/*
 * Decompiled with CFR 0.152.
 */
package smx.tracker.AppsKeystoneSim.SimulatorAPI;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import smx.tracker.AppsKeystoneSim.SimulatorAPI.Constants;
import smx.tracker.AppsKeystoneSim.SimulatorAPI.Nest;
import smx.tracker.AppsKeystoneSim.SimulatorAPI.SimuData;
import smx.tracker.AppsKeystoneSim.SimulatorAPI.TrackerSimInterface;
import smx.tracker.AppsKeystoneSim.SimulatorAPI.Trackers;

public class NestMRDialog
extends JDialog
implements ActionListener {
    private LinkedList nestList;
    private LinkedList trackerList;
    private Nest nest;
    private SimuData simuData;
    private JButton ok;
    private JButton cancel;
    private JButton apply;
    private JLabel[] coordLabel;
    private JTextField[] posDeltaIn;
    private boolean okClick;
    private int flag;
    private int index;
    private int coordinate;
    private double[] position;
    private double[] temp;
    private NumberFormat form = NumberFormat.getNumberInstance();
    private TrackerSimInterface trkKeystoneSim;

    public NestMRDialog(JFrame jFrame, LinkedList linkedList, LinkedList linkedList2, int n, int n2, int n3, SimuData simuData, TrackerSimInterface trackerSimInterface) {
        super(jFrame, Constants.NEST_DIALOG_TITLE[2], true);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        ((Component)this).setLocation(dimension.width / 2, dimension.height / 2);
        ((Component)this).setSize(300, 280);
        this.setResizable(false);
        this.simuData = simuData;
        this.trkKeystoneSim = trackerSimInterface;
        this.posDeltaIn = new JTextField[3];
        this.coordLabel = new JLabel[3];
        this.trackerList = new LinkedList();
        Trackers trackers = new Trackers();
        Trackers trackers2 = new Trackers();
        for (int i = 0; i < linkedList2.size(); ++i) {
            trackers = (Trackers)linkedList2.get(i);
            trackers2 = (Trackers)trackers.clone();
            this.trackerList.add(i, trackers2);
        }
        this.nestList = new LinkedList();
        Nest nest = new Nest();
        Nest nest2 = new Nest();
        for (int i = 0; i < linkedList.size(); ++i) {
            nest = (Nest)linkedList.get(i);
            nest2 = (Nest)nest.clone();
            this.nestList.add(i, nest2);
        }
        this.index = n;
        this.flag = n2;
        this.coordinate = n3;
        this.okClick = false;
        this.temp = new double[3];
        Nest nest3 = (Nest)this.nestList.get(this.index);
        this.nest = (Nest)nest3.clone();
        this.position = this.nest.getPosition();
        this.form.setMaximumFractionDigits(8);
        this.buildMRDialog();
    }

    public boolean isOkClicked() {
        return this.okClick;
    }

    public LinkedList showDialog() {
        this.show();
        return this.nestList;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        double[] dArray = new double[3];
        if (actionEvent.getSource() == this.ok || actionEvent.getSource() == this.apply) {
            double[] dArray2;
            Object object;
            int n;
            for (int i = 0; i < 3; ++i) {
                if (this.posDeltaIn[i].getText().equals("")) {
                    JOptionPane.showConfirmDialog(this, "Please provide nest's complete position", "Error", 2, 0);
                    return;
                }
                dArray[i] = new Double(this.posDeltaIn[i].getText().trim());
                int n2 = i;
                dArray[n2] = dArray[n2] + this.position[i];
            }
            double[] dArray3 = new double[3];
            if (this.coordinate == 1) {
                if (dArray[1] >= -Math.PI && dArray[1] <= 0.0) {
                    dArray = this.simuData.back_to_front(dArray[0], dArray[1], dArray[2]);
                }
                dArray3 = this.simuData.sphere_to_cart(dArray[0], dArray[1], dArray[2]);
            } else {
                dArray3 = dArray;
            }
            for (n = 0; n < this.trackerList.size(); ++n) {
                object = (Trackers)this.trackerList.get(n);
                dArray2 = ((Trackers)object).getPosition();
                if (!(Math.sqrt(Math.pow(dArray3[0] - dArray2[0], 2.0) + Math.pow(dArray3[1] - dArray2[1], 2.0) + Math.pow(dArray3[2] - dArray2[2], 2.0)) <= 0.1)) continue;
                JOptionPane.showConfirmDialog(this, "This nest is too close to a tracker, please enter another position.", "Error", 2, 0);
                return;
            }
            for (n = 0; n < this.nestList.size(); ++n) {
                if (n == this.index) continue;
                object = (Nest)this.nestList.get(n);
                dArray2 = ((Nest)object).getPosition();
                double[] dArray4 = new double[3];
                dArray4 = this.coordinate == 1 ? this.simuData.sphere_to_cart(dArray2[0], dArray2[1], dArray2[2]) : dArray2;
                if (!(Math.sqrt(Math.pow(dArray3[0] - dArray4[0], 2.0) + Math.pow(dArray3[1] - dArray4[1], 2.0) + Math.pow(dArray3[2] - dArray4[2], 2.0)) <= 0.1)) continue;
                JOptionPane.showConfirmDialog(this, "This nest is too close to another nest, please enter another position.", "Error", 2, 0);
                return;
            }
            if (actionEvent.getSource() == this.apply) {
                this.ok.setEnabled(false);
                for (n = 0; n < 3; ++n) {
                    object = this.form.format(dArray[n]);
                    this.coordLabel[n].setText((String)object);
                    this.position = dArray;
                }
            }
            this.nest.setAbsPosition(dArray);
            this.nestList.set(this.index, this.nest);
            this.trkKeystoneSim.setSimPosition(this.coordinate, this.nest);
            this.okClick = true;
            if (actionEvent.getSource() == this.ok) {
                this.dispose();
            }
        } else {
            this.dispose();
        }
    }

    private void buildMRDialog() {
        Object object;
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = new JLabel("Name");
        JLabel jLabel2 = new JLabel(this.nest.getNestName());
        JLabel jLabel3 = new JLabel("X");
        JLabel jLabel4 = new JLabel("Y");
        JLabel jLabel5 = new JLabel("Z");
        JLabel jLabel6 = new JLabel("Azimuth");
        JLabel jLabel7 = new JLabel("Zenith");
        JLabel jLabel8 = new JLabel("Distance");
        JLabel jLabel9 = new JLabel(this.nest.getNestName());
        JLabel jLabel10 = new JLabel("X");
        JLabel jLabel11 = new JLabel("Y");
        JLabel jLabel12 = new JLabel("Z");
        JLabel jLabel13 = new JLabel("Azimuth");
        JLabel jLabel14 = new JLabel("Zenith");
        JLabel jLabel15 = new JLabel("Distance");
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.right = 23;
        gridBagConstraints.insets.top = 5;
        this.add(jLabel, gridBagConstraints, jPanel, 0, 0, 1, 1);
        this.add(jLabel2, gridBagConstraints, jPanel, 1, 0, 1, 1);
        gridBagConstraints.insets.left = 5;
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        Border border = BorderFactory.createEtchedBorder();
        TitledBorder titledBorder = BorderFactory.createTitledBorder(border, "Current");
        jPanel2.setBorder(titledBorder);
        gridBagConstraints2.insets.left = 10;
        gridBagConstraints2.insets.right = 25;
        if (this.coordinate == 0) {
            this.add(jLabel3, gridBagConstraints2, jPanel2, 0, 0, 1, 1);
            this.add(jLabel4, gridBagConstraints2, jPanel2, 0, 1, 1, 1);
            this.add(jLabel5, gridBagConstraints2, jPanel2, 0, 2, 1, 1);
        } else {
            this.add(jLabel6, gridBagConstraints2, jPanel2, 0, 0, 1, 1);
            this.add(jLabel7, gridBagConstraints2, jPanel2, 0, 1, 1, 1);
            this.add(jLabel8, gridBagConstraints2, jPanel2, 0, 2, 1, 1);
        }
        for (int i = 0; i < 3; ++i) {
            object = this.form.format(this.position[i]);
            this.coordLabel[i] = new JLabel((String)object);
            this.add(this.coordLabel[i], gridBagConstraints2, jPanel2, 1, i, 1, 1);
        }
        this.add(jPanel2, gridBagConstraints, jPanel, 0, 1, 3, 3);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(gridBagLayout);
        object = new GridBagConstraints();
        TitledBorder titledBorder2 = BorderFactory.createTitledBorder(border, "Delta");
        jPanel3.setBorder(titledBorder2);
        ((GridBagConstraints)object).insets.left = 10;
        ((GridBagConstraints)object).insets.right = 15;
        if (this.coordinate == 0) {
            this.add(jLabel10, (GridBagConstraints)object, jPanel3, 0, 0, 1, 1);
            this.add(jLabel11, (GridBagConstraints)object, jPanel3, 0, 1, 1, 1);
            this.add(jLabel12, (GridBagConstraints)object, jPanel3, 0, 2, 1, 1);
        } else {
            this.add(jLabel13, (GridBagConstraints)object, jPanel3, 0, 0, 1, 1);
            this.add(jLabel14, (GridBagConstraints)object, jPanel3, 0, 1, 1, 1);
            this.add(jLabel15, (GridBagConstraints)object, jPanel3, 0, 2, 1, 1);
        }
        MyDocumentListener myDocumentListener = new MyDocumentListener();
        for (int i = 0; i < 3; ++i) {
            this.posDeltaIn[i] = new JTextField("0.0", 8);
            this.posDeltaIn[i].getDocument().addDocumentListener(myDocumentListener);
            this.add(this.posDeltaIn[i], (GridBagConstraints)object, jPanel3, 1, i, 1, 1);
        }
        this.add(jPanel3, (GridBagConstraints)object, jPanel, 0, 5, 3, 3);
        this.ok = new JButton("OK");
        this.cancel = new JButton("Cancel");
        this.apply = new JButton("Apply");
        this.ok.addActionListener(this);
        this.cancel.addActionListener(this);
        this.apply.addActionListener(this);
        gridBagConstraints.insets.top = 15;
        gridBagConstraints.insets.bottom = 5;
        gridBagConstraints.insets.right = 10;
        gridBagConstraints.insets.left = 5;
        this.add(this.ok, gridBagConstraints, jPanel, 0, 8, 1, 1);
        this.add(this.cancel, gridBagConstraints, jPanel, 1, 8, 1, 1);
        this.add(this.apply, gridBagConstraints, jPanel, 2, 8, 1, 1);
        this.getContentPane().add(jPanel);
    }

    private void add(Component component, GridBagConstraints gridBagConstraints, JPanel jPanel, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        jPanel.add(component, gridBagConstraints);
    }

    class MyDocumentListener
    implements DocumentListener {
        MyDocumentListener() {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            NestMRDialog.this.ok.setEnabled(true);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            NestMRDialog.this.ok.setEnabled(true);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }
    }
}

