/*
 * Decompiled with CFR 0.152.
 */
package smx.tracker.AppsKeystoneSim.SimulatorAPI;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import smx.tracker.AppsKeystoneSim.SimulatorAPI.MaterialTemp;
import smx.tracker.AppsKeystoneSim.SimulatorAPI.MaterialTempDialog;
import smx.tracker.AppsKeystoneSim.SimulatorAPI.SimuData;
import smx.tracker.AppsKeystoneSim.SimulatorAPI.TrackerSimInterface;
import smx.tracker.AppsKeystoneSim.SimulatorAPI.mainPanel;

public class MaterialTempPanel
extends mainPanel
implements ActionListener {
    private SimuData simuData;
    private MaterialTemp materialTemp;
    private JFrame parent;
    private JButton modify;
    private JLabel tempLabel;
    private JLabel staLabel;
    private TrackerSimInterface trkKeystoneSim;

    public MaterialTempPanel(JFrame jFrame, TrackerSimInterface trackerSimInterface) {
        this.parent = jFrame;
        this.trkKeystoneSim = trackerSimInterface;
        this.simuData = new SimuData();
        this.materialTemp = this.simuData.getMaterialTemp();
        this.buildMaterialPanel();
    }

    public void setSimuData(SimuData simuData) {
        this.simuData = simuData;
        this.materialTemp = this.simuData.getMaterialTemp();
        this.setLabel();
    }

    public SimuData getSimuData() {
        this.simuData.setMaterialTemp(this.materialTemp);
        return this.simuData;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.modify) {
            MaterialTempDialog materialTempDialog = new MaterialTempDialog(this.parent, "Modify Material Temperature", this.materialTemp);
            this.materialTemp = materialTempDialog.showDialog();
            this.trkKeystoneSim.setSimMaterialTempData(this.materialTemp);
            if (materialTempDialog.isOKClicked()) {
                this.setLabel();
                this.setModifiedFlag(true);
            }
        }
    }

    private void setLabel() {
        this.tempLabel.setText(new Double(this.materialTemp.getTemperature()).toString());
        if (this.materialTemp.getStatus() == 0) {
            this.staLabel.setText("OK");
        } else if ((this.materialTemp.getStatus() & 1) / 1 == 1) {
            this.staLabel.setText("Hardware Error");
        } else if ((this.materialTemp.getStatus() & 2) / 2 == 1 || (this.materialTemp.getStatus() & 0x40) / 64 == 1) {
            this.staLabel.setText("Value Problem");
        } else if ((this.materialTemp.getStatus() & 0x200) / 512 == 1 || (this.materialTemp.getStatus() & 0x400) / 1024 == 1) {
            this.staLabel.setText("Supporting Data Problem");
        }
    }

    private void buildMaterialPanel() {
        this.modify = new JButton("Modify");
        this.modify.addActionListener(this);
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = new JLabel("Temperature");
        JLabel jLabel2 = new JLabel("Status");
        this.tempLabel = new JLabel();
        this.staLabel = new JLabel();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.insets.right = 50;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.top = 50;
        this.add(jLabel, gridBagConstraints, jPanel, 0, 0, 1, 1);
        gridBagConstraints.insets.top = 10;
        this.add(jLabel2, gridBagConstraints, jPanel, 0, 2, 1, 1);
        gridBagConstraints.insets.right = 100;
        gridBagConstraints.insets.top = 50;
        this.add(this.tempLabel, gridBagConstraints, jPanel, 1, 0, 1, 1);
        gridBagConstraints.insets.top = 10;
        this.add(this.staLabel, gridBagConstraints, jPanel, 1, 2, 1, 1);
        gridBagConstraints.insets.right = 10;
        this.setLabel();
        this.add(this.modify, gridBagConstraints, jPanel, 2, 1, 1, 1);
        this.add(jPanel);
    }

    private void add(Component component, GridBagConstraints gridBagConstraints, JPanel jPanel, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        jPanel.add(component, gridBagConstraints);
    }
}

