/*
 * Decompiled with CFR 0.152.
 */
package smx.tracker.AppsKeystoneSim.SimulatorAPI;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import smx.tracker.AppsKeystoneSim.SimulatorAPI.MaterialTemp;

public class MaterialTempDialog
extends JDialog
implements ActionListener {
    private MaterialTemp materialTemp;
    private JTextField tempField;
    private JLabel tempLabel;
    private JButton ok;
    private JButton cancel;
    private JCheckBox hwError;
    private JCheckBox inaccValue;
    private JCheckBox manualValue;
    private JCheckBox supdataInacc;
    private JCheckBox supdataError;
    private boolean okClick;
    private int bits;

    public MaterialTempDialog(JFrame jFrame, String string, MaterialTemp materialTemp) {
        super(jFrame, string, true);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        ((Component)this).setSize(300, 260);
        Dimension dimension = toolkit.getScreenSize();
        ((Component)this).setLocation(dimension.width * 1 / 2, dimension.height * 1 / 2);
        this.setResizable(false);
        this.okClick = false;
        this.bits = 0;
        this.materialTemp = (MaterialTemp)materialTemp.clone();
        this.buildInterface();
    }

    public MaterialTemp showDialog() {
        this.show();
        return this.materialTemp;
    }

    public boolean isOKClicked() {
        return this.okClick;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.ok) {
            if (this.tempField.getText().equals("")) {
                JOptionPane.showConfirmDialog(this, "Please provide a temperature.", "Error", 2, 0);
                return;
            }
            this.materialTemp.setTemperature(new Double(this.tempField.getText().trim()));
            this.bits = (this.hwError.isSelected() ? 1 : 0) + (this.inaccValue.isSelected() ? 2 : 0) + (this.manualValue.isSelected() ? 64 : 0) + (this.supdataInacc.isSelected() ? 512 : 0) + (this.supdataError.isSelected() ? 1024 : 0);
            this.materialTemp.setStatus(this.bits);
            this.okClick = true;
            this.dispose();
        } else if (actionEvent.getSource() == this.cancel) {
            this.dispose();
        }
    }

    private void buildInterface() {
        this.tempLabel = new JLabel("Temperature");
        this.tempField = new JTextField(new Double(this.materialTemp.getTemperature()).toString(), 5);
        this.hwError = new JCheckBox("Hardware Error");
        this.inaccValue = new JCheckBox("Value Inaccurate");
        this.manualValue = new JCheckBox("Manual Value");
        this.supdataInacc = new JCheckBox("Supporting Data Inaccurate");
        this.supdataError = new JCheckBox("Supporting Data Error");
        this.hwError.addActionListener(this);
        this.inaccValue.addActionListener(this);
        this.manualValue.addActionListener(this);
        this.supdataInacc.addActionListener(this);
        this.supdataError.addActionListener(this);
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.left = 25;
        this.add(this.tempLabel, gridBagConstraints, jPanel, 0, 0, 1, 1);
        gridBagConstraints.insets.left = 15;
        this.add(this.tempField, gridBagConstraints, jPanel, 1, 0, 1, 1);
        JPanel jPanel2 = new JPanel();
        Border border = BorderFactory.createEtchedBorder();
        TitledBorder titledBorder = BorderFactory.createTitledBorder(border, "Status");
        jPanel2.setBorder(titledBorder);
        Box box = Box.createVerticalBox();
        box.add(this.hwError);
        box.add(this.inaccValue);
        box.add(this.manualValue);
        box.add(this.supdataInacc);
        box.add(this.supdataError);
        if ((this.materialTemp.getStatus() & 1) / 1 == 1) {
            this.hwError.setSelected(true);
        }
        if ((this.materialTemp.getStatus() & 2) / 2 == 1) {
            this.inaccValue.setSelected(true);
        }
        if ((this.materialTemp.getStatus() & 0x40) / 64 == 1) {
            this.manualValue.setSelected(true);
        }
        if ((this.materialTemp.getStatus() & 0x200) / 512 == 1) {
            this.supdataInacc.setSelected(true);
        }
        if ((this.materialTemp.getStatus() & 0x400) / 1024 == 1) {
            this.supdataError.setSelected(true);
        }
        jPanel2.add(box);
        gridBagConstraints.insets.right = 5;
        this.add(jPanel2, gridBagConstraints, jPanel, 0, 3, 2, 6);
        this.ok = new JButton("OK");
        this.cancel = new JButton("Cancel");
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.left = 5;
        this.add(this.ok, gridBagConstraints, jPanel, 0, 10, 1, 1);
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.insets.right = 5;
        this.add(this.cancel, gridBagConstraints, jPanel, 1, 10, 1, 1);
        this.ok.addActionListener(this);
        this.cancel.addActionListener(this);
        this.getContentPane().add(jPanel);
    }

    public void add(Component component, GridBagConstraints gridBagConstraints, JPanel jPanel, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        jPanel.add(component, gridBagConstraints);
    }
}

