/*
 * Decompiled with CFR 0.152.
 */
package smx.tracker.AppsKeystoneSim.SimulatorAPI;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import smx.tracker.AppsKeystoneSim.SimulatorAPI.Constants;
import smx.tracker.AppsKeystoneSim.SimulatorAPI.GeneralDialog;
import smx.tracker.AppsKeystoneSim.SimulatorAPI.MaterialTemp;
import smx.tracker.AppsKeystoneSim.SimulatorAPI.Nest;
import smx.tracker.AppsKeystoneSim.SimulatorAPI.Noise;
import smx.tracker.AppsKeystoneSim.SimulatorAPI.SimuData;
import smx.tracker.AppsKeystoneSim.SimulatorAPI.Target;
import smx.tracker.AppsKeystoneSim.SimulatorAPI.TrackerSimInterface;
import smx.tracker.AppsKeystoneSim.SimulatorAPI.Trackers;
import smx.tracker.AppsKeystoneSim.SimulatorAPI.mainPanel;

public class GeneralPanel
extends mainPanel
implements ActionListener {
    private SimuData simuData;
    private LinkedList trackerList;
    private LinkedList nestList;
    private LinkedList targetList;
    private MaterialTemp materialTemp;
    private Noise noise;
    private int coordinate;
    private JFrame parent;
    private JButton save;
    private JButton saveAs;
    private JButton open;
    private JButton modify;
    private JRadioButton cartesian;
    private JRadioButton spherical;
    private JLabel fileName;
    private JLabel fileStatus;
    private JLabel ANLabel;
    private JLabel RNLabel;
    private JLabel TrNLabel;
    private JLabel TeNLabel;
    private JFileChooser chooser;
    private String dataFile;
    private TrackerSimInterface trkKeystoneSim;

    public GeneralPanel(JFrame jFrame, TrackerSimInterface trackerSimInterface) {
        this.setLayout(new BorderLayout());
        this.parent = jFrame;
        this.trkKeystoneSim = trackerSimInterface;
        this.chooser = this.formatStream();
        this.dataFile = "";
        this.simuData = new SimuData();
        this.trackerList = new LinkedList();
        this.nestList = new LinkedList();
        this.targetList = new LinkedList();
        this.noise = new Noise();
        this.materialTemp = new MaterialTemp();
        this.coordinate = this.simuData.getCoord();
        this.buildGeneralPanel();
    }

    public void setSimuData(SimuData simuData) {
        this.simuData = simuData;
        this.trackerList = simuData.getTrackerList();
        this.nestList = simuData.getNestList();
        this.targetList = simuData.getTargetList();
        this.materialTemp = simuData.getMaterialTemp();
        this.noise = this.simuData.getNoise();
        this.coordinate = this.simuData.getCoord();
        if (this.getModifiedFlag()) {
            this.fileStatus.setText("Modified");
        }
    }

    public SimuData getSimuData() {
        this.simuData.setTrackerList(this.trackerList);
        this.simuData.setNestList(this.nestList);
        this.simuData.setTargetList(this.targetList);
        this.simuData.setMaterialTemp(this.materialTemp);
        this.simuData.setNoise(this.noise);
        this.simuData.setCoord(this.coordinate);
        if (this.trackerList.size() != 0) {
            this.simuData.setTracker((Trackers)this.trackerList.getFirst());
        }
        return this.simuData;
    }

    private JFileChooser formatStream() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setCurrentDirectory(new File("."));
        jFileChooser.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                return file.getName().toLowerCase().endsWith(".dat") || file.isDirectory();
            }

            public String getDescription() {
                return "Tracker Simulation Data (.dat)";
            }
        });
        jFileChooser.setMultiSelectionEnabled(false);
        return jFileChooser;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.open) {
            this.chooser.setDialogTitle("Open");
            this.chooser.rescanCurrentDirectory();
            if (this.chooser.showOpenDialog(this.parent) == 0) {
                this.dataFile = this.chooser.getSelectedFile().getName();
                this.fileName.setText(this.dataFile);
                this.fileStatus.setText("Original");
                this.loadData(this.dataFile);
                this.setRadioButton();
                this.setLabel();
                this.setModifiedFlag(true);
            }
        } else if (object == this.saveAs) {
            this.chooser.setDialogTitle("Save as");
            this.chooser.rescanCurrentDirectory();
            if (this.chooser.showSaveDialog(this.parent) == 0) {
                this.dataFile = this.chooser.getSelectedFile().getName();
                this.fileName.setText(this.dataFile);
                this.fileStatus.setText("Original");
                this.simuData.setNoise(this.noise);
                this.simuData.setCoord(this.coordinate);
                this.saveData();
            }
        } else if (object == this.save) {
            this.simuData.setNoise(this.noise);
            this.simuData.setCoord(this.coordinate);
            this.saveData();
        } else if (object == this.modify) {
            GeneralDialog generalDialog = new GeneralDialog(this.parent, "Modify Noise Level", this.noise);
            this.noise = generalDialog.showDialog();
            this.trkKeystoneSim.setSimNoiseData(this.noise);
            if (generalDialog.isOKClicked()) {
                this.setLabel();
                this.fileStatus.setText("Modified");
                this.setModifiedFlag(true);
            } else {
                this.setModifiedFlag(false);
            }
        } else if (object == this.cartesian) {
            if (this.coordinate == 1) {
                this.fileStatus.setText("Modified");
            }
            this.coordinate = 0;
            for (int i = 0; i < this.nestList.size(); ++i) {
                double[] dArray = new double[3];
                double[] dArray2 = new double[3];
                Nest nest = (Nest)this.nestList.get(i);
                dArray2 = nest.getPosition();
                dArray = this.simuData.sphere_to_cart(dArray2[0], dArray2[1], dArray2[2]);
                nest.setAbsPosition(dArray);
            }
            this.setModifiedFlag(true);
            this.trkKeystoneSim.setSimCoordinate(0);
        } else {
            if (this.coordinate == 0) {
                this.fileStatus.setText("Modified");
            }
            this.coordinate = 1;
            for (int i = 0; i < this.nestList.size(); ++i) {
                double[] dArray = new double[3];
                double[] dArray3 = new double[3];
                Nest nest = (Nest)this.nestList.get(i);
                dArray3 = nest.getPosition();
                dArray = this.simuData.cart_to_sphere(dArray3[0], dArray3[1], dArray3[2]);
                nest.setAbsPosition(dArray);
            }
            this.setModifiedFlag(true);
            this.trkKeystoneSim.setSimCoordinate(1);
        }
    }

    private void loadData(String string) {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        LinkedList<Object> linkedList2 = new LinkedList<Object>();
        LinkedList<Object> linkedList3 = new LinkedList<Object>();
        try {
            Object object;
            Object object2;
            int n;
            Object object3;
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            while ((string2 = bufferedReader.readLine()) != null) {
                double[] dArray;
                Object object4;
                String string3 = "";
                String string4 = "";
                int n2 = string2.indexOf(59);
                object3 = n2 != -1 ? string2.substring(0, n2) : string2;
                if (((String)object3).trim().equals("")) continue;
                n = ((String)object3).indexOf(34, 0);
                if (n != -1 && (n2 = ((String)object3).indexOf(34, n + 1)) != -1) {
                    string3 = ((String)object3).substring(n + 1, n2);
                    object2 = ((String)object3).substring(0, n) + ((String)object3).substring(n2 + 1);
                } else {
                    object2 = object3;
                }
                n = ((String)object2).indexOf(34, 0);
                if (n != -1 && (n2 = ((String)object2).indexOf(34, n + 1)) != -1) {
                    string4 = ((String)object2).substring(n + 1, n2);
                    object = ((String)object2).substring(0, n) + ((String)object2).substring(n2 + 1);
                } else {
                    object = object2;
                }
                StringTokenizer stringTokenizer = new StringTokenizer((String)object, " \t\n\r");
                String string5 = stringTokenizer.nextToken();
                if (string5.equals("TRACKER")) {
                    int n3;
                    object4 = new Trackers();
                    ((Trackers)object4).setName(string3);
                    ((Trackers)object4).setIPAddress(stringTokenizer.nextToken());
                    if (string4 != null) {
                        ((Trackers)object4).setClassmate(string4);
                    }
                    dArray = new double[3];
                    double[] dArray2 = new double[3];
                    for (n3 = 0; n3 < 3; ++n3) {
                        dArray[n3] = new Double(stringTokenizer.nextToken());
                    }
                    for (n3 = 0; n3 < 3; ++n3) {
                        dArray2[n3] = new Double(stringTokenizer.nextToken());
                    }
                    ((Trackers)object4).setAbsPosition(dArray, dArray2);
                    linkedList.add(object4);
                    continue;
                }
                if (string5.equals("NEST")) {
                    object4 = new Nest();
                    ((Nest)object4).setNestName(string3);
                    if (string4 != null) {
                        ((Nest)object4).setClassmateName(string4);
                    }
                    dArray = new double[3];
                    for (int i = 0; i < 3; ++i) {
                        dArray[i] = new Double(stringTokenizer.nextToken());
                    }
                    ((Nest)object4).setAbsPosition(dArray);
                    linkedList2.add(object4);
                    continue;
                }
                if (string5.equals("TARGET")) {
                    object4 = new Target();
                    ((Target)object4).setTargetName(string3);
                    ((Target)object4).setClassmate(string4);
                    if (stringTokenizer.nextToken().equals("YES")) {
                        ((Target)object4).setTargetStatus("Blocked");
                    } else {
                        ((Target)object4).setTargetStatus("");
                    }
                    linkedList3.add(object4);
                    continue;
                }
                if (string5.equals("MATERIAL_TEMP")) {
                    this.materialTemp.setTemperature(new Double(stringTokenizer.nextToken()));
                    this.materialTemp.setStatus(new Integer(stringTokenizer.nextToken()));
                    continue;
                }
                if (string5.equals("NOISE")) {
                    object4 = new double[4];
                    while (stringTokenizer.countTokens() != 0) {
                        for (int i = 0; i < 4; ++i) {
                            object4[i] = new Double(stringTokenizer.nextToken());
                        }
                    }
                    this.noise.setNoise((double[])object4);
                    continue;
                }
                if (!string5.equals("COORDINATE_SYSTEM_TYPE") || stringTokenizer.countTokens() == 0) continue;
                this.coordinate = new Integer(stringTokenizer.nextToken());
                if (this.coordinate >= 0 && this.coordinate <= 1) continue;
                this.coordinate = 0;
            }
            bufferedReader.close();
            this.trackerList = linkedList;
            this.nestList = linkedList2;
            this.targetList = linkedList3;
            for (n = 0; n < this.trackerList.size(); ++n) {
                Trackers trackers = (Trackers)this.trackerList.get(n);
                object3 = new Nest();
                if (!trackers.getClassmate().equals("")) {
                    ((Nest)object3).setClassmateName(trackers.getClassmate());
                }
                ((Nest)object3).setNestName("TMR_" + trackers.getName());
                object2 = Constants.TMR_LOCATION;
                object2 = this.simuData.coordTransfer((double[])object2, trackers.getPosition(), trackers.getRotation());
                if (this.coordinate == 0) {
                    object2 = this.simuData.sphere_to_cart((double)object2[0], (double)object2[1], (double)object2[2]);
                }
                ((Nest)object3).setAbsPosition((double[])object2);
                this.nestList.add(object3);
                object = new Target();
                if (trackers.getClassmate().equals("")) continue;
                ((Target)object).setTargetName(trackers.getClassmate());
                ((Target)object).setClassmate("TMR_" + trackers.getName());
                this.targetList.add(object);
            }
            if (this.trackerList.size() == 0) {
                Trackers trackers = new Trackers();
                trackers.setIPAddress("128.128.128.100");
                trackers.setName("DefaultTracker");
                this.trackerList.add(trackers);
                Nest nest = new Nest();
                nest.setNestName("TMR_DefaultTracker");
                object3 = Constants.TMR_LOCATION;
                object3 = this.simuData.coordTransfer((double[])object3, trackers.getPosition(), trackers.getRotation());
                if (this.coordinate == 0) {
                    object3 = this.simuData.sphere_to_cart((double)object3[0], (double)object3[1], (double)object3[2]);
                }
                nest.setAbsPosition((double[])object3);
                this.nestList.add(nest);
            }
        }
        catch (IOException iOException) {
            Trackers trackers = new Trackers();
            trackers.setIPAddress("128.128.128.100");
            trackers.setName("DefaultTracker");
            this.trackerList.add(trackers);
            Nest nest = new Nest();
            nest.setNestName("TMR_DefaultTracker");
            double[] dArray = Constants.TMR_LOCATION;
            dArray = this.simuData.coordTransfer(dArray, trackers.getPosition(), trackers.getRotation());
            dArray = this.simuData.sphere_to_cart(dArray[0], dArray[1], dArray[2]);
            nest.setAbsPosition(dArray);
            this.nestList.add(nest);
        }
        catch (NoSuchElementException noSuchElementException) {
            JOptionPane.showMessageDialog(this.parent, string + " " + "File corruption", "ERROR", 0);
        }
    }

    private void saveData() {
        try {
            int n;
            double[] dArray;
            Cloneable cloneable;
            int n2;
            PrintWriter printWriter = new PrintWriter((Writer)new FileWriter(this.dataFile), true);
            printWriter.println(";tracker information");
            for (n2 = 0; n2 < this.trackerList.size(); ++n2) {
                cloneable = (Trackers)this.trackerList.get(n2);
                printWriter.print("TRACKER \"" + ((Trackers)cloneable).getName() + "\" " + ((Trackers)cloneable).getIPAddress() + " ");
                dArray = ((Trackers)cloneable).getPosition();
                for (n = 0; n < 3; ++n) {
                    printWriter.print(new Double(dArray[n]).toString() + " ");
                }
                dArray = ((Trackers)cloneable).getRotation();
                for (n = 0; n < 3; ++n) {
                    printWriter.print(new Double(dArray[n]).toString() + " ");
                }
                if (!((Trackers)cloneable).getClassmate().equals("")) {
                    printWriter.print("\"" + ((Trackers)cloneable).getClassmate() + "\"");
                }
                printWriter.println("");
            }
            printWriter.println(";nest information");
            for (n2 = 0; n2 < this.nestList.size(); ++n2) {
                cloneable = (Nest)this.nestList.get(n2);
                if (((Nest)cloneable).getNestName().substring(0, 4).equals("TMR_")) continue;
                printWriter.print("NEST \"" + ((Nest)cloneable).getNestName() + "\" ");
                dArray = ((Nest)cloneable).getPosition();
                for (n = 0; n < 3; ++n) {
                    printWriter.print(new Double(dArray[n]).toString() + " ");
                }
                if (((Nest)cloneable).getClassmateName() != "") {
                    printWriter.print("\"" + ((Nest)cloneable).getClassmateName() + "\"");
                }
                printWriter.println("");
            }
            printWriter.println(";target information");
            for (n2 = 0; n2 < this.targetList.size(); ++n2) {
                cloneable = (Target)this.targetList.get(n2);
                if (!((Target)cloneable).getClassmate().equals("") && ((Target)cloneable).getClassmate().substring(0, 4).equals("TMR_")) continue;
                printWriter.print("TARGET \"" + ((Target)cloneable).getTargetName() + "\" " + "\"" + ((Target)cloneable).getClassmate() + "\"" + " ");
                if (((Target)cloneable).getTargetStatus().equals("")) {
                    printWriter.print("NO");
                } else {
                    printWriter.print("YES");
                }
                printWriter.println("");
            }
            printWriter.println(";material temperature");
            printWriter.print("MATERIAL_TEMP " + this.materialTemp.getTemperature() + " " + this.materialTemp.getStatus());
            printWriter.println("");
            printWriter.println(";noise");
            printWriter.print("NOISE ");
            double[] dArray2 = this.simuData.getNoise().getNoise();
            for (int i = 0; i < 4; ++i) {
                printWriter.print(new Double(dArray2[i]).toString() + " ");
            }
            printWriter.println("");
            printWriter.println(";coordinate system");
            printWriter.print("COORDINATE_SYSTEM_TYPE " + this.simuData.getCoord());
            printWriter.println("");
            printWriter.close();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this.parent, iOException.getMessage(), "Error", 0);
        }
    }

    private void setLabel() {
        this.ANLabel.setText(new Double(this.noise.getNoise()[0]).toString());
        this.RNLabel.setText(new Double(this.noise.getNoise()[1]).toString());
        this.TrNLabel.setText(new Double(this.noise.getNoise()[2]).toString());
        this.TeNLabel.setText(new Double(this.noise.getNoise()[3]).toString());
    }

    private void setRadioButton() {
        if (this.coordinate == 0) {
            this.cartesian.setSelected(true);
            this.spherical.setSelected(false);
        } else if (this.coordinate == 1) {
            this.cartesian.setSelected(false);
            this.spherical.setSelected(true);
        }
    }

    private JRadioButton addRadioButton(JPanel jPanel, ButtonGroup buttonGroup, String string, boolean bl) {
        JRadioButton jRadioButton = new JRadioButton(string, bl);
        jRadioButton.addActionListener(this);
        buttonGroup.add(jRadioButton);
        jPanel.add(jRadioButton);
        return jRadioButton;
    }

    private void add(Component component, GridBagConstraints gridBagConstraints, JPanel jPanel, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        jPanel.add(component, gridBagConstraints);
    }

    private void buildGeneralPanel() {
        this.save = new JButton("Save");
        this.saveAs = new JButton("Save As...");
        this.open = new JButton("Open...");
        this.modify = new JButton("Modify...");
        this.save.addActionListener(this);
        this.saveAs.addActionListener(this);
        this.open.addActionListener(this);
        this.modify.addActionListener(this);
        this.fileName = new JLabel("None");
        this.fileStatus = new JLabel("Unknown");
        JPanel jPanel = new JPanel();
        ButtonGroup buttonGroup = new ButtonGroup();
        this.cartesian = this.addRadioButton(jPanel, buttonGroup, "Cartesian", false);
        this.spherical = this.addRadioButton(jPanel, buttonGroup, "Spherical", false);
        Border border = BorderFactory.createEtchedBorder();
        TitledBorder titledBorder = BorderFactory.createTitledBorder(border, "Coordinate System");
        jPanel.setBorder(titledBorder);
        this.add((Component)jPanel, "South");
        JPanel jPanel2 = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel2.setLayout(gridBagLayout);
        TitledBorder titledBorder2 = BorderFactory.createTitledBorder(border, "Noise Parameter");
        JLabel jLabel = new JLabel("Max. Angular Noise");
        JLabel jLabel2 = new JLabel("Max. Radial Noise");
        JLabel jLabel3 = new JLabel("Max. Transverse Noise");
        JLabel jLabel4 = new JLabel("Max. Temperature Noise");
        this.ANLabel = new JLabel();
        this.RNLabel = new JLabel();
        this.TrNLabel = new JLabel();
        this.TeNLabel = new JLabel();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.insets.right = 45;
        gridBagConstraints.insets.left = 30;
        gridBagConstraints.insets.bottom = 3;
        this.add(jLabel, gridBagConstraints, jPanel2, 0, 0, 1, 1);
        this.add(jLabel2, gridBagConstraints, jPanel2, 0, 1, 1, 1);
        this.add(jLabel3, gridBagConstraints, jPanel2, 0, 2, 1, 1);
        this.add(jLabel4, gridBagConstraints, jPanel2, 0, 3, 1, 1);
        this.add(this.ANLabel, gridBagConstraints, jPanel2, 1, 0, 2, 1);
        this.add(this.RNLabel, gridBagConstraints, jPanel2, 1, 1, 2, 1);
        this.add(this.TrNLabel, gridBagConstraints, jPanel2, 1, 2, 2, 1);
        this.add(this.TeNLabel, gridBagConstraints, jPanel2, 1, 3, 2, 1);
        this.setLabel();
        gridBagConstraints.insets.bottom = 2;
        gridBagConstraints.insets.right = 5;
        this.add(this.modify, gridBagConstraints, jPanel2, 3, 4, 1, 1);
        jPanel2.setBorder(titledBorder2);
        this.add((Component)jPanel2, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(gridBagLayout);
        TitledBorder titledBorder3 = BorderFactory.createTitledBorder(border, "File operation");
        JLabel jLabel5 = new JLabel("Current Model File");
        JButton[] jButtonArray = new JButton[3];
        this.add(jLabel5, gridBagConstraints, jPanel3, 0, 0, 1, 1);
        this.add(this.fileName, gridBagConstraints, jPanel3, 1, 0, 1, 1);
        this.add(this.fileStatus, gridBagConstraints, jPanel3, 2, 0, 1, 1);
        gridBagConstraints.insets.left = 40;
        gridBagConstraints.insets.right = 45;
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.bottom = 5;
        this.add(this.save, gridBagConstraints, jPanel3, 0, 1, 1, 1);
        this.add(this.saveAs, gridBagConstraints, jPanel3, 1, 1, 1, 1);
        this.add(this.open, gridBagConstraints, jPanel3, 2, 1, 1, 1);
        jPanel3.setBorder(titledBorder3);
        this.add((Component)jPanel3, "North");
        this.loadData("temp.dat");
        this.fileName.setText("temp.dat");
        this.fileStatus.setText("Original");
        this.setRadioButton();
        this.setLabel();
        this.setModifiedFlag(true);
    }
}

