/*
 * Decompiled with CFR 0.152.
 */
package com.inzoom.winreg;

import com.inzoom.util.EnumToString;
import com.inzoom.winreg.Dll;
import com.inzoom.winreg.WinRegException;

public class RegKey {
    RegKey parent;
    int hkey;
    String name;
    static /* synthetic */ Class class$com$inzoom$winreg$enums$HKey;
    static /* synthetic */ Class class$com$inzoom$winreg$enums$KeyType;

    public RegKey(int n) {
        if (!EnumToString.hasValue(class$com$inzoom$winreg$enums$HKey == null ? (class$com$inzoom$winreg$enums$HKey = RegKey.class$("com.inzoom.winreg.enums.HKey")) : class$com$inzoom$winreg$enums$HKey, n)) {
            throw new IllegalArgumentException("arg must be one of the predefined constants in com.inzoom.winreg.enums.HKey");
        }
        this.hkey = n;
        this.parent = null;
        this.name = null;
    }

    public RegKey getParent() {
        return this.parent;
    }

    public RegKey getRoot() {
        return this.parent == null ? this : this.parent.getRoot();
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public void close() throws WinRegException {
        if (!this.isRoot() && this.hkey != 0) {
            RegKey.jniClose(this.hkey);
        }
        this.hkey = 0;
    }

    public void finalize() {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public RegKey openKey(String string, boolean bl) throws WinRegException {
        return this.openKey(string, bl, 983103);
    }

    public RegKey openKey(String string, boolean bl, int n) throws WinRegException {
        return new RegKey(string, RegKey.jniOpen(this.hkey, string, bl, n), this);
    }

    public boolean hasKey(String string) throws WinRegException {
        return RegKey.jniHasKey(this.hkey, string);
    }

    public void deleteKey(String string) throws WinRegException {
        RegKey.jniDeleteKey(this.hkey, string);
    }

    public int getKeyCount() throws WinRegException {
        return RegKey.jniGetKeyCount(this.hkey);
    }

    public String getKeyName(int n) throws WinRegException {
        return RegKey.jniGetKeyName(this.hkey, n);
    }

    public int getValueCount() throws WinRegException {
        return RegKey.jniGetValueCount(this.hkey);
    }

    public ValueInfo getValueInfo() throws WinRegException {
        return this.getValueInfo(null);
    }

    public ValueInfo getValueInfo(String string) throws WinRegException {
        int[] nArray = new int[1];
        Object object = RegKey.jniGetValueS(this.hkey, string, nArray);
        return new ValueInfo(string, object, nArray[0]);
    }

    public ValueInfo getValueInfo(int n) throws WinRegException {
        int[] nArray = new int[1];
        String[] stringArray = new String[1];
        Object object = RegKey.jniGetValueI(this.hkey, n, stringArray, nArray);
        return new ValueInfo(stringArray[0], object, nArray[0]);
    }

    public Object getValue() throws WinRegException {
        return this.getValue(null);
    }

    public Object getValue(String string) throws WinRegException {
        return RegKey.jniGetValueS(this.hkey, string, null);
    }

    public void setValue(Object object) throws WinRegException {
        this.setValue(null, object);
    }

    public void setValue(Object object, int n) throws WinRegException {
        this.setValue(null, object, n);
    }

    public void setValue(String string, Object object) throws WinRegException {
        this.setValue(string, object, RegKey.getObjType(object));
    }

    public void setValue(String string, Object object, int n) throws WinRegException {
        RegKey.jniSetValue(this.hkey, string, object, n);
    }

    public boolean hasValue(String string) throws WinRegException {
        return RegKey.jniHasValue(this.hkey, string);
    }

    public void deleteValue(String string) throws WinRegException {
        RegKey.jniDeleteValue(this.hkey, string);
    }

    public String getName() {
        if (this.isRoot()) {
            return "HKEY_" + EnumToString.toString(class$com$inzoom$winreg$enums$HKey == null ? (class$com$inzoom$winreg$enums$HKey = RegKey.class$("com.inzoom.winreg.enums.HKey")) : class$com$inzoom$winreg$enums$HKey, this.hkey, false, false);
        }
        int n = this.name.lastIndexOf(92);
        if (n > 0) {
            return this.name.substring(n + 1);
        }
        return this.name;
    }

    public String getFullName() {
        return this.isRoot() ? this.getName() : this.getParent().getFullName() + '\\' + this.name;
    }

    private static char[] intToHex(int n) {
        char[] cArray = new char[8];
        for (int i = 0; i < 8; ++i) {
            cArray[7 - i] = RegKey.hexToChar((char)(n >> 4 * i & 0xF));
        }
        return cArray;
    }

    private static char hexToChar(char c) {
        return c < '\n' ? (char)(c + 48) : (char)(c - 10 + 65);
    }

    private static char[] byteToHex(byte by) {
        char[] cArray = new char[2];
        for (int i = 0; i < 2; ++i) {
            cArray[1 - i] = RegKey.hexToChar((char)(by >> 4 * i & 0xF));
        }
        return cArray;
    }

    public static int getObjType(Object object) {
        if (object == null) {
            return 0;
        }
        if (object instanceof Integer) {
            return 4;
        }
        if (object instanceof String) {
            return 1;
        }
        if (object instanceof String[]) {
            return 7;
        }
        if (object instanceof byte[]) {
            return 3;
        }
        throw new IllegalArgumentException("Object type can't be automatically mapped to Registry type");
    }

    RegKey(String string, int n, RegKey regKey) {
        this.name = string;
        this.hkey = n;
        this.parent = regKey;
    }

    private static native void jniClose(int var0) throws WinRegException;

    private static native int jniOpen(int var0, String var1, boolean var2, int var3) throws WinRegException;

    private static native Object jniGetValueS(int var0, String var1, int[] var2) throws WinRegException;

    private static native Object jniGetValueI(int var0, int var1, String[] var2, int[] var3) throws WinRegException;

    private static native int jniGetValueCount(int var0) throws WinRegException;

    private static native void jniSetValue(int var0, String var1, Object var2, int var3) throws WinRegException;

    private static native void jniDeleteValue(int var0, String var1) throws WinRegException;

    private static native boolean jniHasValue(int var0, String var1) throws WinRegException;

    private static native boolean jniHasKey(int var0, String var1) throws WinRegException;

    private static native void jniDeleteKey(int var0, String var1) throws WinRegException;

    private static native int jniGetKeyCount(int var0) throws WinRegException;

    private static native String jniGetKeyName(int var0, int var1) throws WinRegException;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Dll.start();
    }

    public static class ValueInfo {
        public final String name;
        public final Object value;
        public final int type;

        ValueInfo(String string, Object object, int n) {
            this.name = string;
            this.value = object;
            this.type = n;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('\"');
            stringBuffer.append(this.name);
            stringBuffer.append('\"');
            stringBuffer.append("=");
            switch (this.type) {
                case 1: {
                    stringBuffer.append('\"');
                    stringBuffer.append(this.value);
                    stringBuffer.append('\"');
                    break;
                }
                case 4: {
                    stringBuffer.append("dword:");
                    stringBuffer.append(RegKey.intToHex((Integer)this.value));
                    break;
                }
                case 3: {
                    stringBuffer.append("hex:");
                    for (int i = 0; i < ((byte[])this.value).length; ++i) {
                        if (i > 0) {
                            stringBuffer.append(',');
                        }
                        stringBuffer.append(RegKey.byteToHex(((byte[])this.value)[i]));
                    }
                    break;
                }
                default: {
                    stringBuffer.append('(');
                    stringBuffer.append(EnumToString.toString(class$com$inzoom$winreg$enums$KeyType == null ? (class$com$inzoom$winreg$enums$KeyType = RegKey.class$("com.inzoom.winreg.enums.KeyType")) : class$com$inzoom$winreg$enums$KeyType, this.type));
                    stringBuffer.append(')');
                    stringBuffer.append(':');
                    stringBuffer.append(this.value);
                }
            }
            return stringBuffer.toString();
        }
    }
}

