/*
 * Decompiled with CFR 0.152.
 */
package com.inzoom.win;

import com.inzoom.win.NativeSurfaceHelper;
import com.inzoom.win.SurfaceInfo;
import java.applet.Applet;
import java.awt.Component;
import java.awt.Point;
import java.awt.Window;
import java.awt.peer.ComponentPeer;
import java.lang.reflect.Method;

public class Util {
    static Method sun_awt_DrawingSurface_getDrawingSurfaceInfo;
    static Method sun_awt_DrawingSurfaceInfo_lock;
    static Method sun_awt_DrawingSurfaceInfo_unlock;
    static Method sun_awt_DrawingSurfaceInfo_getSurface;
    static Method sun_awt_Win32DrawingSurface_getHWND;
    static boolean bJavaAccessHWND;
    static boolean bInitialized;

    static void init() {
        bInitialized = true;
        try {
            Class<?> clazz = Class.forName("sun.awt.DrawingSurfaceInfo");
            Class<?> clazz2 = Class.forName("sun.awt.Win32DrawingSurface");
            Class<?> clazz3 = Class.forName("sun.awt.DrawingSurface");
            sun_awt_DrawingSurface_getDrawingSurfaceInfo = clazz3.getDeclaredMethod("getDrawingSurfaceInfo", null);
            sun_awt_DrawingSurfaceInfo_lock = clazz.getMethod("lock", null);
            sun_awt_DrawingSurfaceInfo_unlock = clazz.getMethod("unlock", null);
            sun_awt_DrawingSurfaceInfo_getSurface = clazz.getMethod("getSurface", null);
            sun_awt_Win32DrawingSurface_getHWND = clazz2.getMethod("getHWnd", null);
            bJavaAccessHWND = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!bJavaAccessHWND) {
            System.loadLibrary("jawt");
        }
    }

    public static int getHWND(Component component) {
        return Util.getSurfaceInfo(component).getHWND();
    }

    public static int getJHWND(Component component) {
        return Util.getJSurfaceInfo(component).getHWND();
    }

    static int getHWNDFromSurface(Component component) {
        int n = 0;
        if (component == null) {
            throw new IllegalArgumentException();
        }
        if (!bInitialized) {
            Util.init();
        }
        if (bJavaAccessHWND) {
            ComponentPeer componentPeer = component.getPeer();
            if (componentPeer != null) {
                try {
                    Object object = sun_awt_DrawingSurface_getDrawingSurfaceInfo.invoke((Object)componentPeer, null);
                    if (null != object) {
                        sun_awt_DrawingSurfaceInfo_lock.invoke(object, null);
                        Object object2 = sun_awt_DrawingSurfaceInfo_getSurface.invoke(object, null);
                        n = (Integer)sun_awt_Win32DrawingSurface_getHWND.invoke(object2, null);
                        sun_awt_DrawingSurfaceInfo_unlock.invoke(object, null);
                    }
                }
                catch (Exception exception) {}
            }
        } else {
            try {
                n = NativeSurfaceHelper.getHWND(component);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n;
    }

    public static SurfaceInfo getJSurfaceInfoLight(Component component) {
        return Util.getJSurfaceInfoImpl(component, true);
    }

    static SurfaceInfoImpl getJSurfaceInfoImpl(Component component, boolean bl) {
        if (component == null) {
            throw new IllegalArgumentException();
        }
        SurfaceInfoImpl surfaceInfoImpl = new SurfaceInfoImpl();
        Point point = new Point();
        if (!bJavaAccessHWND) {
            while (!(component instanceof Window) && !(component instanceof Applet) && (component = component.getParent()) != null) {
                surfaceInfoImpl.addOffset(point);
                point = component.getLocation();
            }
            if (component == null) {
                throw new IllegalArgumentException("No DrawingSurface found");
            }
            if (!bl) {
                surfaceInfoImpl.m_HWND = NativeSurfaceHelper.getHWND(component);
            }
        } else {
            while ((surfaceInfoImpl.m_HWND = Util.getHWNDFromSurface(component)) == 0 && (component = component.getParent()) != null) {
                surfaceInfoImpl.addOffset(point);
                point = component.getLocation();
            }
            if (component == null) {
                throw new IllegalArgumentException("No DrawingSurface found");
            }
        }
        return surfaceInfoImpl;
    }

    public static SurfaceInfo getJSurfaceInfo(Component component) {
        return Util.getJSurfaceInfoImpl(component, false);
    }

    public static SurfaceInfo getSurfaceInfo(Component component) {
        if (component == null) {
            throw new IllegalArgumentException();
        }
        SurfaceInfoImpl surfaceInfoImpl = new SurfaceInfoImpl();
        Component component2 = component;
        Point point = new Point();
        while ((surfaceInfoImpl.m_HWND = Util.getHWNDFromSurface(component2)) == 0 && (component2 = component2.getParent()) != null) {
            surfaceInfoImpl.addOffset(point);
            point = component2.getLocation();
        }
        if (component2 == null) {
            throw new IllegalArgumentException("No DrawingSurface found");
        }
        return surfaceInfoImpl;
    }

    public static int getFocusOwnerHWND() {
        return NativeSurfaceHelper.getFocusOwnerHWND();
    }

    public static boolean isChild(int n, int n2) {
        return NativeSurfaceHelper.isChildHWND(n, n2);
    }

    static {
        bJavaAccessHWND = false;
        bInitialized = false;
        Util.init();
    }

    static class SurfaceInfoImpl
    implements SurfaceInfo {
        int m_HWND = 0;
        Point p = new Point(0, 0);

        SurfaceInfoImpl() {
        }

        public int getHWND() {
            return this.m_HWND;
        }

        public int getOffsetX() {
            return this.p.x;
        }

        public int getOffsetY() {
            return this.p.y;
        }

        void addOffset(Point point) {
            this.p.x += point.x;
            this.p.y += point.y;
        }
    }
}

