/*
 * Decompiled with CFR 0.152.
 */
package com.inzoom.util;

import java.io.PrintStream;
import java.io.Serializable;
import java.util.Vector;

public abstract class Map
implements Cloneable,
Serializable {
    protected Vector v = new Vector();

    public int size() {
        return this.v.size();
    }

    public synchronized void clear() {
        this.v.clear();
    }

    public abstract int compare(Object var1, Object var2);

    public synchronized void put(Object object, Object object2) {
        int n = 0;
        int n2 = this.size() - 1;
        int n3 = 0;
        while (n <= n2) {
            n3 = n + n2 >> 1;
            Entry entry = this.entryAt(n3);
            int n4 = this.compare(object, entry.getKey());
            if (n4 < 0) {
                n2 = n3 - 1;
                continue;
            }
            if (n4 > 0) {
                n = n3 + 1;
                continue;
            }
            if (object2 == null) {
                this.v.removeElementAt(n3);
            } else {
                entry.setValue(object2);
            }
            return;
        }
        if (object2 == null) {
            return;
        }
        if (n == this.size()) {
            this.v.addElement(new Entry(object, object2));
        } else {
            this.v.insertElementAt(new Entry(object, object2), n);
        }
    }

    public Entry entryAt(int n) {
        return (Entry)this.v.elementAt(n);
    }

    public synchronized Object get(Object object) {
        int n = 0;
        int n2 = this.size() - 1;
        int n3 = 0;
        while (n <= n2) {
            n3 = n + n2 >> 1;
            Entry entry = this.entryAt(n3);
            int n4 = this.compare(object, entry.getKey());
            if (n4 < 0) {
                n2 = n3 - 1;
                continue;
            }
            if (n4 > 0) {
                n = n3 + 1;
                continue;
            }
            return entry.getValue();
        }
        return null;
    }

    public synchronized EntryInfo getInfo(Object object) {
        int n = 0;
        int n2 = this.size() - 1;
        int n3 = 0;
        while (n <= n2) {
            n3 = n + n2 >> 1;
            Entry entry = this.entryAt(n3);
            int n4 = this.compare(object, entry.getKey());
            if (n4 < 0) {
                n2 = n3 - 1;
                continue;
            }
            if (n4 > 0) {
                n = n3 + 1;
                continue;
            }
            return new EntryInfo(entry, n3);
        }
        return null;
    }

    public synchronized EntryInfo findEntryToValue(Object object) {
        for (int i = 0; i < this.size(); ++i) {
            if (this.entryAt(i).getValue() != object) continue;
            return new EntryInfo(this.entryAt(i), i);
        }
        return null;
    }

    public synchronized Entry removeKey(Object object) {
        int n = 0;
        int n2 = this.v.size() - 1;
        int n3 = 0;
        while (n <= n2) {
            n3 = n + n2 >> 1;
            Entry entry = this.entryAt(n3);
            int n4 = this.compare(object, entry.getKey());
            if (n4 < 0) {
                n2 = n3 - 1;
                continue;
            }
            if (n4 > 0) {
                n = n3 + 1;
                continue;
            }
            this.v.removeElementAt(n3);
            return entry;
        }
        return null;
    }

    public synchronized Entry removeValue(Object object) {
        for (int i = 0; i < this.size(); ++i) {
            if (this.entryAt(i).getValue() != object) continue;
            Entry entry = this.entryAt(i);
            this.v.removeElementAt(i);
            return entry;
        }
        return null;
    }

    public synchronized Entry removeEntry(int n) {
        Entry entry = this.entryAt(n);
        this.v.removeElementAt(n);
        return entry;
    }

    public synchronized void list(PrintStream printStream) {
        printStream.println("-- listing Map entries --");
        for (int i = 0; i < this.size(); ++i) {
            Entry entry = this.entryAt(i);
            String string = entry.getKey().toString();
            String string2 = entry.getValue().toString();
            if (string2.length() > 40) {
                string2 = string2.substring(0, 37) + "...";
            }
            printStream.println(string + "=" + string2);
        }
    }

    public static class EntryInfo
    extends Entry {
        public final int Index;

        EntryInfo(Entry entry, int n) {
            super(entry.getKey(), entry.getValue());
            this.Index = n;
        }
    }

    public static class Entry
    implements Serializable {
        private final Object mKey;
        private Object mValue;

        Entry(Object object, Object object2) {
            this.mKey = object;
            this.mValue = object2;
        }

        public Object getKey() {
            return this.mKey;
        }

        public Object getValue() {
            return this.mValue;
        }

        public void setValue(Object object) {
            this.mValue = object;
        }
    }
}

