/*
 * Decompiled with CFR 0.152.
 */
package com.inzoom.util;

public class Guid {
    static GuidGen DefaultGuidGen = null;
    public int data1;
    public short data2;
    public short data3;
    public final byte[] data4 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};

    public static synchronized void setDefaultGuidGen(GuidGen guidGen) {
        DefaultGuidGen = guidGen;
    }

    public static synchronized GuidGen getDefaultGuidGen() {
        if (DefaultGuidGen == null) {
            try {
                DefaultGuidGen = (GuidGen)Class.forName("com.inzoom.comjni.ComLib$GuidGen").newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (DefaultGuidGen == null) {
            try {
                DefaultGuidGen = (GuidGen)Class.forName("com.inzoom.adojni.Guid$GuidGen").newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return DefaultGuidGen;
    }

    public static Guid createGuidNull() {
        return new Guid(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
    }

    public Guid(int n, short s, short s2, byte[] byArray) {
        this.data1 = n;
        this.data2 = s;
        this.data3 = s2;
        int n2 = Math.min(8, byArray.length);
        for (int i = 0; i < n2; ++i) {
            this.data4[i] = byArray[i];
        }
    }

    public Guid(int n, short s, short s2, char[] cArray) {
        this.data1 = n;
        this.data2 = s;
        this.data3 = s2;
        int n2 = Math.min(8, cArray.length);
        for (int i = 0; i < n2; ++i) {
            this.data4[i] = (byte)cArray[i];
        }
    }

    public Guid(int n, short s, short s2, byte by, byte by2, byte by3, byte by4, byte by5, byte by6, byte by7, byte by8) {
        this.data1 = n;
        this.data2 = s;
        this.data3 = s2;
        this.data4[0] = by;
        this.data4[1] = by2;
        this.data4[2] = by3;
        this.data4[3] = by4;
        this.data4[4] = by5;
        this.data4[5] = by6;
        this.data4[6] = by7;
        this.data4[7] = by8;
    }

    public Guid(byte[] byArray) {
        this.setBytes(byArray);
    }

    public Guid(String string) {
        this.fromString(string);
    }

    public void setBytes(byte[] byArray) {
        if (byArray == null || byArray.length < 16) {
            throw new IllegalArgumentException("Guid.setBytes need byte[16] as arg.");
        }
        this.data1 = byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8 | (byArray[2] & 0xFF) << 16 | (byArray[3] & 0xFF) << 24;
        this.data2 = (short)(byArray[4] & 0xFF | (byArray[5] & 0xFF) << 8);
        this.data3 = (short)(byArray[6] & 0xFF | (byArray[7] & 0xFF) << 8);
        for (int i = 0; i < 8; ++i) {
            this.data4[i] = byArray[8 + i];
        }
    }

    public byte[] getBytes() {
        byte[] byArray = new byte[16];
        byArray[0] = (byte)(this.data1 & 0xFF);
        byArray[1] = (byte)(this.data1 >> 8 & 0xFF);
        byArray[2] = (byte)(this.data1 >> 16 & 0xFF);
        byArray[3] = (byte)(this.data1 >> 24 & 0xFF);
        byArray[4] = (byte)(this.data2 & 0xFF);
        byArray[5] = (byte)(this.data2 >> 8 & 0xFF);
        byArray[6] = (byte)(this.data3 & 0xFF);
        byArray[7] = (byte)(this.data3 >> 8 & 0xFF);
        for (int i = 0; i < 8; ++i) {
            byArray[8 + i] = this.data4[i];
        }
        return byArray;
    }

    public boolean isGuidNull() {
        return this.data1 == 0 && this.data2 == 0 && this.data3 == 0 && this.data4[0] == 0 && this.data4[1] == 0 && this.data4[2] == 0 && this.data4[3] == 0 && this.data4[4] == 0 && this.data4[5] == 0 && this.data4[6] == 0 && this.data4[7] == 0;
    }

    public int compare(Guid guid) {
        int n;
        int n2 = this.data1 < guid.data1 ? -1 : (this.data1 > guid.data1 ? 1 : (this.data2 < guid.data2 ? -1 : (this.data2 > guid.data2 ? 1 : (this.data3 < guid.data3 ? -1 : (n = this.data3 > guid.data3 ? 1 : 0)))));
        if (n != 0) {
            return n;
        }
        for (int i = 0; i < 8; ++i) {
            int n3 = this.data4[i] < guid.data4[i] ? -1 : (n = this.data4[i] > guid.data4[i] ? 1 : 0);
            if (n == 0) continue;
            return n;
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (object instanceof Guid) {
            Guid guid = (Guid)object;
            return guid.data1 == this.data1 && guid.data2 == this.data2 && guid.data3 == this.data3 && guid.data4[0] == this.data4[0] && guid.data4[1] == this.data4[1] && guid.data4[2] == this.data4[2] && guid.data4[3] == this.data4[3] && guid.data4[4] == this.data4[4] && guid.data4[5] == this.data4[5] && guid.data4[6] == this.data4[6] && guid.data4[7] == this.data4[7];
        }
        return false;
    }

    public String toString() {
        return this.toString('{');
    }

    public String toHex() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('0');
        stringBuffer.append('x');
        byte[] byArray = this.getBytes();
        for (int i = 0; i < 16; ++i) {
            stringBuffer.append(Guid.byteToHex(byArray[i]));
        }
        return stringBuffer.toString();
    }

    public void fromHex(String string) {
        int n = 0;
        if (string.charAt(1) == 'x' || string.charAt(1) == 'X') {
            n = 2;
        }
        if (string.length() - n != 32) {
            throw new IllegalArgumentException("Hex string must be of length " + (32 + n));
        }
        byte[] byArray = new byte[16];
        for (int i = 0; i < 16; ++i) {
            byArray[i] = (byte)Guid.parseInt(string, n, 2);
            n += 2;
        }
        this.setBytes(byArray);
    }

    public String toString(char c) {
        char c2;
        switch (c) {
            case '(': {
                c2 = ')';
                break;
            }
            case '{': {
                c2 = '}';
                break;
            }
            case '[': {
                c2 = ']';
                break;
            }
            default: {
                c2 = c;
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (c != '\u0000') {
            stringBuffer.append(c);
        }
        stringBuffer.append(Guid.intToHex(this.data1));
        stringBuffer.append('-');
        stringBuffer.append(Guid.shortToHex(this.data2));
        stringBuffer.append('-');
        stringBuffer.append(Guid.shortToHex(this.data3));
        stringBuffer.append('-');
        for (int i = 0; i < 8; ++i) {
            stringBuffer.append(Guid.byteToHex(this.data4[i]));
            if (i != 1) continue;
            stringBuffer.append('-');
        }
        if (c2 != '\u0000') {
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    public void fromString(String string) {
        int n = 0;
        if (string.startsWith("{guid {")) {
            if (string.length() < 44) {
                throw new IllegalArgumentException();
            }
            n = 7;
        } else if (string.charAt(0) == '{') {
            if (string.length() < 38 || string.charAt(37) != '}') {
                throw new IllegalArgumentException();
            }
            ++n;
        } else if (string.length() < 36) {
            throw new IllegalArgumentException();
        }
        string = string.substring(n, n + 36);
        if (string.charAt(8) != '-' || string.charAt(13) != '-' || string.charAt(18) != '-' || string.charAt(23) != '-') {
            throw new IllegalArgumentException();
        }
        this.data1 = Guid.parseInt(string, 0, 8);
        this.data2 = (short)Guid.parseInt(string, 9, 4);
        this.data3 = (short)Guid.parseInt(string, 14, 4);
        n = 19;
        for (int i = 0; i < 8; ++i) {
            this.data4[i] = (byte)Guid.parseInt(string, n, 2);
            n += 2;
            if (i != 1) continue;
            ++n;
        }
    }

    private static char[] intToHex(int n) {
        char[] cArray = new char[8];
        for (int i = 0; i < 8; ++i) {
            cArray[7 - i] = Guid.hexToChar((char)(n >> 4 * i & 0xF));
        }
        return cArray;
    }

    private static char[] shortToHex(short s) {
        char[] cArray = new char[4];
        for (int i = 0; i < 4; ++i) {
            cArray[3 - i] = Guid.hexToChar((char)(s >> 4 * i & 0xF));
        }
        return cArray;
    }

    private static char[] byteToHex(byte by) {
        char[] cArray = new char[2];
        for (int i = 0; i < 2; ++i) {
            cArray[1 - i] = Guid.hexToChar((char)(by >> 4 * i & 0xF));
        }
        return cArray;
    }

    private static char hexToChar(char c) {
        return c < '\n' ? (char)(c + 48) : (char)(c - 10 + 65);
    }

    private static int parseInt(String string, int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            n3 <<= 4;
            n3 |= Guid.digit(string.charAt(n++));
        }
        return n3;
    }

    private static byte digit(char c) {
        if (c >= '0' && c <= '9') {
            return (byte)(c - 48);
        }
        if (c >= 'a' && c <= 'f') {
            return (byte)(c - 97 + 10);
        }
        if (c >= 'A' && c <= 'F') {
            return (byte)(c - 65 + 10);
        }
        throw new NumberFormatException("Is no hex digit: " + c);
    }

    public static interface GuidGen {
        public byte[] createBytes();
    }
}

