/*
 * Decompiled with CFR 0.152.
 */
package com.inzoom.comjni.jcw;

import com.inzoom.comjni.ComJniException;
import com.inzoom.comjni.Dll;
import com.inzoom.comjni.IUnknown;
import com.inzoom.comjni.SafeArray;
import com.inzoom.comjni.UDT;
import com.inzoom.comjni.Variant;
import com.inzoom.util.Guid;

public class IUnknownJCW
implements IUnknown {
    protected int mComPtr = 0;

    public static IUnknown getIUnknownFromComPtr(int n, boolean bl) {
        return n == 0 ? null : new IUnknownJCW(n, bl);
    }

    public static IUnknown getIUnknownFromPtr(int n, boolean bl) {
        return n == 0 ? null : new IUnknownJCW(n, bl);
    }

    public static IUnknown getIUnknownFromIUnknown(IUnknown iUnknown) throws ComJniException {
        return iUnknown == null ? null : new IUnknownJCW(iUnknown);
    }

    public static IUnknown convertComPtrToIUnknown(int n, boolean bl) throws ComJniException {
        return n == 0 ? null : new IUnknownJCW(n, IUnknown.IID, bl);
    }

    protected IUnknownJCW(int n) throws ComJniException {
        this(n, IUnknown.IID);
    }

    protected IUnknownJCW(int n, boolean bl, boolean bl2) throws ComJniException {
        this(n, IUnknown.IID, bl2);
    }

    protected IUnknownJCW(int n, boolean bl) {
        this.mComPtr = n;
        if (bl && this.mComPtr != 0) {
            IUnknownJCW.jniAddRef(n);
        }
    }

    protected IUnknownJCW(int n, Guid guid) throws ComJniException {
        this.mComPtr = IUnknownJCW.jniQI(n, guid);
    }

    protected IUnknownJCW(int n, Guid guid, boolean bl) throws ComJniException {
        this.mComPtr = IUnknownJCW.jniQI(n, guid);
        if (bl) {
            IUnknownJCW.jniRelease(n);
        }
    }

    protected IUnknownJCW(IUnknown iUnknown, Guid guid) throws ComJniException {
        this.mComPtr = iUnknown.QueryInterface(guid);
    }

    protected IUnknownJCW(IUnknown iUnknown) throws ComJniException {
        this(iUnknown, IUnknown.IID);
    }

    protected synchronized void finalize() {
        try {
            this.release();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public synchronized int release() {
        if (this.mComPtr != 0) {
            int n = IUnknownJCW.jniRelease(this.mComPtr);
            this.mComPtr = 0;
            return n;
        }
        return 0;
    }

    public void vtblCall(int n, Variant[] variantArray) throws ComJniException {
        this.vtblCall(n, variantArray, null);
    }

    public void vtblCall(int n, Variant[] variantArray, Guid guid) throws ComJniException {
        int[] nArray = new int[variantArray.length];
        for (int i = 0; i < variantArray.length; ++i) {
            nArray[i] = variantArray[i].getComPtr();
        }
        IUnknownJCW.jniVtblCall(this.mComPtr, n, nArray, guid);
    }

    public int QueryInterface(Guid guid) throws ComJniException {
        return IUnknownJCW.jniQI(this.mComPtr, guid);
    }

    public synchronized int detachPtr() {
        int n = this.mComPtr;
        this.mComPtr = 0;
        return n;
    }

    public int getAddRefPtr() {
        IUnknownJCW.jniAddRef(this.mComPtr);
        return this.mComPtr;
    }

    public int getPtr() {
        return this.mComPtr;
    }

    public synchronized boolean isValid() {
        return this.mComPtr != 0;
    }

    protected Variant createVTblVArg(Variant variant) throws ComJniException {
        return new VTblArg((Object)variant, IUnknownJCW.jniCreateVTblVArg(variant.getComPtr()));
    }

    protected Variant createVTblSAArg(SafeArray safeArray) throws ComJniException {
        return new VTblArg((Object)safeArray, IUnknownJCW.jniCreateVTblSAArg(safeArray.getComPtr()));
    }

    protected Variant createVTblRArg(UDT uDT) throws ComJniException {
        if (uDT.getBuffer() == 0 || uDT.getSize() <= 0) {
            throw new IllegalArgumentException("UDT must be allocated");
        }
        return new VTblArg(uDT, IUnknownJCW.jniCreateVTblRArg(uDT.getBuffer(), uDT.getSize()));
    }

    private static native int jniRelease(int var0);

    private static native void jniAddRef(int var0);

    private static native int jniQI(int var0, Guid var1) throws ComJniException;

    private static native void jniVtblCall(int var0, int var1, int[] var2, Guid var3) throws ComJniException;

    private static native int jniCreateVTblVArg(int var0);

    private static native void jniClearVTblVArg(int var0);

    private static native int jniCreateVTblSAArg(int var0);

    private static native int jniCreateVTblRArg(int var0, int var1);

    static {
        Dll.start();
    }

    private static class VTblArg
    extends Variant {
        Object mRef;

        VTblArg(Object object, int n) {
            super(n, 0);
            this.mRef = object;
        }

        public void release() throws ComJniException {
            if (this.getComPtr() != 0) {
                IUnknownJCW.jniClearVTblVArg(this.getComPtr());
            }
            this.mRef = null;
            super.release();
        }
    }
}

