/*
 * Decompiled with CFR 0.152.
 */
package com.inzoom.comjni;

import com.inzoom.comjni.ComJniException;
import com.inzoom.comjni.Documentation;
import com.inzoom.comjni.ElemDesc;
import com.inzoom.comjni.ITypeInfo;
import com.inzoom.comjni.Variant;
import com.inzoom.comjni._StructWrapper;
import com.inzoom.comjni.jcw.ITypeInfoJCW;

public class VarDesc
extends _StructWrapper {
    int mParentPtr;
    int mPtr;

    public static VarDesc getVarDescFromPtr(int n, ITypeInfo iTypeInfo) {
        return n == 0 ? null : new VarDesc(n, iTypeInfo);
    }

    VarDesc(int n, ITypeInfo iTypeInfo) {
        this.mParentPtr = iTypeInfo.getAddRefPtr();
        this.mPtr = n;
    }

    protected void finalize() {
        this.release();
    }

    void checkValid() throws NullPointerException {
        if (this.mPtr == 0) {
            throw new NullPointerException(this.getClass().getName());
        }
    }

    public Documentation getDocumentation() throws NullPointerException, ComJniException {
        this.checkValid();
        return ITypeInfoJCW.getITypeInfoFromPtr(this.mParentPtr, true).getDocumentation(this.getMemid());
    }

    public int getMemid() throws NullPointerException {
        this.checkValid();
        return VarDesc.jniGetMemid(this.mPtr);
    }

    public int getOInst() throws NullPointerException {
        this.checkValid();
        return VarDesc.jniGetOInst(this.mPtr);
    }

    public Variant getVarValue() throws NullPointerException, ComJniException {
        this.checkValid();
        return Variant.VariantFromPtr(VarDesc.jniGetVarValue(this.mPtr));
    }

    public ElemDesc getElemDesc() throws NullPointerException {
        this.checkValid();
        return new ElemDesc(VarDesc.jniGetElemDesc(this.mPtr), this);
    }

    public short getVarFlags() throws NullPointerException {
        this.checkValid();
        return VarDesc.jniGetVarFlags(this.mPtr);
    }

    public int getVarKind() throws NullPointerException {
        this.checkValid();
        return VarDesc.jniGetVarKind(this.mPtr);
    }

    public synchronized void release() {
        if (this.mPtr != 0) {
            ((ITypeInfoJCW)ITypeInfoJCW.getITypeInfoFromPtr(this.mParentPtr, false)).releaseVarDesc(this.mPtr);
            this.mPtr = 0;
            this.mParentPtr = 0;
        }
    }

    public String toString() {
        try {
            return "VarDesc: " + this.getDocumentation().name;
        }
        catch (Throwable throwable) {
            return super.toString();
        }
    }

    private static native int jniGetMemid(int var0);

    private static native int jniGetOInst(int var0);

    private static native int jniGetVarValue(int var0);

    private static native int jniGetElemDesc(int var0);

    private static native short jniGetVarFlags(int var0);

    private static native int jniGetVarKind(int var0);
}

