/*
 * Decompiled with CFR 0.152.
 */
package com.inzoom.comjni;

import com.inzoom.comjni.ITypeInfo;
import com.inzoom.comjni.TypeDesc;
import com.inzoom.comjni._StructWrapper;
import com.inzoom.comjni.jcw.ITypeInfoJCW;
import com.inzoom.util.Guid;

public class TypeAttr
extends _StructWrapper {
    int mParentPtr;
    int mPtr;

    public static TypeAttr getTypeAttrFromPtr(int n, ITypeInfo iTypeInfo) {
        return n == 0 ? null : new TypeAttr(n, iTypeInfo);
    }

    TypeAttr(int n, ITypeInfo iTypeInfo) {
        this.mParentPtr = iTypeInfo.getAddRefPtr();
        this.mPtr = n;
    }

    protected void finalize() {
        this.release();
    }

    void checkValid() throws NullPointerException {
        if (this.mPtr == 0) {
            throw new NullPointerException(this.getClass().getName());
        }
    }

    public Guid getGuid() throws NullPointerException {
        this.checkValid();
        return TypeAttr.jniGetGuid(this.mPtr);
    }

    public int getLCID() throws NullPointerException {
        this.checkValid();
        return TypeAttr.jniGetLCID(this.mPtr);
    }

    public int getMemidConstructor() throws NullPointerException {
        this.checkValid();
        return TypeAttr.jniGetMemIdConstructor(this.mPtr);
    }

    public int getMemidDestructor() throws NullPointerException {
        this.checkValid();
        return TypeAttr.jniGetMemIdDestructor(this.mPtr);
    }

    public TypeDesc getTDescAlias() throws NullPointerException {
        this.checkValid();
        return new TypeDesc(TypeAttr.jniGetTDescAlias(this.mPtr), this);
    }

    public int getTypeKind() throws NullPointerException {
        this.checkValid();
        return TypeAttr.jniGetTypeKind(this.mPtr);
    }

    public short getFuncCount() throws NullPointerException {
        this.checkValid();
        return TypeAttr.jniGetCFuncs(this.mPtr);
    }

    public short getVarCount() throws NullPointerException {
        this.checkValid();
        return TypeAttr.jniGetCVars(this.mPtr);
    }

    public int getInstanceSize() throws NullPointerException {
        this.checkValid();
        return TypeAttr.jniGetInstanceSize(this.mPtr);
    }

    public short getImplTypeCount() throws NullPointerException {
        this.checkValid();
        return TypeAttr.jniGetCImplTypes(this.mPtr);
    }

    public short getVftSize() throws NullPointerException {
        this.checkValid();
        return TypeAttr.jniGetCbSizeVft(this.mPtr);
    }

    public short getAlignment() throws NullPointerException {
        this.checkValid();
        return TypeAttr.jniGetCbAlignment(this.mPtr);
    }

    public short getMinorVerNum() throws NullPointerException {
        this.checkValid();
        return TypeAttr.jniGetMinorVerNum(this.mPtr);
    }

    public short getMajorVerNum() throws NullPointerException {
        this.checkValid();
        return TypeAttr.jniGetMajorVerNum(this.mPtr);
    }

    public int getTypeFlags() throws NullPointerException {
        this.checkValid();
        return TypeAttr.jniGetTypeFlags(this.mPtr);
    }

    public synchronized void release() {
        if (this.mPtr != 0) {
            ((ITypeInfoJCW)ITypeInfoJCW.getITypeInfoFromPtr(this.mParentPtr, false)).releaseTypeAttr(this.mPtr);
            this.mPtr = 0;
            this.mParentPtr = 0;
        }
    }

    private static native Guid jniGetGuid(int var0);

    private static native int jniGetLCID(int var0);

    private static native int jniGetMemIdConstructor(int var0);

    private static native int jniGetMemIdDestructor(int var0);

    private static native int jniGetTypeKind(int var0);

    private static native short jniGetCFuncs(int var0);

    private static native short jniGetCVars(int var0);

    private static native short jniGetCImplTypes(int var0);

    private static native short jniGetCbSizeVft(int var0);

    private static native short jniGetCbAlignment(int var0);

    private static native int jniGetTDescAlias(int var0);

    private static native int jniGetTypeFlags(int var0);

    private static native int jniGetInstanceSize(int var0);

    private static native short jniGetMajorVerNum(int var0);

    private static native short jniGetMinorVerNum(int var0);
}

