/*
 * Decompiled with CFR 0.152.
 */
package com.inzoom.comjni;

import com.inzoom.comjni.ITypeLib;
import com.inzoom.comjni._StructWrapper;
import com.inzoom.comjni.jcw.ITypeLibJCW;
import com.inzoom.util.Guid;

public class TLibAttr
extends _StructWrapper {
    int mParentPtr;
    int mPtr;

    public static TLibAttr getTLibAttrFromPtr(int n, ITypeLib iTypeLib) {
        return n == 0 ? null : new TLibAttr(n, iTypeLib);
    }

    TLibAttr(int n, ITypeLib iTypeLib) {
        this.mParentPtr = iTypeLib.getAddRefPtr();
        this.mPtr = n;
    }

    void checkValid() throws NullPointerException {
        if (this.mPtr == 0) {
            throw new NullPointerException(this.getClass().getName());
        }
    }

    public synchronized void release() {
        if (this.mPtr != 0) {
            ((ITypeLibJCW)ITypeLibJCW.getITypeLibFromPtr(this.mParentPtr, false)).releaseTLibAttr(this.mPtr);
            this.mPtr = 0;
            this.mParentPtr = 0;
        }
    }

    public Guid getGuid() throws NullPointerException {
        this.checkValid();
        return TLibAttr.jniGetGuid(this.mPtr);
    }

    public int getLCID() throws NullPointerException {
        this.checkValid();
        return TLibAttr.jniGetLCID(this.mPtr);
    }

    public short getMinorVerNum() throws NullPointerException {
        this.checkValid();
        return TLibAttr.jniGetMinorVerNum(this.mPtr);
    }

    public short getMajorVerNum() throws NullPointerException {
        this.checkValid();
        return TLibAttr.jniGetMajorVerNum(this.mPtr);
    }

    public short getLibFlags() throws NullPointerException {
        this.checkValid();
        return TLibAttr.jniGetLibFlags(this.mPtr);
    }

    protected void finalize() {
        this.release();
    }

    private static native Guid jniGetGuid(int var0);

    private static native int jniGetLCID(int var0);

    private static native short jniGetLibFlags(int var0);

    private static native short jniGetMajorVerNum(int var0);

    private static native short jniGetMinorVerNum(int var0);
}

