/*
 * Decompiled with CFR 0.152.
 */
package com.inzoom.comjni;

import com.inzoom.comjni.ComJniException;
import com.inzoom.comjni.Dll;
import com.inzoom.comjni.IDispatch;
import com.inzoom.comjni.IUnknown;
import com.inzoom.comjni.Variant;
import com.inzoom.comjni.jcw.IDispatchJCW;
import com.inzoom.comjni.jcw.IUnknownJCW;
import com.inzoom.util.EnumToString;

public class SafeArray {
    private int mPtr = 0;
    private boolean mAttached = false;
    static /* synthetic */ Class class$com$inzoom$comjni$enums$VarType;

    public static SafeArray attach(int n) throws ComJniException {
        return n == 0 ? null : new SafeArray(n, true);
    }

    public SafeArray(short s, int n) throws ComJniException {
        this.mPtr = SafeArray.jniCreate(new int[]{n}, new int[]{0}, s);
    }

    public SafeArray(short s, int[] nArray, int[] nArray2) throws ComJniException {
        this.mPtr = SafeArray.jniCreate(nArray2, nArray, s);
    }

    public SafeArray(Bound[] boundArray, short s) throws ComJniException {
        int[] nArray = new int[boundArray.length];
        int[] nArray2 = new int[boundArray.length];
        for (int i = 0; i < boundArray.length; ++i) {
            nArray2[i] = boundArray[i].lBound;
            nArray[i] = boundArray[i].cElems;
        }
        this.mPtr = SafeArray.jniCreate(nArray, nArray2, s);
    }

    public SafeArray(boolean[] blArray) throws ComJniException {
        this.mPtr = SafeArray.jniCreateBooleanVector(blArray, (short)11);
    }

    public SafeArray(byte[] byArray) throws ComJniException {
        this(byArray, 17);
    }

    public SafeArray(byte[] byArray, short s) throws ComJniException {
        this.mPtr = SafeArray.jniCreateByteVector(byArray, s);
    }

    public SafeArray(short[] sArray) throws ComJniException {
        this(sArray, 2);
    }

    public SafeArray(short[] sArray, short s) throws ComJniException {
        this.mPtr = SafeArray.jniCreateShortVector(sArray, s);
    }

    public SafeArray(int[] nArray) throws ComJniException {
        this(nArray, 3);
    }

    public SafeArray(int[] nArray, short s) throws ComJniException {
        this.mPtr = SafeArray.jniCreateIntVector(nArray, s);
    }

    public SafeArray(long[] lArray, short s) throws ComJniException {
        this.mPtr = SafeArray.jniCreateLongVector(lArray, s);
    }

    public SafeArray(float[] fArray) throws ComJniException {
        this.mPtr = SafeArray.jniCreateFloatVector(fArray, (short)4);
    }

    public SafeArray(double[] dArray, short s) throws ComJniException {
        this.mPtr = SafeArray.jniCreateDoubleVector(dArray, s);
    }

    public SafeArray(double[] dArray) throws ComJniException {
        this(dArray, 5);
    }

    public SafeArray(String string) throws ComJniException {
        this.mPtr = SafeArray.jniCreateVectorFromString(string);
    }

    public SafeArray(String[] stringArray) throws ComJniException {
        this.mPtr = SafeArray.jniCreateStringVector(stringArray, (short)8);
    }

    public SafeArray(Variant[] variantArray) throws ComJniException {
        int[] nArray = new int[variantArray.length];
        for (int i = 0; i < variantArray.length; ++i) {
            nArray[i] = variantArray[i].getComPtr();
        }
        this.mPtr = SafeArray.jniCreateVariantVector(nArray, (short)12);
    }

    public SafeArray(IUnknown[] iUnknownArray) throws ComJniException {
        int[] nArray = new int[iUnknownArray.length];
        for (int i = 0; i < iUnknownArray.length; ++i) {
            nArray[i] = iUnknownArray[i].getAddRefPtr();
        }
        this.mPtr = SafeArray.jniCreateIUnknownVector(nArray, (short)13);
    }

    public SafeArray(IDispatch[] iDispatchArray) throws ComJniException {
        int[] nArray = new int[iDispatchArray.length];
        for (int i = 0; i < iDispatchArray.length; ++i) {
            nArray[i] = iDispatchArray[i].getAddRefPtr();
        }
        this.mPtr = SafeArray.jniCreateIDispatchVector(nArray, (short)9);
    }

    public static SafeArray SafeArrayFromPtr(int n) {
        return n == 0 ? null : new SafeArray(false, n);
    }

    public static SafeArray SafeArrayCopy(SafeArray safeArray) throws ComJniException {
        return SafeArray.SafeArrayFromPtr(SafeArray.jniCopy(safeArray.getComPtr()));
    }

    public synchronized Object getObject() throws ComJniException {
        if (this.mPtr == 0) {
            return null;
        }
        short s = SafeArray.jnigetvt(this.mPtr);
        switch (s) {
            case 11: {
                return SafeArray.jniGetBooleanVector(this.mPtr, 0, 0);
            }
            case 16: 
            case 17: {
                return SafeArray.jniGetByteVector(this.mPtr, 0, 0);
            }
            case 2: 
            case 18: {
                return SafeArray.jniGetShortVector(this.mPtr, 0, 0);
            }
            case 3: 
            case 10: 
            case 19: 
            case 22: 
            case 23: 
            case 25: {
                return SafeArray.jniGetIntVector(this.mPtr, 0, 0);
            }
            case 6: 
            case 20: 
            case 21: {
                return SafeArray.jniGetLongVector(this.mPtr, 0, 0);
            }
            case 8: {
                return SafeArray.jniGetStringVector(this.mPtr, 0, 0);
            }
            case 4: {
                return SafeArray.jniGetFloatVector(this.mPtr, 0, 0);
            }
            case 5: 
            case 7: {
                return SafeArray.jniGetDoubleVector(this.mPtr, 0, 0);
            }
            case 9: {
                return this.getDispatchArray(0, 0);
            }
            case 13: {
                return this.getUnknownArray(0, 0);
            }
            case 12: {
                return this.getVariantArray(0, 0);
            }
        }
        throw new ComJniException("Variant type unsupported: " + EnumToString.toString(class$com$inzoom$comjni$enums$VarType == null ? (class$com$inzoom$comjni$enums$VarType = SafeArray.class$("com.inzoom.comjni.enums.VarType")) : class$com$inzoom$comjni$enums$VarType, s), "SafeArray.getObject", 0, 4);
    }

    public int getComPtr() {
        return this.mPtr;
    }

    public synchronized short getVt() throws ComJniException {
        return SafeArray.jnigetvt(this.mPtr);
    }

    public synchronized int getLBound() throws ComJniException {
        return SafeArray.jnigetLBound(this.mPtr, 0);
    }

    public synchronized int getLBound(int n) throws ComJniException {
        return SafeArray.jnigetLBound(this.mPtr, n);
    }

    public synchronized int getSize() {
        return SafeArray.jniGetSize(this.mPtr, 0);
    }

    public synchronized int getSize(int n) {
        return SafeArray.jniGetSize(this.mPtr, n);
    }

    public synchronized int getDims() {
        return SafeArray.jnigetDim(this.mPtr);
    }

    public synchronized Bound getBound() throws ComJniException {
        int[] nArray = SafeArray.jniGetBounds(this.mPtr);
        return new Bound(nArray[0], nArray[1]);
    }

    public Bound getBound(int n) throws ComJniException {
        return this.getBounds()[n];
    }

    public synchronized Bound[] getBounds() throws ComJniException {
        int[] nArray = SafeArray.jniGetBounds(this.mPtr);
        Bound[] boundArray = new Bound[nArray.length >> 1];
        int n = 0;
        int n2 = 0;
        while (n < nArray.length) {
            boundArray[n2] = new Bound(nArray[n++], nArray[n++]);
            ++n2;
        }
        return boundArray;
    }

    public synchronized void setBooleanArray(boolean[] blArray) throws ComJniException {
        SafeArray.jniSetBooleanVector(this.mPtr, blArray, 0, blArray.length, 0, true);
    }

    public synchronized void setBooleanArray(boolean[] blArray, int n, int n2, int n3) throws ComJniException, IndexOutOfBoundsException {
        SafeArray.jniSetBooleanVector(this.mPtr, blArray, n, n2, n3, true);
    }

    public synchronized void setByteArray(byte[] byArray) throws ComJniException {
        SafeArray.jniSetByteVector(this.mPtr, byArray, 0, byArray.length, 0, true);
    }

    public synchronized void setByteArray(byte[] byArray, int n, int n2, int n3) throws ComJniException, IndexOutOfBoundsException {
        SafeArray.jniSetByteVector(this.mPtr, byArray, n, n2, n3, true);
    }

    public synchronized void setShortArray(short[] sArray) throws ComJniException {
        SafeArray.jniSetShortVector(this.mPtr, sArray, 0, sArray.length, 0, true);
    }

    public synchronized void setShortArray(short[] sArray, int n, int n2, int n3) throws ComJniException, IndexOutOfBoundsException {
        SafeArray.jniSetShortVector(this.mPtr, sArray, n, n2, n3, true);
    }

    public synchronized void setIntArray(int[] nArray) throws ComJniException {
        SafeArray.jniSetIntVector(this.mPtr, nArray, 0, nArray.length, 0, true);
    }

    public synchronized void setIntArray(int[] nArray, int n, int n2, int n3) throws ComJniException, IndexOutOfBoundsException {
        SafeArray.jniSetIntVector(this.mPtr, nArray, n, n2, n3, true);
    }

    public synchronized void setLongArray(long[] lArray) throws ComJniException {
        SafeArray.jniSetLongVector(this.mPtr, lArray, 0, lArray.length, 0, true);
    }

    public synchronized void setLongArray(long[] lArray, int n, int n2, int n3) throws ComJniException, IndexOutOfBoundsException {
        SafeArray.jniSetLongVector(this.mPtr, lArray, n, n2, n3, true);
    }

    public synchronized void setFloatArray(float[] fArray) throws ComJniException {
        SafeArray.jniSetFloatVector(this.mPtr, fArray, 0, fArray.length, 0, true);
    }

    public synchronized void setFloatArray(float[] fArray, int n, int n2, int n3) throws ComJniException, IndexOutOfBoundsException {
        SafeArray.jniSetFloatVector(this.mPtr, fArray, n, n2, n3, true);
    }

    public synchronized void setDoubleArray(double[] dArray) throws ComJniException {
        SafeArray.jniSetDoubleVector(this.mPtr, dArray, 0, dArray.length, 0, true);
    }

    public synchronized void setDoubleArray(double[] dArray, int n, int n2, int n3) throws ComJniException, IndexOutOfBoundsException {
        SafeArray.jniSetDoubleVector(this.mPtr, dArray, n, n2, n3, true);
    }

    public synchronized void setStringArray(String[] stringArray) throws ComJniException {
        SafeArray.jniSetStringVector(this.mPtr, stringArray, 0, stringArray.length, 0, true);
    }

    public synchronized void setStringArray(String[] stringArray, int n, int n2, int n3) throws ComJniException {
        SafeArray.jniSetStringVector(this.mPtr, stringArray, n, n2, n3, true);
    }

    public void setVariantArray(Variant[] variantArray) throws ComJniException {
        this.setVariantArray(variantArray, 0, variantArray.length, 0);
    }

    public synchronized void setVariantArray(Variant[] variantArray, int n, int n2, int n3) throws ComJniException {
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = variantArray[n3 + i].getComPtr();
        }
        SafeArray.jniSetVariantVector(this.mPtr, nArray, n, n2, 0, true);
    }

    public void setUnknownArray(IUnknown[] iUnknownArray) throws ComJniException {
        this.setUnknownArray(iUnknownArray, 0, iUnknownArray.length, 0);
    }

    public synchronized void setUnknownArray(IUnknown[] iUnknownArray, int n, int n2, int n3) throws ComJniException {
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = iUnknownArray[n3 + i].getAddRefPtr();
        }
        SafeArray.jniSetIUnknownVector(this.mPtr, nArray, n, n2, 0, true);
    }

    public void setDispatchArray(IDispatch[] iDispatchArray) throws ComJniException {
        this.setDispatchArray(iDispatchArray, 0, iDispatchArray.length, 0);
    }

    public synchronized void setDispatchArray(IDispatch[] iDispatchArray, int n, int n2, int n3) throws ComJniException {
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = iDispatchArray[n3 + i].getAddRefPtr();
        }
        SafeArray.jniSetIDispatchVector(this.mPtr, nArray, n, n2, 0, true);
    }

    public synchronized boolean[] getBooleanArray() throws ComJniException {
        return SafeArray.jniGetBooleanVector(this.mPtr, 0, 0);
    }

    public synchronized boolean[] getBooleanArray(int n, int n2) throws ComJniException {
        return SafeArray.jniGetBooleanVector(this.mPtr, n, n2);
    }

    public synchronized byte[] getByteArray() throws ComJniException {
        return SafeArray.jniGetByteVector(this.mPtr, 0, 0);
    }

    public synchronized byte[] getByteArray(int n, int n2) throws ComJniException {
        return SafeArray.jniGetByteVector(this.mPtr, n, n2);
    }

    public synchronized short[] getShortArray() throws ComJniException {
        return SafeArray.jniGetShortVector(this.mPtr, 0, 0);
    }

    public synchronized short[] getShortArray(int n, int n2) throws ComJniException {
        return SafeArray.jniGetShortVector(this.mPtr, n, n2);
    }

    public synchronized int[] getIntArray() throws ComJniException {
        return SafeArray.jniGetIntVector(this.mPtr, 0, 0);
    }

    public synchronized int[] getIntArray(int n, int n2) throws ComJniException {
        return SafeArray.jniGetIntVector(this.mPtr, n, n2);
    }

    public synchronized long[] getLongArray() throws ComJniException {
        return SafeArray.jniGetLongVector(this.mPtr, 0, 0);
    }

    public synchronized long[] getLongArray(int n, int n2) throws ComJniException {
        return SafeArray.jniGetLongVector(this.mPtr, n, n2);
    }

    public synchronized float[] getFloatArray() throws ComJniException {
        return SafeArray.jniGetFloatVector(this.mPtr, 0, 0);
    }

    public synchronized float[] getFloatArray(int n, int n2) throws ComJniException {
        return SafeArray.jniGetFloatVector(this.mPtr, n, n2);
    }

    public synchronized double[] getDoubleArray() throws ComJniException {
        return SafeArray.jniGetDoubleVector(this.mPtr, 0, 0);
    }

    public synchronized double[] getDoubleArray(int n, int n2) throws ComJniException {
        return SafeArray.jniGetDoubleVector(this.mPtr, n, n2);
    }

    public synchronized String[] getStringArray() throws ComJniException {
        return SafeArray.jniGetStringVector(this.mPtr, 0, 0);
    }

    public synchronized String[] getStringArray(int n, int n2) throws ComJniException {
        return SafeArray.jniGetStringVector(this.mPtr, n, n2);
    }

    public Variant[] getVariantArray() throws ComJniException {
        return this.getVariantArray(0, 0);
    }

    public synchronized Variant[] getVariantArray(int n, int n2) throws ComJniException {
        int[] nArray = SafeArray.jniGetVariantVector(this.mPtr, n, n2);
        Variant[] variantArray = new Variant[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            variantArray[i] = Variant.VariantFromPtr(nArray[i]);
        }
        return variantArray;
    }

    public IUnknown[] getUnknownArray() throws ComJniException {
        return this.getUnknownArray(0, 0);
    }

    public synchronized IUnknown[] getUnknownArray(int n, int n2) throws ComJniException {
        int[] nArray = SafeArray.jniGetIUnknownVector(this.mPtr, n, n2);
        IUnknown[] iUnknownArray = new IUnknown[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            iUnknownArray[i] = IUnknownJCW.getIUnknownFromPtr(nArray[i], false);
        }
        return iUnknownArray;
    }

    public IDispatch[] getDispatchArray() throws ComJniException {
        return this.getDispatchArray(0, 0);
    }

    public synchronized IDispatch[] getDispatchArray(int n, int n2) throws ComJniException {
        int[] nArray = SafeArray.jniGetIDispatchVector(this.mPtr, n, n2);
        IDispatch[] iDispatchArray = new IDispatch[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            iDispatchArray[i] = IDispatchJCW.getIDispatchFromPtr(nArray[i], false);
        }
        return iDispatchArray;
    }

    public synchronized String asString() throws ComJniException {
        return SafeArray.jniGetStringFromVector(this.mPtr);
    }

    public synchronized void setBoolean(int n, boolean bl) throws ComJniException {
        SafeArray.jniSetBoolean(this.mPtr, n, bl);
    }

    public synchronized void setBoolean(int[] nArray, boolean bl) throws ComJniException {
        SafeArray.jniSetBooleanEx(this.mPtr, nArray, bl);
    }

    public synchronized boolean getBoolean(int n) throws ComJniException {
        return SafeArray.jniGetBoolean(this.mPtr, n);
    }

    public synchronized boolean getBoolean(int[] nArray) throws ComJniException {
        return SafeArray.jniGetBooleanEx(this.mPtr, nArray);
    }

    public synchronized void setByte(int n, byte by) throws ComJniException {
        SafeArray.jniSetByte(this.mPtr, n, by);
    }

    public synchronized void setByte(int[] nArray, byte by) throws ComJniException {
        SafeArray.jniSetByteEx(this.mPtr, nArray, by);
    }

    public synchronized byte getByte(int n) throws ComJniException {
        return SafeArray.jniGetByte(this.mPtr, n);
    }

    public synchronized byte getByte(int[] nArray) throws ComJniException {
        return SafeArray.jniGetByteEx(this.mPtr, nArray);
    }

    public synchronized void setShort(int n, short s) throws ComJniException {
        SafeArray.jniSetShort(this.mPtr, n, s);
    }

    public synchronized void setShort(int[] nArray, short s) throws ComJniException {
        SafeArray.jniSetShortEx(this.mPtr, nArray, s);
    }

    public synchronized short getShort(int n) throws ComJniException {
        return SafeArray.jniGetShort(this.mPtr, n);
    }

    public synchronized short getShort(int[] nArray) throws ComJniException {
        return SafeArray.jniGetShortEx(this.mPtr, nArray);
    }

    public synchronized void setInt(int n, int n2) throws ComJniException {
        SafeArray.jniSetInt(this.mPtr, n, n2);
    }

    public synchronized void setInt(int[] nArray, int n) throws ComJniException {
        SafeArray.jniSetIntEx(this.mPtr, nArray, n);
    }

    public synchronized int getInt(int n) throws ComJniException {
        return SafeArray.jniGetInt(this.mPtr, n);
    }

    public synchronized int getInt(int[] nArray) throws ComJniException {
        return SafeArray.jniGetIntEx(this.mPtr, nArray);
    }

    public synchronized void setLong(int n, long l) throws ComJniException {
        SafeArray.jniSetLong(this.mPtr, n, l);
    }

    public synchronized void setLong(int[] nArray, long l) throws ComJniException {
        SafeArray.jniSetLongEx(this.mPtr, nArray, l);
    }

    public synchronized long getLong(int n) throws ComJniException {
        return SafeArray.jniGetLong(this.mPtr, n);
    }

    public synchronized long getLong(int[] nArray) throws ComJniException {
        return SafeArray.jniGetLongEx(this.mPtr, nArray);
    }

    public synchronized void setFloat(int n, float f) throws ComJniException {
        SafeArray.jniSetFloat(this.mPtr, n, f);
    }

    public synchronized void setFloat(int[] nArray, float f) throws ComJniException {
        SafeArray.jniSetFloatEx(this.mPtr, nArray, f);
    }

    public synchronized float getFloat(int n) throws ComJniException {
        return SafeArray.jniGetFloat(this.mPtr, n);
    }

    public synchronized float getFloat(int[] nArray) throws ComJniException {
        return SafeArray.jniGetFloatEx(this.mPtr, nArray);
    }

    public synchronized void setDouble(int n, double d) throws ComJniException {
        SafeArray.jniSetDouble(this.mPtr, n, d);
    }

    public synchronized void setDouble(int[] nArray, double d) throws ComJniException {
        SafeArray.jniSetDoubleEx(this.mPtr, nArray, d);
    }

    public synchronized double getDouble(int n) throws ComJniException {
        return SafeArray.jniGetDouble(this.mPtr, n);
    }

    public synchronized double getDouble(int[] nArray) throws ComJniException {
        return SafeArray.jniGetDoubleEx(this.mPtr, nArray);
    }

    public synchronized void setString(int n, String string) throws ComJniException {
        SafeArray.jniSetString(this.mPtr, n, string);
    }

    public synchronized void setString(int[] nArray, String string) throws ComJniException {
        SafeArray.jniSetStringEx(this.mPtr, nArray, string);
    }

    public synchronized String getString(int n) throws ComJniException {
        return SafeArray.jniGetString(this.mPtr, n);
    }

    public synchronized String getString(int[] nArray) throws ComJniException {
        return SafeArray.jniGetStringEx(this.mPtr, nArray);
    }

    public synchronized void setVariant(int n, Variant variant) throws ComJniException {
        SafeArray.jniSetVariant(this.mPtr, n, variant.getComPtr());
    }

    public synchronized void setVariant(int[] nArray, Variant variant) throws ComJniException {
        SafeArray.jniSetVariantEx(this.mPtr, nArray, variant.getComPtr());
    }

    public synchronized Variant getVariant(int n) throws ComJniException {
        return Variant.VariantFromPtr(SafeArray.jniGetVariant(this.mPtr, n));
    }

    public synchronized Variant getVariant(int[] nArray) throws ComJniException {
        return Variant.VariantFromPtr(SafeArray.jniGetVariantEx(this.mPtr, nArray));
    }

    public synchronized void setUnknown(int n, IUnknown iUnknown) throws ComJniException {
        SafeArray.jniSetIUnknown(this.mPtr, n, iUnknown.getAddRefPtr());
    }

    public synchronized void setUnknown(int[] nArray, IUnknown iUnknown) throws ComJniException {
        SafeArray.jniSetIUnknownEx(this.mPtr, nArray, iUnknown.getAddRefPtr());
    }

    public synchronized IUnknown getUnknown(int n) throws ComJniException {
        return IUnknownJCW.getIUnknownFromPtr(SafeArray.jniGetIUnknown(this.mPtr, n), false);
    }

    public synchronized IUnknown getUnknown(int[] nArray) throws ComJniException {
        return IUnknownJCW.getIUnknownFromPtr(SafeArray.jniGetIUnknownEx(this.mPtr, nArray), false);
    }

    public synchronized void setDispatch(int n, IDispatch iDispatch) throws ComJniException {
        SafeArray.jniSetIDispatch(this.mPtr, n, iDispatch.getAddRefPtr());
    }

    public synchronized void setDispatch(int[] nArray, IDispatch iDispatch) throws ComJniException {
        SafeArray.jniSetIDispatchEx(this.mPtr, nArray, iDispatch.getAddRefPtr());
    }

    public synchronized IDispatch getDispatch(int n) throws ComJniException {
        return IDispatchJCW.getIDispatchFromPtr(SafeArray.jniGetIDispatch(this.mPtr, n), false);
    }

    public synchronized IDispatch getDispatch(int[] nArray) throws ComJniException {
        return IDispatchJCW.getIDispatchFromPtr(SafeArray.jniGetIDispatchEx(this.mPtr, nArray), false);
    }

    public synchronized void release() throws ComJniException {
        if (!this.mAttached && this.mPtr != 0) {
            SafeArray.jniDestroy(this.mPtr);
        }
        this.mPtr = 0;
    }

    protected void finalize() throws ComJniException, Exception {
        this.release();
    }

    private SafeArray(boolean bl, int n) {
        this.mPtr = n;
    }

    private SafeArray(int n, boolean bl) {
        this.mPtr = n;
        this.mAttached = bl;
    }

    private static native int jniCreate(int[] var0, int[] var1, short var2) throws ComJniException;

    private static native int jniDestroy(int var0) throws ComJniException;

    private static native short jnigetvt(int var0) throws ComJniException;

    private static native int jnigetLBound(int var0, int var1) throws ComJniException;

    private static native int jnigetUBound(int var0, int var1) throws ComJniException;

    private static native int jnigetDim(int var0);

    private static native int jniGetSize(int var0, int var1);

    private static native int[] jniGetBounds(int var0) throws ComJniException;

    private static native int jniCopy(int var0) throws ComJniException;

    private static native void jniSetBooleanVector(int var0, boolean[] var1, int var2, int var3, int var4, boolean var5) throws ComJniException;

    private static native void jniSetByteVector(int var0, byte[] var1, int var2, int var3, int var4, boolean var5) throws ComJniException;

    private static native void jniSetLongVector(int var0, long[] var1, int var2, int var3, int var4, boolean var5) throws ComJniException;

    private static native void jniSetShortVector(int var0, short[] var1, int var2, int var3, int var4, boolean var5) throws ComJniException;

    private static native void jniSetIntVector(int var0, int[] var1, int var2, int var3, int var4, boolean var5) throws ComJniException;

    private static native void jniSetFloatVector(int var0, float[] var1, int var2, int var3, int var4, boolean var5) throws ComJniException;

    private static native void jniSetDoubleVector(int var0, double[] var1, int var2, int var3, int var4, boolean var5) throws ComJniException;

    private static native boolean[] jniGetBooleanVector(int var0, int var1, int var2) throws ComJniException;

    private static native byte[] jniGetByteVector(int var0, int var1, int var2) throws ComJniException;

    private static native short[] jniGetShortVector(int var0, int var1, int var2) throws ComJniException;

    private static native int[] jniGetIntVector(int var0, int var1, int var2) throws ComJniException;

    private static native long[] jniGetLongVector(int var0, int var1, int var2) throws ComJniException;

    private static native float[] jniGetFloatVector(int var0, int var1, int var2) throws ComJniException;

    private static native double[] jniGetDoubleVector(int var0, int var1, int var2) throws ComJniException;

    private static native int jniCreateBooleanVector(boolean[] var0, short var1) throws ComJniException;

    private static native int jniCreateByteVector(byte[] var0, short var1) throws ComJniException;

    private static native int jniCreateShortVector(short[] var0, short var1) throws ComJniException;

    private static native int jniCreateIntVector(int[] var0, short var1) throws ComJniException;

    private static native int jniCreateLongVector(long[] var0, short var1) throws ComJniException;

    private static native int jniCreateFloatVector(float[] var0, short var1) throws ComJniException;

    private static native int jniCreateDoubleVector(double[] var0, short var1) throws ComJniException;

    private static native int jniCreateVectorFromString(String var0) throws ComJniException;

    private static native String jniGetStringFromVector(int var0) throws ComJniException;

    private static native void jniSetBoolean(int var0, int var1, boolean var2) throws ComJniException;

    private static native void jniSetBooleanEx(int var0, int[] var1, boolean var2) throws ComJniException;

    private static native boolean jniGetBoolean(int var0, int var1) throws ComJniException;

    private static native boolean jniGetBooleanEx(int var0, int[] var1) throws ComJniException;

    private static native void jniSetByte(int var0, int var1, byte var2) throws ComJniException;

    private static native void jniSetByteEx(int var0, int[] var1, byte var2) throws ComJniException;

    private static native byte jniGetByte(int var0, int var1) throws ComJniException;

    private static native byte jniGetByteEx(int var0, int[] var1) throws ComJniException;

    private static native void jniSetShort(int var0, int var1, short var2) throws ComJniException;

    private static native void jniSetShortEx(int var0, int[] var1, short var2) throws ComJniException;

    private static native short jniGetShort(int var0, int var1) throws ComJniException;

    private static native short jniGetShortEx(int var0, int[] var1) throws ComJniException;

    private static native void jniSetInt(int var0, int var1, int var2) throws ComJniException;

    private static native void jniSetIntEx(int var0, int[] var1, int var2) throws ComJniException;

    private static native int jniGetInt(int var0, int var1) throws ComJniException;

    private static native int jniGetIntEx(int var0, int[] var1) throws ComJniException;

    private static native void jniSetLong(int var0, int var1, long var2) throws ComJniException;

    private static native void jniSetLongEx(int var0, int[] var1, long var2) throws ComJniException;

    private static native long jniGetLong(int var0, int var1) throws ComJniException;

    private static native long jniGetLongEx(int var0, int[] var1) throws ComJniException;

    private static native void jniSetFloat(int var0, int var1, float var2) throws ComJniException;

    private static native void jniSetFloatEx(int var0, int[] var1, float var2) throws ComJniException;

    private static native float jniGetFloat(int var0, int var1) throws ComJniException;

    private static native float jniGetFloatEx(int var0, int[] var1) throws ComJniException;

    private static native void jniSetDouble(int var0, int var1, double var2) throws ComJniException;

    private static native void jniSetDoubleEx(int var0, int[] var1, double var2) throws ComJniException;

    private static native double jniGetDouble(int var0, int var1) throws ComJniException;

    private static native double jniGetDoubleEx(int var0, int[] var1) throws ComJniException;

    private static native int jniCreateStringVector(String[] var0, short var1) throws ComJniException;

    private static native String[] jniGetStringVector(int var0, int var1, int var2) throws ComJniException;

    private static native void jniSetStringVector(int var0, String[] var1, int var2, int var3, int var4, boolean var5) throws ComJniException;

    private static native void jniSetString(int var0, int var1, String var2) throws ComJniException;

    private static native void jniSetStringEx(int var0, int[] var1, String var2) throws ComJniException;

    private static native String jniGetString(int var0, int var1) throws ComJniException;

    private static native String jniGetStringEx(int var0, int[] var1) throws ComJniException;

    private static native int jniCreateVariantVector(int[] var0, short var1) throws ComJniException;

    private static native int[] jniGetVariantVector(int var0, int var1, int var2) throws ComJniException;

    private static native void jniSetVariantVector(int var0, int[] var1, int var2, int var3, int var4, boolean var5) throws ComJniException;

    private static native void jniSetVariant(int var0, int var1, int var2) throws ComJniException;

    private static native void jniSetVariantEx(int var0, int[] var1, int var2) throws ComJniException;

    private static native int jniGetVariant(int var0, int var1) throws ComJniException;

    private static native int jniGetVariantEx(int var0, int[] var1) throws ComJniException;

    private static native int jniCreateIUnknownVector(int[] var0, short var1) throws ComJniException;

    private static native int[] jniGetIUnknownVector(int var0, int var1, int var2) throws ComJniException;

    private static native void jniSetIUnknownVector(int var0, int[] var1, int var2, int var3, int var4, boolean var5) throws ComJniException;

    private static native void jniSetIUnknown(int var0, int var1, int var2) throws ComJniException;

    private static native void jniSetIUnknownEx(int var0, int[] var1, int var2) throws ComJniException;

    private static native int jniGetIUnknown(int var0, int var1) throws ComJniException;

    private static native int jniGetIUnknownEx(int var0, int[] var1) throws ComJniException;

    private static native int jniCreateIDispatchVector(int[] var0, short var1) throws ComJniException;

    private static native int[] jniGetIDispatchVector(int var0, int var1, int var2) throws ComJniException;

    private static native void jniSetIDispatchVector(int var0, int[] var1, int var2, int var3, int var4, boolean var5) throws ComJniException;

    private static native void jniSetIDispatch(int var0, int var1, int var2) throws ComJniException;

    private static native void jniSetIDispatchEx(int var0, int[] var1, int var2) throws ComJniException;

    private static native int jniGetIDispatch(int var0, int var1) throws ComJniException;

    private static native int jniGetIDispatchEx(int var0, int[] var1) throws ComJniException;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Dll.start();
    }

    public static class Bound {
        int cElems;
        int lBound;

        public Bound(int n) {
            this.cElems = n;
            this.lBound = 0;
        }

        public Bound(int n, int n2) {
            this.cElems = n2;
            this.lBound = n;
        }

        public int size() {
            return this.cElems;
        }

        public int bound() {
            return this.lBound;
        }

        public int getUBound() {
            return this.lBound + this.cElems - 1;
        }
    }
}

