/*
 * Decompiled with CFR 0.152.
 */
package com.inzoom.comjni;

import com.inzoom.comjni.ComLib;
import com.inzoom.comjni.Dll;

public class NativeMemory {
    static final int PTR_SIZE = 4;
    private int mSize = 0;
    private int mBuf = 0;

    public NativeMemory(int n) {
        if (n > 0) {
            this.mBuf = ComLib.coTaskMemAlloc(n);
            this.mSize = n;
        }
    }

    public NativeMemory() {
    }

    public static NativeMemory coTaskMemAlloc(int n) {
        int n2 = ComLib.coTaskMemAlloc(n);
        if (n2 == 0) {
            return null;
        }
        NativeMemory nativeMemory = new NativeMemory();
        nativeMemory.initializeBuffer(n2, n);
        return nativeMemory;
    }

    public void initializeBuffer(int n) {
        this.mBuf = n;
        this.mSize = this.mBuf == 0 ? 0 : -1;
    }

    public void initializeBuffer(int n, int n2) {
        this.mBuf = n;
        this.mSize = n2;
    }

    public NativeMemory(byte[] byArray) {
        if (byArray != null && byArray.length > 0) {
            this.mBuf = NativeMemory.jniCoAllocBytes(byArray);
            this.mSize = byArray.length;
        }
    }

    public NativeMemory(boolean[] blArray) {
        if (blArray != null && blArray.length > 0) {
            this.mBuf = NativeMemory.jniCoAllocBooleans(blArray);
            this.mSize = blArray.length * 2;
        }
    }

    public NativeMemory(short[] sArray) {
        if (sArray != null && sArray.length > 0) {
            this.mBuf = NativeMemory.jniCoAllocShorts(sArray);
            this.mSize = sArray.length * 2;
        }
    }

    public NativeMemory(int[] nArray) {
        if (nArray != null && nArray.length > 0) {
            this.mBuf = NativeMemory.jniCoAllocInts(nArray);
            this.mSize = nArray.length * 4;
        }
    }

    public NativeMemory(long[] lArray) {
        if (lArray != null && lArray.length > 0) {
            this.mBuf = NativeMemory.jniCoAllocLongs(lArray);
            this.mSize = lArray.length * 8;
        }
    }

    public NativeMemory(float[] fArray) {
        if (fArray != null && fArray.length > 0) {
            this.mBuf = NativeMemory.jniCoAllocFloats(fArray);
            this.mSize = fArray.length * 4;
        }
    }

    public NativeMemory(double[] dArray) {
        if (dArray != null && dArray.length > 0) {
            this.mBuf = NativeMemory.jniCoAllocDoubles(dArray);
            this.mSize = dArray.length * 8;
        }
    }

    public NativeMemory(String string, int n) {
        if (string != null) {
            int n2 = 0;
            int n3 = 0;
            switch (n) {
                case 8: {
                    n3 = 2;
                    n2 = NativeMemory.jniSysAllocBSTR(string);
                    break;
                }
                case 30: {
                    n3 = 1;
                    n2 = NativeMemory.jniCoAllocLPSTR(string);
                    break;
                }
                case 31: {
                    n3 = 2;
                    n2 = NativeMemory.jniCoAllocLPWSTR(string);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid vartype " + n);
                }
            }
            if (n2 != 0) {
                this.initializeBuffer(n2, (string.length() + 1) * n3);
            }
        }
    }

    public NativeMemory(String string) {
        this(string, 8);
    }

    public NativeMemory(String[] stringArray) {
        this(stringArray, 8);
    }

    public NativeMemory(String[] stringArray, int n) {
        if (stringArray != null && stringArray.length > 0) {
            int n2 = 0;
            switch (n) {
                case 8: {
                    n2 = NativeMemory.jniCoAllocBSTRs(stringArray);
                    break;
                }
                case 30: {
                    n2 = NativeMemory.jniCoAllocLPSTRs(stringArray);
                    break;
                }
                case 31: {
                    n2 = NativeMemory.jniCoAllocLPWSTRs(stringArray);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid vartype " + n);
                }
            }
            if (n2 != 0) {
                this.initializeBuffer(n2, stringArray.length * 4);
            }
        }
    }

    public byte[] getBytes(int n) {
        if (this.mBuf == 0) {
            return null;
        }
        byte[] byArray = new byte[n];
        NativeMemory.jniGetBytes(this.mBuf, byArray, false);
        return byArray;
    }

    public short[] getShorts(int n) {
        if (this.mBuf == 0) {
            return null;
        }
        short[] sArray = new short[n];
        NativeMemory.jniGetShorts(this.mBuf, sArray, false);
        return sArray;
    }

    public boolean[] getBooleans(int n) {
        if (this.mBuf == 0) {
            return null;
        }
        boolean[] blArray = new boolean[n];
        NativeMemory.jniGetBooleans(this.mBuf, blArray, false);
        return blArray;
    }

    public int[] getInts(int n) {
        if (this.mBuf == 0) {
            return null;
        }
        int[] nArray = new int[n];
        NativeMemory.jniGetInts(this.mBuf, nArray, false);
        return nArray;
    }

    public long[] getLongs(int n) {
        if (this.mBuf == 0) {
            return null;
        }
        long[] lArray = new long[n];
        NativeMemory.jniGetLongs(this.mBuf, lArray, false);
        return lArray;
    }

    public float[] getFloats(int n) {
        if (this.mBuf == 0) {
            return null;
        }
        float[] fArray = new float[n];
        NativeMemory.jniGetFloats(this.mBuf, fArray, false);
        return fArray;
    }

    public double[] getDoubles(int n) {
        if (this.mBuf == 0) {
            return null;
        }
        double[] dArray = new double[n];
        NativeMemory.jniGetDoubles(this.mBuf, dArray, false);
        return dArray;
    }

    public String getString(short s) {
        if (this.mBuf == 0) {
            return null;
        }
        switch (s) {
            case 8: 
            case 31: {
                return NativeMemory.jniGetWSTR(this.mBuf, false);
            }
            case 30: {
                return NativeMemory.jniGetASTR(this.mBuf, false);
            }
        }
        throw new IllegalArgumentException("invalid vartype " + s);
    }

    public String[] getStrings(int n) {
        return this.getStrings(n, (short)8);
    }

    public String[] getStrings(int n, short s) {
        if (this.mBuf == 0) {
            return null;
        }
        String[] stringArray = new String[n];
        NativeMemory.jniGetStrings(this.mBuf, stringArray, false, s);
        return stringArray;
    }

    public void coTaskMemFree() {
        if (this.mBuf != 0) {
            ComLib.coTaskMemFree(this.mBuf);
            this.mBuf = 0;
            this.mSize = 0;
        }
    }

    public void coTaskMemFreePointers(int n, boolean bl) {
        NativeMemory.jniCoMemFreePtrs(this.mBuf, n);
        if (bl) {
            this.coTaskMemFree();
        }
    }

    public void freeStrings(int n, short s, boolean bl) {
        switch (s) {
            case 8: {
                this.freeBSTRs(n, bl);
                break;
            }
            case 30: 
            case 31: {
                this.coTaskMemFreePointers(n, bl);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid vartype " + s);
            }
        }
        if (bl) {
            this.coTaskMemFree();
        }
    }

    public void freeString(int n) {
        switch (n) {
            case 8: {
                NativeMemory.jniFreeBSTR(this.getBuffer());
                this.initializeBuffer(0, 0);
                break;
            }
            case 30: 
            case 31: {
                this.coTaskMemFree();
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid vartype " + n);
            }
        }
    }

    public void freeBSTRs(int n, boolean bl) {
        NativeMemory.jniFreeBSTRs(this.getBuffer(), n);
        if (bl) {
            this.coTaskMemFree();
        }
    }

    public int getSizeInBytes() {
        return this.mSize;
    }

    public int getSizeInPointers() {
        return this.getSize(4);
    }

    public int getSizeInShorts() {
        return this.getSize(2);
    }

    public int getSizeInInts() {
        return this.getSize(4);
    }

    public int getSizeInLongs() {
        return this.getSize(8);
    }

    public int getSizeInFloats() {
        return this.getSize(4);
    }

    public int getSizeInDoubles() {
        return this.getSize(8);
    }

    public int getSizeInBooleans() {
        return this.getSize(2);
    }

    public int getSizeInStrings() {
        return this.getSizeInPointers();
    }

    protected int getSize(int n) {
        if (this.mSize == -1) {
            return -1;
        }
        int n2 = this.mSize / n;
        if (n2 * n != this.mSize) {
            throw new IndexOutOfBoundsException("Buffer size is not a multiple of unit size");
        }
        return n2;
    }

    public int getBuffer() {
        return this.mBuf;
    }

    public static native int jniCoAllocBytes(byte[] var0);

    public static native int jniCoAllocShorts(short[] var0);

    public static native int jniCoAllocInts(int[] var0);

    public static native int jniCoAllocLongs(long[] var0);

    public static native int jniCoAllocFloats(float[] var0);

    public static native int jniCoAllocDoubles(double[] var0);

    public static native int jniCoAllocBooleans(boolean[] var0);

    public static native int jniCoAllocBSTRs(String[] var0);

    public static native int jniCoAllocLPWSTRs(String[] var0);

    public static native int jniCoAllocLPSTRs(String[] var0);

    public static native int jniSysAllocBSTR(String var0);

    public static native int jniCoAllocLPWSTR(String var0);

    public static native int jniCoAllocLPSTR(String var0);

    public static native byte jniGetByte(int var0);

    public static native void jniSetByte(int var0, byte var1);

    public static native boolean jniGetBoolean(int var0);

    public static native void jniSetBoolean(int var0, boolean var1);

    public static native short jniGetShort(int var0);

    public static native void jniSetShort(int var0, short var1);

    public static native int jniGetInt(int var0);

    public static native void jniSetInt(int var0, int var1);

    public static native long jniGetLong(int var0);

    public static native void jniSetLong(int var0, long var1);

    public static native float jniGetFloat(int var0);

    public static native void jniSetFloat(int var0, float var1);

    public static native double jniGetDouble(int var0);

    public static native void jniSetDouble(int var0, double var1);

    public static String jniGetASTR(int n, boolean bl) {
        return NativeMemory.jniGetString(n, bl, (short)30);
    }

    public static String jniGetWSTR(int n, boolean bl) {
        return NativeMemory.jniGetString(n, bl, (short)31);
    }

    public static String jniGetBSTR(int n, boolean bl) {
        return NativeMemory.jniGetString(n, bl, (short)8);
    }

    public static native String jniGetString(int var0, boolean var1, short var2);

    public static native void jniReplaceString(int var0, String var1, short var2);

    public static native void jniGetBytes(int var0, byte[] var1, boolean var2);

    public static native void jniGetShorts(int var0, short[] var1, boolean var2);

    public static native void jniGetInts(int var0, int[] var1, boolean var2);

    public static native void jniGetLongs(int var0, long[] var1, boolean var2);

    public static native void jniGetFloats(int var0, float[] var1, boolean var2);

    public static native void jniGetDoubles(int var0, double[] var1, boolean var2);

    public static native void jniGetBooleans(int var0, boolean[] var1, boolean var2);

    public static native void jniGetStrings(int var0, String[] var1, boolean var2, short var3);

    public static native String jniGetStringAt(int var0, int var1, short var2);

    public static native void jniSetBytes(int var0, byte[] var1, boolean var2);

    public static native void jniSetShorts(int var0, short[] var1, boolean var2);

    public static native void jniSetInts(int var0, int[] var1, boolean var2);

    public static native void jniSetLongs(int var0, long[] var1, boolean var2);

    public static native void jniSetFloats(int var0, float[] var1, boolean var2);

    public static native void jniSetDoubles(int var0, double[] var1, boolean var2);

    public static native void jniSetBooleans(int var0, boolean[] var1, boolean var2);

    public static native void jniSetStrings(int var0, String[] var1, boolean var2, short var3);

    public static native void jniSetComPtr(int var0, int var1, boolean var2, boolean var3);

    public static native void jniSetComPtrs(int var0, int[] var1, boolean var2, boolean var3);

    public static native void jniSetStringAt(int var0, int var1, String var2, boolean var3, short var4);

    public static native void jniMemCopy(int var0, int var1, int var2);

    public static native void jniCoAllocBytesByRef(int var0, byte[] var1, boolean var2);

    public static native void jniCoAllocShortsByRef(int var0, short[] var1, boolean var2);

    public static native void jniCoAllocIntsByRef(int var0, int[] var1, boolean var2);

    public static native void jniCoAllocLongsByRef(int var0, long[] var1, boolean var2);

    public static native void jniCoAllocFloatsByRef(int var0, float[] var1, boolean var2);

    public static native void jniCoAllocDoublesByRef(int var0, double[] var1, boolean var2);

    public static native void jniCoAllocBooleansByRef(int var0, boolean[] var1, boolean var2);

    public static native void jniCoMemFreePtrs(int var0, int var1);

    public static native void jniFreeBSTRs(int var0, int var1);

    public static native void jniFreeBSTR(int var0);

    static {
        Dll.start();
    }
}

