/*
 * Decompiled with CFR 0.152.
 */
package com.inzoom.comjni;

import com.inzoom.comjni.ComJniException;
import com.inzoom.comjni.Documentation;
import com.inzoom.comjni.ElemDesc;
import com.inzoom.comjni.ITypeInfo;
import com.inzoom.comjni._StructWrapper;
import com.inzoom.comjni.jcw.ITypeInfoJCW;
import java.util.Vector;

public class FuncDesc
extends _StructWrapper {
    int mParentPtr;
    int mPtr;

    public static FuncDesc getFuncDescFromPtr(int n, ITypeInfo iTypeInfo) {
        return n == 0 ? null : new FuncDesc(n, iTypeInfo);
    }

    FuncDesc(int n, ITypeInfo iTypeInfo) {
        this.mParentPtr = iTypeInfo.getAddRefPtr();
        this.mPtr = n;
    }

    public FuncDesc() {
        this.mParentPtr = 0;
        this.mPtr = FuncDesc.jniCreateFuncDesc();
    }

    protected void finalize() {
        this.release();
    }

    void checkValid() throws NullPointerException {
        if (this.mPtr == 0) {
            throw new NullPointerException(this.getClass().getName());
        }
    }

    public Documentation getDocumentation() throws NullPointerException, ComJniException {
        this.checkValid();
        if (this.mParentPtr == 0) {
            throw new NullPointerException();
        }
        return ITypeInfoJCW.getITypeInfoFromPtr(this.mParentPtr, true).getDocumentation(this.getMemid());
    }

    public int getMemid() throws NullPointerException {
        this.checkValid();
        return FuncDesc.jniGetMemid(this.mPtr);
    }

    public void setMemid(int n) throws NullPointerException {
        this.checkValid();
        FuncDesc.jniSetMemid(this.mPtr, n);
    }

    public int getFuncKind() throws NullPointerException {
        this.checkValid();
        return FuncDesc.jniGetFuncKind(this.mPtr);
    }

    public void setFuncKind(int n) throws NullPointerException {
        this.checkValid();
        FuncDesc.jniSetFuncKind(this.mPtr, n);
    }

    public int getInvKind() throws NullPointerException {
        this.checkValid();
        return FuncDesc.jniGetInvKind(this.mPtr);
    }

    public void setInvKind(int n) throws NullPointerException {
        this.checkValid();
        FuncDesc.jniSetInvKind(this.mPtr, n);
    }

    public int getCallConv() throws NullPointerException {
        this.checkValid();
        return FuncDesc.jniGetCallConv(this.mPtr);
    }

    public void setCallConv(int n) throws NullPointerException {
        this.checkValid();
        FuncDesc.jniSetCallConv(this.mPtr, n);
    }

    public short getParamCount() throws NullPointerException {
        this.checkValid();
        return FuncDesc.jniGetCParams(this.mPtr);
    }

    public short getCParamsOpt() throws NullPointerException {
        this.checkValid();
        return FuncDesc.jniGetCParamsOpt(this.mPtr);
    }

    public short getOVft() throws NullPointerException {
        this.checkValid();
        return FuncDesc.jniGetOVft(this.mPtr);
    }

    public ElemDesc getElemDescFunc() throws NullPointerException {
        this.checkValid();
        return new ElemDesc(FuncDesc.jniGetElemDescFunc(this.mPtr), this);
    }

    public ElemDesc[] getElemDescParam() throws NullPointerException {
        this.checkValid();
        int[] nArray = FuncDesc.jniGetElemDescParam(this.mPtr);
        ElemDesc[] elemDescArray = new ElemDesc[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            elemDescArray[i] = new ElemDesc(nArray[i], this);
        }
        return elemDescArray;
    }

    public void setElemDescParam(ElemDesc[] elemDescArray) throws NullPointerException {
        this.checkValid();
        int[] nArray = new int[elemDescArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = elemDescArray[i].mPtr;
        }
        FuncDesc.jniSetElemDescParam(this.mPtr, nArray);
    }

    public void setElemDescParam(Vector vector) throws NullPointerException {
        this.checkValid();
        int[] nArray = new int[vector.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = ((ElemDesc)vector.elementAt((int)i)).mPtr;
        }
        FuncDesc.jniSetElemDescParam(this.mPtr, nArray);
    }

    public int getFuncFlags() throws NullPointerException {
        this.checkValid();
        return FuncDesc.jniGetFuncFlags(this.mPtr);
    }

    public synchronized void release() {
        if (this.mPtr != 0) {
            if (this.mParentPtr != 0) {
                ((ITypeInfoJCW)ITypeInfoJCW.getITypeInfoFromPtr(this.mParentPtr, false)).releaseFuncDesc(this.mPtr);
            } else {
                FuncDesc.jniDeleteFuncDesc(this.mPtr);
            }
            this.mPtr = 0;
            this.mParentPtr = 0;
        }
    }

    public String toString() {
        try {
            return "FuncDesc: " + this.getDocumentation().name;
        }
        catch (Throwable throwable) {
            return super.toString();
        }
    }

    public int getPtr() {
        return this.mPtr;
    }

    private static native int jniGetMemid(int var0);

    private static native void jniSetMemid(int var0, int var1);

    private static native int jniGetFuncKind(int var0);

    private static native void jniSetFuncKind(int var0, int var1);

    private static native int jniGetInvKind(int var0);

    private static native void jniSetInvKind(int var0, int var1);

    private static native int jniGetCallConv(int var0);

    private static native void jniSetCallConv(int var0, int var1);

    private static native short jniGetCParams(int var0);

    private static native short jniGetCParamsOpt(int var0);

    private static native short jniGetOVft(int var0);

    private static native int jniGetFuncFlags(int var0);

    private static native int jniGetElemDescFunc(int var0);

    private static native int[] jniGetElemDescParam(int var0);

    private static native void jniSetElemDescParam(int var0, int[] var1);

    private static native int jniCreateFuncDesc();

    private static native void jniDeleteFuncDesc(int var0);
}

