/*
 * Decompiled with CFR 0.152.
 */
package com.inzoom.axjni;

import com.inzoom.axjni.FocusProcessor;
import com.inzoom.axjni.IWinSurfaceWrap;
import com.inzoom.axjni.impl.IWinSurface;
import com.inzoom.win.Util;
import java.awt.Component;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.PrintStream;

abstract class WinSurfaceWrap
implements IWinSurfaceWrap {
    PrintStream m_ps = System.out;
    FocusProcessor m_FocusProcessor = new FocusProcessor();
    boolean m_bAllowReparenting = false;
    Component m_parent;
    HierarchyProcessor m_hierarchyProcessor = new HierarchyProcessor();

    WinSurfaceWrap(Component component) {
        this.m_parent = component;
    }

    public boolean getAllowReparenting() {
        return this.m_bAllowReparenting;
    }

    public void setAllowReparenting(boolean bl) {
        this.m_bAllowReparenting = bl;
    }

    public void resizeSurface() {
        IWinSurface iWinSurface = this.getWinSurface();
        if (iWinSurface != null) {
            try {
                iWinSurface.resize();
            }
            catch (Exception exception) {
                exception.printStackTrace(this.m_ps);
            }
        }
    }

    public void onPaint() {
        this.m_hierarchyProcessor.onPaint();
    }

    public int getUnmarshalledControlPtr() {
        IWinSurface iWinSurface = this.getWinSurface();
        if (iWinSurface != null) {
            try {
                return iWinSurface.getUnmarshalledRawUnknown();
            }
            catch (Exception exception) {
                exception.printStackTrace(this.m_ps);
            }
        }
        return 0;
    }

    void onAddNotify() {
        IWinSurface iWinSurface = this.getWinSurface();
        if (iWinSurface == null) {
            if (this.init()) {
                this.m_hierarchyProcessor.start();
                this.m_FocusProcessor.startProcess(this);
                if (this.m_parent != null) {
                    this.setVisible(this.m_parent.isShowing());
                }
            }
        } else {
            try {
                iWinSurface.setParent(this.getHWND());
            }
            catch (Exception exception) {
                exception.printStackTrace(this.m_ps);
            }
            if (this.m_parent != null) {
                this.setVisible(this.m_parent.isShowing());
            }
        }
    }

    public void release() {
        IWinSurface iWinSurface = this.getWinSurface();
        if (iWinSurface != null) {
            try {
                if (this.m_parent != null) {
                    this.m_hierarchyProcessor.stop();
                    this.m_FocusProcessor.stopProcess(this.m_parent);
                }
                iWinSurface.destroy();
                this.done();
            }
            catch (Exception exception) {
                exception.printStackTrace(this.m_ps);
            }
        }
    }

    void onRemoveNotify() {
        if (this.m_bAllowReparenting) {
            IWinSurface iWinSurface = this.getWinSurface();
            if (iWinSurface != null) {
                this.setVisible(false);
                try {
                    iWinSurface.setParent(0);
                }
                catch (Exception exception) {
                    exception.printStackTrace(this.m_ps);
                }
            }
        } else {
            this.release();
        }
    }

    public void setVisible(boolean bl) {
        IWinSurface iWinSurface = this.getWinSurface();
        if (iWinSurface != null) {
            try {
                iWinSurface.setVisible(bl);
            }
            catch (Exception exception) {
                exception.printStackTrace(this.m_ps);
            }
        }
    }

    protected synchronized void finalize() {
        IWinSurface iWinSurface = this.getWinSurface();
        if (iWinSurface != null) {
            try {
                iWinSurface.destroy();
            }
            catch (Exception exception) {
                exception.printStackTrace(this.m_ps);
            }
        }
    }

    int getHWND() {
        return Util.getHWND(this.m_parent);
    }

    void applyShowing() {
        if (this.m_parent != null) {
            this.setVisible(this.m_parent.isShowing());
        }
    }

    public void call(Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException();
        }
        IWinSurface iWinSurface = this.getWinSurface();
        if (iWinSurface != null) {
            WinSurfaceWrap.jniCall(runnable, iWinSurface.getPtr());
        }
    }

    static native void jniCall(Runnable var0, int var1);

    public Component getParent() {
        return this.m_parent;
    }

    public PrintStream getDebugOutStream() {
        return this.m_ps;
    }

    public void setDebugOutStream(PrintStream printStream) {
        this.m_ps = printStream;
    }

    public abstract /* synthetic */ IWinSurface getWinSurface();

    public abstract /* synthetic */ void done();

    public abstract /* synthetic */ boolean init();

    public abstract /* synthetic */ void deactivate();

    public abstract /* synthetic */ void activate();

    class InternalHierarchyListener
    implements HierarchyListener {
        InternalHierarchyListener() {
        }

        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            if (WinSurfaceWrap.this.m_parent != null) {
                WinSurfaceWrap.this.setVisible(WinSurfaceWrap.this.m_parent.isShowing());
            }
        }
    }

    class HierarchyProcessor {
        Object m_listener;

        HierarchyProcessor() {
            try {
                Class<?> clazz = Class.forName("java.awt.event.HierarchyListener");
                if (clazz != null) {
                    this.m_listener = new InternalHierarchyListener();
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.m_listener = null;
            }
        }

        void start() {
            if (this.m_listener != null && WinSurfaceWrap.this.m_parent != null) {
                WinSurfaceWrap.this.m_parent.addHierarchyListener((HierarchyListener)this.m_listener);
            }
        }

        void stop() {
            if (this.m_listener != null && WinSurfaceWrap.this.m_parent != null) {
                WinSurfaceWrap.this.m_parent.removeHierarchyListener((HierarchyListener)this.m_listener);
            }
        }

        void onPaint() {
            if (this.m_listener == null) {
                WinSurfaceWrap.this.applyShowing();
            }
        }
    }
}

