/*
 * Decompiled with CFR 0.152.
 */
package com.inzoom.axjni;

import com.inzoom.axjni.IWinSurfaceJWrap;
import com.inzoom.axjni.IWinSurfaceWrap;
import com.inzoom.axjni.impl.IWinSurface;
import com.inzoom.win.SurfaceInfo;
import com.inzoom.win.Util;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JRootPane;

abstract class WinSurfaceJWrap
implements IWinSurfaceJWrap {
    Point m_LastOffset = new Point();

    WinSurfaceJWrap() {
    }

    public void setSize(int n, int n2) {
        IWinSurfaceWrap iWinSurfaceWrap = this.getWrap();
        if (iWinSurfaceWrap == null) {
            return;
        }
        if (iWinSurfaceWrap.getWinSurface() != null) {
            try {
                iWinSurfaceWrap.getWinSurface().setSize(n, n2);
            }
            catch (Exception exception) {
                exception.printStackTrace(iWinSurfaceWrap.getDebugOutStream());
            }
        }
    }

    public void internalSetBounds(int n, int n2, int n3, int n4, Point point) {
        IWinSurfaceWrap iWinSurfaceWrap = this.getWrap();
        if (iWinSurfaceWrap == null) {
            return;
        }
        IWinSurface iWinSurface = iWinSurfaceWrap.getWinSurface();
        if (iWinSurface == null) {
            return;
        }
        int n5 = n;
        int n6 = n2;
        Component component = iWinSurfaceWrap.getParent();
        if (component != null) {
            try {
                Object object;
                if (point == null) {
                    object = Util.getJSurfaceInfo(component);
                    if (object != null) {
                        this.m_LastOffset.x = object.getOffsetX();
                        n5 += this.m_LastOffset.x;
                        this.m_LastOffset.y = object.getOffsetY();
                        n6 += this.m_LastOffset.y;
                    }
                } else {
                    this.m_LastOffset.x = point.x;
                    n5 += this.m_LastOffset.x;
                    this.m_LastOffset.y = point.y;
                    n6 += this.m_LastOffset.y;
                }
                object = this.getRootPaneLocation();
                iWinSurface.setBounds(n5 - ((Point)object).x, n6 - ((Point)object).y, n3, n4);
            }
            catch (Exception exception) {
                exception.printStackTrace(iWinSurfaceWrap.getDebugOutStream());
            }
        }
    }

    Point getRootPaneLocation() {
        JComponent jComponent = (JComponent)this.getWrap().getParent();
        JRootPane jRootPane = jComponent.getRootPane();
        if (jRootPane == null) {
            return new Point();
        }
        Point point = jRootPane.getLocation();
        for (Container container = jRootPane.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof JRootPane)) continue;
            point = ((JRootPane)container).getLocation();
        }
        return point;
    }

    public void onPaint(Graphics graphics) {
        IWinSurfaceWrap iWinSurfaceWrap = this.getWrap();
        if (iWinSurfaceWrap == null) {
            return;
        }
        iWinSurfaceWrap.onPaint();
        Component component = iWinSurfaceWrap.getParent();
        if (component == null) {
            return;
        }
        if (!component.isShowing()) {
            return;
        }
        SurfaceInfo surfaceInfo = Util.getJSurfaceInfoLight(component);
        if (surfaceInfo.getOffsetX() != this.m_LastOffset.x || surfaceInfo.getOffsetY() != this.m_LastOffset.y) {
            this.revalidateOn(component.getBounds(), new Point(surfaceInfo.getOffsetX(), surfaceInfo.getOffsetY()));
        }
    }

    void revalidateOn(Rectangle rectangle, Point point) {
        this.internalSetBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height, point);
    }

    public void revalidate() {
        IWinSurfaceWrap iWinSurfaceWrap = this.getWrap();
        if (iWinSurfaceWrap == null) {
            return;
        }
        Component component = iWinSurfaceWrap.getParent();
        if (component == null) {
            return;
        }
        SurfaceInfo surfaceInfo = Util.getJSurfaceInfoLight(component);
        this.revalidateOn(component.getBounds(), new Point(surfaceInfo.getOffsetX(), surfaceInfo.getOffsetY()));
    }

    public abstract /* synthetic */ IWinSurfaceWrap getWrap();
}

