/*
 * Decompiled with CFR 0.152.
 */
package com.inzoom.axjni;

import com.inzoom.axjni.AxEventHelper;
import com.inzoom.axjni.IAxEventHelp;
import com.inzoom.axjni.WinSurfaceWrap;
import com.inzoom.axjni.impl.AxCreator;
import com.inzoom.axjni.impl.ICallbackSupport;
import com.inzoom.axjni.impl.IOleDoc;
import com.inzoom.axjni.impl.IWinSurface;
import com.inzoom.axjni.impl.impl.ICallbackSupportHandlerImpl;
import com.inzoom.comjni.ComJniException;
import com.inzoom.comjni.IDispatch;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

class ODWrap
extends WinSurfaceWrap
implements ICallbackSupport,
AWTEventListener {
    IOleDoc m_doc;
    String m_strDocServer;
    AxEventHelper m_listenerHelp = new AxEventHelper();
    ActivateListener m_activateListener = new ActivateListener();
    ICallbackSupportHandlerImpl m_callbackHandler = new ICallbackSupportHandlerImpl(this);

    ODWrap(Component component) {
        super(component);
    }

    public void setDocumentServer(String string) {
        this.m_strDocServer = string;
    }

    public IOleDoc getOleDoc() {
        return this.m_doc;
    }

    public IAxEventHelp getListenerHelper() {
        return this.m_listenerHelp;
    }

    public boolean init() {
        try {
            AxCreator axCreator = new AxCreator();
            int n = this.getHWND();
            Rectangle rectangle = this.m_parent.getBounds();
            this.m_doc = axCreator.createDoc(n, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            this.m_callbackHandler.advise(this.m_doc, ICallbackSupport.DIID);
            if (this.m_strDocServer != null) {
                this.m_parent.requestFocus();
                this.m_doc.createNew(this.m_strDocServer);
            }
            axCreator.release();
            this.m_listenerHelp.init(this.m_parent);
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace(this.m_ps);
            return false;
        }
    }

    public void done() {
        this.m_listenerHelp.done(this.m_parent);
        if (this.m_doc != null) {
            try {
                this.m_callbackHandler.unAdvise(this.m_doc);
                this.m_doc.release();
                this.m_doc = null;
            }
            catch (Exception exception) {
                exception.printStackTrace(this.m_ps);
            }
        }
    }

    public IWinSurface getWinSurface() {
        return this.m_doc;
    }

    public void activate() {
        if (this.m_doc != null) {
            try {
                this.m_doc.activate();
            }
            catch (Exception exception) {
                exception.printStackTrace(this.m_ps);
            }
        }
    }

    public void deactivate() {
        try {
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 4L);
        }
        catch (Exception exception) {
            this.m_ps.println("OleDocument focus tracking(needed on application switch )supported only for JDK >=1.2");
            exception.printStackTrace(this.m_ps);
        }
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 4L);
        } else {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        }
    }

    public void eventDispatched(AWTEvent aWTEvent) {
        if (this.m_doc != null && aWTEvent.getSource() != this.m_parent) {
            try {
                this.m_doc.deactivate();
                Toolkit.getDefaultToolkit().removeAWTEventListener(this);
            }
            catch (Exception exception) {
                exception.printStackTrace(this.m_ps);
            }
        }
    }

    public void onSetMenu(int n, int n2) {
    }

    public void onActivate(boolean bl) {
        if (this.m_doc != null && this.m_parent.isShowing()) {
            this.m_parent.requestFocus();
            try {
                this.m_doc.activate();
            }
            catch (Exception exception) {
                exception.printStackTrace(this.m_ps);
            }
        }
    }

    void resizeControl() {
        if (this.m_doc != null) {
            try {
                this.m_doc.resize();
            }
            catch (Exception exception) {
                exception.printStackTrace(this.m_ps);
            }
        }
    }

    public IDispatch getDocument() {
        if (this.m_doc != null) {
            try {
                return this.m_doc.getDocument();
            }
            catch (Exception exception) {
                exception.printStackTrace(this.m_ps);
            }
        }
        return null;
    }

    public void onAddNotify() {
        super.onAddNotify();
        this.m_activateListener.attachWindowListener();
    }

    public void onRemoveNotify() {
        super.onRemoveNotify();
        this.m_activateListener.detachWindowListener();
    }

    public void create(String string) throws ComJniException {
        this.m_parent.requestFocus();
        if (this.m_doc == null) {
            this.m_strDocServer = string;
        } else {
            this.m_doc.createNew(string);
        }
    }

    public void call(Runnable runnable) {
        if (this.m_doc != null) {
            super.call(runnable);
        }
    }

    public boolean processEvent(AWTEvent aWTEvent) {
        return this.m_listenerHelp.processEvent(aWTEvent);
    }

    class ActivateListener
    extends WindowAdapter {
        Window m_wnd = null;

        ActivateListener() {
        }

        boolean attachWindowListener() {
            for (Container container = ODWrap.this.m_parent.getParent(); container != null; container = container.getParent()) {
                if (!(container instanceof Window)) continue;
                this.m_wnd = (Window)container;
                this.m_wnd.addWindowListener(this);
                return true;
            }
            return false;
        }

        boolean detachWindowListener() {
            if (this.m_wnd == null) {
                return false;
            }
            this.m_wnd.removeWindowListener(this);
            return true;
        }

        public void windowDeactivated(WindowEvent windowEvent) {
            if (ODWrap.this.m_doc != null) {
                try {
                    ODWrap.this.m_doc.appActivate(false);
                }
                catch (Exception exception) {
                    exception.printStackTrace(ODWrap.this.m_ps);
                }
            }
        }

        public void windowActivated(WindowEvent windowEvent) {
            if (ODWrap.this.m_doc != null) {
                try {
                    ODWrap.this.m_doc.appActivate(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace(ODWrap.this.m_ps);
                }
            }
        }
    }
}

