/*
 * Decompiled with CFR 0.152.
 */
package com.inzoom.axjni;

import com.inzoom.axjni.WinSurfaceWrap;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.Vector;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class JScrollProcessor {
    WinSurfaceWrap m_sf;
    Vector m_scrolls;

    JScrollProcessor() {
    }

    public void startProcess(WinSurfaceWrap winSurfaceWrap) {
        if (winSurfaceWrap == null) {
            throw new IllegalArgumentException("Argument must be not null.");
        }
        this.m_sf = winSurfaceWrap;
        this.refreshParent(winSurfaceWrap.m_parent.getParent());
    }

    public void refreshParent(Component component) {
        this.clear();
        this.m_scrolls = new Vector();
        for (Component component2 = component; component2 != null; component2 = component2.getParent()) {
            if (!(component2 instanceof JScrollPane)) continue;
            this.addPane((JScrollPane)component2);
        }
    }

    public boolean isAktiv() {
        return this.m_scrolls == null ? false : !this.m_scrolls.isEmpty();
    }

    void addPane(JScrollPane jScrollPane) {
        this.m_scrolls.addElement(new JScrollPaneProcessor(jScrollPane));
    }

    public void stopProcess() {
        this.clear();
        this.m_sf = null;
    }

    void clear() {
        if (this.m_scrolls == null) {
            return;
        }
        int n = this.m_scrolls.size();
        for (int i = 0; i < n; ++i) {
            ((JScrollPaneProcessor)this.m_scrolls.elementAt(i)).clear();
        }
        this.m_scrolls = null;
    }

    void scroll() {
        ScrollData scrollData = new ScrollData(this.m_sf.m_parent.getBounds());
        Component component = this.m_sf.m_parent;
        Point point = new Point();
        Point point2 = null;
        boolean bl = true;
        while ((component = component.getParent()) != null) {
            if (component instanceof JViewport) {
                scrollData.intersection((JViewport)component);
            }
            point2 = component.getLocation();
            if (component instanceof JRootPane) {
                point.translate(point2.x - point.x, point2.y - point.y);
            }
            scrollData.move(point2);
            if (!(component instanceof Window)) continue;
        }
        scrollData.move(new Point(-point.x, -point.y));
        if (point2 != null) {
            scrollData.move(new Point(-point2.x, -point2.y));
        }
        try {
            this.m_sf.getWinSurface().clip(scrollData.m_location.x, scrollData.m_location.y, this.m_sf.m_parent.getBounds().width, this.m_sf.m_parent.getBounds().height, scrollData.m_clip.x, scrollData.m_clip.y, scrollData.m_clip.width, scrollData.m_clip.height);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    class JScrollPaneProcessor
    implements ChangeListener {
        JScrollPane m_Pane;

        JScrollPaneProcessor(JScrollPane jScrollPane) {
            this.m_Pane = jScrollPane;
            this.m_Pane.getViewport().addChangeListener(this);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JScrollProcessor.this.scroll();
        }

        void clear() {
            this.m_Pane.getViewport().removeChangeListener(this);
            this.m_Pane = null;
        }
    }

    class ScrollData {
        Point m_location;
        Rectangle m_bounds;
        Rectangle m_clip;

        ScrollData(Rectangle rectangle) {
            this.m_location = rectangle.getLocation();
            this.m_bounds = rectangle.getBounds();
            this.m_clip = new Rectangle(rectangle.getSize());
        }

        void move(Point point) {
            this.moveLocation(point);
            Point point2 = this.m_bounds.getLocation();
            point2.x += point.x;
            point2.y += point.y;
            this.m_bounds.setLocation(point2);
        }

        void moveLocation(Point point) {
            this.m_location.x += point.x;
            this.m_location.y += point.y;
        }

        void intersection(JViewport jViewport) {
            Point point = jViewport.getView().getLocation();
            this.m_bounds.x -= point.x;
            this.m_bounds.y -= point.y;
            Rectangle rectangle = jViewport.getViewRect().intersection(this.m_bounds);
            this.m_clip.x += rectangle.x - this.m_bounds.x;
            this.m_clip.y += rectangle.y - this.m_bounds.y;
            this.m_clip.width -= this.m_bounds.width - rectangle.width;
            this.m_clip.height -= this.m_bounds.height - rectangle.height;
            this.m_bounds = rectangle;
            this.m_bounds.x += point.x;
            this.m_bounds.y += point.y;
        }
    }
}

