/*
 * Decompiled with CFR 0.152.
 */
package com.inzoom.axjni;

import com.inzoom.axjni.IAxEventHelp;
import com.inzoom.axjni.event.AxEvent;
import com.inzoom.axjni.event.AxEventListener;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Toolkit;
import java.util.Vector;

class AxEventHelper
implements IAxEventHelp {
    AxEventListener m_listener = null;
    boolean m_bDoneFired = false;

    AxEventHelper() {
    }

    public void addListener(AxEventListener axEventListener) {
        if (axEventListener == null) {
            return;
        }
        if (this.m_listener == null) {
            this.m_listener = axEventListener;
        } else if (this.m_listener instanceof AxMulticastListener) {
            ((AxMulticastListener)this.m_listener).addListener(axEventListener);
        } else {
            this.m_listener = new AxMulticastListener(this.m_listener, axEventListener);
        }
    }

    public void removeListener(AxEventListener axEventListener) {
        if (this.m_listener == null) {
            return;
        }
        if (this.m_listener instanceof AxMulticastListener) {
            this.m_listener = ((AxMulticastListener)this.m_listener).removeListener(axEventListener);
        } else if (this.m_listener == axEventListener) {
            this.m_listener = null;
        }
    }

    boolean processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof AxEvent) {
            AxEvent axEvent = (AxEvent)aWTEvent;
            if (this.m_listener != null && aWTEvent != null) {
                if (aWTEvent.getID() == 2000) {
                    this.m_listener.init(axEvent);
                } else {
                    this.m_listener.done(axEvent);
                }
            }
            return true;
        }
        return false;
    }

    void init(Component component) {
        Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new AxEvent(component, 2000));
        this.m_bDoneFired = false;
    }

    void done(Component component) {
        if (!this.m_bDoneFired) {
            this.m_bDoneFired = true;
            component.dispatchEvent(new AxEvent(component, 2001));
        }
    }

    class AxMulticastListener
    extends Vector
    implements AxEventListener {
        AxMulticastListener(AxEventListener axEventListener, AxEventListener axEventListener2) {
            this.addListener(axEventListener);
            this.addListener(axEventListener2);
        }

        public void init(AxEvent axEvent) {
            for (int i = this.size() - 1; i >= 0; --i) {
                ((AxEventListener)this.get(i)).init(axEvent);
            }
        }

        public void done(AxEvent axEvent) {
            for (int i = this.size() - 1; i >= 0; --i) {
                ((AxEventListener)this.get(i)).done(axEvent);
            }
        }

        void addListener(AxEventListener axEventListener) {
            if (axEventListener == null) {
                throw new IllegalArgumentException("lis");
            }
            if (!this.contains(axEventListener)) {
                this.add(axEventListener);
            }
        }

        AxEventListener removeListener(AxEventListener axEventListener) {
            this.remove(axEventListener);
            if (this.size() == 1) {
                return (AxEventListener)this.get(0);
            }
            return this;
        }
    }
}

