/*
 * Decompiled with CFR 0.152.
 */
package smx.tracker;

import smx.tracker.ADMOnly;
import smx.tracker.DistanceMode;
import smx.tracker.InterferometerSetByADM;
import smx.tracker.TargetType;

public class WindowedSMRTargetType
extends TargetType {
    private double targetDiameter;
    private int targetType;
    private static final int TARGET_3_2 = 0;
    private static final int TARGET_7_8 = 1;
    private static final double TARGET_3_2_OFFSET = -8.86E-4;
    private static final double TARGET_7_8_OFFSET = -4.3722E-4;

    public WindowedSMRTargetType(double d) {
        if (d >= 0.038 && d <= 0.0382) {
            this.targetDiameter = d;
            this.targetType = 0;
        } else if (d >= 0.022224 && d <= 0.022226) {
            this.targetDiameter = d;
            this.targetType = 1;
        } else {
            throw new IllegalArgumentException();
        }
    }

    public double getDiameter() {
        return this.targetDiameter;
    }

    public double getRadiusOffset(DistanceMode distanceMode) {
        if (distanceMode instanceof InterferometerSetByADM || distanceMode instanceof ADMOnly) {
            if (this.targetType == 0) {
                return -8.86E-4;
            }
            if (this.targetType == 1) {
                return -4.3722E-4;
            }
            return 0.0;
        }
        return 0.0;
    }
}

