/*
 * Decompiled with CFR 0.152.
 */
package smx.tracker;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.JarURLConnection;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.security.SecureClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import smx.ftp.Ftp;
import smx.ftp.FtpAbortedException;
import smx.ftp.FtpAlreadyConnectedException;
import smx.ftp.FtpBusyException;
import smx.ftp.FtpException;
import smx.ftp.FtpIOException;
import smx.ftp.FtpNoResponseException;
import smx.ftp.FtpNotConnectedException;
import smx.tracker.ADMOnly;
import smx.tracker.AbortedException;
import smx.tracker.AdaptiveFilter;
import smx.tracker.AdaptiveFilterInternal;
import smx.tracker.AirExtTemp;
import smx.tracker.Alarm;
import smx.tracker.AlarmType;
import smx.tracker.AlreadyConnectedException;
import smx.tracker.ApplicationFailedException;
import smx.tracker.ApplicationResults;
import smx.tracker.AsyncMsg;
import smx.tracker.AverageFilter;
import smx.tracker.BadCommandException;
import smx.tracker.Change;
import smx.tracker.CommunicationException;
import smx.tracker.ConnectFailedException;
import smx.tracker.ContinueTrigger;
import smx.tracker.DataFormatException;
import smx.tracker.DataTag;
import smx.tracker.DataTagDouble;
import smx.tracker.DataTagUnsigned16;
import smx.tracker.DataTagUnsigned32;
import smx.tracker.DataTagUnsigned8;
import smx.tracker.DeviationAlarm;
import smx.tracker.DeviceLockedException;
import smx.tracker.Diagnostic;
import smx.tracker.DisconnectFailedException;
import smx.tracker.DistanceMode;
import smx.tracker.DistanceSetException;
import smx.tracker.DistanceTrigger;
import smx.tracker.DoubleFaultException;
import smx.tracker.ExtTempType;
import smx.tracker.ExternalContinueTrigger;
import smx.tracker.ExternalStartTrigger;
import smx.tracker.FileAccessException;
import smx.tracker.Filter;
import smx.tracker.HardwareNotInstalledException;
import smx.tracker.HighAlarm;
import smx.tracker.InterfaceBusyException;
import smx.tracker.InterferometerOnly;
import smx.tracker.InterferometerSetByADM;
import smx.tracker.InternalDeviceFailureException;
import smx.tracker.InternalTrackerException;
import smx.tracker.IntervalTrigger;
import smx.tracker.LaserStateException;
import smx.tracker.LevelData;
import smx.tracker.LowAlarm;
import smx.tracker.MPEResultsData;
import smx.tracker.MaterialExtTemp;
import smx.tracker.MaterialTemperatureData;
import smx.tracker.MeasureCfg;
import smx.tracker.MeasureData;
import smx.tracker.MeasurePointData;
import smx.tracker.MeasurePointStdDev;
import smx.tracker.MeasureStdDev;
import smx.tracker.MirrorTargetType;
import smx.tracker.MotorStateException;
import smx.tracker.NoDataAvailableException;
import smx.tracker.NoResponseException;
import smx.tracker.NoTargetException;
import smx.tracker.NotConnectedException;
import smx.tracker.NullAlarm;
import smx.tracker.NullContinueTrigger;
import smx.tracker.NullExtTemp;
import smx.tracker.NullFilter;
import smx.tracker.NullStartTrigger;
import smx.tracker.PermissionException;
import smx.tracker.PrintException;
import smx.tracker.Probe;
import smx.tracker.ProbeCalibrationData;
import smx.tracker.ProbeCompensationData;
import smx.tracker.RequestException;
import smx.tracker.SMRTargetType;
import smx.tracker.SimplePointPairData;
import smx.tracker.StartTrigger;
import smx.tracker.Status;
import smx.tracker.StdDevFilter;
import smx.tracker.TargetType;
import smx.tracker.Tracker;
import smx.tracker.TrackerApp;
import smx.tracker.TrackerException;
import smx.tracker.TrackerInterface;
import smx.tracker.TrackingStateException;
import smx.tracker.UnsupportedFeatureException;
import smx.tracker.UserSpecifiedDistance;
import smx.tracker.VideoCfg;
import smx.tracker.VideoData;
import smx.tracker.WeatherInformation;
import smx.tracker.WindowedSMRTargetType;

public class TrackerVector
implements TrackerInterface {
    private Ftp ftpClient = null;
    private LinkedList maintainApp = null;
    private String fileDirectory = "";
    private int[] measureTypeList = null;
    private boolean generalMeasureFlag = false;
    private boolean readInProgress = false;
    private Filter measureFilter = null;
    private int[] bkndMeasureTypeList = null;
    private boolean bkndReadInProgress = false;
    private boolean bkndGeneralMeasureFlag = false;
    private Filter bkndMeasureFilter = null;
    private int[] factoryBkndMeasureTypeList = null;
    private boolean factoryBkndReadInProgress = false;
    private boolean factoryBkndGeneralMeasureFlag = false;
    private Filter factoryBkndMeasureFilter = null;
    private boolean cmdInProgress = false;
    private DatagramSocket dgSocket = null;
    private DatagramSocket bkndDgSocket = null;
    private DatagramSocket asyncSocket = null;
    private DatagramSocket factoryBkndDgSocket = null;
    private DatagramPacket packet = null;
    private DatagramPacket bkndPacket = null;
    private DatagramPacket asyncPacket = null;
    private DatagramPacket factoryBkndPacket = null;
    private final int DATAGRAM_SOCKET_TIMEOUT = 5000;
    private byte[] buf = null;
    private byte[] bkndBuf = null;
    private byte[] asyncBuf = null;
    private byte[] factoryBkndBuf = null;
    private BufferedReader asyncInput = null;
    private boolean asyncReadInProgress = false;
    private boolean asyncReadInterrupted = false;
    private int accessLevel = 0;
    private static final int UNSIGNED8 = 1;
    private static final int UNSIGNED16 = 2;
    private static final int UNSIGNED32 = 3;
    private static final int DOUBLE = 4;
    private static final int ACCESS_STANDARD = 0;
    private static final int ACCESS_ADMIN = 1;
    private static final int ACCESS_FACTORY = 2;
    private static final int JAR_FROM_TRACKER = 0;
    private static final int JAR_FROM_LOCAL = 1;
    private DataTag[] pointMeasurementTags = new DataTag[6];
    private boolean measureInProgress = false;
    private boolean bkndMeasureInProgress = false;
    private boolean factoryBkndMeasureInProgress = false;
    private MeasureCfg oldmeasureCfg = null;
    private DataTag[] oldmeasureTags = null;
    private int[] oldmeasureTypeList = null;
    private MeasureCfg oldbkndMeasureCfg = null;
    private DataTag[] oldbkndMeasureTags = null;
    private int[] oldbkndMeasureTypeList = null;
    private MeasureCfg oldfactoryBkndMeasureCfg = null;
    private DataTag[] oldfactoryBkndMeasureTags = null;
    private int[] oldfactoryBkndMeasureTypeList = null;
    private long MCUVersionNumber = 0L;
    private JarClassLoader jarClassLoader = null;
    private Map jarCache = Collections.synchronizedMap(new HashMap(500));
    private boolean factoryConnect = false;
    private boolean factoryDisconnect = false;
    private int NUM_EXT_TEMP_SENSORS = 4;
    ArrayList tmpDownloadedJarsPath = new ArrayList(10);
    Random generator = new Random();
    private String subCompApp = "";
    private static final int[] diagMap = new int[]{0, 8, 8, 8, 8, 8, 1, 4, 5, 8, 8, 3, 6, 8};
    private static final int[] changeMap = new int[]{0, 2, 1, 4, 3};
    private static final int[] statusMap = new int[]{0, 1, 2, 21, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 14, 18, 16, 17, 19, 20, 0, 22, 23, 24};
    private static final int FILE_XFER_BUFFER_SIZE = 1200;
    private static final int TRACKER_SAMPLES_PER_SECOND = 1024;
    private static final int TRACKER_COMMAND_MIN_TIME_OUT = 15000;
    private static final double MAX_AIR_PRESSURE_VALUE = 900.0;
    private static final double MIN_AIR_PRESSURE_VALUE = 225.0;
    private static final double MAX_AIR_TEMP_VALUE = 60.0;
    private static final double MIN_AIR_TEMP_VALUE = -20.0;
    private static final double MAX_HUMIDITY_VALUE = 100.0;
    private static final double MIN_HUMIDITY_VALUE = 0.0;
    private static int EXTENDED_THERMAL_TIME = 2700;
    private static int LONG_THERMAL_TIME = 1200;
    private static int QUICK_THERMAL_TIME = 300;
    private static int DONE_THERMAL_TIME = 0;
    private boolean initialLocalAppValueSet = false;
    private boolean loadingLocalApp = false;
    boolean generalVideoFlag = false;
    boolean videoInProgress = false;
    private VideoCfg oldVideoCfg = null;
    private Socket videoSocket;
    private ServerSocket videoServerSocket;
    private InputStream videoRawInput;
    private DataInputStream videoInputStream;
    private boolean performanceParametersSetForTracker = false;
    private double admMPEOffset = 0.0;
    private double admMPEScale = 0.0;
    private double transverseMPEOffset = 0.0;
    private double transverseMPEScale = 0.0;
    boolean printed_once = false;
    final double MINIMUM_PSD_REQUIRED_TO_SAY_WE_ARE_ON_THE_TARGET = 0.1;
    final double COMBO_SPIRAL_RADIUS_WHEN_DISTANCE_IS_NOT_KNOWN = 0.007;
    final double COMBO_SPIRAL_RADIUS_WITH_KNOWN_DISTANCE = 0.007;
    private final int COMBO_SPIRAL_SEARCH_TIME_OUT = 10000;
    final double TIGHT_TOLERANCE = 0.005;
    final double WIDE_TOLERANCE = 0.02;
    final int FAR_FROM_CENTER_X_PIXEL = 400;
    final int FAR_FROM_CENTER_Y_PIXEL = 250;
    final double TOO_FAR_FROM_SEARCH_LOCATION_FOR_SPIRAL = 0.003;
    PrintWriter combo_search_log_writer = null;
    int combo_writer_step = 1;
    static boolean showed_once = false;
    private final int CAMERA_GESTURE_STATE_START_LOOKING_FOR_TARGET = 4;
    final double azFactor = 3.665E-4;
    final double zeFactor = -3.665E-4;
    final double TIGHT_TOLERANCE_2_AZ = 0.006;
    final double WIDE_TOLERANCE_2_AZ = 0.01;
    final double TIGHT_TOLERANCE_2 = 0.0035;
    final double WIDE_TOLERANCE_2 = 0.007;
    final int FAR_FROM_CENTER_X_PIXEL_2 = 300;
    final int FAR_FROM_CENTER_Y_PIXEL_2 = 100;
    private final int MAX_TIME_TO_WAIT_FOR_CAMERA_DATA_AFTER_A_MOVE = 3500;
    private String ipAddressToUse = null;
    private boolean printOutput = false;

    public TrackerVector() {
        this.pointMeasurementTags[0] = new DataTagDouble("target.corrected.azimuth.value");
        this.pointMeasurementTags[1] = new DataTagUnsigned16("target.corrected.azimuth.status");
        this.pointMeasurementTags[2] = new DataTagDouble("target.corrected.zenith.value");
        this.pointMeasurementTags[3] = new DataTagUnsigned16("target.corrected.zenith.status");
        this.pointMeasurementTags[4] = new DataTagDouble("target.corrected.distance.value");
        this.pointMeasurementTags[5] = new DataTagUnsigned16("target.corrected.distance.status");
    }

    @Override
    public synchronized void connect(String string, String string2, String string3) throws TrackerException {
        ConnectFailedException connectFailedException = null;
        if (this.ftpClient != null) {
            throw new AlreadyConnectedException();
        }
        if (-1 == string.indexOf(46) || !Tracker.isUserParameterValidIPAddress(string)) {
            string = Tracker.checkAndGetIPAddress(string, "TrackerVector");
        }
        this.ftpClient = new Ftp();
        try {
            this.ftpClient.connect(string, string2, string3);
            this.ipAddressToUse = string;
            this.jarClassLoader = new JarClassLoader();
        }
        catch (FtpException ftpException) {
            this.ftpClient = null;
            throw new ConnectFailedException(ftpException.toString());
        }
        try {
            this.checkIfConnectingToTrackerTypeSpecified();
            this.setAccessLevel(string2);
            this.setAppInfo();
        }
        catch (ConnectFailedException connectFailedException2) {
            connectFailedException = connectFailedException2;
        }
        catch (TrackerException trackerException) {
            connectFailedException = new ConnectFailedException("Could not obtain needed info");
        }
        if (connectFailedException != null) {
            try {
                this.ftpClient.disconnect();
            }
            catch (FtpException ftpException) {
                // empty catch block
            }
            this.cleanupInterface();
            throw connectFailedException;
        }
    }

    private boolean checkTags(DataTag[] dataTagArray, DataTag[] dataTagArray2) {
        if (dataTagArray == null || dataTagArray2 == null) {
            return false;
        }
        if (dataTagArray.length != dataTagArray2.length) {
            return false;
        }
        for (int i = 0; i < dataTagArray2.length; ++i) {
            if (dataTagArray[i].getName().equals(dataTagArray2[i].getName())) continue;
            return false;
        }
        return true;
    }

    private boolean checkTypeList(int[] nArray, int[] nArray2) {
        if (nArray == null || nArray2 == null) {
            return false;
        }
        if (nArray.length != nArray2.length) {
            return false;
        }
        for (int i = 0; i < nArray2.length; ++i) {
            if (nArray[i] == nArray2[i]) continue;
            return false;
        }
        return true;
    }

    private Object checkAndSendCFGData(MeasureCfg measureCfg, DataTag[] dataTagArray, boolean bl, boolean bl2, Ftp ftp, String string) throws TrackerException {
        int[] nArray = null;
        int[] nArray2 = null;
        MeasureCfg measureCfg2 = null;
        DataTag[] dataTagArray2 = null;
        int[] nArray3 = null;
        if (bl) {
            if (bl2) {
                measureCfg2 = this.oldfactoryBkndMeasureCfg;
                dataTagArray2 = this.oldfactoryBkndMeasureTags;
                nArray3 = this.oldfactoryBkndMeasureTypeList;
            } else {
                measureCfg2 = this.oldbkndMeasureCfg;
                dataTagArray2 = this.oldbkndMeasureTags;
                nArray3 = this.oldbkndMeasureTypeList;
            }
        } else {
            measureCfg2 = this.oldmeasureCfg;
            dataTagArray2 = this.oldmeasureTags;
            nArray3 = this.oldmeasureTypeList;
        }
        nArray2 = TrackerVector.createTypeList(dataTagArray);
        if (measureCfg2 != null && this.checkTags(dataTagArray2, dataTagArray) && this.checkTypeList(nArray3, nArray2) && measureCfg2.getContinueTrigger().equals(measureCfg.getContinueTrigger()) && measureCfg.getFilter().equals(measureCfg2.getFilter()) && measureCfg2.getStartTrigger().equals(measureCfg.getStartTrigger()) && measureCfg2.getSamplesPerObservation() == measureCfg.getSamplesPerObservation()) {
            return null;
        }
        this.sendMeasureCfg(ftp, measureCfg, dataTagArray, string);
        nArray = nArray2;
        measureCfg2 = new MeasureCfg(measureCfg.getSamplesPerObservation(), measureCfg.getFilter(), measureCfg.getStartTrigger(), measureCfg.getContinueTrigger());
        dataTagArray2 = new DataTag[dataTagArray.length];
        for (int i = 0; i < dataTagArray.length; ++i) {
            if (dataTagArray[i] instanceof DataTagDouble) {
                dataTagArray2[i] = new DataTagDouble(dataTagArray[i].getName());
                continue;
            }
            if (dataTagArray[i] instanceof DataTagUnsigned16) {
                dataTagArray2[i] = new DataTagUnsigned16(dataTagArray[i].getName());
                continue;
            }
            if (dataTagArray[i] instanceof DataTagUnsigned32) {
                dataTagArray2[i] = new DataTagUnsigned32(dataTagArray[i].getName());
                continue;
            }
            if (dataTagArray[i] instanceof DataTagUnsigned8) {
                dataTagArray2[i] = new DataTagUnsigned8(dataTagArray[i].getName());
                continue;
            }
            throw new TrackerException("Unknown DataTag type passed");
        }
        nArray3 = nArray;
        if (bl) {
            if (bl2) {
                this.oldfactoryBkndMeasureCfg = measureCfg2;
                this.oldfactoryBkndMeasureTags = dataTagArray2;
                this.oldfactoryBkndMeasureTypeList = nArray3;
            } else {
                this.oldbkndMeasureCfg = measureCfg2;
                this.oldbkndMeasureTags = dataTagArray2;
                this.oldbkndMeasureTypeList = nArray3;
            }
        } else {
            this.oldmeasureCfg = measureCfg2;
            this.oldmeasureTags = dataTagArray2;
            this.oldmeasureTypeList = nArray3;
        }
        return nArray;
    }

    private void setAccessLevel(String string) throws TrackerException {
        if (string.equalsIgnoreCase("user")) {
            this.accessLevel = 0;
        } else if (string.equalsIgnoreCase("admin")) {
            this.accessLevel = 1;
        } else if (string.equalsIgnoreCase("factory") || string.equalsIgnoreCase("supervis")) {
            this.accessLevel = 2;
        } else {
            throw new ConnectFailedException("Invalid user name");
        }
    }

    @Override
    public int sampleRate() throws TrackerException {
        return 1024;
    }

    private void closeCachedJars() {
        Collection collection = this.jarCache.values();
        for (JarFile jarFile : collection) {
            try {
                jarFile.close();
            }
            catch (Exception exception) {
                PrintException.print(exception);
            }
        }
        this.jarCache.clear();
        if (this.tmpDownloadedJarsPath.size() > 0) {
            for (int i = 0; i < this.tmpDownloadedJarsPath.size(); ++i) {
                File file = new File((String)this.tmpDownloadedJarsPath.get(i));
                if (!file.exists()) continue;
                file.delete();
            }
            this.tmpDownloadedJarsPath.clear();
        }
    }

    private void cleanupInterface() throws TrackerException {
        this.ftpClient = null;
        this.closeCachedJars();
        this.jarClassLoader = null;
        this.measureTypeList = null;
        this.generalMeasureFlag = false;
        this.readInProgress = false;
        this.measureFilter = null;
        this.bkndMeasureTypeList = null;
        this.bkndReadInProgress = false;
        this.bkndGeneralMeasureFlag = false;
        this.bkndMeasureFilter = null;
        this.factoryBkndMeasureTypeList = null;
        this.factoryBkndReadInProgress = false;
        this.factoryBkndGeneralMeasureFlag = false;
        this.factoryBkndMeasureFilter = null;
        this.cmdInProgress = false;
        this.dgSocket = null;
        this.bkndDgSocket = null;
        this.asyncSocket = null;
        this.factoryBkndDgSocket = null;
        this.packet = null;
        this.bkndPacket = null;
        this.asyncPacket = null;
        this.factoryBkndPacket = null;
        this.buf = null;
        this.bkndBuf = null;
        this.asyncBuf = null;
        this.factoryBkndBuf = null;
        this.asyncInput = null;
        this.asyncReadInProgress = false;
        this.asyncReadInterrupted = false;
        this.accessLevel = 0;
        this.measureInProgress = false;
        this.bkndMeasureInProgress = false;
        this.factoryBkndMeasureInProgress = false;
        this.oldmeasureCfg = null;
        this.oldmeasureTags = null;
        this.oldbkndMeasureCfg = null;
        this.oldbkndMeasureTags = null;
        this.oldfactoryBkndMeasureCfg = null;
        this.oldfactoryBkndMeasureTags = null;
    }

    @Override
    public void disconnect() throws TrackerException {
        if (!this.isConnected()) {
            return;
        }
        try {
            this.clearAppInfo();
            this.ftpClient.disconnect();
            this.cleanupInterface();
        }
        catch (FtpIOException ftpIOException) {
            this.cleanupInterface();
        }
        catch (FtpNoResponseException ftpNoResponseException) {
            this.cleanupInterface();
        }
        catch (FtpException ftpException) {
            throw new DisconnectFailedException();
        }
    }

    private boolean isConnected() {
        return this.ftpClient != null;
    }

    private boolean isMeasuring() {
        return this.measureInProgress;
    }

    @Override
    public void trackerCommand(String string, int n) throws TrackerException {
        if (n < 15000) {
            n = 15000;
        }
        this.executeTrackerCommand(string, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeTrackerCommand(String string, int n) throws TrackerException {
        try {
            TrackerVector trackerVector = this;
            synchronized (trackerVector) {
                this.readyForCommand();
                this.cmdInProgress = true;
            }
            int n2 = this.ftpClient.command(string, n);
            if (n2 != 200) {
                throw TrackerVector.exceptionFromResponse(this.ftpClient, n2);
            }
        }
        catch (FtpException ftpException) {
            throw TrackerVector.convertFtpExc(ftpException);
        }
        finally {
            TrackerVector trackerVector = this;
            synchronized (trackerVector) {
                this.cmdInProgress = false;
            }
        }
    }

    @Override
    public void initialize() throws TrackerException {
        this.initialize(true);
    }

    @Override
    public void initialize(boolean bl) throws TrackerException {
        if (!this.readyToInitialize(bl)) {
            throw new TrackerException("Tracker is not ready.");
        }
        boolean bl2 = this.shouldRunLineJumpCorrection();
        this.trackerCommand("init", 180000);
        if (bl2) {
            this.customInitialize();
        }
    }

    private void customInitialize() throws TrackerException {
        try {
            this.runEncoderLineJumpCorrection();
        }
        catch (Exception exception) {
            PrintException.print(exception);
        }
        if (!this.customInitialized()) {
            throw new TrackerException("Failed to initialize tracker");
        }
    }

    private boolean shouldRunLineJumpCorrection() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned16("position_device.azimuth_encoder.reading.status"), new DataTagUnsigned16("position_device.zenith_encoder.reading.status")};
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        int n = (Integer)objectArray[0];
        int n2 = (Integer)objectArray[1];
        return 0 != (0x20 & n) && 0 != (0x20 & n2);
    }

    /*
     * Exception decompiling
     */
    private void runEncoderLineJumpCorrection() throws TrackerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 14[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void log(String string) {
        if (this.printOutput) {
            System.out.println(string);
        }
    }

    private void log(PrintWriter printWriter, String string) {
        if (printWriter != null) {
            printWriter.println(string);
        }
        this.log(string);
    }

    private void saveRawData(DataTag[] dataTagArray, ArrayList arrayList) {
        String string = ",";
        String string2 = System.getProperty("user.dir");
        String string3 = "\\linejump.csv";
        try {
            String string4;
            Object object;
            File file = new File(string2 + string3);
            if (file.exists()) {
                object = Long.toString(System.currentTimeMillis());
                string4 = string2 + string3 + (String)object + ".csv";
                File file2 = new File(string4);
                if (file.exists()) {
                    file.renameTo(file2);
                }
            }
            object = new PrintWriter((Writer)new FileWriter(string2 + string3, true), false);
            string4 = "TimeStamp" + string;
            if (object != null) {
                int n;
                for (n = 0; n < dataTagArray.length; ++n) {
                    string4 = string4 + dataTagArray[n].getName() + string;
                }
                ((PrintWriter)object).println(string4);
                for (n = 0; n < arrayList.size(); ++n) {
                    MeasureData measureData = (MeasureData)arrayList.get(n);
                    String string5 = measureData.time() + string;
                    for (int i = 0; i < measureData.getNumDataElements(); ++i) {
                        if (measureData.getDataElement(i) instanceof Double) {
                            double d = (Double)measureData.getDataElement(i);
                            string5 = string5 + d + string;
                            continue;
                        }
                        if (measureData.getDataElement(i) instanceof Integer) {
                            int n2 = (Integer)measureData.getDataElement(i);
                            string5 = string5 + n2 + string;
                            continue;
                        }
                        if (!(measureData.getDataElement(i) instanceof Long)) continue;
                        long l = (Long)measureData.getDataElement(i);
                        string5 = string5 + l + string;
                    }
                    ((PrintWriter)object).println(string5);
                }
                ((PrintWriter)object).println();
                ((PrintWriter)object).flush();
                ((PrintWriter)object).close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected int[] convertToVersionNumber(long l) {
        long l2 = 255L;
        int[] nArray = new int[]{Integer.parseInt(Long.toString((l & l2 << 24) >> 24)), Integer.parseInt(Long.toString((l & l2 << 16) >> 16)), Integer.parseInt(Long.toString((l & l2 << 8) >> 8)), Integer.parseInt(Long.toString(l & l2))};
        return nArray;
    }

    private static String getLogFileEnvPath(String string) {
        String string2;
        String string3 = "";
        String string4 = System.getenv("APPDATA");
        string3 = string2 = System.getenv("ALLUSERSPROFILE");
        String string5 = System.getProperty("os.name");
        if (string5.equals("Windows XP")) {
            String string6 = string4.substring(string4.lastIndexOf("\\"), string4.length());
            string3 = string3 + string6;
        }
        string3 = string3 + "\\FARO Laser\\" + string;
        return string3;
    }

    @Override
    public void initializeSmart() throws TrackerException {
        this.initializeSmart(true);
    }

    @Override
    public void initializeSmart(boolean bl) throws TrackerException {
        if (!this.readyToInitialize(bl)) {
            throw new TrackerException("Tracker is not ready.");
        }
        boolean bl2 = this.shouldRunLineJumpCorrection();
        this.trackerCommand("init smart", 180000);
        if (bl2) {
            this.customInitialize();
        }
    }

    @Override
    public void move(double d, double d2, double d3, boolean bl) throws TrackerException {
        String string = "move " + d + " " + d2 + " " + d3 + (bl ? " r" : " a");
        try {
            this.trackerCommand(string, 15000);
        }
        catch (NoTargetException noTargetException) {
            // empty catch block
        }
    }

    @Override
    public void move(double d, double d2, double d3, boolean bl, boolean bl2) throws TrackerException {
        String string = "move " + d + " " + d2 + " " + d3 + (bl2 ? " r" : " a") + (bl ? " b" : " f");
        try {
            this.trackerCommand(string, 15000);
        }
        catch (NoTargetException noTargetException) {
            // empty catch block
        }
    }

    @Override
    public void home(boolean bl) throws TrackerException {
        this.trackerCommand("home" + (bl ? " b" : ""), 120000);
    }

    @Override
    public void toggleSightOrientation() throws TrackerException {
        this.trackerCommand("backsight", 600000);
    }

    @Override
    public void search(double d, int n) throws TrackerException {
        if (n < 1000) {
            throw new TrackerException("Timeout value is out of bounds");
        }
        this.executeTrackerCommand("fr " + d, n);
    }

    @Override
    public void search(double d, double d2, int n) throws TrackerException {
        if (n < 1000) {
            throw new TrackerException("Timeout value is out of bounds");
        }
        this.executeTrackerCommand("fr " + d + " " + d2, n);
    }

    @Override
    public void search(double d, double d2) throws TrackerException {
        this.trackerCommand("fr " + d + " " + d2, 600000);
    }

    @Override
    public void search(double d) throws TrackerException {
        this.trackerCommand("fr " + d, 600000);
    }

    @Override
    public void changeMotorState(boolean bl) throws TrackerException {
        this.trackerCommand("motors " + (bl ? "on auto_adjust" : "off"), 6000);
    }

    @Override
    public void changeTrackingState(boolean bl) throws TrackerException {
        String string = "tracking " + (bl ? "on" : "off");
        this.trackerCommand(string, 6000);
    }

    @Override
    public void changeDistanceMeasureMode(DistanceMode distanceMode) throws TrackerException {
        if (distanceMode instanceof ADMOnly) {
            this.trackerCommand("dist_mode adm auto_adjust", 6000);
        } else if (distanceMode instanceof UserSpecifiedDistance) {
            this.trackerCommand("dist_mode user", 6000);
        } else {
            throw new UnsupportedFeatureException("Mode not supported");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void changeTargetType(TargetType targetType) throws TrackerException {
        String string = "";
        if (targetType instanceof SMRTargetType) {
            SMRTargetType sMRTargetType = (SMRTargetType)targetType;
            double d = sMRTargetType.getDiameter();
            string = d >= 0.038 && d <= 0.0382 ? "smr_1_1/2" : (d >= 0.0126 && d <= 0.0128 ? "smr_1/2" : (d >= 0.0221 && d <= 0.0223 ? "smr_7/8" : "smr_user"));
        } else if (targetType instanceof WindowedSMRTargetType) {
            WindowedSMRTargetType windowedSMRTargetType = (WindowedSMRTargetType)targetType;
            double d = windowedSMRTargetType.getDiameter();
            if (d >= 0.038 && d <= 0.0382) {
                string = "smr_1_1/2_windowed";
            } else {
                if (!(d >= 0.022224) || !(d <= 0.022226)) throw new UnsupportedFeatureException("Target type not supported.");
                string = "smr_7/8_windowed";
            }
        } else {
            if (!(targetType instanceof MirrorTargetType)) throw new UnsupportedFeatureException("Target type not supported.");
            string = "mirror";
        }
        this.trackerCommand("target " + string, 1000);
    }

    @Override
    public synchronized void abort() {
        try {
            if (this.cmdInProgress) {
                this.ftpClient.abort();
            }
        }
        catch (FtpException ftpException) {
            // empty catch block
        }
    }

    @Override
    public void startMeasure(MeasureCfg measureCfg, DataTag[] dataTagArray) throws TrackerException {
        this.localStartMeasure(measureCfg, dataTagArray, true);
    }

    private synchronized void localStartMeasure(MeasureCfg measureCfg, DataTag[] dataTagArray, boolean bl) throws TrackerException {
        this.readyForCommand();
        Object object = this.checkAndSendCFGData(measureCfg, dataTagArray, false, false, this.ftpClient, "\\data\\measure.arg");
        int n = this.receiveMeasurementData(this.ftpClient);
        if (n != 200) {
            throw TrackerVector.exceptionFromResponse(this.ftpClient, n);
        }
        if (object != null) {
            this.measureTypeList = (int[])object;
            this.measureFilter = measureCfg.getFilter();
        }
        this.generalMeasureFlag = bl;
        this.measureInProgress = true;
    }

    private void readyForCommand() throws InterfaceBusyException, NotConnectedException {
        if (!this.isConnected()) {
            throw new NotConnectedException();
        }
        if (this.isMeasuring() || this.cmdInProgress) {
            throw new InterfaceBusyException("Measure or cmd in progress");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMeasureCfg(Ftp ftp, MeasureCfg measureCfg, DataTag[] dataTagArray, String string) throws TrackerException {
        int n;
        TrackerException trackerException = null;
        try {
            n = ftp.sendStart(string);
            if (n != 150) {
                throw TrackerVector.exceptionFromResponse(ftp, n);
            }
        }
        catch (FtpException ftpException) {
            throw TrackerVector.convertFtpExc(ftpException);
        }
        try {
            ftp.sendLine("maxobs=0");
            ftp.sendLine("nsamps=" + measureCfg.getSamplesPerObservation());
            this.sendStartTrigger(ftp, measureCfg);
            this.sendContinueTrigger(ftp, measureCfg);
            this.sendFilter(ftp, measureCfg);
            for (int i = 0; i < dataTagArray.length; ++i) {
                ftp.sendLine("tag=" + dataTagArray[i].getName());
            }
        }
        catch (FtpException ftpException) {
            trackerException = TrackerVector.convertFtpExc(ftpException);
        }
        catch (TrackerException trackerException2) {
            trackerException = trackerException2;
        }
        finally {
            block22: {
                try {
                    n = ftp.sendEnd(10000);
                    if (n != 226 && trackerException == null) {
                        trackerException = TrackerVector.exceptionFromResponse(ftp, n);
                    }
                }
                catch (FtpException ftpException) {
                    if (trackerException != null) break block22;
                    trackerException = TrackerVector.convertFtpExc(ftpException);
                }
            }
        }
        if (trackerException != null) {
            throw trackerException;
        }
    }

    private int receiveMeasurementData(Ftp ftp) throws TrackerException {
        try {
            this.dgSocket = new DatagramSocket();
            this.dgSocket.setSoTimeout(5000);
            byte[] byArray = ftp.getIPAddress().getAddress();
            int n = this.dgSocket.getLocalPort();
            int[] nArray = new int[4];
            for (int i = 0; i < 4; ++i) {
                nArray[i] = byArray[i];
                if (nArray[i] >= 0) continue;
                int n2 = i;
                nArray[n2] = nArray[n2] + 256;
            }
            int n3 = ftp.command("measure " + nArray[0] + "," + nArray[1] + "," + nArray[2] + "," + nArray[3] + "," + n / 256 + "," + n % 256, 10000);
            return n3;
        }
        catch (SocketException socketException) {
            if (this.dgSocket != null) {
                this.dgSocket.close();
            }
            throw new CommunicationException("measurement data exception");
        }
        catch (FtpException ftpException) {
            throw TrackerVector.convertFtpExc(ftpException);
        }
    }

    private void sendStartTrigger(Ftp ftp, MeasureCfg measureCfg) throws FtpException, TrackerException {
        StartTrigger startTrigger = measureCfg.getStartTrigger();
        if (startTrigger instanceof ExternalStartTrigger) {
            ftp.sendLine("start_type=digio");
            return;
        }
        if (startTrigger instanceof NullStartTrigger) {
            ftp.sendLine("start_type=nopause");
            return;
        }
        throw new UnsupportedFeatureException("Unknown start trigger");
    }

    private void sendContinueTrigger(Ftp ftp, MeasureCfg measureCfg) throws FtpException, TrackerException {
        ContinueTrigger continueTrigger = measureCfg.getContinueTrigger();
        if (continueTrigger instanceof NullContinueTrigger) {
            ftp.sendLine("nth_type=noseq");
            return;
        }
        if (continueTrigger instanceof ExternalContinueTrigger) {
            ftp.sendLine("nth_type=digio");
            return;
        }
        if (continueTrigger instanceof IntervalTrigger) {
            ftp.sendLine("nth_type=time");
            ftp.sendLine("obsrate=" + ((IntervalTrigger)continueTrigger).getObservationRate());
            return;
        }
        if (continueTrigger instanceof DistanceTrigger) {
            ftp.sendLine("nth_type=distance");
            ftp.sendLine("distance=" + ((DistanceTrigger)continueTrigger).getDistance());
            return;
        }
        throw new UnsupportedFeatureException("Unknown continue trigger");
    }

    private void sendFilter(Ftp ftp, MeasureCfg measureCfg) throws FtpException, TrackerException {
        Filter filter = measureCfg.getFilter();
        if (filter instanceof NullFilter) {
            ftp.sendLine("filter=none");
            return;
        }
        if (filter instanceof AverageFilter) {
            ftp.sendLine("filter=firstorder");
            return;
        }
        if (filter instanceof StdDevFilter) {
            ftp.sendLine("filter=stddev");
            return;
        }
        if (filter instanceof AdaptiveFilter) {
            ftp.sendLine("filter=adaptive");
            ftp.sendLine("sdm=" + ((AdaptiveFilter)filter).getSdm());
            int n = 65535;
            if (filter instanceof AdaptiveFilterInternal) {
                n = ((AdaptiveFilterInternal)filter).getStatusMask();
            }
            ftp.sendLine("statusmask=" + n);
            return;
        }
        throw new UnsupportedFeatureException("Unknown filter");
    }

    private static TrackerException exceptionFromResponse(Ftp ftp, int n) {
        String string;
        try {
            string = ftp.getLastResponse();
        }
        catch (FtpException ftpException) {
            return new CommunicationException("Unexpected FTP exception while getting last response");
        }
        switch (n) {
            case 340: {
                return new RequestException(string);
            }
            case 453: {
                return new InternalDeviceFailureException(string);
            }
            case 450: 
            case 452: 
            case 454: 
            case 455: 
            case 456: 
            case 555: {
                return new InternalTrackerException(string);
            }
            case 421: 
            case 425: 
            case 428: 
            case 429: 
            case 520: 
            case 530: {
                return new CommunicationException(string);
            }
            case 550: {
                return new PermissionException(string);
            }
            case 552: 
            case 557: {
                return new FileAccessException(string);
            }
            case 556: 
            case 558: {
                return TrackerVector.exceptionFromReason(string);
            }
            case 500: 
            case 501: 
            case 503: {
                return new BadCommandException(string);
            }
        }
        return new TrackerException(string);
    }

    private static TrackerException convertFtpExc(FtpException ftpException) {
        try {
            throw ftpException;
        }
        catch (FtpAbortedException ftpAbortedException) {
            return new AbortedException();
        }
        catch (FtpAlreadyConnectedException ftpAlreadyConnectedException) {
            return new AlreadyConnectedException();
        }
        catch (FtpBusyException ftpBusyException) {
            return new InterfaceBusyException("FTP is busy");
        }
        catch (FtpNoResponseException ftpNoResponseException) {
            return new NoResponseException();
        }
        catch (FtpNotConnectedException ftpNotConnectedException) {
            return new NotConnectedException();
        }
        catch (FtpException ftpException2) {
            return new CommunicationException("Unexpected FTP exception");
        }
    }

    private static TrackerException exceptionFromReason(String string) {
        int n;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        stringTokenizer.nextToken();
        String string2 = stringTokenizer.nextToken();
        try {
            n = Integer.parseInt(string2, 16);
        }
        catch (NumberFormatException numberFormatException) {
            return new CommunicationException("FTP response string not in expected format");
        }
        String string3 = "Code: " + n;
        switch (n) {
            case 1: {
                return new DeviceLockedException(string3);
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 25: 
            case 48: {
                return new InternalTrackerException(string3);
            }
            case 5: 
            case 15: 
            case 23: 
            case 68: {
                return new MotorStateException(string3);
            }
            case 6: 
            case 19: {
                return new LaserStateException(string3);
            }
            case 13: {
                return new NoTargetException(string3);
            }
            case 18: {
                return new DoubleFaultException(string3);
            }
            case 69: {
                return new InternalDeviceFailureException(string3);
            }
            case 70: {
                return new HardwareNotInstalledException(string3);
            }
            case 27: 
            case 49: {
                return new DistanceSetException(string3);
            }
            case 30: {
                return new TrackingStateException(string3);
            }
        }
        return new TrackerException(string3);
    }

    private static int[] createTypeList(DataTag[] dataTagArray) throws TrackerException {
        int n = dataTagArray.length;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            if (dataTagArray[i] instanceof DataTagUnsigned8) {
                nArray[i] = 1;
                continue;
            }
            if (dataTagArray[i] instanceof DataTagUnsigned16) {
                nArray[i] = 2;
                continue;
            }
            if (dataTagArray[i] instanceof DataTagUnsigned32) {
                nArray[i] = 3;
                continue;
            }
            if (dataTagArray[i] instanceof DataTagDouble) {
                nArray[i] = 4;
                continue;
            }
            throw new UnsupportedFeatureException("Unknown data tag");
        }
        return nArray;
    }

    @Override
    public MeasureData[] readMeasureData(int n) throws TrackerException {
        MeasureData[] measureDataArray;
        this.testAndSetReadData(true);
        try {
            measureDataArray = this.readData(this.ftpClient, n, this.measureTypeList, this.measureFilter);
        }
        catch (IOException iOException) {
            throw new CommunicationException("measurement data exception");
        }
        catch (FtpException ftpException) {
            throw TrackerVector.convertFtpExc(ftpException);
        }
        finally {
            this.releaseReadData();
        }
        return measureDataArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testAndSetReadData(boolean bl) throws TrackerException {
        TrackerVector trackerVector = this;
        synchronized (trackerVector) {
            if (!this.isConnected()) {
                throw new NotConnectedException();
            }
            if (!this.isMeasuring() || bl != this.generalMeasureFlag) {
                throw new NoDataAvailableException();
            }
            if (this.readInProgress) {
                throw new InterfaceBusyException("Read in progress");
            }
            this.readInProgress = true;
        }
    }

    private MeasureData[] readData(Ftp ftp, int n, int[] nArray, Filter filter) throws IOException, FtpException {
        MeasureData[] measureDataArray = new MeasureData[n];
        for (int i = 0; i < n; ++i) {
            MeasureStdDev measureStdDev;
            this.buf = filter instanceof StdDevFilter ? new byte[(nArray.length * 8 + 8) * 2] : new byte[nArray.length * 8 + 8];
            this.packet = new DatagramPacket(this.buf, this.buf.length);
            this.receiveDgPacket(this.dgSocket, this.packet);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.packet.getData());
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            Object[] objectArray = new Object[nArray.length];
            long l = dataInputStream.readInt();
            long l2 = dataInputStream.readInt();
            double d = (double)l + (double)l2 / 1000000.0;
            for (int j = 0; j < nArray.length; ++j) {
                objectArray[j] = this.readDataElement(dataInputStream, nArray[j]);
            }
            if (filter instanceof StdDevFilter) {
                Object[] objectArray2 = new Object[nArray.length];
                for (int j = 0; j < nArray.length; ++j) {
                    objectArray2[j] = this.readDataElement(dataInputStream, nArray[j]);
                }
                measureStdDev = new MeasureStdDev(objectArray2);
            } else {
                measureStdDev = null;
            }
            measureDataArray[i] = new MeasureData(d, objectArray, measureStdDev);
        }
        return measureDataArray;
    }

    private void releaseReadData() {
        this.readInProgress = false;
    }

    private Object readDataElement(DataInputStream dataInputStream, int n) throws FtpException, IOException {
        Number number = null;
        switch (n) {
            case 1: {
                short s = (short)((short)dataInputStream.readByte() & 0xFF);
                number = new Short(s);
                dataInputStream.skip(7L);
                break;
            }
            case 2: {
                number = new Integer(dataInputStream.readUnsignedShort());
                dataInputStream.skip(6L);
                break;
            }
            case 3: {
                number = new Long((long)dataInputStream.readInt() & 0xFFFFFFFFL);
                dataInputStream.skip(4L);
                break;
            }
            case 4: {
                number = new Double(dataInputStream.readDouble());
            }
        }
        return number;
    }

    @Override
    public synchronized void stopMeasure() throws TrackerException {
        this.localStopMeasure(true);
    }

    private synchronized void localStopMeasure(boolean bl) throws TrackerException {
        if (!this.isConnected()) {
            throw new NotConnectedException();
        }
        if (this.isMeasuring() && this.generalMeasureFlag == bl) {
            try {
                this.ftpClient.command("measure", 10000);
                this.dgSocket.close();
                this.packet = null;
                this.measureInProgress = false;
            }
            catch (FtpIOException ftpIOException) {
                this.dgSocket.close();
                this.packet = null;
                this.measureInProgress = false;
            }
            catch (FtpNoResponseException ftpNoResponseException) {
                this.dgSocket.close();
                this.packet = null;
                this.measureInProgress = false;
            }
            catch (FtpException ftpException) {
                throw TrackerVector.convertFtpExc(ftpException);
            }
        }
    }

    @Override
    public void startMeasurePoint(MeasureCfg measureCfg) throws TrackerException {
        this.localStartMeasure(measureCfg, this.pointMeasurementTags, false);
    }

    @Override
    public MeasurePointData[] readMeasurePointData(int n) throws TrackerException {
        MeasurePointData[] measurePointDataArray;
        this.testAndSetReadData(false);
        try {
            measurePointDataArray = this.readPointData(this.ftpClient, n, this.measureFilter);
        }
        catch (IOException iOException) {
            throw new CommunicationException("measurement data exception");
        }
        catch (FtpException ftpException) {
            throw TrackerVector.convertFtpExc(ftpException);
        }
        finally {
            this.releaseReadData();
        }
        return measurePointDataArray;
    }

    private MeasurePointData[] localReadPointData(Ftp ftp, int n, Filter filter, boolean bl, boolean bl2) throws IOException, FtpException {
        MeasurePointData[] measurePointDataArray = new MeasurePointData[n];
        for (int i = 0; i < n; ++i) {
            MeasurePointStdDev measurePointStdDev;
            double d;
            double d2;
            ByteArrayInputStream byteArrayInputStream;
            if (!bl) {
                this.buf = new byte[256];
                this.packet = new DatagramPacket(this.buf, this.buf.length);
                this.receiveDgPacket(this.dgSocket, this.packet);
                if (null == this.packet) {
                    throw new IOException();
                }
                byteArrayInputStream = new ByteArrayInputStream(this.packet.getData());
            } else if (bl2) {
                this.factoryBkndBuf = new byte[256];
                this.factoryBkndPacket = new DatagramPacket(this.factoryBkndBuf, this.factoryBkndBuf.length);
                this.receiveDgPacket(this.factoryBkndDgSocket, this.factoryBkndPacket);
                if (null == this.factoryBkndPacket) {
                    throw new IOException();
                }
                byteArrayInputStream = new ByteArrayInputStream(this.factoryBkndPacket.getData());
            } else {
                this.bkndBuf = new byte[256];
                this.bkndPacket = new DatagramPacket(this.bkndBuf, this.bkndBuf.length);
                this.receiveDgPacket(this.bkndDgSocket, this.bkndPacket);
                if (null == this.bkndPacket) {
                    throw new IOException();
                }
                byteArrayInputStream = new ByteArrayInputStream(this.bkndPacket.getData());
            }
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            long l = dataInputStream.readInt();
            long l2 = dataInputStream.readInt();
            double d3 = (double)l + (double)l2 / 1000000.0;
            double d4 = Math.IEEEremainder((Double)this.readDataElement(dataInputStream, 4), Math.PI * 2);
            int n2 = (Integer)this.readDataElement(dataInputStream, 2);
            double d5 = Math.IEEEremainder((Double)this.readDataElement(dataInputStream, 4), Math.PI * 2);
            int n3 = (Integer)this.readDataElement(dataInputStream, 2);
            double d6 = (Double)this.readDataElement(dataInputStream, 4);
            int n4 = (Integer)this.readDataElement(dataInputStream, 2);
            int n5 = n2 | n3 | n4;
            int n6 = (n5 & 1) != 0 ? 2 : ((n5 & 2) != 0 ? 1 : 0);
            if (filter instanceof StdDevFilter) {
                d2 = Math.IEEEremainder((Double)this.readDataElement(dataInputStream, 4), Math.PI);
                dataInputStream.skip(8L);
                d = Math.IEEEremainder((Double)this.readDataElement(dataInputStream, 4), Math.PI);
                dataInputStream.skip(8L);
                double d7 = (Double)this.readDataElement(dataInputStream, 4);
                measurePointStdDev = new MeasurePointStdDev(d2, d, d7);
            } else {
                measurePointStdDev = null;
            }
            d2 = 1.0E-25;
            d = 1.0E10;
            boolean bl3 = false;
            if (Math.abs(d4) < d2 && 0 == n2 || Math.abs(d5) < d2 && 0 == n3 || d6 < d2 && 0 == n4 || Math.abs(d4) > d && 0 == n2 || Math.abs(d5) > d && 0 == n3 || d6 > d && 0 == n4) {
                bl3 = true;
            }
            if (bl3) {
                --i;
                continue;
            }
            measurePointDataArray[i] = new MeasurePointData(d3, d4, d5, d6, n6, measurePointStdDev);
        }
        return measurePointDataArray;
    }

    private MeasurePointData[] readPointData(Ftp ftp, int n, Filter filter) throws IOException, FtpException {
        MeasurePointData[] measurePointDataArray = this.localReadPointData(ftp, n, filter, false, false);
        return measurePointDataArray;
    }

    @Override
    public synchronized void stopMeasurePoint() throws TrackerException {
        this.localStopMeasure(false);
    }

    @Override
    public synchronized void startBkndMeasure(MeasureCfg measureCfg, DataTag[] dataTagArray) throws TrackerException {
        this.localStartBkndMeasure(measureCfg, dataTagArray, true, false);
    }

    @Override
    public synchronized void startFactoryBkndMeasure(MeasureCfg measureCfg, DataTag[] dataTagArray) throws TrackerException {
        this.localStartBkndMeasure(measureCfg, dataTagArray, true, true);
    }

    private synchronized void localStartBkndMeasure(MeasureCfg measureCfg, DataTag[] dataTagArray, boolean bl, boolean bl2) throws TrackerException {
        this.readyForCommand();
        String string = "\\data\\bkndmeas1.arg";
        if (bl2) {
            if (this.isFactoryBkndMeasuring()) {
                throw new InterfaceBusyException("Factory background measurements in progress");
            }
            string = "\\data\\bkndmeas2.arg";
        } else if (this.isBkndMeasuring()) {
            throw new InterfaceBusyException("Background measurements in progress");
        }
        Object object = this.checkAndSendCFGData(measureCfg, dataTagArray, true, bl2, this.ftpClient, string);
        int n = this.receiveBkndMeasurementData(this.ftpClient, bl2);
        if (n != 200) {
            throw TrackerVector.exceptionFromResponse(this.ftpClient, n);
        }
        if (bl2) {
            if (object != null) {
                this.factoryBkndMeasureTypeList = (int[])object;
                this.factoryBkndMeasureFilter = measureCfg.getFilter();
            }
            this.factoryBkndGeneralMeasureFlag = bl;
            this.factoryBkndMeasureInProgress = true;
        } else {
            if (object != null) {
                this.bkndMeasureTypeList = (int[])object;
                this.bkndMeasureFilter = measureCfg.getFilter();
            }
            this.bkndGeneralMeasureFlag = bl;
            this.bkndMeasureInProgress = true;
        }
    }

    private boolean isBkndMeasuring() {
        return this.bkndMeasureInProgress;
    }

    private boolean isFactoryBkndMeasuring() {
        return this.factoryBkndMeasureInProgress;
    }

    private int receiveBkndMeasurementData(Ftp ftp, boolean bl) throws TrackerException {
        DatagramSocket datagramSocket = null;
        try {
            datagramSocket = new DatagramSocket();
            datagramSocket.setSoTimeout(5000);
            byte[] byArray = ftp.getIPAddress().getAddress();
            int n = datagramSocket.getLocalPort();
            int[] nArray = new int[4];
            for (int i = 0; i < 4; ++i) {
                nArray[i] = byArray[i];
                if (nArray[i] >= 0) continue;
                int n2 = i;
                nArray[n2] = nArray[n2] + 256;
            }
            int n3 = ftp.command("bkndmeasure " + (bl ? "2 " : "1 ") + nArray[0] + "," + nArray[1] + "," + nArray[2] + "," + nArray[3] + "," + n / 256 + "," + n % 256, 10000);
            if (bl) {
                this.factoryBkndDgSocket = datagramSocket;
            } else {
                this.bkndDgSocket = datagramSocket;
            }
            return n3;
        }
        catch (SocketException socketException) {
            if (datagramSocket != null) {
                datagramSocket.close();
            }
            throw new CommunicationException("measurement data exception");
        }
        catch (FtpException ftpException) {
            throw TrackerVector.convertFtpExc(ftpException);
        }
    }

    @Override
    public MeasureData[] readBkndMeasureData(int n) throws TrackerException {
        return this.localReadBkndMeasureData(n, false);
    }

    @Override
    public MeasureData[] readFactoryBkndMeasureData(int n) throws TrackerException {
        return this.localReadBkndMeasureData(n, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MeasureData[] localReadBkndMeasureData(int n, boolean bl) throws TrackerException {
        boolean bl2;
        MeasureData[] measureDataArray = null;
        do {
            bl2 = false;
            this.testAndSetBkndReadData(true, bl);
            try {
                measureDataArray = bl ? this.readBkndData(true, n, this.factoryBkndMeasureTypeList, this.factoryBkndMeasureFilter) : this.readBkndData(false, n, this.bkndMeasureTypeList, this.bkndMeasureFilter);
                bl2 = false;
            }
            catch (IOException iOException) {
                throw new CommunicationException("measurement data exception");
            }
            catch (FtpException ftpException) {
                bl2 = true;
            }
            finally {
                this.releaseBkndReadData(bl);
            }
        } while (bl2);
        return measureDataArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testAndSetBkndReadData(boolean bl, boolean bl2) throws TrackerException {
        TrackerVector trackerVector = this;
        synchronized (trackerVector) {
            if (!this.isConnected()) {
                throw new NotConnectedException();
            }
            if (bl2) {
                if (!this.isFactoryBkndMeasuring() || bl != this.factoryBkndGeneralMeasureFlag) {
                    throw new NoDataAvailableException();
                }
                if (this.factoryBkndReadInProgress) {
                    throw new InterfaceBusyException("Background read in progress");
                }
                this.factoryBkndReadInProgress = true;
            } else {
                if (!this.isBkndMeasuring() || bl != this.bkndGeneralMeasureFlag) {
                    throw new NoDataAvailableException();
                }
                if (this.bkndReadInProgress) {
                    throw new InterfaceBusyException("Background read in progress");
                }
                this.bkndReadInProgress = true;
            }
        }
    }

    private void receiveDgPacket(DatagramSocket datagramSocket, DatagramPacket datagramPacket) throws IOException {
        while (true) {
            try {
                datagramSocket.receive(datagramPacket);
            }
            catch (InterruptedIOException interruptedIOException) {
                if (this.isConnected()) continue;
                throw new IOException();
            }
            break;
        }
    }

    private MeasureData[] readBkndData(boolean bl, int n, int[] nArray, Filter filter) throws IOException, FtpException {
        MeasureData[] measureDataArray = new MeasureData[n];
        for (int i = 0; i < n; ++i) {
            MeasureStdDev measureStdDev;
            ByteArrayInputStream byteArrayInputStream;
            if (bl) {
                this.factoryBkndBuf = filter instanceof StdDevFilter ? new byte[(nArray.length * 8 + 8) * 2] : new byte[nArray.length * 8 + 8];
                this.factoryBkndPacket = new DatagramPacket(this.factoryBkndBuf, this.factoryBkndBuf.length);
                this.receiveDgPacket(this.factoryBkndDgSocket, this.factoryBkndPacket);
                if (null == this.factoryBkndPacket) {
                    throw new IOException();
                }
                byteArrayInputStream = new ByteArrayInputStream(this.factoryBkndPacket.getData());
            } else {
                this.bkndBuf = filter instanceof StdDevFilter ? new byte[(nArray.length * 8 + 8) * 2] : new byte[nArray.length * 8 + 8];
                this.bkndPacket = new DatagramPacket(this.bkndBuf, this.bkndBuf.length);
                this.receiveDgPacket(this.bkndDgSocket, this.bkndPacket);
                if (null == this.bkndPacket) {
                    throw new IOException();
                }
                byteArrayInputStream = new ByteArrayInputStream(this.bkndPacket.getData());
            }
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            Object[] objectArray = new Object[nArray.length];
            long l = dataInputStream.readInt();
            long l2 = dataInputStream.readInt();
            double d = (double)l + (double)l2 / 1000000.0;
            for (int j = 0; j < nArray.length; ++j) {
                objectArray[j] = this.readDataElement(dataInputStream, nArray[j]);
            }
            if (filter instanceof StdDevFilter) {
                Object[] objectArray2 = new Object[nArray.length];
                for (int j = 0; j < nArray.length; ++j) {
                    objectArray2[j] = this.readDataElement(dataInputStream, nArray[j]);
                }
                measureStdDev = new MeasureStdDev(objectArray2);
            } else {
                measureStdDev = null;
            }
            measureDataArray[i] = new MeasureData(d, objectArray, measureStdDev);
        }
        return measureDataArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseBkndReadData(boolean bl) {
        TrackerVector trackerVector = this;
        synchronized (trackerVector) {
            if (bl) {
                this.factoryBkndReadInProgress = false;
            } else {
                this.bkndReadInProgress = false;
            }
        }
    }

    @Override
    public void stopBkndMeasure() throws TrackerException {
        this.localStopBkndMeasure(true, false);
    }

    @Override
    public void stopFactoryBkndMeasure() throws TrackerException {
        this.localStopBkndMeasure(true, true);
    }

    private synchronized void localStopBkndMeasure(boolean bl, boolean bl2) throws TrackerException {
        if (!this.isConnected()) {
            throw new NotConnectedException();
        }
        if (bl2) {
            if (this.isFactoryBkndMeasuring() && bl == this.factoryBkndGeneralMeasureFlag) {
                try {
                    this.ftpClient.command("bkndmeasure 2", 10000);
                    this.factoryBkndDgSocket.close();
                    this.factoryBkndPacket = null;
                    this.factoryBkndMeasureInProgress = false;
                }
                catch (FtpIOException ftpIOException) {
                    this.factoryBkndDgSocket.close();
                    this.factoryBkndPacket = null;
                    this.factoryBkndMeasureInProgress = false;
                }
                catch (FtpNoResponseException ftpNoResponseException) {
                    this.factoryBkndDgSocket.close();
                    this.factoryBkndPacket = null;
                    this.factoryBkndMeasureInProgress = false;
                }
                catch (FtpException ftpException) {
                    throw TrackerVector.convertFtpExc(ftpException);
                }
            }
        } else if (this.isBkndMeasuring() && bl == this.bkndGeneralMeasureFlag) {
            try {
                this.ftpClient.command("bkndmeasure 1", 10000);
                this.bkndDgSocket.close();
                this.bkndPacket = null;
                this.bkndMeasureInProgress = false;
            }
            catch (FtpIOException ftpIOException) {
                this.bkndDgSocket.close();
                this.bkndPacket = null;
                this.bkndMeasureInProgress = false;
            }
            catch (FtpNoResponseException ftpNoResponseException) {
                this.bkndDgSocket.close();
                this.bkndPacket = null;
                this.bkndMeasureInProgress = false;
            }
            catch (FtpException ftpException) {
                throw TrackerVector.convertFtpExc(ftpException);
            }
        }
    }

    @Override
    public synchronized void startBkndMeasurePoint(MeasureCfg measureCfg) throws TrackerException {
        this.localStartBkndMeasurePoint(measureCfg, false);
    }

    @Override
    public synchronized void startFactoryBkndMeasurePoint(MeasureCfg measureCfg) throws TrackerException {
        this.localStartBkndMeasurePoint(measureCfg, true);
    }

    private synchronized void localStartBkndMeasurePoint(MeasureCfg measureCfg, boolean bl) throws TrackerException {
        DataTag[] dataTagArray = new DataTag[]{new DataTagDouble("target.corrected.azimuth.value"), new DataTagUnsigned16("target.corrected.azimuth.status"), new DataTagDouble("target.corrected.zenith.value"), new DataTagUnsigned16("target.corrected.zenith.status"), new DataTagDouble("target.corrected.distance.value"), new DataTagUnsigned16("target.corrected.distance.status")};
        this.localStartBkndMeasure(measureCfg, dataTagArray, false, bl);
    }

    @Override
    public MeasurePointData[] readBkndMeasurePointData(int n) throws TrackerException {
        MeasurePointData[] measurePointDataArray = null;
        this.testAndSetBkndReadData(false, false);
        try {
            measurePointDataArray = this.readBkndPointData(this.ftpClient, false, n, this.bkndMeasureFilter);
        }
        catch (IOException iOException) {
            throw new CommunicationException("measurement data exception");
        }
        catch (FtpException ftpException) {
            throw TrackerVector.convertFtpExc(ftpException);
        }
        finally {
            this.releaseBkndReadData(false);
        }
        return measurePointDataArray;
    }

    @Override
    public MeasurePointData[] readFactoryBkndMeasurePointData(int n) throws TrackerException {
        MeasurePointData[] measurePointDataArray = null;
        this.testAndSetBkndReadData(false, true);
        try {
            measurePointDataArray = this.readBkndPointData(this.ftpClient, true, n, this.factoryBkndMeasureFilter);
        }
        catch (IOException iOException) {
            throw new CommunicationException("measurement data exception");
        }
        catch (FtpException ftpException) {
            throw TrackerVector.convertFtpExc(ftpException);
        }
        finally {
            this.releaseBkndReadData(true);
        }
        return measurePointDataArray;
    }

    @Override
    public void stopBkndMeasurePoint() throws TrackerException {
        this.localStopBkndMeasure(false, false);
    }

    @Override
    public void stopFactoryBkndMeasurePoint() throws TrackerException {
        this.localStopBkndMeasure(false, true);
    }

    private MeasurePointData[] readBkndPointData(Ftp ftp, boolean bl, int n, Filter filter) throws IOException, FtpException {
        MeasurePointData[] measurePointDataArray = this.localReadPointData(ftp, n, filter, true, bl);
        return measurePointDataArray;
    }

    @Override
    public synchronized void startAsync() throws TrackerException {
        int[] nArray = new int[4];
        this.readyForCommand();
        if (this.asyncRunning()) {
            throw new InterfaceBusyException("Async already running");
        }
        try {
            this.asyncSocket = new DatagramSocket();
            this.asyncSocket.setSoTimeout(5000);
            int n = this.asyncSocket.getLocalPort();
            byte[] byArray = this.ftpClient.getIPAddress().getAddress();
            for (int i = 0; i < 4; ++i) {
                nArray[i] = byArray[i];
                if (nArray[i] >= 0) continue;
                int n2 = i;
                nArray[n2] = nArray[n2] + 256;
            }
            int n3 = this.ftpClient.command("asyncmsg " + nArray[0] + "," + nArray[1] + "," + nArray[2] + "," + nArray[3] + "," + n / 256 + "," + n % 256, 10000);
            this.asyncReadInterrupted = false;
            this.asyncReadInProgress = false;
            if (n3 != 228 && n3 == 556) {
                throw TrackerVector.exceptionFromResponse(this.ftpClient, n3);
            }
        }
        catch (FtpException ftpException) {
            if (this.asyncSocket != null) {
                this.asyncSocket.close();
                this.asyncSocket = null;
            }
            throw TrackerVector.convertFtpExc(ftpException);
        }
        catch (IOException iOException) {
            if (this.asyncSocket != null) {
                this.asyncSocket.close();
                this.asyncSocket = null;
            }
            throw new CommunicationException("IO Exception");
        }
    }

    private boolean asyncRunning() {
        return this.asyncSocket != null;
    }

    @Override
    public Status[] statusHistory() throws TrackerException {
        Object[] objectArray = this.getHistory("\\message\\stathst.dat", Status.class);
        int n = objectArray.length;
        Status[] statusArray = new Status[n];
        for (int i = 0; i < n; ++i) {
            statusArray[i] = (Status)objectArray[i];
        }
        return statusArray;
    }

    private Change[] changeHistory() throws TrackerException {
        Object[] objectArray = this.getHistory("\\message\\eventhst.dat", Change.class);
        int n = objectArray.length;
        Change[] changeArray = new Change[n];
        for (int i = 0; i < n; ++i) {
            changeArray[i] = (Change)objectArray[i];
        }
        return changeArray;
    }

    @Override
    public synchronized void stopAsync() throws TrackerException {
        this.readyForCommand();
        if (!this.asyncRunning()) {
            return;
        }
        try {
            this.ftpClient.command("asyncmsg", 1000);
            this.asyncSocket.close();
            this.asyncSocket = null;
            this.asyncPacket = null;
        }
        catch (FtpIOException ftpIOException) {
            this.asyncSocket.close();
            this.asyncSocket = null;
            this.asyncPacket = null;
        }
        catch (FtpNoResponseException ftpNoResponseException) {
            this.asyncSocket.close();
            this.asyncSocket = null;
            this.asyncPacket = null;
        }
        catch (FtpException ftpException) {
            throw TrackerVector.convertFtpExc(ftpException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public AsyncMsg readAsyncMsg() throws TrackerException {
        String string = null;
        AsyncMsg asyncMsg = null;
        TrackerVector trackerVector = this;
        synchronized (trackerVector) {
            if (!this.asyncRunning()) {
                throw new NoDataAvailableException();
            }
            this.asyncReadInProgress = true;
        }
        try {
            while (!(string != null && asyncMsg != null || this.asyncReadInterrupted)) {
                try {
                    this.asyncBuf = new byte[256];
                    this.asyncPacket = new DatagramPacket(this.asyncBuf, this.asyncBuf.length);
                    this.receiveDgPacket(this.asyncSocket, this.asyncPacket);
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.asyncPacket.getData());
                    this.asyncInput = new BufferedReader(new InputStreamReader(byteArrayInputStream));
                    string = this.asyncInput.readLine();
                    asyncMsg = this.convertLineToAsync(string);
                }
                catch (InterruptedIOException interruptedIOException) {
                }
                catch (IOException iOException) {
                    throw new NoDataAvailableException();
                    return asyncMsg;
                }
            }
        }
        finally {
            trackerVector = this;
            synchronized (trackerVector) {
                this.asyncReadInProgress = false;
                while (this.asyncReadInterrupted) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    @Override
    public Diagnostic[] diagnosticHistory() throws TrackerException {
        Object[] objectArray = this.getHistory("\\message\\diaghst.dat", Diagnostic.class);
        int n = objectArray.length;
        Diagnostic[] diagnosticArray = new Diagnostic[n];
        for (int i = 0; i < n; ++i) {
            diagnosticArray[i] = (Diagnostic)objectArray[i];
        }
        return diagnosticArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object[] getHistory(String string, Class clazz) throws TrackerException {
        ArrayList<AsyncMsg> arrayList = null;
        TrackerException trackerException = null;
        this.readyForCommand();
        try {
            arrayList = new ArrayList<AsyncMsg>();
            int n = this.ftpClient.receiveStart(string);
            if (150 != n) {
                throw TrackerVector.exceptionFromResponse(this.ftpClient, n);
            }
            try {
                String string2;
                while (null != (string2 = this.ftpClient.receiveLine())) {
                    try {
                        AsyncMsg asyncMsg = this.convertLineToAsync(string2);
                        if (clazz != asyncMsg.getClass()) continue;
                        arrayList.add(asyncMsg);
                    }
                    catch (DataFormatException dataFormatException) {
                    }
                }
            }
            catch (FtpNoResponseException ftpNoResponseException) {
                // empty catch block
            }
        }
        catch (FtpException ftpException) {
            trackerException = TrackerVector.convertFtpExc(ftpException);
        }
        finally {
            block21: {
                try {
                    int n = this.ftpClient.receiveEnd();
                    if (226 != n) {
                        trackerException = TrackerVector.exceptionFromResponse(this.ftpClient, n);
                    }
                }
                catch (FtpException ftpException) {
                    if (null != trackerException) break block21;
                    trackerException = TrackerVector.convertFtpExc(ftpException);
                }
            }
        }
        if (null != trackerException) {
            throw trackerException;
        }
        if (null != arrayList && 0 != arrayList.size()) {
            return arrayList.toArray();
        }
        throw new NoDataAvailableException();
    }

    private AsyncMsg convertLineToAsync(String string) throws TrackerException {
        AsyncMsg asyncMsg = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        try {
            String string2 = stringTokenizer.nextToken();
            switch (string2.charAt(0)) {
                case 'D': {
                    asyncMsg = this.convertToDiag(string, stringTokenizer);
                    break;
                }
                case 'E': {
                    asyncMsg = this.convertToChange(string, stringTokenizer);
                    break;
                }
                case 'S': {
                    asyncMsg = this.convertToStatus(string, stringTokenizer);
                    break;
                }
                case 'A': {
                    asyncMsg = this.convertToAlarm(string, stringTokenizer);
                    break;
                }
                default: {
                    throw new NoSuchElementException();
                }
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new DataFormatException();
        }
        return asyncMsg;
    }

    private Diagnostic convertToDiag(String string, StringTokenizer stringTokenizer) {
        int n = Integer.parseInt(stringTokenizer.nextToken(), 16);
        int n2 = n < 0 || n >= diagMap.length ? 0 : diagMap[n];
        String string2 = "Code=" + n + " ";
        string2 = string2 + "Param1=" + stringTokenizer.nextToken() + " ";
        string2 = string2 + "Param2=" + stringTokenizer.nextToken() + " ";
        string2 = string2 + "Task=" + stringTokenizer.nextToken();
        double d = Double.parseDouble(stringTokenizer.nextToken());
        int n3 = Integer.parseInt(stringTokenizer.nextToken(), 16);
        return new Diagnostic(n2, d, n3, string2);
    }

    private Change convertToChange(String string, StringTokenizer stringTokenizer) {
        Object object;
        int n = Integer.parseInt(stringTokenizer.nextToken(), 16) & 0xFF;
        int n2 = n < 0 || n >= changeMap.length ? 0 : changeMap[n];
        int n3 = Integer.parseInt(stringTokenizer.nextToken());
        switch (n2) {
            case 2: {
                object = new Boolean(0 == n3);
                break;
            }
            case 1: {
                object = new Boolean(1 == n3);
                break;
            }
            case 4: {
                try {
                    object = this.constructTargetType(n3);
                }
                catch (TrackerException trackerException) {
                    object = null;
                }
                break;
            }
            case 3: {
                object = this.constructDistanceMode(n3);
                break;
            }
            default: {
                object = null;
            }
        }
        double d = Double.parseDouble(stringTokenizer.nextToken());
        int n4 = Integer.parseInt(stringTokenizer.nextToken(), 16);
        return new Change(n2, d, n4, string, object);
    }

    private Status convertToStatus(String string, StringTokenizer stringTokenizer) {
        int n = Integer.parseInt(stringTokenizer.nextToken(), 16) & 0xFF;
        String string2 = stringTokenizer.nextToken();
        double d = Double.parseDouble(stringTokenizer.nextToken());
        int n2 = Integer.parseInt(stringTokenizer.nextToken(), 16);
        boolean bl = string2.compareToIgnoreCase("on") == 0;
        int n3 = n < 0 || n >= statusMap.length ? 0 : statusMap[n];
        return new Status(n3, bl, d, n2, string);
    }

    private Alarm convertToAlarm(String string, StringTokenizer stringTokenizer) {
        int n = Integer.parseInt(stringTokenizer.nextToken());
        String string2 = stringTokenizer.nextToken();
        double d = Double.parseDouble(stringTokenizer.nextToken());
        int n2 = Integer.parseInt(stringTokenizer.nextToken(), 16);
        boolean bl = string2.compareToIgnoreCase("on") == 0;
        return new Alarm(n, bl, d, n2, string);
    }

    @Override
    public Alarm[] alarmHistory() throws TrackerException {
        Object[] objectArray = this.getHistory("\\message\\alarmhst.dat", Alarm.class);
        int n = objectArray.length;
        Alarm[] alarmArray = new Alarm[n];
        for (int i = 0; i < n; ++i) {
            alarmArray[i] = (Alarm)objectArray[i];
        }
        return alarmArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeOneTimeData(Ftp ftp, DataTag[] dataTagArray, Object[] objectArray) throws TrackerException {
        int n;
        TrackerException trackerException = null;
        TrackerVector.writeOneTimePoints(ftp, dataTagArray);
        try {
            n = ftp.sendStart("\\data\\singlbin.dat");
            if (150 != n) {
                throw TrackerVector.exceptionFromResponse(ftp, n);
            }
        }
        catch (FtpException ftpException) {
            throw TrackerVector.convertFtpExc(ftpException);
        }
        int[] nArray = TrackerVector.createTypeList(dataTagArray);
        try {
            for (int i = 0; i < dataTagArray.length; ++i) {
                TrackerVector.writeDataElement(ftp, objectArray[i], nArray[i]);
            }
        }
        catch (FtpException ftpException) {
            trackerException = TrackerVector.convertFtpExc(ftpException);
        }
        finally {
            block18: {
                try {
                    n = ftp.sendEnd(10000);
                    if (226 != n) {
                        trackerException = TrackerVector.exceptionFromResponse(ftp, n);
                    }
                }
                catch (FtpException ftpException) {
                    if (null != trackerException) break block18;
                    trackerException = TrackerVector.convertFtpExc(ftpException);
                }
            }
        }
        if (null != trackerException) {
            throw trackerException;
        }
    }

    @Override
    public synchronized void writeOneTimeData(DataTag[] dataTagArray, Object[] objectArray) throws TrackerException {
        this.readyForCommand();
        this.storeOneTimeData(this.ftpClient, dataTagArray, objectArray);
    }

    private static void writeDataElement(Ftp ftp, Object object, int n) throws FtpException {
        switch (n) {
            case 1: {
                byte by = (byte)((Short)object & 0xFF);
                ftp.sendByte(by);
                ftp.sendByte((byte)0);
                ftp.sendUnsignedShort(0);
                ftp.sendUnsignedInt(0L);
                break;
            }
            case 2: {
                ftp.sendUnsignedShort(((Integer)object).intValue());
                ftp.sendUnsignedShort(0);
                ftp.sendUnsignedInt(0L);
                break;
            }
            case 3: {
                ftp.sendUnsignedInt(((Long)object).longValue());
                ftp.sendUnsignedInt(0L);
                break;
            }
            case 4: {
                ftp.sendDouble(((Double)object).doubleValue());
            }
        }
    }

    static Object[] getTagData(Ftp ftp, DataTag[] dataTagArray) throws TrackerException {
        Object[] objectArray = null;
        TrackerException trackerException = null;
        TrackerVector.writeOneTimePoints(ftp, dataTagArray);
        for (int i = 0; i < 3; ++i) {
            trackerException = null;
            try {
                objectArray = TrackerVector.readOneTimePoints(ftp, dataTagArray);
            }
            catch (TrackerException trackerException2) {
                trackerException = trackerException2;
            }
            if (null == trackerException) break;
        }
        if (null != trackerException) {
            throw trackerException;
        }
        return objectArray;
    }

    @Override
    public synchronized Object[] readOneTimeData(DataTag[] dataTagArray) throws TrackerException {
        this.readyForCommand();
        return TrackerVector.getTagData(this.ftpClient, dataTagArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object[] readOneTimePoints(Ftp ftp, DataTag[] dataTagArray) throws TrackerException {
        int n;
        TrackerException trackerException = null;
        Object[] objectArray = new Object[dataTagArray.length];
        int[] nArray = TrackerVector.createTypeList(dataTagArray);
        try {
            n = ftp.receiveStart("\\data\\singlbin.dat");
            if (150 != n) {
                throw TrackerVector.exceptionFromResponse(ftp, n);
            }
        }
        catch (FtpException ftpException) {
            throw TrackerVector.convertFtpExc(ftpException);
        }
        try {
            for (int i = 0; i < dataTagArray.length; ++i) {
                objectArray[i] = TrackerVector.readDataElement(ftp, nArray[i]);
            }
        }
        catch (FtpException ftpException) {
            trackerException = TrackerVector.convertFtpExc(ftpException);
        }
        finally {
            block18: {
                try {
                    n = ftp.receiveEnd();
                    if (226 != n) {
                        trackerException = TrackerVector.exceptionFromResponse(ftp, n);
                    }
                }
                catch (FtpException ftpException) {
                    if (null != trackerException) break block18;
                    trackerException = TrackerVector.convertFtpExc(ftpException);
                }
            }
        }
        if (null != trackerException) {
            throw trackerException;
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeOneTimePoints(Ftp ftp, DataTag[] dataTagArray) throws TrackerException {
        int n;
        TrackerException trackerException = null;
        try {
            n = ftp.sendStart("\\data\\single.arg");
            if (n != 150) {
                throw TrackerVector.exceptionFromResponse(ftp, n);
            }
        }
        catch (FtpException ftpException) {
            throw TrackerVector.convertFtpExc(ftpException);
        }
        try {
            for (int i = 0; i < dataTagArray.length; ++i) {
                ftp.sendLine(dataTagArray[i].getName());
            }
        }
        catch (FtpException ftpException) {
            trackerException = TrackerVector.convertFtpExc(ftpException);
        }
        finally {
            block18: {
                try {
                    n = ftp.sendEnd(10000);
                    if (n != 226 && trackerException == null) {
                        trackerException = TrackerVector.exceptionFromResponse(ftp, n);
                    }
                }
                catch (FtpException ftpException) {
                    if (trackerException != null) break block18;
                    trackerException = TrackerVector.convertFtpExc(ftpException);
                }
            }
        }
        if (trackerException != null) {
            throw trackerException;
        }
    }

    private static Object readDataElement(Ftp ftp, int n) throws FtpException {
        Number number = null;
        switch (n) {
            case 1: {
                short s = (short)((short)ftp.receiveByte() & 0xFF);
                number = new Short(s);
                ftp.receiveSkip(7);
                break;
            }
            case 2: {
                number = new Integer(ftp.receiveUnsignedShort());
                ftp.receiveSkip(6);
                break;
            }
            case 3: {
                number = new Long(ftp.receiveUnsignedInt());
                ftp.receiveSkip(4);
                break;
            }
            case 4: {
                number = new Double(ftp.receiveDouble());
            }
        }
        return number;
    }

    @Override
    public boolean connected() throws TrackerException {
        return this.isConnected();
    }

    @Override
    public boolean targetPresent() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32("target.state")};
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        return ((Long)objectArray[0]).intValue() == 2;
    }

    @Override
    public boolean targetLocationValid() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned16("target.corrected.azimuth.status"), new DataTagUnsigned16("target.corrected.zenith.status"), new DataTagUnsigned16("target.corrected.distance.status")};
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        return (Integer)objectArray[0] == 0 && (Integer)objectArray[1] == 0 && (Integer)objectArray[2] == 0;
    }

    @Override
    public boolean motorsOn() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32("servo.motor_state.current")};
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        return ((Long)objectArray[0]).intValue() == 1;
    }

    @Override
    public boolean initialized() throws TrackerException {
        return this.initialized(true);
    }

    @Override
    public boolean initialized(boolean bl) throws TrackerException {
        DataTag[] dataTagArray = new DataTag[4];
        DataTag[] dataTagArray2 = new DataTag[1];
        dataTagArray[0] = new DataTagUnsigned32("servo.motor_state.current");
        dataTagArray[1] = new DataTagUnsigned16("position_device.psd.raw.a.status");
        dataTagArray[2] = new DataTagUnsigned16("position_device.azimuth_encoder.reading.status");
        dataTagArray[3] = new DataTagUnsigned16("position_device.zenith_encoder.reading.status");
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        if ((Long)objectArray[0] != 0L && (Long)objectArray[0] != 1L) {
            return false;
        }
        if (0 != ((Integer)objectArray[1] & 0x20)) {
            return false;
        }
        if (0 != (1 & (Integer)objectArray[2]) || 0 != (0x20 & (Integer)objectArray[2]) || 0 != (1 & (Integer)objectArray[3]) || 0 != (0x20 & (Integer)objectArray[3])) {
            return false;
        }
        if (!bl) {
            dataTagArray2[0] = new DataTagUnsigned16("system.zero_correct.time.status");
            objectArray = this.readOneTimeData(dataTagArray2);
            if ((Integer)objectArray[0] != 0) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean trackingOn() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32("servo.tracking_mode")};
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        return ((Long)objectArray[0]).intValue() == 0;
    }

    @Override
    public boolean admCapable() throws TrackerException {
        return true;
    }

    @Override
    public boolean admOnlyCapable() {
        return true;
    }

    @Override
    public boolean interferometerCapable() throws TrackerException {
        return false;
    }

    @Override
    public boolean levelCapable() throws TrackerException {
        return true;
    }

    @Override
    public DistanceMode distanceMeasureMode() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32("system.distance_mode")};
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        return this.constructDistanceMode((int)((Long)objectArray[0]).longValue());
    }

    private DistanceMode constructDistanceMode(int n) {
        switch (n) {
            case 1: {
                return new InterferometerOnly();
            }
            case 3: {
                return new ADMOnly();
            }
            case 2: {
                return new InterferometerSetByADM();
            }
            case 0: {
                return new UserSpecifiedDistance();
            }
        }
        return new InterferometerOnly();
    }

    @Override
    public TargetType targetType() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32("target.type")};
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        return this.constructTargetType((int)((Long)objectArray[0]).longValue());
    }

    private TargetType constructTargetType(int n) throws TrackerException {
        switch (n) {
            case 0: {
                return new SMRTargetType(0.0381);
            }
            case 1: {
                return new MirrorTargetType();
            }
            case 2: {
                return new SMRTargetType(0.0127);
            }
            case 3: {
                return new SMRTargetType(0.022225);
            }
            case 4: {
                return new SMRTargetType(0.0);
            }
            case 5: {
                return new WindowedSMRTargetType(0.0381);
            }
            case 6: {
                return new WindowedSMRTargetType(0.022225);
            }
        }
        throw new UnsupportedFeatureException("Target type not supported.");
    }

    @Override
    public boolean backsightOrientation() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32("system.orientation")};
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        return ((Long)objectArray[0]).intValue() == 1;
    }

    @Override
    public LevelData measureLevel() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[6];
        Object[] objectArray = null;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        this.trackerCommand("level run", 180000);
        dataTagArray[0] = new DataTagDouble("fine_level.tilt.rx.value");
        dataTagArray[1] = new DataTagUnsigned16("fine_level.tilt.rx.status");
        dataTagArray[2] = new DataTagDouble("fine_level.tilt.ry.value");
        dataTagArray[3] = new DataTagUnsigned16("fine_level.tilt.ry.status");
        dataTagArray[4] = new DataTagDouble("fine_level.tilt.rz.value");
        dataTagArray[5] = new DataTagUnsigned16("fine_level.tilt.rz.status");
        objectArray = this.readOneTimeData(dataTagArray);
        n = (Integer)objectArray[1];
        n2 = (Integer)objectArray[3];
        n3 = (Integer)objectArray[5];
        if ((n & 1) != 0 || (n2 & 1) != 0 || (n3 & 1) != 0) {
            throw new InternalDeviceFailureException("Level error");
        }
        if ((n & 2) != 0 || (n2 & 2) != 0 || (n3 & 2) != 0) {
            throw new InternalDeviceFailureException("Level inaccurate");
        }
        d = (Double)objectArray[0];
        d2 = (Double)objectArray[2];
        d3 = (Double)objectArray[4];
        return new LevelData(d, d2, d3);
    }

    @Override
    public MaterialTemperatureData measureMaterialTemperature() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[3];
        Object[] objectArray = null;
        double d = 0.0;
        int n = 0;
        int n2 = 0;
        dataTagArray[0] = new DataTagDouble("weather.current.ext_material.value");
        dataTagArray[1] = new DataTagUnsigned16("weather.current.ext_material.status");
        dataTagArray[2] = new DataTagUnsigned32("weather.current.ext_material.count");
        objectArray = this.readOneTimeData(dataTagArray);
        d = (Double)objectArray[0];
        n = (Integer)objectArray[1];
        n2 = (int)((Long)objectArray[2]).longValue();
        if (n2 == 0) {
            throw new InternalDeviceFailureException("Sensor not found");
        }
        if ((n & 0x80) != 0) {
            throw new InternalDeviceFailureException("Sensor disabled");
        }
        if ((n & 2) != 0) {
            throw new InternalDeviceFailureException("Sensor inaccurate");
        }
        if ((n & 1) != 0) {
            throw new InternalDeviceFailureException("Sensor error");
        }
        return new MaterialTemperatureData(d, n2);
    }

    @Override
    public TrackerApp startApplication(String string, String string2, Tracker tracker, JFrame jFrame) throws TrackerException {
        Class[] classArray = new Class[3];
        Object[] objectArray = new Object[3];
        this.readyForCommand();
        AppRec appRec = this.findAppInfo(string);
        if (!this.initialLocalAppValueSet) {
            this.loadingLocalApp = appRec.readFromLocal;
            this.initialLocalAppValueSet = true;
        }
        if (this.loadingLocalApp != appRec.readFromLocal) {
            this.closeCachedJars();
            this.jarClassLoader = null;
            this.jarClassLoader = new JarClassLoader();
            this.loadingLocalApp = appRec.readFromLocal;
        }
        if (appRec.isSet()) {
            throw new ApplicationFailedException("Application already running");
        }
        try {
            int n;
            this.jarClassLoader.setAppName(string);
            Class<?> clazz = this.jarClassLoader.loadClass(appRec.fullQualifiedName);
            classArray[0] = String.class;
            classArray[1] = Tracker.class;
            classArray[2] = JFrame.class;
            Constructor<?> constructor = clazz.getConstructor(classArray);
            objectArray[0] = string2;
            objectArray[1] = tracker;
            objectArray[2] = jFrame;
            TrackerApp trackerApp = (TrackerApp)constructor.newInstance(objectArray);
            if ("CompIT".equalsIgnoreCase(string)) {
                n = 0;
                if (null != string2) {
                    n = string2.toUpperCase(Locale.ENGLISH).indexOf("QUICK_COMP");
                    if (-1 != n) {
                        this.subCompApp = "QuickComp";
                    } else if (-1 != string2.toUpperCase(Locale.ENGLISH).indexOf("AAC") || -1 != string2.toUpperCase(Locale.ENGLISH).indexOf("QBC")) {
                        this.subCompApp = "AngularAccuracy";
                    }
                }
            }
            for (n = 0; n < this.maintainApp.size(); ++n) {
                appRec = (AppRec)this.maintainApp.get(n);
                if (!appRec.appName.equals(string)) continue;
                appRec.set(trackerApp);
                this.maintainApp.set(n, appRec);
                if (this.subCompApp.length() <= 0) break;
                this.setSubAppStateForCompIT(trackerApp);
                break;
            }
            return trackerApp;
        }
        catch (FtpException ftpException) {
            PrintException.print((Exception)((Object)ftpException));
            throw new ApplicationFailedException("Could not invoke application");
        }
        catch (ClassNotFoundException classNotFoundException) {
            PrintException.print(classNotFoundException);
            throw new ApplicationFailedException(classNotFoundException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            PrintException.print(illegalAccessException);
            throw new ApplicationFailedException("Illegal access");
        }
        catch (InstantiationException instantiationException) {
            PrintException.print(instantiationException);
            throw new ApplicationFailedException("Instantiation failed");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            PrintException.print(noSuchMethodException);
            throw new ApplicationFailedException("Could not get constructor");
        }
        catch (InvocationTargetException invocationTargetException) {
            PrintException.print(invocationTargetException);
            throw new ApplicationFailedException("Could not invoke application");
        }
    }

    private void setSubAppStateForCompIT(TrackerApp trackerApp) {
        AppRec appRec = null;
        for (int i = 0; i < this.maintainApp.size(); ++i) {
            appRec = (AppRec)this.maintainApp.get(i);
            if (!appRec.appName.equals(this.subCompApp)) continue;
            if (null != trackerApp) {
                appRec.set(trackerApp);
                this.maintainApp.set(i, appRec);
                break;
            }
            appRec.clear();
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void setAppInfo() throws TrackerException {
        var1_1 = 0;
        var2_2 = 0;
        this.maintainApp = new LinkedList<E>();
        var3_3 = null;
        var4_4 = "";
        var5_5 = "";
        try {
            var1_1 = this.ftpClient.receiveStart("\\signatur\\capability.dat");
            if (150 != var1_1) {
                throw TrackerVector.exceptionFromResponse(this.ftpClient, var1_1);
            }
        }
        catch (FtpException var6_6) {
            throw TrackerVector.convertFtpExc(var6_6);
        }
        try {
            block13: while (true) {
                if (var4_4 == null) {
                    break;
                }
                var4_4 = this.ftpClient.receiveLine();
                if (var4_4.indexOf(91) == -1) continue;
                var2_2 = var4_4.indexOf(93);
                var5_5 = var4_4.substring(1, var2_2);
                if (var5_5.toUpperCase(Locale.ENGLISH).equals("APPS")) {
                    var6_7 = "";
                    var7_11 = "";
                    var8_12 = "";
                    var9_13 = "";
                    var10_15 = null;
                    var11_16 = 0;
                    var12_17 = null;
                    var4_4 = this.ftpClient.receiveLine();
                    while (true) {
                        if (var4_4 == null || var4_4.equals("") || var4_4.indexOf(91) != -1) continue block13;
                        var12_17 = new StringTokenizer(var4_4, ",");
                        var6_7 = var12_17.nextToken().trim();
                        var7_11 = var12_17.nextToken().trim();
                        var8_12 = var12_17.nextToken().trim();
                        var12_17 = new StringTokenizer((String)var8_12, " ");
                        var11_16 = var12_17.countTokens();
                        var13_18 = new Object[2];
                        var10_15 = new String[var11_16];
                        for (var14_19 = 0; var14_19 < var11_16; ++var14_19) {
                            var9_13 = var12_17.nextToken().trim();
                            var10_15[var14_19] = var9_13.substring(1, var9_13.indexOf(34, 1));
                        }
                        var13_18[0] = var10_15;
                        var3_3 = new AppRec(var6_7, var7_11, var13_18, false);
                        this.maintainApp.add(var3_3);
                        if ("CompIT".equalsIgnoreCase(var6_7)) {
                            var14_20 = new AppRec("Pointing", var7_11, var13_18, false);
                            this.maintainApp.add(var14_20);
                            var14_20 = new AppRec("AngularAccuracy", var7_11, var13_18, false);
                            this.maintainApp.add(var14_20);
                            var14_20 = new AppRec("QuickComp", var7_11, var13_18, false);
                            this.maintainApp.add(var14_20);
                            var14_20 = new AppRec("ADM", var7_11, var13_18, false);
                            this.maintainApp.add(var14_20);
                        }
                        var4_4 = this.ftpClient.receiveLine();
                    }
                }
                if (var5_5.toUpperCase(Locale.ENGLISH).equals("OPTIONAL HARDWARE")) {
                    var6_7 = "";
                    var7_11 = "";
                    var8_12 = null;
                    var9_14 = false;
                    var4_4 = this.ftpClient.receiveLine();
                    while (true) {
                        if (var4_4 == null || var4_4.equals("") || var4_4.indexOf(91) != -1) continue block13;
                        var8_12 = new StringTokenizer(var4_4, " ");
                        var6_7 = var8_12.nextToken().trim().toUpperCase(Locale.ENGLISH);
                        var8_12.nextToken();
                        var7_11 = var8_12.nextToken().trim();
                        if (var7_11.equals("0")) {
                            var9_14 = false;
                        } else if (var7_11.equals("1")) {
                            var9_14 = true;
                        }
                        var4_4 = this.ftpClient.receiveLine();
                    }
                }
                var4_4 = this.ftpClient.receiveLine();
                while (true) {
                    if (var4_4 != null && !var4_4.equals("") && var4_4.indexOf(91) == -1) ** break;
                    continue block13;
                    var4_4 = this.ftpClient.receiveLine();
                }
                break;
            }
        }
        catch (FtpException var6_9) {
            PrintException.print((Exception)var6_9);
        }
        finally {
            try {
                this.ftpClient.receiveEnd();
            }
            catch (FtpException var6_10) {}
        }
        this.loadLocalApp();
    }

    private void loadLocalApp() {
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String[] stringArray = null;
        int n = 0;
        StringTokenizer stringTokenizer = null;
        AppRec appRec = null;
        AppRec appRec2 = null;
        boolean bl = false;
        String string7 = "/apps/Vantage/";
        this.fileDirectory = this.findClassPath();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.fileDirectory + string7 + "Apps.txt"));
            while ((string6 = bufferedReader.readLine()) != null) {
                int n2;
                stringTokenizer = new StringTokenizer(string6, ",");
                string = stringTokenizer.nextToken().trim();
                string2 = stringTokenizer.nextToken().trim();
                string3 = stringTokenizer.nextToken().trim();
                string4 = stringTokenizer.nextToken().trim();
                stringTokenizer = new StringTokenizer(string3, " ");
                n = stringTokenizer.countTokens();
                stringArray = new String[n];
                for (n2 = 0; n2 < n; ++n2) {
                    string5 = stringTokenizer.nextToken().trim();
                    stringArray[n2] = string7 + string5.substring(1, string5.indexOf(34, 1));
                }
                stringTokenizer = new StringTokenizer(string4, "=");
                string5 = stringTokenizer.nextToken().trim();
                bl = string5.toUpperCase(Locale.ENGLISH).equals("LOADFIRST") ? (string5 = stringTokenizer.nextToken().trim()).toUpperCase(Locale.ENGLISH).equals("TRUE") : false;
                for (n2 = 0; n2 < this.maintainApp.size(); ++n2) {
                    appRec2 = (AppRec)this.maintainApp.get(n2);
                    if (!string.equals(appRec2.appName)) continue;
                    appRec2.readFromLocal = bl;
                    appRec2.jarFileName[1] = stringArray;
                    break;
                }
                if (n2 != this.maintainApp.size()) continue;
                Object[] objectArray = new Object[2];
                objectArray[1] = stringArray;
                appRec = new AppRec(string, string2, objectArray, bl);
                this.maintainApp.add(appRec);
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String findClassPath() {
        String string = "";
        String string2 = "";
        String string3 = "";
        StringTokenizer stringTokenizer = null;
        StringTokenizer stringTokenizer2 = null;
        int n = 0;
        int n2 = 0;
        stringTokenizer = new StringTokenizer(System.getProperty("java.class.path"), ";");
        n = stringTokenizer.countTokens();
        for (int i = 0; i < n; ++i) {
            string = stringTokenizer.nextToken().trim();
            stringTokenizer2 = new StringTokenizer(string, "\\");
            n2 = stringTokenizer2.countTokens();
            string2 = "";
            string3 = "";
            for (int j = 0; j < n2; ++j) {
                string2 = stringTokenizer2.nextToken().trim();
                if (string2.toUpperCase(Locale.ENGLISH).equals("TRACKER.JAR")) {
                    return string3.substring(0, string3.length() - 1);
                }
                string3 = string3 + string2 + "/";
            }
        }
        return null;
    }

    private void clearAppInfo() throws TrackerException {
        if (this.maintainApp.size() == 0) {
            return;
        }
        for (int i = 0; i < this.maintainApp.size(); ++i) {
            AppRec appRec = (AppRec)this.maintainApp.get(i);
            if (!appRec.isSet()) continue;
            throw new InterfaceBusyException("Application running");
        }
        this.maintainApp.clear();
    }

    private AppRec findAppInfo(String string) throws TrackerException {
        AppRec appRec = null;
        AppRec appRec2 = null;
        for (int i = 0; i < this.maintainApp.size(); ++i) {
            appRec = (AppRec)this.maintainApp.get(i);
            if (!string.equals(appRec.appName)) continue;
            for (int j = i + 1; j < this.maintainApp.size(); ++j) {
                appRec2 = (AppRec)this.maintainApp.get(j);
                if (!string.equals(appRec2.appName)) continue;
                if (appRec2.readFromLocal) {
                    appRec.readFromLocal = appRec2.readFromLocal;
                }
                return appRec;
            }
            return appRec;
        }
        throw new ApplicationFailedException("Unknown application name");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modifyApplication(String string, String string2) throws TrackerException {
        TrackerVector trackerVector = this;
        synchronized (trackerVector) {
            AppRec appRec = this.findAppInfo(string);
            if (appRec.isSet()) {
                appRec.app.modifyParameters(string2);
            }
        }
    }

    @Override
    public TrackerApp stopApplication(String string) throws TrackerException {
        TrackerApp trackerApp = this.stopApplication(string, true);
        return trackerApp;
    }

    private void localStopApplication(AppRec appRec) {
        appRec.app.stop();
        appRec.clear();
        this.setSubAppStateForCompIT(null);
    }

    @Override
    public String[] startedApplications() throws TrackerException {
        AppRec appRec;
        int n;
        int n2 = 0;
        if (this.maintainApp.size() == 0) {
            return null;
        }
        for (n = 0; n < this.maintainApp.size(); ++n) {
            appRec = (AppRec)this.maintainApp.get(n);
            if (!appRec.isSet()) continue;
            ++n2;
        }
        if (n2 == 0) {
            return null;
        }
        String[] stringArray = new String[n2];
        int n3 = 0;
        for (n = 0; n < this.maintainApp.size(); ++n) {
            appRec = (AppRec)this.maintainApp.get(n);
            if (!appRec.isSet()) continue;
            stringArray[n3] = appRec.appName;
            ++n3;
        }
        return stringArray;
    }

    @Override
    public synchronized String[] availableApplications() throws TrackerException {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.maintainApp.size(); ++i) {
            AppRec appRec = (AppRec)this.maintainApp.get(i);
            if (appRec.appName.equals("QuickComp") || appRec.appName.equals("AngularAccuracy") || appRec.appName.equals("Pointing") || appRec.appName.equals("ADM")) continue;
            arrayList.add(appRec.appName);
        }
        String[] stringArray = new String[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            stringArray[i] = (String)arrayList.get(i);
        }
        arrayList = null;
        return stringArray;
    }

    @Override
    public void writeFile(String string, String string2) throws TrackerException {
        int n;
        FileInputStream fileInputStream;
        this.readyForCommand();
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new FileAccessException(fileNotFoundException.toString());
        }
        catch (SecurityException securityException) {
            throw new FileAccessException(securityException.toString());
        }
        try {
            n = this.ftpClient.sendStart(string2);
            if (n != 150) {
                throw TrackerVector.exceptionFromResponse(this.ftpClient, n);
            }
        }
        catch (FtpException ftpException) {
            throw TrackerVector.convertFtpExc(ftpException);
        }
        try {
            int n2;
            byte[] byArray;
            int n3 = fileInputStream.available();
            int n4 = n3 / 1200;
            if (n4 > 0) {
                byArray = new byte[1200];
                for (int i = 0; i < n4; ++i) {
                    fileInputStream.read(byArray);
                    this.ftpClient.sendBuffer(byArray);
                }
            }
            if ((n2 = n3 % 1200) > 0) {
                byArray = new byte[n2];
                fileInputStream.read(byArray);
                this.ftpClient.sendBuffer(byArray);
            }
        }
        catch (FtpException ftpException) {
            try {
                this.ftpClient.sendAbort();
            }
            catch (FtpException ftpException2) {
                // empty catch block
            }
            throw TrackerVector.convertFtpExc(ftpException);
        }
        catch (IOException iOException) {
            try {
                this.ftpClient.sendAbort();
            }
            catch (FtpException ftpException) {
                // empty catch block
            }
            throw new FileAccessException(iOException.toString());
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {}
        }
        try {
            n = this.ftpClient.sendEnd();
            if (n != 226) {
                throw TrackerVector.exceptionFromResponse(this.ftpClient, n);
            }
        }
        catch (FtpException ftpException) {
            throw TrackerVector.convertFtpExc(ftpException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readFile(String string, String string2) throws TrackerException {
        FileOutputStream fileOutputStream;
        TrackerException trackerException = null;
        this.readyForCommand();
        byte[] byArray = new byte[1200];
        try {
            fileOutputStream = new FileOutputStream(string, false);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new FileAccessException(fileNotFoundException.toString());
        }
        catch (SecurityException securityException) {
            throw new FileAccessException(securityException.toString());
        }
        try {
            int n;
            int n2 = this.ftpClient.receiveStart(string2);
            if (150 != n2) {
                throw TrackerVector.exceptionFromResponse(this.ftpClient, n2);
            }
            do {
                if ((n = this.ftpClient.receiveBuffer(byArray)) <= 0) continue;
                fileOutputStream.write(byArray, 0, n);
            } while (n > 0);
        }
        catch (FtpException ftpException) {
            trackerException = TrackerVector.convertFtpExc(ftpException);
        }
        catch (IOException iOException) {
            trackerException = new FileAccessException(iOException.toString());
        }
        finally {
            block31: {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
                try {
                    int n = this.ftpClient.receiveEnd();
                    if (226 != n) {
                        trackerException = TrackerVector.exceptionFromResponse(this.ftpClient, n);
                    }
                }
                catch (FtpException ftpException) {
                    if (null != trackerException) break block31;
                    trackerException = TrackerVector.convertFtpExc(ftpException);
                }
            }
        }
        if (null != trackerException) {
            throw trackerException;
        }
    }

    @Override
    public void changeAlarmCfg(int n, AlarmType alarmType) throws TrackerException {
        DataTag[] dataTagArray = new DataTag[3];
        Object[] objectArray = new Object[3];
        if (n < 1 || n > this.NUM_EXT_TEMP_SENSORS) {
            throw new UnsupportedFeatureException("Unknown alarm number");
        }
        String string = "alarm." + n;
        dataTagArray[0] = new DataTagUnsigned32(string + ".type");
        dataTagArray[1] = new DataTagDouble(string + ".setpoint");
        dataTagArray[2] = new DataTagDouble(string + ".deviation");
        this.fillAlarmData(alarmType, objectArray);
        this.writeOneTimeData(dataTagArray, objectArray);
    }

    private void fillAlarmData(AlarmType alarmType, Object[] objectArray) throws TrackerException {
        if (alarmType instanceof DeviationAlarm) {
            objectArray[0] = new Long(1L);
            objectArray[1] = new Double(((DeviationAlarm)alarmType).getSetPoint());
            objectArray[2] = new Double(((DeviationAlarm)alarmType).getDeviation());
            return;
        }
        if (alarmType instanceof NullAlarm) {
            objectArray[0] = new Long(0L);
            objectArray[1] = new Double(20.0);
            objectArray[2] = new Double(5.0);
            return;
        }
        if (alarmType instanceof HighAlarm) {
            objectArray[0] = new Long(2L);
            objectArray[1] = new Double(((HighAlarm)alarmType).getSetPoint());
            objectArray[2] = new Double(5.0);
            return;
        }
        if (alarmType instanceof LowAlarm) {
            objectArray[0] = new Long(3L);
            objectArray[1] = new Double(((LowAlarm)alarmType).getSetPoint());
            objectArray[2] = new Double(5.0);
            return;
        }
        throw new UnsupportedFeatureException("Unknown alarm type");
    }

    @Override
    public AlarmType alarmCfg(int n) throws TrackerException {
        DataTag[] dataTagArray = new DataTag[3];
        Object[] objectArray = null;
        String string = "";
        if (n < 1 || n > this.NUM_EXT_TEMP_SENSORS) {
            throw new UnsupportedFeatureException("Unknown alarm number");
        }
        string = "alarm." + n;
        dataTagArray[0] = new DataTagUnsigned32(string + ".type");
        dataTagArray[1] = new DataTagDouble(string + ".setpoint");
        dataTagArray[2] = new DataTagDouble(string + ".deviation");
        objectArray = this.readOneTimeData(dataTagArray);
        return this.getAlarmType(n, objectArray);
    }

    private AlarmType getAlarmType(int n, Object[] objectArray) throws TrackerException {
        long l = (Long)objectArray[0];
        if (l == 0L) {
            return new NullAlarm();
        }
        if (l == 2L) {
            return new HighAlarm((Double)objectArray[1]);
        }
        if (l == 3L) {
            return new LowAlarm((Double)objectArray[1]);
        }
        if (l == 1L) {
            return new DeviationAlarm((Double)objectArray[1], (Double)objectArray[2]);
        }
        return new NullAlarm();
    }

    @Override
    public ExtTempType externalTempType(int n) throws TrackerException {
        DataTag[] dataTagArray = new DataTag[1];
        if (n < 1 || n > this.NUM_EXT_TEMP_SENSORS) {
            throw new UnsupportedFeatureException("Unknown sensor number");
        }
        String string = "weather.device.temperature.ext" + n + ".type";
        dataTagArray[0] = new DataTagUnsigned32(string);
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        ExtTempType extTempType = (Long)objectArray[0] == 1L ? new AirExtTemp() : ((Long)objectArray[0] == 2L ? new MaterialExtTemp() : new NullExtTemp());
        return extTempType;
    }

    @Override
    public void changeExternalTempType(int n, ExtTempType extTempType) throws TrackerException {
        throw new UnsupportedFeatureException("Can't change external temp type.");
    }

    @Override
    public boolean externalTempTypeChangeable() throws TrackerException {
        return false;
    }

    @Override
    public int numExternalTempSensors() throws TrackerException {
        return this.NUM_EXT_TEMP_SENSORS;
    }

    @Override
    public double measureExternalTempSensor(int n) throws TrackerException {
        DataTag[] dataTagArray = new DataTag[2];
        if (n < 1 || n > this.NUM_EXT_TEMP_SENSORS) {
            throw new UnsupportedFeatureException("Unknown sensor number");
        }
        dataTagArray[0] = new DataTagDouble("weather.device.temperature.ext" + n + ".reading.value");
        dataTagArray[1] = new DataTagUnsigned16("weather.device.temperature.ext" + n + ".reading.status");
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        int n2 = (Integer)objectArray[1];
        if ((n2 & 1) != 0) {
            throw new InternalDeviceFailureException("Sensor error");
        }
        if ((n2 & 2) != 0) {
            throw new InternalDeviceFailureException("Sensor inaccurate");
        }
        return (Double)objectArray[0];
    }

    @Override
    public boolean standardPrivilege() throws TrackerException {
        if (!this.isConnected()) {
            throw new NotConnectedException();
        }
        return this.accessLevel >= 0;
    }

    @Override
    public boolean adminPrivilege() throws TrackerException {
        if (!this.isConnected()) {
            throw new NotConnectedException();
        }
        return this.accessLevel >= 1;
    }

    @Override
    public boolean factoryPrivilege() throws TrackerException {
        if (!this.isConnected()) {
            throw new NotConnectedException();
        }
        return this.accessLevel >= 2;
    }

    @Override
    public void readFileAbort() {
        try {
            this.ftpClient.sendAbort();
        }
        catch (FtpException ftpException) {
            // empty catch block
        }
    }

    @Override
    public void writeFileAbort() {
        try {
            this.ftpClient.sendAbort();
        }
        catch (FtpException ftpException) {
            // empty catch block
        }
    }

    @Override
    public boolean admScanCapable() throws TrackerException {
        return true;
    }

    @Override
    public TargetType[] availableTargetType() throws TrackerException {
        TargetType[] targetTypeArray = null;
        targetTypeArray = new TargetType[]{new SMRTargetType(0.0381), new MirrorTargetType(), new SMRTargetType(0.0127), new SMRTargetType(0.022225), new SMRTargetType(0.0), new WindowedSMRTargetType(0.0381), new WindowedSMRTargetType(0.022225)};
        return targetTypeArray;
    }

    @Override
    public WeatherInformation getWeatherInfo() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[9];
        int n = 0;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        dataTagArray[0] = new DataTagDouble("weather.current.air_temperature.value");
        dataTagArray[1] = new DataTagUnsigned16("weather.current.air_temperature.status");
        dataTagArray[2] = new DataTagDouble("weather.current.air_pressure.value");
        dataTagArray[3] = new DataTagUnsigned16("weather.current.air_pressure.status");
        dataTagArray[4] = new DataTagDouble("weather.current.humidity.value");
        dataTagArray[5] = new DataTagUnsigned16("weather.current.humidity.status");
        dataTagArray[6] = new DataTagUnsigned32("weather.config.air_temperature.source");
        dataTagArray[7] = new DataTagUnsigned32("weather.config.air_pressure.source");
        dataTagArray[8] = new DataTagUnsigned32("weather.config.humidity.source");
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        double d = (Double)objectArray[0];
        double d2 = (Double)objectArray[2];
        double d3 = (Double)objectArray[4];
        l = (Long)objectArray[6];
        l2 = (Long)objectArray[7];
        l3 = (Long)objectArray[8];
        n = (Integer)objectArray[1] | (Integer)objectArray[3] | (Integer)objectArray[5];
        if (0 == (n & 0xFFFFFFBF)) {
            return new WeatherInformation(d, d2, d3, l, l2, l3);
        }
        if ((n & 1) != 0) {
            throw new InternalDeviceFailureException("Sensor error");
        }
        if ((n & 0x80) != 0) {
            throw new InternalDeviceFailureException("Sensor disabled");
        }
        if ((n & 2) != 0) {
            throw new InternalDeviceFailureException("Sensor inaccurate");
        }
        throw new InternalDeviceFailureException("Sensor unknown error");
    }

    @Override
    public String getSerialNumber() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[4];
        String string = "";
        dataTagArray[0] = new DataTagUnsigned32("system.serial_num.value");
        dataTagArray[1] = new DataTagUnsigned32("system.serial_type.value");
        dataTagArray[2] = new DataTagUnsigned16("system.serial_num.status");
        dataTagArray[3] = new DataTagUnsigned16("system.serial_type.status");
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        long l = (Long)objectArray[0];
        long l2 = (Long)objectArray[1];
        int n = (Integer)objectArray[2];
        int n2 = (Integer)objectArray[3];
        if (0 == n && 0 == n2 && 0L != (2L & l2)) {
            string = "V01";
        }
        if (string == "") {
            return new String("Vantage");
        }
        string = string + "00";
        String string2 = "" + l;
        int n3 = 7 - string2.length();
        for (int i = 0; i < n3; ++i) {
            string = string + "0";
        }
        string = string + l;
        return string;
    }

    @Override
    public String getIPAddress() throws TrackerException {
        return this.ipAddressToUse;
    }

    @Override
    public boolean readyToInitialize(boolean bl) throws TrackerException {
        DataTag[] dataTagArray = new DataTag[1];
        if (!bl) {
            dataTagArray[0] = new DataTagUnsigned32("system.smart_warmup.state");
            try {
                Object[] objectArray = this.readOneTimeData(dataTagArray);
                long l = (Long)objectArray[0];
                if (l == 1L) {
                    return false;
                }
            }
            catch (TrackerException trackerException) {
                // empty catch block
            }
        }
        return true;
    }

    @Override
    public synchronized void factoryConnect(String string, String string2, String string3) throws TrackerException {
        boolean bl;
        boolean bl2 = bl = this.accessLevel >= 2;
        if (!bl) {
            throw new PermissionException("Will have to connect to the Tracker as factory to use this method");
        }
        if (this.isConnected()) {
            throw new TrackerException("Will have to disconnect to the Tracker using the factoryDisconnect() method to use this method");
        }
        if (!this.factoryDisconnect) {
            throw new TrackerException("Will have to connect and disconnect to the Tracker using connect() and factoryDisconnect() methods to use this method");
        }
        Object var5_5 = null;
        this.ftpClient = new Ftp();
        try {
            this.ftpClient.connect(string, string2, string3);
            this.factoryConnect = true;
            this.factoryDisconnect = false;
        }
        catch (FtpException ftpException) {
            this.ftpClient = null;
            throw new ConnectFailedException(ftpException.toString());
        }
    }

    @Override
    public void factoryDisconnect() throws TrackerException {
        boolean bl;
        boolean bl2 = bl = this.accessLevel >= 2;
        if (!bl) {
            throw new PermissionException("Will have to connect to the Tracker as factory to use this method");
        }
        if (!this.isConnected()) {
            throw new TrackerException("Will have to connect to the Tracker using connect() or factoryConnect() method to call this method");
        }
        try {
            this.ftpClient.disconnect();
            this.ftpClient = null;
            this.factoryDisconnect = true;
            this.factoryConnect = false;
            this.oldmeasureCfg = null;
            this.oldmeasureTags = null;
            this.oldbkndMeasureCfg = null;
            this.oldbkndMeasureTags = null;
            this.oldfactoryBkndMeasureCfg = null;
            this.oldfactoryBkndMeasureTags = null;
        }
        catch (FtpIOException ftpIOException) {
        }
        catch (FtpNoResponseException ftpNoResponseException) {
        }
        catch (FtpException ftpException) {
            throw new DisconnectFailedException();
        }
    }

    @Override
    public TrackerApp stopApplication(String string, boolean bl) throws TrackerException {
        if (bl && !this.isConnected()) {
            throw new NotConnectedException();
        }
        AppRec appRec = this.findAppInfo(string);
        if (!appRec.isSet()) {
            return null;
        }
        TrackerApp trackerApp = appRec.app;
        this.localStopApplication(appRec);
        return trackerApp;
    }

    @Override
    public int applicationExitCode(String string) throws TrackerException {
        AppRec appRec = this.findAppInfo(string);
        if (appRec.app != null) {
            return appRec.app.applicationExitCode();
        }
        return appRec.appExitCode;
    }

    @Override
    public void releaseLock() throws TrackerException {
        this.trackerCommand("release_lock", 10000);
    }

    @Override
    public void startSlew(double d, double d2, double d3) throws TrackerException {
        double d4 = 2.0;
        int n = 10000;
        if (Math.abs(d) > d4 || Math.abs(d2) > d4) {
            throw new TrackerException("Velocity value exceeds maximum permissible value");
        }
        if (d3 < 0.0) {
            throw new TrackerException("Minimum value for time is 1 second");
        }
        if (d3 > 0.0) {
            this.trackerCommand("slew " + d + " " + d2 + " " + d3, n);
        } else {
            this.trackerCommand("slew " + d + " " + d2, n);
        }
    }

    @Override
    public void startSlew(double d, double d2) throws TrackerException {
        this.startSlew(d, d2, 0.0);
    }

    @Override
    public void stopSlew() throws TrackerException {
        this.startSlew(0.0, 0.0);
    }

    @Override
    public boolean isResultReportingCapable() throws TrackerException {
        return true;
    }

    @Override
    public boolean isAdaptiveFilterCapable() throws TrackerException {
        return true;
    }

    @Override
    public ApplicationResults applicationResults(String string) throws TrackerException {
        String[] stringArray;
        DataTag[] dataTagArray = new DataTag[2];
        ApplicationResults applicationResults = null;
        AppRec appRec = this.findAppInfo(string);
        if (string.equalsIgnoreCase("Pointing")) {
            dataTagArray[0] = new DataTagUnsigned32("system.aim_it.result.value");
            dataTagArray[1] = new DataTagUnsigned32("system.aim_it.time.value");
        } else if (string.equalsIgnoreCase("AngularAccuracy")) {
            dataTagArray[0] = new DataTagUnsigned32("system.aa_check.result.value");
            dataTagArray[1] = new DataTagUnsigned32("system.aa_check.time.value");
        } else if (string.equalsIgnoreCase("ADM")) {
            dataTagArray[0] = new DataTagUnsigned32("system.adm_check.result.value");
            dataTagArray[1] = new DataTagUnsigned32("system.adm_check.time.value");
        } else if (string.equalsIgnoreCase("QuickComp")) {
            dataTagArray[0] = new DataTagUnsigned32("system.quick_comp.result.value");
            dataTagArray[1] = new DataTagUnsigned32("system.quick_comp.time.value");
        } else {
            if (string.equalsIgnoreCase("HealthChecks") || string.equalsIgnoreCase("StartupChecks")) {
                int n = appRec.appExitCode;
                if (appRec.app != null) {
                    n = appRec.app.applicationExitCode();
                }
                if (n == 0 || n == 1) {
                    if (appRec.app != null) {
                        return appRec.app.applicationResults();
                    }
                    return appRec.appResults;
                }
                return new ApplicationResults("Unknown result", 0L);
            }
            throw new UnsupportedFeatureException("Feature not supported");
        }
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        long l = (Long)objectArray[0];
        long l2 = (Long)objectArray[1];
        String string2 = "";
        boolean bl = false;
        String string3 = null;
        if (null != appRec && null != appRec.appResults) {
            string2 = appRec.appResults.getResult();
        }
        if (2 == (stringArray = string2.split(string + "-")).length) {
            String[] stringArray2;
            string2 = stringArray[1].trim();
            int n = string2.indexOf(64);
            if (-1 != n && 2 == (stringArray2 = string2.split("@")).length) {
                string2 = stringArray2[1].trim();
                try {
                    String[] stringArray3 = stringArray2[0].trim().split(":");
                    if (2 == stringArray3.length) {
                        string2 = stringArray3[0] + ":" + string2;
                        int n2 = Integer.parseInt(stringArray3[0].trim());
                        bl = 1 == n2;
                        string3 = stringArray2[0].trim();
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
        } else {
            string2 = "";
        }
        switch ((int)l) {
            case 0: {
                applicationResults = new ApplicationResults("Pass", string2, l2);
                break;
            }
            case 1: {
                applicationResults = new ApplicationResults("Fail", string2, l2);
                break;
            }
            case 2: {
                applicationResults = new ApplicationResults("Recommendation", string2, l2);
                break;
            }
            default: {
                applicationResults = new ApplicationResults("Unknown", l2);
            }
        }
        applicationResults.setRawMeasurements(string3);
        return applicationResults;
    }

    @Override
    public boolean is_1_5_WindowedSMRTargetCapable() throws TrackerException {
        return true;
    }

    @Override
    public boolean is_7_8_WindowedSMRTargetCapable() throws TrackerException {
        return true;
    }

    private MPEResultsData getADMError(double d, double d2) throws TrackerException {
        double d3 = Math.abs(d - d2);
        double d4 = this.calculateADMMPE(d);
        return new MPEResultsData(d3, d4, d3 / d4, d3 <= d4);
    }

    private MPEResultsData getAACError(double[] dArray, double[] dArray2) throws TrackerException {
        double[] dArray3 = new double[]{dArray[0] - dArray2[0], dArray[1] - dArray2[1], dArray[2] - dArray2[2]};
        double d = this.distanceInSpace(dArray3);
        double d2 = this.distanceInSpace(dArray);
        double d3 = this.calculateTransverseMPE(d2);
        return new MPEResultsData(d, d3, d / d3, d <= d3);
    }

    @Override
    public MPEResultsData checkADMAgainstIFM(SimplePointPairData simplePointPairData) throws TrackerException {
        double[] dArray = simplePointPairData.getSecondPoint();
        double[] dArray2 = simplePointPairData.getFirstPoint();
        return this.getADMError(dArray2[2], dArray[2]);
    }

    private void pointSphereToCart(double[] dArray) {
        double d = dArray[0];
        double d2 = dArray[1];
        double d3 = dArray[2];
        double d4 = Math.sin(dArray[1]);
        dArray[0] = d3 * Math.cos(d) * d4;
        dArray[1] = d3 * Math.sin(d) * d4;
        dArray[2] = d3 * Math.cos(d2);
    }

    private double distanceInSpace(double[] dArray) {
        return Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1] + dArray[2] * dArray[2]);
    }

    @Override
    public MPEResultsData checkAngularAccuracyError(SimplePointPairData simplePointPairData) throws TrackerException {
        double[] dArray = simplePointPairData.getSecondPoint();
        double[] dArray2 = simplePointPairData.getFirstPoint();
        this.pointSphereToCart(dArray);
        this.pointSphereToCart(dArray2);
        return this.getAACError(dArray2, dArray);
    }

    @Override
    public boolean isSelfCompensationNoUICapable() throws TrackerException {
        String string = "CompIT";
        AppRec appRec = this.findAppInfo(string);
        Class<?> clazz = null;
        try {
            this.jarClassLoader.setAppName(string);
            clazz = this.jarClassLoader.loadClass(appRec.fullQualifiedName);
            return this.isSelfCompNoUISupported(clazz);
        }
        catch (FtpException ftpException) {
        }
        catch (TrackerException trackerException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return false;
    }

    private boolean isSelfCompNoUISupported(Class clazz) {
        try {
            Class clazz2 = clazz.getSuperclass();
            Method method = clazz2.getMethod("isSelfCompNoUICapable", null);
            return true;
        }
        catch (Exception exception) {
            PrintException.print(exception);
        }
        catch (Error error) {
            PrintException.print(error);
        }
        return false;
    }

    @Override
    public void changeAirTemperatureToHardware() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32("weather.config.air_temperature.source")};
        Object[] objectArray = new Object[]{new Long(1L)};
        this.writeOneTimeData(dataTagArray, objectArray);
    }

    @Override
    public void changeAirPressureToHardware() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32("weather.config.air_pressure.source")};
        Object[] objectArray = new Object[]{new Long(1L)};
        this.writeOneTimeData(dataTagArray, objectArray);
    }

    @Override
    public void changeHumidityToHardware() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32("weather.config.humidity.source")};
        Object[] objectArray = new Object[]{new Long(1L)};
        this.writeOneTimeData(dataTagArray, objectArray);
    }

    @Override
    public void changeAirTemperatureToManual(double d) throws TrackerException {
        DataTag[] dataTagArray = new DataTag[2];
        if (d > 60.0 || d < -20.0) {
            throw new TrackerException("Air Temperature value is out of bounds");
        }
        dataTagArray[0] = new DataTagUnsigned32("weather.config.air_temperature.source");
        dataTagArray[1] = new DataTagDouble("weather.config.air_temperature.manual");
        Object[] objectArray = new Object[]{new Long(2L), new Double(d)};
        this.writeOneTimeData(dataTagArray, objectArray);
    }

    @Override
    public void changeAirPressureToManual(double d) throws TrackerException {
        DataTag[] dataTagArray = new DataTag[2];
        if (d > 900.0 || d < 225.0) {
            throw new TrackerException("Air Pressure value is out of bounds");
        }
        dataTagArray[0] = new DataTagUnsigned32("weather.config.air_pressure.source");
        dataTagArray[1] = new DataTagDouble("weather.config.air_pressure.manual");
        Object[] objectArray = new Object[]{new Long(2L), new Double(d)};
        this.writeOneTimeData(dataTagArray, objectArray);
    }

    @Override
    public void changeHumidityToManual(double d) throws TrackerException {
        DataTag[] dataTagArray = new DataTag[2];
        if (d > 100.0 || d < 0.0) {
            throw new TrackerException("Humidity value is out of bounds");
        }
        dataTagArray[0] = new DataTagUnsigned32("weather.config.humidity.source");
        dataTagArray[1] = new DataTagDouble("weather.config.humidity.manual");
        Object[] objectArray = new Object[]{new Long(2L), new Double(d / 100.0)};
        this.writeOneTimeData(dataTagArray, objectArray);
    }

    @Override
    public void changeLedState(int n, int n2) throws TrackerException {
        String string = "triad";
        String string2 = "";
        switch (n) {
            case 1: {
                string2 = "blue";
                break;
            }
            case 0: {
                string2 = "yellow";
                break;
            }
            case 2: {
                string2 = "blue yellow";
            }
        }
        String string3 = "";
        switch (n2) {
            case 1: {
                string3 = "1";
                break;
            }
            case 0: {
                string3 = "0";
                break;
            }
            case 2: {
                string3 = "2";
                break;
            }
            case 3: {
                string3 = "5";
                break;
            }
            case 4: {
                string3 = "15";
            }
        }
        this.trackerCommand("led " + string + " " + string2 + " " + string3, 180000);
    }

    private void checkIfConnectingToTrackerTypeSpecified() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[]{new DataTagDouble("case_temperature.16.reading.value")};
        try {
            this.readOneTimeData(dataTagArray);
        }
        catch (TrackerException trackerException) {
            throw new ConnectFailedException("Tracker type specified and tracker being connected to are not same");
        }
    }

    @Override
    public void startVideo(VideoCfg videoCfg) throws TrackerException {
        this.localStartVideo(videoCfg, true);
    }

    private synchronized void localStartVideo(VideoCfg videoCfg, boolean bl) throws TrackerException {
        this.readyForCommand();
        int n = this.beginVideoTransfer(this.ftpClient);
        if (n != 222) {
            throw TrackerVector.exceptionFromResponse(this.ftpClient, n);
        }
        this.generalVideoFlag = bl;
        this.videoInProgress = true;
    }

    private void readyForVideoCommand() throws InterfaceBusyException, NotConnectedException {
        if (!this.isConnected()) {
            throw new NotConnectedException();
        }
        if (this.cmdInProgress) {
            throw new InterfaceBusyException("Command in progress");
        }
        if (this.videoInProgress) {
            throw new InterfaceBusyException("Videoin progress");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendVideoCfg(Ftp ftp, VideoCfg videoCfg, String string) throws TrackerException {
        int n;
        TrackerException trackerException = null;
        try {
            n = ftp.sendStart(string);
            if (n != 150) {
                throw TrackerVector.exceptionFromResponse(ftp, n);
            }
        }
        catch (FtpException ftpException) {
            throw TrackerVector.convertFtpExc(ftpException);
        }
        try {
            ftp.sendLine("frmrate=" + videoCfg.getFrameRate());
            ftp.sendLine("imgwdth=" + videoCfg.getImageWidth());
            ftp.sendLine("imght=" + videoCfg.getImageHeight());
            ftp.sendLine("camera=" + videoCfg.getCameraInUse());
        }
        catch (FtpException ftpException) {
            trackerException = TrackerVector.convertFtpExc(ftpException);
        }
        finally {
            block17: {
                try {
                    n = ftp.sendEnd(10000);
                    if (n != 226 && trackerException == null) {
                        trackerException = TrackerVector.exceptionFromResponse(ftp, n);
                    }
                }
                catch (FtpException ftpException) {
                    if (trackerException != null) break block17;
                    trackerException = TrackerVector.convertFtpExc(ftpException);
                }
            }
        }
        if (trackerException != null) {
            throw trackerException;
        }
    }

    private int receiveVideoData2(Ftp ftp) throws TrackerException {
        try {
            this.dgSocket = new DatagramSocket();
            this.dgSocket.setSoTimeout(5000);
            byte[] byArray = ftp.getIPAddress().getAddress();
            int n = this.dgSocket.getLocalPort();
            int[] nArray = new int[4];
            for (int i = 0; i < 4; ++i) {
                nArray[i] = byArray[i];
                if (nArray[i] >= 0) continue;
                int n2 = i;
                nArray[n2] = nArray[n2] + 256;
            }
            int n3 = ftp.command("video " + nArray[0] + "," + nArray[1] + "," + nArray[2] + "," + nArray[3] + "," + n / 256 + "," + n % 256, 10000);
            return n3;
        }
        catch (SocketException socketException) {
            if (this.dgSocket != null) {
                this.dgSocket.close();
            }
            throw new CommunicationException("video data exception");
        }
        catch (FtpException ftpException) {
            throw TrackerVector.convertFtpExc(ftpException);
        }
    }

    private void checkAndSendVideoCFG(VideoCfg videoCfg, Ftp ftp, String string) throws TrackerException {
        VideoCfg videoCfg2 = this.oldVideoCfg;
        if (!videoCfg2.equals(videoCfg)) {
            this.sendVideoCfg(ftp, videoCfg, string);
        }
        this.oldVideoCfg = new VideoCfg(videoCfg.getFrameRate(), videoCfg.getImageWidth(), videoCfg.getImageHeight(), videoCfg.getCameraInUse());
    }

    @Override
    public synchronized void stopVideo() throws TrackerException {
        this.localStopVideo(true);
    }

    private void cleanupVideoSockets() throws TrackerException {
        try {
            this.videoSocket.close();
            this.videoServerSocket.close();
            this.videoRawInput.close();
            this.videoInputStream.close();
            this.videoSocket = null;
            this.videoServerSocket = null;
            this.videoRawInput = null;
            this.videoInputStream = null;
        }
        catch (IOException iOException) {
            throw new TrackerException("Failed to close Video Sockets");
        }
    }

    private synchronized void localStopVideo(boolean bl) throws TrackerException {
        if (!this.isConnected()) {
            throw new NotConnectedException();
        }
        if (this.videoInProgress) {
            try {
                this.ftpClient.command("video", 10000);
                this.videoInProgress = false;
                this.generalVideoFlag = false;
                this.cleanupVideoSockets();
            }
            catch (FtpException ftpException) {
                throw TrackerVector.convertFtpExc(ftpException);
            }
        }
    }

    private int beginVideoTransfer(Ftp ftp) throws TrackerException {
        int n = 9;
        if (null != this.videoSocket || this.videoInProgress) {
            throw new InterfaceBusyException("Video data transmission in progress");
        }
        try {
            int n2;
            this.videoServerSocket = new ServerSocket(0, 1);
            byte[] byArray = ftp.getIPAddress().getAddress();
            int[] nArray = new int[4];
            for (n2 = 0; n2 < 4; ++n2) {
                nArray[n2] = byArray[n2];
                if (nArray[n2] >= 0) continue;
                int n3 = n2;
                nArray[n3] = nArray[n3] + 256;
            }
            n2 = this.videoServerSocket.getLocalPort();
            n = ftp.command("video " + nArray[0] + "," + nArray[1] + "," + nArray[2] + "," + nArray[3] + "," + n2 / 256 + "," + n2 % 256, 10000);
            try {
                this.videoServerSocket.setSoTimeout(10000);
                this.videoSocket = this.videoServerSocket.accept();
                this.videoSocket.setReceiveBufferSize(65536);
            }
            catch (IOException iOException) {
                throw new TrackerException("video problem");
            }
        }
        catch (Exception exception) {
            PrintException.print(exception);
            throw new TrackerException(exception.getMessage());
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public VideoData[] readVideoData() throws TrackerException {
        VideoData videoData = null;
        if (!this.videoInProgress) {
            return null;
        }
        try {
            CharSequence charSequence;
            int n;
            byte[] byArray;
            int n2;
            Long l;
            Long l2;
            int n3;
            ByteBuffer byteBuffer;
            block14: {
                if (null == this.videoRawInput && null == this.videoInputStream) {
                    this.videoRawInput = this.videoSocket.getInputStream();
                    this.videoInputStream = new DataInputStream(this.videoRawInput);
                }
                int n4 = 0;
                int n5 = 0;
                while ((n5 = this.videoInputStream.available()) <= 0) {
                    ++n4;
                    try {
                        Thread.currentThread();
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (n4 < 100) continue;
                }
                if (n5 <= 0) {
                    throw new NoDataAvailableException();
                }
                byteBuffer = null;
                Object var5_8 = null;
                n3 = 0;
                l2 = null;
                l = null;
                n2 = 0;
                byArray = null;
                n3 = 0;
                n = -1;
                Runtime runtime = Runtime.getRuntime();
                long l3 = runtime.maxMemory();
                long l4 = runtime.totalMemory();
                long l5 = runtime.freeMemory();
                do {
                    Long l6 = new Long((long)this.videoInputStream.readInt() & 0xFFFFFFFFL);
                    charSequence = Long.toHexString(l6);
                    if (!((String)charSequence).equalsIgnoreCase("12345678")) continue;
                    n = VideoData.VIDEO_TYPE;
                    break block14;
                } while (!((String)charSequence).equalsIgnoreCase("12345679") && !((String)charSequence).equalsIgnoreCase("1234567A"));
                n = VideoData.TARGET_TYPE;
            }
            l = new Long((long)this.videoInputStream.readInt() & 0xFFFFFFFFL);
            if (VideoData.VIDEO_TYPE == n) {
                // empty if block
            }
            l2 = new Long((long)this.videoInputStream.readInt() & 0xFFFFFFFFL);
            int n6 = (int)l.longValue();
            byteBuffer = ByteBuffer.allocate(n6);
            n2 = n6 - n3;
            byArray = byteBuffer.array();
            do {
                n3 = n2 > 1200 ? (n3 += this.videoInputStream.read(byArray, n3, 1200)) : (n3 += this.videoInputStream.read(byArray, n3, n2));
                n2 = n6 - n3;
            } while ((long)n3 < l);
            charSequence = Charset.forName("ISO-8859-1").decode(byteBuffer);
            if (VideoData.TARGET_TYPE == n) {
                String string = new String(((CharBuffer)charSequence).array());
            }
            videoData = new VideoData(0.0, byArray, ((CharBuffer)charSequence).array(), n, l, l2);
            byteBuffer.clear();
            if (0 == n3 - (int)l.longValue() && 0 == n2) return new VideoData[]{videoData};
        }
        catch (IOException iOException) {
            throw new TrackerException("Video IO Exception");
        }
        catch (NullPointerException nullPointerException) {
            if (this.videoInProgress) {
                throw new TrackerException("Video Socket Null Exception");
            }
            PrintException.print(nullPointerException);
            throw new TrackerException("Video already stopped. No Video to show.");
        }
        return new VideoData[]{videoData};
    }

    JarFile getJarFile(String string) {
        if (null == this.jarCache || this.jarCache.isEmpty()) {
            return null;
        }
        Set set = this.jarCache.keySet();
        Object[] objectArray = set.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            if (!((String)objectArray[i]).toLowerCase(Locale.ENGLISH).endsWith(string.toLowerCase(Locale.ENGLISH))) continue;
            return (JarFile)this.jarCache.get(objectArray[i]);
        }
        return null;
    }

    @Override
    public void changeGestureState(boolean bl) throws TrackerException {
        String string = "gesture_ctrl " + (bl ? "on" : "off");
        this.trackerCommand(string, 6000);
    }

    @Override
    public boolean gestureRecognitionOn() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32("target_camera.gesture_mode")};
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        return ((Long)objectArray[0]).intValue() == 1;
    }

    @Override
    public boolean wirelessCapable() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32("system.serial_type.value")};
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        return (((Long)objectArray[0]).intValue() & 1) != 0;
    }

    @Override
    public boolean videoCapable() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32("system.serial_type.value")};
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        return (((Long)objectArray[0]).intValue() & 4) != 0;
    }

    @Override
    public boolean gesturesCapable() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32("system.serial_type.value")};
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        return (((Long)objectArray[0]).intValue() & 8) != 0;
    }

    @Override
    public void searchUsingCamera() throws TrackerException {
        int n;
        if (!this.videoCapable()) {
            throw new TrackerException("Video disabled. Camera search not supported");
        }
        DataTag[] dataTagArray = new DataTag[]{new DataTagDouble("target_camera.diag.center_smr.x.value"), new DataTagDouble("target_camera.diag.center_smr.y.value"), new DataTagUnsigned32("target_camera.diag.tgt_count.registered")};
        double d = 0.0;
        double d2 = 0.0;
        for (n = 0; n < 3; ++n) {
            Object[] objectArray = this.readOneTimeData(dataTagArray);
            d = (Double)objectArray[0];
            d2 = (Double)objectArray[1];
            long l = (Long)objectArray[2];
            if (!Double.isNaN(d) && !Double.isNaN(d2) && d != 0.0 && d2 != 0.0 && l >= 1L) break;
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (n == 3) {
            throw new TrackerException("No target in field of view");
        }
        int n2 = 10000;
        this.log("finding targets @(" + d + ", " + d2 + ")");
        this.trackerCommand("force_gesture  " + d + " " + d2, n2);
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        int n3 = 10;
        for (int i = 0; i < n3; ++i) {
            if (this.targetPresent()) {
                return;
            }
            try {
                Thread.sleep(n2 / n3);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (!this.targetPresent()) {
            throw new TrackerException("Cameras failed to find target");
        }
    }

    private boolean customInitialized() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[4];
        DataTag[] dataTagArray2 = new DataTag[1];
        dataTagArray[0] = new DataTagUnsigned32("servo.motor_state.current");
        dataTagArray[1] = new DataTagUnsigned16("position_device.psd.raw.a.status");
        dataTagArray[2] = new DataTagUnsigned16("position_device.azimuth_encoder.reading.status");
        dataTagArray[3] = new DataTagUnsigned16("position_device.zenith_encoder.reading.status");
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        if ((Long)objectArray[0] != 1L) {
            return false;
        }
        if (0 != ((Integer)objectArray[1] & 0x20)) {
            return false;
        }
        return 0 == (1 & (Integer)objectArray[2]) && 0 == (0x20 & (Integer)objectArray[2]) && 0 == (1 & (Integer)objectArray[3]) && 0 == (0x20 & (Integer)objectArray[3]);
    }

    private void readTrackerPerformanceParameters() throws TrackerException {
        DataTag[] dataTagArray;
        Object[] objectArray;
        if (0.0 == this.admMPEOffset && 0.0 == this.admMPEScale && null != (objectArray = this.readOneTimeData(dataTagArray = new DataTag[]{new DataTagDouble("system.spec.adm.offset.value"), new DataTagUnsigned16("system.spec.adm.offset.status"), new DataTagDouble("system.spec.adm.scale.value"), new DataTagUnsigned16("system.spec.adm.scale.status"), new DataTagDouble("system.spec.transverse.offset.value"), new DataTagUnsigned16("system.spec.transverse.offset.status"), new DataTagDouble("system.spec.transverse.scale.value"), new DataTagUnsigned16("system.spec.transverse.scale.status")}))) {
            int n = 0;
            this.admMPEOffset = (Double)objectArray[n++];
            int n2 = (Integer)objectArray[n++];
            this.admMPEScale = (Double)objectArray[n++];
            int n3 = (Integer)objectArray[n++];
            this.transverseMPEOffset = (Double)objectArray[n++];
            int n4 = (Integer)objectArray[n++];
            this.transverseMPEScale = (Double)objectArray[n++];
            int n5 = (Integer)objectArray[n++];
            if (0 == n2 && 0 == n3 && 0 == n4 && 0 == n5) {
                this.performanceParametersSetForTracker = true;
            }
        }
        if (!this.performanceParametersSetForTracker) {
            throw new InternalTrackerException();
        }
    }

    private double calculateADMMPE(double d) throws TrackerException {
        this.readTrackerPerformanceParameters();
        double d2 = this.admMPEOffset + d * this.admMPEScale;
        return d2;
    }

    private double calculateTransverseMPE(double d) throws TrackerException {
        double d2 = 0.0;
        this.readTrackerPerformanceParameters();
        double d3 = this.transverseMPEOffset + d * this.transverseMPEScale;
        d2 = 2.0 * d3;
        return d2;
    }

    private Class getCompITSuperClass() throws TrackerException {
        String string = "CompIT";
        AppRec appRec = this.findAppInfo(string);
        Class<?> clazz = null;
        try {
            this.jarClassLoader.setAppName(string);
            clazz = this.jarClassLoader.loadClass(appRec.fullQualifiedName);
            Class<?> clazz2 = clazz.getSuperclass();
        }
        catch (Exception exception) {
            throw new InternalTrackerException();
        }
        return clazz;
    }

    @Override
    public boolean isQuickCompensationNoUICapable() throws TrackerException {
        try {
            Class clazz = this.getCompITSuperClass();
            Method method = clazz.getMethod("isQuickCompNoUICapable", null);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean isAACNoUICapable() throws TrackerException {
        try {
            Class clazz = this.getCompITSuperClass();
            Method method = clazz.getMethod("isAACNoUICapable", null);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long stabilityTime() throws TrackerException {
        long l;
        long l2;
        Object object;
        long l3 = -1L;
        TrackerException trackerException = null;
        this.readyForCommand();
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32("system.thermal_init.time.value"), new DataTagUnsigned32("system.smart_warmup.state")};
        for (int i = 0; i < 20; ++i) {
            object = this.readOneTimeData(dataTagArray);
            l2 = (Long)object[0];
            l = (Long)object[1];
            if (l2 != 0L || l != 1L) break;
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        String string = "\\diagnose\\time.dat";
        try {
            int n = this.ftpClient.receiveStart(string);
            if (150 != n) {
                throw TrackerVector.exceptionFromResponse(this.ftpClient, n);
            }
            try {
                while (null != (object = this.ftpClient.receiveLine())) {
                    try {
                        if (object == null) continue;
                        StringTokenizer stringTokenizer = new StringTokenizer((String)object, "=");
                        String string2 = stringTokenizer.nextToken();
                        l3 = Long.parseLong(stringTokenizer.nextToken().trim());
                    }
                    catch (NumberFormatException numberFormatException) {
                    }
                }
            }
            catch (FtpNoResponseException ftpNoResponseException) {
                // empty catch block
            }
        }
        catch (FtpException ftpException) {
            trackerException = TrackerVector.convertFtpExc(ftpException);
        }
        finally {
            block24: {
                try {
                    int n = this.ftpClient.receiveEnd();
                    if (226 != n) {
                        trackerException = TrackerVector.exceptionFromResponse(this.ftpClient, n);
                    }
                }
                catch (FtpException ftpException) {
                    if (null != trackerException) break block24;
                    trackerException = TrackerVector.convertFtpExc(ftpException);
                }
            }
        }
        if (null != trackerException) {
            throw trackerException;
        }
        object = this.readOneTimeData(new DataTag[]{new DataTagUnsigned32("system.thermal_init.time.value")});
        l2 = (Long)object[0];
        l = l2 - l3;
        if (l > 0L) {
            return Math.round((double)l * 1.024);
        }
        return 0L;
    }

    @Override
    public boolean home(boolean bl, boolean bl2) throws TrackerException {
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32("system.version.mcu_firmware.num.value")};
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        this.MCUVersionNumber = (Long)objectArray[0];
        int[] nArray = this.convertToVersionNumber(this.MCUVersionNumber);
        boolean bl3 = false;
        if (nArray[0] == 1) {
            if (nArray[1] < 1) {
                bl3 = true;
            } else if (nArray[1] == 1 && nArray[2] <= 6) {
                bl3 = true;
            }
        }
        if (bl3) {
            this.home(bl);
            if (bl2) {
                return this.targetLocationValid();
            }
            return true;
        }
        try {
            this.trackerCommand("home" + (bl ? " b" : "") + (bl2 ? " target_required" : ""), 120000);
        }
        catch (NoTargetException noTargetException) {
            return false;
        }
        return true;
    }

    @Override
    public int smartWarmupWaitState() throws TrackerException {
        boolean bl = this.readyToInitialize(false);
        if (!bl) {
            long l = this.stabilityTime();
            if (l > (long)EXTENDED_THERMAL_TIME) {
                return 1;
            }
            if (l > (long)LONG_THERMAL_TIME && l <= (long)EXTENDED_THERMAL_TIME) {
                return 2;
            }
            if (l > (long)QUICK_THERMAL_TIME && l <= (long)LONG_THERMAL_TIME) {
                return 3;
            }
            if (l > (long)DONE_THERMAL_TIME && l <= (long)QUICK_THERMAL_TIME) {
                return 4;
            }
        }
        return 0;
    }

    @Override
    public int applicationPercentComplete(String string) throws TrackerException {
        AppRec appRec = this.findAppInfo(string);
        if (null != appRec && appRec.app != null) {
            if (!this.printed_once) {
                this.printed_once = true;
                AppRec appRec2 = null;
                for (int i = 0; i < this.maintainApp.size(); ++i) {
                    appRec2 = (AppRec)this.maintainApp.get(i);
                }
            }
            return appRec.app.applicationPercentComplete();
        }
        throw new TrackerException("Application \"" + string + "\" is not running.");
    }

    @Override
    public void resetCameras() throws TrackerException {
        if (!this.videoCapable()) {
            throw new TrackerException("Video disabled. Reset cameras is not supported");
        }
        this.executeTrackerCommand("set_camera_mode reset", 18000);
        Object[] objectArray = new Object[1];
        for (int i = 0; i < 21; ++i) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            objectArray = this.readOneTimeData(new DataTag[]{new DataTagUnsigned32("target_camera.diag.system_ready")});
            if ((Long)objectArray[0] == 1L) break;
        }
        if ((Long)objectArray[0] == 0L) {
            throw new TrackerException("Failed to reset cameras");
        }
    }

    private void runSpiralSearch(double d, double d2, int n) throws TrackerException {
        try {
            if (d2 > 0.0) {
                this.log("\t SPIRAL with ADM");
                this.search(d, d2, n);
            } else {
                this.log("\t SPIRAL");
                this.search(d, n);
            }
        }
        catch (TrackerException trackerException) {
            // empty catch block
        }
    }

    MeasureData extractFactoryBkndDataFromTracker(int n) {
        MeasureData[] measureDataArray = null;
        try {
            measureDataArray = this.readFactoryBkndMeasureData(n);
        }
        catch (TrackerException trackerException) {
            return null;
        }
        if (measureDataArray == null) {
            return null;
        }
        return measureDataArray[0];
    }

    int checkAndRunSpiralSearch(Object[] objectArray, DataTag[] dataTagArray, int n, double d) throws TrackerException {
        boolean bl;
        boolean bl2;
        if (null == objectArray) {
            objectArray = this.readOneTimeData(dataTagArray);
        }
        this.logComboSearch("carss");
        this.logComboSearch(objectArray);
        double d2 = (Double)objectArray[5] * 100.0;
        double d3 = (Double)objectArray[0];
        double d4 = (Double)objectArray[1];
        double d5 = (Double)objectArray[9];
        double d6 = (Double)objectArray[10];
        double d7 = (Double)objectArray[3];
        int n2 = (Integer)objectArray[4];
        boolean bl3 = bl2 = 1 != (n2 & 1);
        if (!bl2 && d > 0.0) {
            d7 = d;
            bl2 = true;
        }
        this.log("adm = (" + d7 + ", " + n2 + "), psd% = " + d2 + ", while camera coords are (" + d3 + ", " + d4 + ") - @ (" + d5 + ", " + d6 + ")");
        boolean bl4 = bl = d2 > 0.1;
        if (bl || bl2) {
            this.log("INITIATE SPIRAL SEARCH");
            if (bl2) {
                this.runSpiralSearch(0.007, d7, n);
            } else {
                this.runSpiralSearch(0.007, -1.0, n);
            }
            objectArray = this.readOneTimeData(dataTagArray);
            d2 = (Double)objectArray[5] * 100.0;
            int n3 = ((Long)objectArray[8]).intValue();
            d5 = (Double)objectArray[9];
            d6 = (Double)objectArray[10];
            this.log("\t AFTER SPIRAL, psd% = " + d2 + ", and target state = " + n3 + " @ (" + d5 + ", " + d6 + ")");
            this.logComboSearch("as-");
            this.logComboSearch(objectArray);
            if (2 == n3) {
                this.log("\t\t SPIRAL Search FOUND IT!!!");
                return 0;
            }
            return 1;
        }
        return -1;
    }

    private void createComboDebugWriter() {
        try {
            String string = "ComboSearch";
            String string2 = TrackerVector.getLogFileEnvPath(string + "Log.txt");
            if (!showed_once) {
                JOptionPane.showMessageDialog(null, string2, "Debug File Location", 0);
                showed_once = true;
            }
            this.combo_search_log_writer = new PrintWriter((Writer)new FileWriter(string2, true), false);
            this.log(this.combo_search_log_writer, "");
            this.log(this.combo_search_log_writer, "Combo Search debug info:");
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, exception, "Error", 0);
        }
    }

    private void closeComboDebugWriter() {
        if (null != this.combo_search_log_writer) {
            this.combo_search_log_writer.flush();
            this.combo_search_log_writer.close();
            this.combo_search_log_writer = null;
        }
    }

    private void logComboSearch(String string) {
        this.log(this.combo_search_log_writer, string);
    }

    private void logComboSearch(Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append((Double)objectArray[0]);
        stringBuffer.append(',');
        stringBuffer.append((Double)objectArray[1]);
        stringBuffer.append(',');
        stringBuffer.append(((Long)objectArray[2]).intValue());
        stringBuffer.append(',');
        stringBuffer.append((Double)objectArray[3]);
        stringBuffer.append(',');
        stringBuffer.append((Integer)objectArray[4]);
        stringBuffer.append(',');
        stringBuffer.append((Double)objectArray[5]);
        stringBuffer.append(',');
        stringBuffer.append((Double)objectArray[6]);
        stringBuffer.append(',');
        stringBuffer.append((Double)objectArray[7]);
        stringBuffer.append(',');
        stringBuffer.append(((Long)objectArray[8]).intValue());
        stringBuffer.append(',');
        stringBuffer.append((Double)objectArray[9]);
        stringBuffer.append(',');
        stringBuffer.append((Double)objectArray[10]);
        stringBuffer.append(',');
        stringBuffer.append(((Long)objectArray[11]).intValue());
        stringBuffer.append(',');
        stringBuffer.append(((Long)objectArray[12]).intValue());
        stringBuffer.append(',');
        stringBuffer.append(((Long)objectArray[13]).intValue());
        stringBuffer.append(',');
        stringBuffer.append(((Long)objectArray[14]).intValue());
        stringBuffer.append(',');
        stringBuffer.append(((Long)objectArray[15]).intValue());
        stringBuffer.append(',');
        this.log(this.combo_search_log_writer, stringBuffer.toString());
    }

    private int waitTillCamerasAreDoneSearching() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32("target_camera.diag.camera_state"), new DataTagUnsigned32("target.state")};
        boolean bl = false;
        long l = System.currentTimeMillis();
        long l2 = System.currentTimeMillis() - l;
        int n = -1;
        while (l2 < 10000L) {
            l2 = System.currentTimeMillis() - l;
            Object[] objectArray = this.readOneTimeData(dataTagArray);
            n = ((Long)objectArray[1]).intValue();
            int n2 = ((Long)objectArray[0]).intValue();
            this.log("CAM state: " + n2);
            if (!bl && n2 < 4) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (l2 < 2000L) continue;
                this.log("Camera Search state didn't change till min time out");
                break;
            }
            bl = true;
            if (n2 >= 4) continue;
            break;
        }
        this.log("\n\t\t\t\t\ttotal time waiting for camera hunt: " + l2 + ", and the target state value = " + n);
        return n;
    }

    private int searchUsingCamera2(double d, double d2) throws TrackerException {
        this.log("\n\n\t\tForce Gesture to (" + d + ", " + d2 + ")\n\n");
        int n = -1;
        this.trackerCommand("force_gesture  " + d + " " + d2, 10000);
        n = this.waitTillCamerasAreDoneSearching();
        return n;
    }

    private double convertXPixelToAzAngle(double d, double d2, double d3, double d4, double d5) throws TrackerException {
        double d6 = (d4 - d) * d5;
        d6 /= Math.sin(d3);
        return d6 += d2;
    }

    private double convertYPixelToZeAngle(double d, double d2, double d3, double d4) throws TrackerException {
        double d5 = (d3 - d) * -d4;
        d5 = d2 + d5;
        return d5;
    }

    private boolean checkIfCameraSearchFoundTargetCloseToNominal(DataTag[] dataTagArray, double d, double d2, double d3, double d4) throws TrackerException {
        this.log("Checking...with tols (" + d3 + ", " + d4 + ")");
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        double d5 = (Double)objectArray[9];
        double d6 = (Double)objectArray[10];
        this.log("Delta from Nominal : (" + Math.abs(d5 - d) + ", " + Math.abs(d6 - d2) + ")");
        if (Math.abs(d5 - d) > d3 || Math.abs(d6 - d2) > d4) {
            this.log("Moving back to NOMINAL location");
            this.executeTrackerCommand("moveaxis " + d + " " + d2 + " a", 15000);
            return false;
        }
        return true;
    }

    public void comboSearch(double d, double d2, boolean bl) throws TrackerException {
        this.comboSearchInternal(-1.0, -1.0, -1.0, d, d2, bl);
    }

    public void comboSearch(double d, double d2, double d3, boolean bl) throws TrackerException {
        this.comboSearch(d, d2, d3, -1.0, -1.0, bl);
    }

    @Override
    public void comboSearch(double d, double d2, double d3, double d4, double d5, boolean bl) throws TrackerException {
        if (d > 0.0 || d2 > 0.0 || d3 > 0.0) {
            this.move(d, d2, d3, false);
        }
        this.comboSearchInternal(-1.0, -1.0, d3, d4, d5, bl);
    }

    @Override
    public void comboSearchInternal(double d, double d2, double d3) throws TrackerException {
        this.comboSearchInternal(d, d2, d3, -1.0, -1.0, true);
    }

    /*
     * Loose catch block
     */
    private void comboSearchInternal(double d, double d2, double d3, double d4, double d5, boolean bl) throws TrackerException {
        boolean bl2;
        double d6;
        double d7;
        boolean bl3;
        DataTag[] dataTagArray;
        block55: {
            block59: {
                block60: {
                    int n;
                    Object[] objectArray;
                    int n2;
                    double d8;
                    double d9;
                    double d10;
                    double d11;
                    Object[] objectArray2;
                    block56: {
                        block57: {
                            block58: {
                                boolean bl4;
                                block52: {
                                    block53: {
                                        block54: {
                                            try {
                                                this.trackerCommand("debug on", 5000);
                                            }
                                            catch (TrackerException trackerException) {
                                                // empty catch block
                                            }
                                            dataTagArray = new DataTag[]{new DataTagDouble("target_camera.diag.center_smr.x.value"), new DataTagDouble("target_camera.diag.center_smr.y.value"), new DataTagUnsigned32("target_camera.diag.tgt_count.registered"), new DataTagDouble("position_device.adm.reading.value"), new DataTagUnsigned16("position_device.adm.reading.status"), new DataTagDouble("position_device.psd.reading.intensity.value"), new DataTagDouble("target_camera.compensation.tracking_center_x.value"), new DataTagDouble("target_camera.compensation.tracking_center_y.value"), new DataTagUnsigned32("target.state"), new DataTagDouble("position_device.azimuth_encoder.reading.value"), new DataTagDouble("position_device.zenith_encoder.reading.value"), new DataTagUnsigned32("target_camera.diag.camera_state"), new DataTagUnsigned32("target_camera.diag.pixel_avg.left"), new DataTagUnsigned32("target_camera.diag.pixel_avg.right"), new DataTagUnsigned32("target_camera.diag.tgt_count.left"), new DataTagUnsigned32("target_camera.diag.tgt_count.right"), new DataTagDouble("target_camera.compensation.scale_factor.value")};
                                            objectArray2 = null;
                                            try {
                                                objectArray2 = this.getCameraSearchData(dataTagArray, true);
                                            }
                                            catch (TrackerException trackerException) {
                                                objectArray2 = this.readOneTimeData(dataTagArray);
                                            }
                                            double d12 = (Double)objectArray2[0];
                                            double d13 = (Double)objectArray2[1];
                                            boolean bl5 = false;
                                            if (d < 0.0 && d2 < 0.0) {
                                                d = (Double)objectArray2[6];
                                                d2 = (Double)objectArray2[7];
                                                bl5 = true;
                                            }
                                            this.log("View Center coords (" + d + ", " + d2 + "), while closest target coords are (" + d12 + ", " + d13 + ")\n");
                                            d11 = this.convertXPixelToAzAngle(d, (Double)objectArray2[9], (Double)objectArray2[10], (Double)objectArray2[6], (Double)objectArray2[16]);
                                            d10 = this.convertYPixelToZeAngle(d2, (Double)objectArray2[10], (Double)objectArray2[7], (Double)objectArray2[16]);
                                            double d14 = this.convertXPixelToAzAngle(d12, (Double)objectArray2[9], (Double)objectArray2[10], (Double)objectArray2[6], (Double)objectArray2[16]);
                                            double d15 = this.convertYPixelToZeAngle(d13, (Double)objectArray2[10], (Double)objectArray2[7], (Double)objectArray2[16]);
                                            if (bl5) {
                                                d11 = (Double)objectArray2[9];
                                                d10 = (Double)objectArray2[10];
                                            }
                                            double d16 = Math.abs(d11 - d14);
                                            double d17 = Math.abs(d10 - d15);
                                            if (bl5 && d16 < 0.006 && d17 < 0.0035) {
                                                d = d12;
                                                d2 = d13;
                                                d11 = d14;
                                                d10 = d15;
                                                this.log("\t Using Target Center coords instead of View center coords because deltas are (" + d16 + ", " + d17 + ")");
                                            }
                                            this.log("NOMINALS : " + d11 + " " + d10 + "\t(" + d14 + ", " + d15 + ")\t Delta : (" + (d11 - d14) + ", " + (d10 - d15) + ")");
                                            double d18 = Math.abs(d - (Double)objectArray2[6]);
                                            double d19 = Math.abs(d2 - (Double)objectArray2[7]);
                                            d9 = 0.006;
                                            d8 = 0.0035;
                                            this.log("\t\t AZ DELTA Pixels = " + d18);
                                            this.log("\t\t ZE DELTA Pixels = " + d19);
                                            double d20 = 1.2;
                                            if (d18 > 300.0) {
                                                d9 = 0.01 * d20;
                                                this.log("\t\t Using WIDE Tolerance for AZ: 0.01");
                                            } else {
                                                this.log("\t\t Using TIGHT Tolerance for AZ: 0.006");
                                            }
                                            if (d19 > 100.0) {
                                                d8 = 0.007 * d20;
                                                this.log("\t\t Using WIDE Tolerance for ZE: 0.007");
                                            } else {
                                                this.log("\t\t Using TIGHT Tolerance for ZE: 0.0035");
                                            }
                                            if (d4 > 0.0 && d5 > 0.0) {
                                                d9 = d4;
                                                d8 = d5;
                                            }
                                            bl3 = 2 == (n2 = this.searchUsingCamera2(d, d2));
                                            objectArray = this.readOneTimeData(dataTagArray);
                                            n = (Integer)objectArray[4];
                                            bl4 = false;
                                            if (bl3) {
                                                bl3 = this.checkIfCameraSearchFoundTargetCloseToNominal(dataTagArray, d11, d10, d9, d8);
                                            } else {
                                                bl4 = this.checkIfCameraSearchFoundTargetCloseToNominal(dataTagArray, d11, d10, d9, d8);
                                            }
                                            if (!bl3) break block52;
                                            this.log("\n\t\t FIRST New CAM Search found it");
                                            if (!bl) break block53;
                                            if (0 != (n & 1)) break block54;
                                            try {
                                                this.trackerCommand("debug of", 5000);
                                            }
                                            catch (TrackerException trackerException) {
                                                // empty catch block
                                            }
                                            return;
                                        }
                                        this.log("\t\t PSD is good, but ADM is not, will try SPIRAL");
                                    }
                                    try {
                                        this.trackerCommand("debug of", 5000);
                                    }
                                    catch (TrackerException trackerException) {
                                        // empty catch block
                                    }
                                    return;
                                }
                                boolean bl6 = false;
                                if (bl4 && 1 == n2) {
                                    bl6 = true;
                                    this.log("\n\t\t SKIPPING 2nd CAM search\n");
                                }
                                d7 = d11;
                                d6 = d10;
                                bl2 = false;
                                if (bl6) break block55;
                                try {
                                    this.log("\n\t\tZZZZZZZZZZZZZZZZZZZ....\n");
                                    Thread.sleep(500L);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                                objectArray2 = this.getCameraSearchData(dataTagArray);
                                if (null != objectArray2) break block56;
                                bl3 = true;
                                objectArray = this.readOneTimeData(dataTagArray);
                                n = (Integer)objectArray[4];
                                if (!bl) break block57;
                                if (0 != (n & 1)) break block58;
                                try {
                                    this.trackerCommand("debug of", 5000);
                                }
                                catch (TrackerException trackerException) {
                                    // empty catch block
                                }
                                return;
                            }
                            this.log("\t\t PSD is good, but ADM is not, will try SPIRAL");
                        }
                        try {
                            this.trackerCommand("debug of", 5000);
                        }
                        catch (TrackerException trackerException) {
                            // empty catch block
                        }
                        return;
                    }
                    d11 = this.convertXPixelToAzAngle((Double)objectArray2[0], (Double)objectArray2[9], (Double)objectArray2[10], (Double)objectArray2[6], (Double)objectArray2[16]);
                    d10 = this.convertYPixelToZeAngle((Double)objectArray2[1], (Double)objectArray2[10], (Double)objectArray2[7], (Double)objectArray2[16]);
                    this.log("NOMINALS for 2nd Search: " + d11 + " " + d10 + "(Diff from previous nominals : (" + (d7 - d11) + " , " + (d6 - d10) + "), pixels for center coords are (" + (Double)objectArray2[0] + ", " + (Double)objectArray2[1] + ")");
                    boolean bl7 = false;
                    if (Math.abs(d7 - d11) <= d9 && Math.abs(d6 - d10) <= d8) {
                        d7 = d11;
                        d6 = d10;
                        bl7 = true;
                        this.log("\t\t RE-ASSIGNED the NOMINALS\n");
                    }
                    if (!bl7) break block55;
                    n2 = this.searchUsingCamera2((Double)objectArray2[0], (Double)objectArray2[1]);
                    boolean bl8 = bl3 = 2 == n2;
                    if (bl7) {
                        d9 = 0.006;
                        d8 = 0.0035;
                    }
                    if (d4 > 0.0 && d5 > 0.0) {
                        d9 = d4;
                        d8 = d5;
                    }
                    if (bl3) {
                        bl3 = this.checkIfCameraSearchFoundTargetCloseToNominal(dataTagArray, d7, d6, d9, d8);
                    } else {
                        this.checkIfCameraSearchFoundTargetCloseToNominal(dataTagArray, d7, d6, d9, d8);
                    }
                    if (!bl3) break block55;
                    objectArray = this.readOneTimeData(dataTagArray);
                    n = (Integer)objectArray[4];
                    if (!bl) break block59;
                    if (0 != (n & 1)) break block60;
                    try {
                        this.trackerCommand("debug of", 5000);
                    }
                    catch (TrackerException trackerException) {
                        // empty catch block
                    }
                    return;
                }
                this.log("\t\t PSD is good, but ADM is not, will try SPIRAL");
            }
            try {
                this.trackerCommand("debug of", 5000);
            }
            catch (TrackerException trackerException) {
                // empty catch block
            }
            return;
        }
        try {
            int n;
            block61: {
                break block61;
                {
                    catch (TrackerException trackerException) {
                        bl2 = true;
                    }
                }
            }
            if (bl && (!bl2 || d3 > 0.0) && 0 == (n = this.checkAndRunSpiralSearch(null, dataTagArray, 10000, d3))) {
                this.log("\n\t\t SPIRAL Search found it");
                bl3 = this.checkIfCameraSearchFoundTargetCloseToNominal(dataTagArray, d7, d6, 0.005, 0.005);
                if (bl3) {
                    return;
                }
            }
            throw new TrackerException("Camera search failed to find target.");
        }
        finally {
            try {
                this.trackerCommand("debug of", 5000);
            }
            catch (TrackerException trackerException) {}
        }
    }

    private Object[] getCameraSearchData(DataTag[] dataTagArray) throws TrackerException {
        return this.getCameraSearchData(dataTagArray, false);
    }

    private Object[] getCameraSearchData(DataTag[] dataTagArray, boolean bl) throws TrackerException {
        long l = System.currentTimeMillis();
        double d = 0.0;
        double d2 = 0.0;
        Object[] objectArray = null;
        long l2 = 0L;
        double d3 = 0.0;
        boolean bl2 = false;
        int n = 0;
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        while (System.currentTimeMillis() - l <= 3500L) {
            bl2 = false;
            l2 = 0L;
            d3 = 0.0;
            d = 0.0;
            d2 = 0.0;
            objectArray = this.readOneTimeData(dataTagArray);
            d = (Double)objectArray[0];
            d2 = (Double)objectArray[1];
            l2 = (Long)objectArray[2];
            d3 = (Double)objectArray[5] * 100.0;
            n = ((Long)objectArray[8]).intValue();
            int n2 = (Integer)objectArray[4];
            if (!bl && 2 == n && 0 == n2) {
                return null;
            }
            if (!Double.isNaN(d) && !Double.isNaN(d2) && d != 0.0 && d2 != 0.0 && l2 >= 1L) break;
            bl2 = true;
        }
        if (null == objectArray || bl2 && d3 < 0.05) {
            throw new TrackerException("No target in field of view");
        }
        this.log("Time to get CAM data after a move = " + (System.currentTimeMillis() - l) + " millis");
        return objectArray;
    }

    public void comboSearch() throws TrackerException {
        this.comboSearchInternal(-1.0, -1.0, -1.0, -1.0, -1.0, true);
    }

    @Override
    public boolean didAACPassSinceInitialization() throws TrackerException {
        ApplicationResults applicationResults = this.applicationResults("AngularAccuracy");
        long l = applicationResults.getTime();
        Date date = new Date(l * 1000L);
        this.log("Last AAC: " + applicationResults.getResult() + ", ran @ : " + applicationResults.getTime() + " Date: " + date.toString() + " (Details:" + applicationResults.getDetails() + ")");
        Object[] objectArray = this.getTrackerPowerupTime();
        boolean bl = false;
        if (null != objectArray) {
            if (((Boolean)objectArray[0]).booleanValue()) {
                long l2 = (Long)objectArray[1];
                long l3 = System.currentTimeMillis();
                long l4 = -1L;
                int n = 1;
                if (objectArray.length > 2) {
                    l4 = (Long)objectArray[2];
                    n = (Integer)objectArray[3];
                }
                this.log("Tracker Powered on since @ " + l2 + " seconds, in other words @ " + new Date(l3 - l2 * 1000L).toString());
                if (0 != n) {
                    this.log("Tracker is not initialized yet!");
                } else {
                    this.log("Tracker initialized @ " + l4 + " seconds since powered on, in other words @ " + new Date(l3 - (l2 - l4) * 1000L).toString());
                    long l5 = l3 - (l2 - l4) * 1000L;
                    if (l * 1000L >= l5) {
                        if (applicationResults.getResult().trim().equalsIgnoreCase("pass")) {
                            this.log("Last AAC since initializing the tracker passed, so OK to use the tracker :) .");
                            bl = true;
                        } else {
                            bl = false;
                            this.log("Last AAC that was run after initializing the tracker failed. Re-run AAC.");
                        }
                    } else {
                        bl = false;
                        this.log("Tracker accuracy is not checked since initializing the tracker. Run AAC.");
                    }
                }
            } else {
                this.log("Failed to get the tracker start up time. Possible communication issue.");
                throw new TrackerException("Failed to determine when tracker was turned on possibly due to communication/network issue.");
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] getTrackerPowerupTime() throws TrackerException {
        boolean bl;
        Object[] objectArray;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        long l;
        block13: {
            l = -1L;
            bl4 = false;
            bl3 = false;
            bl2 = false;
            objectArray = null;
            Ftp ftp = new Ftp();
            try {
                if (ftp == null) break block13;
                ftp.connect(this.ipAddressToUse, "factory", "4253");
                DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32("system.zero_correct.time.value"), new DataTagUnsigned16("system.zero_correct.time.status")};
                this.readyForCommand();
                objectArray = TrackerVector.getTagData(ftp, dataTagArray);
                try {
                    int n = ftp.receiveStart("\\diagnose\\time.dat");
                    try {
                        String string;
                        if (150 == n && (string = ftp.receiveLine()) != null) {
                            StringTokenizer stringTokenizer = new StringTokenizer(string, "=");
                            String string2 = stringTokenizer.nextToken();
                            l = Long.parseLong(stringTokenizer.nextToken().trim());
                            bl4 = true;
                        }
                    }
                    finally {
                        n = ftp.receiveEnd();
                        bl3 = true;
                    }
                }
                finally {
                    ftp.disconnect();
                    bl2 = true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.log(numberFormatException.toString());
            }
            catch (FtpException ftpException) {
                this.log(ftpException.toString());
            }
            catch (TrackerException trackerException) {
                this.log(trackerException.toString());
            }
            catch (Exception exception) {
                this.log(exception.toString());
            }
        }
        boolean bl5 = bl = bl4 && bl3 && bl2;
        if (null != objectArray) {
            return new Object[]{new Boolean(bl), new Long(l), objectArray[0], objectArray[1]};
        }
        return null;
    }

    @Override
    public boolean isNoUICompCalCapable() throws TrackerException {
        try {
            Class clazz = this.getCompITSuperClass();
            Method method = clazz.getMethod("isNoUICompCalCapable", null);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public int batteryChargeRemaining(int n) throws TrackerException {
        throw new UnsupportedFeatureException("Feature not supported");
    }

    @Override
    public void factoryDisconnect(String string) throws TrackerException {
        throw new UnsupportedFeatureException("Feature not supported");
    }

    @Override
    public int batteryState(int n) throws TrackerException {
        throw new UnsupportedFeatureException("Feature not supported");
    }

    @Override
    public void changePowerButtonState(boolean bl) throws TrackerException {
        throw new UnsupportedFeatureException("Feature not supported");
    }

    @Override
    public boolean powerButtonState() throws TrackerException {
        throw new UnsupportedFeatureException("Feature not supported");
    }

    @Override
    public void reboot() throws TrackerException {
        throw new UnsupportedFeatureException("Feature not supported");
    }

    @Override
    public boolean isFollowMeCapable() throws TrackerException {
        return false;
    }

    @Override
    public void changeFollowMeState(boolean bl) throws TrackerException {
        throw new UnsupportedFeatureException("Feature not supported");
    }

    @Override
    public boolean isFollowMeOn() throws TrackerException {
        return false;
    }

    @Override
    public double getFollowMeSearchRadius() throws TrackerException {
        throw new UnsupportedFeatureException("Feature not supported");
    }

    @Override
    public void changeFollowMeSearchRadius(double d) throws TrackerException {
        throw new UnsupportedFeatureException("Feature not supported");
    }

    @Override
    public boolean sixDofCapable() throws TrackerException {
        return false;
    }

    @Override
    public Probe[] availableProbes() throws TrackerException {
        throw new UnsupportedFeatureException("Feature not supported");
    }

    @Override
    public void addProbe(Probe probe) throws TrackerException {
        throw new UnsupportedFeatureException("Feature not supported");
    }

    @Override
    public void removeProbe(Probe probe) throws TrackerException {
        throw new UnsupportedFeatureException("Feature not supported");
    }

    @Override
    public void modifyProbe(Probe probe) throws TrackerException {
        throw new UnsupportedFeatureException("Feature not supported");
    }

    @Override
    public void changeProbe(Probe probe, boolean bl) throws TrackerException {
        throw new UnsupportedFeatureException("Feature not supported");
    }

    @Override
    public Probe probe() throws TrackerException {
        throw new UnsupportedFeatureException("Feature not supported");
    }

    @Override
    public String probeAdapter() throws TrackerException {
        throw new UnsupportedFeatureException("Feature not supported");
    }

    @Override
    public boolean probeAdapterConnected() throws TrackerException {
        return false;
    }

    @Override
    public ProbeCompensationData calcProbeCompensationParameters(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, double[] dArray6) throws TrackerException {
        throw new UnsupportedFeatureException("Feature not supported");
    }

    @Override
    public ProbeCalibrationData calibrateProbeTip(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, double[] dArray6) throws TrackerException {
        throw new UnsupportedFeatureException("Feature not supported");
    }

    @Override
    public ProbeCalibrationData calibrateISOProbeTip(double[] dArray, double[] dArray2, double[] dArray3) throws TrackerException {
        throw new UnsupportedFeatureException("Feature not supported");
    }

    @Override
    public void updateProbeCompensationParameters(Probe probe, ProbeCompensationData probeCompensationData) throws TrackerException {
        throw new UnsupportedFeatureException("Feature not supported");
    }

    @Override
    public void updateProbeCompensationParameters(Probe probe, double d, double d2, double d3) throws TrackerException {
        throw new UnsupportedFeatureException("Feature not supported");
    }

    @Override
    public boolean sixDofEnabled() throws TrackerException {
        return false;
    }

    @Override
    public void changeSixDofEnableState(boolean bl) throws TrackerException {
        throw new UnsupportedFeatureException("Feature not supported");
    }

    @Override
    public int probeBatteryChargeRemaining() throws TrackerException {
        throw new UnsupportedFeatureException("Feature not supported");
    }

    @Override
    public void removeAllProbes() throws TrackerException {
        throw new UnsupportedFeatureException("Feature not supported");
    }

    @Override
    public void removeAllFactoryProbes() throws TrackerException {
        throw new UnsupportedFeatureException("Feature not supported");
    }

    @Override
    public double getDelayFromPassiveToActiveFollowMe() throws TrackerException {
        throw new UnsupportedFeatureException("Feature not supported");
    }

    @Override
    public void setDelayFromPassiveToActiveFollowMe(double d) throws TrackerException {
        throw new UnsupportedFeatureException("Feature not supported");
    }

    @Override
    public int probeBatteryState() throws TrackerException {
        throw new UnsupportedFeatureException("Feature not supported");
    }

    @Override
    public boolean probeBatteryStateChangeEventSupported() throws TrackerException {
        return false;
    }

    @Override
    public boolean wirelessStateChangeSupported() throws TrackerException {
        return false;
    }

    @Override
    public void changeWirelessState(boolean bl) throws TrackerException {
        throw new UnsupportedFeatureException("Feature not supported");
    }

    @Override
    public boolean wirelessOn() throws TrackerException {
        throw new UnsupportedFeatureException("Feature not supported");
    }

    @Override
    public boolean isCatEyeTargetCapable() throws TrackerException {
        return false;
    }

    public static class GestureRecognitionMode {
        public static final int ON = 1;
        public static final int OFF = 0;
    }

    private class AppRec {
        public String appName;
        public String fullQualifiedName;
        public Object[] jarFileName;
        public TrackerApp app;
        public boolean readFromLocal = false;
        public int appExitCode = 3;
        public ApplicationResults appResults;
        public int appPercentComplete = -1;

        public AppRec(String string, String string2, Object[] objectArray, boolean bl) {
            this.appName = string;
            this.fullQualifiedName = string2;
            this.jarFileName = objectArray;
            this.readFromLocal = bl;
            this.app = null;
            this.appResults = new ApplicationResults("Unknown result", 0L);
        }

        public void set(TrackerApp trackerApp) {
            this.app = trackerApp;
            this.appExitCode = 2;
            this.appPercentComplete = 1;
        }

        public void clear() {
            try {
                if (this.app != null) {
                    this.appExitCode = this.app.applicationExitCode();
                    this.appResults = this.app.applicationResults();
                    this.appPercentComplete = this.app.applicationPercentComplete();
                }
            }
            catch (TrackerException trackerException) {
                // empty catch block
            }
            this.app = null;
        }

        public boolean isSet() {
            return this.app != null;
        }

        void setAppName(String string) {
            this.appName = string;
        }
    }

    private class JarClassLoader
    extends SecureClassLoader {
        private String[] jarNamesToUse = null;
        private String ipAddress = null;

        private void downLoadJarFiles(AppRec appRec, boolean bl) throws ClassNotFoundException, TrackerException, FtpException {
            Object object;
            Object object2;
            int n;
            String[] stringArray = null;
            if (bl) {
                stringArray = (String[])appRec.jarFileName[1];
            } else {
                stringArray = (String[])appRec.jarFileName[0];
                this.setIpAddress();
            }
            if (stringArray == null) {
                System.err.println("tmpjarnames == null");
                throw new ClassNotFoundException("Application cannot be found in either local jars or in Tracker firmware");
            }
            int n2 = stringArray.length;
            ArrayList<Object> arrayList = new ArrayList<Object>(10);
            ArrayList<String> arrayList2 = new ArrayList<String>(10);
            for (n = 0; n < n2; ++n) {
                object2 = (JarFile)TrackerVector.this.jarCache.get(stringArray[n]);
                if (object2 != null) continue;
                URL uRL = null;
                try {
                    Object object3;
                    if (bl) {
                        uRL = new URL("jar:file:/" + TrackerVector.this.fileDirectory + stringArray[n] + "!/");
                    } else {
                        object = System.getProperty("java.io.tmpdir");
                        object3 = (String)object + "\\" + this.generateJarName();
                        TrackerVector.this.readFile((String)object3, stringArray[n]);
                        uRL = new URL("jar", "", -1, "file:/" + (String)object3 + "!/");
                        TrackerVector.this.tmpDownloadedJarsPath.add(object3);
                    }
                    object = (JarURLConnection)uRL.openConnection();
                    ((URLConnection)object).setUseCaches(false);
                    ((URLConnection)object).connect();
                    object3 = ((JarURLConnection)object).getJarFile();
                    arrayList2.add(stringArray[n]);
                    arrayList.add(object3);
                    continue;
                }
                catch (Exception exception) {
                    System.err.println("jar downloading error for jar name : " + stringArray[n] + " exception = " + exception.toString() + " msg = " + exception.getMessage());
                    throw new ClassNotFoundException("Error with JAR file downloading: " + stringArray[n]);
                }
            }
            this.jarNamesToUse = stringArray;
            for (n = 0; n < arrayList2.size(); ++n) {
                TrackerVector.this.jarCache.put(arrayList2.get(n), arrayList.get(n));
            }
            Collection collection = TrackerVector.this.jarCache.values();
            object2 = collection.iterator();
            int n3 = 0;
            while (object2.hasNext()) {
                object = (JarFile)object2.next();
                ++n3;
            }
        }

        public void setAppName(String string) throws ClassNotFoundException, TrackerException, FtpException {
            AppRec appRec = TrackerVector.this.findAppInfo(string);
            if (appRec == null) {
                throw new ClassNotFoundException(string);
            }
            boolean bl = appRec.readFromLocal;
            try {
                this.downLoadJarFiles(appRec, bl);
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.downLoadJarFiles(appRec, !bl);
            }
        }

        @Override
        public URL getResource(String string) {
            try {
                int n;
                boolean bl = false;
                if (string.startsWith("smx/tracker/appskeystone/utility")) {
                    bl = true;
                }
                String[] stringArray = null;
                stringArray = this.jarNamesToUse;
                int n2 = stringArray.length;
                JarFile jarFile = null;
                for (n = 0; n < n2 && !(bl ? stringArray[n].indexOf("utility") != -1 : stringArray[n].indexOf("utility") == -1); ++n) {
                }
                jarFile = (JarFile)TrackerVector.this.jarCache.get(stringArray[n]);
                if (jarFile != null) {
                    return new URL("jar:file:/" + jarFile.getName() + "!/" + string);
                }
            }
            catch (Exception exception) {
                System.err.println("ex = " + exception.getMessage() + "\ntostr = " + exception.toString());
                return null;
            }
            return null;
        }

        @Override
        public InputStream getResourceAsStream(String string) {
            try {
                InputStream inputStream = null;
                Collection collection = TrackerVector.this.jarCache.values();
                for (JarFile jarFile : collection) {
                    inputStream = jarFile.getInputStream(new ZipEntry(string));
                    if (inputStream == null) continue;
                    return inputStream;
                }
            }
            catch (IOException iOException) {
                System.err.println("ex = " + iOException.getMessage() + "\nnew getResource failed bcoz of Exception : " + iOException.toString());
                return null;
            }
            return null;
        }

        public Class findClass(String string) throws ClassNotFoundException {
            Class<?> clazz = null;
            try {
                Object object;
                String string2 = string.replace('.', '/') + ".class";
                InputStream inputStream = null;
                Collection collection = TrackerVector.this.jarCache.values();
                Iterator iterator = collection.iterator();
                while (iterator.hasNext() && (inputStream = ((JarFile)(object = (JarFile)iterator.next())).getInputStream(new ZipEntry(string2))) == null) {
                }
                if (inputStream == null) {
                    throw new ClassNotFoundException("No Class found by name : " + string);
                }
                object = this.loadClassData(inputStream);
                clazz = this.defineClass(string, (byte[])object, 0, ((Object)object).length);
                if (clazz == null) {
                    throw new ClassNotFoundException("Error defining class : " + string);
                }
            }
            catch (Exception exception) {
                throw new ClassNotFoundException("Error with JAR file accessing/reading: " + string);
            }
            return clazz;
        }

        private byte[] loadClassData(InputStream inputStream) throws IOException {
            int n;
            int n2 = inputStream.available();
            byte[] byArray = new byte[n2];
            for (int i = inputStream.read(byArray, 0, n2); i < n2; i += n) {
                n = inputStream.read(byArray, i, n2 - i);
            }
            inputStream.close();
            return byArray;
        }

        private void setIpAddress() throws FtpException {
            if (this.ipAddress != null) {
                return;
            }
            byte[] byArray = TrackerVector.this.ftpClient.getRemoteIPAddress().getAddress();
            int[] nArray = new int[4];
            for (int i = 0; i < 4; ++i) {
                nArray[i] = byArray[i];
                if (nArray[i] >= 0) continue;
                int n = i;
                nArray[n] = nArray[n] + 256;
            }
            this.ipAddress = nArray[0] + "." + nArray[1] + "." + nArray[2] + "." + nArray[3];
        }

        private String generateJarName() {
            String string = "jar_cachefv";
            for (int i = 0; i < 20; ++i) {
                int n = TrackerVector.this.generator.nextInt(9) + 1;
                string = string + n;
            }
            string = string + ".tmp";
            return string;
        }
    }

    public static class TrackerCapabilities {
        public static final int WIRELESS = 1;
        public static final int VIDEO = 4;
        public static final int GESTURES = 8;
    }

    public static class ApplicationResultCode {
        public static final int PASS = 0;
        public static final int FAIL = 1;
        public static final int RECOMMANDATION = 2;
    }

    public static class ApplicationExitCode {
        public static final int CLOSED = 0;
        public static final int CANCELLED = 1;
        public static final int RUNNING = 2;
        public static final int NEVER_RUN = 3;
        public static final int UNSUPPORTED = 4;
    }

    public static class EncoderImproveState {
        public static final int DISABLE = 0;
        public static final int ENABLE = 1;
    }

    public static class ADMVelocityCompState {
        public static final int DISABLE = 0;
        public static final int ENABLE = 1;
    }

    public static class ADMAutoAdjustState {
        public static final int DISABLE = 0;
        public static final int ENABLE = 1;
    }

    public static class OnTrackerTargetThermalCompState {
        public static final int OFF = 0;
        public static final int ON = 1;
    }

    public static class SmartWarmUpState {
        public static final int OFF = 0;
        public static final int ON = 1;
    }

    public static class PayloadThermalCompState {
        public static final int OFF = 0;
        public static final int ON = 1;
    }

    public static class AutoGainAdjustState {
        public static final int DISABLE = 0;
        public static final int ENABLE = 1;
    }

    public static class AzPostThermalCompState {
        public static final int OFF = 0;
        public static final int ON = 1;
    }

    public static class AlarmOutput {
        public static final int OFF = 0;
        public static final int ON = 1;
    }

    public static class SMART_WARMUP_STATE {
        public static final int DEFAULT = 0;
        public static final int IN_PROGRESS = 1;
        public static final int DONE = 2;
        public static final int TERMINATE = 3;
        public static final int ERROR = 4;
    }

    public static class TRACKER_TYPE {
        public static final int VANTAGE = 2;
    }

    public static class ADM_ALIGNMENT {
        public static final int PEAK = 0;
        public static final int COLINEAR = 1;
    }

    public static class ADMState {
        public static final int FINE = 0;
        public static final int COARSE = 1;
        public static final int FORCED_FINE = 2;
        public static final int FORCED_COARSE = 3;
        public static final int ERROR = 4;
    }

    public static class TrackerOrientation {
        public static final int Z_UP = 0;
        public static final int Z_DOWN = 1;
        public static final int Y_UP = 2;
        public static final int Y_DOWN = 3;
        public static final int X_DOWN = 4;
        public static final int X_UP = 5;
    }

    public static class TempSensorType {
        public static final int NONE = 0;
        public static final int AIR = 1;
        public static final int MATERIAL = 2;
    }

    public static class TargetState {
        public static final int NO_TARGET = 0;
        public static final int MARGINAL_TARGET = 1;
        public static final int TARGET_PRESENT = 2;
    }

    public static class DistanceMeasureMode {
        public static final int USER_SPECIFIED = 0;
        public static final int IFM_ONLY = 1;
        public static final int IFM_SET_BY_ADM = 2;
        public static final int ADM_ONLY = 3;
    }

    public static class TypeOfTarget {
        public static final int SMR_3_2 = 0;
        public static final int MIRROR = 1;
        public static final int SMR_1_2 = 2;
        public static final int SMR_7_8 = 3;
        public static final int SMR_USER = 4;
        public static final int SMR_3_2_WINDOWED = 5;
        public static final int SMR_7_8_WINDOWED = 6;
    }

    public static class FBSightMode {
        public static final int FRONTSIGHT = 0;
        public static final int BACKSIGHT = 1;
    }

    public static class TrackingMode {
        public static final int ON = 0;
        public static final int OFF = 1;
    }

    public static class MotorState {
        public static final int OFF = 0;
        public static final int ON = 1;
        public static final int FULL_MANUAL_CONTROL = 2;
        public static final int TORQUE_MANUAL_CONTROL = 3;
        public static final int FAILED = 4;
        public static final int NEVER_INITIALIZED = 5;
        public static final int FULL_MANUAL_FAILED = 6;
        public static final int FULL_MANUAL_NEVER_INITIALIZED = 7;
        public static final int INITIALIZING = 8;
    }

    public static class InternalTemperatureStability {
        public static final int NOT_STABLE = 0;
        public static final int STABLE = 1;
        public static final int CANNOT_DETERMINE_STABILITY = 2;
    }

    public static class ControlState {
        public static final int OFF = 0;
        public static final int ON_UNLOCKED = 1;
        public static final int ON_LOCKED = 2;
        public static final int MANUAL = 3;
        public static final int ERROR = 4;
    }

    public static class PointBeamState {
        public static final int OFF = 0;
        public static final int ON = 2;
        public static final int ERROR = 4;
    }

    public static class AlarmSelect {
        public static final int NONE = 0;
        public static final int DEVIATION = 1;
        public static final int HIGH = 2;
        public static final int LOW = 3;
    }

    public static class InputSelect {
        public static final int NO_SELECTION = 0;
        public static final int HARDWARE_INPUT = 1;
        public static final int MANUAL_INPUT = 2;
    }

    public static class StatusBits {
        public static final int DATA_ERROR = 1;
        public static final int DATA_INACCURATE = 2;
        public static final int DATA_HARDWARE_ERROR = 4;
        public static final int DATA_HARDWARE_INACCURATE = 8;
        public static final int DATA_NOT_COMPENSATED = 16;
        public static final int DATA_NOT_INITIALIZED = 32;
        public static final int DATA_MANUAL = 64;
        public static final int DATA_DISABLED = 128;
        public static final int DATA_DEFAULT = 256;
        public static final int DATA_SUPPORTING_DATA_INACCURATE = 512;
        public static final int DATA_SUPPORTING_DATA_ERROR = 1024;
    }
}

