/*
 * Decompiled with CFR 0.152.
 */
package smx.tracker;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import smx.tracker.CypherInfo;
import smx.tracker.NetworkCardInfo;
import smx.tracker.TrkInfo;
import smx.tracker.VantageIonInfo;

public class TrackerReachable {
    private Vector<TrkInfo> trksFoundList;
    private Vector<NetworkCardInfo> nicAddrsList;
    private PrintWriter debugWriter = null;
    private int TIMEOUT = 1;
    private int PING_TIMEOUT = 1000;
    HashMap<String, Boolean> wifiPingedIpsList = new HashMap();
    String notApplicable = "N/A";

    public TrackerReachable(Vector<TrkInfo> vector, Vector<NetworkCardInfo> vector2, PrintWriter printWriter) {
        this.trksFoundList = vector;
        this.nicAddrsList = vector2;
        this.debugWriter = printWriter;
    }

    protected ReachableInfo checkIfTrackerReachable(TrkInfo trkInfo) throws Exception {
        if (trkInfo instanceof CypherInfo) {
            ReachableInfo reachableInfo = this.getCypherReachableDetails(trkInfo, this.trksFoundList, "", null, this.nicAddrsList, false);
            CypherInfo cypherInfo = (CypherInfo)trkInfo;
            cypherInfo.setReachable(reachableInfo.getReachableState().ordinal());
            cypherInfo.setReachableDetails(reachableInfo.getDetails());
            cypherInfo.setReachableRecommendation(reachableInfo.getRecommendation());
        } else {
            ReachableInfo[] reachableInfoArray = this.getVantageIONReachableDetails(trkInfo, this.trksFoundList, "", null, this.nicAddrsList);
            VantageIonInfo vantageIonInfo = (VantageIonInfo)trkInfo;
            vantageIonInfo.setWiredReachable(reachableInfoArray[0].getReachableState().ordinal());
            vantageIonInfo.setWiredReachableDetails(reachableInfoArray[0].getDetails());
            vantageIonInfo.setWiredReachableRecommendation(reachableInfoArray[0].getRecommendation());
            if (vantageIonInfo.getModelType() == 1) {
                vantageIonInfo.setWifiReachable(reachableInfoArray[1].getReachableState().ordinal());
                vantageIonInfo.setWifiReachableDetails(reachableInfoArray[1].getDetails());
                vantageIonInfo.setWifiReachableRecommendation(reachableInfoArray[1].getRecommendation());
            }
        }
        return null;
    }

    private ReachableInfo getCypherReachableDetails(TrkInfo trkInfo, Vector<TrkInfo> vector, String string, Object[] objectArray, Vector<NetworkCardInfo> vector2, boolean bl) throws Exception {
        ReachableInfo reachableInfo = null;
        if (trkInfo instanceof CypherInfo) {
            String string2;
            CypherInfo cypherInfo = (CypherInfo)trkInfo;
            if (cypherInfo.getPacketType() == CypherInfo.CYPHER_WIFI_PACKET) {
                string2 = "";
                if (cypherInfo.supportsWifiSSIDInfo()) {
                    if (!cypherInfo.sessionsAvailable()) {
                        return new ReachableInfo(REACHABLE_STATE.NO, "Out of sessions", "Reboot tracker and try to connect");
                    }
                    if ((cypherInfo.getSerialType() & 1) == 0) {
                        return new ReachableInfo(REACHABLE_STATE.NO, "Tracker is not Wifi capable", "Cannot use  tracker in Wifi mode");
                    }
                    string2 = cypherInfo.getTrkSSID();
                    if (!cypherInfo.isTrkWifiOn()) {
                        return new ReachableInfo(REACHABLE_STATE.NO, "Tracker Wifi is off", "Turn tracker Wifi on and connect to SSID " + string2);
                    }
                }
                reachableInfo = this.getCypherWifiReachableDetails(true, cypherInfo, vector2, string2);
            }
            if (cypherInfo.getPacketType() == CypherInfo.CYPHER_WIRED_PACKET) {
                if (cypherInfo.supportsWifiSSIDInfo()) {
                    if (!cypherInfo.sessionsAvailable()) {
                        return new ReachableInfo(REACHABLE_STATE.NO, "Out of sessions", "Reboot tracker and try to connect");
                    }
                    if (!cypherInfo.isEthernetOn()) {
                        return new ReachableInfo(REACHABLE_STATE.NO, "No Ethernet Cable", "Connect ethernet cable from tracker to PC");
                    }
                }
                if (cypherInfo.getStaticDynamicInfo() == 2) {
                    string2 = cypherInfo.getIpAdd();
                    if (string2.equals("None") || string2.equals("0.0.0.0")) {
                        REACHABLE_STATE rEACHABLE_STATE = REACHABLE_STATE.NO;
                        String string3 = "DHCP IP address not available";
                        String string4 = "Tracker is in DHCP mode. Reconfigure tracker to a Static IP address or plug tracker ethernet cable into DHCP server network and connect the computer to the same network.";
                        return new ReachableInfo(rEACHABLE_STATE, string3, string4);
                    }
                    boolean bl2 = this.sendPingRequest(cypherInfo.getIpAdd());
                    if (bl2) {
                        return new ReachableInfo(REACHABLE_STATE.YES, "Tracker can be connected in wired mode (DHCP)", this.notApplicable);
                    }
                    return new ReachableInfo(REACHABLE_STATE.NO, "Tracker is in DHCP mode but connot be reached", "Plug tracker ethernet cable into DHCP server network and connect the computer to the same network.");
                }
                reachableInfo = this.getWiredReachableDetails(cypherInfo, vector2);
            }
        }
        return reachableInfo;
    }

    private ReachableInfo getCypherWifiReachableDetails(boolean bl, TrkInfo trkInfo, Vector<NetworkCardInfo> vector, String string) {
        String string2;
        REACHABLE_STATE rEACHABLE_STATE;
        String string3 = this.notApplicable;
        String string4 = this.notApplicable;
        boolean bl2 = this.checkIfIPaddressAreWithinSameSubnet(trkInfo);
        REACHABLE_STATE rEACHABLE_STATE2 = rEACHABLE_STATE = bl2 ? REACHABLE_STATE.YES : REACHABLE_STATE.NO;
        if (bl2) {
            string3 = "Tracker can be reached in Wifi mode";
        } else {
            Object[] objectArray = this.checkIfTrkCanBeReachedFromAnotherNIC(trkInfo, vector);
            if (((Boolean)objectArray[0]).booleanValue()) {
                string3 = "Computer not connected to tracker SSID";
                if (string.equals("")) {
                    if (trkInfo.getPacketType() == TrkInfo.CYPHER_WIFI_PACKET) {
                        string2 = this.getSSIDNameFromSrNum(trkInfo);
                        string4 = "Connect to tracker SSID ending with serial number " + string2;
                    }
                } else {
                    string4 = "Connect to tracker SSID \"" + string + "\"";
                }
            } else {
                string3 = "Computer not connected to tracker SSID";
                if (string.equals("")) {
                    if (trkInfo.getPacketType() == TrkInfo.CYPHER_WIFI_PACKET) {
                        string2 = this.getSSIDNameFromSrNum(trkInfo);
                        string4 = "Connect to tracker SSID ending with serial number " + string2;
                    }
                } else {
                    string4 = "Connect to tracker SSID \"" + string + "\"";
                }
            }
        }
        boolean bl3 = this.wifiPingedIpsList.get(trkInfo.getSrNum());
        if (!bl3) {
            rEACHABLE_STATE = REACHABLE_STATE.NO;
            string3 = "Computer not connected to tracker SSID";
            string4 = "Connect to tracker SSID " + string;
            if (string.equals("") && trkInfo.getPacketType() == TrkInfo.CYPHER_WIFI_PACKET) {
                string2 = this.getSSIDNameFromSrNum(trkInfo);
                string4 = "Connect to tracker SSID ending with serial number " + string2;
            }
        }
        return new ReachableInfo(rEACHABLE_STATE, string3, string4);
    }

    private ReachableInfo[] getVantageIONReachableDetails(TrkInfo trkInfo, Vector<TrkInfo> vector, String string, Object[] objectArray, Vector<NetworkCardInfo> vector2) throws Exception {
        ReachableInfo[] reachableInfoArray = new ReachableInfo[2];
        if (trkInfo instanceof VantageIonInfo) {
            VantageIonInfo vantageIonInfo = (VantageIonInfo)trkInfo;
            reachableInfoArray[0] = this.getWiredReachableDetails(vantageIonInfo, vector2);
            if (vantageIonInfo.getModelType() == 1) {
                String string2 = vantageIonInfo.getSSIDName();
                reachableInfoArray[1] = this.getVantageIONWifiReachableDetails(true, vantageIonInfo, vector2, string2);
            }
        }
        return reachableInfoArray;
    }

    private ReachableInfo getVantageIONWifiReachableDetails(boolean bl, TrkInfo trkInfo, Vector<NetworkCardInfo> vector, String string) throws Exception {
        REACHABLE_STATE rEACHABLE_STATE;
        String string2 = this.notApplicable;
        String string3 = this.notApplicable;
        VantageIonInfo vantageIonInfo = (VantageIonInfo)trkInfo;
        if (vantageIonInfo.getWifiMode() == 0) {
            return new ReachableInfo(REACHABLE_STATE.NONE, string2, string3);
        }
        if (vantageIonInfo.getWifiMode() == 2) {
            return new ReachableInfo(REACHABLE_STATE.NO, "Wifi is OFF", "Turn Wifi On");
        }
        boolean bl2 = TrackerReachable.checkIfIPaddressAreWithinSameSubnet(vantageIonInfo.getWifiIp(), vantageIonInfo.getIpMask(), vantageIonInfo.getNetworkCardIpAdd(), vantageIonInfo.getNetworkCardIpMask());
        REACHABLE_STATE rEACHABLE_STATE2 = rEACHABLE_STATE = bl2 ? REACHABLE_STATE.YES : REACHABLE_STATE.NO;
        if (bl2) {
            string2 = "Tracker can be reached in Wifi mode";
        } else {
            Object[] objectArray = this.checkIfTrkCanBeReachedFromAnotherNIC(vantageIonInfo.getWifiIp(), vantageIonInfo.getIpMask(), vantageIonInfo, vector);
            if (((Boolean)objectArray[0]).booleanValue()) {
                string2 = "Computer not connected to tracker SSID";
                string3 = "Connect to tracker SSID " + string;
            } else {
                string2 = "Computer not connected to tracker SSID";
                string3 = "Connect to tracker SSID " + string;
            }
        }
        boolean bl3 = this.wifiPingedIpsList.get(trkInfo.getSrNum());
        if (!bl3) {
            rEACHABLE_STATE = REACHABLE_STATE.NO;
            string2 = "Computer not connected to tracker SSID ";
            string3 = "Connect to tracker SSID " + string;
        }
        return new ReachableInfo(rEACHABLE_STATE, string2, string3);
    }

    private Object[] checkIfTrkCanBeReachedFromAnotherNIC(String string, String string2, TrkInfo trkInfo, Vector vector) {
        boolean bl = false;
        int n = 0;
        int n2 = vector.size();
        if (n2 == 0) {
            return new Object[]{bl, n};
        }
        for (int i = 0; i < n2; ++i) {
            NetworkCardInfo networkCardInfo = (NetworkCardInfo)vector.get(i);
            String string3 = networkCardInfo.getIPAddress().getHostAddress();
            String string4 = networkCardInfo.getSubNet();
            if (string3.equals(trkInfo.getNetworkCardIpAdd()) && string4.equals(trkInfo.getNetworkCardIpMask()) || !(bl = TrackerReachable.checkIfIPaddressAreWithinSameSubnet(string, string2, string3, string4))) continue;
            NetworkInterface networkInterface = networkCardInfo.getNetworkInterface();
            n = i;
            break;
        }
        return new Object[]{new Boolean(bl), new Integer(n)};
    }

    private ReachableInfo getWiredReachableDetails(TrkInfo trkInfo, Vector<NetworkCardInfo> vector) {
        REACHABLE_STATE rEACHABLE_STATE;
        String string = this.notApplicable;
        String string2 = this.notApplicable;
        if (this.sendPingRequest(trkInfo.getIpAdd())) {
            return new ReachableInfo(REACHABLE_STATE.YES, string, string2);
        }
        boolean bl = this.checkIfIPaddressAreWithinSameSubnet(trkInfo);
        REACHABLE_STATE rEACHABLE_STATE2 = rEACHABLE_STATE = bl ? REACHABLE_STATE.YES : REACHABLE_STATE.NO;
        if (bl) {
            string = "Tracker can be reached in wired mode";
        } else {
            Object[] objectArray = this.checkIfTrkCanBeReachedFromAnotherNIC(trkInfo, vector);
            if (((Boolean)objectArray[0]).booleanValue()) {
                string = "Not connected to PC";
                string2 = "Connect ethernet cable from tracker to PC network card \"" + (String)objectArray[2] + "\"";
            } else {
                string = "PC network card IP address not in the same subnet tracker IP address";
                string2 = "Change the PC network IP address to be in the same subnet of tracker IP address or vice versa.";
                String string3 = trkInfo.getIpAdd();
                if (string3.startsWith("128.128.128.")) {
                    string2 = string3.equals("128.128.128.10") ? "Set the PC network card IP address to 128.128.128.11" : "Set the PC network card IP address to 128.128.128.10";
                }
            }
        }
        return new ReachableInfo(rEACHABLE_STATE, string, string2);
    }

    private boolean checkIfIPaddressAreWithinSameSubnet(TrkInfo trkInfo) {
        return TrackerReachable.checkIfIPaddressAreWithinSameSubnet(trkInfo, trkInfo.getNetworkCardIpAdd(), trkInfo.getNetworkCardIpMask());
    }

    private static boolean checkIfIPaddressAreWithinSameSubnet(TrkInfo trkInfo, String string, String string2) {
        String string3 = trkInfo.getIpAdd();
        String string4 = trkInfo.getIpMask();
        if (trkInfo instanceof VantageIonInfo) {
            if (((VantageIonInfo)trkInfo).getWifiMode() == 1) {
                string3 = ((VantageIonInfo)trkInfo).getWifiIp();
            }
        } else if (trkInfo instanceof CypherInfo && (string3.equalsIgnoreCase("None") || string4.equalsIgnoreCase("None"))) {
            return false;
        }
        return TrackerReachable.checkIfIPaddressAreWithinSameSubnet(string3, trkInfo.getIpMask(), string, string2);
    }

    private Object[] checkIfTrkCanBeReachedFromAnotherNIC(TrkInfo trkInfo, Vector vector) {
        boolean bl = false;
        int n = 0;
        String string = "";
        int n2 = vector.size();
        if (n2 == 0) {
            return new Object[]{bl, n};
        }
        for (int i = 0; i < n2; ++i) {
            NetworkCardInfo networkCardInfo = (NetworkCardInfo)vector.get(i);
            String string2 = networkCardInfo.getIPAddress().getHostAddress();
            String string3 = networkCardInfo.getSubNet();
            if (string2.equals(trkInfo.getNetworkCardIpAdd()) && string3.equals(trkInfo.getNetworkCardIpMask()) || !(bl = TrackerReachable.checkIfIPaddressAreWithinSameSubnet(trkInfo, string2, string3))) continue;
            NetworkInterface networkInterface = networkCardInfo.getNetworkInterface();
            string = networkInterface.getDisplayName();
            n = i;
            break;
        }
        return new Object[]{new Boolean(bl), new Integer(n), new String(string)};
    }

    private ReachableInfo checkIfTrackersHaveSameIP(TrkInfo trkInfo, Vector<TrkInfo> vector) {
        String string;
        Object object;
        boolean bl = false;
        int n = vector.size();
        String string2 = "";
        String string3 = "";
        if (trkInfo instanceof VantageIonInfo) {
            string2 = ((VantageIonInfo)trkInfo).getSrNum();
            string3 = ((VantageIonInfo)trkInfo).getIpAdd();
        }
        if (trkInfo instanceof CypherInfo) {
            string2 = ((CypherInfo)trkInfo).getSrNum();
            string3 = ((CypherInfo)trkInfo).getIpAdd();
        }
        for (int i = 0; i < n && !bl; ++i) {
            TrkInfo trkInfo2;
            object = vector.get(new Integer(i));
            string = "";
            String string4 = "";
            if (object instanceof VantageIonInfo) {
                trkInfo2 = (VantageIonInfo)object;
                if (((VantageIonInfo)trkInfo2).getWifiMode() == 1) continue;
                string = trkInfo2.getSrNum();
                string4 = trkInfo2.getIpAdd();
            }
            if (object instanceof CypherInfo) {
                trkInfo2 = (CypherInfo)object;
                if (trkInfo2.getPacketType() == TrkInfo.CYPHER_WIFI_PACKET) continue;
                string = trkInfo2.getSrNum();
                string4 = trkInfo2.getIpAdd();
            }
            if (string2.equals(string) || !string3.equals(string4)) continue;
            bl = true;
        }
        REACHABLE_STATE rEACHABLE_STATE = bl ? REACHABLE_STATE.NO : REACHABLE_STATE.YES;
        object = bl ? "Duplicate IP" : this.notApplicable;
        string = bl ? "Resolve IP Conflict" : this.notApplicable;
        return new ReachableInfo(rEACHABLE_STATE, (String)object, string);
    }

    public static boolean checkIfIPaddressAreWithinSameSubnet(String string, String string2, String string3, String string4) {
        int n;
        if (string.equalsIgnoreCase("None") || string2.equalsIgnoreCase("None")) {
            return false;
        }
        String[] stringArray = string.split("\\.");
        String[] stringArray2 = string3.split("\\.");
        String[] stringArray3 = string2.split("\\.");
        String[] stringArray4 = string4.split("\\.");
        int n2 = stringArray.length;
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        String string5 = "";
        String string6 = "";
        for (n = 0; n < n2; ++n) {
            nArray[n] = Integer.parseInt(stringArray[n]) & Integer.parseInt(stringArray3[n]);
            nArray2[n] = Integer.parseInt(stringArray2[n]) & Integer.parseInt(stringArray4[n]);
            string5 = string5 + nArray[n];
            string6 = string6 + nArray2[n];
            if (n >= 3) continue;
            string5 = string5 + ".";
            string6 = string6 + ".";
        }
        n = 1;
        for (int i = 0; i < 2; ++i) {
            if (nArray[i] == nArray2[i]) continue;
            n = 0;
        }
        return n != 0;
    }

    private boolean sendPingRequest(String string) {
        if (null == string) {
            return false;
        }
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            return inetAddress.isReachable(this.PING_TIMEOUT);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    protected void checkIfTrackersReachable() {
        TrkInfo trkInfo;
        this.checkIfAnyWifiIpIsPingable();
        int n = this.trksFoundList.size();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            TrkInfo trkInfo2 = this.trksFoundList.get(i);
            if (trkInfo2 instanceof CypherInfo ? ((CypherInfo)(trkInfo = (CypherInfo)trkInfo2)).isReachable() == REACHABLE_STATE.NO.ordinal() : ((VantageIonInfo)(trkInfo = (VantageIonInfo)trkInfo2)).isWiredReachable() == REACHABLE_STATE.NO.ordinal()) continue;
            ++n2;
        }
        if (n2 == 0) {
            return;
        }
        CountDownLatch countDownLatch = new CountDownLatch(n2);
        for (int i = 0; i < n; ++i) {
            TrkInfo trkInfo3;
            trkInfo = this.trksFoundList.get(i);
            if (trkInfo instanceof CypherInfo ? ((CypherInfo)(trkInfo3 = (CypherInfo)trkInfo)).isReachable() == REACHABLE_STATE.NO.ordinal() : ((VantageIonInfo)(trkInfo3 = (VantageIonInfo)trkInfo)).isWiredReachable() == REACHABLE_STATE.NO.ordinal()) continue;
            new CheckIfTrkReachableThread(trkInfo, "TrkReachThread_" + (i + 1), countDownLatch);
        }
        try {
            countDownLatch.await(this.TIMEOUT, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void logLine(String string) {
        if (this.debugWriter != null) {
            this.debugWriter.println(string);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void checkIfAnyWifiIpIsPingable() {
        void var7_13;
        CheckIfWifiIpPingableThread[] checkIfWifiIpPingableThreadArray;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = this.trksFoundList.size();
        for (int i = 0; i < n; ++i) {
            checkIfWifiIpPingableThreadArray = this.trksFoundList.get(i);
            if (checkIfWifiIpPingableThreadArray instanceof CypherInfo) {
                if (checkIfWifiIpPingableThreadArray.getPacketType() != CypherInfo.CYPHER_WIFI_PACKET) continue;
                hashMap.put(checkIfWifiIpPingableThreadArray.getIpAdd(), checkIfWifiIpPingableThreadArray.getSrNum());
                continue;
            }
            VantageIonInfo vantageIonInfo = (VantageIonInfo)checkIfWifiIpPingableThreadArray;
            if (vantageIonInfo.getModelType() != 1) continue;
            hashMap.put(vantageIonInfo.getWifiIp(), vantageIonInfo.getSrNum());
        }
        CountDownLatch countDownLatch = new CountDownLatch(n);
        checkIfWifiIpPingableThreadArray = new CheckIfWifiIpPingableThread[n];
        int n2 = 0;
        for (Map.Entry object2 : hashMap.entrySet()) {
            String string = (String)object2.getKey();
            checkIfWifiIpPingableThreadArray[n2] = new CheckIfWifiIpPingableThread(string, "SSID", countDownLatch);
            ++n2;
        }
        try {
            countDownLatch.await(this.TIMEOUT, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            this.logLine("Reachable Threads timeout");
        }
        HashMap hashMap2 = new HashMap();
        n2 = 0;
        for (Map.Entry entry : hashMap.entrySet()) {
            String string = (String)entry.getKey();
            hashMap2.put(string, checkIfWifiIpPingableThreadArray[n2].pingable());
            ++n2;
        }
        boolean bl = false;
        while (var7_13 < n) {
            TrkInfo trkInfo = this.trksFoundList.get((int)var7_13);
            boolean bl2 = false;
            if (trkInfo instanceof CypherInfo) {
                if (trkInfo.getPacketType() == CypherInfo.CYPHER_WIFI_PACKET && hashMap2.containsKey(trkInfo.getIpAdd())) {
                    bl2 = (Boolean)hashMap2.get(trkInfo.getIpAdd());
                }
            } else {
                VantageIonInfo vantageIonInfo = (VantageIonInfo)trkInfo;
                if (vantageIonInfo.getModelType() == 1 && hashMap2.containsKey(vantageIonInfo.getWifiIp())) {
                    bl2 = (Boolean)hashMap2.get(vantageIonInfo.getWifiIp());
                }
            }
            this.wifiPingedIpsList.put(trkInfo.getSrNum(), bl2);
            ++var7_13;
        }
    }

    private void checkIfReachableTrackersHaveSameIP() {
        int n = this.trksFoundList.size();
        for (int i = 0; i < n; ++i) {
            Object object;
            String string;
            Object object2;
            TrkInfo trkInfo;
            TrkInfo trkInfo2 = this.trksFoundList.get(i);
            if (trkInfo2 instanceof VantageIonInfo && ((VantageIonInfo)(trkInfo = (VantageIonInfo)trkInfo2)).getWifiMode() == 1 || trkInfo2 instanceof CypherInfo && (trkInfo = (CypherInfo)trkInfo2).getPacketType() == TrkInfo.CYPHER_WIFI_PACKET) continue;
            boolean bl = false;
            String string2 = "";
            String string3 = "";
            if (trkInfo2 instanceof VantageIonInfo) {
                string2 = ((VantageIonInfo)trkInfo2).getSrNum();
                string3 = ((VantageIonInfo)trkInfo2).getIpAdd();
            }
            if (trkInfo2 instanceof CypherInfo) {
                string2 = ((CypherInfo)trkInfo2).getSrNum();
                string3 = ((CypherInfo)trkInfo2).getIpAdd();
            }
            System.out.println("");
            System.out.println(string2 + "," + string3);
            for (int j = 0; j < n && !bl; ++j) {
                TrkInfo trkInfo3;
                object2 = this.trksFoundList.get(new Integer(j));
                string = "";
                object = "";
                if (object2 instanceof VantageIonInfo) {
                    trkInfo3 = (VantageIonInfo)object2;
                    if (((VantageIonInfo)trkInfo3).getWifiMode() == 1 || ((VantageIonInfo)trkInfo3).isWiredReachable() == REACHABLE_STATE.NO.ordinal() || !this.checkIfIPaddressAreWithinSameSubnet((TrkInfo)object2)) continue;
                    string = trkInfo3.getSrNum();
                    object = trkInfo3.getIpAdd();
                }
                if (object2 instanceof CypherInfo) {
                    trkInfo3 = (CypherInfo)object2;
                    if (trkInfo3.getPacketType() == TrkInfo.CYPHER_WIFI_PACKET || ((CypherInfo)trkInfo3).isReachable() == REACHABLE_STATE.NO.ordinal()) continue;
                    string = trkInfo3.getSrNum();
                    object = trkInfo3.getIpAdd();
                    System.out.println("\t" + string + "," + (String)object);
                }
                if (string2.equals(string) || !string3.equals(object)) continue;
                bl = true;
            }
            if (!bl) continue;
            REACHABLE_STATE rEACHABLE_STATE = REACHABLE_STATE.NO;
            object2 = "Duplicate IP";
            string = "Resolve IP Conflict";
            if (trkInfo2 instanceof VantageIonInfo) {
                object = (VantageIonInfo)trkInfo2;
                ((VantageIonInfo)object).setWiredReachable(rEACHABLE_STATE.ordinal());
                ((VantageIonInfo)object).setWiredReachableDetails((String)object2);
                ((VantageIonInfo)object).setWiredReachableRecommendation(string);
            }
            if (!(trkInfo2 instanceof CypherInfo)) continue;
            object = (CypherInfo)trkInfo2;
            ((CypherInfo)object).setReachable(rEACHABLE_STATE.ordinal());
            ((CypherInfo)object).setReachableDetails((String)object2);
            ((CypherInfo)object).setReachableRecommendation(string);
        }
    }

    private String getSSIDNameFromSrNum(TrkInfo trkInfo) {
        String string = trkInfo.getSrNum();
        int n = string.length();
        if (n > 4) {
            string = string.substring(n - 4, n);
        }
        return string;
    }

    private class CheckIfWifiIpPingableThread
    implements Runnable {
        String ip;
        CountDownLatch latch;
        boolean ping = false;

        public CheckIfWifiIpPingableThread(String string, String string2, CountDownLatch countDownLatch) {
            this.ip = string;
            this.latch = countDownLatch;
            Thread thread = new Thread((Runnable)this, string2);
            thread.setDaemon(true);
            thread.start();
        }

        @Override
        public void run() {
            String string = Thread.currentThread().getName();
            try {
                this.ping = TrackerReachable.this.sendPingRequest(this.ip);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.latch != null) {
                this.latch.countDown();
            }
        }

        public boolean pingable() {
            return this.ping;
        }
    }

    private class CheckIfTrkReachableThread
    implements Runnable {
        TrkInfo trkInfo;
        CountDownLatch latch;

        public CheckIfTrkReachableThread(TrkInfo trkInfo, String string, CountDownLatch countDownLatch) {
            this.trkInfo = trkInfo;
            this.latch = countDownLatch;
            Thread thread = new Thread((Runnable)this, string);
            thread.setDaemon(true);
            thread.start();
        }

        @Override
        public void run() {
            String string = Thread.currentThread().getName();
            try {
                TrackerReachable.this.checkIfTrackerReachable(this.trkInfo);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.latch != null) {
                this.latch.countDown();
            }
        }
    }

    static enum REACHABLE_STATE {
        NONE,
        YES,
        NO;

    }

    class ReachableInfo {
        REACHABLE_STATE state;
        String details;
        String recommendation;

        ReachableInfo(REACHABLE_STATE rEACHABLE_STATE, String string, String string2) {
            this.state = rEACHABLE_STATE;
            this.details = string;
            this.recommendation = string2;
        }

        public REACHABLE_STATE getReachableState() {
            return this.state;
        }

        public String getDetails() {
            return this.details;
        }

        public String getRecommendation() {
            return this.recommendation;
        }
    }
}

