/*
 * Decompiled with CFR 0.152.
 */
package smx.tracker;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.DatagramPacket;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.JarFile;
import javax.swing.JComponent;
import javax.swing.JFrame;
import smx.ftp.Ftp;
import smx.ftp.FtpException;
import smx.ftp.FtpIOException;
import smx.tracker.Alarm;
import smx.tracker.AlarmType;
import smx.tracker.ApplicationResults;
import smx.tracker.AsyncAlreadyStartedException;
import smx.tracker.AvailableTracker;
import smx.tracker.ClassLoadException;
import smx.tracker.CommandThread;
import smx.tracker.ConnectFailedException;
import smx.tracker.CypherInfo;
import smx.tracker.DataTag;
import smx.tracker.DataTagDouble;
import smx.tracker.DataTagUnsigned32;
import smx.tracker.Diagnostic;
import smx.tracker.DistanceMode;
import smx.tracker.DistanceTrigger;
import smx.tracker.ExtTempType;
import smx.tracker.FindTrackers;
import smx.tracker.InterfaceBusyException;
import smx.tracker.InternalTrackerException;
import smx.tracker.LevelData;
import smx.tracker.MPEResultsData;
import smx.tracker.MaterialTemperatureData;
import smx.tracker.MeasureCfg;
import smx.tracker.MeasureData;
import smx.tracker.MeasurePointData;
import smx.tracker.MeasurePointStdDev;
import smx.tracker.MeasureTypeException;
import smx.tracker.NoDataAvailableException;
import smx.tracker.NullFilter;
import smx.tracker.NullStartTrigger;
import smx.tracker.Probe;
import smx.tracker.ProbeCalibrationData;
import smx.tracker.ProbeCompensationData;
import smx.tracker.SimplePointPairData;
import smx.tracker.Status;
import smx.tracker.TargetType;
import smx.tracker.TrackerApp;
import smx.tracker.TrackerCypher;
import smx.tracker.TrackerException;
import smx.tracker.TrackerInterface;
import smx.tracker.TrackerKeystone;
import smx.tracker.TrackerVector;
import smx.tracker.TrkInfo;
import smx.tracker.UnsupportedFeatureException;
import smx.tracker.VantageIonInfo;
import smx.tracker.VersionInfo;
import smx.tracker.VideoCfg;
import smx.tracker.VideoData;
import smx.tracker.WeatherInformation;
import smx.tracker.event.AlarmListener;
import smx.tracker.event.ApplicationListener;
import smx.tracker.event.BkndMeasureDataListener;
import smx.tracker.event.BusyListener;
import smx.tracker.event.ChangeListener;
import smx.tracker.event.CommandCompleteListener;
import smx.tracker.event.ConnectListener;
import smx.tracker.event.DiagnosticListener;
import smx.tracker.event.EventListenerList;
import smx.tracker.event.FactoryBkndMeasureDataListener;
import smx.tracker.event.MeasureDataListener;
import smx.tracker.event.ProbeButtonListener;
import smx.tracker.event.StatusListener;
import smx.tracker.event.VideoDataListener;

public class Tracker {
    private CommandThread trackerMgr;
    private TrackerInterface trackerIntf;
    private EventListenerList exclusiveListenerList = new EventListenerList();
    private TrackerApp trackerApp;
    private final String NO_UI_SELF_COMP_COMPIT_PARAMS = "-a SELF_COMP_NO_UI -fselfcomp= , continue_on";
    private long startingTimeForNoUIComp = 0L;
    private final String NO_UI_QUICK_COMP_COMPIT_PARAMS = "-a QUICK_COMP_NO_UI -fquickcomp= , continue_on";
    private final String NO_UI_AAC_COMPIT_PARAMS = "-a AAC_NO_UI -faac= , continue_on";
    private final int MAX_NUMBER_OF_REPEATABILITY_CHECKS_FOR_AAC = 10;
    private final double MAX_REPEATABILITY_TOLERANCE_FOR_AAC = 5.0E-6;
    private String noUIAppParams = null;
    private static final String OLD_RESP = "Tracker IP Resp";
    private static final String NEW_RESP = "TrackerV2 network response";
    private static final int SHORT_TIME_OUT = 300;
    private static final int LONG_TIME_OUT = 3000;
    private boolean threadTransactionInProgress = false;
    private Thread exclusiveThread = null;
    private boolean blockingFlag = false;
    private boolean bkndMeasureBlockingFlag = false;
    private boolean factoryBkndMeasureBlockingFlag = false;
    private int measureEventRate = 1;
    private int bkndMeasureEventRate = 1;
    private int factoryBkndMeasureEventRate = 1;
    private String trackerType = "";
    private static final int PACKET_LENGTH = 200;
    private static final int TIMEOUT = 3000;
    private static final int OLD_PORT = 4000;
    private static final String OLD_GROUP = "224.0.0.40";
    private static final int NEW_PORT = 54000;
    private static final String NEW_GROUP = "239.0.0.40";
    private String ipAddressToUse = null;
    private final double PI = Math.PI;
    private final double TINY = 1.0E-14;
    private static PrintWriter debugWriter = null;

    private void init(TrackerInterface trackerInterface) {
        this.trackerIntf = trackerInterface;
        this.trackerMgr = new CommandThread(this.trackerIntf);
    }

    public Tracker(TrackerInterface trackerInterface) throws TrackerException {
        this.init(trackerInterface);
    }

    public Tracker(String string) throws TrackerException {
        Class<?> clazz;
        Tracker.logLine(new Date().toString());
        if (null != string) {
            this.trackerType = string = string.trim();
        }
        try {
            clazz = Class.forName("smx.tracker." + string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            String[] stringArray = Tracker.getTrackerIPAndType(string, true);
            if (null == stringArray) {
                throw new TrackerException("Failed to identify tracker type for \"" + string + "\".");
            }
            String string2 = stringArray[0];
            this.trackerType = stringArray[0].trim();
            this.ipAddressToUse = stringArray[1];
            try {
                clazz = Class.forName("smx.tracker." + string2);
            }
            catch (ClassNotFoundException classNotFoundException2) {
                throw new ClassLoadException();
            }
        }
        try {
            TrackerInterface trackerInterface = (TrackerInterface)clazz.newInstance();
            this.init(trackerInterface);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ClassLoadException();
        }
        catch (InstantiationException instantiationException) {
            throw new ClassLoadException();
        }
    }

    protected void finalize() {
        this.trackerMgr.shutdown();
    }

    private boolean localBusy(Thread thread) {
        return this.threadTransactionInProgress || this.trackerMgr.isBusy() || null != this.exclusiveThread && thread != this.exclusiveThread;
    }

    public synchronized void setBlocking(boolean bl) throws TrackerException {
        if (this.localBusy(Thread.currentThread()) || this.trackerMgr.measureInProgress()) {
            throw new InterfaceBusyException("Transaction or measurement in progress");
        }
        this.blockingFlag = bl;
    }

    public boolean getBlocking() {
        return this.blockingFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBkndMeasureBlocking(boolean bl) throws TrackerException {
        Tracker tracker = this;
        synchronized (tracker) {
            if (this.localBusy(Thread.currentThread()) || this.trackerMgr.bkndMeasureInProgress()) {
                throw new InterfaceBusyException("Background measurement in progress");
            }
        }
        this.bkndMeasureBlockingFlag = bl;
    }

    public boolean getBkndMeasureBlocking() {
        return this.bkndMeasureBlockingFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFactoryBkndMeasureBlocking(boolean bl) throws TrackerException {
        Tracker tracker = this;
        synchronized (tracker) {
            if (this.localBusy(Thread.currentThread()) || this.trackerMgr.factoryBkndMeasureInProgress()) {
                throw new InterfaceBusyException("Factory background measurement in progress");
            }
        }
        this.factoryBkndMeasureBlockingFlag = bl;
    }

    public boolean getFactoryBkndMeasureBlocking() {
        return this.factoryBkndMeasureBlockingFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMeasureEventRate(int n) throws TrackerException {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        Tracker tracker = this;
        synchronized (tracker) {
            if (this.localBusy(Thread.currentThread()) || this.trackerMgr.measureInProgress()) {
                throw new InterfaceBusyException("Measurement in progress");
            }
        }
        this.measureEventRate = n;
    }

    public int getMeasureEventRate() {
        return this.measureEventRate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBkndMeasureEventRate(int n) throws TrackerException {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        Tracker tracker = this;
        synchronized (tracker) {
            if (this.localBusy(Thread.currentThread()) || this.trackerMgr.bkndMeasureInProgress()) {
                throw new InterfaceBusyException("Background measurement in progress");
            }
        }
        this.bkndMeasureEventRate = n;
    }

    public int getBkndMeasureEventRate() {
        return this.bkndMeasureEventRate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFactoryBkndMeasureEventRate(int n) throws TrackerException {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        Tracker tracker = this;
        synchronized (tracker) {
            if (this.localBusy(Thread.currentThread()) || this.trackerMgr.factoryBkndMeasureInProgress()) {
                throw new InterfaceBusyException("Factory background measurement in progress");
            }
        }
        this.factoryBkndMeasureEventRate = n;
    }

    public int getFactoryBkndMeasureEventRate() {
        return this.factoryBkndMeasureEventRate;
    }

    public VersionInfo version() {
        String string = "Driver_v5.1.7.3";
        return this.createVersionInformation(string);
    }

    private VersionInfo createVersionInformation(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        String string2 = "";
        try {
            if (string.indexOf(95) != -1) {
                string = string.substring(string.lastIndexOf(95) + 1);
            }
            string = string.toLowerCase(Locale.ENGLISH);
            switch (string.charAt(0)) {
                case 'x': {
                    string2 = "xDevelopment";
                    break;
                }
                case 'a': {
                    string2 = "Alpha";
                    break;
                }
                case 'b': {
                    string2 = "Beta";
                    break;
                }
                default: {
                    string2 = "vRelease";
                }
            }
            String string3 = string;
            try {
                Integer.parseInt(string.substring(0, 1));
            }
            catch (NumberFormatException numberFormatException) {
                string3 = string.substring(1);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string3, ".");
            if (stringTokenizer.hasMoreTokens()) {
                n = Integer.parseInt(stringTokenizer.nextToken());
            }
            if (stringTokenizer.hasMoreTokens()) {
                n2 = Integer.parseInt(stringTokenizer.nextToken());
            }
            if (stringTokenizer.hasMoreTokens()) {
                n3 = Integer.parseInt(stringTokenizer.nextToken());
            }
            if (stringTokenizer.hasMoreTokens()) {
                try {
                    n4 = Integer.parseInt(stringTokenizer.nextToken());
                }
                catch (Exception exception) {
                    n4 = 9999;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new VersionInfo(n, n2, n3, n4, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] doThreadTransaction(Object[] objectArray, boolean bl) throws TrackerException {
        Object[] objectArray2 = null;
        Tracker tracker = this;
        synchronized (tracker) {
            if (this.threadTransactionInProgress || null != this.exclusiveThread && Thread.currentThread() != this.exclusiveThread) {
                throw new InterfaceBusyException("Transaction is progress or exclusive access");
            }
            this.threadTransactionInProgress = true;
        }
        try {
            this.trackerMgr.SendCommand(objectArray);
            if (bl && (objectArray2 = this.trackerMgr.ReceiveResponse())[0] instanceof TrackerException) {
                throw (TrackerException)objectArray2[0];
            }
        }
        catch (IOException iOException) {
            throw new TrackerException("IO Exception doing thread transaction");
        }
        catch (InterruptedException interruptedException) {
            throw new TrackerException("Interrupted exception doing thread transaction");
        }
        finally {
            Tracker tracker2 = this;
            synchronized (tracker2) {
                this.threadTransactionInProgress = false;
                this.notifyAll();
            }
        }
        return objectArray2;
    }

    public synchronized void setExclusiveAccess() throws TrackerException {
        while (this.threadTransactionInProgress) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (null != this.exclusiveThread || this.trackerMgr.isBusy()) {
            throw new InterfaceBusyException("Other thread has exclusive access or command thread busy");
        }
        this.exclusiveThread = Thread.currentThread();
        Object[] objectArray = new Object[]{new Integer(38), new Boolean(true)};
        this.doThreadTransaction(objectArray, true);
    }

    public synchronized void clearExclusiveAccess() throws TrackerException {
        if (null != this.exclusiveThread && Thread.currentThread() != this.exclusiveThread) {
            throw new InterfaceBusyException("Another thread has exclusive access");
        }
        this.exclusiveThread = null;
        Object[] objectArray = new Object[]{new Integer(38), new Boolean(false)};
        this.doThreadTransaction(objectArray, true);
    }

    public synchronized boolean exclusiveAccessSet() {
        return null != this.exclusiveThread;
    }

    public synchronized boolean exclusiveAccessForCurrentThread() {
        return Thread.currentThread() == this.exclusiveThread;
    }

    public synchronized boolean busy() {
        return this.localBusy(null);
    }

    public synchronized boolean busyForCurrentThread() {
        return this.localBusy(Thread.currentThread());
    }

    public void connect(String string, String string2, String string3) throws TrackerException {
        if (null != string) {
            string = string.trim();
        }
        if (null != string2) {
            string2 = string2.trim();
        }
        if (null != string3) {
            string3 = string3.trim();
        }
        Object[] objectArray = new Object[]{new Integer(1), string, string2, string3};
        this.doThreadTransaction(objectArray, this.blockingFlag);
    }

    public void disconnect() throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(2)};
        this.doThreadTransaction(objectArray, this.blockingFlag);
    }

    public void initialize() throws TrackerException {
        this.initialize(true);
    }

    public void initialize(boolean bl) throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(0x10000003), new Boolean(bl)};
        this.doThreadTransaction(objectArray, this.blockingFlag);
    }

    public void initializeSmart() throws TrackerException {
        this.initializeSmart(true);
    }

    public void initializeSmart(boolean bl) throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(0x10000040), new Boolean(bl)};
        this.doThreadTransaction(objectArray, this.blockingFlag);
    }

    public void toggleSightOrientation() throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(0x10000004)};
        this.doThreadTransaction(objectArray, this.blockingFlag);
    }

    public void move(double d, double d2, double d3, boolean bl) throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(0x10000005), new Double(d), new Double(d2), new Double(d3), new Boolean(bl)};
        this.doThreadTransaction(objectArray, this.blockingFlag);
    }

    public void move(double d, double d2, double d3, boolean bl, boolean bl2) throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(0x10000005), new Double(d), new Double(d2), new Double(d3), new Boolean(bl), new Boolean(bl2)};
        this.doThreadTransaction(objectArray, this.blockingFlag);
    }

    public void home(boolean bl) throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(0x10000006), new Boolean(bl)};
        this.doThreadTransaction(objectArray, this.blockingFlag);
    }

    public void search(double d, int n) throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(0x1000000C), new Double(d), new Integer(n)};
        this.doThreadTransaction(objectArray, this.blockingFlag);
    }

    public void search(double d, double d2, int n) throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(0x1000000C), new Double(d), new Double(d2), new Integer(n)};
        this.doThreadTransaction(objectArray, this.blockingFlag);
    }

    public void search(double d, double d2) throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(0x1000000C), new Double(d), new Double(d2)};
        this.doThreadTransaction(objectArray, this.blockingFlag);
    }

    public void search(double d) throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(0x1000000C), new Double(d)};
        this.doThreadTransaction(objectArray, this.blockingFlag);
    }

    public void changeMotorState(boolean bl) throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(19), new Boolean(bl)};
        this.doThreadTransaction(objectArray, true);
    }

    public void changeTrackingState(boolean bl) throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(20), new Boolean(bl)};
        this.doThreadTransaction(objectArray, true);
    }

    public void changeDistanceMeasureMode(DistanceMode distanceMode) throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(21), distanceMode};
        this.doThreadTransaction(objectArray, true);
    }

    public void changeTargetType(TargetType targetType) throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(22), targetType};
        this.doThreadTransaction(objectArray, true);
    }

    public void abort() {
        this.trackerMgr.abort();
    }

    public int sampleRate() throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(56)};
        Object[] objectArray2 = this.doThreadTransaction(objectArray, true);
        return (Integer)objectArray2[0];
    }

    public void startMeasurePoint(MeasureCfg measureCfg) throws TrackerException {
        if (this.trackerMgr.measureInProgress()) {
            throw new InterfaceBusyException("Measurement in progress");
        }
        Object[] objectArray = new Object[]{new Integer(10), new Integer(1), new Integer(this.measureEventRate), measureCfg};
        this.doThreadTransaction(objectArray, this.blockingFlag);
    }

    public void stopMeasurePoint() throws TrackerException {
        if (!this.trackerMgr.measureInProgress()) {
            return;
        }
        if (!this.trackerMgr.measureInProgress(1)) {
            throw new MeasureTypeException();
        }
        Object[] objectArray = new Object[]{new Integer(11), new Integer(1)};
        this.doThreadTransaction(objectArray, this.blockingFlag);
    }

    public MeasurePointData[] readMeasurePointData(int n) throws TrackerException {
        MeasurePointData[] measurePointDataArray = null;
        if (!this.trackerMgr.measureInProgress(1) || !this.blockingFlag && this.trackerMgr.measureRecordsAvailable() < n) {
            throw new NoDataAvailableException();
        }
        try {
            measurePointDataArray = this.trackerMgr.readMeasurePointData(n);
        }
        catch (IOException iOException) {
            throw new NoDataAvailableException();
        }
        return measurePointDataArray;
    }

    public boolean measureInProgress() throws TrackerException {
        return this.trackerMgr.measureInProgress();
    }

    public MeasurePointData readMeasurePointData() throws TrackerException {
        MeasurePointData[] measurePointDataArray = null;
        measurePointDataArray = this.readMeasurePointData(1);
        return measurePointDataArray[0];
    }

    public void startBkndMeasurePoint(MeasureCfg measureCfg) throws TrackerException {
        if (this.trackerMgr.bkndMeasureInProgress()) {
            throw new InterfaceBusyException("Background measurement in progress");
        }
        Object[] objectArray = new Object[]{new Integer(13), new Integer(1), new Integer(this.bkndMeasureEventRate), measureCfg};
        this.doThreadTransaction(objectArray, this.blockingFlag);
    }

    public void stopBkndMeasurePoint() throws TrackerException {
        if (!this.trackerMgr.bkndMeasureInProgress()) {
            return;
        }
        if (!this.trackerMgr.bkndMeasureInProgress(1)) {
            throw new MeasureTypeException();
        }
        Object[] objectArray = new Object[]{new Integer(14), new Integer(1)};
        this.doThreadTransaction(objectArray, this.blockingFlag);
    }

    public MeasurePointData[] readBkndMeasurePointData(int n) throws TrackerException {
        MeasurePointData[] measurePointDataArray = null;
        if (!this.trackerMgr.bkndMeasureInProgress(1) || !this.bkndMeasureBlockingFlag && this.trackerMgr.bkndMeasureRecordsAvailable() < n) {
            throw new NoDataAvailableException();
        }
        try {
            measurePointDataArray = this.trackerMgr.readBkndMeasurePointData(n);
        }
        catch (IOException iOException) {
            throw new NoDataAvailableException();
        }
        return measurePointDataArray;
    }

    public MeasurePointData readBkndMeasurePointData() throws TrackerException {
        MeasurePointData[] measurePointDataArray = null;
        measurePointDataArray = this.readBkndMeasurePointData(1);
        return measurePointDataArray[0];
    }

    public boolean bkndMeasureInProgress() throws TrackerException {
        return this.trackerMgr.bkndMeasureInProgress();
    }

    public void startAsync() throws TrackerException {
        if (this.trackerMgr.asyncRunning()) {
            throw new AsyncAlreadyStartedException();
        }
        Object[] objectArray = new Object[]{new Integer(15)};
        this.doThreadTransaction(objectArray, true);
    }

    public void stopAsync() throws TrackerException {
        if (!this.trackerMgr.asyncRunning()) {
            return;
        }
        Object[] objectArray = new Object[]{new Integer(16)};
        this.doThreadTransaction(objectArray, true);
    }

    public boolean asyncStarted() throws TrackerException {
        return this.trackerMgr.asyncRunning();
    }

    public Diagnostic[] diagnosticHistory() throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(35)};
        Object[] objectArray2 = this.doThreadTransaction(objectArray, this.blockingFlag);
        if (null != objectArray2) {
            return (Diagnostic[])objectArray2[0];
        }
        return null;
    }

    public Diagnostic[] readBufferedDiagnosticHistory() throws TrackerException {
        Object[] objectArray;
        try {
            objectArray = this.trackerMgr.ReceiveSpecificResponse(35);
            if (null == objectArray || objectArray[0] instanceof Exception) {
                throw new NoDataAvailableException();
            }
        }
        catch (IOException iOException) {
            throw new TrackerException("IO Exception reading diagnostic history");
        }
        return (Diagnostic[])objectArray[0];
    }

    public Status[] statusHistory() throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(37)};
        Object[] objectArray2 = this.doThreadTransaction(objectArray, this.blockingFlag);
        if (null != objectArray2) {
            return (Status[])objectArray2[0];
        }
        return null;
    }

    public Status[] readBufferedStatusHistory() throws TrackerException {
        Object[] objectArray;
        try {
            objectArray = this.trackerMgr.ReceiveSpecificResponse(37);
            if (null == objectArray || objectArray[0] instanceof Exception) {
                throw new NoDataAvailableException();
            }
        }
        catch (IOException iOException) {
            throw new TrackerException("IO Exception reading status history");
        }
        return (Status[])objectArray[0];
    }

    public Alarm[] alarmHistory() throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(36)};
        Object[] objectArray2 = this.doThreadTransaction(objectArray, this.blockingFlag);
        if (null != objectArray2) {
            return (Alarm[])objectArray2[0];
        }
        return null;
    }

    public Alarm[] readBufferedAlarmHistory() throws TrackerException {
        Object[] objectArray;
        try {
            objectArray = this.trackerMgr.ReceiveSpecificResponse(36);
            if (null == objectArray || objectArray[0] instanceof Exception) {
                throw new NoDataAvailableException();
            }
        }
        catch (IOException iOException) {
            throw new TrackerException("IO Exception reading alarm history");
        }
        return (Alarm[])objectArray[0];
    }

    public boolean connected() throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(24)};
        Object[] objectArray2 = this.doThreadTransaction(objectArray, true);
        if (null != objectArray2) {
            return (Boolean)objectArray2[0];
        }
        throw new NoDataAvailableException();
    }

    public boolean targetPresent() throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(25)};
        Object[] objectArray2 = this.doThreadTransaction(objectArray, true);
        if (null != objectArray2) {
            return (Boolean)objectArray2[0];
        }
        throw new NoDataAvailableException();
    }

    public boolean targetLocationValid() throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(26)};
        Object[] objectArray2 = this.doThreadTransaction(objectArray, true);
        if (null != objectArray2) {
            return (Boolean)objectArray2[0];
        }
        throw new NoDataAvailableException();
    }

    public boolean motorsOn() throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(27)};
        Object[] objectArray2 = this.doThreadTransaction(objectArray, true);
        if (null != objectArray2) {
            return (Boolean)objectArray2[0];
        }
        throw new NoDataAvailableException();
    }

    public boolean initialized() throws TrackerException {
        return this.initialized(true);
    }

    public boolean initialized(boolean bl) throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(52), new Boolean(bl)};
        Object[] objectArray2 = this.doThreadTransaction(objectArray, true);
        if (null != objectArray2) {
            return (Boolean)objectArray2[0];
        }
        throw new NoDataAvailableException();
    }

    public boolean trackingOn() throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(28)};
        Object[] objectArray2 = this.doThreadTransaction(objectArray, true);
        if (null != objectArray2) {
            return (Boolean)objectArray2[0];
        }
        throw new NoDataAvailableException();
    }

    public boolean admCapable() throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(29)};
        Object[] objectArray2 = this.doThreadTransaction(objectArray, true);
        if (null != objectArray2) {
            return (Boolean)objectArray2[0];
        }
        throw new NoDataAvailableException();
    }

    public boolean admOnlyCapable() {
        return this.trackerIntf.admOnlyCapable();
    }

    public boolean interferometerCapable() throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(30)};
        Object[] objectArray2 = this.doThreadTransaction(objectArray, true);
        if (null != objectArray2) {
            return (Boolean)objectArray2[0];
        }
        throw new NoDataAvailableException();
    }

    public boolean levelCapable() throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(51)};
        Object[] objectArray2 = this.doThreadTransaction(objectArray, true);
        if (null != objectArray2) {
            return (Boolean)objectArray2[0];
        }
        throw new NoDataAvailableException();
    }

    public DistanceMode distanceMeasureMode() throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(39)};
        Object[] objectArray2 = this.doThreadTransaction(objectArray, true);
        if (null != objectArray2) {
            return (DistanceMode)objectArray2[0];
        }
        throw new NoDataAvailableException();
    }

    public TargetType targetType() throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(40)};
        Object[] objectArray2 = this.doThreadTransaction(objectArray, true);
        if (null != objectArray2) {
            return (TargetType)objectArray2[0];
        }
        throw new NoDataAvailableException();
    }

    public boolean backsightOrientation() throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(50)};
        Object[] objectArray2 = this.doThreadTransaction(objectArray, true);
        if (null != objectArray2) {
            return (Boolean)objectArray2[0];
        }
        throw new NoDataAvailableException();
    }

    public LevelData measureLevel() throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(0x10000011)};
        Object[] objectArray2 = this.doThreadTransaction(objectArray, this.blockingFlag);
        if (null != objectArray2) {
            return (LevelData)objectArray2[0];
        }
        return null;
    }

    public LevelData readBufferedLevel() throws TrackerException {
        Object[] objectArray;
        try {
            objectArray = this.trackerMgr.ReceiveSpecificResponse(0x10000011);
            if (null == objectArray || objectArray[0] instanceof Exception) {
                throw new NoDataAvailableException();
            }
        }
        catch (IOException iOException) {
            throw new TrackerException("IO Exception reading buffered level data");
        }
        return (LevelData)objectArray[0];
    }

    public MaterialTemperatureData measureMaterialTemperature() throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(18)};
        Object[] objectArray2 = this.doThreadTransaction(objectArray, this.blockingFlag);
        if (null != objectArray2) {
            return (MaterialTemperatureData)objectArray2[0];
        }
        return null;
    }

    public MaterialTemperatureData readBufferedMaterialTemperature() throws TrackerException {
        Object[] objectArray;
        try {
            objectArray = this.trackerMgr.ReceiveSpecificResponse(18);
            if (null == objectArray || objectArray[0] instanceof Exception) {
                throw new NoDataAvailableException();
            }
        }
        catch (IOException iOException) {
            throw new TrackerException("IO Exception reading buffered material temperature.");
        }
        return (MaterialTemperatureData)objectArray[0];
    }

    public String[] availableApplications() throws TrackerException {
        return this.trackerMgr.availableApplications();
    }

    public void startApplicationFrame(String string, String string2) throws TrackerException {
        this.startApplicationFrame(string, string2, false, this.blockingFlag);
    }

    public void startApplicationFrameAlwaysOnTop(String string, String string2) throws TrackerException {
        this.startApplicationFrame(string, string2, true, this.blockingFlag);
    }

    private void startApplicationFrame(String string, String string2, boolean bl, boolean bl2) throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(23), string, string2, this, new Boolean(bl)};
        Object[] objectArray2 = this.doThreadTransaction(objectArray, bl2);
        if (bl2 && null != objectArray2) {
            if (string.equalsIgnoreCase("compit") && (string2.equalsIgnoreCase("-a SELF_COMP_NO_UI -fselfcomp= , continue_on") || string2.startsWith("-a QUICK_COMP_NO_UI -fquickcomp= , continue_on") || string2.startsWith("-a AAC_NO_UI -faac= , continue_on"))) {
                this.trackerApp = (TrackerApp)objectArray2[0];
                this.startingTimeForNoUIComp = System.currentTimeMillis() / 1000L;
            } else {
                this.trackerApp = null;
            }
            this.trackerMgr.waitUntilApplicationStable((TrackerApp)objectArray2[0]);
        }
    }

    public void startApplication(String string, String string2, JFrame jFrame, JComponent jComponent, int n) throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(23), string, string2, this, jFrame, jComponent, new Integer(n)};
        Object[] objectArray2 = this.doThreadTransaction(objectArray, this.blockingFlag);
        if (this.blockingFlag && null != objectArray2) {
            this.trackerMgr.waitUntilApplicationStable((TrackerApp)objectArray2[0]);
        }
    }

    public void modifyApplication(String string, String string2) throws TrackerException {
        this.trackerMgr.modifyApplication(string, string2);
    }

    public void stopApplicationFrame(String string) throws TrackerException {
        this.stopApplication(string);
    }

    public void stopApplication(String string) throws TrackerException {
        this.stopApplication(string, true);
    }

    public String[] startedApplications() throws TrackerException {
        return this.trackerMgr.startedApplications();
    }

    public void addCommandCompleteListener(CommandCompleteListener commandCompleteListener) {
        this.trackerMgr.addCommandCompleteListener(commandCompleteListener);
    }

    public void removeCommandCompleteListener(CommandCompleteListener commandCompleteListener) {
        this.trackerMgr.removeCommandCompleteListener(commandCompleteListener);
    }

    public void addConnectListener(ConnectListener connectListener) {
        this.trackerMgr.addConnectListener(connectListener);
    }

    public void removeConnectListener(ConnectListener connectListener) {
        this.trackerMgr.removeConnectListener(connectListener);
    }

    public synchronized void addMeasureDataListener(MeasureDataListener measureDataListener) {
        this.trackerMgr.addMeasureDataListener(measureDataListener);
    }

    public synchronized void removeMeasureDataListener(MeasureDataListener measureDataListener) {
        this.trackerMgr.removeMeasureDataListener(measureDataListener);
    }

    public synchronized void addBkndMeasureDataListener(BkndMeasureDataListener bkndMeasureDataListener) {
        this.trackerMgr.addBkndMeasureDataListener(bkndMeasureDataListener);
    }

    public synchronized void removeBkndMeasureDataListener(BkndMeasureDataListener bkndMeasureDataListener) {
        this.trackerMgr.removeBkndMeasureDataListener(bkndMeasureDataListener);
    }

    public synchronized void addFactoryBkndMeasureDataListener(FactoryBkndMeasureDataListener factoryBkndMeasureDataListener) {
        this.trackerMgr.addFactoryBkndMeasureDataListener(factoryBkndMeasureDataListener);
    }

    public synchronized void removeFactoryBkndMeasureDataListener(FactoryBkndMeasureDataListener factoryBkndMeasureDataListener) {
        this.trackerMgr.removeFactoryBkndMeasureDataListener(factoryBkndMeasureDataListener);
    }

    public synchronized void addDiagnosticListener(DiagnosticListener diagnosticListener) {
        this.trackerMgr.addDiagnosticListener(diagnosticListener);
    }

    public synchronized void removeDiagnosticListener(DiagnosticListener diagnosticListener) {
        this.trackerMgr.removeDiagnosticListener(diagnosticListener);
    }

    public synchronized void addStatusListener(StatusListener statusListener) {
        this.trackerMgr.addStatusListener(statusListener);
    }

    public synchronized void removeStatusListener(StatusListener statusListener) {
        this.trackerMgr.removeStatusListener(statusListener);
    }

    public synchronized void addAlarmListener(AlarmListener alarmListener) {
        this.trackerMgr.addAlarmListener(alarmListener);
    }

    public synchronized void removeAlarmListener(AlarmListener alarmListener) {
        this.trackerMgr.removeAlarmListener(alarmListener);
    }

    public synchronized void addChangeListener(ChangeListener changeListener) {
        this.trackerMgr.addChangeListener(changeListener);
    }

    public synchronized void removeChangeListener(ChangeListener changeListener) {
        this.trackerMgr.removeChangeListener(changeListener);
    }

    public synchronized void addBusyListener(BusyListener busyListener) {
        this.trackerMgr.addBusyListener(busyListener);
    }

    public synchronized void removeBusyListener(BusyListener busyListener) {
        this.trackerMgr.removeBusyListener(busyListener);
    }

    public synchronized void addApplicationListener(ApplicationListener applicationListener) {
        this.trackerMgr.addApplicationListener(applicationListener);
    }

    public synchronized void removeApplicationListener(ApplicationListener applicationListener) {
        this.trackerMgr.removeApplicationListener(applicationListener);
    }

    public void command(String string, int n) throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(0x10000009), string, new Integer(n)};
        this.doThreadTransaction(objectArray, this.blockingFlag);
    }

    public void writeOneTimeData(DataTag[] dataTagArray, Object[] objectArray) throws TrackerException {
        if (dataTagArray.length != objectArray.length) {
            throw new IllegalArgumentException("Tag list and data list must be same size.");
        }
        Object[] objectArray2 = new Object[]{new Integer(7), dataTagArray, objectArray};
        this.doThreadTransaction(objectArray2, this.blockingFlag);
    }

    public Object[] readOneTimeData(DataTag[] dataTagArray) throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(8), dataTagArray};
        Object[] objectArray2 = this.doThreadTransaction(objectArray, this.blockingFlag);
        if (null != objectArray2) {
            return (Object[])objectArray2[0];
        }
        return null;
    }

    public Object[] readBufferedOneTimeData(DataTag[] dataTagArray) throws TrackerException {
        Object[] objectArray;
        try {
            objectArray = this.trackerMgr.ReceiveSpecificResponse(8);
            if (null == objectArray || objectArray[0] instanceof Exception) {
                throw new NoDataAvailableException();
            }
        }
        catch (IOException iOException) {
            throw new TrackerException("IO Exception reading buffered one time  data");
        }
        return (Object[])objectArray[0];
    }

    public void startMeasure(MeasureCfg measureCfg, DataTag[] dataTagArray) throws TrackerException {
        if (this.trackerMgr.measureInProgress()) {
            throw new InterfaceBusyException("Measurement in progress");
        }
        Object[] objectArray = new Object[]{new Integer(10), new Integer(0), new Integer(this.measureEventRate), measureCfg, dataTagArray};
        this.doThreadTransaction(objectArray, this.blockingFlag);
    }

    public void stopMeasure() throws TrackerException {
        if (!this.trackerMgr.measureInProgress()) {
            return;
        }
        if (!this.trackerMgr.measureInProgress(0)) {
            throw new MeasureTypeException();
        }
        Object[] objectArray = new Object[]{new Integer(11), new Integer(0)};
        this.doThreadTransaction(objectArray, this.blockingFlag);
    }

    public MeasureData[] readMeasureData(int n) throws TrackerException {
        MeasureData[] measureDataArray = null;
        if (!this.trackerMgr.measureInProgress() || !this.blockingFlag && this.trackerMgr.measureRecordsAvailable() < n) {
            throw new NoDataAvailableException();
        }
        try {
            measureDataArray = this.trackerMgr.readMeasureData(n);
        }
        catch (IOException iOException) {
            throw new NoDataAvailableException();
        }
        return measureDataArray;
    }

    public void startBkndMeasure(MeasureCfg measureCfg, DataTag[] dataTagArray) throws TrackerException {
        if (this.trackerMgr.bkndMeasureInProgress()) {
            throw new InterfaceBusyException("Background measurement in progress");
        }
        Object[] objectArray = new Object[]{new Integer(13), new Integer(0), new Integer(this.bkndMeasureEventRate), measureCfg, dataTagArray};
        this.doThreadTransaction(objectArray, this.blockingFlag);
    }

    public void stopBkndMeasure() throws TrackerException {
        if (!this.trackerMgr.bkndMeasureInProgress()) {
            return;
        }
        if (!this.trackerMgr.bkndMeasureInProgress(0)) {
            throw new MeasureTypeException();
        }
        Object[] objectArray = new Object[]{new Integer(14), new Integer(0)};
        this.doThreadTransaction(objectArray, this.blockingFlag);
    }

    public MeasureData[] readBkndMeasureData(int n) throws TrackerException {
        MeasureData[] measureDataArray = null;
        if (!this.trackerMgr.bkndMeasureInProgress(0) || !this.bkndMeasureBlockingFlag && this.trackerMgr.bkndMeasureRecordsAvailable() < n) {
            throw new NoDataAvailableException();
        }
        try {
            measureDataArray = this.trackerMgr.readBkndMeasureData(n);
        }
        catch (IOException iOException) {
            throw new NoDataAvailableException();
        }
        return measureDataArray;
    }

    public void startFactoryBkndMeasurePoint(MeasureCfg measureCfg) throws TrackerException {
        if (this.trackerMgr.factoryBkndMeasureInProgress()) {
            throw new InterfaceBusyException("Factory background measurement in progress");
        }
        Object[] objectArray = new Object[]{new Integer(62), new Integer(1), new Integer(this.factoryBkndMeasureEventRate), measureCfg};
        this.doThreadTransaction(objectArray, this.blockingFlag);
    }

    public void stopFactoryBkndMeasurePoint() throws TrackerException {
        if (!this.trackerMgr.factoryBkndMeasureInProgress()) {
            return;
        }
        if (!this.trackerMgr.factoryBkndMeasureInProgress(1)) {
            throw new MeasureTypeException();
        }
        Object[] objectArray = new Object[]{new Integer(63), new Integer(1)};
        this.doThreadTransaction(objectArray, this.blockingFlag);
    }

    public MeasurePointData[] readFactoryBkndMeasurePointData(int n) throws TrackerException {
        MeasurePointData[] measurePointDataArray = null;
        if (!this.trackerMgr.factoryBkndMeasureInProgress(1) || !this.factoryBkndMeasureBlockingFlag && this.trackerMgr.factoryBkndMeasureRecordsAvailable() < n) {
            throw new NoDataAvailableException();
        }
        try {
            measurePointDataArray = this.trackerMgr.readFactoryBkndMeasurePointData(n);
        }
        catch (IOException iOException) {
            throw new NoDataAvailableException();
        }
        return measurePointDataArray;
    }

    public MeasurePointData readFactoryBkndMeasurePointData() throws TrackerException {
        MeasurePointData[] measurePointDataArray = null;
        measurePointDataArray = this.readFactoryBkndMeasurePointData(1);
        return measurePointDataArray[0];
    }

    public boolean factoryBkndMeasureInProgress() throws TrackerException {
        return this.trackerMgr.factoryBkndMeasureInProgress();
    }

    public void startFactoryBkndMeasure(MeasureCfg measureCfg, DataTag[] dataTagArray) throws TrackerException {
        if (this.trackerMgr.factoryBkndMeasureInProgress()) {
            throw new InterfaceBusyException("Factory background measurement in progress");
        }
        Object[] objectArray = new Object[]{new Integer(62), new Integer(0), new Integer(this.factoryBkndMeasureEventRate), measureCfg, dataTagArray};
        this.doThreadTransaction(objectArray, this.blockingFlag);
    }

    public void stopFactoryBkndMeasure() throws TrackerException {
        if (!this.trackerMgr.factoryBkndMeasureInProgress()) {
            return;
        }
        if (!this.trackerMgr.factoryBkndMeasureInProgress(0)) {
            throw new MeasureTypeException();
        }
        Object[] objectArray = new Object[]{new Integer(63), new Integer(0)};
        this.doThreadTransaction(objectArray, this.blockingFlag);
    }

    public MeasureData[] readFactoryBkndMeasureData(int n) throws TrackerException {
        MeasureData[] measureDataArray = null;
        if (!this.trackerMgr.factoryBkndMeasureInProgress(0) || !this.factoryBkndMeasureBlockingFlag && this.trackerMgr.factoryBkndMeasureRecordsAvailable() < n) {
            throw new NoDataAvailableException();
        }
        try {
            measureDataArray = this.trackerMgr.readFactoryBkndMeasureData(n);
        }
        catch (IOException iOException) {
            throw new NoDataAvailableException();
        }
        return measureDataArray;
    }

    public void writeFile(String string, String string2) throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(0x1000001F), string, string2};
        this.doThreadTransaction(objectArray, this.blockingFlag);
    }

    public void readFile(String string, String string2) throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(0x10000020), string, string2};
        this.doThreadTransaction(objectArray, this.blockingFlag);
    }

    public void changeAlarmCfg(int n, AlarmType alarmType) throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(33), new Integer(n), alarmType};
        this.doThreadTransaction(objectArray, true);
    }

    public AlarmType alarmCfg(int n) throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(34), new Integer(n)};
        Object[] objectArray2 = this.doThreadTransaction(objectArray, true);
        if (null != objectArray2) {
            return (AlarmType)objectArray2[0];
        }
        return null;
    }

    public int numExternalTempSensors() throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(61)};
        Object[] objectArray2 = this.doThreadTransaction(objectArray, true);
        if (null != objectArray2) {
            return (Integer)objectArray2[0];
        }
        return 0;
    }

    public ExtTempType externalTempType(int n) throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(53), new Integer(n)};
        Object[] objectArray2 = this.doThreadTransaction(objectArray, true);
        if (null != objectArray2) {
            return (ExtTempType)objectArray2[0];
        }
        return null;
    }

    public void changeExternalTempType(int n, ExtTempType extTempType) throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(54), new Integer(n), extTempType};
        this.doThreadTransaction(objectArray, true);
    }

    public boolean externalTempTypeChangeable() throws TrackerException {
        Object[] objectArray = new Object[3];
        objectArray[0] = new Integer(55);
        Object[] objectArray2 = this.doThreadTransaction(objectArray, true);
        if (null != objectArray2) {
            return (Boolean)objectArray2[0];
        }
        throw new NoDataAvailableException();
    }

    public double measureExternalTempSensor(int n) throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(60), new Integer(n)};
        Object[] objectArray2 = this.doThreadTransaction(objectArray, this.blockingFlag);
        if (null != objectArray2) {
            return (Double)objectArray2[0];
        }
        return 0.0;
    }

    public double readBufferedExternalTempSensor() throws TrackerException {
        Object[] objectArray;
        try {
            objectArray = this.trackerMgr.ReceiveSpecificResponse(60);
            if (null == objectArray || objectArray[0] instanceof Exception) {
                throw new NoDataAvailableException();
            }
        }
        catch (IOException iOException) {
            throw new TrackerException("IO Exception reading buffered external temp sensor.");
        }
        return (Double)objectArray[0];
    }

    public boolean standardPrivilege() throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(57)};
        Object[] objectArray2 = this.doThreadTransaction(objectArray, true);
        if (null != objectArray2) {
            return (Boolean)objectArray2[0];
        }
        throw new NoDataAvailableException();
    }

    public boolean adminPrivilege() throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(58)};
        Object[] objectArray2 = this.doThreadTransaction(objectArray, true);
        if (null != objectArray2) {
            return (Boolean)objectArray2[0];
        }
        throw new NoDataAvailableException();
    }

    public boolean factoryPrivilege() throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(59)};
        Object[] objectArray2 = this.doThreadTransaction(objectArray, true);
        if (null != objectArray2) {
            return (Boolean)objectArray2[0];
        }
        throw new NoDataAvailableException();
    }

    public void readFileAbort() {
        this.trackerMgr.readFileAbort();
    }

    public void writeFileAbort() {
        this.trackerMgr.writeFileAbort();
    }

    public boolean admScanCapable() throws TrackerException {
        return this.trackerIntf.admScanCapable();
    }

    public TargetType[] availableTargetType() throws TrackerException {
        return this.trackerIntf.availableTargetType();
    }

    public WeatherInformation getWeatherInfo() throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(85)};
        Object[] objectArray2 = this.doThreadTransaction(objectArray, true);
        if (null != objectArray2) {
            return (WeatherInformation)objectArray2[0];
        }
        return null;
    }

    public String getSerialNumber() throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(84)};
        Object[] objectArray2 = this.doThreadTransaction(objectArray, true);
        if (null != objectArray2) {
            return (String)objectArray2[0];
        }
        return null;
    }

    public String getIPAddress() throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(132)};
        Object[] objectArray2 = this.doThreadTransaction(objectArray, true);
        if (null != objectArray2) {
            return (String)objectArray2[0];
        }
        return null;
    }

    public boolean readyToInitialize(boolean bl) throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(87), new Boolean(bl)};
        Object[] objectArray2 = this.doThreadTransaction(objectArray, true);
        if (null != objectArray2) {
            return (Boolean)objectArray2[0];
        }
        throw new NoDataAvailableException();
    }

    public void factoryConnect(String string, String string2, String string3) throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(65), string, string2, string3};
        this.doThreadTransaction(objectArray, this.blockingFlag);
    }

    public void factoryDisconnect() throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(66)};
        this.doThreadTransaction(objectArray, this.blockingFlag);
    }

    public void stopApplication(String string, boolean bl) throws TrackerException {
        this.trackerMgr.stopApplication(string, bl);
    }

    public void stopApplicationFrame(String string, boolean bl) throws TrackerException {
        this.stopApplication(string, bl);
    }

    public int applicationExitCode(String string) throws TrackerException {
        return this.trackerIntf.applicationExitCode(string);
    }

    public void releaseLock() throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(88)};
        this.doThreadTransaction(objectArray, true);
    }

    public void startSlew(double d, double d2, double d3) throws TrackerException {
    }

    public void startSlew(double d, double d2) throws TrackerException {
    }

    public void stopSlew() throws TrackerException {
    }

    public int availableMeasurements() throws TrackerException {
        return this.trackerMgr.measureRecordsAvailable();
    }

    public void availableBkndMeasurements() throws TrackerException {
        this.trackerMgr.bkndMeasureRecordsAvailable();
    }

    public boolean isResultReportingCapable() throws TrackerException {
        return this.trackerIntf.isResultReportingCapable();
    }

    public boolean isAdaptiveFilterCapable() throws TrackerException {
        return this.trackerIntf.isAdaptiveFilterCapable();
    }

    public ApplicationResults applicationResults(String string) throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(82), new String(string)};
        Object[] objectArray2 = this.doThreadTransaction(objectArray, true);
        if (null != objectArray2) {
            return (ApplicationResults)objectArray2[0];
        }
        return null;
    }

    public boolean is_1_5_WindowedSMRTargetCapable() throws TrackerException {
        return this.trackerIntf.is_1_5_WindowedSMRTargetCapable();
    }

    public boolean is_7_8_WindowedSMRTargetCapable() throws TrackerException {
        return this.trackerIntf.is_7_8_WindowedSMRTargetCapable();
    }

    public MPEResultsData checkAngularAccuracyError(SimplePointPairData simplePointPairData) throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(81), simplePointPairData};
        Object[] objectArray2 = this.doThreadTransaction(objectArray, true);
        if (null != objectArray2) {
            return (MPEResultsData)objectArray2[0];
        }
        return null;
    }

    public MPEResultsData checkADMAgainstIFM(SimplePointPairData simplePointPairData) throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(83), simplePointPairData};
        Object[] objectArray2 = this.doThreadTransaction(objectArray, true);
        if (null != objectArray2) {
            return (MPEResultsData)objectArray2[0];
        }
        return null;
    }

    public void runNoUISelfCompensation() throws TrackerException {
        if (!(this.trackerIntf instanceof TrackerKeystone) || !this.isSelfCompensationNoUICapable()) {
            throw new UnsupportedFeatureException("Feature not supported");
        }
        this.startApplicationFrame("CompIT", "-a SELF_COMP_NO_UI -fselfcomp= , continue_on", false, true);
        this.noUIAppParams = "-a SELF_COMP_NO_UI -fselfcomp= , continue_on";
    }

    public boolean abortNoUISelfCompensation() throws TrackerException {
        if (null != this.noUIAppParams && this.noUIAppParams.toLowerCase(Locale.ENGLISH).startsWith("-a SELF_COMP_NO_UI -fselfcomp= , continue_on".toLowerCase(Locale.ENGLISH))) {
            return this.abortNoUIComp();
        }
        return false;
    }

    public boolean isSelfCompensationNoUICapable() throws TrackerException {
        return this.trackerIntf.isSelfCompensationNoUICapable();
    }

    public void changeAirTemperatureToHardware() throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(67)};
        this.doThreadTransaction(objectArray, true);
    }

    public void changeAirPressureToHardware() throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(68)};
        this.doThreadTransaction(objectArray, true);
    }

    public void changeHumidityToHardware() throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(69)};
        this.doThreadTransaction(objectArray, true);
    }

    public void changeAirTemperatureToManual(double d) throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(70), new Double(d)};
        this.doThreadTransaction(objectArray, true);
    }

    public void changeAirPressureToManual(double d) throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(71), new Double(d)};
        this.doThreadTransaction(objectArray, true);
    }

    public void changeHumidityToManual(double d) throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(72), new Double(d)};
        this.doThreadTransaction(objectArray, true);
    }

    public void changeLedState(int n, int n2) throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(86), new Integer(n), new Integer(n2)};
        this.doThreadTransaction(objectArray, true);
    }

    public VideoData[] readVideoData() throws TrackerException {
        VideoData[] videoDataArray = null;
        if (!this.trackerMgr.videoInProgress() || !this.blockingFlag && this.trackerMgr.videoRecordsAvailable() < 1) {
            throw new NoDataAvailableException();
        }
        try {
            videoDataArray = this.trackerMgr.readVideoData();
        }
        catch (IOException iOException) {
            throw new NoDataAvailableException();
        }
        return videoDataArray;
    }

    public void startVideo(VideoCfg videoCfg) throws TrackerException {
        if (this.trackerMgr.videoInProgress()) {
            throw new InterfaceBusyException("Video transmission already in progress");
        }
        Object[] objectArray = new Object[]{new Integer(73), videoCfg, new Integer[]{new Integer(0), new Integer(1)}};
        this.doThreadTransaction(objectArray, this.blockingFlag);
    }

    public void stopVideo() throws TrackerException {
        if (!this.trackerMgr.videoInProgress()) {
            return;
        }
        Object[] objectArray = new Object[]{new Integer(74)};
        this.doThreadTransaction(objectArray, this.blockingFlag);
    }

    public synchronized void addVideoDataListener(VideoDataListener videoDataListener) {
        this.trackerMgr.addVideoDataListener(videoDataListener);
    }

    public synchronized void removeVideoDataListener(VideoDataListener videoDataListener) {
        this.trackerMgr.removeVideoDataListener(videoDataListener);
    }

    public synchronized JarFile getJarFile(String string) throws TrackerException {
        if (this.trackerIntf instanceof TrackerCypher) {
            return ((TrackerCypher)this.trackerIntf).getJarFile(string);
        }
        if (this.trackerIntf instanceof TrackerVector) {
            return ((TrackerVector)this.trackerIntf).getJarFile(string);
        }
        throw new UnsupportedFeatureException("Feature only supported for Vantage trackers");
    }

    public void changeGestureState(boolean bl) throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(75), new Boolean(bl)};
        this.doThreadTransaction(objectArray, true);
    }

    public boolean gestureRecognitionOn() throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(76)};
        Object[] objectArray2 = this.doThreadTransaction(objectArray, true);
        if (null != objectArray2) {
            return (Boolean)objectArray2[0];
        }
        throw new NoDataAvailableException();
    }

    public boolean wirelessCapable() throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(77)};
        Object[] objectArray2 = this.doThreadTransaction(objectArray, true);
        if (null != objectArray2) {
            return (Boolean)objectArray2[0];
        }
        throw new NoDataAvailableException();
    }

    public boolean videoCapable() throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(78)};
        Object[] objectArray2 = this.doThreadTransaction(objectArray, true);
        if (null != objectArray2) {
            return (Boolean)objectArray2[0];
        }
        throw new NoDataAvailableException();
    }

    public boolean gesturesCapable() throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(79)};
        Object[] objectArray2 = this.doThreadTransaction(objectArray, true);
        if (null != objectArray2) {
            return (Boolean)objectArray2[0];
        }
        throw new NoDataAvailableException();
    }

    public void searchUsingCamera() throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(80)};
        this.doThreadTransaction(objectArray, this.blockingFlag);
    }

    public boolean abortNoUIQuickCompensation() throws TrackerException {
        if (null != this.noUIAppParams && this.noUIAppParams.toLowerCase(Locale.ENGLISH).startsWith("-a QUICK_COMP_NO_UI -fquickcomp= , continue_on".toLowerCase(Locale.ENGLISH))) {
            return this.abortNoUIComp();
        }
        return false;
    }

    public boolean isQuickCompensationNoUICapable() throws TrackerException {
        return this.trackerIntf.isQuickCompensationNoUICapable();
    }

    public void runNoUIQuickCompensation() throws TrackerException {
        if (!(this.trackerIntf instanceof TrackerVector) && !(this.trackerIntf instanceof TrackerCypher) || !this.isQuickCompensationNoUICapable()) {
            throw new UnsupportedFeatureException("Feature not supported");
        }
        this.startApplicationFrame("CompIT", "-a QUICK_COMP_NO_UI -fquickcomp= , continue_on", false, true);
        this.noUIAppParams = "-a QUICK_COMP_NO_UI -fquickcomp= , continue_on";
        this.waitForNoUIAppToClose();
    }

    public boolean abortNoUIAAC() throws TrackerException {
        if (null != this.noUIAppParams && this.noUIAppParams.toLowerCase(Locale.ENGLISH).startsWith("-a AAC_NO_UI -faac= , continue_on".toLowerCase(Locale.ENGLISH))) {
            return this.abortNoUIComp();
        }
        return false;
    }

    public boolean isAACNoUICapable() throws TrackerException {
        return this.trackerIntf.isAACNoUICapable();
    }

    public boolean isNoUIAACWithCompensationOptionSupported() throws TrackerException {
        return this.trackerIntf.isNoUICompCalCapable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void waitForNoUIAppToClose() {
        if (!this.blockingFlag) return;
        int[] nArray = this.trackerApp.appExitLock;
        synchronized (this.trackerApp.appExitLock) {
            if (0 != this.trackerApp.appExitLock[0]) return;
            try {
                this.trackerApp.appExitLock.wait();
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.trackerApp.appExitLock[0] = 0;
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void runNoUIAAC() throws TrackerException {
        if (!(this.trackerIntf instanceof TrackerVector) && !(this.trackerIntf instanceof TrackerCypher) || !this.isAACNoUICapable()) {
            throw new UnsupportedFeatureException("Feature not supported");
        }
        this.startApplicationFrame("CompIT", "-a AAC_NO_UI -faac= , continue_on", false, true);
        this.noUIAppParams = "-a AAC_NO_UI -faac= , continue_on";
        this.waitForNoUIAppToClose();
    }

    private double makeAnglePositive(double d) {
        while (!((d += Math.PI * 2) > 0.0)) {
        }
        return d;
    }

    private String parseNoUIPointsToString(double[][] dArray) {
        String string = null;
        if (null != dArray) {
            string = "";
            int n = dArray.length;
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < dArray[i].length - 1; ++j) {
                    string = string + dArray[i][j] + ", ";
                }
                string = string + dArray[i][dArray[i].length - 1] + ";";
            }
        }
        return string;
    }

    public void runNoUIAAC(String string) throws TrackerException {
        this.runNoUICompCal(string, false, true, false, false);
    }

    public void runNoUIAACWithCompensationOption(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws TrackerException {
        this.runNoUICompCal(string, bl, bl2, bl3, bl4);
    }

    private void runNoUICompCal(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws TrackerException {
        if (null == string || 0 == string.length()) {
            this.runNoUIAAC();
            return;
        }
        try {
            String[] stringArray = string.split(";");
            int n = stringArray.length;
            double[][] dArray = new double[n][7];
            for (int i = 0; i < n; ++i) {
                String[] stringArray2 = stringArray[i].split(",");
                double[] dArray2 = new double[]{Double.parseDouble(stringArray2[0].trim()), Double.parseDouble(stringArray2[1].trim()), Double.parseDouble(stringArray2[2].trim())};
                if (bl) {
                    this.pointCartToSphere(dArray2);
                }
                dArray[i][0] = dArray2[0];
                if (dArray[i][0] < 0.0) {
                    dArray[i][0] = this.makeAnglePositive(dArray[i][0]);
                }
                dArray[i][1] = dArray2[1];
                if (dArray[i][1] < 0.0) {
                    dArray[i][1] = this.makeAnglePositive(dArray[i][1]);
                }
                dArray[i][2] = dArray2[2];
                dArray[i][3] = -1.0;
                dArray[i][4] = -1.0;
                dArray[i][5] = 10.0;
                dArray[i][6] = 5.0E-6;
                if (5 == stringArray2.length) {
                    dArray[i][3] = Double.parseDouble(stringArray2[3].trim());
                    dArray[i][4] = Double.parseDouble(stringArray2[4].trim());
                    continue;
                }
                if (6 == stringArray2.length) {
                    dArray[i][3] = Double.parseDouble(stringArray2[3].trim());
                    dArray[i][4] = Double.parseDouble(stringArray2[4].trim());
                    dArray[i][5] = Double.parseDouble(stringArray2[5].trim());
                    continue;
                }
                if (7 != stringArray2.length) continue;
                dArray[i][3] = Double.parseDouble(stringArray2[3].trim());
                dArray[i][4] = Double.parseDouble(stringArray2[4].trim());
                dArray[i][5] = Double.parseDouble(stringArray2[5].trim());
                dArray[i][6] = Double.parseDouble(stringArray2[6].trim());
            }
            this.runNoUICompCal(dArray, bl2, bl3, bl4);
        }
        catch (NumberFormatException numberFormatException) {
            throw new TrackerException("Invalid data format.");
        }
    }

    private void runNoUICompCal(double[][] dArray, boolean bl, boolean bl2, boolean bl3) throws TrackerException {
        if ((this.trackerIntf instanceof TrackerVector || this.trackerIntf instanceof TrackerCypher) && this.isAACNoUICapable()) {
            if (bl2 && !this.isNoUIAACWithCompensationOptionSupported()) {
                throw new UnsupportedFeatureException("Feature not supported");
            }
            String string = this.parseNoUIPointsToString(dArray);
            if (null != string && string.length() > 0) {
                int n = bl ? 1 : 0;
                int n2 = bl2 ? 1 : 0;
                int n3 = bl2 && bl3 ? 1 : 0;
                this.noUIAppParams = "-a AAC_NO_UI -faac= , continue_on-UserPoints " + string + "@" + n + "," + n2 + "," + n3;
            }
        } else {
            throw new UnsupportedFeatureException("Feature not supported");
        }
        this.startApplicationFrame("CompIT", this.noUIAppParams, false, true);
        this.waitForNoUIAppToClose();
    }

    private boolean abortNoUIComp() throws TrackerException {
        if (null != this.trackerApp) {
            long l = 10L;
            long l2 = System.currentTimeMillis() / 1000L;
            long l3 = l - (l2 - this.startingTimeForNoUIComp);
            if (l3 > 0L) {
                try {
                    Thread.sleep(l3 * 1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.trackerApp.abortApp();
            return true;
        }
        throw new UnsupportedFeatureException("Feature not supported");
    }

    private static void checkAndAddMatchingTrackerToList(Vector<Object[]> vector, String string, String string2) {
        for (int i = 0; i < vector.size(); ++i) {
            String string3;
            Object[] objectArray = vector.get(i);
            if (null == objectArray || !string2.equalsIgnoreCase(string3 = (String)objectArray[1])) continue;
            return;
        }
        vector.add(new Object[]{string, string2});
    }

    private static Object[] getTrackerIPAddressFromSerialNumber(String string) throws TrackerException {
        Vector<InetAddress> vector = null;
        try {
            vector = Tracker.getNICsHostAddresses();
        }
        catch (SocketException socketException) {
            throw new InternalTrackerException("Failed to obtain NIC addresses.");
        }
        if (vector.size() == 0) {
            throw new InternalTrackerException("Failed to obtain NIC addresses.");
        }
        Object[] objectArray = Tracker.getTrackerIPAddressFromSerialNumber(string, vector, 300);
        if (null == objectArray) {
            objectArray = Tracker.getTrackerIPAddressFromSerialNumber(string, vector, 3000);
        }
        return objectArray;
    }

    private static Object[] getTrackerIPAddressFromSerialNumber(String string, Vector<InetAddress> vector, int n) throws InternalTrackerException, TrackerException, NumberFormatException {
        Object[] objectArray = null;
        int n2 = 54000;
        String string2 = "TrackerV2 network command all get wlan0";
        String string3 = NEW_GROUP;
        objectArray = Tracker.getTrackerIPAddressFromSerialNumber(string, vector, n2, string2, string3, n, true);
        if (objectArray == null) {
            string2 = "TrackerV2 network command all get eth1";
            objectArray = Tracker.getTrackerIPAddressFromSerialNumber(string, vector, n2, string2, string3, n, false);
        }
        if (objectArray == null) {
            n2 = 4000;
            string2 = "Tracker IP Address Identification";
            string3 = OLD_GROUP;
            objectArray = Tracker.getTrackerIPAddressFromSerialNumber(string, vector, n2, string2, string3, n, false);
        }
        return objectArray;
    }

    private static Object[] getTrackerIPAddressFromSerialNumber(String string, Vector<InetAddress> vector, int n, String string2, String string3, int n2, boolean bl) throws InternalTrackerException, TrackerException {
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(string3);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        Object[] objectArray = Tracker.getTrackerIPAddressFromSerialNumber(string, n, inetAddress, string2, vector, n2, bl);
        return objectArray;
    }

    private static Object[] getTrackerIPAddressFromSerialNumber(String string, int n, InetAddress inetAddress, String string2, Vector<InetAddress> vector, int n2, boolean bl) throws InternalTrackerException, TrackerException {
        int n3;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        int n4 = 112;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < vector.size(); ++i) {
            InetAddress inetAddress2 = vector.elementAt(i);
            object4 = inetAddress2.getHostAddress();
            object4 = ((String)object4).substring(0, ((String)object4).lastIndexOf("."));
            MulticastSocket multicastSocket = null;
            try {
                multicastSocket = new MulticastSocket(n);
                multicastSocket.setLoopbackMode(false);
                multicastSocket.setInterface(inetAddress2);
                multicastSocket.joinGroup(inetAddress);
                object3 = new DatagramPacket(string2.getBytes(), string2.length(), inetAddress, n);
                multicastSocket.send((DatagramPacket)object3);
                multicastSocket.setSoTimeout(n2);
                boolean bl2 = false;
                while (!bl2) {
                    try {
                        object2 = new byte[n4];
                        object = new DatagramPacket((byte[])object2, ((String[])object2).length);
                        multicastSocket.receive((DatagramPacket)object);
                        if (object == null) continue;
                        Tracker.addToList((String)object4, (DatagramPacket)object, bl, arrayList);
                        object = null;
                    }
                    catch (SocketTimeoutException socketTimeoutException) {
                        bl2 = true;
                    }
                }
                multicastSocket.close();
                continue;
            }
            catch (IOException iOException) {
                throw new InternalTrackerException("Failed to find tracker using broadcast address.");
            }
        }
        Vector<Object[]> vector2 = new Vector<Object[]>(10);
        for (n3 = 0; n3 < arrayList.size(); ++n3) {
            String[] stringArray;
            String string3;
            object4 = (String)arrayList.get(n3);
            if (object4 == null) continue;
            if (((String)object4).startsWith(NEW_RESP)) {
                object4 = ((String)object4).substring(NEW_RESP.length() + 1, ((String)object4).length());
                String[] stringArray2 = ((String)object4).split(" ");
                object3 = stringArray2[4];
                string3 = stringArray2[0];
                object2 = Tracker.checkAndGetTrkIndex(string, string3);
                object = object2[0];
                if (!((String)object).equals(stringArray = object2[1])) continue;
                Tracker.checkAndAddMatchingTrackerToList(vector2, (String)object3, string3);
                continue;
            }
            if (!((String)object4).startsWith(OLD_RESP)) continue;
            int n5 = 16;
            object4 = ((String)object4).substring(16, ((String)object4).length());
            object3 = ((String)object4).substring(n5 * 0, n5 * 1).trim();
            string3 = ((String)object4).substring(n5 * 1, n5 * 2).trim();
            object2 = ((String)object4).substring(n5 * 2, n5 * 3).trim();
            object = Tracker.StringToLong((String)object2);
            stringArray = Tracker.checkAndGetTrkIndex(string, (String)object);
            String string4 = stringArray[0];
            String string5 = stringArray[1];
            if (((String)object4).length() > 48) {
                String string6 = ((String)object4).substring(n5 * 3, n5 * 4).trim();
                if ((string6 = string6.trim()).equals("WIFI_ON")) {
                    String string7 = ((String)object4).substring(n5 * 4, n5 * 5).trim();
                    String string8 = ((String)object4).substring(n5 * 5, n5 * 6).trim();
                    object3 = string7;
                }
            }
            if (!string4.equals(string5)) continue;
            Tracker.checkAndAddMatchingTrackerToList(vector2, (String)object3, (String)object);
        }
        if (1 == vector2.size()) {
            return (Object[])vector2.firstElement();
        }
        if (vector2.size() > 1) {
            for (n3 = 0; n3 < vector2.size(); ++n3) {
                object4 = (Object[])vector2.get(n3);
                if (null == object4) continue;
            }
            throw new TrackerException("Please use the unique and full serial number from the back of the tracker as multiple trackers are found on the network that match the same serial number ending in \"" + string + "\".");
        }
        return null;
    }

    private static String[] checkAndGetTrkIndex(String string, String string2) {
        String string3 = string2;
        String string4 = string;
        int n = string2.length();
        if (string2.length() > 3) {
            int n2 = string.length();
            if (n2 > n) {
                n2 = n;
                string4 = string.substring(string.length() - n2, string.length());
            }
            if (n2 > 3 && n2 <= string2.length()) {
                string3 = string2.substring(string2.length() - n2, string2.length());
            }
        }
        return new String[]{string3, string4};
    }

    private static Vector<InetAddress> getNICsHostAddresses() throws SocketException {
        Vector<InetAddress> vector = new Vector<InetAddress>(10, 1);
        Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
        while (enumeration.hasMoreElements()) {
            NetworkInterface networkInterface = enumeration.nextElement();
            Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
            while (enumeration2.hasMoreElements()) {
                InetAddress inetAddress = enumeration2.nextElement();
                if (inetAddress instanceof Inet6Address || inetAddress.isLoopbackAddress()) continue;
                vector.addElement(inetAddress);
            }
        }
        return vector;
    }

    private static String StringToLong(String string) {
        int[] nArray = new int[4];
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            nArray[n++] = Integer.parseInt(stringTokenizer.nextToken());
        }
        long l = 0L;
        for (n = 0; n < 4; ++n) {
            l = (long)((double)l + (double)nArray[3 - n] * Math.pow(256.0, n));
        }
        return Long.toString(l);
    }

    private static void addToList(String string, DatagramPacket datagramPacket, boolean bl, List<String> list) {
        boolean bl2 = false;
        int n = 0;
        string = string.substring(0, string.lastIndexOf("."));
        String string2 = new String(datagramPacket.getData());
        if (string2.startsWith(OLD_RESP) || string2.startsWith(NEW_RESP)) {
            String string3 = "";
            String string4 = "";
            if (string2.startsWith(OLD_RESP)) {
                string4 = string2.substring(16, string2.length());
                string3 = string4.substring(0, 16).trim();
            } else if (string2.startsWith(NEW_RESP)) {
                String string5 = "Fail";
                String string6 = "Invalid Format";
                if (string2.contains(string5) || string2.contains(string6)) {
                    return;
                }
                string4 = string2.substring(NEW_RESP.length() + 1, string2.length());
                String[] stringArray = string4.split(" ");
                string3 = stringArray[4];
                if (string3.equalsIgnoreCase("None")) {
                    return;
                }
            }
            string3 = string3.substring(0, string3.lastIndexOf("."));
            string3 = string3.substring(0, string3.lastIndexOf("."));
            if (string.equals(string3)) {
                n = 1;
            }
            if (bl && n == 0) {
                return;
            }
            list.add(string2 + n);
        }
    }

    static String checkAndGetIPAddress(String string, String string2) throws TrackerException {
        String[] stringArray;
        String string3;
        if (null != string) {
            string = string.trim();
        }
        if (!(string3 = (stringArray = Tracker.getTrackerIPAndType(string))[0]).equalsIgnoreCase(string2)) {
            throw new TrackerException("Illegal connection attempt detected. (Trying to connect to a tracker of type \"" + string3 + "\" using a driver object of type \"" + string2 + "\".) Please use the serial number or IP address while creating the driver object and empty connect method or the same parameter.");
        }
        return stringArray[1];
    }

    static boolean isUserParameterValidIPAddress(String string) throws TrackerException {
        String[] stringArray = string.split("\\.");
        int[] nArray = new int[4];
        if (4 != stringArray.length) {
            return false;
        }
        try {
            for (int i = 0; i < 4; ++i) {
                nArray[i] = Integer.parseInt(stringArray[i]);
                if (nArray[i] >= 0 && nArray[i] <= 255) continue;
                throw new ConnectFailedException("Illegal IP address specified.");
            }
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    private static String[] getTrackerIPAndType(String string) throws TrackerException {
        return Tracker.getTrackerIPAndType(string, false);
    }

    private static String[] getTrackerIPAndType_OLD(String string, boolean bl) throws TrackerException {
        Object object;
        boolean bl2 = Tracker.isUserParameterValidIPAddress(string.trim());
        String string2 = null;
        String string3 = null;
        if (bl2) {
            string2 = string;
        } else {
            try {
                object = Tracker.getTrackerIPAddressFromSerialNumber(string.trim());
                if (null != object) {
                    string2 = (String)object[0];
                }
            }
            catch (TrackerException trackerException) {
                string3 = trackerException.getText();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (null == string2) {
            object = "";
            if (!bl2) {
                if (null == string3) {
                    object = bl ? "Failed to identify tracker type from serial number# \"" + string + "\"." : "Failed to connect to tracker with serial number# \"" + string + "\".";
                    object = (String)object + " Please make sure you enter the full serial number from the back of the tracker. If tracker is in WiFi mode, make sure you are connected to the tracker's SSID.";
                } else {
                    object = string3;
                }
            }
            throw new TrackerException((String)object);
        }
        if (!bl) {
            // empty if block
        }
        boolean bl3 = false;
        Ftp ftp = new Ftp();
        try {
            ftp.connect(string2, "user", "");
            bl3 = true;
        }
        catch (FtpException ftpException) {
            ftp = null;
            if (bl2) {
                String string4 = "";
                if (bl) {
                    string4 = "Failed to identify tracker type from \"" + string + "\".";
                }
                if (null != string2) {
                    string4 = string4 + "Please check network settings to verify Tracker @ \"" + string2 + "\" is reachable. If tracker is in WiFi mode, make sure you are connected to the tracker's SSID." + " Alternately, use the tracker's serial number (printed at the back of the tracker) instead of the IP address.";
                }
                throw new TrackerException(string4);
            }
            String string5 = "";
            if (bl) {
                string5 = "Failed to identify tracker type from serial number# \"" + string + "\".";
            }
            if (null != string2) {
                string5 = string5 + "Please check network settings to verify Tracker @ \"" + string2 + "\" is reachable.";
            }
            throw new TrackerException(string5);
        }
        try {
            TrackerCypher.getTagData(ftp, new DataTag[]{new DataTagUnsigned32("system.os_init.time.value")});
            String[] stringArray = new String[]{"TrackerCypher", string2};
            return stringArray;
        }
        catch (TrackerException trackerException) {
            try {
                TrackerVector.getTagData(ftp, new DataTag[]{new DataTagDouble("case_temperature.16.reading.value")});
                String[] stringArray = new String[]{"TrackerVector", string2};
                return stringArray;
            }
            catch (TrackerException trackerException2) {
                try {
                    TrackerVector.getTagData(ftp, new DataTag[]{new DataTagDouble("target.corrected.distance.value")});
                    String[] stringArray = new String[]{"TrackerKeystone", string2};
                    return stringArray;
                }
                catch (TrackerException trackerException3) {
                    try {
                        TrackerVector.getTagData(ftp, new DataTag[]{new DataTagDouble("dist_corrected.output")});
                        String[] stringArray = new String[]{"Tracker4xxx", string2};
                        return stringArray;
                    }
                    catch (TrackerException trackerException4) {
                        if (bl) {
                            throw new TrackerException("Failed to identify tracker type for \"" + string + "\".");
                        }
                        throw new TrackerException("Failed to identify tracker type to connect to.");
                    }
                }
            }
        }
        finally {
            if (bl3) {
                try {
                    ftp.disconnect();
                }
                catch (FtpException ftpException) {}
                ftp = null;
            }
        }
    }

    public int applicationPercentComplete(String string) throws TrackerException {
        return this.trackerIntf.applicationPercentComplete(string);
    }

    public int smartWarmupWaitState() throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(91)};
        Object[] objectArray2 = this.doThreadTransaction(objectArray, this.blockingFlag);
        if (null != objectArray2) {
            return (Integer)objectArray2[0];
        }
        return 0;
    }

    public boolean home(boolean bl, boolean bl2) throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(92), new Boolean(bl), new Boolean(bl2)};
        Object[] objectArray2 = this.doThreadTransaction(objectArray, true);
        if (null != objectArray2) {
            return (Boolean)objectArray2[0];
        }
        throw new NoDataAvailableException();
    }

    public void connect() throws TrackerException {
        if (null == this.ipAddressToUse) {
            throw new TrackerException("Usage not compatible with the Tracker object creation. Please create Tracker object using either IP Address or the full Serial Number.");
        }
        Object[] objectArray = new Object[]{new Integer(1), this.ipAddressToUse, "user", ""};
        this.doThreadTransaction(objectArray, this.blockingFlag);
    }

    public void resetCameras() throws TrackerException {
        Object[] objectArray = new Object[3];
        objectArray[0] = new Integer(93);
        this.doThreadTransaction(objectArray, this.blockingFlag);
    }

    public void comboSearch(double d, double d2, boolean bl) throws TrackerException {
        this.comboSearch(-1.0, -1.0, -1.0, d, d2, bl);
    }

    public void comboSearch(double d, double d2, double d3, boolean bl) throws TrackerException {
        this.comboSearch(d, d2, d3, -1.0, -1.0, bl);
    }

    public void comboSearch(double d, double d2, double d3, double d4, double d5, boolean bl) throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(94), new Double(d), new Double(d2), new Double(d3), new Double(d4), new Double(d5), new Boolean(bl)};
        this.doThreadTransaction(objectArray, this.blockingFlag);
    }

    public void comboSearchInternal(double d, double d2, double d3) throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(95), new Double(d), new Double(d2), new Double(d3)};
        this.doThreadTransaction(objectArray, this.blockingFlag);
    }

    public void comboSearch() throws TrackerException {
        this.comboSearchInternal(-1.0, -1.0, -1.0);
    }

    public String getTrackerType() {
        return this.trackerType;
    }

    public boolean didAACPassSinceInitialization() throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(96)};
        Object[] objectArray2 = this.doThreadTransaction(objectArray, true);
        if (null != objectArray2) {
            return (Boolean)objectArray2[0];
        }
        throw new NoDataAvailableException();
    }

    private final int pointCartToSphere(double[] dArray) {
        if (Math.abs(dArray[0]) < 1.0E-14 && Math.abs(dArray[1]) < 1.0E-14) {
            if (Math.abs(dArray[2]) < 1.0E-14) {
                dArray[2] = 0.0;
                dArray[1] = 0.0;
                dArray[0] = 0.0;
                return -1;
            }
            if (dArray[2] > 0.0) {
                dArray[2] = dArray[2];
                dArray[1] = 0.0;
                dArray[0] = 0.0;
                return -2;
            }
            dArray[2] = -dArray[2];
            dArray[0] = 0.0;
            dArray[1] = -Math.PI;
            return -3;
        }
        double d = this.get3DPtDistance(dArray);
        dArray[0] = Math.atan2(dArray[1], dArray[0]);
        dArray[1] = Math.acos(dArray[2] / d);
        dArray[2] = d;
        return 0;
    }

    private double get3DPtDistance(double[] dArray) {
        return Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1] + dArray[2] * dArray[2]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MeasurePointData hiddenPointMeasurement() throws TrackerException {
        boolean bl = this.getBlocking();
        boolean bl2 = this.exclusiveAccessForCurrentThread();
        if (!bl2) {
            this.setExclusiveAccess();
        }
        try {
            ArrayList<double[]> arrayList = new ArrayList<double[]>();
            this.setBlocking(true);
            this.startMeasurePoint(new MeasureCfg(1, new NullFilter(), new NullStartTrigger(), new DistanceTrigger(0.001)));
            int n = 0;
            double d = 0.0;
            block3: while (SphereFit.needMoreSphereData(arrayList) && n != 2) {
                int n2 = this.availableMeasurements();
                if (n2 <= 0) continue;
                MeasurePointData[] measurePointDataArray = this.readMeasurePointData(n2);
                d = measurePointDataArray[n2 - 1].time();
                for (int i = 0; i < n2; ++i) {
                    if (measurePointDataArray[i].status() != 2) {
                        arrayList.add(new double[]{measurePointDataArray[i].distance() * Math.sin(measurePointDataArray[i].zenith()) * Math.cos(measurePointDataArray[i].azimuth()), measurePointDataArray[i].distance() * Math.sin(measurePointDataArray[i].zenith()) * Math.sin(measurePointDataArray[i].azimuth()), measurePointDataArray[i].distance() * Math.cos(measurePointDataArray[i].zenith())});
                        if (measurePointDataArray[i].status() != 1) continue;
                        n = 1;
                        continue;
                    }
                    n = 2;
                    continue block3;
                }
            }
            if (arrayList.size() < 50) {
                throw new TrackerException("Not enough data to compute hidden point");
            }
            double[] dArray = SphereFit.computeSphereAndResiduals((double[][])arrayList.toArray((T[])new double[arrayList.size()][3]), false);
            double d2 = 2.0E-5 + 5.0E-6 * dArray[2];
            double d3 = 0.33 * d2;
            double d4 = 0.8 * d2;
            if (n == 0 && (dArray[4] > d3 || dArray[5] > d4)) {
                n = 1;
            }
            MeasurePointData measurePointData = new MeasurePointData(d, dArray[0], dArray[1], dArray[2], n, new MeasurePointStdDev(0.0, 0.0, dArray[6]));
            return measurePointData;
        }
        finally {
            this.stopMeasurePoint();
            this.setBlocking(bl);
            if (!bl2) {
                this.clearExclusiveAccess();
            }
        }
    }

    public int batteryChargeRemaining(int n) throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(97), new Integer(n)};
        Object[] objectArray2 = this.doThreadTransaction(objectArray, true);
        if (null != objectArray2) {
            return (Integer)objectArray2[0];
        }
        throw new NoDataAvailableException();
    }

    public void factoryDisconnect(String string) throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(66), new String(string)};
        this.doThreadTransaction(objectArray, this.blockingFlag);
    }

    public int batteryState(int n) throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(100), new Integer(n)};
        Object[] objectArray2 = this.doThreadTransaction(objectArray, true);
        if (null != objectArray2) {
            return (Integer)objectArray2[0];
        }
        throw new NoDataAvailableException();
    }

    public void changePowerButtonState(boolean bl) throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(101), new Boolean(bl)};
        this.doThreadTransaction(objectArray, true);
    }

    public boolean powerButtonState() throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(102)};
        Object[] objectArray2 = this.doThreadTransaction(objectArray, true);
        if (null != objectArray2) {
            return (Boolean)objectArray2[0];
        }
        throw new NoDataAvailableException();
    }

    public void reboot() throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(103)};
        this.doThreadTransaction(objectArray, true);
    }

    public boolean isFollowMeCapable() throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(108)};
        Object[] objectArray2 = this.doThreadTransaction(objectArray, true);
        if (null != objectArray2) {
            return (Boolean)objectArray2[0];
        }
        throw new NoDataAvailableException();
    }

    public boolean isFollowMeOn() throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(104)};
        Object[] objectArray2 = this.doThreadTransaction(objectArray, true);
        if (null != objectArray2) {
            return (Boolean)objectArray2[0];
        }
        throw new NoDataAvailableException();
    }

    public void changeFollowMeState(boolean bl) throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(105), new Boolean(bl)};
        this.doThreadTransaction(objectArray, true);
    }

    public double getFollowMeSearchRadius() throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(106)};
        Object[] objectArray2 = this.doThreadTransaction(objectArray, true);
        if (null != objectArray2) {
            return (Double)objectArray2[0];
        }
        throw new NoDataAvailableException();
    }

    public void changeFollowMeSearchRadius(double d) throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(107), new Double(d)};
        this.doThreadTransaction(objectArray, true);
    }

    public boolean sixDofCapable() throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(109)};
        Object[] objectArray2 = this.doThreadTransaction(objectArray, true);
        if (null != objectArray2) {
            return (Boolean)objectArray2[0];
        }
        throw new NoDataAvailableException();
    }

    public Probe[] availableProbes() throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(110)};
        Object[] objectArray2 = this.doThreadTransaction(objectArray, true);
        if (null != objectArray2) {
            return (Probe[])objectArray2[0];
        }
        throw new NoDataAvailableException();
    }

    public void addProbe(Probe probe) throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(111), probe};
        this.doThreadTransaction(objectArray, true);
    }

    public void removeProbe(Probe probe) throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(113), probe};
        this.doThreadTransaction(objectArray, true);
    }

    public void modifyProbe(Probe probe) throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(112), probe};
        this.doThreadTransaction(objectArray, true);
    }

    public void changeProbe(Probe probe, boolean bl) throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(115), probe, new Boolean(bl)};
        this.doThreadTransaction(objectArray, true);
    }

    public Probe probe() throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(114)};
        Object[] objectArray2 = this.doThreadTransaction(objectArray, true);
        if (null != objectArray2) {
            return (Probe)objectArray2[0];
        }
        throw new NoDataAvailableException();
    }

    public String probeAdapter() throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(116)};
        Object[] objectArray2 = this.doThreadTransaction(objectArray, true);
        if (null != objectArray2) {
            return (String)objectArray2[0];
        }
        throw new NoDataAvailableException();
    }

    public boolean probeAdapterConnected() throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(117)};
        Object[] objectArray2 = this.doThreadTransaction(objectArray, true);
        if (null != objectArray2) {
            return (Boolean)objectArray2[0];
        }
        throw new NoDataAvailableException();
    }

    public synchronized void addProbeButtonListener(ProbeButtonListener probeButtonListener) throws TrackerException {
        if (!this.sixDofCapable()) {
            throw new UnsupportedFeatureException("Feature not supported");
        }
        Object[] objectArray = new Object[]{new Integer(126)};
        this.doThreadTransaction(objectArray, true);
        this.trackerMgr.addProbeButtonListener(probeButtonListener);
    }

    public synchronized void removeProbeButtonListener(ProbeButtonListener probeButtonListener) throws TrackerException {
        if (!this.sixDofCapable()) {
            throw new UnsupportedFeatureException("Feature not supported");
        }
        this.trackerMgr.removeProbeButtonListener(probeButtonListener);
    }

    public ProbeCompensationData calcProbeCompensationParameters(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, double[] dArray6) throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(121), dArray, dArray2, dArray3, dArray4, dArray5, dArray6};
        Object[] objectArray2 = this.doThreadTransaction(objectArray, true);
        if (null != objectArray2) {
            return (ProbeCompensationData)objectArray2[0];
        }
        throw new NoDataAvailableException();
    }

    public ProbeCalibrationData calibrateProbeTip(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, double[] dArray6) throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(119), dArray, dArray2, dArray3, dArray4, dArray5, dArray6};
        Object[] objectArray2 = this.doThreadTransaction(objectArray, true);
        if (null != objectArray2) {
            return (ProbeCalibrationData)objectArray2[0];
        }
        throw new NoDataAvailableException();
    }

    public ProbeCalibrationData calibrateISOProbeTip(double[] dArray, double[] dArray2, double[] dArray3) throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(122), dArray, dArray2, dArray3};
        Object[] objectArray2 = this.doThreadTransaction(objectArray, true);
        if (null != objectArray2) {
            return (ProbeCalibrationData)objectArray2[0];
        }
        throw new NoDataAvailableException();
    }

    public void updateProbeCompensationParameters(Probe probe, ProbeCompensationData probeCompensationData) throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(120), probe, probeCompensationData};
        this.doThreadTransaction(objectArray, true);
    }

    public void updateProbeCompensationParameters(Probe probe, double d, double d2, double d3) throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(129), probe, d, d2, d3};
        this.doThreadTransaction(objectArray, true);
    }

    public boolean sixDofEnabled() throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(123)};
        Object[] objectArray2 = this.doThreadTransaction(objectArray, true);
        if (null != objectArray2) {
            return (Boolean)objectArray2[0];
        }
        throw new NoDataAvailableException();
    }

    public void changeSixDofEnableState(boolean bl) throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(124), new Boolean(bl)};
        this.doThreadTransaction(objectArray, true);
    }

    public int probeBatteryChargeRemaining() throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(125)};
        Object[] objectArray2 = this.doThreadTransaction(objectArray, true);
        if (null != objectArray2) {
            return (Integer)objectArray2[0];
        }
        throw new NoDataAvailableException();
    }

    public void removeAllProbes() throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(127)};
        this.doThreadTransaction(objectArray, true);
    }

    public void removeAllFactoryProbes() throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(128)};
        this.doThreadTransaction(objectArray, true);
    }

    public double getDelayFromPassiveToActiveFollowMe() throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(130)};
        Object[] objectArray2 = this.doThreadTransaction(objectArray, true);
        if (null != objectArray2) {
            return (Double)objectArray2[0];
        }
        throw new NoDataAvailableException();
    }

    public void setDelayFromPassiveToActiveFollowMe(double d) throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(131), new Double(d)};
        this.doThreadTransaction(objectArray, true);
    }

    public synchronized void addFactoryProbeButtonListener(ProbeButtonListener probeButtonListener) throws TrackerException {
        if (!this.sixDofCapable()) {
            throw new UnsupportedFeatureException("Feature not supported");
        }
        Object[] objectArray = new Object[]{new Integer(126)};
        this.doThreadTransaction(objectArray, true);
        this.trackerMgr.addFactoryProbeButtonListener(probeButtonListener);
    }

    public synchronized void removeFactoryProbeButtonListener(ProbeButtonListener probeButtonListener) throws TrackerException {
        if (!this.sixDofCapable()) {
            throw new UnsupportedFeatureException("Feature not supported");
        }
        this.trackerMgr.removeFactoryProbeButtonListener(probeButtonListener);
    }

    public int probeBatteryState() throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(133)};
        Object[] objectArray2 = this.doThreadTransaction(objectArray, true);
        if (null != objectArray2) {
            return (Integer)objectArray2[0];
        }
        throw new NoDataAvailableException();
    }

    public boolean probeBatteryStateChangeEventSupported() throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(134)};
        Object[] objectArray2 = this.doThreadTransaction(objectArray, true);
        if (null != objectArray2) {
            return (Boolean)objectArray2[0];
        }
        throw new NoDataAvailableException();
    }

    private static AvailableTracker[] convertResponseToTracker(List<String> list) {
        ArrayList<AvailableTracker> arrayList = new ArrayList<AvailableTracker>();
        for (int i = 0; i < list.size(); ++i) {
            String[] stringArray;
            int n;
            String string = list.get(i);
            if (string == null) continue;
            if (string.startsWith(OLD_RESP)) {
                String string2;
                n = 0;
                int n2 = 0;
                stringArray = string.substring(16, string.length());
                int n3 = 16;
                String string3 = stringArray.substring(0, n3).trim();
                String string4 = stringArray.substring(n3 * 2, n3 * 3).trim();
                if (stringArray.length() > 48) {
                    string2 = stringArray.substring(n3 * 3, n3 * 4).trim();
                    if ((string2 = string2.trim()).equals("WIFI_ON") || string2.equals("WIFI_OFF")) {
                        n2 = 1;
                        n = string2.equals("WIFI_ON") ? 1 : 0;
                        String string5 = stringArray.substring(n3 * 4, n3 * 5).trim();
                        if (string2.equals("WIFI_ON")) {
                            string3 = string5;
                        }
                    } else {
                        n2 = 0;
                    }
                }
                string2 = Tracker.StringToLong(string4);
                arrayList.add(new AvailableTracker(string2, string3, n, n2));
                continue;
            }
            if (!string.startsWith(NEW_RESP)) continue;
            n = 0;
            String string6 = (string = string.trim()).substring(NEW_RESP.length() + 1, string.length());
            stringArray = string6.split(" ");
            if (stringArray[1].equalsIgnoreCase("wlan0")) {
                n = 1;
            }
            arrayList.add(new AvailableTracker(stringArray[0], stringArray[4], n, 2));
        }
        AvailableTracker[] availableTrackerArray = new AvailableTracker[arrayList.size()];
        for (int i = 0; i < availableTrackerArray.length; ++i) {
            availableTrackerArray[i] = (AvailableTracker)arrayList.get(i);
        }
        return availableTrackerArray;
    }

    private static void availableTrackers(String string, InetAddress inetAddress, int n, Vector vector, List<String> list) throws IOException {
        for (int i = 0; i < vector.size(); ++i) {
            InetAddress inetAddress2 = (InetAddress)vector.elementAt(i);
            String string2 = inetAddress2.getHostAddress();
            string2 = string2.substring(0, string2.lastIndexOf("."));
            MulticastSocket multicastSocket = Tracker.sendPacket(string, inetAddress, inetAddress2, n);
            boolean bl = false;
            while (!bl) {
                try {
                    byte[] byArray = new byte[200];
                    DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
                    multicastSocket.receive(datagramPacket);
                    if (datagramPacket == null) continue;
                    Tracker.addFindTrackersResultToList(string2, datagramPacket, list);
                    datagramPacket = null;
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    bl = true;
                }
            }
            multicastSocket.leaveGroup(inetAddress);
            multicastSocket.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addFindTrackersResultToList(String string, DatagramPacket datagramPacket, List<String> list) {
        String string2 = new String(datagramPacket.getData());
        if (string2.startsWith(OLD_RESP) || string2.startsWith(NEW_RESP)) {
            String string3 = "Fail";
            String string4 = "Invalid Format";
            if (string2.startsWith(NEW_RESP) && (string2.contains(string3) || string2.contains(string4))) {
                return;
            }
            List<String> list2 = list;
            synchronized (list2) {
                if (!list.contains(string2)) {
                    list.add(string2);
                }
            }
        }
    }

    private static MulticastSocket sendPacket(String string, InetAddress inetAddress, InetAddress inetAddress2, int n) throws IOException {
        MulticastSocket multicastSocket = new MulticastSocket(n);
        multicastSocket.setLoopbackMode(false);
        multicastSocket.setInterface(inetAddress2);
        multicastSocket.joinGroup(inetAddress);
        DatagramPacket datagramPacket = new DatagramPacket(string.getBytes(), string.length(), inetAddress, n);
        multicastSocket.send(datagramPacket);
        multicastSocket.setSoTimeout(3000);
        return multicastSocket;
    }

    /*
     * WARNING - void declaration
     */
    public static AvailableTracker[] availableTrackers() throws IOException {
        FindTrackers findTrackers = new FindTrackers(null, "", false);
        Tracker.logLine("---------------------availableTrackers-----------------");
        Tracker.logLine(new Date().toString());
        long l = System.currentTimeMillis();
        try {
            Object object;
            int n;
            ArrayList<AvailableTracker> arrayList;
            Vector[] vectorArray = findTrackers.findTrackers();
            Vector vector = vectorArray[0];
            HashMap<TrkInfo, String> hashMap = new HashMap<TrkInfo, String>();
            for (int i = 0; i < vector.size(); ++i) {
                arrayList = (TrkInfo)vector.elementAt(i);
                hashMap.put((TrkInfo)((Object)arrayList), ((TrkInfo)((Object)arrayList)).getSrNum());
            }
            HashMap hashMap2 = new HashMap();
            for (Map.Entry availableTrackerArray2 : hashMap.entrySet()) {
                void var9_12;
                ArrayList arrayList2 = new ArrayList();
                if (hashMap2.containsKey(availableTrackerArray2.getValue())) {
                    List list = (List)hashMap2.get(availableTrackerArray2.getValue());
                }
                var9_12.add(availableTrackerArray2.getKey());
                hashMap2.put(availableTrackerArray2.getValue(), var9_12);
            }
            arrayList = new ArrayList<AvailableTracker>();
            for (Map.Entry entry : hashMap2.entrySet()) {
                List list = (List)entry.getValue();
                if (list.size() <= 0) continue;
                boolean bl = false;
                for (n = 0; n < list.size(); ++n) {
                    object = (TrkInfo)list.get(n);
                    if (((TrkInfo)object).getPacketType() != TrkInfo.CYPHER_WIFI_PACKET || ((CypherInfo)object).isReachable() != TrkInfo.REACHABLE_YES) continue;
                    arrayList.add(new AvailableTracker(((TrkInfo)object).getSrNum(), ((TrkInfo)object).getIpAdd(), ((TrkInfo)object).getConnectionType(), ((TrkInfo)object).getModelType()));
                    bl = true;
                }
                if (bl) continue;
                for (n = 0; n < list.size(); ++n) {
                    object = (TrkInfo)list.get(n);
                    if (((TrkInfo)object).getPacketType() != TrkInfo.CYPHER_WIRED_PACKET || ((CypherInfo)object).isReachable() != TrkInfo.REACHABLE_YES) continue;
                    arrayList.add(new AvailableTracker(((TrkInfo)object).getSrNum(), ((TrkInfo)object).getIpAdd(), ((TrkInfo)object).getConnectionType(), ((TrkInfo)object).getModelType()));
                    bl = true;
                }
                if (bl) continue;
                for (n = 0; n < list.size(); ++n) {
                    object = (TrkInfo)list.get(n);
                    if (!(object instanceof VantageIonInfo)) continue;
                    VantageIonInfo vantageIonInfo = (VantageIonInfo)object;
                    int n2 = vantageIonInfo.isWiredReachable();
                    int n3 = TrkInfo.REACHABLE_NO;
                    if (vantageIonInfo.getModelType() == 1) {
                        n3 = vantageIonInfo.isWifiReachable();
                    }
                    if (n3 == TrkInfo.REACHABLE_YES) {
                        arrayList.add(new AvailableTracker(vantageIonInfo.getSrNum(), vantageIonInfo.getWifiIp(), vantageIonInfo.getConnectionType(), vantageIonInfo.getModelType()));
                        continue;
                    }
                    if (n2 != TrkInfo.REACHABLE_YES) continue;
                    arrayList.add(new AvailableTracker(vantageIonInfo.getSrNum(), vantageIonInfo.getIpAdd(), vantageIonInfo.getConnectionType(), vantageIonInfo.getModelType()));
                }
            }
            AvailableTracker[] availableTrackerArray = arrayList.toArray(new AvailableTracker[arrayList.size()]);
            int n4 = availableTrackerArray.length;
            Tracker.logLine("Num trks: " + n4);
            for (int i = 0; i < n4; ++i) {
                String string = "";
                n = availableTrackerArray[i].getModelType();
                if (n == 0) {
                    string = "faro";
                } else if (n == 1) {
                    string = "Vantage";
                } else if (n == 2) {
                    string = "Vantage S";
                }
                object = "";
                int n5 = availableTrackerArray[i].getConnectionType();
                if (n5 == 1) {
                    object = "wifi";
                } else if (n5 == 0) {
                    object = "wired";
                }
                Tracker.logLine(availableTrackerArray[i].getSerialNum() + "," + availableTrackerArray[i].getIpAddress() + "," + string + "," + (String)object);
            }
            Tracker.logLine("Time: " + (System.currentTimeMillis() - l) / 1000L);
            Tracker.logLine("---------------------done availableTrackers-----------------");
            return availableTrackerArray;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String[] getTrackerIPAndType(String string, boolean bl) throws TrackerException {
        Object[] objectArray;
        Object object;
        Ftp ftp;
        boolean bl2;
        String string2;
        boolean bl3;
        long l;
        block72: {
            Object object2;
            l = System.currentTimeMillis();
            bl3 = Tracker.isUserParameterValidIPAddress(string.trim());
            string2 = null;
            String string3 = null;
            String string4 = null;
            boolean bl4 = false;
            boolean bl5 = false;
            String string5 = "For WiFi connection: ";
            String string6 = "For wired connection: ";
            boolean bl6 = false;
            if (bl3) {
                string2 = string;
            } else {
                if (string.trim().length() < 4) {
                    throw new TrackerException("Invalid serial number. Please provide atleast last four digits of the full tracker serial number");
                }
                Tracker.logLine("Searching for: " + string);
                Tracker.logLine("getTrackerIPAddressFromSerialNumber");
                try {
                    try {
                        Vector<TrkInfo> vector = Tracker.findIPAddressesFromSerialNumber(string.trim());
                        if (0 != vector.size()) {
                            for (int i = 0; i < vector.size(); ++i) {
                                bl6 = true;
                                if (TrkInfo.CYPHER_WIFI_PACKET == vector.get(i).getPacketType()) {
                                    string3 = vector.get(i).getIpAdd();
                                    bl4 = TrkInfo.REACHABLE_YES == ((CypherInfo)vector.get(i)).isReachable();
                                    Tracker.logLine("WIFI IP found :" + string3);
                                    if (!bl4) {
                                        if (Tracker.isTrackerReachable(string3)) {
                                            bl4 = true;
                                            Tracker.logLine("WIFI IP is reachable");
                                            continue;
                                        }
                                        string5 = string5 + ((CypherInfo)vector.get(i)).getReachableRecommendation();
                                        Tracker.logLine("WIFI IP not reachable because :" + string5);
                                        continue;
                                    }
                                    Tracker.logLine("WIFI IP is reachable");
                                    continue;
                                }
                                if (TrkInfo.CYPHER_WIRED_PACKET == vector.get(i).getPacketType()) {
                                    string4 = vector.get(i).getIpAdd();
                                    Tracker.logLine("WIRED IP found :" + string4);
                                    boolean bl7 = bl5 = TrkInfo.REACHABLE_YES == ((CypherInfo)vector.get(i)).isReachable();
                                    if (!bl5) {
                                        string6 = string6 + ((CypherInfo)vector.get(i)).getReachableRecommendation();
                                        Tracker.logLine("WIRED IP not reachable because :" + string6);
                                        continue;
                                    }
                                    Tracker.logLine("WIRED IP is reachable");
                                    continue;
                                }
                                if (TrkInfo.LEGACY_PACKET != vector.get(i).getPacketType()) continue;
                                object2 = (VantageIonInfo)vector.get(i);
                                if (vector.get(i).getModelType() == 1) {
                                    string3 = ((VantageIonInfo)object2).getWifiIp();
                                    bl4 = TrkInfo.REACHABLE_YES == ((VantageIonInfo)object2).isWifiReachable();
                                    Tracker.logLine("WIFI IP found :" + string3);
                                    if (!bl4) {
                                        if (Tracker.isTrackerReachable(string3)) {
                                            bl4 = true;
                                            Tracker.logLine("WIFI IP is reachable");
                                        } else {
                                            string5 = string5 + ((VantageIonInfo)object2).getWifiReachableRecommendation();
                                            Tracker.logLine("WIFI IP not reachable because :" + string5);
                                        }
                                    } else {
                                        Tracker.logLine("WIFI IP is reachable");
                                    }
                                }
                                string4 = ((TrkInfo)object2).getIpAdd();
                                Tracker.logLine("WIRED IP found :" + string4);
                                boolean bl8 = bl5 = TrkInfo.REACHABLE_YES == ((VantageIonInfo)object2).isWiredReachable();
                                if (!bl5) {
                                    string6 = string6 + ((VantageIonInfo)object2).getWiredReachableRecommendation();
                                    Tracker.logLine("WIRED IP not reachable because :" + string6);
                                    continue;
                                }
                                Tracker.logLine("WIRED IP is reachable");
                            }
                            if (bl4) {
                                string2 = string3;
                            } else if (bl5) {
                                string2 = string4;
                            }
                        }
                    }
                    catch (IOException iOException) {
                        Tracker.logLine("Exp: Failed to find IP Address from given serial number (" + string + ")");
                        throw new TrackerException("Failed to find IP Address from given serial number (" + string + ")");
                    }
                }
                catch (TrackerException trackerException) {
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            boolean bl9 = false;
            String string7 = null;
            if (null != string3) {
                string7 = string3;
            }
            if (null != string4) {
                string7 = null == string7 ? string4 : string7 + " & " + string4;
            }
            object2 = "Failed to connect to tracker with serial number ending in \"" + string + "\"";
            object2 = null != string7 ? (String)object2 + " (using: " + string7 + ")." : (String)object2 + ".";
            object2 = (String)object2 + "\nPlease follow the below recommendation(s) to successfully connect to the tracker: ";
            String string8 = "\n - Please make sure that the tracker with serial number ending in \"" + string + "\"" + " is powered on.";
            string8 = string8 + "\n - Then check that the PC is connected to the tracker via it's SSID or via an ethernet cable.";
            if (!bl3 && null == string2) {
                if (bl6) {
                    if (null != string3 && !bl4) {
                        object2 = (String)object2 + "\n - " + string5;
                    }
                    if (null != string4 && !bl5) {
                        object2 = (String)object2 + "\n - " + string6;
                    }
                    throw new TrackerException((String)object2);
                }
                if (Tracker.isTrackerReachable("169.254.1.1")) {
                    string2 = "169.254.1.1";
                    bl9 = true;
                } else {
                    Tracker.logLine((String)object2 + string8);
                    throw new TrackerException((String)object2 + string8);
                }
            }
            bl2 = false;
            ftp = new Ftp();
            try {
                String string9;
                int n;
                int n2;
                int n3;
                String string10;
                Tracker.logLine("Connecting to tracker using IP address : " + string2);
                ftp.connect(string2, "user", "");
                bl2 = true;
                if (!bl3 && string2.startsWith("169.254.1") && !(string10 = ((String)(object = String.valueOf((Long)(objectArray = TrackerCypher.getTagData(ftp, new DataTag[]{new DataTagUnsigned32("system.serial_num.value")}))[0]))).substring((n3 = ((String)object).length()) - (n2 = Math.min(n3, n = string.length())), n3)).endsWith(string9 = string.substring(n - n2, n))) {
                    if (!bl5) {
                        if (bl9) {
                            Tracker.logLine((String)object2 + string8);
                            throw new TrackerException((String)object2 + string8);
                        }
                        Tracker.logLine("PC is connected to the wrong tracker's SSID. Connect the PC to the SSID of the tracker whose serial number ends in \"" + string9 + "\"");
                        throw new TrackerException("PC is connected to the wrong tracker's SSID. Connect the PC to the SSID of the tracker whose serial number ends in \"" + string9 + "\"");
                    }
                    string2 = string4;
                    ftp.disconnect();
                    bl2 = false;
                    Tracker.logLine("RE-trying connecting to tracker using WIRED IP: " + string2);
                    ftp.connect(string2, "user", "");
                    bl2 = true;
                }
            }
            catch (FtpException ftpException) {
                if (bl4 && bl5) {
                    string2 = string4;
                    Tracker.logLine("WiFi reachable but not connectable!! RE-trying connecting to tracker using WIRED IP: " + string2);
                    try {
                        ftp.connect(string2, "user", "");
                        bl2 = true;
                    }
                    catch (FtpException ftpException2) {
                        // empty catch block
                    }
                }
                if (bl2) break block72;
                ftp = null;
                Tracker.logLine("Connect failed");
                if (ftpException instanceof FtpIOException && ((FtpIOException)ftpException).getErrorCode() == 421) {
                    Tracker.logLine("Out of sessions");
                    if (bl3) {
                        Tracker.logLine("Failed to connect to tracker with ip address \"" + string + "\"" + ". Please reboot tracker and try again. ");
                        throw new TrackerException("Failed to connect to tracker with ip address \"" + string + "\"" + ". Please reboot tracker and try again. ");
                    }
                    if (bl9) {
                        Tracker.logLine((String)object2 + string8);
                        throw new TrackerException((String)object2 + string8);
                    }
                    Tracker.logLine((String)object2 + "\n - Please reboot tracker and try again.");
                    throw new TrackerException((String)object2 + "\n - Please reboot tracker and try again.");
                }
                if (bl9) {
                    string2 = null;
                    Tracker.logLine((String)object2 + string8);
                    throw new TrackerException((String)object2 + string8);
                }
                if (bl3) {
                    Tracker.logLine("Failed to connect to tracker with ip address \"" + string + "\"" + ". Please make sure tracker and PC network configurations match or try using tracker serial number instead of IP address.");
                    throw new TrackerException("Failed to connect to tracker with ip address \"" + string + "\"" + ". Please make sure tracker and PC network configurations match or try using tracker serial number instead of IP address.");
                }
                Tracker.logLine("Failed to find tracker with serial number ending in \"" + string + "\" (using: " + string7 + "). \n - Please reboot tracker and try again.");
                throw new TrackerException("Failed to find tracker with serial number ending in \"" + string + "\" (using: " + string7 + "). \n - Please reboot tracker and try again.");
            }
        }
        Tracker.logLine("Reading tag to determine tracker type");
        try {
            TrackerCypher.getTagData(ftp, new DataTag[]{new DataTagUnsigned32("system.os_init.time.value")});
            objectArray = new String[]{"TrackerCypher", string2};
            return objectArray;
        }
        catch (TrackerException trackerException) {
            try {
                TrackerVector.getTagData(ftp, new DataTag[]{new DataTagDouble("case_temperature.16.reading.value")});
                object = new String[]{"TrackerVector", string2};
                return object;
            }
            catch (TrackerException trackerException2) {
                try {
                    TrackerVector.getTagData(ftp, new DataTag[]{new DataTagDouble("target.corrected.distance.value")});
                    String[] stringArray = new String[]{"TrackerKeystone", string2};
                    return stringArray;
                }
                catch (TrackerException trackerException3) {
                    try {
                        TrackerVector.getTagData(ftp, new DataTag[]{new DataTagDouble("dist_corrected.output")});
                        String[] stringArray = new String[]{"Tracker4xxx", string2};
                        return stringArray;
                    }
                    catch (TrackerException trackerException4) {
                        Tracker.logLine("Failed to read tag to determine tracker type");
                        if (bl3) {
                            Tracker.logLine("Firewall prevented connecting to tracker with ip address \"" + string + "\"" + ". Please check that the application is added to the allowed programs on the firewall for the public network.");
                            throw new TrackerException("Firewall prevented connecting to tracker with ip address \"" + string + "\"" + ". Please check that the application is added to the allowed programs on the firewall for the public network.");
                        }
                        Tracker.logLine("Firewall prevented connecting to tracker with serial number ending in \"" + string + "\"" + ". Please check that the application is added to the allowed programs on the firewall for the public network.");
                        throw new TrackerException("Firewall prevented connecting to tracker with serial number ending in \"" + string + "\"" + ". Please check that the application is added to the allowed programs on the firewall for the public network.");
                    }
                }
            }
        }
        finally {
            if (bl2) {
                try {
                    Tracker.logLine("Disconnect tracker - Constructor");
                    ftp.disconnect();
                    Tracker.logLine("Time Taken: " + (System.currentTimeMillis() - l) / 1000L);
                }
                catch (FtpException ftpException) {}
                ftp = null;
            }
        }
    }

    private static boolean isTrackerReachable(String string) {
        if (null == string) {
            return false;
        }
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            return inetAddress.isReachable(1000);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private static Vector<TrkInfo> findIPAddressesFromSerialNumber(String string) throws Exception {
        FindTrackers findTrackers = new FindTrackers(debugWriter, string, false);
        Vector[] vectorArray = findTrackers.findTrackers();
        Vector vector = vectorArray[0];
        int n = vector.size();
        String[] stringArray = new String[2];
        for (int i = 0; i < n; ++i) {
            TrkInfo trkInfo = (TrkInfo)vector.get(i);
            stringArray[i] = trkInfo.getIpAdd();
            Tracker.logLine(trkInfo.toString());
        }
        return vector;
    }

    private static void logLine(String string) {
        if (debugWriter != null) {
            debugWriter.println(string);
        }
    }

    public boolean wirelessStateChangeSupported() throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(135)};
        Object[] objectArray2 = this.doThreadTransaction(objectArray, true);
        if (null != objectArray2) {
            return (Boolean)objectArray2[0];
        }
        throw new NoDataAvailableException();
    }

    public void changeWirelessState(boolean bl) throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(136), new Boolean(bl)};
        this.doThreadTransaction(objectArray, true);
    }

    public boolean wirelessOn() throws TrackerException {
        Object[] objectArray = new Object[]{new Integer(137)};
        Object[] objectArray2 = this.doThreadTransaction(objectArray, true);
        if (null != objectArray2) {
            return (Boolean)objectArray2[0];
        }
        throw new NoDataAvailableException();
    }

    public boolean isCatEyeTargetCapable() throws TrackerException {
        return this.trackerIntf.isCatEyeTargetCapable();
    }

    private static class SphereFit {
        public static int minPts = 500;
        public static double minDist = 0.1;
        public static double planeDist = 0.025;

        private SphereFit() {
        }

        public static double[] computeSphereAndResiduals(double[][] dArray, boolean bl) {
            int n = dArray.length;
            double d = 0.0;
            double d2 = 0.0;
            double[] dArray2 = new double[n];
            double[][] dArray3 = bl ? SphereFit.cartesian(dArray) : dArray;
            double[] dArray4 = SphereFit.sphereFit(dArray3);
            for (int i = 0; i < n; ++i) {
                double d3 = dArray3[i][0] - dArray4[0];
                double d4 = dArray3[i][1] - dArray4[1];
                double d5 = dArray3[i][2] - dArray4[2];
                dArray2[i] = Math.sqrt(d3 * d3 + d4 * d4 + d5 * d5);
                double d6 = Math.abs(dArray4[3] - dArray2[i]);
                if (d6 > d2) {
                    d2 = d6;
                }
                d += d6;
            }
            double[] dArray5 = SphereFit.spherical(dArray4);
            return new double[]{dArray5[0], dArray5[1], dArray5[2], dArray4[3], d / (double)n, d2, SphereFit.stdDev(dArray2)};
        }

        private static double[] sphereFit(double[][] dArray) {
            int n = dArray.length;
            double[] dArray2 = new double[9];
            double[] dArray3 = new double[4];
            for (int i = 0; i < n; ++i) {
                dArray2[0] = dArray2[0] + dArray[i][0];
                dArray2[1] = dArray2[1] + dArray[i][1];
                dArray2[2] = dArray2[2] + dArray[i][2];
                dArray2[3] = dArray2[3] + dArray[i][0] * dArray[i][0];
                dArray2[4] = dArray2[4] + dArray[i][0] * dArray[i][1];
                dArray2[5] = dArray2[5] + dArray[i][0] * dArray[i][2];
                dArray2[6] = dArray2[6] + dArray[i][1] * dArray[i][1];
                dArray2[7] = dArray2[7] + dArray[i][1] * dArray[i][2];
                dArray2[8] = dArray2[8] + dArray[i][2] * dArray[i][2];
                double d = dArray[i][0] * dArray[i][0] + dArray[i][1] * dArray[i][1] + dArray[i][2] * dArray[i][2];
                dArray3[0] = dArray3[0] + d;
                dArray3[1] = dArray3[1] + d * dArray[i][0];
                dArray3[2] = dArray3[2] + d * dArray[i][1];
                dArray3[3] = dArray3[3] + d * dArray[i][2];
            }
            double[][] dArrayArray = new double[][]{{n, dArray2[0], dArray2[1], dArray2[2]}, {dArray2[0], dArray2[3], dArray2[4], dArray2[5]}, {dArray2[1], dArray2[4], dArray2[6], dArray2[7]}, {dArray2[2], dArray2[5], dArray2[7], dArray2[8]}};
            double[] dArray4 = new double[]{-dArray3[0], -dArray3[1], -dArray3[2], -dArray3[3]};
            double[] dArray5 = SphereFit.solve(dArrayArray, dArray4);
            double d = -0.5 * dArray5[1];
            double d2 = -0.5 * dArray5[2];
            double d3 = -0.5 * dArray5[3];
            return new double[]{d, d2, d3, Math.sqrt(d * d + d2 * d2 + d3 * d3 - dArray5[0])};
        }

        public static boolean needMoreSphereData(ArrayList<double[]> arrayList) {
            if (arrayList.size() > minPts) {
                double d;
                int n;
                int n2;
                int n3 = arrayList.size();
                int n4 = -1;
                int n5 = -1;
                double d2 = 0.0;
                double[] dArray = null;
                double[] dArray2 = null;
                for (n2 = 0; n2 < n3 - 1; ++n2) {
                    dArray = arrayList.get(n2);
                    for (n = n2 + 1; n < n3; ++n) {
                        dArray2 = arrayList.get(n);
                        d = SphereFit.distancePointPoint(dArray, dArray2);
                        if (!(d > d2)) continue;
                        n4 = n2;
                        n5 = n;
                        d2 = d;
                    }
                }
                dArray = arrayList.get(n4);
                dArray2 = arrayList.get(n5);
                if (d2 > minDist) {
                    n2 = -1;
                    d2 = 0.0;
                    for (n = 0; n < n3; ++n) {
                        if (n == n4 || n == n5 || !((d = SphereFit.distancePointLine(dArray, dArray2, arrayList.get(n))) > d2)) continue;
                        n2 = n;
                        d2 = d;
                    }
                    double[] dArray3 = arrayList.get(n2);
                    double[] dArray4 = SphereFit.cross(SphereFit.minus(dArray, dArray3), SphereFit.minus(dArray2, dArray3));
                    for (int i = 0; i < n3; ++i) {
                        double d3;
                        if (i == n4 || i == n5 || i == n2 || !((d3 = SphereFit.distancePointPlane(dArray3, dArray4, arrayList.get(i))) > planeDist)) continue;
                        return false;
                    }
                }
            }
            return true;
        }

        private static double[][] cartesian(double[][] dArray) {
            int n = dArray.length;
            double[][] dArray2 = new double[n][3];
            for (int i = 0; i < n; ++i) {
                dArray2[i] = SphereFit.cartesian(dArray[i]);
            }
            return dArray2;
        }

        private static double[] cartesian(double[] dArray) {
            return new double[]{dArray[2] * Math.sin(dArray[1]) * Math.cos(dArray[0]), dArray[2] * Math.sin(dArray[1]) * Math.sin(dArray[0]), dArray[2] * Math.cos(dArray[1])};
        }

        private static double[] spherical(double[] dArray) {
            double d = Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1] + dArray[2] * dArray[2]);
            return new double[]{Math.atan2(dArray[1], dArray[0]), Math.acos(dArray[2] / d), d};
        }

        private static double avg(double[] dArray) {
            double d = 0.0;
            int n = dArray.length;
            for (int i = 0; i < n; ++i) {
                d += dArray[i];
            }
            return d / (double)n;
        }

        private static double stdDev(double[] dArray) {
            double d = SphereFit.avg(dArray);
            double d2 = 0.0;
            int n = dArray.length;
            for (int i = 0; i < n; ++i) {
                double d3 = dArray[i] - d;
                d2 += d3 * d3;
            }
            return Math.sqrt(d2 / (double)n);
        }

        private static double distancePointPoint(double[] dArray, double[] dArray2) {
            return SphereFit.magnitude(SphereFit.minus(dArray, dArray2));
        }

        private static double distancePointLine(double[] dArray, double[] dArray2, double[] dArray3) {
            return SphereFit.magnitude(SphereFit.cross(SphereFit.minus(dArray3, dArray), SphereFit.minus(dArray3, dArray2))) / SphereFit.magnitude(SphereFit.minus(dArray2, dArray));
        }

        private static double distancePointPlane(double[] dArray, double[] dArray2, double[] dArray3) {
            double d = SphereFit.magnitude(dArray2);
            return SphereFit.dot(SphereFit.minus(dArray3, dArray), new double[]{dArray2[0] / d, dArray2[1] / d, dArray2[2] / d});
        }

        private static double magnitude(double[] dArray) {
            return Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1] + dArray[2] * dArray[2]);
        }

        private static double[] minus(double[] dArray, double[] dArray2) {
            return new double[]{dArray[0] - dArray2[0], dArray[1] - dArray2[1], dArray[2] - dArray2[2]};
        }

        private static double[] cross(double[] dArray, double[] dArray2) {
            return new double[]{dArray[1] * dArray2[2] - dArray[2] * dArray2[1], dArray[2] * dArray2[0] - dArray[0] * dArray2[2], dArray[0] * dArray2[1] - dArray[1] * dArray2[0]};
        }

        private static double dot(double[] dArray, double[] dArray2) {
            return dArray[0] * dArray2[0] + dArray[1] * dArray2[1] + dArray[2] * dArray2[2];
        }

        private static double[] solve(double[][] dArray, double[] dArray2) {
            int n;
            int n2;
            int n3 = dArray.length;
            int n4 = dArray[0].length;
            int[] nArray = new int[n3];
            for (int i = 0; i < n3; ++i) {
                nArray[i] = i;
            }
            double[] dArray3 = new double[n3];
            for (int i = 0; i < n4; ++i) {
                double d;
                for (n2 = 0; n2 < n3; ++n2) {
                    dArray3[n2] = dArray[n2][i];
                }
                n2 = 0;
                while (n2 < n3) {
                    double[] dArray4 = dArray[n2];
                    n = Math.min(n2, i);
                    d = 0.0;
                    for (int j = 0; j < n; ++j) {
                        d += dArray4[j] * dArray3[j];
                    }
                    int n5 = n2++;
                    double d2 = dArray3[n5] - d;
                    dArray3[n5] = d2;
                    dArray4[i] = d2;
                }
                n2 = i;
                for (n = i + 1; n < n3; ++n) {
                    if (!(Math.abs(dArray3[n]) > Math.abs(dArray3[n2]))) continue;
                    n2 = n;
                }
                if (n2 != i) {
                    for (n = 0; n < n4; ++n) {
                        d = dArray[n2][n];
                        dArray[n2][n] = dArray[i][n];
                        dArray[i][n] = d;
                    }
                    n = nArray[n2];
                    nArray[n2] = nArray[i];
                    nArray[i] = n;
                }
                if (!(i < n3 & dArray[i][i] != 0.0)) continue;
                for (n = i + 1; n < n3; ++n) {
                    double[] dArray5 = dArray[n];
                    int n6 = i;
                    dArray5[n6] = dArray5[n6] / dArray[i][i];
                }
            }
            double[] dArray6 = new double[nArray.length];
            for (n2 = 0; n2 < nArray.length; ++n2) {
                dArray6[n2] = dArray2[nArray[n2]];
            }
            for (n2 = 0; n2 < n4; ++n2) {
                for (n = n2 + 1; n < n4; ++n) {
                    int n7 = n;
                    dArray6[n7] = dArray6[n7] - dArray6[n2] * dArray[n][n2];
                }
            }
            for (n2 = n4 - 1; n2 >= 0; --n2) {
                int n8 = n2;
                dArray6[n8] = dArray6[n8] / dArray[n2][n2];
                for (n = 0; n < n2; ++n) {
                    int n9 = n;
                    dArray6[n9] = dArray6[n9] - dArray6[n2] * dArray[n][n2];
                }
            }
            return dArray6;
        }
    }
}

