/*
 * Decompiled with CFR 0.152.
 */
package smx.tracker;

import java.util.EventListener;
import java.util.Hashtable;
import smx.tracker.CommandThread;
import smx.tracker.ProbeButtonInterface;
import smx.tracker.ProbeButtonStatusListener;
import smx.tracker.TrackerException;
import smx.tracker.TrackerInterface;
import smx.tracker.event.EventListenerList;
import smx.tracker.event.ProbeButtonEvent;
import smx.tracker.event.ProbeButtonListener;

class SixDOFManager
implements ProbeButtonInterface {
    private TrackerInterface m_trackerIntf;
    private CommandThread m_trackerMgr;
    private ProbeButtonStatusListener m_buttonAlarmListener;
    private EventListenerList m_buttonListeners;
    private boolean m_connected = false;
    public static Hashtable<Integer, String> AlarmTags = new Hashtable();

    public SixDOFManager(CommandThread commandThread, TrackerInterface trackerInterface) {
        this.m_trackerIntf = trackerInterface;
        this.m_trackerMgr = commandThread;
        this.m_buttonListeners = new EventListenerList();
        this.m_buttonAlarmListener = new ProbeButtonStatusListener(this);
    }

    private void connect() throws TrackerException {
        this.m_trackerMgr.addAlarmListener(this.m_buttonAlarmListener);
        int n = 0;
        for (int i = 21; i <= 24; ++i) {
            String string = "configure_alarm ";
            int n2 = i - 21;
            string = string + String.valueOf(i) + " enable " + AlarmTags.get(new Integer(n2)) + " high " + n;
            this.m_trackerIntf.trackerCommand(string, 18000);
        }
        this.m_connected = true;
    }

    boolean isSixDOFCapable() throws TrackerException {
        return this.m_trackerIntf.sixDofCapable();
    }

    void addSixDOFButtonListener(ProbeButtonListener probeButtonListener) throws TrackerException {
        if (!this.m_connected) {
            this.connect();
        }
        this.addListener(probeButtonListener);
    }

    @Override
    public void addListener(ProbeButtonListener probeButtonListener) {
        this.m_buttonListeners.add(ProbeButtonListener.class, probeButtonListener);
    }

    void removeSixDOFButtonListener(ProbeButtonListener probeButtonListener) throws TrackerException {
        this.removeListener(probeButtonListener);
    }

    @Override
    public void removeListener(ProbeButtonListener probeButtonListener) {
        this.m_buttonListeners.remove(ProbeButtonListener.class, probeButtonListener);
    }

    @Override
    public void invokeListener(ProbeButtonEvent probeButtonEvent) {
        EventListener[] eventListenerArray = this.m_buttonListeners.getListeners(ProbeButtonListener.class);
        for (int i = 0; i < eventListenerArray.length; ++i) {
            ((ProbeButtonListener)eventListenerArray[i]).buttonStatusChanged(probeButtonEvent);
        }
    }

    static {
        AlarmTags.put(0, "sixdof.probe_adapter.user_button.1.value");
        AlarmTags.put(1, "sixdof.probe_adapter.user_button.2.value");
        AlarmTags.put(2, "sixdof.probe_adapter.user_button.3.value");
        AlarmTags.put(3, "sixdof.probe_adapter.user_button.4.value");
    }
}

