/*
 * Decompiled with CFR 0.152.
 */
package smx.tracker;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.StringWriter;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import smx.ftp.Ftp;
import smx.ftp.FtpException;
import smx.ftp.FtpNoResponseException;
import smx.tracker.TrackerCypher;
import smx.tracker.TrackerException;

public class ProbeInfoParser {
    private Document templateDoc = null;
    private Document userDoc = null;
    private Ftp ftpClient;
    private final String templateFilePath = "C:\\Temp\\Probes\\ProbesTemplate.dat";
    private final String userFilePath = "C:\\Temp\\Probes\\ProbesUser.dat";
    private final String templateFileFtpPath = "\\data\\6dof_calibration_default.dat";
    private final String userFileFtpPath = "\\data\\6dof_calibration.dat";
    private final int NUM_ITEMS_PER_PROBE = 12;
    private final String rootProbesElement = "Probes";
    private final String probeElement = "Probe";
    private final String idElement = "ID";
    private final String nameElement = "Name";
    private final String adapterNameElement = "AdapterName";
    private final String diameterElement = "Diameter";
    private final String xElement = "X";
    private final String yElement = "Y";
    private final String zElement = "Z";
    private final String calDateElement = "CalDate";
    private final String calTempElement = "CalTemp";
    private final String typeElement = "Type";
    private final String activeElement = "Active";
    private final String lengthElement = "Length";
    private final String compensatedElement = "Compensated";
    private final String factoryElement = "Factory";
    private final int STANDARD = 0;
    private final int CUSTOM = 1;
    private final int SMART = 2;
    private final int ACTIVE = 1;
    private final int INACTIVE = 0;
    boolean resetProbes = false;
    String encodingName = "UTF-8";

    ProbeInfoParser(Ftp ftp) {
        this.ftpClient = ftp;
    }

    private void readFile() throws TrackerException {
        if (this.templateDoc == null) {
            this.templateDoc = this.readFileFtp("\\data\\6dof_calibration_default.dat", true);
        }
        this.userDoc = this.readFileFtp("\\data\\6dof_calibration.dat", false);
    }

    private Document readFile(String string, boolean bl) throws TrackerException {
        Document document = null;
        try {
            String string2;
            File file = new File(string);
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            StringBuffer stringBuffer = new StringBuffer();
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string2);
            }
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            if (stringBuffer.length() == 0 && bl) {
                throw new TrackerException("Failed to get probe information");
            }
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            if (stringBuffer.length() != 0) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(stringBuffer.toString().getBytes(this.encodingName));
                document = documentBuilder.parse(byteArrayInputStream);
                document.getDocumentElement().normalize();
            } else {
                document = documentBuilder.newDocument();
                Element element = document.createElement("Probes");
                document.appendChild(element);
            }
        }
        catch (Exception exception) {
            throw new TrackerException("Failed to get probe information");
        }
        return document;
    }

    private Document readFileFtp(String string, boolean bl) throws TrackerException {
        Document document = null;
        try {
            String string2 = TrackerCypher.readFileContents(this.ftpClient, string);
            if ((string2 == null || string2.length() == 0) && bl) {
                throw new TrackerException("Failed to get probe information");
            }
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            if (string2 != null && string2.length() != 0) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string2.getBytes(this.encodingName));
                document = documentBuilder.parse(byteArrayInputStream);
                document.getDocumentElement().normalize();
            } else {
                document = documentBuilder.newDocument();
                Element element = document.createElement("Probes");
                document.appendChild(element);
            }
        }
        catch (Exception exception) {
            throw new TrackerException("Failed to get probe information");
        }
        return document;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readFileContents(String string) throws TrackerException {
        int n = 0;
        StringBuffer stringBuffer = null;
        try {
            n = this.ftpClient.receiveStart(string);
            if (150 != n) {
                throw new TrackerException("Failed to get probe data");
            }
            stringBuffer = new StringBuffer();
            try {
                String string2;
                while (null != (string2 = this.ftpClient.receiveLine())) {
                    try {
                        if (string2 == null) continue;
                        stringBuffer.append(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                    }
                }
            }
            catch (FtpNoResponseException ftpNoResponseException) {
                // empty catch block
            }
        }
        catch (FtpException ftpException) {
            throw new TrackerException("Failed to get probe data");
        }
        finally {
            try {
                n = this.ftpClient.receiveEnd();
                if (226 != n) {
                    throw new TrackerException("Failed to get probe data");
                }
            }
            catch (FtpException ftpException) {
                throw new TrackerException("Failed to get probe data");
            }
        }
        if (stringBuffer != null && stringBuffer.length() != 0) {
            return stringBuffer.toString();
        }
        return null;
    }

    private void writeFileContents(String string) throws TrackerException {
        int n = 0;
        try {
            n = this.ftpClient.sendStart("\\data\\6dof_calibration.dat");
            if (150 != n) {
                throw new TrackerException("Failed to update probe data");
            }
            this.ftpClient.sendLine(string);
        }
        catch (FtpException ftpException) {
            throw new TrackerException("Failed to update probe data");
        }
        finally {
            try {
                n = this.ftpClient.sendEnd();
                if (226 != n) {
                    throw new TrackerException("Failed to update probe data");
                }
            }
            catch (FtpException ftpException) {
                throw new TrackerException("Failed to update probe data");
            }
        }
    }

    private void updateFile() throws TrackerException {
        this.updateFileFtp();
    }

    private void updateFileLocal() throws TrackerException {
        try {
            this.userDoc.getDocumentElement().normalize();
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource dOMSource = new DOMSource(this.userDoc);
            StreamResult streamResult = new StreamResult(new File("C:\\Temp\\Probes\\ProbesUser.dat"));
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", this.encodingName);
            transformer.transform(dOMSource, streamResult);
        }
        catch (Exception exception) {
            throw new TrackerException("Failed to update probe information");
        }
    }

    private void updateFileFtp() throws TrackerException {
        try {
            this.userDoc.getDocumentElement().normalize();
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", this.encodingName);
            DOMSource dOMSource = new DOMSource(this.userDoc);
            StringWriter stringWriter = new StringWriter();
            StreamResult streamResult = new StreamResult(stringWriter);
            transformer.transform(dOMSource, streamResult);
            String string = stringWriter.toString();
            ArrayList<String> arrayList = new ArrayList<String>(1);
            arrayList.add(string);
            TrackerCypher.writeFileContents(this.ftpClient, "\\data\\6dof_calibration.dat", arrayList);
        }
        catch (Exception exception) {
            throw new TrackerException("Failed to update probe information");
        }
    }

    protected Object[][] getProbes(boolean bl) throws TrackerException {
        Object[][] objectArray;
        this.readFile();
        Object[][] objectArray2 = null;
        Object[][] objectArray3 = null;
        int n = 0;
        if (this.templateDoc != null) {
            objectArray = this.templateDoc.getElementsByTagName("Probe");
            objectArray2 = this.getProbesFromList((NodeList)objectArray);
            n = objectArray2.length;
        }
        if (this.userDoc != null) {
            objectArray = this.userDoc.getElementsByTagName("Probe");
            objectArray3 = this.getProbesFromList((NodeList)objectArray, bl);
            n += objectArray3.length;
        }
        objectArray = new Object[n][];
        if (objectArray2 != null) {
            System.arraycopy(objectArray2, 0, objectArray, 0, objectArray2.length);
        }
        if (objectArray3 != null) {
            System.arraycopy(objectArray3, 0, objectArray, objectArray2.length, objectArray3.length);
        }
        return objectArray;
    }

    protected Object[][] getProbes(String string, boolean bl) throws TrackerException {
        Object[][] objectArray;
        this.readFile();
        Object[][] objectArray2 = null;
        Object[][] objectArray3 = null;
        int n = 0;
        if (this.templateDoc != null) {
            objectArray = this.templateDoc.getElementsByTagName("Probe");
            objectArray2 = this.getProbesFromList((NodeList)objectArray, string);
            n = objectArray2.length;
        }
        if (this.userDoc != null) {
            objectArray = this.userDoc.getElementsByTagName("Probe");
            objectArray3 = this.getProbesFromList((NodeList)objectArray, string, bl);
            n += objectArray3.length;
        }
        if (n <= 0) {
            throw new TrackerException("No probes found for the adpater " + string);
        }
        objectArray = new Object[n][];
        if (objectArray2 != null) {
            System.arraycopy(objectArray2, 0, objectArray, 0, objectArray2.length);
        }
        if (objectArray3 != null) {
            System.arraycopy(objectArray3, 0, objectArray, objectArray2.length, objectArray3.length);
        }
        return objectArray;
    }

    private Object[][] getProbesFromList(NodeList nodeList) {
        return this.getProbesFromList(nodeList, false);
    }

    private Object[][] getProbesFromList(NodeList nodeList, boolean bl) {
        int n;
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        Object[][] objectArray = null;
        for (n = 0; n < nodeList.getLength(); ++n) {
            NodeList nodeList2;
            int n2;
            Node node = nodeList.item(n);
            if (node.getNodeType() != 1) continue;
            boolean bl2 = this.checkIfProbeTypeSmart(node);
            if (!bl && bl2 || (n2 = (nodeList2 = node.getChildNodes()).getLength()) < 12) continue;
            Object[] objectArray2 = this.getProbeElements(nodeList2);
            arrayList.add(objectArray2);
        }
        n = arrayList.size();
        objectArray = new Object[n][];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = (Object[])arrayList.get(i);
        }
        return objectArray;
    }

    private Object[][] getProbesFromList(NodeList nodeList, String string) throws TrackerException {
        return this.getProbesFromList(nodeList, string, false);
    }

    private Object[][] getProbesFromList(NodeList nodeList, String string, boolean bl) throws TrackerException {
        int n;
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        Object[][] objectArray = null;
        for (n = 0; n < nodeList.getLength(); ++n) {
            Element element;
            String string2;
            NodeList nodeList2;
            int n2;
            Node node = nodeList.item(n);
            if (node.getNodeType() != 1) continue;
            boolean bl2 = this.checkIfProbeTypeSmart(node);
            if (!bl && bl2 || (n2 = (nodeList2 = node.getChildNodes()).getLength()) < 12 || !(string2 = (element = (Element)node).getElementsByTagName("AdapterName").item(0).getTextContent()).equals(string)) continue;
            Object[] objectArray2 = this.getProbeElements(nodeList2);
            arrayList.add(objectArray2);
        }
        n = arrayList.size();
        objectArray = new Object[n][];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = (Object[])arrayList.get(i);
        }
        return objectArray;
    }

    private boolean checkIfProbeTypeSmart(Node node) {
        Element element = (Element)node;
        String string = element.getElementsByTagName("Type").item(0).getTextContent();
        int n = Integer.parseInt(string);
        return n == 2;
    }

    private Object[] getProbeElements(NodeList nodeList) {
        int n = nodeList.getLength();
        ArrayList<Object> arrayList = new ArrayList<Object>(15);
        int n2 = 0;
        String string = nodeList.item(n2).getTextContent();
        arrayList.add(nodeList.item(++n2).getTextContent());
        arrayList.add(nodeList.item(++n2).getTextContent());
        arrayList.add(Double.valueOf(nodeList.item(++n2).getTextContent()));
        arrayList.add(Double.valueOf(nodeList.item(++n2).getTextContent()));
        arrayList.add(Double.valueOf(nodeList.item(++n2).getTextContent()));
        arrayList.add(Double.valueOf(nodeList.item(++n2).getTextContent()));
        arrayList.add(Double.valueOf(nodeList.item(++n2).getTextContent()));
        arrayList.add(Double.valueOf(nodeList.item(++n2).getTextContent()));
        arrayList.add(Integer.valueOf(nodeList.item(++n2).getTextContent()));
        arrayList.add(Integer.valueOf(nodeList.item(++n2).getTextContent()));
        arrayList.add(Double.valueOf(nodeList.item(++n2).getTextContent()));
        if (++n2 >= n) {
            arrayList.add(new Integer(0));
        } else {
            arrayList.add(Integer.valueOf(nodeList.item(n2).getTextContent()));
        }
        if (++n2 >= n) {
            arrayList.add(new Integer(0));
        } else {
            arrayList.add(Integer.valueOf(nodeList.item(n2).getTextContent()));
        }
        ++n2;
        Object[] objectArray = arrayList.toArray();
        return objectArray;
    }

    protected void addProbe(String string, String string2, double d, double d2, boolean bl) throws TrackerException {
        this.addProbe(string, string2, d, false, d2, bl);
    }

    protected void addProbe(String string, String string2, double d, boolean bl, double d2, boolean bl2) throws TrackerException {
        this.validateProbeElements(string, string2, d, d2);
        this.readFile();
        boolean bl3 = this.checkIfProbeExists(string, string2);
        if (bl3) {
            throw new TrackerException("Cannot add probe. Probe exists with this name for this adapter");
        }
        if (this.userDoc != null) {
            Node node = this.userDoc.getFirstChild();
            Element element = this.userDoc.createElement("Probe");
            Element element2 = this.userDoc.createElement("ID");
            element2.appendChild(this.userDoc.createTextNode(string + string2));
            element.appendChild(element2);
            element2 = this.userDoc.createElement("Name");
            element2.appendChild(this.userDoc.createTextNode(string));
            element.appendChild(element2);
            element2 = this.userDoc.createElement("AdapterName");
            element2.appendChild(this.userDoc.createTextNode(string2));
            element.appendChild(element2);
            element2 = this.userDoc.createElement("Diameter");
            element2.appendChild(this.userDoc.createTextNode(String.valueOf(d)));
            element.appendChild(element2);
            element2 = this.userDoc.createElement("X");
            element2.appendChild(this.userDoc.createTextNode(String.valueOf(0)));
            element.appendChild(element2);
            element2 = this.userDoc.createElement("Y");
            element2.appendChild(this.userDoc.createTextNode(String.valueOf(0)));
            element.appendChild(element2);
            element2 = this.userDoc.createElement("Z");
            element2.appendChild(this.userDoc.createTextNode(String.valueOf(0)));
            element.appendChild(element2);
            element2 = this.userDoc.createElement("CalDate");
            element2.appendChild(this.userDoc.createTextNode(String.valueOf(0)));
            element.appendChild(element2);
            element2 = this.userDoc.createElement("CalTemp");
            element2.appendChild(this.userDoc.createTextNode(String.valueOf(0)));
            element.appendChild(element2);
            int n = 1;
            if (bl) {
                n = 2;
            }
            element2 = this.userDoc.createElement("Type");
            element2.appendChild(this.userDoc.createTextNode(String.valueOf(n)));
            element.appendChild(element2);
            element2 = this.userDoc.createElement("Active");
            element2.appendChild(this.userDoc.createTextNode(String.valueOf(0)));
            element.appendChild(element2);
            element2 = this.userDoc.createElement("Length");
            element2.appendChild(this.userDoc.createTextNode(String.valueOf(d2)));
            element.appendChild(element2);
            element2 = this.userDoc.createElement("Compensated");
            element2.appendChild(this.userDoc.createTextNode(String.valueOf(0)));
            element.appendChild(element2);
            element2 = this.userDoc.createElement("Factory");
            element2.appendChild(this.userDoc.createTextNode(String.valueOf(bl2 ? 1 : 0)));
            element.appendChild(element2);
            node.appendChild(element);
            this.updateFile();
        }
    }

    protected void removeProbe(String string, String string2) throws TrackerException {
        this.readFile();
        if (this.checkIfProbeExists(string, string2, this.templateDoc)) {
            throw new TrackerException("Cannot remove a standard probe type");
        }
        Node node = this.getProbeNode(string, string2, this.userDoc);
        if (node == null) {
            throw new TrackerException("Probe does not exist");
        }
        if (!this.checkIfProbeTypeCustom(node)) {
            throw new TrackerException("Cannot remove probe if not custom type");
        }
        if (this.checkIfProbeIsActive(node)) {
            throw new TrackerException("Cannot remove probe if active");
        }
        if (node != null) {
            node.getParentNode().removeChild(node);
            this.updateFile();
        }
    }

    protected boolean modifyProbe(String string, String string2, String string3, String string4, double d, double d2) throws TrackerException {
        Node node;
        this.readFile();
        if (this.checkIfProbeExists(string2, string4, this.templateDoc)) {
            throw new TrackerException("Cannot modify a standard probe type");
        }
        Node node2 = this.getProbeNode(string2, string4, this.userDoc);
        if (node2 == null) {
            throw new TrackerException("Probe does not exist");
        }
        if (!this.checkIfProbeTypeCustom(node2)) {
            throw new TrackerException("Cannot modify probe if not custom type");
        }
        this.validateProbeElements(string, string3, d, d2);
        if (!(string.equals(string2) && string3.equals(string4) || (node = this.getProbeNode(string, string3, this.userDoc)) == null)) {
            throw new TrackerException("Cannot modify probe. A probe with this name exists for this adpater");
        }
        if (node2 != null) {
            node = (Element)node2;
            node.getElementsByTagName("Name").item(0).setTextContent(string);
            node.getElementsByTagName("AdapterName").item(0).setTextContent(string3);
            node.getElementsByTagName("Diameter").item(0).setTextContent(String.valueOf(d));
            node.getElementsByTagName("ID").item(0).setTextContent(string + string3);
            node.getElementsByTagName("Length").item(0).setTextContent(String.valueOf(d2));
            this.updateFile();
            return true;
        }
        return false;
    }

    private void validateProbeElements(String string, String string2, double d, double d2) throws TrackerException {
        if (string.equals("")) {
            throw new TrackerException("Probe name cannot be empty");
        }
        if (string2.equals("")) {
            throw new TrackerException("Adpater name cannot be empty");
        }
        if (d <= 0.0) {
            throw new TrackerException("Diameter should be greater than 0");
        }
    }

    private boolean checkIfProbeExists(String string, String string2) {
        if (this.checkIfProbeExists(string, string2, this.templateDoc)) {
            return true;
        }
        return this.checkIfProbeExists(string, string2, this.userDoc);
    }

    private boolean checkIfProbeExists(String string, String string2, Document document) {
        Node node;
        return document != null && (node = this.getProbeNode(string, string2, document)) != null;
    }

    private boolean checkIfProbeTypeCustom(String string, String string2) {
        Element element;
        String string3;
        int n;
        Node node = this.getProbeNode(string, string2, this.userDoc);
        return node != null && (n = Integer.parseInt(string3 = (element = (Element)node).getElementsByTagName("Type").item(0).getTextContent())) == 1;
    }

    public void changeActiveProbe(String string, String string2, boolean bl) throws TrackerException {
        this.readFile();
        if (this.checkIfProbeExists(string, string2, this.templateDoc)) {
            String string3 = bl ? "Cannot activate a standard probe type" : "Cannot deactivate a standard probe type";
            throw new TrackerException(string3);
        }
        Node node = this.getProbeNode(string, string2, this.userDoc);
        if (node == null) {
            throw new TrackerException("Probe does not exist");
        }
        if (this.userDoc != null) {
            if (bl) {
                this.resetAllProbesInList(string2);
                Element element = (Element)node;
                element.getElementsByTagName("Active").item(0).setTextContent(Integer.toString(1));
            } else {
                Element element = (Element)node;
                element.getElementsByTagName("Active").item(0).setTextContent(Integer.toString(0));
            }
            this.updateFile();
        }
    }

    public Object[] getActiveProbe(boolean bl) throws TrackerException {
        boolean bl2 = false;
        Object[] objectArray = null;
        this.readFile();
        if (this.userDoc != null) {
            NodeList nodeList = this.userDoc.getElementsByTagName("Probe");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                Element element = (Element)node;
                String string = element.getElementsByTagName("Type").item(0).getTextContent();
                String string2 = element.getElementsByTagName("Active").item(0).getTextContent();
                int n = Integer.parseInt(string2);
                if (n != 1) continue;
                int n2 = Integer.parseInt(string);
                if (!bl && n2 == 2) break;
                bl2 = true;
                NodeList nodeList2 = node.getChildNodes();
                int n3 = nodeList2.getLength();
                if (n3 < 12) {
                    return null;
                }
                objectArray = this.getProbeElements(nodeList2);
                break;
            }
        }
        if (!bl2) {
            throw new TrackerException("There is no active probe");
        }
        return objectArray;
    }

    private boolean checkIfProbeIsActive(String string, String string2) {
        Element element;
        String string3;
        int n;
        Node node;
        return this.userDoc != null && (node = this.getProbeNode(string, string2, this.userDoc)) != null && (n = Integer.parseInt(string3 = (element = (Element)node).getElementsByTagName("Active").item(0).getTextContent())) == 1;
    }

    private Node getProbeNode(String string, String string2, Document document) {
        if (document != null) {
            String string3 = string + string2;
            NodeList nodeList = document.getElementsByTagName("Probe");
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Element element;
                String string4;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || !(string4 = (element = (Element)node).getElementsByTagName("ID").item(0).getTextContent()).equals(string3)) continue;
                return node;
            }
        }
        return null;
    }

    private boolean checkIfProbeIsActive(Node node) {
        Element element;
        String string;
        int n;
        return node != null && (n = Integer.parseInt(string = (element = (Element)node).getElementsByTagName("Active").item(0).getTextContent())) == 1;
    }

    private boolean checkIfProbeTypeCustom(Node node) {
        Element element;
        String string;
        int n;
        return node != null && (n = Integer.parseInt(string = (element = (Element)node).getElementsByTagName("Type").item(0).getTextContent())) == 1;
    }

    protected void resetAllProbes() throws TrackerException {
        this.readFile();
        this.resetAllProbesInList();
        if (this.userDoc != null) {
            this.updateFile();
        }
    }

    private void resetAllProbesInList() {
        if (this.userDoc != null) {
            NodeList nodeList = this.userDoc.getElementsByTagName("Probe");
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                Element element = (Element)node;
                element.getElementsByTagName("Active").item(0).setTextContent(Integer.toString(0));
            }
        }
    }

    protected void addSmartProbe(String string, String string2, double d, double d2, boolean bl) throws TrackerException {
        this.readFile();
        if (this.userDoc != null && !this.checkIfProbeExists(string, string2, this.userDoc)) {
            this.addProbe(string, string2, d, true, d2, bl);
        }
    }

    public double[] getCalibrationValues(String string, String string2) throws TrackerException {
        this.readFile();
        if (this.checkIfProbeExists(string, string2, this.templateDoc)) {
            throw new TrackerException("Cannot activate a a standard probe type");
        }
        Node node = this.getProbeNode(string, string2, this.userDoc);
        if (node == null) {
            throw new TrackerException("Probe does not exist");
        }
        if (!this.checkIfProbeTypeCustom(node)) {
            throw new TrackerException("Cannot activate a probe if not custom type");
        }
        double[] dArray = new double[4];
        if (node != null) {
            Element element = (Element)node;
            dArray[0] = Double.parseDouble(element.getElementsByTagName("X").item(0).getTextContent());
            dArray[1] = Double.parseDouble(element.getElementsByTagName("Y").item(0).getTextContent());
            dArray[2] = Double.parseDouble(element.getElementsByTagName("Z").item(0).getTextContent());
            dArray[3] = Double.parseDouble(element.getElementsByTagName("CalDate").item(0).getTextContent());
        }
        return dArray;
    }

    public void updateProbeCalibration(String string, String string2, double d, double d2, double d3, double d4, double d5, boolean bl) throws TrackerException {
        this.readFile();
        if (this.checkIfProbeExists(string, string2, this.templateDoc)) {
            throw new TrackerException("Cannot modify a standard probe type");
        }
        Node node = this.getProbeNode(string, string2, this.userDoc);
        if (node == null) {
            throw new TrackerException("Probe does not exist");
        }
        if (!this.checkIfProbeTypeCustom(node)) {
            throw new TrackerException("Cannot modify probe if not custom type");
        }
        if (node != null) {
            Element element = (Element)node;
            element.getElementsByTagName("X").item(0).setTextContent(String.valueOf(d));
            element.getElementsByTagName("Y").item(0).setTextContent(String.valueOf(d2));
            element.getElementsByTagName("Z").item(0).setTextContent(String.valueOf(d3));
            element.getElementsByTagName("CalTemp").item(0).setTextContent(String.valueOf(d4));
            element.getElementsByTagName("CalDate").item(0).setTextContent(String.valueOf(d5));
            if (element.getElementsByTagName("Compensated").item(0) == null) {
                Element element2 = this.userDoc.createElement("Compensated");
                element2.appendChild(this.userDoc.createTextNode(String.valueOf(bl ? 1 : 0)));
                node.appendChild(element2);
            } else {
                element.getElementsByTagName("Compensated").item(0).setTextContent(String.valueOf(bl ? 1 : 0));
            }
            this.updateFile();
        }
    }

    private void resetAllProbesInList(String string) {
        if (this.userDoc != null) {
            NodeList nodeList = this.userDoc.getElementsByTagName("Probe");
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                String string2;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                Element element = (Element)node;
                String string3 = element.getElementsByTagName("Name").item(0).getTextContent();
                String string4 = element.getElementsByTagName("ID").item(0).getTextContent();
                if (!string4.equals(string2 = string3 + string)) continue;
                element.getElementsByTagName("Active").item(0).setTextContent(Integer.toString(0));
            }
        }
    }

    public Object[] getActiveProbe(boolean bl, String string) throws TrackerException {
        boolean bl2 = false;
        Object[] objectArray = null;
        this.readFile();
        if (this.userDoc != null) {
            NodeList nodeList = this.userDoc.getElementsByTagName("Probe");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                Element element = (Element)node;
                String string2 = element.getElementsByTagName("AdapterName").item(0).getTextContent();
                String string3 = element.getElementsByTagName("Type").item(0).getTextContent();
                String string4 = element.getElementsByTagName("Active").item(0).getTextContent();
                int n = Integer.parseInt(string4);
                if (!string2.equals(string) || n != 1) continue;
                int n2 = Integer.parseInt(string3);
                if (!bl && n2 == 2) break;
                bl2 = true;
                NodeList nodeList2 = node.getChildNodes();
                int n3 = nodeList2.getLength();
                if (n3 < 12) {
                    return null;
                }
                objectArray = this.getProbeElements(nodeList2);
                break;
            }
        }
        if (!bl2) {
            throw new TrackerException("There is no active probe");
        }
        return objectArray;
    }

    protected void removeAllProbes() throws TrackerException {
        this.readFile();
        if (this.userDoc != null) {
            NodeList nodeList = this.userDoc.getElementsByTagName("Probe");
            int n = nodeList.getLength();
            for (int i = n - 1; i >= 0; --i) {
                Element element;
                String string;
                int n2;
                Node node = nodeList.item(i);
                if (node == null || node.getNodeType() != 1 || (n2 = Integer.parseInt(string = (element = (Element)node).getElementsByTagName("Type").item(0).getTextContent())) != 1) continue;
                node.getParentNode().removeChild(node);
            }
            this.updateFile();
        }
    }

    protected void removeAllFactoryProbes() throws TrackerException {
        this.readFile();
        if (this.userDoc != null) {
            NodeList nodeList = this.userDoc.getElementsByTagName("Probe");
            int n = nodeList.getLength();
            for (int i = n - 1; i >= 0; --i) {
                Node node = nodeList.item(i);
                if (node == null || node.getNodeType() != 1) continue;
                Element element = (Element)node;
                String string = element.getElementsByTagName("Type").item(0).getTextContent();
                Node node2 = element.getElementsByTagName("Factory").item(0);
                if (node2 == null) continue;
                String string2 = node2.getTextContent();
                int n2 = Integer.parseInt(string);
                int n3 = Integer.parseInt(string2);
                if (n2 != 1 || n3 != 1) continue;
                node.getParentNode().removeChild(node);
            }
            this.updateFile();
        }
    }
}

