/*
 * Decompiled with CFR 0.152.
 */
package smx.tracker;

import smx.tracker.DataTag;
import smx.tracker.DataTagDouble;
import smx.tracker.DataTagUnsigned16;
import smx.tracker.TrackerException;
import smx.tracker.TrackerInterface;

public class PerformanceParameters {
    public static boolean factoryAccess = false;
    public static final int ADM_OFFSET = 0;
    public static final int ADM_SCALE = 1;
    public static final int ADM_GUARD_BAND = 2;
    public static final int IFM_OFFSET = 3;
    public static final int IFM_SCALE = 4;
    public static final int IFM_GUARD_BAND = 5;
    public static final int TRANSVERSE_OFFSET = 6;
    public static final int TRANSVERSE_SCALE = 7;
    public static final int TRANSVERSE_GUARD_BAND = 8;
    public static final int LEVEL_OFFSET = 9;
    public static final int LEVEL_GUARD_BAND = 10;
    public static final int R0_COMP_MPE = 11;
    public static final int R0_CAL_MPE = 12;
    public static final int R0_GUARD_BAND = 13;
    public static final int AXOF_MPE = 14;
    public static final int AXOF_GUARD_BAND = 15;
    public static final int PTGIT_BEFORE_RETRACE_MPE = 16;
    public static final int TOTAL_SPECS = 17;
    static double[] V1_TRACKER_PARAMETERS = new double[]{4.0E-5, 2.2E-6, 0.15, 2.0E-5, 1.6E-6, 0.15, 3.5E-5, 7.0E-6, 0.0, 9.7E-6, 0.0, 1.25E-5, 0.0, 0.15, 7.5E-6, 0.15, 6.0E-5};
    static double[] V2_TRACKER_PARAMETERS = new double[]{2.0E-5, 8.0E-7, 0.15, 4.0E-6, 8.0E-7, 0.15, 3.6E-5, 6.0E-6, 0.0, 9.7E-6, 0.0, 1.25E-5, 2.0E-5, 0.15, 7.5E-6, 0.15, 6.0E-5};
    static double[] V3_TRACKER_PARAMETERS = new double[]{1.6E-5, 8.0E-7, 0.2, 4.0E-6, 8.0E-7, 0.2, 2.0E-5, 5.0E-6, 0.2, 9.7E-6, 0.0, 1.6E-5, 1.6E-5, 0.15, 7.5E-6, 0.15, 5.0E-5};
    public static boolean performanceParameterState = false;
    static PerformanceParameters pp = null;
    static boolean statusState = true;
    static int firstStatus = 0;
    static double[] parameters = V1_TRACKER_PARAMETERS;
    static DataTag[] performanceParameterStatusTags = new DataTag[]{new DataTagUnsigned16("system.spec.adm.offset.status"), new DataTagUnsigned16("system.spec.adm.scale.status"), new DataTagUnsigned16("system.spec.adm.guard_band.status"), new DataTagUnsigned16("system.spec.ifm.offset.status"), new DataTagUnsigned16("system.spec.ifm.scale.status"), new DataTagUnsigned16("system.spec.ifm.guard_band.status"), new DataTagUnsigned16("system.spec.transverse.offset.status"), new DataTagUnsigned16("system.spec.transverse.scale.status"), new DataTagUnsigned16("system.spec.transverse.guard_band.status"), new DataTagUnsigned16("system.spec.level.offset.status"), new DataTagUnsigned16("system.spec.level.guard_band.status"), new DataTagUnsigned16("system.spec.R0.comp_mpe.status"), new DataTagUnsigned16("system.spec.R0.cal_mpe.status"), new DataTagUnsigned16("system.spec.R0.guard_band.status"), new DataTagUnsigned16("system.spec.axof.comp_mpe.status"), new DataTagUnsigned16("system.spec.axof.guard_band.status"), new DataTagUnsigned16("system.spec.ptg_it.before_retrace.comp_mpe.status")};
    static DataTag[] performanceParameterSpecTags = new DataTag[]{new DataTagDouble("system.spec.adm.offset.value"), new DataTagDouble("system.spec.adm.scale.value"), new DataTagDouble("system.spec.adm.guard_band.value"), new DataTagDouble("system.spec.ifm.offset.value"), new DataTagDouble("system.spec.ifm.scale.value"), new DataTagDouble("system.spec.ifm.guard_band.value"), new DataTagDouble("system.spec.transverse.offset.value"), new DataTagDouble("system.spec.transverse.scale.value"), new DataTagDouble("system.spec.transverse.guard_band.value"), new DataTagDouble("system.spec.level.offset.value"), new DataTagDouble("system.spec.level.guard_band.value"), new DataTagDouble("system.spec.R0.comp_mpe.value"), new DataTagDouble("system.spec.R0.cal_mpe.value"), new DataTagDouble("system.spec.R0.guard_band.value"), new DataTagDouble("system.spec.axof.comp_mpe.value"), new DataTagDouble("system.spec.axof.guard_band.value"), new DataTagDouble("system.spec.ptg_it.before_retrace.comp_mpe.value")};

    static DataTag[] getPerformanceParametersStatusTags() {
        return performanceParameterStatusTags;
    }

    static DataTag[] getPerformanceParametersSpecTags() {
        return performanceParameterSpecTags;
    }

    static DataTag[] getUserPerformanceParametersStatusTags() {
        DataTag[] dataTagArray = new DataTag[16];
        for (int i = 0; i < 16; ++i) {
            dataTagArray[i] = performanceParameterStatusTags[i];
        }
        return dataTagArray;
    }

    static DataTag[] getPerformanceParametersAllTags() {
        DataTag[] dataTagArray = PerformanceParameters.getPerformanceParametersStatusTags();
        DataTag[] dataTagArray2 = PerformanceParameters.getPerformanceParametersSpecTags();
        int n = dataTagArray.length + dataTagArray2.length;
        DataTag[] dataTagArray3 = new DataTag[n];
        int n2 = 0;
        for (int i = 0; i < n / 2; ++i) {
            dataTagArray3[n2++] = dataTagArray2[i];
            dataTagArray3[n2++] = dataTagArray[i];
        }
        return dataTagArray3;
    }

    static double[] getV1PerformanceParameters() {
        return V1_TRACKER_PARAMETERS;
    }

    static double[] getV2PerformanceParameters() {
        return V2_TRACKER_PARAMETERS;
    }

    static double[] getV3PerformanceParameters() {
        return V3_TRACKER_PARAMETERS;
    }

    static double transverseMPE(double d) {
        return PerformanceParameters.transverseMPE(d, false);
    }

    static double transverseMPE(double d, boolean bl) {
        double d2 = PerformanceParameters.calculateMPE(parameters[6], parameters[7], parameters[8], d, bl);
        return d2;
    }

    static double admMPE(double d) {
        return PerformanceParameters.admMPE(d, false);
    }

    static double admMPE(double d, boolean bl) {
        double d2 = PerformanceParameters.calculateMPE(parameters[0], parameters[1], parameters[2], d, bl);
        return d2;
    }

    static double ifmMPE(double d) {
        return PerformanceParameters.ifmMPE(d, false);
    }

    static double ifmMPE(double d, boolean bl) {
        double d2 = PerformanceParameters.calculateMPE(parameters[3], parameters[4], parameters[5], d, bl);
        return d2;
    }

    private static double calculateMPE(double d, double d2, double d3, double d4, boolean bl) {
        double d5;
        double d6 = d5 = d + d2 * d4;
        if (factoryAccess && !bl) {
            d6 = (1.0 - d3) * d5;
        }
        return d6;
    }

    static double r0FsBsMPE() {
        return 2.0 * parameters[14];
    }

    static double r0InOutMPE() {
        double d = PerformanceParameters.calculateMPE(2.0 * parameters[11], 0.0, parameters[13], 0.0, false);
        return d;
    }

    static double r0CalMPE() {
        return parameters[12];
    }

    static double levelMPE() {
        double d = PerformanceParameters.calculateMPE(parameters[9], 0.0, parameters[10], 0.0, false);
        return d;
    }

    static double twoFaceMPE(double d) {
        return PerformanceParameters.twoFaceMPE(d, false);
    }

    static double twoFaceMPE(double d, boolean bl) {
        double d2 = PerformanceParameters.transverseMPE(d, bl);
        return 2.0 * d2;
    }

    static double ptgItBeforeRetraceMPE() {
        return parameters[16];
    }

    static void initPerformanceParameters(TrackerInterface trackerInterface) throws TrackerException {
        int n;
        factoryAccess = trackerInterface.factoryPrivilege();
        DataTag[] dataTagArray = PerformanceParameters.getPerformanceParametersStatusTags();
        Object[] objectArray = trackerInterface.readOneTimeData(dataTagArray);
        int n2 = 0;
        firstStatus = (Integer)objectArray[n2++];
        for (n = n2; n < objectArray.length && (factoryAccess || n < 16); ++n) {
            int n3 = (Integer)objectArray[n];
            if (n3 == firstStatus) continue;
            statusState = false;
            break;
        }
        performanceParameterState = statusState;
        if (statusState && firstStatus == 0 && (objectArray = trackerInterface.readOneTimeData(dataTagArray = PerformanceParameters.getPerformanceParametersSpecTags())) != null) {
            for (n = 0; n < 17; ++n) {
                PerformanceParameters.parameters[n] = (Double)objectArray[n];
            }
        }
    }
}

