/*
 * Decompiled with CFR 0.152.
 */
package smx.tracker;

import smx.tracker.MeasurePointStats;
import smx.tracker.UnsupportedFeatureException;

public class MeasurePointData {
    private double timeStamp;
    private double az;
    private double ze;
    private double dist;
    private int stat;
    private MeasurePointStats statisticsInfo;
    private double rotationA;
    private double rotationB;
    private double rotationC;
    private boolean sixDofCapable;
    private boolean sixDofData;
    public static final int DATA_ACCURATE = 0;
    public static final int DATA_INACCURATE = 1;
    public static final int DATA_ERROR = 2;

    MeasurePointData(double d, double d2, double d3, double d4, int n, MeasurePointStats measurePointStats) {
        this(d, d2, d3, d4, n, measurePointStats, 0.0, 0.0, 0.0, false, false);
    }

    MeasurePointData(double d, double d2, double d3, double d4, int n, MeasurePointStats measurePointStats, double d5, double d6, double d7, boolean bl, boolean bl2) {
        this.sixDofCapable = bl;
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException();
        }
        this.timeStamp = d;
        this.az = d2;
        this.ze = d3;
        this.dist = d4;
        this.rotationA = d5;
        this.rotationB = d6;
        this.rotationC = d7;
        this.stat = n;
        this.statisticsInfo = measurePointStats;
        this.sixDofData = bl2;
    }

    public double time() {
        return this.timeStamp;
    }

    public double azimuth() {
        return this.az;
    }

    public double zenith() {
        return this.ze;
    }

    public double distance() {
        return this.dist;
    }

    public int status() {
        return this.stat;
    }

    public MeasurePointStats statistics() {
        return this.statisticsInfo;
    }

    public double rotationA() throws UnsupportedFeatureException {
        if (!this.sixDofCapable) {
            throw new UnsupportedFeatureException("Feature not supported");
        }
        return this.rotationA;
    }

    public double rotationB() throws UnsupportedFeatureException {
        if (!this.sixDofCapable) {
            throw new UnsupportedFeatureException("Feature not supported");
        }
        return this.rotationB;
    }

    public double rotationC() throws UnsupportedFeatureException {
        if (!this.sixDofCapable) {
            throw new UnsupportedFeatureException("Feature not supported");
        }
        return this.rotationC;
    }

    public boolean sixDofData() {
        return this.sixDofData;
    }
}

