/*
 * Decompiled with CFR 0.152.
 */
package smx.tracker;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import smx.tracker.TrackerException;

public class EncoderInitializationKernel {
    static PrintWriter logWriter;

    public static double[] EncoderDatumParameters(PrintWriter printWriter, double[] dArray, long[] lArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, double[] dArray6, double[] dArray7, double d, double d2, double d3, String string) {
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        int n;
        int n2;
        logWriter = printWriter;
        Date date = new Date();
        EncoderInitializationKernel.log(date);
        EncoderInitializationKernel.log(",");
        EncoderInitializationKernel.log("Begin,EncoderDatumParameters,V01,");
        EncoderInitializationKernel.logln(string);
        int n3 = -1;
        for (n2 = 0; n2 < lArray.length; ++n2) {
            if (lArray[n2] != 1L) continue;
            n3 = n2;
            EncoderInitializationKernel.log("leading edge,");
            EncoderInitializationKernel.logln(n3);
            break;
        }
        if (n3 == -1) {
            EncoderInitializationKernel.logln("ERROR,leading edge not found.");
            EncoderInitializationKernel.log(date);
            EncoderInitializationKernel.log(",");
            EncoderInitializationKernel.logln("End,EncoderDatumParameters,");
            return null;
        }
        n2 = -1;
        for (int i = n3 + 1; i < lArray.length; ++i) {
            if (lArray[i] != 0L) continue;
            n2 = i;
            EncoderInitializationKernel.log("trailing edge,");
            EncoderInitializationKernel.logln(n2);
            break;
        }
        if (n2 == -1) {
            EncoderInitializationKernel.logln("ERROR,trailing edge not found.");
            EncoderInitializationKernel.log(date);
            EncoderInitializationKernel.log(",");
            EncoderInitializationKernel.logln("End,EncoderDatumParameters,");
            return null;
        }
        int[] nArray = new int[]{n3, 0, 0, 0, 0};
        int n4 = 1;
        double d9 = Math.atan2(dArray2[n3], dArray3[n3]);
        double d10 = 0.0;
        for (n = n3 + 1; n < n2; ++n) {
            d10 = Math.atan2(dArray2[n], dArray3[n]);
            d8 = Math.abs(d10 - d9);
            if (d8 > Math.PI) {
                nArray[n4++] = n;
                break;
            }
            d9 = d10;
        }
        d9 = Math.atan2(dArray4[n3], dArray5[n3]);
        d10 = 0.0;
        for (n = n3 + 1; n < n2; ++n) {
            d10 = Math.atan2(dArray4[n], dArray5[n]);
            d8 = Math.abs(d10 - d9);
            if (d8 > Math.PI) {
                nArray[n4++] = n;
                break;
            }
            d9 = d10;
        }
        d9 = Math.atan2(dArray6[n3], dArray7[n3]);
        d10 = 0.0;
        for (n = n3 + 1; n < n2; ++n) {
            d10 = Math.atan2(dArray6[n], dArray7[n]);
            d8 = Math.abs(d10 - d9);
            if (d8 > Math.PI) {
                nArray[n4++] = n;
                break;
            }
            d9 = d10;
        }
        nArray[n4++] = n2;
        int[] nArray2 = new int[n4];
        System.arraycopy(nArray, 0, nArray2, 0, n4);
        EncoderInitializationKernel.BubbleSort(nArray2);
        EncoderInitializationKernel.log("critical points,");
        EncoderInitializationKernel.PrintVector(nArray2, logWriter);
        int n5 = -1;
        int n6 = -1;
        for (int i = 1; i < nArray2.length; ++i) {
            int n7 = nArray2[i] - nArray2[i - 1];
            if (n7 <= n5) continue;
            n5 = n7;
            n6 = nArray2[i - 1] + n7 / 2 - 1;
        }
        EncoderInitializationKernel.log("datum point abs,");
        EncoderInitializationKernel.logln(n6);
        double d11 = (Math.atan2(dArray2[n6], dArray3[n6]) + Math.atan2(dArray4[n6], dArray5[n6]) + Math.atan2(dArray6[n6], dArray7[n6])) / 3.0;
        EncoderInitializationKernel.log("pQIV new,");
        EncoderInitializationKernel.logln(d11);
        double d12 = n6 - n3;
        EncoderInitializationKernel.log("pQIP new,");
        EncoderInitializationKernel.logln(d12);
        if (string.equalsIgnoreCase("zenith")) {
            EncoderInitializationKernel.log("zeF,");
            EncoderInitializationKernel.logln(d2);
            EncoderInitializationKernel.log("zeB,");
            EncoderInitializationKernel.logln(d3);
            d7 = EncoderInitializationKernel.NormalizeAngle(d2);
            d6 = EncoderInitializationKernel.NormalizeAngle(d3);
            EncoderInitializationKernel.log("zeFN,");
            EncoderInitializationKernel.logln(d7);
            EncoderInitializationKernel.log("zeBN,");
            EncoderInitializationKernel.logln(d6);
            d5 = d7 + d6;
            d4 = d - d5 / 2.0;
            EncoderInitializationKernel.log("dze2f,");
            EncoderInitializationKernel.logln(d5);
            EncoderInitializationKernel.log("pZE0 old,");
            EncoderInitializationKernel.logln(d);
            EncoderInitializationKernel.log("pZE0 new,");
            EncoderInitializationKernel.logln(d4);
        } else {
            EncoderInitializationKernel.log("azF,");
            EncoderInitializationKernel.logln(d2);
            d7 = EncoderInitializationKernel.NormalizeAngle(d2);
            EncoderInitializationKernel.log("azFN,");
            EncoderInitializationKernel.logln(d7);
            d6 = -1.5707963267948966;
            d4 = d + d6 - d7;
            d4 = EncoderInitializationKernel.NormalizeAngle(d4);
            EncoderInitializationKernel.log("pAZ0 old,");
            EncoderInitializationKernel.logln(d);
            EncoderInitializationKernel.log("pAZ0 new,");
            EncoderInitializationKernel.logln(d4);
        }
        d7 = dArray[n6];
        d6 = d4 - d;
        d5 = d7 + d6;
        d5 = EncoderInitializationKernel.NormalizeAngle(d5);
        EncoderInitializationKernel.log("pQREF new,");
        EncoderInitializationKernel.logln(d5);
        double[] dArray8 = new double[]{d12, d11, d5, d4};
        EncoderInitializationKernel.log(date);
        EncoderInitializationKernel.log(",");
        EncoderInitializationKernel.logln("End,EncoderDatumParameters,");
        return dArray8;
    }

    public static double EncoderOffsetFromIndexTraverse(String string, PrintWriter printWriter, double d, double d2, double d3, int n, double[] dArray, long[] lArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, double[] dArray6, double[] dArray7) throws TrackerException {
        double d4;
        double d5;
        double d6;
        int n2;
        int n3;
        logWriter = printWriter;
        Date date = new Date();
        EncoderInitializationKernel.log(date);
        EncoderInitializationKernel.log(",");
        EncoderInitializationKernel.log("Begin,EncoderOffsetFromIndexTraverse,V01,");
        EncoderInitializationKernel.logln(string);
        EncoderInitializationKernel.log("pQ0,");
        EncoderInitializationKernel.logln(d);
        EncoderInitializationKernel.log("pQREF,");
        EncoderInitializationKernel.logln(d2);
        EncoderInitializationKernel.log("pIV,");
        EncoderInitializationKernel.logln(d3);
        EncoderInitializationKernel.log("pIP,");
        EncoderInitializationKernel.logln(n);
        int n4 = -1;
        for (n3 = 0; n3 < lArray.length; ++n3) {
            if (lArray[n3] != 1L) continue;
            n4 = n3;
            EncoderInitializationKernel.log("leading edge,");
            EncoderInitializationKernel.logln(n4);
            break;
        }
        if (n4 == -1) {
            EncoderInitializationKernel.logln("ERROR,leading edge not found.");
            return d;
        }
        n3 = -1;
        int n5 = 0;
        for (n2 = n4 + 1; n2 < lArray.length; ++n2) {
            if (lArray[n2 - 1] != 1L || lArray[n2] != 0L) continue;
            n3 = n2;
            EncoderInitializationKernel.log("trailing edge,");
            EncoderInitializationKernel.logln(n3);
            if (++n5 <= 1) continue;
            throw new TrackerException("Vibrations Detected - Encoder initialization may be inaccurate.\nUser must run Quick Comp or Pointing Comp before valid data can be obtained.");
        }
        if (n3 == -1) {
            EncoderInitializationKernel.logln("ERROR,trailing edge not found.");
        }
        n2 = 200;
        int n6 = n4 + n;
        int n7 = n6 - n2 / 2;
        double[] dArray8 = new double[n2];
        System.arraycopy(dArray, n7, dArray8, 0, n2);
        for (int i = 0; i < dArray8.length; ++i) {
            dArray8[i] = Math.IEEEremainder(dArray8[i], Math.PI * 2);
        }
        double[] dArray9 = new double[n2];
        int n8 = 0;
        for (int i = n7; i < n7 + n2; ++i) {
            d6 = Math.atan2(dArray2[i], dArray3[i]);
            d5 = Math.atan2(dArray4[i], dArray5[i]);
            d4 = Math.atan2(dArray6[i], dArray7[i]);
            dArray9[n8++] = (d6 + d5 + d4) / 3.0;
        }
        EncoderInitializationKernel.log("rdg,");
        EncoderInitializationKernel.PrintVector(dArray8, logWriter);
        EncoderInitializationKernel.log("at,");
        EncoderInitializationKernel.PrintVector(dArray9, logWriter);
        double[] dArray10 = EncoderInitializationKernel.CalcRegressionParameters(logWriter, dArray8, dArray9);
        if (dArray10 == null) {
            EncoderInitializationKernel.logln("ERROR,fit failed.");
            return d;
        }
        EncoderInitializationKernel.log("fit c0,");
        EncoderInitializationKernel.log(dArray10[0]);
        EncoderInitializationKernel.log(",fit c1,");
        EncoderInitializationKernel.logln(dArray10[1]);
        d6 = (d3 - dArray10[0]) / dArray10[1];
        EncoderInitializationKernel.log("indexReading,");
        EncoderInitializationKernel.logln(d6);
        d5 = d6 - d2;
        d4 = d - d5;
        EncoderInitializationKernel.log("oldQ0,");
        EncoderInitializationKernel.logln(d);
        EncoderInitializationKernel.log("newQ0,");
        EncoderInitializationKernel.logln(d4);
        EncoderInitializationKernel.log(date);
        EncoderInitializationKernel.log(",");
        EncoderInitializationKernel.logln("End,EncoderOffsetFromIndexTraverse");
        return d4;
    }

    public static double EncoderOffsetFromVibratingTraverse(String string, PrintWriter printWriter, double d, double d2, double d3, int n, double[] dArray, long[] lArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, double[] dArray6, double[] dArray7, double[] dArray8) throws TrackerException {
        double[] dArray9;
        int n2;
        int n3;
        int n4;
        logWriter = printWriter;
        Date date = new Date();
        EncoderInitializationKernel.log(date);
        EncoderInitializationKernel.log(",");
        EncoderInitializationKernel.log("Begin,EncoderOffsetFromVibratingTraverse,V02,");
        EncoderInitializationKernel.logln(string);
        EncoderInitializationKernel.log("pQ0,");
        EncoderInitializationKernel.logln(d);
        EncoderInitializationKernel.log("pQREF,");
        EncoderInitializationKernel.logln(d2);
        EncoderInitializationKernel.log("pIV,");
        EncoderInitializationKernel.logln(d3);
        EncoderInitializationKernel.log("pIP,");
        EncoderInitializationKernel.logln(n);
        ArrayList<LineJumpDataPoint> arrayList = new ArrayList<LineJumpDataPoint>();
        int n5 = dArray.length;
        for (int i = 0; i < n5; ++i) {
            double d4 = Math.atan2(dArray2[i], dArray3[i]);
            double d5 = Math.atan2(dArray4[i], dArray5[i]);
            double d6 = Math.atan2(dArray6[i], dArray7[i]);
            arrayList.add(new LineJumpDataPoint(dArray[i], lArray[i], d4, d5, d6));
        }
        Collections.sort(arrayList);
        double[] dArray10 = new double[n5];
        long[] lArray2 = new long[n5];
        double[] dArray11 = new double[n5];
        double[] dArray12 = new double[n5];
        double[] dArray13 = new double[n5];
        for (int i = 0; i < n5; ++i) {
            LineJumpDataPoint lineJumpDataPoint = (LineJumpDataPoint)arrayList.get(i);
            dArray10[i] = lineJumpDataPoint.getEncoderReading();
            lArray2[i] = lineJumpDataPoint.getIndexFlag();
            dArray11[i] = lineJumpDataPoint.getArcTan1();
            dArray12[i] = lineJumpDataPoint.getArcTan2();
            dArray13[i] = lineJumpDataPoint.getArcTan3();
        }
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = 0.0;
        int n6 = 0;
        int n7 = 0;
        boolean bl = false;
        for (int i = 0; i < n5; ++i) {
            if (lArray2[i] == 1L) {
                if (!bl) {
                    d8 = dArray10[i];
                    bl = true;
                }
                d10 = dArray10[i];
                if (n7 == 0) {
                    d11 = dArray10[i];
                }
                d12 = dArray10[i];
                if (++n7 <= n6) continue;
                d7 = d11;
                d9 = d12;
                n6 = n7;
                continue;
            }
            n7 = 0;
        }
        double d13 = (d8 + d7) / 2.0;
        double d14 = (d10 + d9) / 2.0;
        EncoderInitializationKernel.logln("leading edge @  " + d13);
        EncoderInitializationKernel.logln("trailing edge @ " + d14);
        if (d13 == 0.0) {
            EncoderInitializationKernel.logln("ERROR,leading edge not found.");
            throw new TrackerException("Could Not Locate Leading Edge for Line Jump Correction");
        }
        if (d14 == 0.0) {
            EncoderInitializationKernel.logln("ERROR,trailing edge not found.");
        }
        double d15 = 0.0;
        for (n4 = 1; n4 < dArray8.length; ++n4) {
            if (!(dArray8[n4 - 1] <= d13) || !(dArray8[n4] >= d13)) continue;
            d15 = dArray8[n4 + n];
            break;
        }
        if (d15 == 0.0) {
            EncoderInitializationKernel.logln("ERROR,index center value not found.");
            throw new TrackerException("Could Not Locate Index Point Center Value for Line Jump Correction");
        }
        n4 = -1;
        for (n3 = 1; n3 < n5; ++n3) {
            if (!(dArray10[n3 - 1] <= d15) || !(dArray10[n3] >= d15)) continue;
            n4 = n3;
            break;
        }
        if (n4 == -1) {
            EncoderInitializationKernel.logln("ERROR,center index not found in encoder readings.");
            throw new TrackerException("Could Not Locate Center Index Encoder Reading for Line Jump Correction");
        }
        EncoderInitializationKernel.logln("center val @  " + dArray10[n4]);
        n3 = -1;
        int n8 = -1;
        int n9 = -1;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        for (n2 = n4; n2 >= 0; --n2) {
            if (Math.abs(dArray11[n2] - dArray11[n2 + 1]) > Math.PI && !bl2) {
                EncoderInitializationKernel.logln("found beginning discontinuity of read head 1");
                n3 = n2 + 1;
                bl2 = true;
            }
            if (Math.abs(dArray12[n2] - dArray12[n2 + 1]) > Math.PI && !bl3) {
                EncoderInitializationKernel.logln("found beginning discontinuity of read head 2");
                n8 = n2 + 1;
                bl3 = true;
            }
            if (Math.abs(dArray13[n2] - dArray13[n2 + 1]) > Math.PI && !bl4) {
                EncoderInitializationKernel.logln("found beginning discontinuity of read head 3");
                n9 = n2 + 1;
                bl4 = true;
            }
            if (bl2 && bl3 && bl4) break;
        }
        if (!bl2) {
            n3 = 0;
        }
        if (!bl3) {
            n8 = 0;
        }
        if (!bl4) {
            n9 = 0;
        }
        n2 = -1;
        int n10 = -1;
        int n11 = -1;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        for (int i = n4; i < n5; ++i) {
            if (Math.abs(dArray11[i] - dArray11[i - 1]) > Math.PI && !bl5) {
                EncoderInitializationKernel.logln("found end discontinuity of read head 1");
                n2 = i - 1;
                bl5 = true;
            }
            if (Math.abs(dArray12[i] - dArray12[i - 1]) > Math.PI && !bl6) {
                EncoderInitializationKernel.logln("found end discontinuity of read head 2");
                n10 = i - 1;
                bl6 = true;
            }
            if (Math.abs(dArray13[i] - dArray13[i - 1]) > Math.PI && !bl7) {
                EncoderInitializationKernel.logln("found end discontinuity of read head 3");
                n11 = i - 1;
                bl7 = true;
            }
            if (bl5 && bl6 && bl7) break;
        }
        if (!bl5) {
            n2 = n5 - 1;
        }
        if (!bl6) {
            n10 = n5 - 1;
        }
        if (!bl7) {
            n11 = n5 - 1;
        }
        if ((dArray9 = EncoderInitializationKernel.readHeadRegression(n3, n2, dArray10, dArray11)) == null) {
            EncoderInitializationKernel.logln("ERROR,fit1 failed.");
            throw new TrackerException("Fit 1 Failed in Line Jump Correction");
        }
        EncoderInitializationKernel.log("fit c0,");
        EncoderInitializationKernel.log(dArray9[0]);
        EncoderInitializationKernel.log(",fit c1,");
        EncoderInitializationKernel.logln(dArray9[1]);
        double[] dArray14 = EncoderInitializationKernel.readHeadRegression(n8, n10, dArray10, dArray12);
        if (dArray14 == null) {
            EncoderInitializationKernel.logln("ERROR,fit2 failed.");
            throw new TrackerException("Fit 2 Failed in Line Jump Correction");
        }
        EncoderInitializationKernel.log("fit c0,");
        EncoderInitializationKernel.log(dArray14[0]);
        EncoderInitializationKernel.log(",fit c1,");
        EncoderInitializationKernel.logln(dArray14[1]);
        double[] dArray15 = EncoderInitializationKernel.readHeadRegression(n9, n11, dArray10, dArray13);
        if (dArray15 == null) {
            EncoderInitializationKernel.logln("ERROR,fit3 failed.");
            throw new TrackerException("Fit 3 Failed in Line Jump Correction");
        }
        EncoderInitializationKernel.log("fit c0,");
        EncoderInitializationKernel.log(dArray15[0]);
        EncoderInitializationKernel.log(",fit c1,");
        EncoderInitializationKernel.logln(dArray15[1]);
        double[] dArray16 = new double[]{(dArray9[0] + dArray14[0] + dArray15[0]) / 3.0, (dArray9[1] + dArray14[1] + dArray15[1]) / 3.0};
        double d16 = (d3 - dArray16[0]) / dArray16[1];
        EncoderInitializationKernel.log("indexReading,");
        EncoderInitializationKernel.logln(d16);
        double d17 = Math.abs(d16 - Math.IEEEremainder(dArray10[n4], Math.PI * 2));
        EncoderInitializationKernel.logln("Difference between computed datum and estimate," + d17);
        double d18 = d16 - d2;
        double d19 = d - d18;
        EncoderInitializationKernel.log("oldQ0,");
        EncoderInitializationKernel.logln(d);
        EncoderInitializationKernel.log("newQ0,");
        EncoderInitializationKernel.logln(d19);
        EncoderInitializationKernel.log(date);
        EncoderInitializationKernel.log(",");
        EncoderInitializationKernel.logln("End,EncoderOffsetFromVibratingTraverse");
        return d19;
    }

    private static double[] readHeadRegression(int n, int n2, double[] dArray, double[] dArray2) {
        int n3 = n2 - n;
        double[] dArray3 = new double[n3];
        System.arraycopy(dArray, n, dArray3, 0, n3);
        for (int i = 0; i < dArray3.length; ++i) {
            dArray3[i] = Math.IEEEremainder(dArray3[i], Math.PI * 2);
        }
        double[] dArray4 = new double[n3];
        System.arraycopy(dArray2, n, dArray4, 0, n3);
        EncoderInitializationKernel.log("rdg,");
        EncoderInitializationKernel.PrintVector(dArray3, logWriter);
        EncoderInitializationKernel.log("at,");
        EncoderInitializationKernel.PrintVector(dArray4, logWriter);
        return EncoderInitializationKernel.CalcRegressionParameters(logWriter, dArray3, dArray4);
    }

    private static double[] CalcRegressionParameters(PrintWriter printWriter, double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[]{0.0, 0.0};
        int n = dArray.length;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i = 0; i < n; ++i) {
            d += dArray[i];
            d3 += dArray2[i];
            d4 += dArray[i] * dArray2[i];
            d2 += dArray[i] * dArray[i];
        }
        double d5 = (double)n * d2 - d * d;
        if (Math.abs(d5) < 1.0E-20) {
            EncoderInitializationKernel.logln("ERROR,CalcRegressionParameters,zero denominator.");
            return null;
        }
        double d6 = (d2 * d3 - d * d4) / d5;
        double d7 = ((double)n * d4 - d * d3) / d5;
        dArray3[0] = d6;
        dArray3[1] = d7;
        return dArray3;
    }

    static void PrintVector(int[] nArray, PrintWriter printWriter) {
        for (int i = 0; i < nArray.length; ++i) {
            EncoderInitializationKernel.log(nArray[i]);
            EncoderInitializationKernel.log(",");
        }
        EncoderInitializationKernel.logln("");
    }

    static void PrintVector(double[] dArray, PrintWriter printWriter) {
        for (int i = 0; i < dArray.length; ++i) {
            EncoderInitializationKernel.log(dArray[i]);
            EncoderInitializationKernel.log(",");
        }
        EncoderInitializationKernel.logln("");
    }

    private static void BubbleSort(int[] nArray) {
        boolean bl;
        do {
            bl = false;
            for (int i = 1; i < nArray.length; ++i) {
                if (nArray[i - 1] <= nArray[i]) continue;
                int n = nArray[i - 1];
                nArray[i - 1] = nArray[i];
                nArray[i] = n;
                bl = true;
            }
        } while (bl);
    }

    private static double NormalizeAngle(double d) {
        double d2 = Math.IEEEremainder(d, Math.PI * 2);
        if (d2 > Math.PI) {
            d2 -= Math.PI * 2;
        } else if (d2 < -Math.PI) {
            d2 += Math.PI * 2;
        }
        return d2;
    }

    private static void log(Date date) {
        if (logWriter != null) {
            logWriter.print(date);
        }
    }

    private static void log(String string) {
        if (logWriter != null) {
            logWriter.print(string);
        }
    }

    private static void logln(String string) {
        if (logWriter != null) {
            logWriter.println(string);
        }
    }

    private static void logln(int n) {
        if (logWriter != null) {
            logWriter.println(n);
        }
    }

    private static void log(double d) {
        if (logWriter != null) {
            logWriter.print(d);
        }
    }

    private static void logln(double d) {
        if (logWriter != null) {
            logWriter.println(d);
        }
    }

    private static class LineJumpDataPoint
    implements Comparable {
        private double encoderReading;
        private long indexFlag;
        private double arcTan1;
        private double arcTan2;
        private double arcTan3;

        public LineJumpDataPoint(double d, long l, double d2, double d3, double d4) {
            this.encoderReading = d;
            this.indexFlag = l;
            this.arcTan1 = d2;
            this.arcTan2 = d3;
            this.arcTan3 = d4;
        }

        public double getEncoderReading() {
            return this.encoderReading;
        }

        public long getIndexFlag() {
            return this.indexFlag;
        }

        public double getArcTan1() {
            return this.arcTan1;
        }

        public double getArcTan2() {
            return this.arcTan2;
        }

        public double getArcTan3() {
            return this.arcTan3;
        }

        public int compareTo(Object object) {
            LineJumpDataPoint lineJumpDataPoint = (LineJumpDataPoint)object;
            return Double.compare(this.encoderReading, lineJumpDataPoint.encoderReading);
        }
    }
}

