/*
 * Decompiled with CFR 0.152.
 */
package smx.tracker;

import java.awt.Component;
import java.io.IOException;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import smx.tracker.AbortedException;
import smx.tracker.AlarmType;
import smx.tracker.AsyncAlreadyStartedException;
import smx.tracker.AsyncThread;
import smx.tracker.DataTag;
import smx.tracker.DistanceMode;
import smx.tracker.ExtTempType;
import smx.tracker.InterfaceBusyException;
import smx.tracker.MeasureCfg;
import smx.tracker.MeasureData;
import smx.tracker.MeasurePointData;
import smx.tracker.MeasureThread;
import smx.tracker.MeasureTypeException;
import smx.tracker.Probe;
import smx.tracker.ProbeCompensationData;
import smx.tracker.SimplePointPairData;
import smx.tracker.TargetType;
import smx.tracker.Tracker;
import smx.tracker.TrackerApp;
import smx.tracker.TrackerAppFrame;
import smx.tracker.TrackerException;
import smx.tracker.TrackerInterface;
import smx.tracker.VideoCfg;
import smx.tracker.VideoData;
import smx.tracker.VideoThread;
import smx.tracker.event.AlarmListener;
import smx.tracker.event.ApplicationEvent;
import smx.tracker.event.ApplicationListener;
import smx.tracker.event.BkndMeasureDataListener;
import smx.tracker.event.BusyEvent;
import smx.tracker.event.BusyListener;
import smx.tracker.event.ChangeListener;
import smx.tracker.event.CommandCompleteEvent;
import smx.tracker.event.CommandCompleteListener;
import smx.tracker.event.ConnectEvent;
import smx.tracker.event.ConnectListener;
import smx.tracker.event.DiagnosticListener;
import smx.tracker.event.EventListenerList;
import smx.tracker.event.FactoryBkndMeasureDataListener;
import smx.tracker.event.MeasureDataListener;
import smx.tracker.event.ProbeButtonListener;
import smx.tracker.event.StatusListener;
import smx.tracker.event.VideoDataListener;
import smx.utility.ThreadComm;

class CommandThread
implements Runnable {
    public static final int ABORTABLE_FLAG = 0x10000000;
    public static final int NULL_COMMAND = 0;
    public static final int CONNECT = 1;
    public static final int DISCONNECT = 2;
    public static final int INITIALIZE = 0x10000003;
    public static final int TOGGLE_SIGHT_ORIENTATION = 0x10000004;
    public static final int MOVE = 0x10000005;
    public static final int HOME = 0x10000006;
    public static final int WRITE_ONE_TIME_DATA = 7;
    public static final int READ_ONE_TIME_DATA = 8;
    public static final int GENERAL_COMMAND = 0x10000009;
    public static final int START_MEASURE = 10;
    public static final int STOP_MEASURE = 11;
    public static final int SEARCH = 0x1000000C;
    public static final int START_BKND_MEASURE = 13;
    public static final int STOP_BKND_MEASURE = 14;
    public static final int START_ASYNC = 15;
    public static final int STOP_ASYNC = 16;
    public static final int MEASURE_LEVEL = 0x10000011;
    public static final int MEASURE_MATERIAL_TEMPERATURE = 18;
    public static final int CHANGE_MOTOR_STATE = 19;
    public static final int CHANGE_TRACKING_STATE = 20;
    public static final int CHANGE_DISTANCE_MEASURE_MODE = 21;
    public static final int CHANGE_TARGET_TYPE = 22;
    public static final int START_APPLICATION = 23;
    public static final int CHECK_CONNECTED = 24;
    public static final int CHECK_TARGET_PRESENT = 25;
    public static final int CHECK_TARGET_VALID = 26;
    public static final int CHECK_MOTORS_ON = 27;
    public static final int CHECK_TRACKING_ON = 28;
    public static final int CHECK_ADM_CAPABLE = 29;
    public static final int CHECK_INTERFEROMETER_CAPABLE = 30;
    public static final int WRITE_FILE = 0x1000001F;
    public static final int READ_FILE = 0x10000020;
    public static final int SET_ALARM_CFG = 33;
    public static final int GET_ALARM_CFG = 34;
    public static final int DIAGNOSTIC_HISTORY = 35;
    public static final int ALARM_HISTORY = 36;
    public static final int STATUS_HISTORY = 37;
    public static final int SET_EXCLUSIVE_ACCESS = 38;
    public static final int GET_DISTANCE_MODE = 39;
    public static final int GET_TARGET_TYPE = 40;
    public static final int CHECK_BACKSIGHT_ORIENTATION = 50;
    public static final int CHECK_LEVEL_CAPABLE = 51;
    public static final int CHECK_INITIALIZED = 52;
    public static final int GET_EXT_TEMP_TYPE = 53;
    public static final int SET_EXT_TEMP_TYPE = 54;
    public static final int CHECK_TEMP_CFG = 55;
    public static final int SAMPLE_RATE = 56;
    public static final int CHECK_STANDARD_PRIVILEGE = 57;
    public static final int CHECK_ADMIN_PRIVILEGE = 58;
    public static final int CHECK_FACTORY_PRIVILEGE = 59;
    public static final int MEASURE_EXT_TEMPERATURE_SENSOR = 60;
    public static final int GET_NUM_EXT_TEMP_SENSORS = 61;
    public static final int START_FACTORY_BKND_MEASURE = 62;
    public static final int STOP_FACTORY_BKND_MEASURE = 63;
    public static final int INITIALIZE_SMART = 0x10000040;
    public static final int FACTORY_CONNECT = 65;
    public static final int FACTORY_DISCONNECT = 66;
    public static final int CHANGE_AIR_TEMP_HARDWARE = 67;
    public static final int CHANGE_AIR_PRES_HARDWARE = 68;
    public static final int CHANGE_HUMIDITY_HARDWARE = 69;
    public static final int CHANGE_AIR_TEMP_MANUAL = 70;
    public static final int CHANGE_AIR_PRES_MANUAL = 71;
    public static final int CHANGE_HUMIDITY_MANUAL = 72;
    public static final int START_VIDEO = 73;
    public static final int STOP_VIDEO = 74;
    public static final int CHANGE_GESTURE_STATE = 75;
    public static final int CHECK_GESTURE_STATE_ON = 76;
    public static final int CHECK_WIRELESS_CAPABLE = 77;
    public static final int CHECK_VIDEO_CAPABLE = 78;
    public static final int CHECK_GESTURES_CAPABLE = 79;
    public static final int SEARCH_USING_CAMERA = 80;
    public static final int CHECK_ANGULAR_ACCURACY_ERROR = 81;
    public static final int GET_APPLICATION_RESULTS = 82;
    public static final int CHECK_ADM_AGAINST_IFM = 83;
    public static final int GET_SERIAL_NUMBER = 84;
    public static final int GET_WEATHER_INFO = 85;
    public static final int CHANGE_LED_STATE = 86;
    public static final int READY_TO_INITIALIZE = 87;
    public static final int RELEASE_LOCK = 88;
    public static final int START_SLEW = 89;
    public static final int STOP_SLEW = 90;
    public static final int GET_STABILITY_WAIT_STATE = 91;
    public static final int HOME_IF_TARGET_PRESENT = 92;
    public static final int RESET_CAMERAS = 93;
    public static final int COMBO_SEARCH = 94;
    public static final int COMBO_SEARCH_INTERNAL = 95;
    public static final int DID_LAST_AAC_SINCE_INIT_PASS = 96;
    public static final int GET_BATTERY_CHARGE_REMAINING = 97;
    public static final int CHANGE_BATTERY_ALARM_CFG = 98;
    public static final int GET_BATTERY_ALARM_CFG = 99;
    public static final int GET_BATTERY_STATE = 100;
    public static final int CHANGE_POWER_BUTTON_STATE = 101;
    public static final int GET_POWER_BUTTON_STATE = 102;
    public static final int REBOOT_TRACKER = 103;
    public static final int GET_FOLLOW_ME_MODE = 104;
    public static final int CHANGE_FOLLOW_ME_MODE = 105;
    public static final int GET_FOLLOW_ME_SEARCH_RADIUS = 106;
    public static final int CHANGE_FOLLOW_ME_SEARCH_RADIUS = 107;
    public static final int CHECK_FOLLOW_ME_CAPABLE = 108;
    public static final int CHECK_SIX_DOF_CAPABLE = 109;
    public static final int GET_AVAILABLE_PROBES = 110;
    public static final int ADD_NEW_PROBE = 111;
    public static final int MODIFY_PROBE = 112;
    public static final int REMOVE_PROBE = 113;
    public static final int GET_ACTIVE_PROBE = 114;
    public static final int CHANGE_ACTIVE_PROBE = 115;
    public static final int GET_ACTIVE_PROBE_ADAPTER = 116;
    public static final int CHECK_PROBE_ADAPTER_CONNECTED = 117;
    public static final int CHECK_SMART_PROBE_CONNECTED = 118;
    public static final int CALC_PROBE_CALIBRATION_PARAMS = 119;
    public static final int UPDATE_PROBE_CALIBRATION = 120;
    public static final int CALC_PROBE_COMPENSATION_PARAMS = 121;
    public static final int CALC_ISO_PROBE_CALIBRATION_PARAMS = 122;
    public static final int CHECK_SIXDOF_ENABLED = 123;
    public static final int CHANGE_SIXDOF_ENABLE_STATE = 124;
    public static final int PROBE_BATTERY_CHARGE_REMAINING = 125;
    public static final int ENABLE_PROBE_BUTTON_EVENTS = 126;
    public static final int REMOVE_ALL_PROBES = 127;
    public static final int REMOVE_ALL_FACTORY_PROBES = 128;
    public static final int UPDATE_PROBE_COMPENSATION = 129;
    public static final int GET_FOLLOW_ME_PASSIVE_TO_ACTIVE_DELAY = 130;
    public static final int SET_FOLLOW_ME_PASSIVE_TO_ACTIVE_DELAY = 131;
    public static final int GET_IP_ADDRESS = 132;
    public static final int PROBE_BATTERY_STATE = 133;
    public static final int PROBE_BATTERY_STATE_CHANGE_EVENT_SUPPORTED = 134;
    public static final int WIRLESS_STATE_CHANGE_SUPPORTED = 135;
    public static final int CHANGE_WIRELESS_STATE = 136;
    public static final int CHECK_WIRELESS_ON = 137;
    public static final int GENERAL_MEASUREMENT = 0;
    public static final int POINT_MEASUREMENT = 1;
    private ThreadComm command = new ThreadComm();
    private ThreadComm response = new ThreadComm();
    private Thread thread;
    private boolean shutdown = false;
    private boolean commandInProgress = false;
    private boolean abortInProgress = false;
    private boolean commandInProgressIsAbortable = false;
    public TrackerInterface trackerIntf = null;
    private EventListenerList listenerList = new EventListenerList();
    private EventListenerList dataListenerList = new EventListenerList();
    private int lastCommandExecuted = 0;
    private VideoThread videoMgr = null;
    private MeasureThread measureMgr = null;
    private MeasureThread bkndMeasureMgr = null;
    private MeasureThread factoryBkndMeasureMgr = null;
    private AsyncThread asyncMgr = null;
    private boolean exclusiveAccessState = false;
    private Object[] probeButtonListeners = null;

    CommandThread(TrackerInterface trackerInterface) {
        this.trackerIntf = trackerInterface;
        this.thread = new Thread((Runnable)this, "Command Thread");
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public int measureRecordsAvailable() {
        return this.measureMgr.recordsAvailable();
    }

    public MeasureData[] readMeasureData(int n) throws IOException {
        return this.measureMgr.readData(n);
    }

    public int videoRecordsAvailable() {
        return this.videoMgr.recordsAvailable();
    }

    public VideoData[] readVideoData() throws IOException {
        return this.videoMgr.readVideoData();
    }

    public MeasurePointData[] readMeasurePointData(int n) throws IOException {
        return this.measureMgr.readPointData(n);
    }

    public int bkndMeasureRecordsAvailable() {
        return this.bkndMeasureMgr.recordsAvailable();
    }

    public MeasureData[] readBkndMeasureData(int n) throws IOException {
        return this.bkndMeasureMgr.readData(n);
    }

    public MeasurePointData[] readBkndMeasurePointData(int n) throws IOException {
        return this.bkndMeasureMgr.readPointData(n);
    }

    public int factoryBkndMeasureRecordsAvailable() {
        return this.factoryBkndMeasureMgr.recordsAvailable();
    }

    public MeasureData[] readFactoryBkndMeasureData(int n) throws IOException {
        return this.factoryBkndMeasureMgr.readData(n);
    }

    public MeasurePointData[] readFactoryBkndMeasurePointData(int n) throws IOException {
        return this.factoryBkndMeasureMgr.readPointData(n);
    }

    public synchronized void addCommandCompleteListener(CommandCompleteListener commandCompleteListener) {
        this.listenerList.add(CommandCompleteListener.class, commandCompleteListener);
    }

    public synchronized void removeCommandCompleteListener(CommandCompleteListener commandCompleteListener) {
        this.listenerList.remove(CommandCompleteListener.class, commandCompleteListener);
    }

    private synchronized void fireCommandComplete(TrackerException trackerException) {
        CommandCompleteEvent commandCompleteEvent = new CommandCompleteEvent(this, trackerException);
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length;
        for (int i = 0; i < n; i += 2) {
            if (objectArray[i] != CommandCompleteListener.class) continue;
            ((CommandCompleteListener)objectArray[i + 1]).commandComplete(commandCompleteEvent);
        }
    }

    public synchronized void addBusyListener(BusyListener busyListener) {
        this.listenerList.add(BusyListener.class, busyListener);
    }

    public synchronized void removeBusyListener(BusyListener busyListener) {
        this.listenerList.remove(BusyListener.class, busyListener);
    }

    private synchronized void fireBusy(boolean bl, boolean bl2, boolean bl3) {
        BusyEvent busyEvent = new BusyEvent(this, bl, bl2, bl3);
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length;
        for (int i = 0; i < n; i += 2) {
            if (objectArray[i] != BusyListener.class) continue;
            ((BusyListener)objectArray[i + 1]).stateChanged(busyEvent);
        }
    }

    public synchronized void addApplicationListener(ApplicationListener applicationListener) {
        this.listenerList.add(ApplicationListener.class, applicationListener);
    }

    public synchronized void removeApplicationListener(ApplicationListener applicationListener) {
        this.listenerList.remove(ApplicationListener.class, applicationListener);
    }

    private synchronized void fireApplication(String string, boolean bl) {
        ApplicationEvent applicationEvent = new ApplicationEvent(this, string, bl);
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length;
        for (int i = 0; i < n; i += 2) {
            if (objectArray[i] != ApplicationListener.class) continue;
            ((ApplicationListener)objectArray[i + 1]).stateChanged(applicationEvent);
        }
    }

    public synchronized void addConnectListener(ConnectListener connectListener) {
        this.listenerList.add(ConnectListener.class, connectListener);
    }

    public synchronized void removeConnectListener(ConnectListener connectListener) {
        this.listenerList.remove(ConnectListener.class, connectListener);
    }

    private synchronized void fireConnect(boolean bl) {
        ConnectEvent connectEvent = new ConnectEvent(this, bl);
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length;
        for (int i = 0; i < n; i += 2) {
            if (objectArray[i] != ConnectListener.class) continue;
            ((ConnectListener)objectArray[i + 1]).connectionChanged(connectEvent);
        }
        if (bl) {
            this.factoryBkndMeasureMgr = new MeasureThread(this.trackerIntf, true, true, this.dataListenerList);
            this.bkndMeasureMgr = new MeasureThread(this.trackerIntf, true, false, this.dataListenerList);
            this.measureMgr = new MeasureThread(this.trackerIntf, false, false, this.dataListenerList);
            this.asyncMgr = new AsyncThread(this.trackerIntf, this.listenerList);
            this.videoMgr = new VideoThread(this.trackerIntf, this.dataListenerList);
        }
    }

    public synchronized void addMeasureDataListener(MeasureDataListener measureDataListener) {
        if (null != this.measureMgr) {
            this.measureMgr.freezeEvents();
        }
        this.dataListenerList.add(MeasureDataListener.class, measureDataListener);
        if (null != this.measureMgr) {
            this.measureMgr.updateListeners(this.dataListenerList);
            this.measureMgr.unfreezeEvents();
        }
    }

    public synchronized void removeMeasureDataListener(MeasureDataListener measureDataListener) {
        if (null != this.measureMgr) {
            this.measureMgr.freezeEvents();
        }
        this.dataListenerList.remove(MeasureDataListener.class, measureDataListener);
        if (null != this.measureMgr) {
            this.measureMgr.updateListeners(this.dataListenerList);
            this.measureMgr.unfreezeEvents();
        }
    }

    public synchronized void addBkndMeasureDataListener(BkndMeasureDataListener bkndMeasureDataListener) {
        if (null != this.bkndMeasureMgr) {
            this.bkndMeasureMgr.freezeEvents();
        }
        this.dataListenerList.add(BkndMeasureDataListener.class, bkndMeasureDataListener);
        if (null != this.bkndMeasureMgr) {
            this.bkndMeasureMgr.updateListeners(this.dataListenerList);
            this.bkndMeasureMgr.unfreezeEvents();
        }
    }

    public synchronized void removeBkndMeasureDataListener(BkndMeasureDataListener bkndMeasureDataListener) {
        if (null != this.bkndMeasureMgr) {
            this.bkndMeasureMgr.freezeEvents();
        }
        this.dataListenerList.remove(BkndMeasureDataListener.class, bkndMeasureDataListener);
        if (null != this.bkndMeasureMgr) {
            this.bkndMeasureMgr.updateListeners(this.dataListenerList);
            this.bkndMeasureMgr.unfreezeEvents();
        }
    }

    public synchronized void addFactoryBkndMeasureDataListener(FactoryBkndMeasureDataListener factoryBkndMeasureDataListener) {
        if (null != this.factoryBkndMeasureMgr) {
            this.factoryBkndMeasureMgr.freezeEvents();
        }
        this.dataListenerList.add(FactoryBkndMeasureDataListener.class, factoryBkndMeasureDataListener);
        if (null != this.factoryBkndMeasureMgr) {
            this.factoryBkndMeasureMgr.updateListeners(this.dataListenerList);
            this.factoryBkndMeasureMgr.unfreezeEvents();
        }
    }

    public synchronized void removeFactoryBkndMeasureDataListener(FactoryBkndMeasureDataListener factoryBkndMeasureDataListener) {
        if (null != this.factoryBkndMeasureMgr) {
            this.factoryBkndMeasureMgr.freezeEvents();
        }
        this.dataListenerList.remove(FactoryBkndMeasureDataListener.class, factoryBkndMeasureDataListener);
        if (null != this.factoryBkndMeasureMgr) {
            this.factoryBkndMeasureMgr.updateListeners(this.dataListenerList);
            this.factoryBkndMeasureMgr.unfreezeEvents();
        }
    }

    public synchronized void addDiagnosticListener(DiagnosticListener diagnosticListener) {
        if (null != this.asyncMgr) {
            this.asyncMgr.freezeEvents();
        }
        this.listenerList.add(DiagnosticListener.class, diagnosticListener);
        if (null != this.asyncMgr) {
            this.asyncMgr.updateListeners(this.listenerList);
            this.asyncMgr.unfreezeEvents();
        }
    }

    public synchronized void removeDiagnosticListener(DiagnosticListener diagnosticListener) {
        if (null != this.asyncMgr) {
            this.asyncMgr.freezeEvents();
        }
        this.listenerList.remove(DiagnosticListener.class, diagnosticListener);
        if (null != this.asyncMgr) {
            this.asyncMgr.updateListeners(this.listenerList);
            this.asyncMgr.unfreezeEvents();
        }
    }

    public synchronized void addStatusListener(StatusListener statusListener) {
        if (null != this.asyncMgr) {
            this.asyncMgr.freezeEvents();
        }
        this.listenerList.add(StatusListener.class, statusListener);
        if (null != this.asyncMgr) {
            this.asyncMgr.updateListeners(this.listenerList);
            this.asyncMgr.unfreezeEvents();
        }
    }

    public synchronized void removeStatusListener(StatusListener statusListener) {
        if (null != this.asyncMgr) {
            this.asyncMgr.freezeEvents();
        }
        this.listenerList.remove(StatusListener.class, statusListener);
        if (null != this.asyncMgr) {
            this.asyncMgr.updateListeners(this.listenerList);
            this.asyncMgr.unfreezeEvents();
        }
    }

    public synchronized void addAlarmListener(AlarmListener alarmListener) {
        if (null != this.asyncMgr) {
            this.asyncMgr.freezeEvents();
        }
        this.listenerList.add(AlarmListener.class, alarmListener);
        if (null != this.asyncMgr) {
            this.asyncMgr.updateListeners(this.listenerList);
            this.asyncMgr.unfreezeEvents();
        }
    }

    public synchronized void removeAlarmListener(AlarmListener alarmListener) {
        if (null != this.asyncMgr) {
            this.asyncMgr.freezeEvents();
        }
        this.listenerList.remove(AlarmListener.class, alarmListener);
        if (null != this.asyncMgr) {
            this.asyncMgr.updateListeners(this.listenerList);
            this.asyncMgr.unfreezeEvents();
        }
    }

    public synchronized void addChangeListener(ChangeListener changeListener) {
        if (null != this.asyncMgr) {
            this.asyncMgr.freezeEvents();
        }
        this.listenerList.add(ChangeListener.class, changeListener);
        if (null != this.asyncMgr) {
            this.asyncMgr.updateListeners(this.listenerList);
            this.asyncMgr.unfreezeEvents();
        }
    }

    public synchronized void removeChangeListener(ChangeListener changeListener) {
        if (null != this.asyncMgr) {
            this.asyncMgr.freezeEvents();
        }
        this.listenerList.remove(ChangeListener.class, changeListener);
        if (null != this.asyncMgr) {
            this.asyncMgr.updateListeners(this.listenerList);
            this.asyncMgr.unfreezeEvents();
        }
    }

    private int convertToMeasureType(int n) {
        switch (n) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
        }
        throw new IllegalArgumentException();
    }

    public boolean measureInProgress() {
        if (this.measureMgr == null) {
            return false;
        }
        return this.measureMgr.isBusy();
    }

    public boolean measureInProgress(int n) {
        this.convertToMeasureType(n);
        return this.measureInProgress() && n == this.measureMgr.type();
    }

    public boolean bkndMeasureInProgress() {
        if (this.bkndMeasureMgr == null) {
            return false;
        }
        return this.bkndMeasureMgr.isBusy();
    }

    public boolean bkndMeasureInProgress(int n) {
        this.convertToMeasureType(n);
        return this.bkndMeasureInProgress() && n == this.bkndMeasureMgr.type();
    }

    public boolean factoryBkndMeasureInProgress() {
        if (this.factoryBkndMeasureMgr == null) {
            return false;
        }
        return this.factoryBkndMeasureMgr.isBusy();
    }

    public boolean factoryBkndMeasureInProgress(int n) {
        this.convertToMeasureType(n);
        return this.factoryBkndMeasureInProgress() && n == this.factoryBkndMeasureMgr.type();
    }

    public boolean asyncRunning() {
        if (this.asyncMgr == null) {
            return false;
        }
        return this.asyncMgr.isBusy();
    }

    public boolean isBusy() {
        return this.commandInProgress || this.command.isFull();
    }

    private synchronized void SendCommand(Object[] objectArray, boolean bl, int n) throws InterfaceBusyException {
        if (this.isBusy() || this.abortInProgress) {
            throw new InterfaceBusyException("Command thread is busy");
        }
        this.response.flush();
        try {
            if (bl) {
                this.command.send(objectArray, n);
            } else {
                this.command.send(objectArray);
            }
        }
        catch (IOException iOException) {
            throw new InterfaceBusyException("Queue full");
        }
    }

    public void SendCommand(Object[] objectArray) throws InterruptedException, InterfaceBusyException {
        this.SendCommand(objectArray, false, 0);
    }

    public void SendCommand(Object[] objectArray, int n) throws InterruptedException, InterfaceBusyException {
        this.SendCommand(objectArray, true, n);
    }

    public Object[] ReceiveResponse() throws IOException {
        return this.response.receive();
    }

    public Object[] ReceiveResponse(int n) throws IOException {
        return this.response.receive(n);
    }

    public synchronized Object[] ReceiveSpecificResponse(int n) throws IOException, InterfaceBusyException {
        if (this.isBusy() || this.abortInProgress) {
            throw new InterfaceBusyException("ReceiveSpecificResponse saw busy");
        }
        if (this.lastCommandExecuted != n || this.response.isEmpty()) {
            return null;
        }
        return this.response.receive();
    }

    private void startMeasurement(Object[] objectArray, boolean bl, boolean bl2) throws TrackerException {
        int n = (Integer)objectArray[2];
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        int n2 = this.convertToMeasureType((Integer)objectArray[1]);
        Object[] objectArray2 = new Object[]{objectArray[1], objectArray[2]};
        switch (n2) {
            case 0: {
                if (bl) {
                    if (bl2) {
                        this.trackerIntf.startFactoryBkndMeasure((MeasureCfg)objectArray[3], (DataTag[])objectArray[4]);
                        break;
                    }
                    this.trackerIntf.startBkndMeasure((MeasureCfg)objectArray[3], (DataTag[])objectArray[4]);
                    break;
                }
                this.trackerIntf.startMeasure((MeasureCfg)objectArray[3], (DataTag[])objectArray[4]);
                break;
            }
            case 1: {
                if (bl) {
                    if (bl2) {
                        this.trackerIntf.startFactoryBkndMeasurePoint((MeasureCfg)objectArray[3]);
                        break;
                    }
                    this.trackerIntf.startBkndMeasurePoint((MeasureCfg)objectArray[3]);
                    break;
                }
                this.trackerIntf.startMeasurePoint((MeasureCfg)objectArray[3]);
            }
        }
        if (bl) {
            if (bl2) {
                this.factoryBkndMeasureMgr.startMeasurements(objectArray2);
            } else {
                this.bkndMeasureMgr.startMeasurements(objectArray2);
            }
        } else {
            this.measureMgr.startMeasurements(objectArray2);
        }
    }

    private void stopMeasurement(int n, boolean bl, boolean bl2) throws TrackerException {
        switch (n) {
            case 0: {
                if (bl) {
                    if (bl2) {
                        this.trackerIntf.stopFactoryBkndMeasure();
                        break;
                    }
                    this.trackerIntf.stopBkndMeasure();
                    break;
                }
                this.trackerIntf.stopMeasure();
                break;
            }
            case 1: {
                if (bl) {
                    if (bl2) {
                        this.trackerIntf.stopFactoryBkndMeasurePoint();
                        break;
                    }
                    this.trackerIntf.stopBkndMeasurePoint();
                    break;
                }
                this.trackerIntf.stopMeasurePoint();
            }
        }
        if (bl) {
            if (bl2) {
                if (!this.factoryBkndMeasureInProgress() || n != this.factoryBkndMeasureMgr.type()) {
                    throw new MeasureTypeException();
                }
                this.factoryBkndMeasureMgr.stopMeasurements();
            } else {
                if (!this.bkndMeasureInProgress() || n != this.bkndMeasureMgr.type()) {
                    throw new MeasureTypeException();
                }
                this.bkndMeasureMgr.stopMeasurements();
            }
        } else {
            if (!this.measureInProgress() || n != this.measureMgr.type()) {
                throw new MeasureTypeException();
            }
            this.measureMgr.stopMeasurements();
        }
    }

    private void stopMeasurement(Object[] objectArray, boolean bl, boolean bl2) throws TrackerException {
        int n = this.convertToMeasureType((Integer)objectArray[1]);
        this.stopMeasurement(n, bl, bl2);
    }

    private void startAsync() throws TrackerException {
        if (this.asyncRunning()) {
            throw new AsyncAlreadyStartedException();
        }
        this.trackerIntf.startAsync();
        this.asyncMgr.startAsync();
    }

    private void stopAsync() throws TrackerException {
        if (!this.asyncRunning()) {
            return;
        }
        this.trackerIntf.stopAsync();
        this.asyncMgr.stopAsync();
    }

    private void killAsyncThread() {
        if (this.asyncMgr == null) {
            return;
        }
        this.asyncMgr.shutdown();
        this.asyncMgr = null;
    }

    private void killMeasureThread(MeasureThread measureThread) {
        if (measureThread == null) {
            return;
        }
        measureThread.shutdown();
        measureThread = null;
    }

    private void killAllThreads() {
        this.killAsyncThread();
        this.killMeasureThread(this.factoryBkndMeasureMgr);
        this.killMeasureThread(this.bkndMeasureMgr);
        this.killMeasureThread(this.measureMgr);
    }

    private void cleanup() throws TrackerException {
        this.killAllThreads();
        this.exclusiveAccessState = false;
    }

    private void disconnect() throws TrackerException {
        if (this.trackerIntf.connected()) {
            String[] stringArray = this.trackerIntf.startedApplications();
            if (null != stringArray) {
                throw new InterfaceBusyException("Applications are still running");
            }
            if (this.asyncRunning()) {
                this.stopAsync();
            }
            if (this.bkndMeasureInProgress()) {
                this.stopMeasurement(this.bkndMeasureMgr.type(), true, false);
            }
            if (this.factoryBkndMeasureInProgress()) {
                this.stopMeasurement(this.factoryBkndMeasureMgr.type(), true, true);
            }
            if (this.measureInProgress()) {
                this.stopMeasurement(this.measureMgr.type(), false, false);
            }
            this.trackerIntf.disconnect();
            this.cleanup();
        }
        this.fireConnect(false);
    }

    private TrackerApp startApplication(Object[] objectArray) throws TrackerException {
        int n;
        JComponent jComponent;
        JFrame jFrame = null;
        boolean bl = false;
        String string = (String)objectArray[1];
        Tracker tracker = (Tracker)objectArray[3];
        if (7 == objectArray.length) {
            jFrame = (JFrame)objectArray[4];
            if (jFrame != null) {
                jFrame.toFront();
            }
            jComponent = (JComponent)objectArray[5];
            n = (Integer)objectArray[6];
        } else {
            bl = (Boolean)objectArray[4];
            jFrame = new TrackerAppFrame(string, tracker, bl);
            jComponent = ((TrackerAppFrame)jFrame).getAppPanel();
            jFrame.setResizable(true);
            jFrame.toFront();
            n = 0;
        }
        TrackerApp trackerApp = this.trackerIntf.startApplication(string, (String)objectArray[2], tracker, jFrame);
        new AddApp(trackerApp, jComponent, n, string, (String)objectArray[2]);
        return trackerApp;
    }

    void waitUntilApplicationStable(TrackerApp trackerApp) {
        trackerApp.waitUntilStable();
    }

    public String[] availableApplications() throws TrackerException {
        return this.trackerIntf.availableApplications();
    }

    public String[] startedApplications() throws TrackerException {
        return this.trackerIntf.startedApplications();
    }

    public void modifyApplication(String string, String string2) throws TrackerException {
        this.trackerIntf.modifyApplication(string, string2);
    }

    public void stopApplication(String string) throws TrackerException {
        this.stopApplication(string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object[] objectArray = null;
        int n = 0;
        while (!this.shutdown) {
            CommandThread commandThread;
            TrackerException trackerException;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            try {
                Object[] objectArray2;
                trackerException = null;
                this.command.browse();
                commandThread = this;
                synchronized (commandThread) {
                    objectArray2 = this.command.receive();
                    n = (Integer)objectArray2[0];
                    objectArray = new Object[]{null};
                    this.commandInProgressIsAbortable = 0 != (0x10000000 & n);
                    this.commandInProgress = true;
                    if (this.abortInProgress && this.commandInProgressIsAbortable) {
                        n = 0;
                    }
                    boolean bl4 = bl2 = 38 == n || this.exclusiveAccessState;
                    if (!bl2) {
                        this.fireBusy(true, this.measureInProgress(), this.bkndMeasureInProgress());
                    }
                }
                switch (n) {
                    case 1: {
                        this.trackerIntf.connect((String)objectArray2[1], (String)objectArray2[2], (String)objectArray2[3]);
                        this.fireConnect(true);
                        break;
                    }
                    case 2: {
                        this.disconnect();
                        break;
                    }
                    case 0x10000003: {
                        this.trackerIntf.initialize((Boolean)objectArray2[1]);
                        break;
                    }
                    case 0x10000040: {
                        this.trackerIntf.initializeSmart((Boolean)objectArray2[1]);
                        break;
                    }
                    case 0x10000004: {
                        this.trackerIntf.toggleSightOrientation();
                        break;
                    }
                    case 0x10000005: {
                        if (6 == objectArray2.length) {
                            this.trackerIntf.move((Double)objectArray2[1], (Double)objectArray2[2], (Double)objectArray2[3], (Boolean)objectArray2[4], (Boolean)objectArray2[5]);
                            break;
                        }
                        this.trackerIntf.move((Double)objectArray2[1], (Double)objectArray2[2], (Double)objectArray2[3], (Boolean)objectArray2[4]);
                        break;
                    }
                    case 0x10000006: {
                        this.trackerIntf.home((Boolean)objectArray2[1]);
                        break;
                    }
                    case 0x1000000C: {
                        if (4 == objectArray2.length) {
                            this.trackerIntf.search((Double)objectArray2[1], (Double)objectArray2[2], (Integer)objectArray2[3]);
                            break;
                        }
                        if (3 == objectArray2.length) {
                            if (objectArray2[2] instanceof Double) {
                                this.trackerIntf.search((double)((Double)objectArray2[1]), (Double)objectArray2[2]);
                                break;
                            }
                            this.trackerIntf.search((double)((Double)objectArray2[1]), (Integer)objectArray2[2]);
                            break;
                        }
                        this.trackerIntf.search((Double)objectArray2[1]);
                        break;
                    }
                    case 19: {
                        bl = true;
                        this.trackerIntf.changeMotorState((Boolean)objectArray2[1]);
                        break;
                    }
                    case 20: {
                        bl = true;
                        this.trackerIntf.changeTrackingState((Boolean)objectArray2[1]);
                        break;
                    }
                    case 21: {
                        bl = true;
                        this.trackerIntf.changeDistanceMeasureMode((DistanceMode)objectArray2[1]);
                        break;
                    }
                    case 22: {
                        bl = true;
                        this.trackerIntf.changeTargetType((TargetType)objectArray2[1]);
                        break;
                    }
                    case 7: {
                        this.trackerIntf.writeOneTimeData((DataTag[])objectArray2[1], (Object[])objectArray2[2]);
                        break;
                    }
                    case 8: {
                        objectArray[0] = this.trackerIntf.readOneTimeData((DataTag[])objectArray2[1]);
                        break;
                    }
                    case 0x10000009: {
                        this.trackerIntf.trackerCommand((String)objectArray2[1], (Integer)objectArray2[2]);
                        break;
                    }
                    case 10: {
                        this.startMeasurement(objectArray2, false, false);
                        bl3 = true;
                        break;
                    }
                    case 11: {
                        this.stopMeasurement(objectArray2, false, false);
                        bl3 = true;
                        break;
                    }
                    case 13: {
                        this.startMeasurement(objectArray2, true, false);
                        bl3 = true;
                        break;
                    }
                    case 14: {
                        this.stopMeasurement(objectArray2, true, false);
                        bl3 = true;
                        break;
                    }
                    case 62: {
                        this.startMeasurement(objectArray2, true, true);
                        break;
                    }
                    case 63: {
                        this.stopMeasurement(objectArray2, true, true);
                        break;
                    }
                    case 15: {
                        bl = true;
                        this.startAsync();
                        break;
                    }
                    case 16: {
                        bl = true;
                        this.stopAsync();
                        break;
                    }
                    case 0x10000011: {
                        objectArray[0] = this.trackerIntf.measureLevel();
                        break;
                    }
                    case 18: {
                        objectArray[0] = this.trackerIntf.measureMaterialTemperature();
                        break;
                    }
                    case 61: {
                        bl = true;
                        objectArray[0] = new Integer(this.trackerIntf.numExternalTempSensors());
                        break;
                    }
                    case 60: {
                        objectArray[0] = new Double(this.trackerIntf.measureExternalTempSensor((Integer)objectArray2[1]));
                        break;
                    }
                    case 23: {
                        bl = true;
                        objectArray[0] = this.startApplication(objectArray2);
                        break;
                    }
                    case 24: {
                        bl = true;
                        objectArray[0] = new Boolean(this.trackerIntf.connected());
                        break;
                    }
                    case 25: {
                        bl = true;
                        objectArray[0] = new Boolean(this.trackerIntf.targetPresent());
                        break;
                    }
                    case 26: {
                        bl = true;
                        objectArray[0] = new Boolean(this.trackerIntf.targetLocationValid());
                        break;
                    }
                    case 27: {
                        bl = true;
                        objectArray[0] = new Boolean(this.trackerIntf.motorsOn());
                        break;
                    }
                    case 52: {
                        bl = true;
                        objectArray[0] = new Boolean(this.trackerIntf.initialized((Boolean)objectArray2[1]));
                        break;
                    }
                    case 28: {
                        bl = true;
                        objectArray[0] = new Boolean(this.trackerIntf.trackingOn());
                        break;
                    }
                    case 29: {
                        bl = true;
                        objectArray[0] = new Boolean(this.trackerIntf.admCapable());
                        break;
                    }
                    case 30: {
                        bl = true;
                        objectArray[0] = new Boolean(this.trackerIntf.interferometerCapable());
                        break;
                    }
                    case 51: {
                        bl = true;
                        objectArray[0] = new Boolean(this.trackerIntf.levelCapable());
                        break;
                    }
                    case 50: {
                        bl = true;
                        objectArray[0] = new Boolean(this.trackerIntf.backsightOrientation());
                        break;
                    }
                    case 0x1000001F: {
                        this.trackerIntf.writeFile((String)objectArray2[1], (String)objectArray2[2]);
                        break;
                    }
                    case 0x10000020: {
                        this.trackerIntf.readFile((String)objectArray2[1], (String)objectArray2[2]);
                        break;
                    }
                    case 33: {
                        bl = true;
                        this.trackerIntf.changeAlarmCfg((Integer)objectArray2[1], (AlarmType)objectArray2[2]);
                        break;
                    }
                    case 34: {
                        bl = true;
                        objectArray[0] = this.trackerIntf.alarmCfg((Integer)objectArray2[1]);
                        break;
                    }
                    case 38: {
                        bl = true;
                        boolean bl5 = (Boolean)objectArray2[1];
                        if (this.exclusiveAccessState != bl5) {
                            this.exclusiveAccessState = bl5;
                            this.fireBusy(bl5, this.measureInProgress(), this.bkndMeasureInProgress());
                        }
                        break;
                    }
                    case 36: {
                        objectArray[0] = this.trackerIntf.alarmHistory();
                        break;
                    }
                    case 35: {
                        objectArray[0] = this.trackerIntf.diagnosticHistory();
                        break;
                    }
                    case 37: {
                        objectArray[0] = this.trackerIntf.statusHistory();
                        break;
                    }
                    case 39: {
                        bl = true;
                        objectArray[0] = this.trackerIntf.distanceMeasureMode();
                        break;
                    }
                    case 40: {
                        bl = true;
                        objectArray[0] = this.trackerIntf.targetType();
                        break;
                    }
                    case 54: {
                        bl = true;
                        this.trackerIntf.changeExternalTempType((Integer)objectArray2[1], (ExtTempType)objectArray2[2]);
                        break;
                    }
                    case 53: {
                        bl = true;
                        objectArray[0] = this.trackerIntf.externalTempType((Integer)objectArray2[1]);
                        break;
                    }
                    case 55: {
                        bl = true;
                        objectArray[0] = new Boolean(this.trackerIntf.externalTempTypeChangeable());
                        break;
                    }
                    case 56: {
                        bl = true;
                        objectArray[0] = new Integer(this.trackerIntf.sampleRate());
                        break;
                    }
                    case 57: {
                        bl = true;
                        objectArray[0] = new Boolean(this.trackerIntf.standardPrivilege());
                        break;
                    }
                    case 58: {
                        bl = true;
                        objectArray[0] = new Boolean(this.trackerIntf.adminPrivilege());
                        break;
                    }
                    case 59: {
                        bl = true;
                        objectArray[0] = new Boolean(this.trackerIntf.factoryPrivilege());
                        break;
                    }
                    case 65: {
                        this.trackerIntf.factoryConnect((String)objectArray2[1], (String)objectArray2[2], (String)objectArray2[3]);
                        break;
                    }
                    case 66: {
                        if (objectArray2.length > 1) {
                            this.factoryDisconnect((String)objectArray2[1]);
                            break;
                        }
                        this.factoryDisconnect();
                        break;
                    }
                    case 67: {
                        this.trackerIntf.changeAirTemperatureToHardware();
                        break;
                    }
                    case 68: {
                        this.trackerIntf.changeAirPressureToHardware();
                        break;
                    }
                    case 69: {
                        this.trackerIntf.changeHumidityToHardware();
                        break;
                    }
                    case 70: {
                        this.trackerIntf.changeAirTemperatureToManual((Double)objectArray2[1]);
                        break;
                    }
                    case 71: {
                        this.trackerIntf.changeAirPressureToManual((Double)objectArray2[1]);
                        break;
                    }
                    case 72: {
                        this.trackerIntf.changeHumidityToManual((Double)objectArray2[1]);
                        break;
                    }
                    case 73: {
                        this.startVideo(objectArray2);
                        break;
                    }
                    case 74: {
                        this.stopVideo();
                        break;
                    }
                    case 75: {
                        bl = true;
                        this.trackerIntf.changeGestureState((Boolean)objectArray2[1]);
                        break;
                    }
                    case 76: {
                        bl = true;
                        objectArray[0] = new Boolean(this.trackerIntf.gestureRecognitionOn());
                        break;
                    }
                    case 77: {
                        bl = true;
                        objectArray[0] = new Boolean(this.trackerIntf.wirelessCapable());
                        break;
                    }
                    case 78: {
                        bl = true;
                        objectArray[0] = new Boolean(this.trackerIntf.videoCapable());
                        break;
                    }
                    case 79: {
                        bl = true;
                        objectArray[0] = new Boolean(this.trackerIntf.gesturesCapable());
                        break;
                    }
                    case 80: {
                        this.trackerIntf.searchUsingCamera();
                        break;
                    }
                    case 94: {
                        this.trackerIntf.comboSearch((Double)objectArray2[1], (Double)objectArray2[2], (Double)objectArray2[3], (Double)objectArray2[4], (Double)objectArray2[5], (Boolean)objectArray2[6]);
                        break;
                    }
                    case 95: {
                        this.trackerIntf.comboSearchInternal((Double)objectArray2[1], (Double)objectArray2[2], (Double)objectArray2[3]);
                        break;
                    }
                    case 96: {
                        bl = true;
                        objectArray[0] = new Boolean(this.trackerIntf.didAACPassSinceInitialization());
                        break;
                    }
                    case 81: {
                        bl = true;
                        objectArray[0] = this.trackerIntf.checkAngularAccuracyError((SimplePointPairData)objectArray2[1]);
                        break;
                    }
                    case 82: {
                        bl = true;
                        objectArray[0] = this.trackerIntf.applicationResults((String)objectArray2[1]);
                        break;
                    }
                    case 83: {
                        bl = true;
                        objectArray[0] = this.trackerIntf.checkADMAgainstIFM((SimplePointPairData)objectArray2[1]);
                        break;
                    }
                    case 84: {
                        bl = true;
                        objectArray[0] = this.trackerIntf.getSerialNumber();
                        break;
                    }
                    case 85: {
                        bl = true;
                        objectArray[0] = this.trackerIntf.getWeatherInfo();
                        break;
                    }
                    case 86: {
                        int n2 = (Integer)objectArray2[1];
                        int n3 = (Integer)objectArray2[2];
                        this.trackerIntf.changeLedState(n2, n3);
                        break;
                    }
                    case 87: {
                        bl = true;
                        objectArray[0] = new Boolean(this.trackerIntf.readyToInitialize((Boolean)objectArray2[1]));
                        break;
                    }
                    case 88: {
                        this.trackerIntf.releaseLock();
                        break;
                    }
                    case 89: {
                        if (4 == objectArray2.length) {
                            this.trackerIntf.startSlew((Double)objectArray2[1], (Double)objectArray2[2], (Double)objectArray2[3]);
                            break;
                        }
                        this.trackerIntf.startSlew((Double)objectArray2[1], (Double)objectArray2[2]);
                        break;
                    }
                    case 90: {
                        this.trackerIntf.stopSlew();
                        break;
                    }
                    case 91: {
                        objectArray[0] = new Integer(this.trackerIntf.smartWarmupWaitState());
                        break;
                    }
                    case 92: {
                        objectArray[0] = new Boolean(this.trackerIntf.home((Boolean)objectArray2[1], (Boolean)objectArray2[2]));
                        break;
                    }
                    case 93: {
                        this.trackerIntf.resetCameras();
                        break;
                    }
                    case 97: {
                        bl = true;
                        objectArray[0] = new Integer(this.trackerIntf.batteryChargeRemaining((Integer)objectArray2[1]));
                        break;
                    }
                    case 100: {
                        bl = true;
                        objectArray[0] = new Integer(this.trackerIntf.batteryState((Integer)objectArray2[1]));
                        break;
                    }
                    case 101: {
                        bl = true;
                        this.trackerIntf.changePowerButtonState((Boolean)objectArray2[1]);
                        break;
                    }
                    case 102: {
                        bl = true;
                        objectArray[0] = new Boolean(this.trackerIntf.powerButtonState());
                        break;
                    }
                    case 103: {
                        bl = true;
                        this.trackerIntf.reboot();
                        break;
                    }
                    case 104: {
                        bl = true;
                        objectArray[0] = new Boolean(this.trackerIntf.isFollowMeOn());
                        break;
                    }
                    case 105: {
                        bl = true;
                        this.trackerIntf.changeFollowMeState((Boolean)objectArray2[1]);
                        break;
                    }
                    case 106: {
                        bl = true;
                        objectArray[0] = new Double(this.trackerIntf.getFollowMeSearchRadius());
                        break;
                    }
                    case 107: {
                        bl = true;
                        this.trackerIntf.changeFollowMeSearchRadius((Double)objectArray2[1]);
                        break;
                    }
                    case 108: {
                        bl = true;
                        objectArray[0] = new Boolean(this.trackerIntf.isFollowMeCapable());
                        break;
                    }
                    case 109: {
                        bl = true;
                        objectArray[0] = new Boolean(this.trackerIntf.sixDofCapable());
                        break;
                    }
                    case 110: {
                        bl = true;
                        objectArray[0] = this.trackerIntf.availableProbes();
                        break;
                    }
                    case 111: {
                        bl = true;
                        this.trackerIntf.addProbe((Probe)objectArray2[1]);
                        break;
                    }
                    case 112: {
                        bl = true;
                        this.trackerIntf.modifyProbe((Probe)objectArray2[1]);
                        break;
                    }
                    case 113: {
                        bl = true;
                        this.trackerIntf.removeProbe((Probe)objectArray2[1]);
                        break;
                    }
                    case 114: {
                        bl = true;
                        objectArray[0] = this.trackerIntf.probe();
                        break;
                    }
                    case 115: {
                        bl = true;
                        this.trackerIntf.changeProbe((Probe)objectArray2[1], (Boolean)objectArray2[2]);
                        break;
                    }
                    case 116: {
                        bl = true;
                        objectArray[0] = this.trackerIntf.probeAdapter();
                        break;
                    }
                    case 117: {
                        bl = true;
                        objectArray[0] = new Boolean(this.trackerIntf.probeAdapterConnected());
                        break;
                    }
                    case 119: {
                        bl = true;
                        objectArray[0] = this.trackerIntf.calibrateProbeTip((double[])objectArray2[1], (double[])objectArray2[2], (double[])objectArray2[3], (double[])objectArray2[4], (double[])objectArray2[5], (double[])objectArray2[6]);
                        break;
                    }
                    case 122: {
                        bl = true;
                        objectArray[0] = this.trackerIntf.calibrateISOProbeTip((double[])objectArray2[1], (double[])objectArray2[2], (double[])objectArray2[3]);
                        break;
                    }
                    case 121: {
                        bl = true;
                        objectArray[0] = this.trackerIntf.calcProbeCompensationParameters((double[])objectArray2[1], (double[])objectArray2[2], (double[])objectArray2[3], (double[])objectArray2[4], (double[])objectArray2[5], (double[])objectArray2[6]);
                        break;
                    }
                    case 120: {
                        bl = true;
                        this.trackerIntf.updateProbeCompensationParameters((Probe)objectArray2[1], (ProbeCompensationData)objectArray2[2]);
                        break;
                    }
                    case 129: {
                        bl = true;
                        this.trackerIntf.updateProbeCompensationParameters((Probe)objectArray2[1], (Double)objectArray2[2], (Double)objectArray2[3], (Double)objectArray2[4]);
                        break;
                    }
                    case 123: {
                        bl = true;
                        objectArray[0] = this.trackerIntf.sixDofEnabled();
                        break;
                    }
                    case 124: {
                        bl = true;
                        this.trackerIntf.changeSixDofEnableState((Boolean)objectArray2[1]);
                        break;
                    }
                    case 125: {
                        bl = true;
                        objectArray[0] = this.trackerIntf.probeBatteryChargeRemaining();
                        break;
                    }
                    case 126: {
                        int n3;
                        bl = true;
                        for (int i = 21; i <= 24; ++i) {
                            n3 = i - 21;
                            String string = "configure_alarm " + i + " enable sixdof.probe_adapter.user_button." + (n3 + 1) + ".value change";
                            this.trackerIntf.trackerCommand(string, 18000);
                        }
                        break;
                    }
                    case 127: {
                        bl = true;
                        this.trackerIntf.removeAllProbes();
                        break;
                    }
                    case 128: {
                        bl = true;
                        this.trackerIntf.removeAllFactoryProbes();
                        break;
                    }
                    case 130: {
                        bl = true;
                        objectArray[0] = new Double(this.trackerIntf.getDelayFromPassiveToActiveFollowMe());
                        break;
                    }
                    case 131: {
                        bl = true;
                        this.trackerIntf.setDelayFromPassiveToActiveFollowMe((Double)objectArray2[1]);
                        break;
                    }
                    case 132: {
                        bl = true;
                        objectArray[0] = this.trackerIntf.getIPAddress();
                        break;
                    }
                    case 133: {
                        bl = true;
                        objectArray[0] = this.trackerIntf.probeBatteryState();
                        break;
                    }
                    case 134: {
                        bl = true;
                        objectArray[0] = this.trackerIntf.probeBatteryStateChangeEventSupported();
                        break;
                    }
                    case 135: {
                        bl = true;
                        objectArray[0] = new Boolean(this.trackerIntf.wirelessStateChangeSupported());
                        break;
                    }
                    case 136: {
                        bl = true;
                        this.trackerIntf.changeWirelessState((Boolean)objectArray2[1]);
                        break;
                    }
                    case 137: {
                        bl = true;
                        objectArray[0] = new Boolean(this.trackerIntf.wirelessOn());
                        break;
                    }
                    case 0: {
                        if (this.abortInProgress) {
                            throw new AbortedException();
                        }
                    }
                    default: {
                        throw new TrackerException("Thread received unexpected command");
                    }
                }
            }
            catch (TrackerException trackerException2) {
                objectArray[0] = trackerException2;
                trackerException = trackerException2;
            }
            catch (Exception exception) {
                TrackerException trackerException3;
                objectArray[0] = trackerException3 = new TrackerException(exception.toString() + ": " + n);
                trackerException = trackerException3;
            }
            try {
                commandThread = this;
                synchronized (commandThread) {
                    this.lastCommandExecuted = n;
                    this.commandInProgress = false;
                    if (this.abortInProgress) {
                        this.abortInProgress = false;
                        this.notify();
                    }
                    this.response.send(objectArray);
                    if (!bl) {
                        this.fireCommandComplete(trackerException);
                    }
                    if (!bl2) {
                        this.fireBusy(false, this.measureInProgress(), this.bkndMeasureInProgress());
                    }
                }
            }
            catch (IOException iOException) {
            }
        }
        try {
            this.disconnect();
        }
        catch (TrackerException trackerException) {
            // empty catch block
        }
        this.response.close();
    }

    public void shutdown() {
        this.shutdown = true;
        this.command.close();
        if (this.commandInProgress) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.commandInProgress) {
            this.thread.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() {
        int n = 0;
        CommandThread commandThread = this;
        synchronized (commandThread) {
            if (this.abortInProgress || !this.isBusy()) {
                return;
            }
            this.abortInProgress = true;
            do {
                ++n;
                try {
                    if (this.commandInProgress && this.commandInProgressIsAbortable) {
                        this.trackerIntf.abort();
                        this.wait(100L);
                        continue;
                    }
                    this.wait(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (this.abortInProgress && n < 50);
            if (this.abortInProgress) {
                this.abortInProgress = false;
            }
        }
    }

    public void readFileAbort() {
        this.trackerIntf.readFileAbort();
    }

    public void writeFileAbort() {
        this.trackerIntf.writeFileAbort();
    }

    private void factoryDisconnect() throws TrackerException {
        this.trackerIntf.factoryDisconnect();
    }

    public void stopApplication(String string, boolean bl) throws TrackerException {
        TrackerApp trackerApp = this.trackerIntf.stopApplication(string, bl);
        if (null != trackerApp) {
            new RemoveApp(trackerApp);
            this.fireApplication(string, false);
        }
    }

    private void startVideo(Object[] objectArray) throws TrackerException {
        this.trackerIntf.startVideo((VideoCfg)objectArray[1]);
        Object[] objectArray2 = (Object[])objectArray[2];
        this.videoMgr.startVideo(objectArray2);
    }

    private void stopVideo() throws TrackerException {
        this.videoMgr.stopVideo();
        this.trackerIntf.stopVideo();
    }

    public synchronized void addVideoDataListener(VideoDataListener videoDataListener) {
        if (null != this.videoMgr) {
            this.videoMgr.freezeEvents();
        }
        this.dataListenerList.add(VideoDataListener.class, videoDataListener);
        if (null != this.videoMgr) {
            this.videoMgr.updateListeners(this.dataListenerList);
            this.videoMgr.unfreezeEvents();
        }
    }

    public synchronized void removeVideoDataListener(VideoDataListener videoDataListener) {
        if (null != this.videoMgr) {
            this.videoMgr.freezeEvents();
        }
        this.dataListenerList.remove(VideoDataListener.class, videoDataListener);
        if (null != this.videoMgr) {
            this.videoMgr.updateListeners(this.dataListenerList);
            this.videoMgr.unfreezeEvents();
        }
    }

    public boolean videoInProgress() {
        if (this.videoMgr == null) {
            return false;
        }
        return this.videoMgr.isBusy();
    }

    private void factoryDisconnect(String string) throws TrackerException {
        this.trackerIntf.factoryDisconnect(string);
    }

    public synchronized void addProbeButtonListener(ProbeButtonListener probeButtonListener) {
        if (null != this.asyncMgr) {
            this.asyncMgr.freezeEvents();
        }
        this.listenerList.add(ProbeButtonListener.class, probeButtonListener);
        if (null != this.asyncMgr) {
            this.asyncMgr.updateListeners(this.listenerList);
            this.asyncMgr.unfreezeEvents();
        }
    }

    public synchronized void removeProbeButtonListener(ProbeButtonListener probeButtonListener) {
        if (null != this.asyncMgr) {
            this.asyncMgr.freezeEvents();
        }
        this.listenerList.remove(ProbeButtonListener.class, probeButtonListener);
        if (null != this.asyncMgr) {
            this.asyncMgr.updateListeners(this.listenerList);
            this.asyncMgr.unfreezeEvents();
        }
    }

    public synchronized void addFactoryProbeButtonListener(ProbeButtonListener probeButtonListener) {
        if (null != this.asyncMgr) {
            this.asyncMgr.freezeEvents();
        }
        this.probeButtonListeners = this.listenerList.getListeners(ProbeButtonListener.class);
        for (int i = 0; i < this.probeButtonListeners.length; ++i) {
            this.listenerList.remove(ProbeButtonListener.class, (ProbeButtonListener)this.probeButtonListeners[i]);
        }
        this.listenerList.add(ProbeButtonListener.class, probeButtonListener);
        if (null != this.asyncMgr) {
            this.asyncMgr.updateListeners(this.listenerList);
            this.asyncMgr.unfreezeEvents();
        }
    }

    public synchronized void removeFactoryProbeButtonListener(ProbeButtonListener probeButtonListener) {
        if (null != this.asyncMgr) {
            this.asyncMgr.freezeEvents();
        }
        this.listenerList.remove(ProbeButtonListener.class, probeButtonListener);
        for (int i = 0; i < this.probeButtonListeners.length; ++i) {
            this.listenerList.add(ProbeButtonListener.class, (ProbeButtonListener)this.probeButtonListeners[i]);
        }
        if (null != this.asyncMgr) {
            this.asyncMgr.updateListeners(this.listenerList);
            this.asyncMgr.unfreezeEvents();
        }
    }

    private class RemoveApp
    implements Runnable {
        private TrackerApp app;

        RemoveApp(TrackerApp trackerApp) {
            this.app = trackerApp;
            SwingUtilities.invokeLater(this);
        }

        @Override
        public void run() {
            JComponent jComponent = (JComponent)this.app.getParent();
            jComponent.remove(this.app);
            jComponent.repaint();
        }
    }

    private class AddApp
    implements Runnable {
        private TrackerApp app;
        private JComponent component;
        private int index;
        private String appName;
        private String appParameters;
        private Thread noUIThread;

        AddApp(TrackerApp trackerApp, JComponent jComponent, int n, String string, String string2) {
            this.app = trackerApp;
            this.component = jComponent;
            this.index = n;
            this.appName = string;
            this.appParameters = string2;
            if (-1 == this.appParameters.toLowerCase(Locale.ENGLISH).indexOf("no_ui")) {
                SwingUtilities.invokeLater(this);
            } else {
                this.noUIThread = new Thread((Runnable)this, "No UI Worker Thread");
                this.noUIThread.setDaemon(true);
                this.noUIThread.start();
            }
        }

        @Override
        public void run() {
            this.component.add((Component)this.app, this.index);
            this.component.repaint();
            this.app.waitUntilStable();
            CommandThread.this.fireApplication(this.appName, true);
        }
    }
}

