/*
 * Decompiled with CFR 0.152.
 */
package smx.tracker;

import java.io.IOException;
import smx.tracker.Alarm;
import smx.tracker.AsyncMsg;
import smx.tracker.Change;
import smx.tracker.Diagnostic;
import smx.tracker.PrintException;
import smx.tracker.ProbeButtonChange;
import smx.tracker.Status;
import smx.tracker.TrackerException;
import smx.tracker.TrackerInterface;
import smx.tracker.event.AlarmEvent;
import smx.tracker.event.AlarmListener;
import smx.tracker.event.ChangeEvent;
import smx.tracker.event.ChangeListener;
import smx.tracker.event.DiagnosticEvent;
import smx.tracker.event.DiagnosticListener;
import smx.tracker.event.EventListenerList;
import smx.tracker.event.ProbeButtonEvent;
import smx.tracker.event.ProbeButtonListener;
import smx.tracker.event.StatusEvent;
import smx.tracker.event.StatusListener;
import smx.utility.ThreadComm;

class AsyncThread
implements Runnable {
    private boolean shutdown = false;
    private TrackerInterface trackerIntf = null;
    private EventListenerList asyncListenerList;
    private boolean eventsFrozen = false;
    private Thread thread;
    private int[] threadExitLock = new int[1];
    private ThreadComm startStop = new ThreadComm();
    private int[] threadSuspendLock = new int[1];
    private boolean stopAsyncActivity = false;

    AsyncThread(TrackerInterface trackerInterface, EventListenerList eventListenerList) {
        this.trackerIntf = trackerInterface;
        this.asyncListenerList = eventListenerList;
        this.threadExitLock[0] = 0;
        this.thread = new Thread((Runnable)this, "Async Thread");
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public boolean isBusy() {
        return this.startStop.isFull();
    }

    public void startAsync() {
        try {
            this.startStop.send((Object[])new Boolean[]{new Boolean(true)});
        }
        catch (IOException iOException) {
            PrintException.print(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAsync() {
        this.stopAsyncActivity = true;
        int[] nArray = this.threadSuspendLock;
        synchronized (this.threadSuspendLock) {
            try {
                if (this.threadSuspendLock[0] == 0) {
                    this.threadSuspendLock.wait();
                    this.threadSuspendLock[0] = 0;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void suspendAsync() {
        try {
            this.startStop.receive();
        }
        catch (IOException iOException) {
            PrintException.print(iOException);
        }
        this.stopAsyncActivity = false;
        int[] nArray = this.threadSuspendLock;
        synchronized (this.threadSuspendLock) {
            this.threadSuspendLock[0] = 1;
            this.threadSuspendLock.notify();
            // ** MonitorExit[var1_2] (shouldn't be in output)
            return;
        }
    }

    public synchronized void freezeEvents() {
        this.eventsFrozen = true;
    }

    public synchronized void unfreezeEvents() {
        this.eventsFrozen = false;
        this.notify();
    }

    public synchronized void updateListeners(EventListenerList eventListenerList) {
        this.asyncListenerList = eventListenerList;
    }

    private synchronized void fireDiagnostic(Diagnostic diagnostic) {
        if (this.eventsFrozen) {
            do {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (this.eventsFrozen);
        }
        DiagnosticEvent diagnosticEvent = new DiagnosticEvent(this, diagnostic);
        Object[] objectArray = this.asyncListenerList.getListenerList();
        int n = objectArray.length;
        for (int i = 0; i < n; i += 2) {
            if (objectArray[i] != DiagnosticListener.class) continue;
            ((DiagnosticListener)objectArray[i + 1]).diagnosticReported(diagnosticEvent);
        }
    }

    private synchronized void fireStatus(Status status) {
        if (this.eventsFrozen) {
            do {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (this.eventsFrozen);
        }
        StatusEvent statusEvent = new StatusEvent(this, status);
        Object[] objectArray = this.asyncListenerList.getListenerList();
        int n = objectArray.length;
        for (int i = 0; i < n; i += 2) {
            if (objectArray[i] != StatusListener.class) continue;
            ((StatusListener)objectArray[i + 1]).statusChanged(statusEvent);
        }
    }

    private synchronized void fireAlarm(Alarm alarm) {
        if (this.eventsFrozen) {
            do {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (this.eventsFrozen);
        }
        AlarmEvent alarmEvent = new AlarmEvent(this, alarm);
        Object[] objectArray = this.asyncListenerList.getListenerList();
        int n = objectArray.length;
        for (int i = 0; i < n; i += 2) {
            if (objectArray[i] != AlarmListener.class) continue;
            ((AlarmListener)objectArray[i + 1]).alarmChanged(alarmEvent);
        }
    }

    private synchronized void fireChange(Change change) {
        if (this.eventsFrozen) {
            do {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (this.eventsFrozen);
        }
        ChangeEvent changeEvent = new ChangeEvent(this, change);
        Object[] objectArray = this.asyncListenerList.getListenerList();
        int n = objectArray.length;
        for (int i = 0; i < n; i += 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            ((ChangeListener)objectArray[i + 1]).changeOccurred(changeEvent);
        }
    }

    private synchronized void fireProbeChange(ProbeButtonChange probeButtonChange) {
        if (this.eventsFrozen) {
            do {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (this.eventsFrozen);
        }
        int n = probeButtonChange.getAlarmNumber();
        boolean bl = probeButtonChange.getState();
        int n2 = probeButtonChange.getID();
        double d = probeButtonChange.getTimeStamp();
        String string = probeButtonChange.getTrackerSpecifics();
        if (n >= 21 && n <= 24) {
            int n3 = n - 21;
            ProbeButtonEvent probeButtonEvent = new ProbeButtonEvent(this, n3, d, !bl ? 0 : 1, string);
            Object[] objectArray = this.asyncListenerList.getListenerList();
            int n4 = objectArray.length;
            for (int i = 0; i < n4; i += 2) {
                if (objectArray[i] != ProbeButtonListener.class) continue;
                ((ProbeButtonListener)objectArray[i + 1]).buttonStatusChanged(probeButtonEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            while (!this.shutdown) {
                AsyncMsg asyncMsg;
                Object[] objectArray;
                if (this.stopAsyncActivity) {
                    this.suspendAsync();
                }
                if (!((Boolean)(objectArray = this.startStop.browse())[0]).booleanValue()) continue;
                try {
                    asyncMsg = this.trackerIntf.readAsyncMsg();
                }
                catch (TrackerException trackerException) {
                    continue;
                }
                try {
                    Status status;
                    if (asyncMsg instanceof Diagnostic) {
                        this.fireDiagnostic((Diagnostic)asyncMsg);
                    }
                    if (asyncMsg instanceof Status && (status = (Status)asyncMsg).getCode() != 0) {
                        this.fireStatus((Status)asyncMsg);
                    }
                    if (asyncMsg instanceof Alarm) {
                        this.fireAlarm((Alarm)asyncMsg);
                    }
                    if (asyncMsg instanceof Change) {
                        this.fireChange((Change)asyncMsg);
                    }
                    if (!(asyncMsg instanceof ProbeButtonChange)) continue;
                    this.fireProbeChange((ProbeButtonChange)asyncMsg);
                }
                catch (Exception exception) {}
            }
            return;
        }
        catch (Exception exception) {
            System.err.println("Strange Async exp : " + exception.toString());
            return;
        }
        finally {
            this.releaseAllLocks();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseAllLocks() {
        int[] nArray = this.threadSuspendLock;
        synchronized (this.threadSuspendLock) {
            this.threadSuspendLock[0] = 1;
            this.threadSuspendLock.notify();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            nArray = this.threadExitLock;
            synchronized (this.threadExitLock) {
                this.threadExitLock[0] = 1;
                this.threadExitLock.notifyAll();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }
    }

    public void shutdown() {
        this.shutdown = true;
        Object[] objectArray = new Boolean[]{new Boolean(false)};
        try {
            this.startStop.send(objectArray);
        }
        catch (IOException iOException) {
            PrintException.print(iOException);
        }
        this.waitTillShutDown();
        this.startStop.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitTillShutDown() {
        int[] nArray = this.threadExitLock;
        synchronized (this.threadExitLock) {
            try {
                if (this.threadExitLock[0] == 0) {
                    this.threadExitLock.wait(10000L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return;
        }
    }
}

