/*
 * Decompiled with CFR 0.152.
 */
package smx.tracker;

import java.io.IOException;
import java.util.ArrayList;
import smx.tracker.MeasurePointData;
import smx.tracker.PrintException;
import smx.tracker.TargetVideoData;
import smx.tracker.TrackerException;
import smx.tracker.TrackerInterface;
import smx.tracker.VideoData;
import smx.tracker.event.EventListenerList;
import smx.tracker.event.VideoDataEvent;
import smx.tracker.event.VideoDataListener;
import smx.utility.ThreadComm;

class VideoThread
implements Runnable {
    public static final int VIDEO_DATA = 0;
    public static final int TARGET_LOCATION_DATA = 1;
    private ThreadComm data;
    private Thread thread;
    private boolean shutdown = false;
    private TrackerInterface trackerIntf = null;
    private int numRecords;
    private int waitingRecords;
    private ArrayList tempHold;
    private boolean isBknd;
    private boolean isFactoryBknd;
    private int videoDataType;
    private EventListenerList dataListenerList;
    private boolean eventsFrozen = false;
    private int[] threadExitLock = new int[1];
    private ThreadComm startStop = new ThreadComm();
    private final int TEMP_HOLD_SIZE = 50;
    private int[] threadSuspendLock = new int[1];
    private boolean stopVideo = false;

    VideoThread(TrackerInterface trackerInterface, EventListenerList eventListenerList) {
        this.data = new ThreadComm(50);
        this.trackerIntf = trackerInterface;
        this.waitingRecords = 0;
        this.dataListenerList = eventListenerList;
        this.tempHold = new ArrayList(50);
        this.threadExitLock[0] = 0;
        this.thread = new Thread((Runnable)this, "Video Thread");
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public synchronized void freezeEvents() {
        this.eventsFrozen = true;
    }

    public synchronized void unfreezeEvents() {
        this.eventsFrozen = false;
        this.notify();
    }

    public synchronized void updateListeners(EventListenerList eventListenerList) {
        this.dataListenerList = eventListenerList;
    }

    private synchronized void fireVideoData(int n) {
        if (this.eventsFrozen) {
            do {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (this.eventsFrozen);
        }
        VideoDataEvent videoDataEvent = new VideoDataEvent(this);
        Object[] objectArray = this.dataListenerList.getListenerList();
        int n2 = objectArray.length;
        for (int i = 0; i < n2; i += 2) {
            if (objectArray[i] != VideoDataListener.class) continue;
            ((VideoDataListener)objectArray[i + 1]).dataAvailable(videoDataEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object[] objectArray = null;
        try {
            while (!this.shutdown) {
                if (this.stopVideo) {
                    this.suspendMeasurements();
                }
                this.startStop.browse();
                if (this.numRecords < 0) continue;
                try {
                    if (1 == this.videoDataType) {
                        MeasurePointData[] measurePointDataArray = this.trackerIntf.readMeasurePointData(this.numRecords);
                        objectArray = measurePointDataArray;
                    } else {
                        VideoData[] videoDataArray = this.trackerIntf.readVideoData();
                        objectArray = videoDataArray;
                    }
                }
                catch (TrackerException trackerException) {
                    continue;
                }
                this.data.send(objectArray);
                VideoThread videoThread = this;
                synchronized (videoThread) {
                    this.waitingRecords += this.numRecords;
                }
                try {
                    this.fireVideoData(this.numRecords);
                }
                catch (Exception exception) {
                    PrintException.print(exception);
                }
            }
        }
        catch (Exception exception) {
            PrintException.print(exception);
        }
        finally {
            this.releaseAllLocks();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseAllLocks() {
        int[] nArray = this.threadSuspendLock;
        synchronized (this.threadSuspendLock) {
            this.threadSuspendLock[0] = 1;
            this.threadSuspendLock.notify();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            nArray = this.threadExitLock;
            synchronized (this.threadExitLock) {
                this.threadExitLock[0] = 1;
                this.threadExitLock.notifyAll();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }
    }

    public boolean isBusy() {
        return this.startStop.isFull();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearOldData() {
        this.data.flush();
        this.tempHold.clear();
        VideoThread videoThread = this;
        synchronized (videoThread) {
            this.waitingRecords = 0;
        }
    }

    public void startVideo(Object[] objectArray) {
        this.videoDataType = (Integer)objectArray[0];
        this.numRecords = (Integer)objectArray[1];
        try {
            this.startStop.send(objectArray);
        }
        catch (IOException iOException) {
            PrintException.print(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopVideo() {
        this.stopVideo = true;
        if (this.data.isFull()) {
            try {
                this.localReadData();
            }
            catch (IOException iOException) {
                System.err.println("Data exception while Command thread tried to remove data to free the Measure Thread");
            }
        }
        int[] nArray = this.threadSuspendLock;
        synchronized (this.threadSuspendLock) {
            try {
                if (this.threadSuspendLock[0] == 0) {
                    this.threadSuspendLock.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.threadSuspendLock[0] = 0;
            // ** MonitorExit[var1_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void suspendMeasurements() {
        try {
            this.startStop.receive();
        }
        catch (IOException iOException) {
            PrintException.print(iOException);
        }
        this.clearOldData();
        this.stopVideo = false;
        int[] nArray = this.threadSuspendLock;
        synchronized (this.threadSuspendLock) {
            this.threadSuspendLock[0] = 1;
            this.threadSuspendLock.notify();
            // ** MonitorExit[var1_2] (shouldn't be in output)
            return;
        }
    }

    public int type() {
        return this.videoDataType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] localReadData() throws IOException {
        int n;
        int n2 = 0;
        Object[] objectArray = null;
        Object[] objectArray2 = null;
        int n3 = 1;
        if (n3 <= 0) {
            return null;
        }
        n2 = Math.min(this.tempHold.size(), n3);
        if (n2 > 0) {
            objectArray2 = 0 == this.videoDataType ? new VideoData[n3] : new TargetVideoData[n3];
            for (n = 0; n < n2; ++n) {
            }
            objectArray2[n] = this.tempHold.remove(0);
        }
        while (n2 < n3) {
            objectArray = this.data.receive();
            int n4 = objectArray.length;
            if (n4 == n3 && 0 == n2) {
                objectArray2 = objectArray;
                break;
            }
            if (null == objectArray2) {
                objectArray2 = 0 == this.videoDataType ? new VideoData[n3] : new TargetVideoData[n3];
            }
            for (n = 0; n < n4; ++n) {
                if (n2 < n3) {
                    objectArray2[n2] = objectArray[n];
                    ++n2;
                    continue;
                }
                this.tempHold.add(objectArray[n]);
            }
        }
        VideoThread videoThread = this;
        synchronized (videoThread) {
            this.waitingRecords -= n3;
        }
        return objectArray2;
    }

    public VideoData[] readVideoData() throws IOException {
        return (VideoData[])this.localReadData();
    }

    public TargetVideoData[] readTargetLocationData() throws IOException {
        return (TargetVideoData[])this.localReadData();
    }

    public void shutdown() {
        this.shutdown = true;
        Object[] objectArray = new Object[]{new Integer(-5), new Integer(-10)};
        try {
            this.startStop.send(objectArray);
        }
        catch (IOException iOException) {
            PrintException.print(iOException);
        }
        this.waitTillShutDown();
        this.startStop.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitTillShutDown() {
        int[] nArray = this.threadExitLock;
        synchronized (this.threadExitLock) {
            try {
                if (this.threadExitLock[0] == 0) {
                    this.threadExitLock.wait(10000L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return;
        }
    }

    public int recordsAvailable() {
        return this.waitingRecords;
    }
}

