/*
 * Decompiled with CFR 0.152.
 */
package smx.tracker;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.StringTokenizer;
import javax.swing.JFrame;
import smx.tracker.ADMOnly;
import smx.tracker.AbortedException;
import smx.tracker.AdaptiveFilter;
import smx.tracker.Alarm;
import smx.tracker.AlarmType;
import smx.tracker.AlreadyConnectedException;
import smx.tracker.ApplicationFailedException;
import smx.tracker.ApplicationResults;
import smx.tracker.AppsKeystoneSim.SimulatorAPI.MaterialTemp;
import smx.tracker.AppsKeystoneSim.SimulatorAPI.Nest;
import smx.tracker.AppsKeystoneSim.SimulatorAPI.Noise;
import smx.tracker.AppsKeystoneSim.SimulatorAPI.Target;
import smx.tracker.AppsKeystoneSim.SimulatorAPI.TrackerSimInterface;
import smx.tracker.AppsKeystoneSim.SimulatorAPI.Trackers;
import smx.tracker.AsyncMsg;
import smx.tracker.AverageFilter;
import smx.tracker.ConnectFailedException;
import smx.tracker.ContinueTrigger;
import smx.tracker.DataTag;
import smx.tracker.Diagnostic;
import smx.tracker.DistanceMode;
import smx.tracker.DistanceTrigger;
import smx.tracker.ExtTempType;
import smx.tracker.ExternalContinueTrigger;
import smx.tracker.Filter;
import smx.tracker.InterfaceBusyException;
import smx.tracker.InternalDeviceFailureException;
import smx.tracker.IntervalTrigger;
import smx.tracker.LevelData;
import smx.tracker.MPEResultsData;
import smx.tracker.MaterialExtTemp;
import smx.tracker.MaterialTemperatureData;
import smx.tracker.MeasureCfg;
import smx.tracker.MeasureData;
import smx.tracker.MeasurePointData;
import smx.tracker.MirrorTargetType;
import smx.tracker.MotorStateException;
import smx.tracker.NoDataAvailableException;
import smx.tracker.NoTargetException;
import smx.tracker.NotConnectedException;
import smx.tracker.NullContinueTrigger;
import smx.tracker.NullFilter;
import smx.tracker.Probe;
import smx.tracker.ProbeCalibrationData;
import smx.tracker.ProbeCompHistoryData;
import smx.tracker.ProbeCompensationData;
import smx.tracker.SMRTargetType;
import smx.tracker.SimplePointPairData;
import smx.tracker.Status;
import smx.tracker.StdDevFilter;
import smx.tracker.TargetType;
import smx.tracker.Tracker;
import smx.tracker.TrackerApp;
import smx.tracker.TrackerException;
import smx.tracker.TrackerInterface;
import smx.tracker.UnsupportedFeatureException;
import smx.tracker.VideoCfg;
import smx.tracker.VideoData;
import smx.tracker.WeatherInformation;
import smx.tracker.WindowedSMRTargetType;
import smx.utility.PortUtility;

public class TrackerVectorSim
implements TrackerInterface {
    private String ipAddress;
    private String userName;
    private String userPassword;
    private String fileName = "temp.dat";
    private boolean isConnected = false;
    private boolean isTrackingOn = false;
    private boolean isMotorOn = false;
    private boolean targetPresent = false;
    private boolean targetValid = false;
    private boolean isBacksight = false;
    private boolean isInitialized = false;
    private TargetType targetType = new SMRTargetType(0.0381);
    private DistanceMode distanceMode;
    private Filter filterType;
    private ContinueTrigger conTrigger;
    private LinkedList trackerList;
    private LinkedList nestList;
    private LinkedList targetList;
    private MaterialTemp materialTemp;
    private Noise noise;
    private Trackers tracker;
    private Target target;
    private int coordinate;
    private int sampleNum;
    private int trackerIndex = 0;
    private int useADM = 1;
    private int accessLevel;
    private double azimuth;
    private double zenith;
    private double distanceDelta;
    private double workingDistance;
    private double baseDistance;
    private double ADMDistance;
    private ArrayList al = new ArrayList();
    private HashMap database = new HashMap();
    private Thread workingThread = null;
    private TrkSimInterfaceImplementer simInterface = new TrkSimInterfaceImplementer();
    private AppRec[] appInfo;
    private DataTag[] tagList;
    private static final int ADM_ONLY = 1;
    public static final double[] TMR_LOCATION = new double[]{0.0, 2.356194490192345, 0.14};
    private static final int ACCESS_STANDARD = 0;
    private static final int ACCESS_ADMIN = 1;
    private static final int ACCESS_FACTORY = 2;
    private static final int TRACKER_SAMPLES_PER_SECOND = 4000;
    private int NUM_EXT_TEMP_SENSORS = 4;
    PortUtility portUtility;

    public TrackerVectorSim() {
        this.trackerList = new LinkedList();
        this.nestList = new LinkedList();
        this.targetList = new LinkedList();
        this.materialTemp = new MaterialTemp();
        this.noise = new Noise();
        this.tracker = new Trackers();
        this.target = new Target();
        this.loadData(this.fileName);
        this.relocateNestList(this.nestList);
        this.initDatabase();
    }

    @Override
    public void connect(String string, String string2, String string3) throws TrackerException {
        if (this.isConnected) {
            throw new AlreadyConnectedException();
        }
        boolean bl = false;
        for (int i = 0; i < this.trackerList.size(); ++i) {
            Trackers trackers = (Trackers)this.trackerList.get(i);
            if (!string.equals(trackers.getIPAddress())) continue;
            bl = true;
            this.trackerIndex = i;
        }
        if (!bl) {
            throw new ConnectFailedException(Tracker.res.getString("IpAddress_Not_Found"));
        }
        this.ipAddress = string;
        this.userName = string2;
        this.userPassword = string3;
        this.tracker = (Trackers)this.trackerList.get(this.trackerIndex);
        this.target = new Target();
        this.azimuth = 0.0;
        this.zenith = 0.0;
        this.ADMDistance = 0.0;
        this.baseDistance = 0.0;
        this.distanceDelta = 0.0;
        this.setAppInfo();
        this.isConnected = true;
    }

    @Override
    public void disconnect() throws TrackerException {
        if (!this.isConnected) {
            throw new NotConnectedException();
        }
        this.tracker = new Trackers();
        this.target = new Target();
        this.azimuth = 0.0;
        this.zenith = 0.0;
        this.ADMDistance = 0.0;
        this.baseDistance = 0.0;
        this.distanceDelta = 0.0;
        this.targetPresent = false;
        this.targetValid = false;
        this.clearAppInfo();
        this.isConnected = false;
    }

    @Override
    public void trackerCommand(String string, int n) throws TrackerException {
    }

    @Override
    public void initialize() throws TrackerException {
        this.initialize(true);
    }

    @Override
    public void initialize(boolean bl) throws TrackerException {
        if (!this.readyToInitialize(bl)) {
            throw new TrackerException(Tracker.res.getString("Tracker_Is_Not_Ready"));
        }
        this.executionDelay(30000);
        this.azimuth = 0.0;
        this.zenith = 0.0;
        this.ADMDistance = 0.0;
        this.baseDistance = 0.0;
        this.distanceDelta = 0.0;
        this.targetPresent = false;
        this.targetValid = false;
        this.isInitialized = true;
        this.isMotorOn = true;
    }

    @Override
    public void initializeSmart() throws TrackerException {
        this.initializeSmart(true);
    }

    @Override
    public void initializeSmart(boolean bl) throws TrackerException {
        if (!this.readyToInitialize(bl)) {
            throw new TrackerException(Tracker.res.getString("Tracker_Is_Not_Ready"));
        }
        this.executionDelay(30000);
        this.azimuth = 0.0;
        this.zenith = 0.0;
        this.ADMDistance = 0.0;
        this.baseDistance = 0.0;
        this.distanceDelta = 0.0;
        this.targetPresent = false;
        this.targetValid = false;
        this.isInitialized = true;
        this.isMotorOn = true;
    }

    @Override
    public void move(double d, double d2, double d3, boolean bl) throws TrackerException {
        if (!this.isInitialized || !this.isMotorOn) {
            throw new MotorStateException(Tracker.res.getString("Tracker_Is_Not_Initialized"));
        }
        this.executionDelay(2000);
        boolean bl2 = false;
        if (bl) {
            this.azimuth += d;
            this.zenith += d2;
            d3 += this.workingDistance;
        } else {
            this.azimuth = d;
            this.zenith = d2;
        }
        this.distanceDelta = 0.0;
        this.baseDistance = d3;
        this.ADMDistance = d3;
        this.workingDistance = d3;
        this.targetPresent = false;
        this.targetValid = false;
        this.target = new Target();
        if (this.zenith >= -Math.PI && this.zenith <= 0.0) {
            this.azimuth += Math.PI;
            this.azimuth = Math.IEEEremainder(this.azimuth, Math.PI * 2);
            this.zenith = -this.zenith;
            this.zenith = Math.IEEEremainder(this.zenith, Math.PI * 2);
            this.isBacksight = true;
        } else {
            this.isBacksight = false;
        }
        this.target = this.findCurrentTarget(this.azimuth, this.zenith);
        if (!this.target.getTargetName().equals("")) {
            this.setCurrentTargetPosition(d3);
            this.targetPresent = true;
            this.targetValid = true;
        } else {
            this.targetPresent = false;
            this.targetValid = false;
        }
    }

    private void setCurrentTargetPosition(double d) {
        for (int i = 0; i < this.nestList.size(); ++i) {
            Nest nest = (Nest)this.nestList.get(i);
            if (!nest.getClassmateName().equals(this.target.getTargetName())) continue;
            this.azimuth = nest.getPosition()[0];
            this.zenith = nest.getPosition()[1];
            this.ADMDistance = nest.getPosition()[2];
            this.distanceDelta = 0.0;
            if (this.useADM != 1) continue;
            this.baseDistance = nest.getPosition()[2];
        }
    }

    private Target findCurrentTarget(double d, double d2) {
        double d3 = 0.0;
        boolean bl = true;
        boolean bl2 = false;
        Target target = new Target();
        block0: for (int i = 0; i < this.nestList.size(); ++i) {
            Nest nest = (Nest)this.nestList.get(i);
            double d4 = nest.getPosition()[0];
            double d5 = nest.getPosition()[1];
            double d6 = nest.getPosition()[2];
            if (!(Math.sqrt(Math.pow(d - d4, 2.0) + Math.pow(d2 - d5, 2.0)) * d6 <= 0.002)) continue;
            if (nest.getClassmateName().equals("")) {
                if (bl2) continue;
                bl2 = false;
                continue;
            }
            for (int j = 0; j < this.targetList.size(); ++j) {
                Target target2 = (Target)this.targetList.get(j);
                if (!target2.getClassmate().equals(nest.getNestName())) continue;
                if (bl) {
                    d3 = d6;
                    bl = false;
                } else {
                    if (!(d6 < d3)) continue block0;
                    d3 = d6;
                }
                target = target2;
                bl2 = true;
            }
        }
        if (bl2) {
            if (target.getTargetStatus().equals("Blocked")) {
                return new Target();
            }
            return target;
        }
        return new Target();
    }

    @Override
    public void move(double d, double d2, double d3, boolean bl, boolean bl2) throws TrackerException {
        double[] dArray = new double[3];
        dArray = this.cartToSphere(d, d2, d3);
        if (bl) {
            this.isBacksight = bl;
        }
        this.move(dArray[0], dArray[1], dArray[2], bl2);
    }

    @Override
    public void home(boolean bl) throws TrackerException {
        if (bl) {
            this.move(Math.PI, -2.356194490192345, 0.14, false);
        } else {
            this.move(0.0, 2.356194490192345, 0.14, false);
        }
    }

    @Override
    public void toggleSightOrientation() throws TrackerException {
        if (!this.isInitialized || !this.isMotorOn) {
            throw new MotorStateException(Tracker.res.getString("Tracker_Is_Not_Initialized"));
        }
        this.executionDelay(2000);
        this.isBacksight = !this.isBacksight;
    }

    @Override
    public boolean backsightOrientation() throws TrackerException {
        return this.isBacksight;
    }

    @Override
    public void search(double d, double d2, int n) throws TrackerException {
        this.search(d, d2);
    }

    @Override
    public void search(double d, int n) throws TrackerException {
        this.search(d, this.workingDistance);
    }

    @Override
    public void search(double d, double d2) throws TrackerException {
        if (!this.isInitialized || !this.isMotorOn) {
            throw new MotorStateException(Tracker.res.getString("Tracker_Is_Not_Initialized"));
        }
        if (this.targetPresent) {
            return;
        }
        this.baseDistance = d2;
        this.distanceDelta = 0.0;
        this.ADMDistance = d2;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        boolean bl = true;
        boolean bl2 = false;
        Target target = new Target();
        double d8 = this.azimuth + Math.atan(d / d2);
        double d9 = this.azimuth - Math.atan(d / d2);
        double d10 = this.zenith + Math.atan(d / d2);
        double d11 = this.zenith - Math.atan(d / d2);
        for (int i = 0; i < this.nestList.size(); ++i) {
            Target target2;
            int n;
            Nest nest = new Nest();
            nest = (Nest)this.nestList.get(i);
            if (nest.getClassmateName().equals("")) continue;
            double d12 = nest.getPosition()[0];
            double d13 = nest.getPosition()[1];
            double d14 = nest.getPosition()[2];
            if (!(d12 <= d8) || !(d12 >= d9) || !(d13 <= d10) || !(d13 >= d11)) continue;
            d7 = Math.sqrt(Math.pow(d12 - this.azimuth, 2.0) + Math.pow(d13 - this.zenith, 2.0));
            if (bl) {
                d6 = d7;
                d3 = d12;
                d4 = d13;
                d5 = d14;
                for (n = 0; n < this.targetList.size(); ++n) {
                    target2 = (Target)this.targetList.get(n);
                    if (!target2.getClassmate().equals(nest.getNestName())) continue;
                    target = target2;
                }
                bl = false;
            } else if (d7 < d6) {
                d6 = d7;
                d3 = d12;
                d4 = d13;
                d5 = d14;
                for (n = 0; n < this.targetList.size(); ++n) {
                    target2 = (Target)this.targetList.get(n);
                    if (!target2.getClassmate().equals(nest.getNestName())) continue;
                    target = target2;
                }
            }
            bl2 = true;
        }
        if (bl2) {
            this.azimuth = d3;
            this.zenith = d4;
            if (this.useADM == 1) {
                this.ADMDistance = d5;
                this.baseDistance = d5;
            }
        } else {
            this.targetPresent = false;
            this.targetValid = false;
            this.target = new Target();
            throw new NoTargetException(Tracker.res.getString("Target_Is_Not_Found"));
        }
        this.target = target;
        this.targetPresent = true;
        this.targetValid = true;
    }

    @Override
    public void search(double d) throws TrackerException {
        this.search(d, this.workingDistance);
    }

    @Override
    public void changeMotorState(boolean bl) throws TrackerException {
        if (!this.isInitialized) {
            throw new MotorStateException(Tracker.res.getString("Tracker_Is_Not_Initialized"));
        }
        this.isMotorOn = bl;
    }

    @Override
    public void changeTrackingState(boolean bl) throws TrackerException {
        this.isTrackingOn = bl;
    }

    @Override
    public void changeDistanceMeasureMode(DistanceMode distanceMode) throws TrackerException {
        if (!(distanceMode instanceof ADMOnly)) {
            throw new UnsupportedFeatureException(Tracker.res.getString("Mode_Not_Supported"));
        }
        this.useADM = 1;
        this.targetValid = true;
        this.distanceMode = distanceMode;
    }

    @Override
    public void changeTargetType(TargetType targetType) throws TrackerException {
        if (!(targetType instanceof SMRTargetType) && !(targetType instanceof MirrorTargetType)) {
            throw new UnsupportedFeatureException(Tracker.res.getString("Mode_Not_Supported"));
        }
        this.targetType = targetType;
    }

    @Override
    public TargetType targetType() {
        return this.targetType;
    }

    @Override
    public DistanceMode distanceMeasureMode() {
        return this.distanceMode;
    }

    @Override
    public Alarm[] alarmHistory() {
        return null;
    }

    @Override
    public Status[] statusHistory() {
        return null;
    }

    @Override
    public Diagnostic[] diagnosticHistory() {
        return null;
    }

    @Override
    public synchronized void abort() {
        if (null != this.workingThread) {
            this.workingThread.interrupt();
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    public int sampleRate() throws TrackerException {
        return 4000;
    }

    @Override
    public void startMeasure(MeasureCfg measureCfg, DataTag[] dataTagArray) throws TrackerException {
        this.startBkndMeasure(measureCfg, dataTagArray);
    }

    @Override
    public MeasureData[] readMeasureData(int n) throws TrackerException {
        MeasureData[] measureDataArray = this.readBkndMeasureData(n);
        return measureDataArray;
    }

    @Override
    public synchronized void stopMeasure() throws TrackerException {
    }

    @Override
    public void startMeasurePoint(MeasureCfg measureCfg) throws TrackerException {
        this.startBkndMeasurePoint(measureCfg);
    }

    @Override
    public MeasurePointData[] readMeasurePointData(int n) throws TrackerException {
        MeasurePointData[] measurePointDataArray = new MeasurePointData[n];
        measurePointDataArray = this.readBkndMeasurePointData(n);
        return measurePointDataArray;
    }

    @Override
    public synchronized void stopMeasurePoint() throws TrackerException {
        if (null != this.workingThread) {
            this.workingThread.interrupt();
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.al.size() != 0) {
            this.al.clear();
        }
    }

    @Override
    public synchronized void startBkndMeasure(MeasureCfg measureCfg, DataTag[] dataTagArray) throws TrackerException {
        this.tagList = dataTagArray;
    }

    @Override
    public MeasureData[] readBkndMeasureData(int n) throws TrackerException {
        MeasureData[] measureDataArray = new MeasureData[n];
        Object[] objectArray = this.readOneTimeData(this.tagList);
        this.executionDelay(2000);
        for (int i = 0; i < n; ++i) {
            measureDataArray[i] = new MeasureData((double)System.currentTimeMillis() / 1000.0, objectArray, null);
        }
        return measureDataArray;
    }

    @Override
    public void stopBkndMeasure() throws TrackerException {
    }

    @Override
    public synchronized void startBkndMeasurePoint(MeasureCfg measureCfg) throws TrackerException {
        ContinueTrigger continueTrigger = measureCfg.getContinueTrigger();
        Filter filter = measureCfg.getFilter();
        this.sampleNum = measureCfg.getSamplesPerObservation();
        if (!(continueTrigger instanceof IntervalTrigger || continueTrigger instanceof DistanceTrigger || continueTrigger instanceof NullContinueTrigger || continueTrigger instanceof ExternalContinueTrigger)) {
            throw new UnsupportedFeatureException(Tracker.res.getString("Unknown_Continue_Trigger"));
        }
        this.conTrigger = continueTrigger;
        if (!(filter instanceof AverageFilter || filter instanceof NullFilter || filter instanceof StdDevFilter || filter instanceof AdaptiveFilter)) {
            throw new UnsupportedFeatureException(Tracker.res.getString("Filter_Is_Not_Supported"));
        }
        this.filterType = filter;
    }

    @Override
    public MeasurePointData[] readBkndMeasurePointData(int n) throws TrackerException {
        MeasurePointData[] measurePointDataArray;
        block7: {
            int n2;
            block8: {
                double d;
                double d2;
                double d3;
                block6: {
                    double[] dArray = new double[3];
                    Random random = new Random();
                    this.workingDistance = this.useADM == 1 ? this.ADMDistance : this.baseDistance + this.distanceDelta;
                    d3 = this.azimuth;
                    d2 = this.zenith;
                    d = this.workingDistance;
                    if (this.targetPresent) {
                        double d4 = random.nextDouble();
                        d3 += this.noise.getNoise()[0] * (d4 * 2.0 - 1.0);
                        d4 = random.nextDouble();
                        d2 += this.noise.getNoise()[0] * (d4 * 2.0 - 1.0);
                        d4 = random.nextDouble();
                        dArray = this.sphereToCart(d3, d2, d += this.noise.getNoise()[1] * (d4 * 2.0 - 1.0));
                        d4 = random.nextDouble();
                        d3 = dArray[0] + this.noise.getNoise()[2] * (d4 * 2.0 - 1.0);
                        d4 = random.nextDouble();
                        d2 = dArray[1] + this.noise.getNoise()[2] * (d4 * 2.0 - 1.0);
                        d4 = random.nextDouble();
                        d = dArray[2] + this.noise.getNoise()[2] * (d4 * 2.0 - 1.0);
                        dArray = this.cartToSphere(d3, d2, d);
                        d3 = dArray[0];
                        d2 = dArray[1];
                        d = dArray[2];
                        if (this.isBacksight) {
                            d3 += Math.PI;
                            d3 = Math.IEEEremainder(d3, Math.PI * 2);
                            d2 = -d2;
                            d2 = Math.IEEEremainder(d2, Math.PI * 2);
                        }
                    } else {
                        d3 = 0.0;
                        d2 = 0.0;
                        d = 0.0;
                    }
                    n2 = this.targetPresent && this.targetValid ? 0 : (this.targetPresent && !this.targetValid ? 1 : 2);
                    measurePointDataArray = new MeasurePointData[n];
                    if (!(this.conTrigger instanceof NullContinueTrigger)) break block6;
                    for (int i = 0; i < n; ++i) {
                        this.executionDelay(this.sampleNum / 4);
                        measurePointDataArray[i] = new MeasurePointData((double)System.currentTimeMillis() / 1000.0, d3, d2, d, n2, null);
                    }
                    break block7;
                }
                if (!(this.conTrigger instanceof IntervalTrigger)) break block8;
                double d5 = ((IntervalTrigger)this.conTrigger).getObservationRate();
                for (int i = 0; i < n; ++i) {
                    this.executionDelay((int)(1000.0 * d5));
                    measurePointDataArray[i] = new MeasurePointData((double)System.currentTimeMillis() / 1000.0, d3, d2, d, n2, null);
                }
                break block7;
            }
            if (!(this.conTrigger instanceof DistanceTrigger)) break block7;
            for (int i = 0; i < n; ++i) {
                double[] dArray = new double[3];
                dArray = this.receivePoints();
                measurePointDataArray[i] = new MeasurePointData((double)System.currentTimeMillis() / 1000.0, dArray[0], dArray[1], dArray[2], n2, null);
            }
        }
        return measurePointDataArray;
    }

    @Override
    public synchronized void stopBkndMeasurePoint() throws TrackerException {
        if (null != this.workingThread) {
            this.workingThread.interrupt();
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    public synchronized void startAsync() throws TrackerException {
    }

    @Override
    public synchronized void stopAsync() throws TrackerException {
    }

    @Override
    public AsyncMsg readAsyncMsg() throws TrackerException {
        throw new NoDataAvailableException();
    }

    @Override
    public synchronized void writeOneTimeData(DataTag[] dataTagArray, Object[] objectArray) throws TrackerException {
        if (null == dataTagArray) {
            throw new NoDataAvailableException();
        }
        int n = dataTagArray.length;
        for (int i = 0; i < n; ++i) {
            String string = dataTagArray[i].getName();
            if (!this.database.containsKey(string)) {
                throw new NoDataAvailableException();
            }
            this.database.put(string, objectArray[i]);
        }
    }

    @Override
    public synchronized Object[] readOneTimeData(DataTag[] dataTagArray) throws TrackerException {
        if (null == dataTagArray) {
            throw new NoDataAvailableException();
        }
        int n = dataTagArray.length;
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            String string = dataTagArray[i].getName();
            if (!this.database.containsKey(string)) {
                throw new NoDataAvailableException();
            }
            objectArray[i] = this.database.get(string);
        }
        return objectArray;
    }

    @Override
    public boolean connected() throws TrackerException {
        return this.isConnected;
    }

    @Override
    public boolean targetPresent() throws TrackerException {
        return this.targetPresent;
    }

    @Override
    public boolean targetLocationValid() throws TrackerException {
        return this.targetValid;
    }

    @Override
    public boolean motorsOn() throws TrackerException {
        return this.isMotorOn;
    }

    @Override
    public boolean initialized() throws TrackerException {
        return this.initialized(true);
    }

    @Override
    public boolean initialized(boolean bl) throws TrackerException {
        return this.isInitialized;
    }

    @Override
    public boolean trackingOn() throws TrackerException {
        return this.isTrackingOn;
    }

    @Override
    public boolean admCapable() throws TrackerException {
        return true;
    }

    @Override
    public boolean admOnlyCapable() {
        return true;
    }

    @Override
    public boolean interferometerCapable() throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public boolean levelCapable() throws TrackerException {
        return true;
    }

    @Override
    public LevelData measureLevel() throws TrackerException {
        if (!this.isInitialized || !this.isMotorOn) {
            throw new MotorStateException(Tracker.res.getString("Tracker_Is_Not_Initialized"));
        }
        this.executionDelay(30000);
        double d = this.tracker.getRotation()[0];
        double d2 = this.tracker.getRotation()[1];
        double d3 = this.tracker.getRotation()[2];
        if (d <= Math.PI / 90 && d >= -Math.PI / 90 && d2 <= Math.PI / 90 && d2 >= -Math.PI / 90) {
            return new LevelData(d, d2, 0.0);
        }
        throw new InternalDeviceFailureException(Tracker.res.getString("Level_Fall_Out_Of_Range"));
    }

    @Override
    public MaterialTemperatureData measureMaterialTemperature() throws TrackerException {
        if (0 != this.materialTemp.getStatus() && Math.pow(2.0, 6.0) != (double)this.materialTemp.getStatus()) {
            throw new InternalDeviceFailureException(Tracker.res.getString("Sensor_Error"));
        }
        double d = this.materialTemp.getTemperature();
        return new MaterialTemperatureData(d, 1);
    }

    @Override
    public TrackerApp startApplication(String string, String string2, Tracker tracker, JFrame jFrame) throws TrackerException {
        if (!this.isConnected) {
            throw new NotConnectedException();
        }
        AppRec appRec = this.findAppInfo(string);
        if (appRec.isSet()) {
            throw new ApplicationFailedException(Tracker.res.getString("Application_Already_Running"));
        }
        try {
            TrackerApp trackerApp;
            if (appRec.appName.equals("SimulatorAPI")) {
                Class[] classArray = new Class[]{String.class, Tracker.class, JFrame.class, TrackerSimInterface.class};
                Class<?> clazz = Class.forName(appRec.fullyQualifiedName);
                Constructor<?> constructor = clazz.getConstructor(classArray);
                Object[] objectArray = new Object[]{string2, tracker, jFrame, new TrkSimInterfaceImplementer()};
                trackerApp = (TrackerApp)constructor.newInstance(objectArray);
            } else {
                Class[] classArray = new Class[]{String.class, Tracker.class, JFrame.class};
                Class<?> clazz = Class.forName(appRec.fullyQualifiedName);
                Constructor<?> constructor = clazz.getConstructor(classArray);
                Object[] objectArray = new Object[]{string2, tracker, jFrame};
                trackerApp = (TrackerApp)constructor.newInstance(objectArray);
            }
            appRec.set(trackerApp);
            return trackerApp;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ApplicationFailedException(Tracker.res.getString("Class_Not_Found"));
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ApplicationFailedException(Tracker.res.getString("Illegal_Access"));
        }
        catch (InstantiationException instantiationException) {
            throw new ApplicationFailedException(Tracker.res.getString("Instantiation_Failed"));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ApplicationFailedException(Tracker.res.getString("Could_No_Get_Constructor"));
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ApplicationFailedException(Tracker.res.getString("Could_Not_Invoke_Application"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modifyApplication(String string, String string2) throws TrackerException {
        TrackerVectorSim trackerVectorSim = this;
        synchronized (trackerVectorSim) {
            AppRec appRec = this.findAppInfo(string);
            if (appRec.isSet()) {
                appRec.app.modifyParameters(string2);
            }
        }
    }

    @Override
    public TrackerApp stopApplication(String string) throws TrackerException {
        TrackerApp trackerApp = this.stopApplication(string, true);
        return trackerApp;
    }

    private AppRec findAppInfo(String string) throws TrackerException {
        int n;
        for (n = 0; n < this.appInfo.length && !string.equals(this.appInfo[n].appName); ++n) {
        }
        if (this.appInfo.length == n) {
            throw new ApplicationFailedException(Tracker.res.getString("Unknown_Application_Name"));
        }
        return this.appInfo[n];
    }

    private void localStopApplication(AppRec appRec) {
        appRec.app.stop();
        appRec.clear();
    }

    private void setAppInfo() throws TrackerException {
        this.appInfo = new AppRec[9];
        this.appInfo[0] = new AppRec("SimulatorAPI", "smx.tracker.AppsKeystoneSim.SimulatorAPI.SimulatorAPI");
        this.appInfo[1] = new AppRec("TrackerPad", "smx.tracker.apps4xxx.trackerpad.TrackerPad");
        this.appInfo[2] = new AppRec("CompIT", "smx.tracker.appskeystone.compit.CompIT");
        this.appInfo[3] = new AppRec("HealthChecks4xxx", "smx.tracker.apps4xxx.healthchecks.HealthChecks");
        this.appInfo[4] = new AppRec("MeasurePad", "smx.tracker.apps4xxx.measurepad.MeasurePad");
        this.appInfo[5] = new AppRec("Diagnostics4xxx", "smx.tracker.apps4xxx.diagnostics.Diagnostics");
        this.appInfo[6] = new AppRec("Closure", "smx.tracker.appskeystone.closure.Closure");
        this.appInfo[7] = new AppRec("HealthChecksKeystone", "smx.tracker.appskeystone.healthchecks.HealthChecks");
        this.appInfo[8] = new AppRec("DiagnosticsKeystone", "smx.tracker.appskeystone.diagnostics.Diagnostics");
    }

    private void clearAppInfo() throws TrackerException {
        if (null == this.appInfo) {
            return;
        }
        for (int i = 0; i < this.appInfo.length; ++i) {
            if (!this.appInfo[i].isSet()) continue;
            throw new InterfaceBusyException(Tracker.res.getString("Application_Running"));
        }
        this.appInfo = null;
    }

    @Override
    public String[] availableApplications() throws TrackerException {
        String[] stringArray = new String[this.appInfo.length];
        for (int i = 0; i < this.appInfo.length; ++i) {
            stringArray[i] = this.appInfo[i].appName;
        }
        return stringArray;
    }

    @Override
    public boolean standardPrivilege() throws TrackerException {
        if (!this.isConnected) {
            throw new NotConnectedException();
        }
        return this.accessLevel >= 0;
    }

    @Override
    public boolean adminPrivilege() throws TrackerException {
        if (!this.isConnected) {
            throw new NotConnectedException();
        }
        return this.accessLevel >= 1;
    }

    @Override
    public boolean factoryPrivilege() throws TrackerException {
        if (!this.isConnected) {
            throw new NotConnectedException();
        }
        return this.accessLevel >= 2;
    }

    @Override
    public String[] startedApplications() throws TrackerException {
        int n;
        int n2 = 0;
        if (null == this.appInfo) {
            return null;
        }
        for (n = 0; n < this.appInfo.length; ++n) {
            if (!this.appInfo[n].isSet()) continue;
            ++n2;
        }
        if (0 == n2) {
            return null;
        }
        String[] stringArray = new String[n2];
        int n3 = 0;
        for (n = 0; n < this.appInfo.length; ++n) {
            if (!this.appInfo[n].isSet()) continue;
            stringArray[n3] = this.appInfo[n].appName;
            ++n3;
        }
        return stringArray;
    }

    @Override
    public synchronized void writeFile(String string, String string2) throws TrackerException {
    }

    @Override
    public synchronized void readFile(String string, String string2) throws TrackerException {
    }

    @Override
    public void changeAlarmCfg(int n, AlarmType alarmType) throws TrackerException {
    }

    @Override
    public AlarmType alarmCfg(int n) throws TrackerException {
        return null;
    }

    @Override
    public int numExternalTempSensors() throws TrackerException {
        return this.NUM_EXT_TEMP_SENSORS;
    }

    @Override
    public ExtTempType externalTempType(int n) throws TrackerException {
        if (n < 1 || n > this.NUM_EXT_TEMP_SENSORS) {
            throw new UnsupportedFeatureException(Tracker.res.getString("Unknown_Sensor_Number"));
        }
        return new MaterialExtTemp();
    }

    @Override
    public void changeExternalTempType(int n, ExtTempType extTempType) throws TrackerException {
        throw new UnsupportedFeatureException();
    }

    @Override
    public double measureExternalTempSensor(int n) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public boolean externalTempTypeChangeable() throws TrackerException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executionDelay(int n) throws TrackerException {
        try {
            TrackerVectorSim trackerVectorSim = this;
            synchronized (trackerVectorSim) {
                this.workingThread = Thread.currentThread();
            }
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            TrackerVectorSim trackerVectorSim = this;
            synchronized (trackerVectorSim) {
                this.workingThread = null;
                this.notifyAll();
            }
        }
        catch (Exception exception) {
            throw new AbortedException();
        }
        finally {
            TrackerVectorSim trackerVectorSim = this;
            synchronized (trackerVectorSim) {
                this.workingThread = null;
                this.notifyAll();
            }
        }
    }

    public synchronized void sendPoints(double[] dArray, double[] dArray2, double d) {
        double[] dArray3 = new double[3];
        double[] dArray4 = new double[3];
        double[] dArray5 = new double[3];
        dArray3[0] = dArray[2] * Math.sin(dArray[1]) * Math.cos(dArray[0]);
        dArray3[1] = dArray[2] * Math.sin(dArray[1]) * Math.sin(dArray[0]);
        dArray3[2] = dArray[2] * Math.cos(dArray[1]);
        dArray4[0] = dArray2[2] * Math.sin(dArray2[1]) * Math.cos(dArray2[0]);
        dArray4[1] = dArray2[2] * Math.sin(dArray2[1]) * Math.sin(dArray2[0]);
        dArray4[2] = dArray2[2] * Math.cos(dArray2[1]);
        double d2 = Math.sqrt(Math.pow(dArray3[0] - dArray4[0], 2.0) + Math.pow(dArray3[1] - dArray4[1], 2.0) + Math.pow(dArray3[2] - dArray4[2], 2.0));
        int n = (int)Math.floor(d2 / d);
        for (int i = 0; i < n; ++i) {
            double[] dArray6 = new double[3];
            for (int j = 0; j < 3; ++j) {
                dArray5[j] = dArray4[j] - dArray3[j] > 0.0 ? dArray3[j] + d * (double)i : dArray3[j] - d * (double)i;
            }
            dArray6 = this.cartToSphere(dArray5[0], dArray5[1], dArray5[2]);
            this.al.add(dArray6);
        }
        this.notifyAll();
    }

    public synchronized double[] receivePoints() {
        while (this.al.size() == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.notifyAll();
        return (double[])this.al.remove(0);
    }

    public void relocateNestList(LinkedList linkedList) {
        this.nestList = new LinkedList();
        Nest nest = new Nest();
        Nest nest2 = new Nest();
        for (int i = 0; i < linkedList.size(); ++i) {
            double[] dArray = new double[3];
            double[] dArray2 = new double[3];
            nest = (Nest)linkedList.get(i);
            nest2 = (Nest)nest.clone();
            dArray = nest.getNestName().startsWith("TMR_") ? TMR_LOCATION : nest2.getPosition();
            dArray2 = this.coordinate == 1 ? dArray : (nest.getNestName().startsWith("TMR_") ? dArray : this.cartToSphere(dArray[0], dArray[1], dArray[2]));
            if (!nest.getNestName().startsWith("TMR_")) {
                dArray2 = this.coordTransferBack(dArray2, this.tracker.getPosition(), this.tracker.getRotation());
            }
            nest2.setAbsPosition(dArray2);
            this.nestList.add(i, nest2);
        }
    }

    private double[] backToFront(double d, double d2, double d3) {
        double[] dArray = new double[3];
        d += Math.PI;
        d = Math.IEEEremainder(d, Math.PI * 2);
        d2 = -d2;
        d2 = Math.IEEEremainder(d2, Math.PI * 2);
        dArray[0] = d;
        dArray[1] = d2;
        dArray[2] = d3;
        return dArray;
    }

    private double[] sphereToCart(double d, double d2, double d3) {
        double[] dArray = new double[]{d3 * Math.sin(d2) * Math.cos(d), d3 * Math.sin(d2) * Math.sin(d), d3 * Math.cos(d2)};
        return dArray;
    }

    private double[] cartToSphere(double d, double d2, double d3) {
        double[] dArray = new double[3];
        if (d != 0.0) {
            dArray[0] = Math.atan(d2 / d);
            if (d < 0.0 && d2 >= 0.0 || d > 0.0 && d2 < 0.0) {
                dArray[0] = dArray[0] + Math.PI;
            }
        } else if (d2 == 0.0) {
            if (d3 == 0.0) {
                return null;
            }
            dArray[0] = 0.0;
        } else {
            dArray[0] = 1.5707963267948966;
        }
        if (d2 < 0.0) {
            dArray[0] = dArray[0] + Math.PI;
        }
        dArray[2] = Math.sqrt(Math.pow(d, 2.0) + Math.pow(d2, 2.0) + Math.pow(d3, 2.0));
        dArray[1] = Math.acos(d3 / dArray[2]);
        dArray[0] = Math.IEEEremainder(dArray[0], Math.PI * 2);
        dArray[1] = Math.IEEEremainder(dArray[1], Math.PI * 2);
        return dArray;
    }

    public double[] coordTransfer(double[] dArray, double[] dArray2, double[] dArray3) {
        int n;
        double[][] dArray4 = new double[3][3];
        double[][] dArray5 = new double[3][3];
        double[][] dArray6 = new double[3][3];
        double[] dArray7 = new double[3];
        double[] dArray8 = new double[]{dArray[2] * Math.sin(dArray[1]) * Math.cos(dArray[0]), dArray[2] * Math.sin(dArray[1]) * Math.sin(dArray[0]), dArray[2] * Math.cos(dArray[1])};
        for (n = 0; n < 3; ++n) {
            dArray7[n] = dArray8[n];
            for (int i = 0; i < 3; ++i) {
                if (n != i) continue;
                dArray4[n][i] = 1.0;
                dArray5[n][i] = 1.0;
                dArray6[n][i] = 1.0;
            }
        }
        dArray4[1][1] = Math.cos(dArray3[0]);
        dArray4[2][2] = Math.cos(dArray3[0]);
        dArray4[1][2] = -Math.sin(dArray3[0]);
        dArray4[2][1] = Math.sin(dArray3[0]);
        dArray5[0][0] = Math.cos(dArray3[1]);
        dArray5[0][2] = Math.sin(dArray3[1]);
        dArray5[2][0] = -Math.sin(dArray3[1]);
        dArray5[2][2] = Math.cos(dArray3[1]);
        dArray6[0][0] = Math.cos(dArray3[2]);
        dArray6[0][1] = Math.sin(dArray3[2]);
        dArray6[1][0] = -Math.sin(dArray3[2]);
        dArray6[1][1] = Math.cos(dArray3[2]);
        dArray7 = this.MatrixTimesVector(dArray6, dArray7);
        dArray7 = this.MatrixTimesVector(dArray5, dArray7);
        dArray7 = this.MatrixTimesVector(dArray4, dArray7);
        for (n = 0; n < 3; ++n) {
            int n2 = n;
            dArray7[n2] = dArray7[n2] + dArray2[n];
        }
        dArray8 = this.cartToSphere(dArray7[0], dArray7[1], dArray7[2]);
        return dArray8;
    }

    private double[] coordTransferBack(double[] dArray, double[] dArray2, double[] dArray3) {
        double[][] dArray4 = new double[3][3];
        double[][] dArray5 = new double[3][3];
        double[][] dArray6 = new double[3][3];
        double[] dArray7 = new double[3];
        double[] dArray8 = new double[]{dArray[2] * Math.sin(dArray[1]) * Math.cos(dArray[0]), dArray[2] * Math.sin(dArray[1]) * Math.sin(dArray[0]), dArray[2] * Math.cos(dArray[1])};
        for (int i = 0; i < 3; ++i) {
            dArray7[i] = dArray8[i] - dArray2[i];
            for (int j = 0; j < 3; ++j) {
                if (i != j) continue;
                dArray4[i][j] = 1.0;
                dArray5[i][j] = 1.0;
                dArray6[i][j] = 1.0;
            }
        }
        dArray4[1][1] = Math.cos(dArray3[0]);
        dArray4[2][2] = Math.cos(dArray3[0]);
        dArray4[1][2] = Math.sin(dArray3[0]);
        dArray4[2][1] = -Math.sin(dArray3[0]);
        dArray5[0][0] = Math.cos(dArray3[1]);
        dArray5[0][2] = -Math.sin(dArray3[1]);
        dArray5[2][2] = Math.cos(dArray3[1]);
        dArray5[2][0] = Math.sin(dArray3[1]);
        dArray6[0][0] = Math.cos(dArray3[2]);
        dArray6[0][1] = Math.sin(dArray3[2]);
        dArray6[1][0] = -Math.sin(dArray3[2]);
        dArray6[1][1] = Math.cos(dArray3[2]);
        dArray7 = this.MatrixTimesVector(dArray4, dArray7);
        dArray7 = this.MatrixTimesVector(dArray5, dArray7);
        dArray7 = this.MatrixTimesVector(dArray6, dArray7);
        dArray8 = this.cartToSphere(dArray7[0], dArray7[1], dArray7[2]);
        return dArray8;
    }

    private double[] MatrixTimesVector(double[][] dArray, double[] dArray2) {
        double[] dArray3 = new double[3];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                int n = i;
                dArray3[n] = dArray3[n] + dArray[i][j] * dArray2[j];
            }
        }
        return dArray3;
    }

    public void loadData(String string) {
        LinkedList<Trackers> linkedList = new LinkedList<Trackers>();
        LinkedList<Trackers> linkedList2 = new LinkedList<Trackers>();
        LinkedList<Trackers> linkedList3 = new LinkedList<Trackers>();
        try {
            String string2;
            Object object;
            Object object2;
            String string3;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            while ((string3 = bufferedReader.readLine()) != null) {
                double[] dArray;
                Object object3;
                String string4 = "";
                String string5 = "";
                int n = string3.indexOf(59);
                object2 = n != -1 ? string3.substring(0, n) : string3;
                if (((String)object2).trim().equals("")) continue;
                int n2 = ((String)object2).indexOf(34, 0);
                if (n2 != -1 && (n = ((String)object2).indexOf(34, n2 + 1)) != -1) {
                    string4 = ((String)object2).substring(n2 + 1, n);
                    object = ((String)object2).substring(0, n2) + ((String)object2).substring(n + 1);
                } else {
                    object = object2;
                }
                n2 = ((String)object).indexOf(34, 0);
                if (n2 != -1 && (n = ((String)object).indexOf(34, n2 + 1)) != -1) {
                    string5 = ((String)object).substring(n2 + 1, n);
                    string2 = ((String)object).substring(0, n2) + ((String)object).substring(n + 1);
                } else {
                    string2 = object;
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string2, " \t\n\r");
                String string6 = stringTokenizer.nextToken();
                if (string6.equals("TRACKER")) {
                    int n3;
                    object3 = new Trackers();
                    object3.setName(string4);
                    object3.setIPAddress(stringTokenizer.nextToken());
                    if (string5 != null) {
                        object3.setClassmate(string5);
                    }
                    dArray = new double[3];
                    double[] dArray2 = new double[3];
                    for (n3 = 0; n3 < 3; ++n3) {
                        dArray[n3] = new Double(stringTokenizer.nextToken());
                    }
                    for (n3 = 0; n3 < 3; ++n3) {
                        dArray2[n3] = new Double(stringTokenizer.nextToken());
                    }
                    object3.setAbsPosition(dArray, dArray2);
                    linkedList.add((Trackers)object3);
                    continue;
                }
                if (string6.equals("NEST")) {
                    object3 = new Nest();
                    object3.setNestName(string4);
                    if (string5 != null) {
                        object3.setClassmateName(string5);
                    }
                    dArray = new double[3];
                    for (int i = 0; i < 3; ++i) {
                        dArray[i] = new Double(stringTokenizer.nextToken());
                    }
                    object3.setAbsPosition(dArray);
                    linkedList2.add((Trackers)object3);
                    continue;
                }
                if (string6.equals("TARGET")) {
                    object3 = new Target();
                    object3.setTargetName(string4);
                    object3.setClassmate(string5);
                    if (stringTokenizer.nextToken().equals("YES")) {
                        object3.setTargetStatus("Blocked");
                    } else {
                        object3.setTargetStatus("");
                    }
                    linkedList3.add((Trackers)object3);
                    continue;
                }
                if (string6.equals("MATERIAL_TEMP")) {
                    this.materialTemp.setTemperature(new Double(stringTokenizer.nextToken()).doubleValue());
                    this.materialTemp.setStatus(new Integer(stringTokenizer.nextToken()).intValue());
                    continue;
                }
                if (string6.equals("NOISE")) {
                    object3 = new double[4];
                    while (stringTokenizer.countTokens() != 0) {
                        for (int i = 0; i < 4; ++i) {
                            object3[i] = (Trackers)new Double(stringTokenizer.nextToken());
                        }
                    }
                    this.noise.setNoise((double[])object3);
                    continue;
                }
                if (!string6.equals("COORDINATE_SYSTEM_TYPE") || stringTokenizer.countTokens() == 0) continue;
                this.coordinate = new Integer(stringTokenizer.nextToken());
                if (this.coordinate >= 0 && this.coordinate <= 1) continue;
                this.coordinate = 0;
            }
            bufferedReader.close();
            this.trackerList = linkedList;
            this.nestList = linkedList2;
            this.targetList = linkedList3;
            if (this.trackerList.size() == 0) {
                Trackers trackers = new Trackers();
                trackers.setIPAddress("128.128.128.100");
                trackers.setName("DefaultTracker");
                this.trackerList.add(trackers);
                Nest nest = new Nest();
                nest.setNestName("TMR_DefaultTracker");
                object2 = TMR_LOCATION;
                if (this.coordinate == 0) {
                    object2 = this.sphereToCart((double)object2[0], (double)object2[1], (double)object2[2]);
                }
                nest.setAbsPosition((double[])object2);
                this.nestList.add(nest);
            }
            for (int i = 0; i < this.trackerList.size(); ++i) {
                Trackers trackers = (Trackers)this.trackerList.get(i);
                object2 = new Nest();
                if (!trackers.getClassmate().equals("")) {
                    object2.setClassmateName(trackers.getClassmate());
                }
                object2.setNestName("TMR_" + trackers.getName());
                object = TMR_LOCATION;
                if (this.coordinate == 0) {
                    object = this.sphereToCart((double)object[0], (double)object[1], (double)object[2]);
                }
                object2.setAbsPosition((double[])object);
                this.nestList.add(object2);
                string2 = new Target();
                if (trackers.getClassmate().equals("")) continue;
                string2.setTargetName(trackers.getClassmate());
                string2.setClassmate("TMR_" + trackers.getName());
                this.targetList.add(string2);
            }
        }
        catch (IOException iOException) {
            Trackers trackers = new Trackers();
            trackers.setIPAddress("128.128.128.100");
            trackers.setName("DefaultTracker");
            this.trackerList.add(trackers);
            Nest nest = new Nest();
            nest.setNestName("TMR_DefaultTracker");
            double[] dArray = TMR_LOCATION;
            dArray = this.sphereToCart(dArray[0], dArray[1], dArray[2]);
            nest.setAbsPosition(dArray);
            this.nestList.add(nest);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    private void saveData() {
        try {
            int n;
            double[] dArray;
            Trackers trackers;
            int n2;
            PrintWriter printWriter = new PrintWriter((Writer)new FileWriter("result.dat"), true);
            printWriter.println(";tracker information");
            for (n2 = 0; n2 < this.trackerList.size(); ++n2) {
                trackers = (Trackers)this.trackerList.get(n2);
                printWriter.print("TRACKER \"" + trackers.getName() + "\" " + trackers.getIPAddress() + " ");
                dArray = trackers.getPosition();
                for (n = 0; n < 3; ++n) {
                    printWriter.print(new Double(dArray[n]).toString() + " ");
                }
                dArray = trackers.getRotation();
                for (n = 0; n < 3; ++n) {
                    printWriter.print(new Double(dArray[n]).toString() + " ");
                }
                if (!trackers.getClassmate().equals("")) {
                    printWriter.print("\"" + trackers.getClassmate() + "\"");
                }
                printWriter.println("");
            }
            printWriter.println(";nest information");
            if (this.nestList.size() != 0) {
                this.nestList.removeFirst();
            }
            for (n2 = 0; n2 < this.nestList.size(); ++n2) {
                trackers = (Nest)this.nestList.get(n2);
                printWriter.print("NEST \"" + trackers.getNestName() + "\" ");
                dArray = trackers.getPosition();
                for (n = 0; n < 3; ++n) {
                    printWriter.print(new Double(dArray[n]).toString() + " ");
                }
                if (trackers.getClassmateName() != "") {
                    printWriter.print("\"" + trackers.getClassmateName() + "\"");
                }
                printWriter.println("");
            }
            printWriter.println(";target information");
            for (n2 = 0; n2 < this.targetList.size(); ++n2) {
                trackers = (Target)this.targetList.get(n2);
                if (!trackers.getClassmate().equals("TMR")) continue;
                this.targetList.remove(n2);
            }
            for (n2 = 0; n2 < this.targetList.size(); ++n2) {
                trackers = (Target)this.targetList.get(n2);
                printWriter.print("TARGET \"" + trackers.getTargetName() + "\" \"" + trackers.getClassmate() + "\" ");
                if (trackers.getTargetStatus().equals("")) {
                    printWriter.print("NO");
                } else {
                    printWriter.print("YES");
                }
                printWriter.println("");
            }
            printWriter.println(";material temperature");
            printWriter.print("MATERIAL_TEMP " + this.materialTemp.getTemperature() + " " + this.materialTemp.getStatus());
            printWriter.println("");
            printWriter.println(";noise");
            printWriter.print("NOISE ");
            double[] dArray2 = this.noise.getNoise();
            for (int i = 0; i < 4; ++i) {
                printWriter.print(new Double(dArray2[i]).toString() + " ");
            }
            printWriter.println("");
            printWriter.println(";coordinate system");
            printWriter.print("COORDINATE_SYSTEM_TYPE " + this.coordinate);
            printWriter.println("");
            printWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void initDatabase() {
        this.database.put("Weather.Device.Air Pressure.Compensation.Data Sheet.T0", new Double(0.23546875));
        this.database.put("Weather.Device.Air Pressure.Compensation.Data Sheet.a20", new Double(-0.0512315));
        this.database.put("Weather.Device.Air Pressure.Compensation.Data Sheet.a11", new Double(0.0208004));
        this.database.put("Weather.Device.Air Pressure.Compensation.Data Sheet.k", new Double(2.0));
        this.database.put("Weather.Device.Air Pressure.Compensation.Data Sheet.a30", new Double(0.00358119));
        this.database.put("Weather.Device.Air Pressure.Compensation.Data Sheet.a21", new Double(-0.00591751));
        this.database.put("Weather.Device.Air Pressure.Compensation.Data Sheet.a00", new Double(-0.0529813));
        this.database.put("Weather.Device.Air Pressure.Compensation.Data Sheet.a01", new Double(0.0226044));
        this.database.put("Weather.Device.Air Pressure.Compensation.Data Sheet.a31", new Double(0.00405172));
        this.database.put("Weather.Device.Air Pressure.Compensation.Data Sheet.a10", new Double(0.672379));
        this.database.put("Weather.Device.Air Pressure.Compensation.Data Sheet.a02", new Double(-0.0269995));
        this.database.put("Weather.Device.Air Pressure.Compensation.Data Sheet.a12", new Double(0.0024508));
        this.database.put("Weather.Device.Air Pressure.Reading", new Double(500.0));
        this.database.put("Weather.Device.Air Pressure.Compensation.Offset", new Double(100.0));
        this.database.put("Weather.Device.Humidity.Compensation.Data Sheet.Offset", new Double(0.865));
        this.database.put("Weather.Device.Humidity.Compensation.Data Sheet.Scale", new Double(32.352));
        this.database.put("System.Stored Location.1 1/2 TMR.Azimuth", new Double(1.5));
        this.database.put("System.Stored Location.1 1/2 TMR.Zenith", new Double(1.5));
        this.database.put("System.Stored Location.1 1/2 TMR.Distance", new Double(1.5));
        this.database.put("System.Stored Location.1 1/2 TMR.Azimuth Backsight", new Double(181.5));
        this.database.put("System.Stored Location.1 1/2 TMR.Zenith Backsight", new Double(-1.5));
        this.database.put("System.Stored Location.1 1/2 TMR.Distance Backsight", new Double(1.5));
        this.database.put("System.Stored Location.1/2 TMR.Azimuth", new Double(0.5));
        this.database.put("System.Stored Location.1/2 TMR.Zenith", new Double(0.5));
        this.database.put("System.Stored Location.1/2 TMR.Distance", new Double(0.5));
        this.database.put("System.Stored Location.1/2 TMR.Azimuth Backsight", new Double(180.5));
        this.database.put("System.Stored Location.1/2 TMR.Zenith Backsight", new Double(-0.5));
        this.database.put("System.Stored Location.1/2 TMR.Distance Backsight", new Double(0.5));
        this.database.put("System.Stored Location.7/8 TMR.Azimuth", new Double(0.875));
        this.database.put("System.Stored Location.7/8 TMR.Zenith", new Double(0.875));
        this.database.put("System.Stored Location.7/8 TMR.Distance", new Double(0.875));
        this.database.put("System.Stored Location.7/8 TMR.Azimuth Backsight", new Double(180.875));
        this.database.put("System.Stored Location.7/8 TMR.Zenith Backsight", new Double(-0.875));
        this.database.put("System.Stored Location.7/8 TMR.Distance Backsight", new Double(0.875));
        this.database.put("System.Stored Location.Cube.Azimuth", new Double(1.0));
        this.database.put("System.Stored Location.Cube.Zenith", new Double(1.0));
        this.database.put("System.Stored Location.Cube.Distance", new Double(1.0));
        this.database.put("System.Stored Location.Cube.Azimuth Backsight", new Double(4.14));
        this.database.put("System.Stored Location.Cube.Zenith Backsight", new Double(-1.0));
        this.database.put("System.Stored Location.Cube.Distance Backsight", new Double(1.0));
        this.database.put("System.Stored Location.Mirror.Azimuth", new Double(2.0));
        this.database.put("System.Stored Location.Mirror.Zenith", new Double(2.0));
        this.database.put("System.Stored Location.Mirror.Distance", new Double(2.0));
        this.database.put("System.Stored Location.Mirror.Azimuth Backsight", new Double(5.14));
        this.database.put("System.Stored Location.Mirror.Zenith Backsight", new Double(-2.0));
        this.database.put("System.Stored Location.Mirror.Distance Backsight", new Double(2.0));
        this.database.put("Position Device.PSD.Raw.A", new Double(0.25));
        this.database.put("Position Device.PSD.Raw.B", new Double(0.25));
        this.database.put("Position Device.PSD.Raw.C", new Double(0.25));
        this.database.put("Position Device.PSD.Raw.D", new Double(0.25));
        this.database.put("Position Device.PSD.Scale", new Double(0.25));
        this.database.put("Position Device.Azimuth Encoder.Raw", new Double(0.8));
        this.database.put("Position Device.Zenith Encoder.Raw", new Double(0.8));
        this.database.put("Position Device.Azimuth Encoder.Compensation.Map1", new Double(0.0));
        this.database.put("Position Device.Azimuth Encoder.Compensation.Map2", new Double(0.0));
        this.database.put("Position Device.Azimuth Encoder.Compensation.Map3", new Double(0.0));
        this.database.put("Position Device.Azimuth Encoder.Compensation.Map4", new Double(0.0));
        this.database.put("Position Device.Azimuth Encoder.Compensation.Map5", new Double(0.0));
        this.database.put("Position Device.Azimuth Encoder.Compensation.Map6", new Double(0.0));
        this.database.put("Position Device.Azimuth Encoder.Compensation.Map7", new Double(0.0));
        this.database.put("Position Device.Azimuth Encoder.Compensation.Map8", new Double(0.0));
        this.database.put("Position Device.Azimuth Encoder.Compensation.Map9", new Double(0.0));
        this.database.put("Position Device.Azimuth Encoder.Compensation.Map10", new Double(0.0));
        this.database.put("Position Device.Azimuth Encoder.Compensation.Map11", new Double(0.0));
        this.database.put("Position Device.Azimuth Encoder.Compensation.Map12", new Double(0.0));
        this.database.put("Position Device.Azimuth Encoder.Compensation.Map13", new Double(0.0));
        this.database.put("Position Device.Azimuth Encoder.Compensation.Map14", new Double(0.0));
        this.database.put("Position Device.Azimuth Encoder.Compensation.Map15", new Double(0.0));
        this.database.put("Position Device.Azimuth Encoder.Compensation.Map16", new Double(0.0));
        this.database.put("Position Device.Azimuth Encoder.Compensation.Map17", new Double(0.0));
        this.database.put("Position Device.Azimuth Encoder.Compensation.Map18", new Double(0.0));
        this.database.put("Position Device.Azimuth Encoder.Compensation.Map19", new Double(0.0));
        this.database.put("Position Device.Azimuth Encoder.Compensation.Map20", new Double(0.0));
        this.database.put("Position Device.Azimuth Encoder.Compensation.Map21", new Double(0.0));
        this.database.put("Position Device.Azimuth Encoder.Compensation.Map22", new Double(0.0));
        this.database.put("Position Device.Azimuth Encoder.Compensation.Map23", new Double(0.0));
        this.database.put("Position Device.Azimuth Encoder.Compensation.Map24", new Double(0.0));
        this.database.put("Position Device.Azimuth Encoder.Compensation.Map25", new Double(0.0));
        this.database.put("Position Device.Azimuth Encoder.Compensation.Map26", new Double(0.0));
        this.database.put("Position Device.Azimuth Encoder.Compensation.Map27", new Double(0.0));
        this.database.put("Position Device.Azimuth Encoder.Compensation.Map28", new Double(0.0));
        this.database.put("Position Device.Azimuth Encoder.Compensation.Map29", new Double(0.0));
        this.database.put("Position Device.Azimuth Encoder.Compensation.Map30", new Double(0.0));
        this.database.put("Position Device.Azimuth Encoder.Compensation.Map31", new Double(0.0));
        this.database.put("Position Device.Azimuth Encoder.Compensation.Map32", new Double(0.0));
        this.database.put("Position Device.Azimuth Encoder.Compensation.Map33", new Double(0.0));
        this.database.put("Position Device.Azimuth Encoder.Compensation.Map34", new Double(0.0));
        this.database.put("Position Device.Azimuth Encoder.Compensation.Map35", new Double(0.0));
        this.database.put("Position Device.Azimuth Encoder.Compensation.Map36", new Double(0.0));
        this.database.put("Position Device.Azimuth Encoder.Compensation.Map37", new Double(0.0));
        this.database.put("Position Device.Azimuth Encoder.Compensation.Map38", new Double(0.0));
        this.database.put("Position Device.Azimuth Encoder.Compensation.Map39", new Double(0.0));
        this.database.put("Position Device.Azimuth Encoder.Compensation.Map40", new Double(0.0));
        this.database.put("Position Device.Azimuth Encoder.Compensation.Map41", new Double(0.0));
        this.database.put("Position Device.Azimuth Encoder.Compensation.Map42", new Double(0.0));
        this.database.put("Position Device.Azimuth Encoder.Compensation.Map43", new Double(0.0));
        this.database.put("Position Device.Azimuth Encoder.Compensation.Map44", new Double(0.0));
        this.database.put("Position Device.Azimuth Encoder.Compensation.Map45", new Double(0.0));
        this.database.put("Position Device.Azimuth Encoder.Compensation.Map46", new Double(0.0));
        this.database.put("Position Device.Azimuth Encoder.Compensation.Map47", new Double(0.0));
        this.database.put("Position Device.Azimuth Encoder.Compensation.Map48", new Double(0.0));
        this.database.put("Position Device.Azimuth Encoder.Compensation.Map49", new Double(0.0));
        this.database.put("Position Device.Azimuth Encoder.Compensation.Map50", new Double(0.0));
        this.database.put("Position Device.Azimuth Encoder.Compensation.Map51", new Double(0.0));
        this.database.put("Position Device.Azimuth Encoder.Compensation.Map52", new Double(0.0));
        this.database.put("Position Device.Azimuth Encoder.Compensation.Map53", new Double(0.0));
        this.database.put("Position Device.Azimuth Encoder.Compensation.Map54", new Double(0.0));
        this.database.put("Position Device.Azimuth Encoder.Compensation.Map55", new Double(0.0));
        this.database.put("Position Device.Azimuth Encoder.Compensation.Map56", new Double(0.0));
        this.database.put("Position Device.Azimuth Encoder.Compensation.Map57", new Double(0.0));
        this.database.put("Position Device.Azimuth Encoder.Compensation.Map58", new Double(0.0));
        this.database.put("Position Device.Azimuth Encoder.Compensation.Map59", new Double(0.0));
        this.database.put("Position Device.Azimuth Encoder.Compensation.Map60", new Double(0.0));
        this.database.put("Position Device.Azimuth Encoder.Compensation.Map61", new Double(0.0));
        this.database.put("Position Device.Azimuth Encoder.Compensation.Map62", new Double(0.0));
        this.database.put("Position Device.Azimuth Encoder.Compensation.Map63", new Double(0.0));
        this.database.put("Position Device.Azimuth Encoder.Compensation.Map64", new Double(0.0));
        this.database.put("Position Device.Azimuth Encoder.Compensation.Map65", new Double(0.0));
        this.database.put("Position Device.Azimuth Encoder.Compensation.Map66", new Double(0.0));
        this.database.put("Position Device.Azimuth Encoder.Compensation.Map67", new Double(0.0));
        this.database.put("Position Device.Azimuth Encoder.Compensation.Map68", new Double(0.0));
        this.database.put("Position Device.Azimuth Encoder.Compensation.Map69", new Double(0.0));
        this.database.put("Position Device.Azimuth Encoder.Compensation.Map70", new Double(0.0));
        this.database.put("Position Device.Azimuth Encoder.Compensation.Map71", new Double(0.0));
        this.database.put("Position Device.Azimuth Encoder.Compensation.Map72", new Double(0.0));
        this.database.put("Position Device.Zenith Encoder.Compensation.Map1", new Double(90.0));
        this.database.put("Position Device.Zenith Encoder.Compensation.Map2", new Double(90.0));
        this.database.put("Position Device.Zenith Encoder.Compensation.Map3", new Double(90.0));
        this.database.put("Position Device.Zenith Encoder.Compensation.Map4", new Double(90.0));
        this.database.put("Position Device.Zenith Encoder.Compensation.Map5", new Double(90.0));
        this.database.put("Position Device.Zenith Encoder.Compensation.Map6", new Double(90.0));
        this.database.put("Position Device.Zenith Encoder.Compensation.Map7", new Double(90.0));
        this.database.put("Position Device.Zenith Encoder.Compensation.Map8", new Double(90.0));
        this.database.put("Position Device.Zenith Encoder.Compensation.Map9", new Double(90.0));
        this.database.put("Position Device.Zenith Encoder.Compensation.Map10", new Double(90.0));
        this.database.put("Position Device.Zenith Encoder.Compensation.Map11", new Double(90.0));
        this.database.put("Position Device.Zenith Encoder.Compensation.Map12", new Double(90.0));
        this.database.put("Position Device.Zenith Encoder.Compensation.Map13", new Double(90.0));
        this.database.put("Position Device.Zenith Encoder.Compensation.Map14", new Double(90.0));
        this.database.put("Position Device.Zenith Encoder.Compensation.Map15", new Double(90.0));
        this.database.put("Position Device.Zenith Encoder.Compensation.Map16", new Double(90.0));
        this.database.put("Position Device.Zenith Encoder.Compensation.Map17", new Double(90.0));
        this.database.put("Position Device.Zenith Encoder.Compensation.Map18", new Double(90.0));
        this.database.put("Position Device.Zenith Encoder.Compensation.Map19", new Double(90.0));
        this.database.put("Position Device.Zenith Encoder.Compensation.Map20", new Double(90.0));
        this.database.put("Position Device.Zenith Encoder.Compensation.Map21", new Double(90.0));
        this.database.put("Position Device.Zenith Encoder.Compensation.Map22", new Double(90.0));
        this.database.put("Position Device.Zenith Encoder.Compensation.Map23", new Double(90.0));
        this.database.put("Position Device.Zenith Encoder.Compensation.Map24", new Double(90.0));
        this.database.put("Position Device.Zenith Encoder.Compensation.Map25", new Double(90.0));
        this.database.put("Position Device.Zenith Encoder.Compensation.Map26", new Double(90.0));
        this.database.put("Position Device.Zenith Encoder.Compensation.Map27", new Double(90.0));
        this.database.put("Position Device.Zenith Encoder.Compensation.Map28", new Double(90.0));
        this.database.put("Position Device.Zenith Encoder.Compensation.Map29", new Double(90.0));
        this.database.put("Position Device.Zenith Encoder.Compensation.Map30", new Double(90.0));
        this.database.put("Position Device.Zenith Encoder.Compensation.Map31", new Double(90.0));
        this.database.put("Position Device.Zenith Encoder.Compensation.Map32", new Double(90.0));
        this.database.put("Position Device.Zenith Encoder.Compensation.Map33", new Double(90.0));
        this.database.put("Position Device.Zenith Encoder.Compensation.Map34", new Double(90.0));
        this.database.put("Position Device.Zenith Encoder.Compensation.Map35", new Double(90.0));
        this.database.put("Position Device.Zenith Encoder.Compensation.Map36", new Double(90.0));
        this.database.put("Position Device.Zenith Encoder.Compensation.Map37", new Double(90.0));
        this.database.put("Position Device.Zenith Encoder.Compensation.Map38", new Double(90.0));
        this.database.put("Position Device.Zenith Encoder.Compensation.Map39", new Double(90.0));
        this.database.put("Position Device.Zenith Encoder.Compensation.Map40", new Double(90.0));
        this.database.put("Position Device.Zenith Encoder.Compensation.Map41", new Double(90.0));
        this.database.put("Position Device.Zenith Encoder.Compensation.Map42", new Double(90.0));
        this.database.put("Position Device.Zenith Encoder.Compensation.Map43", new Double(90.0));
        this.database.put("Position Device.Zenith Encoder.Compensation.Map44", new Double(90.0));
        this.database.put("Position Device.Zenith Encoder.Compensation.Map45", new Double(90.0));
        this.database.put("Position Device.Zenith Encoder.Compensation.Map46", new Double(90.0));
        this.database.put("Position Device.Zenith Encoder.Compensation.Map47", new Double(90.0));
        this.database.put("Position Device.Zenith Encoder.Compensation.Map48", new Double(90.0));
        this.database.put("Position Device.Zenith Encoder.Compensation.Map49", new Double(90.0));
        this.database.put("Position Device.Zenith Encoder.Compensation.Map50", new Double(90.0));
        this.database.put("Position Device.Zenith Encoder.Compensation.Map51", new Double(90.0));
        this.database.put("Position Device.Zenith Encoder.Compensation.Map52", new Double(90.0));
        this.database.put("Position Device.Zenith Encoder.Compensation.Map53", new Double(90.0));
        this.database.put("Position Device.Zenith Encoder.Compensation.Map54", new Double(90.0));
        this.database.put("Position Device.Zenith Encoder.Compensation.Map55", new Double(90.0));
        this.database.put("Position Device.Zenith Encoder.Compensation.Map56", new Double(90.0));
        this.database.put("Position Device.Zenith Encoder.Compensation.Map57", new Double(90.0));
        this.database.put("Position Device.Zenith Encoder.Compensation.Map58", new Double(90.0));
        this.database.put("Position Device.Zenith Encoder.Compensation.Map59", new Double(90.0));
        this.database.put("Position Device.Zenith Encoder.Compensation.Map60", new Double(90.0));
        this.database.put("Position Device.Zenith Encoder.Compensation.Map61", new Double(90.0));
        this.database.put("Position Device.Zenith Encoder.Compensation.Map62", new Double(90.0));
        this.database.put("Position Device.Zenith Encoder.Compensation.Map63", new Double(90.0));
        this.database.put("Position Device.Zenith Encoder.Compensation.Map64", new Double(90.0));
        this.database.put("Position Device.Zenith Encoder.Compensation.Map65", new Double(90.0));
        this.database.put("Position Device.Zenith Encoder.Compensation.Map66", new Double(90.0));
        this.database.put("Position Device.Zenith Encoder.Compensation.Map67", new Double(90.0));
        this.database.put("Position Device.Zenith Encoder.Compensation.Map68", new Double(90.0));
        this.database.put("Position Device.Zenith Encoder.Compensation.Map69", new Double(90.0));
        this.database.put("Position Device.Zenith Encoder.Compensation.Map70", new Double(90.0));
        this.database.put("Position Device.Zenith Encoder.Compensation.Map71", new Double(90.0));
        this.database.put("Position Device.Zenith Encoder.Compensation.Map72", new Double(90.0));
        this.database.put("Standard.Encoder.Raw", new Double(0.0));
        this.database.put("Weather.Device.Temperature.Ext1.Raw", new Double(25.0));
        this.database.put("Weather.Device.Temperature.Ext2.Raw", new Double(25.0));
        this.database.put("Weather.Device.Temperature.Ext3.Raw", new Double(25.0));
        this.database.put("Weather.Device.Temperature.Ext4.Raw", new Double(25.0));
        this.database.put("Weather.Device.Temperature.Ext5.Raw", new Double(25.0));
        this.database.put("Weather.Device.Temperature.Ext6.Raw", new Double(25.0));
        this.database.put("Weather.Device.Temperature.Ext7.Raw", new Double(25.0));
        this.database.put("Weather.Device.Temperature.Ext8.Raw", new Double(25.0));
        this.database.put("Weather.Device.Temperature.Ext1.Compensation.A", new Double(0.1));
        this.database.put("Weather.Device.Temperature.Ext1.Compensation.B", new Double(0.1));
        this.database.put("Weather.Device.Temperature.Ext1.Compensation.C", new Double(0.1));
        this.database.put("Weather.Device.Temperature.Ext2.Compensation.A", new Double(0.2));
        this.database.put("Weather.Device.Temperature.Ext2.Compensation.B", new Double(0.2));
        this.database.put("Weather.Device.Temperature.Ext2.Compensation.C", new Double(0.2));
        this.database.put("Weather.Device.Temperature.Ext3.Compensation.A", new Double(0.3));
        this.database.put("Weather.Device.Temperature.Ext3.Compensation.B", new Double(0.3));
        this.database.put("Weather.Device.Temperature.Ext3.Compensation.C", new Double(0.3));
        this.database.put("Weather.Device.Temperature.Ext4.Compensation.A", new Double(0.4));
        this.database.put("Weather.Device.Temperature.Ext4.Compensation.B", new Double(0.4));
        this.database.put("Weather.Device.Temperature.Ext4.Compensation.C", new Double(0.4));
        this.database.put("Weather.Device.Temperature.Ext5.Compensation.A", new Double(0.5));
        this.database.put("Weather.Device.Temperature.Ext5.Compensation.B", new Double(0.5));
        this.database.put("Weather.Device.Temperature.Ext5.Compensation.C", new Double(0.5));
        this.database.put("Weather.Device.Temperature.Ext6.Compensation.A", new Double(0.6));
        this.database.put("Weather.Device.Temperature.Ext6.Compensation.B", new Double(0.6));
        this.database.put("Weather.Device.Temperature.Ext6.Compensation.C", new Double(0.6));
        this.database.put("Weather.Device.Temperature.Ext7.Compensation.A", new Double(0.7));
        this.database.put("Weather.Device.Temperature.Ext7.Compensation.B", new Double(0.7));
        this.database.put("Weather.Device.Temperature.Ext7.Compensation.C", new Double(0.7));
        this.database.put("Weather.Device.Temperature.Ext8.Compensation.A", new Double(0.8));
        this.database.put("Weather.Device.Temperature.Ext8.Compensation.B", new Double(0.8));
        this.database.put("Weather.Device.Temperature.Ext8.Compensation.C", new Double(0.8));
        this.database.put("Weather.Device.Temperature.Installed.Raw.Value", new Double(25.0));
        this.database.put("Weather.Device.Temperature.Installed.Raw.Status", new Long(0L));
        this.database.put("Weather.Device.Temperature.Installed.Compensation.A", new Double(0.1));
        this.database.put("Weather.Device.Temperature.Installed.Compensation.B", new Double(0.1));
        this.database.put("Weather.Device.Temperature.Installed.Compensation.C", new Double(0.1));
        this.database.put("System.Device.Temperature.Int1.Raw", new Double(25.0));
        this.database.put("System.Device.Temperature.Int2.Raw", new Double(25.0));
        this.database.put("System.Device.Temperature.Int3.Raw", new Double(25.0));
        this.database.put("System.Device.Temperature.Int4.Raw", new Double(25.0));
        this.database.put("System.Device.Temperature.Int5.Raw", new Double(25.0));
        this.database.put("System.Device.Temperature.Int6.Raw", new Double(25.0));
        this.database.put("System.Device.Temperature.Int7.Raw", new Double(25.0));
        this.database.put("System.Device.Temperature.Isolator.Raw", new Double(25.0));
        this.database.put("FanCtrl.1.Temperature.Raw", new Double(25.0));
        this.database.put("FanCtrl.2.Temperature.Raw", new Double(25.0));
        this.database.put("FanCtrl.3.Temperature.Raw", new Double(25.0));
        this.database.put("FanCtrl.4.Temperature.Raw", new Double(25.0));
        this.database.put("System.Device.Temperature.Int1.Compensation.A", new Double(0.1));
        this.database.put("System.Device.Temperature.Int1.Compensation.B", new Double(0.1));
        this.database.put("System.Device.Temperature.Int1.Compensation.C", new Double(0.1));
        this.database.put("System.Device.Temperature.Int2.Compensation.A", new Double(0.2));
        this.database.put("System.Device.Temperature.Int2.Compensation.B", new Double(0.2));
        this.database.put("System.Device.Temperature.Int2.Compensation.C", new Double(0.2));
        this.database.put("System.Device.Temperature.Int3.Compensation.A", new Double(0.3));
        this.database.put("System.Device.Temperature.Int3.Compensation.B", new Double(0.3));
        this.database.put("System.Device.Temperature.Int3.Compensation.C", new Double(0.3));
        this.database.put("System.Device.Temperature.Int4.Compensation.A", new Double(0.4));
        this.database.put("System.Device.Temperature.Int4.Compensation.B", new Double(0.4));
        this.database.put("System.Device.Temperature.Int4.Compensation.C", new Double(0.4));
        this.database.put("System.Device.Temperature.Int5.Compensation.A", new Double(0.5));
        this.database.put("System.Device.Temperature.Int5.Compensation.B", new Double(0.5));
        this.database.put("System.Device.Temperature.Int5.Compensation.C", new Double(0.5));
        this.database.put("System.Device.Temperature.Int6.Compensation.A", new Double(0.6));
        this.database.put("System.Device.Temperature.Int6.Compensation.B", new Double(0.6));
        this.database.put("System.Device.Temperature.Int6.Compensation.C", new Double(0.6));
        this.database.put("System.Device.Temperature.Int7.Compensation.A", new Double(0.7));
        this.database.put("System.Device.Temperature.Int7.Compensation.B", new Double(0.7));
        this.database.put("System.Device.Temperature.Int7.Compensation.C", new Double(0.7));
        this.database.put("System.Device.Temperature.Isolator.Compensation.A", new Double(0.8));
        this.database.put("System.Device.Temperature.Isolator.Compensation.B", new Double(0.8));
        this.database.put("System.Device.Temperature.Isolator.Compensation.C", new Double(0.8));
        this.database.put("FanCtrl.1.Temperature.Compensation.A", new Double(0.9));
        this.database.put("FanCtrl.1.Temperature.Compensation.B", new Double(0.9));
        this.database.put("FanCtrl.1.Temperature.Compensation.C", new Double(0.9));
        this.database.put("FanCtrl.2.Temperature.Compensation.A", new Double(10.0));
        this.database.put("FanCtrl.2.Temperature.Compensation.B", new Double(10.0));
        this.database.put("FanCtrl.2.Temperature.Compensation.C", new Double(10.0));
        this.database.put("FanCtrl.3.Temperature.Compensation.A", new Double(11.0));
        this.database.put("FanCtrl.3.Temperature.Compensation.B", new Double(11.0));
        this.database.put("FanCtrl.3.Temperature.Compensation.C", new Double(11.0));
        this.database.put("FanCtrl.4.Temperature.Compensation.A", new Double(12.0));
        this.database.put("FanCtrl.4.Temperature.Compensation.B", new Double(12.0));
        this.database.put("FanCtrl.4.Temperature.Compensation.C", new Double(12.0));
        this.database.put("FanCtrl.1.Command Output", new Double(0.1));
        this.database.put("FanCtrl.1.Temperature.Raw", new Double(25.1));
        this.database.put("FanCtrl.1.Set Point", new Double(1.0));
        this.database.put("FanCtrl.1.P", new Double(1.0));
        this.database.put("FanCtrl.1.I", new Double(1.0));
        this.database.put("FanCtrl.1.D", new Double(1.0));
        this.database.put("FanCtrl.2.Command Output", new Double(0.2));
        this.database.put("FanCtrl.2.Temperature.Raw", new Double(25.2));
        this.database.put("FanCtrl.2.Set Point", new Double(2.0));
        this.database.put("FanCtrl.2.P", new Double(2.0));
        this.database.put("FanCtrl.2.I", new Double(2.0));
        this.database.put("FanCtrl.2.D", new Double(2.0));
        this.database.put("FanCtrl.3.Command Output", new Double(0.3));
        this.database.put("FanCtrl.3.Temperature.Raw", new Double(25.3));
        this.database.put("FanCtrl.3.Set Point", new Double(3.0));
        this.database.put("FanCtrl.3.P", new Double(3.0));
        this.database.put("FanCtrl.3.I", new Double(3.0));
        this.database.put("FanCtrl.3.D", new Double(3.0));
        this.database.put("FanCtrl.4.Command Output", new Double(0.4));
        this.database.put("FanCtrl.4.Temperature.Raw", new Double(25.4));
        this.database.put("FanCtrl.4.Set Point", new Double(4.0));
        this.database.put("FanCtrl.4.P", new Double(4.0));
        this.database.put("FanCtrl.4.I", new Double(4.0));
        this.database.put("FanCtrl.4.D", new Double(4.0));
        this.database.put("FanCtrl.Isolator.Command Output", new Double(0.5));
        this.database.put("FanCtrl.Isolator.Temperature.Raw", new Double(25.5));
        this.database.put("FanCtrl.Isolator.Set Point", new Double(5.0));
        this.database.put("FanCtrl.Isolator.P", new Double(5.0));
        this.database.put("FanCtrl.Isolator.I", new Double(5.0));
        this.database.put("FanCtrl.Isolator.D", new Double(5.0));
        this.database.put("Servo.Data.Azimuth.Command Torque", new Double(0.1));
        this.database.put("Servo.Data.Azimuth.Command Pos", new Double(0.1));
        this.database.put("Position Device.Azimuth Encoder.Reading", new Double(0.1));
        this.database.put("Servo.Tuning.Azimuth.P", new Double(0.1));
        this.database.put("Servo.Tuning.Azimuth.I", new Double(0.1));
        this.database.put("Servo.Tuning.Azimuth.D", new Double(0.1));
        this.database.put("Servo.Tuning.Azimuth.VFF", new Double(0.1));
        this.database.put("Servo.Data.Zenith.Command Torque", new Double(0.2));
        this.database.put("Servo.Data.Zenith.Command Pos", new Double(0.2));
        this.database.put("Position Device.Zenith Encoder.Reading", new Double(0.2));
        this.database.put("Servo.Tuning.Zenith.P", new Double(0.2));
        this.database.put("Servo.Tuning.Zenith.I", new Double(0.2));
        this.database.put("Servo.Tuning.Zenith.D", new Double(0.2));
        this.database.put("Servo.Tuning.Zenith.VFF", new Double(0.2));
        this.database.put("Target.Uncorrected.Azimuth", new Double(0.0));
        this.database.put("Target.Uncorrected.Zenith", new Double(90.0));
        this.database.put("Position Device.Azimuth Encoder.Compensation.Index Offset", new Double(0.9));
        this.database.put("Position Device.Zenith Encoder.Compensation.Index Offset", new Double(0.9));
        this.database.put("Level.Compensation.Data Sheet.Pos Scale", new Double(0.5));
        this.database.put("Level.Compensation.Data Sheet.Actual Temp", new Double(25.0));
        this.database.put("Level.Compensation.Data Sheet.Scale Temp", new Double(25.5));
        this.database.put("Level.Compensation.Data Sheet.Temp Scale", new Double(0.5));
        this.database.put("Level.Compensation.Data Sheet.Temp Raw", new Double(0.5));
        this.database.put("Level.Compensation.Data Sheet.1st Order Scale", new Double(0.5));
        this.database.put("Level.Compensation.Temperature.Scale", new Double(0.5));
        this.database.put("Level.Compensation.Temperature.Offset", new Double(0.5));
        this.database.put("Level.Compensation.Scale", new Double(0.5));
        this.database.put("Level.Compensation.Scale Temperature", new Double(25.5));
        this.database.put("Level.Compensation.Horizontal Yaw", new Double(0.5));
        this.database.put("Level.Compensation.Vertical Yaw", new Double(0.5));
        this.database.put("Coarse Level.Raw.RX", new Double(0.2));
        this.database.put("Coarse Level.Raw.RY", new Double(0.2));
        this.database.put("Coarse Level.Compensation.Scale", new Double(0.5));
        this.database.put("Coarse Level.Compensation.OffsetRX", new Double(0.6));
        this.database.put("Coarse Level.Compensation.OffsetRY", new Double(0.6));
        this.database.put("motor_state.int_output", new Long(1L));
        this.database.put("control_mode.int_output", new Long(0L));
        this.database.put("adm_state.int_output", new Long(1L));
        this.database.put("shutter_state.int_output", new Long(1L));
        this.database.put("laser.int_output", new Long(2L));
    }

    @Override
    public void startFactoryBkndMeasure(MeasureCfg measureCfg, DataTag[] dataTagArray) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Method_Not_Supported"));
    }

    @Override
    public MeasureData[] readFactoryBkndMeasureData(int n) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Method_Not_Supported"));
    }

    @Override
    public void stopFactoryBkndMeasure() throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Method_Not_Supported"));
    }

    @Override
    public void startFactoryBkndMeasurePoint(MeasureCfg measureCfg) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Method_Not_Supported"));
    }

    @Override
    public MeasurePointData[] readFactoryBkndMeasurePointData(int n) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Method_Not_Supported"));
    }

    @Override
    public void stopFactoryBkndMeasurePoint() throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Method_Not_Supported"));
    }

    @Override
    public void readFileAbort() {
    }

    @Override
    public void writeFileAbort() {
    }

    @Override
    public boolean admScanCapable() throws TrackerException {
        return true;
    }

    @Override
    public TargetType[] availableTargetType() throws TrackerException {
        TargetType[] targetTypeArray = null;
        targetTypeArray = new TargetType[]{new SMRTargetType(0.0381), new MirrorTargetType(), new SMRTargetType(0.0127), new SMRTargetType(0.022225), new SMRTargetType(0.0), new WindowedSMRTargetType(0.0381), new WindowedSMRTargetType(0.022225)};
        return targetTypeArray;
    }

    @Override
    public WeatherInformation getWeatherInfo() throws TrackerException {
        return new WeatherInformation(20.0, 760.0, 0.5);
    }

    @Override
    public String getSerialNumber() throws TrackerException {
        return new String("Simulator");
    }

    @Override
    public String getIPAddress() throws TrackerException {
        return new String("Simulator");
    }

    @Override
    public boolean readyToInitialize(boolean bl) throws TrackerException {
        return true;
    }

    @Override
    public void factoryConnect(String string, String string2, String string3) throws TrackerException {
    }

    @Override
    public void factoryDisconnect() throws TrackerException {
    }

    @Override
    public TrackerApp stopApplication(String string, boolean bl) throws TrackerException {
        if (bl && !this.isConnected) {
            throw new NotConnectedException();
        }
        AppRec appRec = this.findAppInfo(string);
        if (!appRec.isSet()) {
            return null;
        }
        TrackerApp trackerApp = appRec.app;
        this.localStopApplication(appRec);
        return trackerApp;
    }

    @Override
    public int applicationExitCode(String string) throws TrackerException {
        return 4;
    }

    @Override
    public void releaseLock() throws TrackerException {
    }

    @Override
    public void startSlew(double d, double d2, double d3) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Method_Not_Supported"));
    }

    @Override
    public void startSlew(double d, double d2) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Method_Not_Supported"));
    }

    @Override
    public void stopSlew() throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Method_Not_Supported"));
    }

    @Override
    public boolean isResultReportingCapable() throws TrackerException {
        return false;
    }

    @Override
    public boolean isAdaptiveFilterCapable() throws TrackerException {
        return false;
    }

    @Override
    public ApplicationResults applicationResults(String string) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public boolean is_1_5_WindowedSMRTargetCapable() throws TrackerException {
        return true;
    }

    @Override
    public boolean is_7_8_WindowedSMRTargetCapable() throws TrackerException {
        return true;
    }

    @Override
    public MPEResultsData checkADMAgainstIFM(SimplePointPairData simplePointPairData) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public MPEResultsData checkAngularAccuracyError(SimplePointPairData simplePointPairData) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public boolean isSelfCompensationNoUICapable() throws TrackerException {
        return false;
    }

    @Override
    public void changeAirTemperatureToHardware() throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public void changeAirPressureToHardware() throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public void changeHumidityToHardware() throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public void changeAirTemperatureToManual(double d) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public void changeAirPressureToManual(double d) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public void changeHumidityToManual(double d) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public void changeLedState(int n, int n2) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public VideoData[] readVideoData() throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public void startVideo(VideoCfg videoCfg) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public void stopVideo() throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public void changeGestureState(boolean bl) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public boolean gestureRecognitionOn() throws TrackerException {
        return false;
    }

    @Override
    public boolean wirelessCapable() throws TrackerException {
        return false;
    }

    @Override
    public boolean videoCapable() throws TrackerException {
        return false;
    }

    @Override
    public boolean gesturesCapable() throws TrackerException {
        return false;
    }

    @Override
    public void searchUsingCamera() throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public boolean isQuickCompensationNoUICapable() throws TrackerException {
        return false;
    }

    @Override
    public boolean isAACNoUICapable() throws TrackerException {
        return false;
    }

    @Override
    public int smartWarmupWaitState() throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public boolean home(boolean bl, boolean bl2) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public int applicationPercentComplete(String string) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public void resetCameras() throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public void comboSearch(double d, double d2, double d3, double d4, double d5, boolean bl) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public void comboSearchInternal(double d, double d2, double d3) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public boolean didAACPassSinceInitialization() throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public boolean isNoUICompCalCapable() throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public int batteryChargeRemaining(int n) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public void factoryDisconnect(String string) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public int batteryState(int n) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public boolean sixDofCapable() throws TrackerException {
        return false;
    }

    @Override
    public void changePowerButtonState(boolean bl) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public boolean powerButtonState() throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public void reboot() throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public boolean isFollowMeCapable() throws TrackerException {
        return false;
    }

    @Override
    public void changeFollowMeState(boolean bl) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public boolean isFollowMeOn() throws TrackerException {
        return false;
    }

    @Override
    public double getFollowMeSearchRadius() throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public void changeFollowMeSearchRadius(double d) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public Probe[] availableProbes() throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public void addProbe(Probe probe) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public void removeProbe(Probe probe) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public void modifyProbe(Probe probe) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public void changeProbe(Probe probe, boolean bl) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public Probe probe() throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public String probeAdapter() throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public boolean probeAdapterConnected() throws TrackerException {
        return false;
    }

    @Override
    public ProbeCompensationData calcProbeCompensationParameters(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, double[] dArray6) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public ProbeCalibrationData calibrateProbeTip(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, double[] dArray6) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public ProbeCalibrationData calibrateISOProbeTip(double[] dArray, double[] dArray2, double[] dArray3) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public void updateProbeCompensationParameters(Probe probe, ProbeCompensationData probeCompensationData) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public void updateProbeCompensationParameters(Probe probe, double d, double d2, double d3) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public void updateProbeCompensationParameters(Probe probe, double d, double d2, double d3, double d4) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public boolean sixDofEnabled() throws TrackerException {
        return false;
    }

    @Override
    public void changeSixDofEnableState(boolean bl) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public int probeBatteryChargeRemaining() throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public void removeAllProbes() throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public void removeAllFactoryProbes() throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public double getDelayFromPassiveToActiveFollowMe() throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public void setDelayFromPassiveToActiveFollowMe(double d) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public int probeBatteryState() throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public boolean probeBatteryStateChangeEventSupported() throws TrackerException {
        return false;
    }

    @Override
    public boolean wirelessStateChangeSupported() throws TrackerException {
        return false;
    }

    @Override
    public void changeWirelessState(boolean bl) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public boolean wirelessOn() throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public boolean isCatEyeTargetCapable() throws TrackerException {
        return false;
    }

    @Override
    public boolean laserOn() throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public void changeLaserState(boolean bl) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public int connectionType() {
        int n = 0;
        if (this.isConnected) {
            n = 1;
        }
        return n;
    }

    @Override
    public void setPort(PortUtility portUtility) {
        this.portUtility = portUtility;
    }

    @Override
    public int runAutomatedComp() throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public boolean homeRequired() throws TrackerException {
        return false;
    }

    @Override
    public boolean autoCompRequired() throws TrackerException {
        return false;
    }

    @Override
    public boolean autoReconnectCapable() throws TrackerException {
        return false;
    }

    @Override
    public boolean trackerBatteryEventCapable() throws TrackerException {
        return false;
    }

    @Override
    public boolean autoCompCapable() throws TrackerException {
        return false;
    }

    @Override
    public boolean sixProbe2Capable() {
        return false;
    }

    @Override
    public int probeModelType() throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public void removeCompFromProbeCompHistory(Probe probe, double d) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public void useCompFromProbeCompHistory(Probe probe, double d) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public ProbeCompHistoryData[] probeCompHistory(Probe probe) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public boolean probeCompHistoryCapable() throws TrackerException {
        return false;
    }

    private class AppRec {
        String appName;
        String fullyQualifiedName;
        TrackerApp app;

        AppRec(String string, String string2) {
            this.appName = string;
            this.fullyQualifiedName = string2;
            this.app = null;
        }

        void set(TrackerApp trackerApp) {
            this.app = trackerApp;
        }

        void clear() {
            this.app = null;
        }

        boolean isSet() {
            return null != this.app;
        }
    }

    private class TrkSimInterfaceImplementer
    implements TrackerSimInterface {
        public void setSimPosition(int n, Nest nest) {
            int n2;
            double[] dArray = new double[3];
            double[] dArray2 = new double[3];
            Target target = new Target();
            Nest nest2 = new Nest();
            dArray[0] = TrackerVectorSim.this.azimuth;
            dArray[1] = TrackerVectorSim.this.zenith;
            dArray[2] = TrackerVectorSim.this.workingDistance;
            for (n2 = 0; n2 < TrackerVectorSim.this.nestList.size() && !(nest2 = (Nest)TrackerVectorSim.this.nestList.get(n2)).getNestName().equals(nest.getNestName()); ++n2) {
            }
            dArray2 = nest2.getPosition();
            if (TrackerVectorSim.this.target.getTargetName().equals(nest.getClassmateName())) {
                TrackerVectorSim.this.azimuth = dArray2[0];
                TrackerVectorSim.this.zenith = dArray2[1];
                TrackerVectorSim.this.distanceDelta = dArray2[2] - TrackerVectorSim.this.ADMDistance;
            } else {
                target = TrackerVectorSim.this.findCurrentTarget(TrackerVectorSim.this.azimuth, TrackerVectorSim.this.zenith);
                if (!target.getTargetName().equals("")) {
                    TrackerVectorSim.this.targetValid = true;
                    TrackerVectorSim.this.target = target;
                    TrackerVectorSim.this.setCurrentTargetPosition(TrackerVectorSim.this.workingDistance);
                    TrackerVectorSim.this.targetPresent = true;
                    for (n2 = 0; n2 < TrackerVectorSim.this.nestList.size(); ++n2) {
                        Nest nest3 = (Nest)TrackerVectorSim.this.nestList.get(n2);
                        if (!nest3.getClassmateName().equals(TrackerVectorSim.this.target.getTargetName())) continue;
                        TrackerVectorSim.this.distanceDelta = nest3.getPosition()[2] - TrackerVectorSim.this.ADMDistance;
                    }
                } else {
                    TrackerVectorSim.this.targetPresent = false;
                    TrackerVectorSim.this.targetValid = false;
                    TrackerVectorSim.this.target = new Target();
                }
            }
            if (TrackerVectorSim.this.conTrigger instanceof DistanceTrigger) {
                double d = ((DistanceTrigger)TrackerVectorSim.this.conTrigger).getDistance();
                TrackerVectorSim.this.sendPoints(dArray, dArray2, d);
            }
        }

        public void setSimTrkPosition(double[] dArray, double[] dArray2) {
            TrackerVectorSim.this.tracker.setAbsPosition(dArray, dArray2);
        }

        public void updateSimPosition() {
            if (TrackerVectorSim.this.target.getTargetName().equals("")) {
                TrackerVectorSim.this.target = TrackerVectorSim.this.findCurrentTarget(TrackerVectorSim.this.azimuth, TrackerVectorSim.this.zenith);
                if (!TrackerVectorSim.this.target.getTargetName().equals("")) {
                    TrackerVectorSim.this.setCurrentTargetPosition(TrackerVectorSim.this.workingDistance);
                    TrackerVectorSim.this.targetPresent = true;
                    TrackerVectorSim.this.targetValid = true;
                } else {
                    TrackerVectorSim.this.targetPresent = false;
                    TrackerVectorSim.this.targetValid = false;
                }
            }
            Nest nest = new Nest();
            if (!TrackerVectorSim.this.target.getTargetName().equals("")) {
                for (int i = 0; i < 3 && !(nest = (Nest)TrackerVectorSim.this.nestList.get(i)).getClassmateName().equals(TrackerVectorSim.this.target.getTargetName()); ++i) {
                }
                if (!nest.getNestName().startsWith("TMR_")) {
                    double[] dArray = nest.getPosition();
                    TrackerVectorSim.this.azimuth = dArray[0];
                    TrackerVectorSim.this.zenith = dArray[1];
                    TrackerVectorSim.this.distanceDelta = dArray[2] - TrackerVectorSim.this.ADMDistance;
                }
            }
        }

        public void setSimMaterialTempData(MaterialTemp materialTemp) {
            TrackerVectorSim.this.materialTemp = (MaterialTemp)materialTemp.clone();
        }

        public void setSimNoiseData(Noise noise) {
            TrackerVectorSim.this.noise = (Noise)noise.clone();
        }

        public void setSimNestList(LinkedList linkedList) {
            TrackerVectorSim.this.nestList = new LinkedList();
            Nest nest = new Nest();
            Nest nest2 = new Nest();
            for (int i = 0; i < linkedList.size(); ++i) {
                nest = (Nest)linkedList.get(i);
                nest2 = (Nest)nest.clone();
                TrackerVectorSim.this.nestList.add(i, nest2);
            }
            TrackerVectorSim.this.relocateNestList(TrackerVectorSim.this.nestList);
        }

        public void setSimTargetList(LinkedList linkedList) {
            TrackerVectorSim.this.targetList = new LinkedList();
            Target target = new Target();
            Target target2 = new Target();
            for (int i = 0; i < linkedList.size(); ++i) {
                target = (Target)linkedList.get(i);
                target2 = (Target)target.clone();
                TrackerVectorSim.this.targetList.add(i, target2);
            }
        }

        public void setSimTrackerList(LinkedList linkedList) {
            TrackerVectorSim.this.trackerList = new LinkedList();
            Trackers trackers = new Trackers();
            Trackers trackers2 = new Trackers();
            for (int i = 0; i < linkedList.size(); ++i) {
                trackers = (Trackers)linkedList.get(i);
                trackers2 = (Trackers)trackers.clone();
                TrackerVectorSim.this.trackerList.add(i, trackers2);
            }
        }

        public void setSimCurrentTarget(int n) {
            TrackerVectorSim.this.target = (Target)TrackerVectorSim.this.targetList.get(n);
        }

        public void setSimTargetBlocked(boolean bl, Target target) {
            for (int i = 0; i < TrackerVectorSim.this.targetList.size(); ++i) {
                Target target2 = (Target)TrackerVectorSim.this.targetList.get(i);
                if (!target.getTargetName().equals(target2.getTargetName())) continue;
                if (bl) {
                    target2.setTargetStatus("Blocked");
                    continue;
                }
                target2.setTargetStatus("");
            }
            if (bl) {
                if (!TrackerVectorSim.this.target.getTargetName().equals("") && target.getTargetName().equals(TrackerVectorSim.this.target.getTargetName())) {
                    TrackerVectorSim.this.targetPresent = false;
                    TrackerVectorSim.this.targetValid = false;
                    TrackerVectorSim.this.target = new Target();
                }
            } else {
                Target target3 = TrackerVectorSim.this.findCurrentTarget(TrackerVectorSim.this.azimuth, TrackerVectorSim.this.zenith);
                if (target3.getTargetName().equals("")) {
                    TrackerVectorSim.this.targetPresent = false;
                    TrackerVectorSim.this.targetValid = false;
                    TrackerVectorSim.this.target = new Target();
                } else {
                    TrackerVectorSim.this.target = target3;
                    TrackerVectorSim.this.targetPresent = true;
                    TrackerVectorSim.this.setCurrentTargetPosition(TrackerVectorSim.this.workingDistance);
                    if (TrackerVectorSim.this.useADM == 1) {
                        TrackerVectorSim.this.targetValid = true;
                    }
                }
            }
        }

        public void deleteSimTarget(Target target) {
            if (!target.getTargetName().equals(TrackerVectorSim.this.target.getTargetName())) {
                return;
            }
            TrackerVectorSim.this.targetPresent = false;
            TrackerVectorSim.this.targetValid = false;
            TrackerVectorSim.this.target = new Target();
        }

        public void setSimCoordinate(int n) {
            TrackerVectorSim.this.coordinate = n;
        }
    }
}

