/*
 * Decompiled with CFR 0.152.
 */
package smx.tracker;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.swing.JFrame;
import smx.ftp.Ftp;
import smx.ftp.FtpAbortedException;
import smx.ftp.FtpAlreadyConnectedException;
import smx.ftp.FtpBusyException;
import smx.ftp.FtpException;
import smx.ftp.FtpNoResponseException;
import smx.ftp.FtpNotConnectedException;
import smx.tracker.AbortedException;
import smx.tracker.AirExtTemp;
import smx.tracker.Alarm;
import smx.tracker.AlarmType;
import smx.tracker.AlreadyConnectedException;
import smx.tracker.ApplicationFailedException;
import smx.tracker.ApplicationResults;
import smx.tracker.AsyncMsg;
import smx.tracker.AverageFilter;
import smx.tracker.BadCommandException;
import smx.tracker.Change;
import smx.tracker.CommunicationException;
import smx.tracker.ConnectFailedException;
import smx.tracker.ContinueTrigger;
import smx.tracker.DataFormatException;
import smx.tracker.DataTag;
import smx.tracker.DataTagDouble;
import smx.tracker.DataTagUnsigned16;
import smx.tracker.DataTagUnsigned32;
import smx.tracker.DataTagUnsigned8;
import smx.tracker.DeviationAlarm;
import smx.tracker.DeviceLockedException;
import smx.tracker.Diagnostic;
import smx.tracker.DisconnectFailedException;
import smx.tracker.DistanceMode;
import smx.tracker.DistanceSetException;
import smx.tracker.DistanceTrigger;
import smx.tracker.DoubleFaultException;
import smx.tracker.ExtTempType;
import smx.tracker.ExternalContinueTrigger;
import smx.tracker.ExternalStartTrigger;
import smx.tracker.FileAccessException;
import smx.tracker.Filter;
import smx.tracker.HighAlarm;
import smx.tracker.InterfaceBusyException;
import smx.tracker.InterferometerOnly;
import smx.tracker.InterferometerSetByADM;
import smx.tracker.InternalDeviceFailureException;
import smx.tracker.InternalTrackerException;
import smx.tracker.IntervalTrigger;
import smx.tracker.LaserStateException;
import smx.tracker.LevelData;
import smx.tracker.LowAlarm;
import smx.tracker.MPEResultsData;
import smx.tracker.MaterialExtTemp;
import smx.tracker.MaterialTemperatureData;
import smx.tracker.MeasureCfg;
import smx.tracker.MeasureData;
import smx.tracker.MeasurePointData;
import smx.tracker.MeasurePointStdDev;
import smx.tracker.MeasureStdDev;
import smx.tracker.MirrorTargetType;
import smx.tracker.MotorStateException;
import smx.tracker.NoDataAvailableException;
import smx.tracker.NoResponseException;
import smx.tracker.NoTargetException;
import smx.tracker.NotConnectedException;
import smx.tracker.NullAlarm;
import smx.tracker.NullContinueTrigger;
import smx.tracker.NullExtTemp;
import smx.tracker.NullFilter;
import smx.tracker.NullStartTrigger;
import smx.tracker.PermissionException;
import smx.tracker.Probe;
import smx.tracker.ProbeCalibrationData;
import smx.tracker.ProbeCompHistoryData;
import smx.tracker.ProbeCompensationData;
import smx.tracker.RequestException;
import smx.tracker.SMRTargetType;
import smx.tracker.ShutterStateException;
import smx.tracker.SimplePointPairData;
import smx.tracker.StartTrigger;
import smx.tracker.Status;
import smx.tracker.StdDevFilter;
import smx.tracker.TargetType;
import smx.tracker.Tracker;
import smx.tracker.TrackerApp;
import smx.tracker.TrackerException;
import smx.tracker.TrackerInterface;
import smx.tracker.TrackingStateException;
import smx.tracker.UnsupportedFeatureException;
import smx.tracker.UserEntryException;
import smx.tracker.UserPromptException;
import smx.tracker.VideoCfg;
import smx.tracker.VideoData;
import smx.tracker.WeatherInformation;
import smx.utility.PortUtility;
import smx.utility.ThreadComm;

public class Tracker4xxx
implements TrackerInterface {
    private Ftp ftpClient = null;
    private int[] measureTypeList = null;
    private boolean generalMeasureFlag;
    private boolean readInProgress = false;
    private Filter measureFilter = null;
    private int[] bkndMeasureTypeList = null;
    private boolean bkndReadInProgress = false;
    private boolean bkndGeneralMeasureFlag = false;
    private Ftp bkndFtpClient = null;
    private Filter bkndMeasureFilter = null;
    private int[] factoryBkndMeasureTypeList = null;
    private boolean factoryBkndReadInProgress = false;
    private boolean factoryBkndGeneralMeasureFlag = false;
    private Ftp factoryBkndFtpClient = null;
    private Filter factoryBkndMeasureFilter = null;
    private BufferedReader asyncInput = null;
    private boolean asyncReadInProgress = false;
    private boolean asyncReadInterrupted = false;
    private ThreadComm asyncComm = null;
    private boolean cmdInProgress = false;
    private boolean isADMEnabled = false;
    private boolean isADMCapable = false;
    private boolean isLevelCapable = false;
    private Status[] statusHistoryFilter = null;
    private Alarm[] alarmHistoryFilter = null;
    private Change[] changeHistoryFilter = null;
    private int accessLevel;
    private AppRec[] appInfo;
    private static final int UNSIGNED8 = 1;
    private static final int UNSIGNED16 = 2;
    private static final int UNSIGNED32 = 3;
    private static final int DOUBLE = 4;
    private DataTag[] pointMeasurementTags = new DataTag[6];
    private boolean measureInProgress = false;
    private boolean bkndMeasureInProgress = false;
    private boolean factoryBkndMeasureInProgress = false;
    private static final int ACCESS_STANDARD = 0;
    private static final int ACCESS_ADMIN = 1;
    private static final int ACCESS_FACTORY = 2;
    private static final int[] diagMap = new int[]{0, 8, 8, 8, 8, 8, 1, 4, 5, 8, 8, 0, 3, 6, 7, 2, 3, 8};
    private static final int[] changeMap = new int[]{0, 2, 1};
    private static final int[] statusMap = new int[]{0, 1, 2, 1, 3, 4, 5, 6, 7, 8, 10, 11, 12, 13, 14, 15, 16, 17, 0, 0, 0, 0, 0, 0};
    private static final int FILE_XFER_BUFFER_SIZE = 1200;
    private static final int TRACKER_SAMPLES_PER_SECOND = 1000;

    public Tracker4xxx() {
        this.pointMeasurementTags[0] = new DataTagDouble("az_corrected.output");
        this.pointMeasurementTags[1] = new DataTagUnsigned16("az_corrected.status");
        this.pointMeasurementTags[2] = new DataTagDouble("el_corrected.output");
        this.pointMeasurementTags[3] = new DataTagUnsigned16("el_corrected.status");
        this.pointMeasurementTags[4] = new DataTagDouble("dist_corrected.output");
        this.pointMeasurementTags[5] = new DataTagUnsigned16("dist_corrected.status");
    }

    private boolean isConnected() {
        return null != this.ftpClient;
    }

    private boolean isMeasuring() {
        return this.measureInProgress;
    }

    private boolean isBkndMeasuring() {
        return this.bkndMeasureInProgress;
    }

    private boolean isFactoryBkndMeasuring() {
        return this.factoryBkndMeasureInProgress;
    }

    private void readyForCommand() throws InterfaceBusyException, NotConnectedException {
        if (!this.isConnected()) {
            throw new NotConnectedException();
        }
        if (this.isMeasuring() || this.cmdInProgress) {
            throw new InterfaceBusyException(Tracker.res.getString("Measure_Or_Cmd_In_Progress"));
        }
    }

    private TrackerException convertFtpExc(FtpException ftpException) {
        try {
            throw ftpException;
        }
        catch (FtpAbortedException ftpAbortedException) {
            return new AbortedException();
        }
        catch (FtpAlreadyConnectedException ftpAlreadyConnectedException) {
            return new AlreadyConnectedException();
        }
        catch (FtpBusyException ftpBusyException) {
            return new InterfaceBusyException(Tracker.res.getString("FTP_Busy"));
        }
        catch (FtpNoResponseException ftpNoResponseException) {
            return new NoResponseException();
        }
        catch (FtpNotConnectedException ftpNotConnectedException) {
            return new NotConnectedException();
        }
        catch (FtpException ftpException2) {
            return new CommunicationException(Tracker.res.getString("Unexpected_FTP_Exception"));
        }
    }

    private TrackerException exceptionFromReason(String string) {
        int n;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        stringTokenizer.nextToken();
        String string2 = stringTokenizer.nextToken();
        try {
            n = Integer.parseInt(string2, 16);
        }
        catch (NumberFormatException numberFormatException) {
            return new CommunicationException(Tracker.res.getString("FTP_Response_String_Not_In_Expected_Format"));
        }
        String string3 = "Code: " + n;
        switch (n) {
            case 1: {
                return new DeviceLockedException(string3);
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 20: 
            case 22: 
            case 25: 
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 43: 
            case 45: 
            case 48: 
            case 50: {
                return new InternalTrackerException(string3);
            }
            case 5: 
            case 15: 
            case 23: {
                return new MotorStateException(string3);
            }
            case 6: 
            case 19: {
                return new LaserStateException(string3);
            }
            case 7: {
                return new ShutterStateException(string3);
            }
            case 13: {
                return new NoTargetException(string3);
            }
            case 18: {
                return new DoubleFaultException(string3);
            }
            case 21: 
            case 24: 
            case 26: 
            case 28: 
            case 36: 
            case 38: 
            case 51: {
                return new InternalDeviceFailureException(string3);
            }
            case 27: 
            case 49: {
                return new DistanceSetException(string3);
            }
            case 30: {
                return new TrackingStateException(string3);
            }
            case 32: 
            case 37: 
            case 39: 
            case 40: 
            case 44: 
            case 46: 
            case 47: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: {
                return new UserPromptException(string3);
            }
            case 41: 
            case 42: 
            case 61: {
                return new UserEntryException(string3);
            }
        }
        return new TrackerException(string3);
    }

    private TrackerException exceptionFromResponse(Ftp ftp, int n) {
        String string;
        try {
            string = ftp.getLastResponse();
        }
        catch (FtpException ftpException) {
            return new CommunicationException(Tracker.res.getString("Unexpected_FTP_Exception_Last_Response"));
        }
        switch (n) {
            case 340: {
                return new RequestException(string);
            }
            case 453: {
                return new InternalDeviceFailureException(string);
            }
            case 450: 
            case 452: 
            case 454: 
            case 455: 
            case 456: 
            case 555: {
                return new InternalTrackerException(string);
            }
            case 421: 
            case 425: 
            case 428: 
            case 429: 
            case 520: 
            case 530: {
                return new CommunicationException(string);
            }
            case 550: {
                return new PermissionException(string);
            }
            case 552: 
            case 557: {
                return new FileAccessException(string);
            }
            case 556: 
            case 558: {
                return this.exceptionFromReason(string);
            }
            case 500: 
            case 501: 
            case 503: {
                return new BadCommandException(string);
            }
        }
        return new TrackerException(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void trackerCommand(String string, int n) throws TrackerException {
        try {
            Tracker4xxx tracker4xxx = this;
            synchronized (tracker4xxx) {
                this.readyForCommand();
                this.cmdInProgress = true;
            }
            int n2 = this.ftpClient.command(string, n);
            if (200 != n2) {
                throw this.exceptionFromResponse(this.ftpClient, n2);
            }
        }
        catch (FtpException ftpException) {
            throw this.convertFtpExc(ftpException);
        }
        finally {
            Tracker4xxx tracker4xxx = this;
            synchronized (tracker4xxx) {
                this.cmdInProgress = false;
            }
        }
    }

    private boolean validRev() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32("firmware_rev.int_output")};
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        long l = (Long)objectArray[0];
        int n = (int)(l & 0xFFL);
        int n2 = (int)((l & 0xFF00L) >> 8);
        return n > 2 || 2 == n && n2 >= 7;
    }

    private void setADMInfo() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32("adm_state.int_output"), new DataTagUnsigned32("adm_auto_adjust.int_output")};
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        this.isADMCapable = 1L == (Long)objectArray[0] || 2L == (Long)objectArray[0];
        this.isADMEnabled = this.isADMCapable && 1L == (Long)objectArray[1];
    }

    private void setLevelInfo() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned16("lev_pos_cal.status")};
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        this.isLevelCapable = 0 == (Integer)objectArray[0];
    }

    private void cleanupTempTypes() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned8("air_temp_1.input_selector"), new DataTagUnsigned16("air_temp_1.point"), new DataTagUnsigned8("mat_temp_1.input_selector"), new DataTagUnsigned16("mat_temp_1.point"), new DataTagUnsigned8("air_temp_2.input_selector"), new DataTagUnsigned16("air_temp_2.point"), new DataTagUnsigned8("mat_temp_2.input_selector"), new DataTagUnsigned16("mat_temp_2.point"), new DataTagUnsigned8("air_temp_3.input_selector"), new DataTagUnsigned16("air_temp_3.point"), new DataTagUnsigned8("mat_temp_3.input_selector"), new DataTagUnsigned16("mat_temp_3.point"), new DataTagUnsigned8("air_temp_4.input_selector"), new DataTagUnsigned16("air_temp_4.point"), new DataTagUnsigned8("mat_temp_4.input_selector"), new DataTagUnsigned16("mat_temp_4.point"), new DataTagUnsigned8("air_temp_5.input_selector"), new DataTagUnsigned16("air_temp_5.point"), new DataTagUnsigned8("mat_temp_5.input_selector"), new DataTagUnsigned16("mat_temp_5.point"), new DataTagUnsigned8("air_temp_6.input_selector"), new DataTagUnsigned16("air_temp_6.point"), new DataTagUnsigned8("mat_temp_6.input_selector"), new DataTagUnsigned16("mat_temp_6.point"), new DataTagUnsigned8("air_temp_7.input_selector"), new DataTagUnsigned16("air_temp_7.point"), new DataTagUnsigned8("mat_temp_7.input_selector"), new DataTagUnsigned16("mat_temp_7.point"), new DataTagUnsigned8("air_temp_8.input_selector"), new DataTagUnsigned16("air_temp_8.point"), new DataTagUnsigned8("mat_temp_8.input_selector"), new DataTagUnsigned16("mat_temp_8.point")};
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        int n = 0;
        boolean bl = false;
        for (int i = 0; i < 8; ++i) {
            if (3 == ((Short)objectArray[n]).intValue() && (Integer)objectArray[n + 1] != 28 + i || 2 == ((Short)objectArray[n]).intValue()) {
                objectArray[n] = new Short(0);
                objectArray[n + 1] = new Integer(0);
                bl = true;
            }
            if (3 == ((Short)objectArray[n + 2]).intValue() && (Integer)objectArray[n + 3] != 28 + i || 2 == ((Short)objectArray[n + 2]).intValue()) {
                objectArray[n + 2] = new Short(0);
                objectArray[n + 3] = new Integer(0);
                bl = true;
            }
            n += 4;
        }
        if (bl) {
            this.writeOneTimeData(dataTagArray, objectArray);
        }
    }

    private void cleanupAlarms() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned8("temp_alarm_1.input_selector"), new DataTagUnsigned16("temp_alarm_1.point"), new DataTagUnsigned8("temp_alarm_2.input_selector"), new DataTagUnsigned16("temp_alarm_2.point"), new DataTagUnsigned8("temp_alarm_3.input_selector"), new DataTagUnsigned16("temp_alarm_3.point"), new DataTagUnsigned8("temp_alarm_4.input_selector"), new DataTagUnsigned16("temp_alarm_4.point"), new DataTagUnsigned8("temp_alarm_5.input_selector"), new DataTagUnsigned16("temp_alarm_5.point"), new DataTagUnsigned8("temp_alarm_6.input_selector"), new DataTagUnsigned16("temp_alarm_6.point"), new DataTagUnsigned8("temp_alarm_7.input_selector"), new DataTagUnsigned16("temp_alarm_7.point"), new DataTagUnsigned8("temp_alarm_8.input_selector"), new DataTagUnsigned16("temp_alarm_8.point")};
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        int n = 0;
        boolean bl = false;
        for (int i = 0; i < 8; ++i) {
            if (3 == ((Short)objectArray[n]).intValue() && (Integer)objectArray[n + 1] != 28 + i) {
                objectArray[n] = new Short(0);
                objectArray[n + 1] = new Integer(0);
                bl = true;
            }
            n += 2;
        }
        if (bl) {
            this.writeOneTimeData(dataTagArray, objectArray);
        }
    }

    private boolean checkTags(DataTag[] dataTagArray, DataTag[] dataTagArray2) {
        if (dataTagArray == null || dataTagArray2 == null) {
            return false;
        }
        if (dataTagArray.length != dataTagArray2.length) {
            return false;
        }
        for (int i = 0; i < dataTagArray2.length; ++i) {
            if (dataTagArray[i].getName().equals(dataTagArray2[i].getName())) continue;
            return false;
        }
        return true;
    }

    private Object checkAndSendCFGData(MeasureCfg measureCfg, DataTag[] dataTagArray, boolean bl, boolean bl2, Ftp ftp, String string) throws TrackerException {
        this.sendMeasureCfg(ftp, measureCfg, dataTagArray, string);
        return this.createTypeList(dataTagArray);
    }

    private void setAccessLevel(String string) throws TrackerException {
        if (string.equalsIgnoreCase("user")) {
            this.accessLevel = 0;
        } else if (string.equalsIgnoreCase("admin")) {
            this.accessLevel = 1;
        } else if (string.equalsIgnoreCase("factory") || string.equalsIgnoreCase("supervis")) {
            this.accessLevel = 2;
        } else {
            throw new ConnectFailedException(Tracker.res.getString("Invalid_User_Name"));
        }
    }

    @Override
    public synchronized void connect(String string, String string2, String string3) throws TrackerException {
        ConnectFailedException connectFailedException = null;
        if (null != this.ftpClient) {
            throw new AlreadyConnectedException();
        }
        if (-1 == string.indexOf(46) || !Tracker.isUserParameterValidIPAddress(string)) {
            string = Tracker.checkAndGetIPAddress(string, "Tracker4xxx");
        }
        this.ftpClient = new Ftp();
        this.ftpClient.setDataOrientation(true);
        try {
            this.ftpClient.connect(string, string2, string3);
        }
        catch (FtpException ftpException) {
            this.ftpClient = null;
            throw new ConnectFailedException(ftpException.toString());
        }
        try {
            if (this.validRev()) {
                this.setADMInfo();
                this.setLevelInfo();
                this.setAppInfo();
                this.cleanupTempTypes();
                this.cleanupAlarms();
                this.setAccessLevel(string2);
            } else {
                connectFailedException = new ConnectFailedException(Tracker.res.getString("Invalid_Firmware_Revision"));
            }
        }
        catch (ConnectFailedException connectFailedException2) {
            connectFailedException = connectFailedException2;
        }
        catch (TrackerException trackerException) {
            connectFailedException = new ConnectFailedException(Tracker.res.getString("Could_Not_Obtain_Needed_Info"));
        }
        if (null != connectFailedException) {
            try {
                this.ftpClient.disconnect();
            }
            catch (FtpException ftpException) {
                // empty catch block
            }
            this.ftpClient = null;
            throw connectFailedException;
        }
    }

    @Override
    public void initialize() throws TrackerException {
        this.initialize(true);
    }

    @Override
    public void initialize(boolean bl) throws TrackerException {
        if (!this.readyToInitialize(bl)) {
            throw new TrackerException(Tracker.res.getString("Tracker_Is_Not_Ready"));
        }
        this.trackerCommand("calibrate startup", 180000);
    }

    @Override
    public void initializeSmart() throws TrackerException {
        this.initializeSmart(true);
    }

    @Override
    public void initializeSmart(boolean bl) throws TrackerException {
        if (!this.readyToInitialize(bl)) {
            throw new TrackerException(Tracker.res.getString("Tracker_Is_Not_Ready"));
        }
        this.trackerCommand("calibrate startup", 180000);
    }

    @Override
    public void move(double d, double d2, double d3, boolean bl) throws TrackerException {
        String string = "moveto " + d + " " + d2 + " " + d3 + (this.isADMEnabled ? "? " : " ") + (bl ? "r" : "a") + " c3";
        try {
            this.trackerCommand(string, 15000);
        }
        catch (NoTargetException noTargetException) {
            // empty catch block
        }
    }

    @Override
    public void move(double d, double d2, double d3, boolean bl, boolean bl2) throws TrackerException {
        String string = "moveto " + d + " " + d2 + " " + d3 + (this.isADMEnabled ? "? " : " ") + (bl2 ? "r" : "a") + " c4 " + (bl ? "b" : "f");
        try {
            this.trackerCommand(string, 15000);
        }
        catch (NoTargetException noTargetException) {
            // empty catch block
        }
    }

    @Override
    public void home(boolean bl) throws TrackerException {
        String string = "home" + (bl ? " b" : "");
        this.trackerCommand(string, 120000);
    }

    @Override
    public void toggleSightOrientation() throws TrackerException {
        this.trackerCommand("backsight", 300000);
        if (this.isADMEnabled) {
            this.trackerCommand("sd ?", 15000);
        }
    }

    @Override
    public void search(double d, double d2, int n) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public void search(double d, int n) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public void search(double d, double d2) throws TrackerException {
        if (!this.targetLocationValid()) {
            this.trackerCommand("fr " + d + " " + d2 + (this.isADMEnabled ? "?" : ""), 300000);
        }
    }

    @Override
    public void search(double d) throws TrackerException {
        if (!this.targetLocationValid()) {
            this.trackerCommand("fr " + d + (this.isADMEnabled ? " ?" : ""), 300000);
        }
    }

    @Override
    public void changeMotorState(boolean bl) throws TrackerException {
        String string = "servo " + (bl ? "on" : "off");
        this.trackerCommand(string, 6000);
    }

    @Override
    public void changeTrackingState(boolean bl) throws TrackerException {
        String string = "servo " + (bl ? "track" : "notrack");
        this.trackerCommand(string, 6000);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void changeDistanceMeasureMode(DistanceMode distanceMode) throws TrackerException {
        boolean bl;
        if (distanceMode instanceof InterferometerOnly) {
            bl = false;
        } else {
            if (!(distanceMode instanceof InterferometerSetByADM)) throw new UnsupportedFeatureException(Tracker.res.getString("Mode_Not_Supported"));
            if (!this.isADMCapable) throw new UnsupportedFeatureException(Tracker.res.getString("ADM_Not_Installed"));
            bl = true;
        }
        if (bl == this.isADMEnabled) {
            return;
        }
        DataTag[] dataTagArray = new DataTag[1];
        Object[] objectArray = new Object[1];
        dataTagArray[0] = new DataTagUnsigned32("adm_auto_adjust.int_output");
        objectArray[0] = new Long(bl ? 1L : 0L);
        this.writeOneTimeData(dataTagArray, objectArray);
        if (this.asyncRunning()) {
            Object[] objectArray2 = new Object[]{new Change(3, 0.0, 0, bl ? "Interferometer Set By ADM" : "Interferometer Only", distanceMode)};
            try {
                this.asyncComm.send(objectArray2);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.isADMEnabled = bl;
    }

    @Override
    public void changeTargetType(TargetType targetType) throws TrackerException {
        long l;
        if (targetType instanceof SMRTargetType) {
            SMRTargetType sMRTargetType = (SMRTargetType)targetType;
            double d = sMRTargetType.getDiameter();
            l = d >= 0.038 && d <= 0.0382 ? 0L : (d >= 0.0126 && d <= 0.0128 ? 2L : (d >= 0.0221 && d <= 0.0223 ? 3L : 4L));
        } else if (targetType instanceof MirrorTargetType) {
            l = 1L;
        } else {
            throw new UnsupportedFeatureException(Tracker.res.getString("Mode_Not_Supported"));
        }
        DataTag[] dataTagArray = new DataTag[1];
        Object[] objectArray = new Object[1];
        dataTagArray[0] = new DataTagUnsigned32("target.int_output");
        objectArray[0] = new Long(l);
        this.writeOneTimeData(dataTagArray, objectArray);
        if (this.asyncRunning()) {
            Object[] objectArray2 = new Object[]{new Change(4, 0.0, 0, "Target Type", targetType)};
            try {
                this.asyncComm.send(objectArray2);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public synchronized void abort() {
        try {
            if (this.cmdInProgress) {
                this.ftpClient.abort();
            }
        }
        catch (FtpException ftpException) {
            // empty catch block
        }
    }

    @Override
    public void disconnect() throws TrackerException {
        if (!this.isConnected()) {
            return;
        }
        try {
            this.clearAppInfo();
            this.ftpClient.disconnect();
            this.ftpClient = null;
        }
        catch (FtpException ftpException) {
            throw new DisconnectFailedException();
        }
    }

    @Override
    public int sampleRate() throws TrackerException {
        return 1000;
    }

    private void sendStartTrigger(Ftp ftp, MeasureCfg measureCfg) throws FtpException, TrackerException {
        StartTrigger startTrigger = measureCfg.getStartTrigger();
        if (startTrigger instanceof ExternalStartTrigger) {
            ftp.sendLine("start_type=digio");
            return;
        }
        if (startTrigger instanceof NullStartTrigger) {
            ftp.sendLine("start_type=nopause");
            return;
        }
        throw new UnsupportedFeatureException(Tracker.res.getString("Unknown_Start_Trigger"));
    }

    private void sendContinueTrigger(Ftp ftp, MeasureCfg measureCfg) throws FtpException, TrackerException {
        ContinueTrigger continueTrigger = measureCfg.getContinueTrigger();
        if (continueTrigger instanceof NullContinueTrigger) {
            ftp.sendLine("nth_type=noseq");
            return;
        }
        if (continueTrigger instanceof ExternalContinueTrigger) {
            ftp.sendLine("nth_type=digio");
            return;
        }
        if (continueTrigger instanceof IntervalTrigger) {
            ftp.sendLine("nth_type=time");
            ftp.sendLine("obsrate=" + ((IntervalTrigger)continueTrigger).getObservationRate());
            return;
        }
        if (continueTrigger instanceof DistanceTrigger) {
            ftp.sendLine("nth_type=distance");
            ftp.sendLine("distance=" + ((DistanceTrigger)continueTrigger).getDistance());
            return;
        }
        throw new UnsupportedFeatureException(Tracker.res.getString("Unknown_Continue_Trigger"));
    }

    private void sendFilter(Ftp ftp, MeasureCfg measureCfg) throws FtpException, TrackerException {
        Filter filter = measureCfg.getFilter();
        if (filter instanceof NullFilter) {
            ftp.sendLine("filter=none");
            return;
        }
        if (filter instanceof AverageFilter) {
            ftp.sendLine("filter=firstorder");
            return;
        }
        if (filter instanceof StdDevFilter) {
            ftp.sendLine("filter=stddev");
            return;
        }
        throw new UnsupportedFeatureException(Tracker.res.getString("Unknown_Filter"));
    }

    private int[] createTypeList(DataTag[] dataTagArray) throws TrackerException {
        int n = dataTagArray.length;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            if (dataTagArray[i] instanceof DataTagUnsigned8) {
                nArray[i] = 1;
                continue;
            }
            if (dataTagArray[i] instanceof DataTagUnsigned16) {
                nArray[i] = 2;
                continue;
            }
            if (dataTagArray[i] instanceof DataTagUnsigned32) {
                nArray[i] = 3;
                continue;
            }
            if (dataTagArray[i] instanceof DataTagDouble) {
                nArray[i] = 4;
                continue;
            }
            throw new UnsupportedFeatureException(Tracker.res.getString("Unknown_Data_Tag"));
        }
        return nArray;
    }

    private Object readDataElement(Ftp ftp, int n) throws FtpException {
        Number number = null;
        switch (n) {
            case 1: {
                short s = (short)((short)ftp.receiveByte() & 0xFF);
                number = new Short(s);
                ftp.receiveSkip(7);
                break;
            }
            case 2: {
                number = new Integer(ftp.receiveUnsignedShort());
                ftp.receiveSkip(6);
                break;
            }
            case 3: {
                number = new Long(ftp.receiveUnsignedInt());
                ftp.receiveSkip(4);
                break;
            }
            case 4: {
                number = new Double(ftp.receiveDouble());
            }
        }
        return number;
    }

    private void writeDataElement(Object object, int n) throws FtpException {
        Object var4_3 = null;
        switch (n) {
            case 1: {
                byte by = (byte)((Short)object & 0xFF);
                this.ftpClient.sendByte(by);
                this.ftpClient.sendByte((byte)0);
                this.ftpClient.sendUnsignedShort(0);
                this.ftpClient.sendUnsignedInt(0L);
                break;
            }
            case 2: {
                this.ftpClient.sendUnsignedShort(((Integer)object).intValue());
                this.ftpClient.sendUnsignedShort(0);
                this.ftpClient.sendUnsignedInt(0L);
                break;
            }
            case 3: {
                this.ftpClient.sendUnsignedInt(((Long)object).longValue());
                this.ftpClient.sendUnsignedInt(0L);
                break;
            }
            case 4: {
                this.ftpClient.sendDouble(((Double)object).doubleValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMeasureCfg(Ftp ftp, MeasureCfg measureCfg, DataTag[] dataTagArray, String string) throws TrackerException {
        int n;
        TrackerException trackerException = null;
        try {
            n = ftp.sendStart(string);
            if (150 != n) {
                throw this.exceptionFromResponse(ftp, n);
            }
        }
        catch (FtpException ftpException) {
            throw this.convertFtpExc(ftpException);
        }
        try {
            ftp.sendLine("maxobs=0");
            ftp.sendLine("nsamps=" + measureCfg.getSamplesPerObservation());
            this.sendStartTrigger(ftp, measureCfg);
            this.sendContinueTrigger(ftp, measureCfg);
            this.sendFilter(ftp, measureCfg);
            for (int i = 0; i < dataTagArray.length; ++i) {
                ftp.sendLine("point=" + dataTagArray[i].getName());
            }
        }
        catch (FtpException ftpException) {
            trackerException = this.convertFtpExc(ftpException);
        }
        catch (TrackerException trackerException2) {
            trackerException = trackerException2;
        }
        finally {
            block22: {
                try {
                    n = ftp.sendEnd(10000);
                    if (226 != n && null == trackerException) {
                        trackerException = this.exceptionFromResponse(ftp, n);
                    }
                }
                catch (FtpException ftpException) {
                    if (null != trackerException) break block22;
                    trackerException = this.convertFtpExc(ftpException);
                }
            }
        }
        if (null != trackerException) {
            throw trackerException;
        }
    }

    private MeasureData[] readData(Ftp ftp, int n, int[] nArray, Filter filter) throws FtpException {
        MeasureData[] measureDataArray = new MeasureData[n];
        for (int i = 0; i < n; ++i) {
            MeasureStdDev measureStdDev;
            int n2;
            Object[] objectArray = new Object[nArray.length];
            long l = ftp.receiveUnsignedInt();
            long l2 = ftp.receiveUnsignedInt();
            double d = (double)l + (double)l2 / 1000000.0;
            int n3 = nArray.length;
            for (n2 = 0; n2 < n3; ++n2) {
                objectArray[n2] = this.readDataElement(ftp, nArray[n2]);
            }
            if (filter instanceof StdDevFilter) {
                Object[] objectArray2 = new Object[n3];
                for (n2 = 0; n2 < n3; ++n2) {
                    objectArray2[n2] = this.readDataElement(ftp, nArray[n2]);
                }
                measureStdDev = new MeasureStdDev(objectArray2);
            } else {
                measureStdDev = null;
            }
            measureDataArray[i] = new MeasureData(d, objectArray, measureStdDev);
        }
        return measureDataArray;
    }

    private MeasurePointData[] readPointData(Ftp ftp, int n, Filter filter) throws FtpException {
        MeasurePointData[] measurePointDataArray = new MeasurePointData[n];
        for (int i = 0; i < n; ++i) {
            MeasurePointStdDev measurePointStdDev;
            long l = ftp.receiveUnsignedInt();
            long l2 = ftp.receiveUnsignedInt();
            double d = (double)l + (double)l2 / 1000000.0;
            double d2 = Math.IEEEremainder((Double)this.readDataElement(ftp, 4), 1296000.0);
            d2 = Math.toRadians(d2 / 3600.0);
            int n2 = (Integer)this.readDataElement(ftp, 2);
            double d3 = Math.IEEEremainder((Double)this.readDataElement(ftp, 4), 1296000.0);
            d3 = Math.toRadians(d3 / 3600.0);
            int n3 = (Integer)this.readDataElement(ftp, 2);
            double d4 = (Double)this.readDataElement(ftp, 4);
            d4 /= 1000000.0;
            int n4 = (Integer)this.readDataElement(ftp, 2);
            int n5 = n2 | n3 | n4;
            int n6 = 0 != (n5 & 2) ? 2 : (0 != (n5 & 4) ? 1 : 0);
            if (filter instanceof StdDevFilter) {
                double d5 = Math.IEEEremainder((Double)this.readDataElement(ftp, 4), 1296000.0);
                d5 = Math.toRadians(d5 / 3600.0);
                ftp.receiveSkip(8);
                double d6 = Math.IEEEremainder((Double)this.readDataElement(ftp, 4), 1296000.0);
                d6 = Math.toRadians(d6 / 3600.0);
                ftp.receiveSkip(8);
                double d7 = (Double)this.readDataElement(ftp, 4);
                measurePointStdDev = new MeasurePointStdDev(d5, d6, d7 /= 1000000.0);
            } else {
                measurePointStdDev = null;
            }
            measurePointDataArray[i] = new MeasurePointData(d, d2, d3, d4, n6, measurePointStdDev);
        }
        return measurePointDataArray;
    }

    private synchronized void localStartMeasure(MeasureCfg measureCfg, DataTag[] dataTagArray, boolean bl) throws TrackerException {
        this.readyForCommand();
        try {
            Object object = this.checkAndSendCFGData(measureCfg, dataTagArray, false, false, this.ftpClient, "\\data\\measure.arg");
            int n = this.ftpClient.receiveStart("\\data\\measure.dat");
            if (150 != n) {
                throw this.exceptionFromResponse(this.ftpClient, n);
            }
            if (object != null) {
                this.measureTypeList = (int[])object;
                this.measureFilter = measureCfg.getFilter();
            }
            this.generalMeasureFlag = bl;
            this.measureInProgress = true;
        }
        catch (FtpException ftpException) {
            throw this.convertFtpExc(ftpException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testAndSetReadData(boolean bl) throws TrackerException {
        Tracker4xxx tracker4xxx = this;
        synchronized (tracker4xxx) {
            if (!this.isConnected()) {
                throw new NotConnectedException();
            }
            if (!this.isMeasuring() || bl != this.generalMeasureFlag) {
                throw new NoDataAvailableException();
            }
            if (this.readInProgress) {
                throw new InterfaceBusyException(Tracker.res.getString("Read_In_Progress"));
            }
            this.readInProgress = true;
        }
    }

    private void releaseReadData() {
        this.readInProgress = false;
    }

    private synchronized void localStopMeasure(boolean bl) throws TrackerException {
        if (!this.isConnected()) {
            throw new NotConnectedException();
        }
        if (this.isMeasuring() && this.generalMeasureFlag == bl) {
            try {
                this.ftpClient.receiveAbort();
                this.measureInProgress = false;
            }
            catch (FtpException ftpException) {
                throw this.convertFtpExc(ftpException);
            }
        }
    }

    @Override
    public void startMeasure(MeasureCfg measureCfg, DataTag[] dataTagArray) throws TrackerException {
        this.localStartMeasure(measureCfg, dataTagArray, true);
    }

    @Override
    public MeasureData[] readMeasureData(int n) throws TrackerException {
        MeasureData[] measureDataArray;
        this.testAndSetReadData(true);
        try {
            measureDataArray = this.readData(this.ftpClient, n, this.measureTypeList, this.measureFilter);
        }
        catch (FtpException ftpException) {
            throw this.convertFtpExc(ftpException);
        }
        finally {
            this.releaseReadData();
        }
        return measureDataArray;
    }

    @Override
    public synchronized void stopMeasure() throws TrackerException {
        this.localStopMeasure(true);
    }

    @Override
    public void startMeasurePoint(MeasureCfg measureCfg) throws TrackerException {
        this.localStartMeasure(measureCfg, this.pointMeasurementTags, false);
    }

    @Override
    public MeasurePointData[] readMeasurePointData(int n) throws TrackerException {
        MeasurePointData[] measurePointDataArray;
        this.testAndSetReadData(false);
        try {
            measurePointDataArray = this.readPointData(this.ftpClient, n, this.measureFilter);
        }
        catch (FtpException ftpException) {
            throw this.convertFtpExc(ftpException);
        }
        finally {
            this.releaseReadData();
        }
        return measurePointDataArray;
    }

    @Override
    public synchronized void stopMeasurePoint() throws TrackerException {
        this.localStopMeasure(false);
    }

    private synchronized void localStartBkndMeasure(MeasureCfg measureCfg, DataTag[] dataTagArray, boolean bl, boolean bl2) throws TrackerException {
        this.readyForCommand();
        if (bl2) {
            if (this.isFactoryBkndMeasuring()) {
                throw new InterfaceBusyException(Tracker.res.getString("Factory_Bkgnd_Measurement_In_Progress"));
            }
        } else if (this.isBkndMeasuring()) {
            throw new InterfaceBusyException(Tracker.res.getString("Bkgnd_Measurements_In_Progress"));
        }
        try {
            Ftp ftp = new Ftp();
            ftp.setDataOrientation(true);
            InetAddress inetAddress = this.ftpClient.getRemoteIPAddress();
            String string = inetAddress.getHostAddress();
            ftp.connect(string, "user", "");
            Object object = this.checkAndSendCFGData(measureCfg, dataTagArray, true, bl2, ftp, "\\data\\bkndmeas.arg");
            int n = ftp.receiveStart("\\data\\bkndmeas.dat");
            if (150 != n) {
                throw this.exceptionFromResponse(this.ftpClient, n);
            }
            if (bl2) {
                this.factoryBkndFtpClient = ftp;
                if (object != null) {
                    this.factoryBkndMeasureTypeList = (int[])object;
                    this.factoryBkndMeasureFilter = measureCfg.getFilter();
                }
                this.factoryBkndGeneralMeasureFlag = bl;
                this.factoryBkndMeasureInProgress = true;
            } else {
                this.bkndFtpClient = ftp;
                if (object != null) {
                    this.bkndMeasureTypeList = (int[])object;
                    this.bkndMeasureFilter = measureCfg.getFilter();
                }
                this.bkndGeneralMeasureFlag = bl;
                this.bkndMeasureInProgress = true;
            }
        }
        catch (FtpException ftpException) {
            throw this.convertFtpExc(ftpException);
        }
    }

    public synchronized void localStartBkndMeasurePoint(MeasureCfg measureCfg, boolean bl) throws TrackerException {
        DataTag[] dataTagArray = new DataTag[]{new DataTagDouble("az_corrected.output"), new DataTagUnsigned16("az_corrected.status"), new DataTagDouble("el_corrected.output"), new DataTagUnsigned16("el_corrected.status"), new DataTagDouble("dist_corrected.output"), new DataTagUnsigned16("dist_corrected.status")};
        this.localStartBkndMeasure(measureCfg, dataTagArray, false, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testAndSetBkndReadData(boolean bl, boolean bl2) throws TrackerException {
        boolean bl3 = true;
        boolean bl4 = false;
        Tracker4xxx tracker4xxx = this;
        synchronized (tracker4xxx) {
            if (!this.isConnected()) {
                throw new NotConnectedException();
            }
            if (bl2) {
                if (!this.isFactoryBkndMeasuring() || bl != this.factoryBkndGeneralMeasureFlag) {
                    throw new NoDataAvailableException();
                }
                if (this.factoryBkndReadInProgress) {
                    throw new InterfaceBusyException(Tracker.res.getString("Factory_Background_Read_In_Progress"));
                }
                this.factoryBkndReadInProgress = true;
            } else {
                if (!this.isBkndMeasuring() || bl != this.bkndGeneralMeasureFlag) {
                    throw new NoDataAvailableException();
                }
                if (this.bkndReadInProgress) {
                    throw new InterfaceBusyException(Tracker.res.getString("Background_Read_In_Progress"));
                }
                this.bkndReadInProgress = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MeasureData[] localReadBkndMeasureData(int n, boolean bl) throws TrackerException {
        boolean bl2;
        MeasureData[] measureDataArray = null;
        do {
            bl2 = false;
            this.testAndSetBkndReadData(true, bl);
            try {
                measureDataArray = bl ? this.readData(this.factoryBkndFtpClient, n, this.factoryBkndMeasureTypeList, this.factoryBkndMeasureFilter) : this.readData(this.bkndFtpClient, n, this.bkndMeasureTypeList, this.bkndMeasureFilter);
                bl2 = false;
            }
            catch (FtpException ftpException) {
                bl2 = true;
            }
            finally {
                this.releaseBkndReadData(bl);
            }
        } while (bl2);
        return measureDataArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseBkndReadData(boolean bl) {
        Tracker4xxx tracker4xxx = this;
        synchronized (tracker4xxx) {
            if (bl) {
                this.factoryBkndReadInProgress = false;
            } else {
                this.bkndReadInProgress = false;
            }
        }
    }

    private synchronized void localStopBkndMeasure(boolean bl, boolean bl2) throws TrackerException {
        if (!this.isConnected()) {
            throw new NotConnectedException();
        }
        if (bl2) {
            if (this.isFactoryBkndMeasuring() && bl == this.factoryBkndGeneralMeasureFlag) {
                try {
                    this.factoryBkndFtpClient.receiveAbort();
                    this.factoryBkndFtpClient.disconnect();
                    this.factoryBkndFtpClient = null;
                    this.factoryBkndMeasureInProgress = false;
                }
                catch (FtpException ftpException) {
                    throw this.convertFtpExc(ftpException);
                }
            }
        } else if (this.isBkndMeasuring() && bl == this.bkndGeneralMeasureFlag) {
            try {
                this.bkndFtpClient.receiveAbort();
                this.bkndFtpClient.disconnect();
                this.bkndFtpClient = null;
                this.bkndMeasureInProgress = false;
            }
            catch (FtpException ftpException) {
                throw this.convertFtpExc(ftpException);
            }
        }
    }

    @Override
    public synchronized void startBkndMeasure(MeasureCfg measureCfg, DataTag[] dataTagArray) throws TrackerException {
        this.localStartBkndMeasure(measureCfg, dataTagArray, true, false);
    }

    @Override
    public MeasureData[] readBkndMeasureData(int n) throws TrackerException {
        return this.localReadBkndMeasureData(n, false);
    }

    @Override
    public void stopBkndMeasure() throws TrackerException {
        this.localStopBkndMeasure(true, false);
    }

    @Override
    public synchronized void startBkndMeasurePoint(MeasureCfg measureCfg) throws TrackerException {
        this.localStartBkndMeasurePoint(measureCfg, false);
    }

    @Override
    public MeasurePointData[] readBkndMeasurePointData(int n) throws TrackerException {
        MeasurePointData[] measurePointDataArray = null;
        this.testAndSetBkndReadData(false, false);
        try {
            measurePointDataArray = this.readPointData(this.bkndFtpClient, n, this.bkndMeasureFilter);
        }
        catch (FtpException ftpException) {
            throw this.convertFtpExc(ftpException);
        }
        finally {
            this.releaseBkndReadData(false);
        }
        return measurePointDataArray;
    }

    @Override
    public void stopBkndMeasurePoint() throws TrackerException {
        this.localStopBkndMeasure(false, false);
    }

    @Override
    public synchronized void startFactoryBkndMeasure(MeasureCfg measureCfg, DataTag[] dataTagArray) throws TrackerException {
        this.localStartBkndMeasure(measureCfg, dataTagArray, true, true);
    }

    @Override
    public MeasureData[] readFactoryBkndMeasureData(int n) throws TrackerException {
        return this.localReadBkndMeasureData(n, true);
    }

    @Override
    public void stopFactoryBkndMeasure() throws TrackerException {
        this.localStopBkndMeasure(true, true);
    }

    @Override
    public synchronized void startFactoryBkndMeasurePoint(MeasureCfg measureCfg) throws TrackerException {
        this.localStartBkndMeasurePoint(measureCfg, true);
    }

    @Override
    public MeasurePointData[] readFactoryBkndMeasurePointData(int n) throws TrackerException {
        MeasurePointData[] measurePointDataArray = null;
        this.testAndSetBkndReadData(false, true);
        try {
            measurePointDataArray = this.readPointData(this.factoryBkndFtpClient, n, this.factoryBkndMeasureFilter);
        }
        catch (FtpException ftpException) {
            throw this.convertFtpExc(ftpException);
        }
        finally {
            this.releaseBkndReadData(true);
        }
        return measurePointDataArray;
    }

    @Override
    public void stopFactoryBkndMeasurePoint() throws TrackerException {
        this.localStopBkndMeasure(false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeOneTimePoints(DataTag[] dataTagArray) throws TrackerException {
        int n;
        TrackerException trackerException = null;
        try {
            n = this.ftpClient.sendStart("\\data\\single.arg");
            if (150 != n) {
                throw this.exceptionFromResponse(this.ftpClient, n);
            }
        }
        catch (FtpException ftpException) {
            throw this.convertFtpExc(ftpException);
        }
        try {
            for (int i = 0; i < dataTagArray.length; ++i) {
                this.ftpClient.sendLine(dataTagArray[i].getName());
            }
        }
        catch (FtpException ftpException) {
            trackerException = this.convertFtpExc(ftpException);
        }
        finally {
            block18: {
                try {
                    n = this.ftpClient.sendEnd(10000);
                    if (226 != n && null == trackerException) {
                        trackerException = this.exceptionFromResponse(this.ftpClient, n);
                    }
                }
                catch (FtpException ftpException) {
                    if (null != trackerException) break block18;
                    trackerException = this.convertFtpExc(ftpException);
                }
            }
        }
        if (null != trackerException) {
            throw trackerException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void writeOneTimeData(DataTag[] dataTagArray, Object[] objectArray) throws TrackerException {
        int n;
        TrackerException trackerException = null;
        this.readyForCommand();
        this.writeOneTimePoints(dataTagArray);
        try {
            n = this.ftpClient.sendStart("\\data\\singlbin.dat");
            if (150 != n) {
                throw this.exceptionFromResponse(this.ftpClient, n);
            }
        }
        catch (FtpException ftpException) {
            throw this.convertFtpExc(ftpException);
        }
        int[] nArray = this.createTypeList(dataTagArray);
        try {
            for (int i = 0; i < dataTagArray.length; ++i) {
                this.writeDataElement(objectArray[i], nArray[i]);
            }
        }
        catch (FtpException ftpException) {
            trackerException = this.convertFtpExc(ftpException);
        }
        finally {
            block18: {
                try {
                    n = this.ftpClient.sendEnd(10000);
                    if (226 != n) {
                        trackerException = this.exceptionFromResponse(this.ftpClient, n);
                    }
                }
                catch (FtpException ftpException) {
                    if (null != trackerException) break block18;
                    trackerException = this.convertFtpExc(ftpException);
                }
            }
        }
        if (null != trackerException) {
            throw trackerException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Object[] readOneTimeData(DataTag[] dataTagArray) throws TrackerException {
        int n;
        TrackerException trackerException = null;
        this.readyForCommand();
        this.writeOneTimePoints(dataTagArray);
        Object[] objectArray = new Object[dataTagArray.length];
        int[] nArray = this.createTypeList(dataTagArray);
        try {
            n = this.ftpClient.receiveStart("\\data\\singlbin.dat");
            if (150 != n) {
                throw this.exceptionFromResponse(this.ftpClient, n);
            }
        }
        catch (FtpException ftpException) {
            throw this.convertFtpExc(ftpException);
        }
        try {
            for (int i = 0; i < dataTagArray.length; ++i) {
                objectArray[i] = this.readDataElement(this.ftpClient, nArray[i]);
            }
        }
        catch (FtpException ftpException) {
            trackerException = this.convertFtpExc(ftpException);
        }
        finally {
            block18: {
                try {
                    n = this.ftpClient.receiveEnd();
                    if (226 != n) {
                        trackerException = this.exceptionFromResponse(this.ftpClient, n);
                    }
                }
                catch (FtpException ftpException) {
                    if (null != trackerException) break block18;
                    trackerException = this.convertFtpExc(ftpException);
                }
            }
        }
        if (null != trackerException) {
            throw trackerException;
        }
        return objectArray;
    }

    @Override
    public boolean targetPresent() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32("target_state.int_output")};
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        return 2L == (Long)objectArray[0];
    }

    @Override
    public boolean targetLocationValid() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned16("az_corrected.status"), new DataTagUnsigned16("el_corrected.status"), new DataTagUnsigned16("dist_corrected.status")};
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        return 0 == (Integer)objectArray[0] && 0 == (Integer)objectArray[1] && 0 == (Integer)objectArray[2];
    }

    @Override
    public boolean connected() throws TrackerException {
        return this.isConnected();
    }

    @Override
    public boolean motorsOn() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32("motor_state.int_output")};
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        return 1 == ((Long)objectArray[0]).intValue();
    }

    @Override
    public boolean initialized() throws TrackerException {
        return this.initialized(true);
    }

    @Override
    public boolean initialized(boolean bl) throws TrackerException {
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32("motor_state.int_output")};
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        return 2 != ((Long)objectArray[0]).intValue();
    }

    @Override
    public boolean trackingOn() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32("control_mode.int_output")};
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        return 0 == ((Long)objectArray[0]).intValue();
    }

    @Override
    public boolean admCapable() throws TrackerException {
        if (!this.isConnected()) {
            throw new NotConnectedException();
        }
        return this.isADMCapable;
    }

    @Override
    public boolean admOnlyCapable() {
        return false;
    }

    @Override
    public boolean interferometerCapable() throws TrackerException {
        if (!this.isConnected()) {
            throw new NotConnectedException();
        }
        return true;
    }

    @Override
    public boolean levelCapable() throws TrackerException {
        if (!this.isConnected()) {
            throw new NotConnectedException();
        }
        return this.isLevelCapable;
    }

    @Override
    public DistanceMode distanceMeasureMode() throws TrackerException {
        if (!this.isConnected()) {
            throw new NotConnectedException();
        }
        if (this.isADMEnabled) {
            return new InterferometerSetByADM();
        }
        return new InterferometerOnly();
    }

    @Override
    public TargetType targetType() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32("target.int_output")};
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        switch ((int)((Long)objectArray[0]).longValue()) {
            case 0: {
                return new SMRTargetType(0.0381);
            }
            case 1: {
                return new MirrorTargetType();
            }
            case 2: {
                return new SMRTargetType(0.0127);
            }
            case 3: {
                return new SMRTargetType(0.022225);
            }
        }
        return new SMRTargetType(0.0);
    }

    @Override
    public boolean backsightOrientation() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32("fb_sight_mode.int_output")};
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        return 1 == ((Long)objectArray[0]).intValue();
    }

    private boolean asyncRunning() {
        return null != this.asyncInput;
    }

    @Override
    public synchronized void startAsync() throws TrackerException {
        int[] nArray = new int[4];
        this.readyForCommand();
        if (this.asyncRunning()) {
            throw new InterfaceBusyException(Tracker.res.getString("Async_Already_Running"));
        }
        try {
            try {
                this.statusHistoryFilter = this.statusHistory();
            }
            catch (NoDataAvailableException noDataAvailableException) {
                this.statusHistoryFilter = null;
            }
            try {
                this.alarmHistoryFilter = this.alarmHistory();
            }
            catch (NoDataAvailableException noDataAvailableException) {
                this.alarmHistoryFilter = null;
            }
            try {
                this.changeHistoryFilter = this.changeHistory();
            }
            catch (NoDataAvailableException noDataAvailableException) {
                this.changeHistoryFilter = null;
            }
            byte[] byArray = this.ftpClient.getIPAddress().getAddress();
            for (int i = 0; i < 4; ++i) {
                nArray[i] = byArray[i];
                if (nArray[i] >= 0) continue;
                int n = i;
                nArray[n] = nArray[n] + 256;
            }
            ServerSocket serverSocket = new ServerSocket(0, 1);
            int n = serverSocket.getLocalPort();
            String string = "statconn " + nArray[0] + "," + nArray[1] + "," + nArray[2] + "," + nArray[3] + "," + n / 256 + "," + n % 256;
            this.ftpClient.commandOnly(string);
            serverSocket.setSoTimeout(2000);
            Socket socket = serverSocket.accept();
            socket.setSoTimeout(250);
            socket.setReceiveBufferSize(500);
            this.asyncInput = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            this.asyncReadInterrupted = false;
            this.asyncReadInProgress = false;
            int n2 = this.ftpClient.responseOnly(2000);
            if (228 != n2 && 556 == n2) {
                throw this.exceptionFromResponse(this.ftpClient, n2);
            }
            this.asyncComm = new ThreadComm(3);
        }
        catch (FtpException ftpException) {
            Object var8_14 = null;
            throw this.convertFtpExc(ftpException);
        }
        catch (IOException iOException) {
            Object var8_15 = null;
            throw new CommunicationException(Tracker.res.getString("IO_Exception"));
        }
    }

    @Override
    public synchronized void stopAsync() throws TrackerException {
        this.readyForCommand();
        if (!this.asyncRunning()) {
            return;
        }
        try {
            this.asyncInput.close();
            this.asyncInput = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Diagnostic convertToDiag(String string, StringTokenizer stringTokenizer) {
        stringTokenizer.nextToken();
        int n = Integer.parseInt(stringTokenizer.nextToken(), 16);
        int n2 = n < 0 || n >= diagMap.length ? 0 : diagMap[n];
        String string2 = "Code=" + n + " ";
        string2 = string2 + "Param1=" + stringTokenizer.nextToken() + " ";
        string2 = string2 + "Param2=" + stringTokenizer.nextToken() + " ";
        string2 = string2 + "Task=" + stringTokenizer.nextToken();
        double d = Double.parseDouble(stringTokenizer.nextToken());
        int n3 = Integer.parseInt(stringTokenizer.nextToken(), 16);
        return new Diagnostic(n2, d, n3, string2);
    }

    private Change convertToChange(String string, StringTokenizer stringTokenizer) {
        Boolean bl;
        stringTokenizer.nextToken();
        int n = Integer.parseInt(stringTokenizer.nextToken(), 16) & 0xFF;
        int n2 = n < 0 || n >= changeMap.length ? 0 : changeMap[n];
        int n3 = Integer.parseInt(stringTokenizer.nextToken());
        switch (n2) {
            case 2: {
                bl = new Boolean(0 == n3);
                break;
            }
            case 1: {
                bl = new Boolean(1 == n3);
                break;
            }
            default: {
                bl = null;
            }
        }
        double d = Double.parseDouble(stringTokenizer.nextToken());
        int n4 = Integer.parseInt(stringTokenizer.nextToken(), 16);
        return new Change(n2, d, n4, string, bl);
    }

    private Status convertToStatus(String string, StringTokenizer stringTokenizer) {
        stringTokenizer.nextToken();
        int n = Integer.parseInt(stringTokenizer.nextToken(), 16) & 0xFF;
        String string2 = stringTokenizer.nextToken();
        double d = Double.parseDouble(stringTokenizer.nextToken());
        int n2 = Integer.parseInt(stringTokenizer.nextToken(), 16);
        boolean bl = 0 == string2.compareToIgnoreCase("on");
        int n3 = n < 0 || n > statusMap.length ? 0 : statusMap[n];
        return new Status(n3, bl, d, n2, string);
    }

    private Alarm convertToAlarm(String string, StringTokenizer stringTokenizer) {
        stringTokenizer.nextToken();
        int n = Integer.parseInt(stringTokenizer.nextToken());
        String string2 = stringTokenizer.nextToken();
        double d = Double.parseDouble(stringTokenizer.nextToken());
        int n2 = Integer.parseInt(stringTokenizer.nextToken(), 16);
        boolean bl = 0 == string2.compareToIgnoreCase("on");
        return new Alarm(n, bl, d, n2, string);
    }

    private AsyncMsg convertLineToAsync(String string) throws TrackerException {
        AsyncMsg asyncMsg = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        try {
            String string2 = stringTokenizer.nextToken();
            switch (string2.charAt(0)) {
                case 'D': {
                    asyncMsg = this.convertToDiag(string, stringTokenizer);
                    break;
                }
                case 'E': {
                    asyncMsg = this.convertToChange(string, stringTokenizer);
                    break;
                }
                case 'S': {
                    asyncMsg = this.convertToStatus(string, stringTokenizer);
                    break;
                }
                case 'A': {
                    asyncMsg = this.convertToAlarm(string, stringTokenizer);
                    break;
                }
                default: {
                    throw new NoSuchElementException();
                }
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new DataFormatException();
        }
        return asyncMsg;
    }

    private Status filterStatus(Status status) {
        boolean bl = false;
        if (null != this.statusHistoryFilter) {
            int n;
            for (n = this.statusHistoryFilter.length - 1; n >= 0 && status.getCode() != this.statusHistoryFilter[n].getCode(); --n) {
            }
            boolean bl2 = n >= 0 && this.statusHistoryFilter[n].getID() == status.getID();
            boolean bl3 = bl = n >= 0 && (!this.statusHistoryFilter[n].getState() || !bl2);
            if (n < 0 || this.statusHistoryFilter.length - 1 == n && bl2) {
                this.statusHistoryFilter = null;
            }
        }
        if (bl) {
            return null;
        }
        return status;
    }

    private Alarm filterAlarm(Alarm alarm) {
        boolean bl = false;
        if (null != this.alarmHistoryFilter) {
            int n;
            for (n = this.alarmHistoryFilter.length - 1; n >= 0 && alarm.getAlarmNumber() != this.alarmHistoryFilter[n].getAlarmNumber(); --n) {
            }
            boolean bl2 = n >= 0 && this.alarmHistoryFilter[n].getID() == alarm.getID();
            boolean bl3 = bl = n >= 0 && (!this.alarmHistoryFilter[n].getState() || !bl2);
            if (n < 0 || this.alarmHistoryFilter.length - 1 == n && bl2) {
                this.alarmHistoryFilter = null;
            }
        }
        if (bl) {
            return null;
        }
        return alarm;
    }

    private Change filterChange(Change change) {
        boolean bl = false;
        if (null != this.changeHistoryFilter) {
            int n;
            for (n = this.changeHistoryFilter.length - 1; n >= 0; --n) {
                boolean bl2;
                boolean bl3 = bl2 = this.changeHistoryFilter[n].getID() == change.getID();
                if (change.getCode() == this.changeHistoryFilter[n].getCode() && bl2) break;
            }
            boolean bl4 = bl = n >= 0;
            if (n < 0) {
                this.changeHistoryFilter = null;
            }
        }
        if (bl) {
            return null;
        }
        return change;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public AsyncMsg readAsyncMsg() throws TrackerException {
        var1_1 = null;
        var2_2 = null;
        var3_3 = this;
        synchronized (var3_3) {
            if (!this.asyncRunning()) {
                throw new NoDataAvailableException();
            }
            this.asyncReadInProgress = true;
        }
        while (true) lbl-1000:
        // 7 sources

        {
            if (null != var1_1) {
                if (null != var2_2) return var2_2;
            }
            if (this.asyncReadInterrupted != false) return var2_2;
            try {
                if (this.asyncComm.isEmpty()) {
                    var1_1 = this.asyncInput.readLine();
                    var2_2 = this.convertLineToAsync(var1_1);
                    if (var2_2 instanceof Status) {
                        var2_2 = this.filterStatus((Status)var2_2);
                    }
                    if (var2_2 instanceof Alarm) {
                        var2_2 = this.filterAlarm((Alarm)var2_2);
                    }
                    if (!(var2_2 instanceof Change)) ** GOTO lbl-1000
                    var2_2 = this.filterChange((Change)var2_2);
                }
                var2_2 = (AsyncMsg)this.asyncComm.receive()[0];
                var1_1 = "";
            }
            catch (InterruptedIOException var3_4) {
                continue;
            }
            catch (IOException var3_5) {
                throw new NoDataAvailableException();
            }
            break;
        }
        ** GOTO lbl-1000
        finally {
            var3_3 = this;
            synchronized (var3_3) {
                this.asyncReadInProgress = false;
                while (true) {
                    if (!this.asyncReadInterrupted) {
                    }
                    try {
                        this.wait();
                    }
                    catch (InterruptedException var4_6) {
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object[] getHistory(String string, Class clazz) throws TrackerException {
        ArrayList<AsyncMsg> arrayList = null;
        TrackerException trackerException = null;
        this.readyForCommand();
        try {
            arrayList = new ArrayList<AsyncMsg>();
            int n = this.ftpClient.receiveStart(string);
            if (150 != n) {
                throw this.exceptionFromResponse(this.ftpClient, n);
            }
            try {
                String string2;
                while (null != (string2 = this.ftpClient.receiveLine())) {
                    try {
                        AsyncMsg asyncMsg = this.convertLineToAsync(string2);
                        if (clazz != asyncMsg.getClass()) continue;
                        arrayList.add(asyncMsg);
                    }
                    catch (DataFormatException dataFormatException) {
                    }
                }
            }
            catch (FtpNoResponseException ftpNoResponseException) {
                // empty catch block
            }
        }
        catch (FtpException ftpException) {
            trackerException = this.convertFtpExc(ftpException);
        }
        finally {
            block21: {
                try {
                    int n = this.ftpClient.receiveEnd();
                    if (226 != n) {
                        trackerException = this.exceptionFromResponse(this.ftpClient, n);
                    }
                }
                catch (FtpException ftpException) {
                    if (null != trackerException) break block21;
                    trackerException = this.convertFtpExc(ftpException);
                }
            }
        }
        if (null != trackerException) {
            throw trackerException;
        }
        if (null != arrayList && 0 != arrayList.size()) {
            return arrayList.toArray();
        }
        throw new NoDataAvailableException();
    }

    @Override
    public Diagnostic[] diagnosticHistory() throws TrackerException {
        Object[] objectArray = this.getHistory("\\message\\diaghst.dat", Diagnostic.class);
        int n = objectArray.length;
        Diagnostic[] diagnosticArray = new Diagnostic[n];
        for (int i = 0; i < n; ++i) {
            diagnosticArray[i] = (Diagnostic)objectArray[i];
        }
        return diagnosticArray;
    }

    @Override
    public Status[] statusHistory() throws TrackerException {
        Object[] objectArray = this.getHistory("\\message\\stathst.dat", Status.class);
        int n = objectArray.length;
        Status[] statusArray = new Status[n];
        for (int i = 0; i < n; ++i) {
            statusArray[i] = (Status)objectArray[i];
        }
        return statusArray;
    }

    @Override
    public Alarm[] alarmHistory() throws TrackerException {
        Object[] objectArray = this.getHistory("\\message\\alarmhst.dat", Alarm.class);
        int n = objectArray.length;
        Alarm[] alarmArray = new Alarm[n];
        for (int i = 0; i < n; ++i) {
            alarmArray[i] = (Alarm)objectArray[i];
        }
        return alarmArray;
    }

    private Change[] changeHistory() throws TrackerException {
        Object[] objectArray = this.getHistory("\\message\\eventhst.dat", Change.class);
        int n = objectArray.length;
        Change[] changeArray = new Change[n];
        for (int i = 0; i < n; ++i) {
            changeArray[i] = (Change)objectArray[i];
        }
        return changeArray;
    }

    @Override
    public LevelData measureLevel() throws TrackerException {
        if (!this.isLevelCapable) {
            throw new UnsupportedFeatureException(Tracker.res.getString("Level_Not_Installed"));
        }
        this.trackerCommand("level run", 120000);
        DataTag[] dataTagArray = new DataTag[]{new DataTagDouble("last_meas_level_rx.output"), new DataTagDouble("last_meas_level_ry.output")};
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        double d = Math.toRadians((Double)objectArray[0] / 3600.0);
        double d2 = Math.toRadians((Double)objectArray[1] / 3600.0);
        return new LevelData(d, d2, 0.0);
    }

    @Override
    public MaterialTemperatureData measureMaterialTemperature() throws TrackerException {
        double d = 0.0;
        int n = 0;
        DataTag[] dataTagArray = new DataTag[]{new DataTagDouble("mat_temp_1.output"), new DataTagUnsigned16("mat_temp_1.status"), new DataTagDouble("mat_temp_2.output"), new DataTagUnsigned16("mat_temp_2.status"), new DataTagDouble("mat_temp_3.output"), new DataTagUnsigned16("mat_temp_3.status"), new DataTagDouble("mat_temp_4.output"), new DataTagUnsigned16("mat_temp_4.status"), new DataTagDouble("mat_temp_5.output"), new DataTagUnsigned16("mat_temp_5.status"), new DataTagDouble("mat_temp_6.output"), new DataTagUnsigned16("mat_temp_6.status"), new DataTagDouble("mat_temp_7.output"), new DataTagUnsigned16("mat_temp_7.status"), new DataTagDouble("mat_temp_8.output"), new DataTagUnsigned16("mat_temp_8.status")};
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        for (int i = 0; i < 15; i += 2) {
            int n2 = (Integer)objectArray[i + 1];
            if (0 != (n2 & 0x10)) continue;
            if (0 != (n2 & 2)) {
                throw new InternalDeviceFailureException(Tracker.res.getString("Sensor_Error"));
            }
            if (0 != (n2 & 4)) {
                throw new InternalDeviceFailureException(Tracker.res.getString("Sensor_Inaccurate"));
            }
            d += ((Double)objectArray[i]).doubleValue();
            ++n;
        }
        if (0 == n) {
            throw new InternalDeviceFailureException(Tracker.res.getString("No_Sensors_Found"));
        }
        return new MaterialTemperatureData(d /= (double)n, n);
    }

    private void localStopApplication(AppRec appRec) {
        appRec.app.stop();
        appRec.clear();
    }

    private void setAppInfo() throws TrackerException {
        this.appInfo = new AppRec[10];
        this.appInfo[0] = new AppRec("TrackerPad", "smx.tracker.apps4xxx.trackerpad.TrackerPad");
        this.appInfo[1] = new AppRec("AsyncMsgDisplay", "smx.tracker.apps4xxx.asyncmsgdisplay.AsyncMsgDisplay");
        this.appInfo[2] = new AppRec("HealthChecks", "smx.tracker.apps4xxx.healthchecks.HealthChecks");
        this.appInfo[3] = new AppRec("MeasurePad", "smx.tracker.apps4xxx.measurepad.MeasurePad");
        this.appInfo[4] = new AppRec("Diagnostics", "smx.tracker.apps4xxx.diagnostics.Diagnostics");
        this.appInfo[5] = new AppRec("Closure", "smx.tracker.apps4xxx.closure.Closure");
        this.appInfo[6] = new AppRec("CompIT", "smx.tracker.apps4xxx.execompit.ExeCompIT");
        this.appInfo[7] = new AppRec("ADMComp", "smx.tracker.apps4xxx.execompit.ExeCompIT");
        this.appInfo[8] = new AppRec("StartupChecks", "smx.tracker.apps4xxx.startupchecks.StartupChecks");
        this.appInfo[9] = new AppRec("OperationalChecks", "smx.tracker.apps4xxx.operationalchecks.OperationalChecks");
    }

    private void clearAppInfo() throws TrackerException {
        if (null == this.appInfo) {
            return;
        }
        for (int i = 0; i < this.appInfo.length; ++i) {
            if (!this.appInfo[i].isSet()) continue;
            throw new InterfaceBusyException(Tracker.res.getString("Application_Running"));
        }
        this.appInfo = null;
    }

    @Override
    public synchronized String[] availableApplications() throws TrackerException {
        String[] stringArray = this.isADMCapable ? new String[this.appInfo.length] : new String[this.appInfo.length - 1];
        int n = 0;
        for (int i = 0; i < this.appInfo.length; ++i) {
            if (this.appInfo[i].appName.equals("ADMComp") && !this.isADMCapable) continue;
            stringArray[n++] = this.appInfo[i].appName;
        }
        return stringArray;
    }

    private AppRec findAppInfo(String string) throws TrackerException {
        int n;
        for (n = 0; n < this.appInfo.length && !string.equals(this.appInfo[n].appName); ++n) {
        }
        if (this.appInfo.length == n) {
            throw new ApplicationFailedException(Tracker.res.getString("Unknown_Application_Name"));
        }
        return this.appInfo[n];
    }

    @Override
    public TrackerApp startApplication(String string, String string2, Tracker tracker, JFrame jFrame) throws TrackerException {
        this.readyForCommand();
        AppRec appRec = this.findAppInfo(string);
        if (appRec.isSet()) {
            throw new ApplicationFailedException(Tracker.res.getString("Application_Already_Running"));
        }
        try {
            TrackerApp trackerApp;
            if (appRec.appName.equals("CompIT") || appRec.appName.equals("ADMComp")) {
                Class[] classArray = new Class[]{String.class, Tracker.class, JFrame.class, String.class, String.class};
                Class<?> clazz = Class.forName(appRec.fullyQualifiedName);
                Constructor<?> constructor = clazz.getConstructor(classArray);
                Object[] objectArray = new Object[5];
                objectArray[0] = string2;
                objectArray[1] = tracker;
                objectArray[2] = jFrame;
                objectArray[3] = string;
                byte[] byArray = this.ftpClient.getRemoteIPAddress().getAddress();
                int[] nArray = new int[4];
                for (int i = 0; i < 4; ++i) {
                    nArray[i] = byArray[i];
                    if (nArray[i] >= 0) continue;
                    int n = i;
                    nArray[n] = nArray[n] + 256;
                }
                objectArray[4] = nArray[0] + "." + nArray[1] + "." + nArray[2] + "." + nArray[3];
                trackerApp = (TrackerApp)constructor.newInstance(objectArray);
            } else {
                Class[] classArray = new Class[]{String.class, Tracker.class, JFrame.class};
                Class<?> clazz = Class.forName(appRec.fullyQualifiedName);
                Constructor<?> constructor = clazz.getConstructor(classArray);
                Object[] objectArray = new Object[]{string2, tracker, jFrame};
                trackerApp = (TrackerApp)constructor.newInstance(objectArray);
            }
            appRec.set(trackerApp);
            return trackerApp;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ApplicationFailedException(Tracker.res.getString("Class_Not_Found"));
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ApplicationFailedException(Tracker.res.getString("Illegal_Access"));
        }
        catch (InstantiationException instantiationException) {
            throw new ApplicationFailedException(Tracker.res.getString("Instantiation_Failed"));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ApplicationFailedException(Tracker.res.getString("Could_Not_Get_Constructor"));
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ApplicationFailedException(Tracker.res.getString("Could_Not_Invoke_Application"));
        }
        catch (FtpException ftpException) {
            throw new ApplicationFailedException(Tracker.res.getString("Failed_To_Construct"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modifyApplication(String string, String string2) throws TrackerException {
        Tracker4xxx tracker4xxx = this;
        synchronized (tracker4xxx) {
            AppRec appRec = this.findAppInfo(string);
            if (appRec.isSet()) {
                appRec.app.modifyParameters(string2);
            }
        }
    }

    @Override
    public TrackerApp stopApplication(String string) throws TrackerException {
        TrackerApp trackerApp = this.stopApplication(string, true);
        return trackerApp;
    }

    @Override
    public synchronized String[] startedApplications() throws TrackerException {
        int n;
        int n2 = 0;
        if (null == this.appInfo) {
            return null;
        }
        for (n = 0; n < this.appInfo.length; ++n) {
            if (!this.appInfo[n].isSet()) continue;
            ++n2;
        }
        if (0 == n2) {
            return null;
        }
        String[] stringArray = new String[n2];
        int n3 = 0;
        for (n = 0; n < this.appInfo.length; ++n) {
            if (!this.appInfo[n].isSet()) continue;
            stringArray[n3] = this.appInfo[n].appName;
            ++n3;
        }
        return stringArray;
    }

    @Override
    public void writeFile(String string, String string2) throws TrackerException {
        int n;
        FileInputStream fileInputStream;
        this.readyForCommand();
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new FileAccessException(fileNotFoundException.toString());
        }
        catch (SecurityException securityException) {
            throw new FileAccessException(securityException.toString());
        }
        try {
            n = this.ftpClient.sendStart(string2);
            if (150 != n) {
                throw this.exceptionFromResponse(this.ftpClient, n);
            }
        }
        catch (FtpException ftpException) {
            throw this.convertFtpExc(ftpException);
        }
        try {
            int n2;
            byte[] byArray;
            int n3 = fileInputStream.available();
            int n4 = n3 / 1200;
            if (n4 > 0) {
                byArray = new byte[1200];
                for (int i = 0; i < n4; ++i) {
                    fileInputStream.read(byArray);
                    this.ftpClient.sendBuffer(byArray);
                }
            }
            if ((n2 = n3 % 1200) > 0) {
                byArray = new byte[n2];
                fileInputStream.read(byArray);
                this.ftpClient.sendBuffer(byArray);
            }
        }
        catch (FtpException ftpException) {
            try {
                this.ftpClient.sendAbort();
            }
            catch (FtpException ftpException2) {
                // empty catch block
            }
            throw this.convertFtpExc(ftpException);
        }
        catch (IOException iOException) {
            try {
                this.ftpClient.sendAbort();
            }
            catch (FtpException ftpException) {
                // empty catch block
            }
            throw new FileAccessException(iOException.toString());
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {}
        }
        try {
            n = this.ftpClient.sendEnd();
            if (226 != n) {
                throw this.exceptionFromResponse(this.ftpClient, n);
            }
        }
        catch (FtpException ftpException) {
            throw this.convertFtpExc(ftpException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readFile(String string, String string2) throws TrackerException {
        FileOutputStream fileOutputStream;
        TrackerException trackerException = null;
        this.readyForCommand();
        byte[] byArray = new byte[1200];
        try {
            fileOutputStream = new FileOutputStream(string, false);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new FileAccessException(fileNotFoundException.toString());
        }
        catch (SecurityException securityException) {
            throw new FileAccessException(securityException.toString());
        }
        try {
            int n;
            int n2 = this.ftpClient.receiveStart(string2);
            if (150 != n2) {
                throw this.exceptionFromResponse(this.ftpClient, n2);
            }
            do {
                if ((n = this.ftpClient.receiveBuffer(byArray)) <= 0) continue;
                fileOutputStream.write(byArray, 0, n);
            } while (n > 0);
        }
        catch (FtpException ftpException) {
            trackerException = this.convertFtpExc(ftpException);
        }
        catch (IOException iOException) {
            trackerException = new FileAccessException(iOException.toString());
        }
        finally {
            block31: {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
                try {
                    int n = this.ftpClient.receiveEnd();
                    if (226 != n) {
                        trackerException = this.exceptionFromResponse(this.ftpClient, n);
                    }
                }
                catch (FtpException ftpException) {
                    if (null != trackerException) break block31;
                    trackerException = this.convertFtpExc(ftpException);
                }
            }
        }
        if (null != trackerException) {
            throw trackerException;
        }
    }

    private void fillAlarmData(int n, AlarmType alarmType, Object[] objectArray) throws TrackerException {
        if (alarmType instanceof DeviationAlarm) {
            objectArray[0] = new Short(3);
            objectArray[1] = new Short(1);
            objectArray[2] = new Integer(28 + n - 1);
            objectArray[3] = new Double(((DeviationAlarm)alarmType).getSetPoint());
            objectArray[4] = new Double(((DeviationAlarm)alarmType).getDeviation());
            return;
        }
        if (alarmType instanceof NullAlarm) {
            objectArray[0] = new Short(0);
            objectArray[1] = new Short(0);
            objectArray[2] = new Integer(0);
            objectArray[3] = new Double(20.0);
            objectArray[4] = new Double(5.0);
            return;
        }
        if (alarmType instanceof HighAlarm) {
            objectArray[0] = new Short(3);
            objectArray[1] = new Short(2);
            objectArray[2] = new Integer(28 + n - 1);
            objectArray[3] = new Double(((HighAlarm)alarmType).getSetPoint());
            objectArray[4] = new Double(5.0);
            return;
        }
        if (alarmType instanceof LowAlarm) {
            objectArray[0] = new Short(3);
            objectArray[1] = new Short(3);
            objectArray[2] = new Integer(28 + n - 1);
            objectArray[3] = new Double(((LowAlarm)alarmType).getSetPoint());
            objectArray[4] = new Double(5.0);
            return;
        }
        throw new UnsupportedFeatureException(Tracker.res.getString("Unknown_Alarm_Type"));
    }

    @Override
    public void changeAlarmCfg(int n, AlarmType alarmType) throws TrackerException {
        if (n < 1 || n > 8) {
            throw new UnsupportedFeatureException(Tracker.res.getString("Unknown_Alarm_Number"));
        }
        String string = "temp_alarm_" + n;
        DataTag[] dataTagArray = new DataTag[5];
        Object[] objectArray = new Object[5];
        dataTagArray[0] = new DataTagUnsigned8(string + ".input_selector");
        dataTagArray[1] = new DataTagUnsigned8(string + ".alarm_type");
        dataTagArray[2] = new DataTagUnsigned16(string + ".point");
        dataTagArray[3] = new DataTagDouble(string + ".setpoint");
        dataTagArray[4] = new DataTagDouble(string + ".tolerance");
        this.fillAlarmData(n, alarmType, objectArray);
        this.writeOneTimeData(dataTagArray, objectArray);
    }

    private AlarmType getAlarmType(int n, Object[] objectArray) throws TrackerException {
        if (0 == (Short)objectArray[1] || 3 != (Short)objectArray[0] || 28 + n - 1 != (Integer)objectArray[2]) {
            return new NullAlarm();
        }
        switch ((Short)objectArray[1]) {
            case 2: {
                return new HighAlarm((Double)objectArray[3]);
            }
            case 3: {
                return new LowAlarm((Double)objectArray[3]);
            }
            case 1: {
                return new DeviationAlarm((Double)objectArray[3], (Double)objectArray[4]);
            }
        }
        return new NullAlarm();
    }

    @Override
    public AlarmType alarmCfg(int n) throws TrackerException {
        if (n < 1 || n > 8) {
            throw new UnsupportedFeatureException(Tracker.res.getString("Unknown_Alarm_Number"));
        }
        String string = "temp_alarm_" + n;
        DataTag[] dataTagArray = new DataTag[5];
        Object[] objectArray = new Object[5];
        dataTagArray[0] = new DataTagUnsigned8(string + ".input_selector");
        dataTagArray[1] = new DataTagUnsigned8(string + ".alarm_type");
        dataTagArray[2] = new DataTagUnsigned16(string + ".point");
        dataTagArray[3] = new DataTagDouble(string + ".setpoint");
        dataTagArray[4] = new DataTagDouble(string + ".tolerance");
        objectArray = this.readOneTimeData(dataTagArray);
        return this.getAlarmType(n, objectArray);
    }

    @Override
    public int numExternalTempSensors() throws TrackerException {
        return 8;
    }

    @Override
    public ExtTempType externalTempType(int n) throws TrackerException {
        if (n < 1 || n > 8) {
            throw new UnsupportedFeatureException(Tracker.res.getString("Unknown_Sensor_Number"));
        }
        String string = "temp_" + n;
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned8("air_" + string + ".input_selector"), new DataTagUnsigned16("air_" + string + ".point"), new DataTagUnsigned8("mat_" + string + ".input_selector"), new DataTagUnsigned16("mat_" + string + ".point")};
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        ExtTempType extTempType = 3 == (Short)objectArray[0] && 28 + n - 1 == (Integer)objectArray[1] ? new AirExtTemp() : (3 == (Short)objectArray[2] && 28 + n - 1 == (Integer)objectArray[3] ? new MaterialExtTemp() : new NullExtTemp());
        return extTempType;
    }

    @Override
    public void changeExternalTempType(int n, ExtTempType extTempType) throws TrackerException {
        if (n < 1 || n > 8) {
            throw new UnsupportedFeatureException(Tracker.res.getString("Unknown_Sensor_Number"));
        }
        String string = "temp_" + n;
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned8("air_" + string + ".input_selector"), new DataTagUnsigned16("air_" + string + ".point"), new DataTagUnsigned8("mat_" + string + ".input_selector"), new DataTagUnsigned16("mat_" + string + ".point")};
        Object[] objectArray = new Object[4];
        if (extTempType instanceof AirExtTemp) {
            objectArray[0] = new Short(3);
            objectArray[1] = new Integer(28 + n - 1);
        } else {
            objectArray[0] = new Short(0);
            objectArray[1] = new Integer(0);
        }
        if (extTempType instanceof MaterialExtTemp) {
            objectArray[2] = new Short(3);
            objectArray[3] = new Integer(28 + n - 1);
        } else {
            objectArray[2] = new Short(0);
            objectArray[3] = new Integer(0);
        }
        this.writeOneTimeData(dataTagArray, objectArray);
    }

    @Override
    public boolean externalTempTypeChangeable() throws TrackerException {
        if (!this.isConnected()) {
            throw new NotConnectedException();
        }
        return true;
    }

    @Override
    public double measureExternalTempSensor(int n) throws TrackerException {
        if (n < 1 || n > 8) {
            throw new UnsupportedFeatureException(Tracker.res.getString("Unknown_Sensor_Number"));
        }
        DataTag[] dataTagArray = new DataTag[]{new DataTagDouble("temp_input_" + n + ".output"), new DataTagUnsigned16("temp_input_" + n + ".status"), new DataTagUnsigned8("air_temp_" + n + ".input_selector"), new DataTagUnsigned8("mat_temp_" + n + ".input_selector")};
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        if (3 != ((Short)objectArray[2]).intValue() && 3 != ((Short)objectArray[3]).intValue()) {
            throw new InternalDeviceFailureException(Tracker.res.getString("Sensor_Not_Configured"));
        }
        int n2 = (Integer)objectArray[1];
        if (0 != (n2 & 2)) {
            throw new InternalDeviceFailureException(Tracker.res.getString("Sensor_Error"));
        }
        if (0 != (n2 & 4)) {
            throw new InternalDeviceFailureException(Tracker.res.getString("Sensor_Inaccurate"));
        }
        return (Double)objectArray[0];
    }

    @Override
    public boolean standardPrivilege() throws TrackerException {
        if (!this.isConnected()) {
            throw new NotConnectedException();
        }
        return this.accessLevel >= 0;
    }

    @Override
    public boolean adminPrivilege() throws TrackerException {
        if (!this.isConnected()) {
            throw new NotConnectedException();
        }
        return this.accessLevel >= 1;
    }

    @Override
    public boolean factoryPrivilege() throws TrackerException {
        if (!this.isConnected()) {
            throw new NotConnectedException();
        }
        return this.accessLevel >= 2;
    }

    @Override
    public void readFileAbort() {
        try {
            this.ftpClient.sendAbort();
        }
        catch (FtpException ftpException) {
            // empty catch block
        }
    }

    @Override
    public void writeFileAbort() {
        try {
            this.ftpClient.sendAbort();
        }
        catch (FtpException ftpException) {
            // empty catch block
        }
    }

    @Override
    public boolean admScanCapable() throws TrackerException {
        return false;
    }

    @Override
    public TargetType[] availableTargetType() throws TrackerException {
        TargetType[] targetTypeArray = new TargetType[]{new SMRTargetType(0.0381), new MirrorTargetType(), new SMRTargetType(0.0127), new SMRTargetType(0.022225), new SMRTargetType(0.0)};
        return targetTypeArray;
    }

    @Override
    public WeatherInformation getWeatherInfo() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[6];
        int n = 0;
        dataTagArray[0] = new DataTagDouble("ambient_temp.output");
        dataTagArray[1] = new DataTagUnsigned16("ambient_temp.status");
        dataTagArray[2] = new DataTagDouble("air_pressure.output");
        dataTagArray[3] = new DataTagUnsigned16("air_pressure.status");
        dataTagArray[4] = new DataTagDouble("humidity.output");
        dataTagArray[5] = new DataTagUnsigned16("humidity.status");
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        double d = (Double)objectArray[0];
        double d2 = (Double)objectArray[2];
        double d3 = (Double)objectArray[4];
        n = (Integer)objectArray[1] | (Integer)objectArray[3] | (Integer)objectArray[5];
        if (0 == (n & 0xFFFFFFF7)) {
            return new WeatherInformation(d, d2, d3);
        }
        if ((n & 2) != 0) {
            throw new InternalDeviceFailureException(Tracker.res.getString("Sensor_Error"));
        }
        if ((n & 0x10) != 0) {
            throw new InternalDeviceFailureException(Tracker.res.getString("Sensor_Disabled"));
        }
        if ((n & 4) != 0) {
            throw new InternalDeviceFailureException(Tracker.res.getString("Sensor_Inaccurate"));
        }
        throw new InternalDeviceFailureException(Tracker.res.getString("Sensor_Unknown_Error"));
    }

    @Override
    public String getSerialNumber() throws TrackerException {
        return new String("4xxx");
    }

    @Override
    public String getIPAddress() throws TrackerException {
        return new String("4xxx");
    }

    @Override
    public boolean readyToInitialize(boolean bl) throws TrackerException {
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32("shutter_state.int_output"), new DataTagUnsigned32("laser.int_output")};
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        long l = (Long)objectArray[0];
        long l2 = (Long)objectArray[1];
        return l == 1L && l2 == 2L;
    }

    @Override
    public synchronized void factoryConnect(String string, String string2, String string3) throws TrackerException {
    }

    @Override
    public void factoryDisconnect() throws TrackerException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TrackerApp stopApplication(String string, boolean bl) throws TrackerException {
        TrackerApp trackerApp;
        if (bl && !this.isConnected()) {
            throw new NotConnectedException();
        }
        Tracker4xxx tracker4xxx = this;
        synchronized (tracker4xxx) {
            AppRec appRec = this.findAppInfo(string);
            if (!appRec.isSet()) {
                return null;
            }
            trackerApp = appRec.app;
            appRec.clear();
        }
        trackerApp.stop();
        return trackerApp;
    }

    @Override
    public int applicationExitCode(String string) throws TrackerException {
        return 4;
    }

    @Override
    public void releaseLock() throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Method_Not_Supported_4xxx_Trackers"));
    }

    @Override
    public void startSlew(double d, double d2, double d3) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Method_Not_Supported"));
    }

    @Override
    public void startSlew(double d, double d2) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Method_Not_Supported"));
    }

    @Override
    public void stopSlew() throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Method_Not_Supported"));
    }

    @Override
    public boolean isResultReportingCapable() throws TrackerException {
        return false;
    }

    @Override
    public boolean isAdaptiveFilterCapable() throws TrackerException {
        return false;
    }

    @Override
    public ApplicationResults applicationResults(String string) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported_4xxx_Trackers"));
    }

    @Override
    public boolean is_1_5_WindowedSMRTargetCapable() throws TrackerException {
        return false;
    }

    @Override
    public boolean is_7_8_WindowedSMRTargetCapable() throws TrackerException {
        return false;
    }

    @Override
    public MPEResultsData checkADMAgainstIFM(SimplePointPairData simplePointPairData) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported_4xxx_Trackers"));
    }

    @Override
    public MPEResultsData checkAngularAccuracyError(SimplePointPairData simplePointPairData) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported_4xxx_Trackers"));
    }

    @Override
    public boolean isSelfCompensationNoUICapable() throws TrackerException {
        return false;
    }

    @Override
    public void changeAirTemperatureToHardware() throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported_4xxx_Trackers"));
    }

    @Override
    public void changeAirPressureToHardware() throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported_4xxx_Trackers"));
    }

    @Override
    public void changeHumidityToHardware() throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported_4xxx_Trackers"));
    }

    @Override
    public void changeAirTemperatureToManual(double d) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported_4xxx_Trackers"));
    }

    @Override
    public void changeAirPressureToManual(double d) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported_4xxx_Trackers"));
    }

    @Override
    public void changeHumidityToManual(double d) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported_4xxx_Trackers"));
    }

    @Override
    public void changeLedState(int n, int n2) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported_4xxx_Trackers"));
    }

    @Override
    public VideoData[] readVideoData() throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported_4xxx_Trackers"));
    }

    @Override
    public void startVideo(VideoCfg videoCfg) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported_4xxx_Trackers"));
    }

    @Override
    public void stopVideo() throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported_4xxx_Trackers"));
    }

    @Override
    public void changeGestureState(boolean bl) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public boolean gestureRecognitionOn() throws TrackerException {
        return false;
    }

    @Override
    public boolean wirelessCapable() throws TrackerException {
        return false;
    }

    @Override
    public boolean videoCapable() throws TrackerException {
        return false;
    }

    @Override
    public boolean gesturesCapable() throws TrackerException {
        return false;
    }

    @Override
    public void searchUsingCamera() throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public boolean isQuickCompensationNoUICapable() throws TrackerException {
        return false;
    }

    @Override
    public boolean isAACNoUICapable() throws TrackerException {
        return false;
    }

    @Override
    public int smartWarmupWaitState() throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public boolean home(boolean bl, boolean bl2) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public int applicationPercentComplete(String string) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public void resetCameras() throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public void comboSearch(double d, double d2, double d3, double d4, double d5, boolean bl) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public void comboSearchInternal(double d, double d2, double d3) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public boolean didAACPassSinceInitialization() throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public boolean isNoUICompCalCapable() throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public int batteryChargeRemaining(int n) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public void factoryDisconnect(String string) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public int batteryState(int n) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public void changePowerButtonState(boolean bl) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public boolean powerButtonState() throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public void reboot() throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public boolean isFollowMeCapable() throws TrackerException {
        return false;
    }

    @Override
    public void changeFollowMeState(boolean bl) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public boolean isFollowMeOn() throws TrackerException {
        return false;
    }

    @Override
    public double getFollowMeSearchRadius() throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public void changeFollowMeSearchRadius(double d) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public boolean sixDofCapable() throws TrackerException {
        return false;
    }

    @Override
    public Probe[] availableProbes() throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public void addProbe(Probe probe) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public void removeProbe(Probe probe) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public void modifyProbe(Probe probe) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public void changeProbe(Probe probe, boolean bl) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public Probe probe() throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public String probeAdapter() throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public boolean probeAdapterConnected() throws TrackerException {
        return false;
    }

    @Override
    public ProbeCompensationData calcProbeCompensationParameters(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, double[] dArray6) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public ProbeCalibrationData calibrateProbeTip(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, double[] dArray6) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public ProbeCalibrationData calibrateISOProbeTip(double[] dArray, double[] dArray2, double[] dArray3) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public void updateProbeCompensationParameters(Probe probe, ProbeCompensationData probeCompensationData) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public void updateProbeCompensationParameters(Probe probe, double d, double d2, double d3) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public void updateProbeCompensationParameters(Probe probe, double d, double d2, double d3, double d4) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public boolean sixDofEnabled() throws TrackerException {
        return false;
    }

    @Override
    public void changeSixDofEnableState(boolean bl) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public int probeBatteryChargeRemaining() throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public void removeAllProbes() throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public void removeAllFactoryProbes() throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public double getDelayFromPassiveToActiveFollowMe() throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public void setDelayFromPassiveToActiveFollowMe(double d) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public int probeBatteryState() throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public boolean probeBatteryStateChangeEventSupported() throws TrackerException {
        return false;
    }

    @Override
    public boolean wirelessStateChangeSupported() throws TrackerException {
        return false;
    }

    @Override
    public void changeWirelessState(boolean bl) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public boolean wirelessOn() throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public boolean isCatEyeTargetCapable() throws TrackerException {
        return false;
    }

    @Override
    public boolean laserOn() throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public void changeLaserState(boolean bl) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public int connectionType() {
        int n = 0;
        if (this.isConnected()) {
            n = 1;
        }
        return n;
    }

    @Override
    public void setPort(PortUtility portUtility) {
    }

    public PortUtility getPortUtility() {
        return null;
    }

    @Override
    public int runAutomatedComp() throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public boolean homeRequired() throws TrackerException {
        return false;
    }

    @Override
    public boolean autoCompRequired() throws TrackerException {
        return false;
    }

    @Override
    public boolean autoReconnectCapable() throws TrackerException {
        return false;
    }

    @Override
    public boolean trackerBatteryEventCapable() throws TrackerException {
        return false;
    }

    @Override
    public boolean autoCompCapable() throws TrackerException {
        return false;
    }

    @Override
    public boolean sixProbe2Capable() {
        return false;
    }

    @Override
    public int probeModelType() throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public void removeCompFromProbeCompHistory(Probe probe, double d) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public void useCompFromProbeCompHistory(Probe probe, double d) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public ProbeCompHistoryData[] probeCompHistory(Probe probe) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public boolean probeCompHistoryCapable() throws TrackerException {
        return false;
    }

    private class AppRec {
        String appName;
        String fullyQualifiedName;
        TrackerApp app;

        AppRec(String string, String string2) {
            this.appName = string;
            this.fullyQualifiedName = string2;
            this.app = null;
        }

        void set(TrackerApp trackerApp) {
            this.app = trackerApp;
        }

        void clear() {
            this.app = null;
        }

        boolean isSet() {
            return null != this.app;
        }
    }

    public static class LaserState {
        public static final int OFF = 0;
        public static final int UNLOCKED = 1;
        public static final int LOCKED = 2;
        public static final int FAILURE = 3;
    }

    public static class MotorState {
        public static final int OFF = 0;
        public static final int ON = 1;
        public static final int FAILED = 2;
    }

    public static class ControlState {
        public static final int TRACKING_MODE = 0;
        public static final int MANUAL_MODE = 1;
    }

    public static class ShutterState {
        public static final int CLOSED = 0;
        public static final int OPEN = 1;
    }

    public static class TypeOfTarget {
        public static final int SMR_3_2 = 0;
        public static final int MIRROR = 1;
        public static final int SMR_1_2 = 2;
        public static final int SMR_7_8 = 3;
        public static final int SMR_USER = 4;
    }

    public static class TMRType {
        public static final int TMR_3_2 = 0;
        public static final int TMR_3_2_And_1_2 = 1;
    }

    public static class FBSightMode {
        public static final int FRONTSIGHT = 0;
        public static final int BACKSIGHT = 1;
    }

    public static class DatabaseIndex {
        public static final int NULL = 0;
        public static final int EXT_TEMP_1 = 28;
        public static final int AIR_TEMP_1 = 36;
        public static final int MATERIAL_TEMP_1 = 44;
    }

    public static class AlarmSelect {
        public static final short NONE = 0;
        public static final short DEVIATION = 1;
        public static final short HIGH = 2;
        public static final short LOW = 3;
    }

    public static class InputSelect {
        public static final short NO_SELECTION = 0;
        public static final short HARDWARE_INPUT = 1;
        public static final short MANUAL_INPUT = 2;
        public static final short DATABASE_POINT = 3;
    }

    public static class StatusBits {
        public static final int DATA_ERROR = 2;
        public static final int DATA_INACCURATE = 4;
        public static final int DATA_MANUAL = 8;
        public static final int DATA_DISABLED = 16;
        public static final int DATA_DEFAULT = 32;
    }
}

