/*
 * Decompiled with CFR 0.152.
 */
package smx.tracker;

import smx.ftp.CypherFtp;
import smx.tracker.Probe;
import smx.tracker.ProbeCompHistoryData;
import smx.tracker.ProbeCompensationData;
import smx.tracker.ProbeInfoParser;
import smx.tracker.ProbeKinematicParser;
import smx.tracker.Tracker;
import smx.tracker.TrackerException;
import smx.tracker.UnsupportedFeatureException;

public class ProbeManager {
    ProbeInfoParser parser = null;
    boolean smartProbeConnected = false;
    boolean factory = false;
    ProbeKinematicParser kinematicParser = null;
    String srNum = "";

    ProbeManager(CypherFtp cypherFtp, boolean bl) {
        this.parser = new ProbeInfoParser(cypherFtp);
        this.kinematicParser = new ProbeKinematicParser(cypherFtp);
        this.factory = bl;
    }

    protected Probe[] availableProbes(String string, int n) throws TrackerException {
        Probe[] probeArray = null;
        if (n == 2) {
            probeArray = this.kinematicParser.availableProbes();
        } else {
            Object[][] objectArray = this.parser.getProbes(this.smartProbeConnected);
            int n2 = objectArray.length;
            probeArray = new Probe[n2];
            for (int i = 0; i < n2; ++i) {
                Object[] objectArray2 = objectArray[i];
                probeArray[i] = this.createProbe(objectArray2);
            }
        }
        return probeArray;
    }

    protected Probe getActiveProbe(String string, int n) throws TrackerException {
        Probe probe = null;
        if (n == 2) {
            probe = this.kinematicParser.getActiveProbe();
        } else {
            Object[] objectArray = this.parser.getActiveProbe(this.smartProbeConnected, string);
            probe = this.createProbe(objectArray);
        }
        return probe;
    }

    protected void addProbe(Probe probe, String string, int n) throws TrackerException {
        this.checkIfAdapterExists(probe.getAdapterName(), string);
        if (n == 2) {
            throw new UnsupportedFeatureException("Cannot add probe for kinematic type probe");
        }
        this.parser.addProbe(probe.getName(), probe.getAdapterName(), probe.getDiameter(), -1.0, this.factory);
    }

    protected void removeProbe(Probe probe, int n) throws TrackerException {
        if (n == 2) {
            this.kinematicParser.removeProbe(probe);
        } else {
            this.parser.removeProbe(probe.getName(), probe.getAdapterName());
        }
    }

    protected void removeAllFactoryProbes(int n) throws TrackerException {
        if (n == 2) {
            this.kinematicParser.removeAllFactoryProbes();
        } else {
            this.parser.removeAllFactoryProbes();
        }
    }

    protected void modifyProbe(Probe probe, int n) throws TrackerException {
        if (n == 2) {
            this.kinematicParser.modifyProbe(probe);
        } else {
            String string = probe.getOriginalName();
            String string2 = probe.getName();
            String string3 = probe.getAdapterName();
            String string4 = probe.getOriginalAdapterName();
            double d = probe.getDiameter();
            double d2 = probe.getLength();
            boolean bl = probe.active();
            boolean bl2 = this.parser.modifyProbe(string2, string, string3, string4, d, d2);
            if (bl2) {
                if (!string2.equals(string)) {
                    probe.setOriginalName(string2);
                }
                if (!string3.equals(string4)) {
                    probe.setOriginalName(string4);
                }
            }
        }
    }

    private Probe createProbe(Object[] objectArray) {
        String string = (String)objectArray[0];
        String string2 = (String)objectArray[1];
        double d = (Double)objectArray[2];
        double d2 = (Double)objectArray[3];
        double d3 = (Double)objectArray[4];
        double d4 = (Double)objectArray[5];
        double d5 = (Double)objectArray[6];
        double d6 = (Double)objectArray[7];
        int n = (Integer)objectArray[8];
        int n2 = (Integer)objectArray[9];
        double d7 = (Double)objectArray[10];
        int n3 = (Integer)objectArray[11];
        int n4 = (Integer)objectArray[12];
        Probe probe = new Probe(string, string2, d, d2, d3, d4, d5, d6, n, n2, d7, n3, n4);
        return probe;
    }

    private void checkIfAdapterExists(String string, String string2) throws TrackerException {
        if (!string.equals(string2)) {
            throw new TrackerException(Tracker.res.getString("Probe_Adapter_Not_Supported"));
        }
    }

    protected void changeProbe(Probe probe, boolean bl, String string, int n) throws TrackerException {
        if (n == 2) {
            return;
        }
        String string2 = probe.getName();
        String string3 = probe.getAdapterName();
        if (!string.equals(string3)) {
            throw new TrackerException(Tracker.res.getString("Cannot_Change_Probe_State"));
        }
        this.parser.changeActiveProbe(string2, string3, bl);
        probe.setActive(bl);
    }

    protected void resetAllProbes() throws TrackerException {
        this.parser.resetAllProbes();
    }

    protected void removeAllProbes(int n) throws TrackerException {
        if (n == 2) {
            this.kinematicParser.removeAllProbes();
        } else {
            this.parser.removeAllProbes();
        }
    }

    protected void updateProbeCompensation(Probe probe, ProbeCompensationData probeCompensationData, int n) throws TrackerException {
        if (n == 2) {
            this.kinematicParser.updateProbeComp(probe, probeCompensationData.x(), probeCompensationData.y(), probeCompensationData.z(), probeCompensationData.errorStd(), probeCompensationData.temperature(), probeCompensationData.time());
            probe.setError(probeCompensationData.errorStd());
            probe.setErrorSupported(true);
        } else {
            this.parser.updateProbeCalibration(probe.getName(), probe.getAdapterName(), probeCompensationData.x(), probeCompensationData.y(), probeCompensationData.z(), probeCompensationData.temperature(), probeCompensationData.time(), true);
            probe.setError(-1.0);
            probe.setErrorSupported(false);
        }
        probe.setX(probeCompensationData.x());
        probe.setY(probeCompensationData.y());
        probe.setZ(probeCompensationData.z());
        probe.setTemp(probeCompensationData.temperature());
        probe.setDateOfCalibration(probeCompensationData.time());
        probe.setCompensated(true);
    }

    protected void updateProbeCompensation(Probe probe, double d, double d2, double d3, double d4, int n) throws TrackerException {
        this.updateProbeCompensation(probe, d, d2, d3, -1.0, d4, n);
    }

    protected void updateProbeCompensation(Probe probe, double d, double d2, double d3, double d4, double d5, int n) throws TrackerException {
        double d6 = System.currentTimeMillis() / 1000L;
        if (n == 2) {
            this.kinematicParser.updateProbeComp(probe, d, d2, d3, d4, d5, d6);
            probe.setErrorSupported(true);
        } else {
            this.parser.updateProbeCalibration(probe.getName(), probe.getAdapterName(), d, d2, d3, d5, d6, true);
            probe.setErrorSupported(false);
        }
        probe.setX(d);
        probe.setY(d2);
        probe.setZ(d3);
        probe.setTemp(d5);
        probe.setDateOfCalibration(d6);
        probe.setCompensated(true);
        probe.setError(d4);
    }

    protected void removeCompFromProbeCompHistory(Probe probe, double d, int n) throws TrackerException {
        if (n != 2) {
            throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported_For_6Probe_1_0"));
        }
        this.kinematicParser.removeProbeComp(probe, d);
    }

    protected void useCompFromProbeCompHistory(Probe probe, double d, int n) throws TrackerException {
        if (n != 2) {
            throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported_For_6Probe_1_0"));
        }
        this.kinematicParser.useProbeComp(probe, d);
    }

    protected double[] getCalibrationValues(Probe probe) throws TrackerException {
        double[] dArray = this.parser.getCalibrationValues(probe.getName(), probe.getAdapterName());
        return dArray;
    }

    protected ProbeCompHistoryData[] probeCompHistory(Probe probe, int n) throws TrackerException {
        if (n == 2) {
            return this.kinematicParser.probeCompHistory(probe);
        }
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported_For_6Probe_1_0"));
    }

    protected boolean probeCompHistoryAvailable(Probe probe, int n) throws TrackerException {
        if (n == 2) {
            return this.kinematicParser.probeCompHistoryAvailable(probe);
        }
        return false;
    }

    protected Probe createDummyProbe(Probe probe) throws TrackerException {
        return this.kinematicParser.createDummyProbe(probe);
    }

    protected void setAllProbesToInactive() throws TrackerException {
        this.kinematicParser.setAllProbesToInactive();
    }

    protected Probe getProbeBySerial(String string) throws TrackerException {
        return this.kinematicParser.getProbeBySerial(string);
    }

    protected Probe getProbeBySerialAndActive(String string) throws TrackerException {
        return this.kinematicParser.getProbeBySerialAndActive(string);
    }

    protected Probe getDummyProbe(String string, String string2) throws TrackerException {
        return this.kinematicParser.getDummyProbe(string, string2);
    }
}

