/*
 * Decompiled with CFR 0.152.
 */
package smx.tracker;

import java.io.IOException;
import java.util.ArrayList;
import smx.tracker.MeasureData;
import smx.tracker.MeasurePointData;
import smx.tracker.PrintException;
import smx.tracker.TrackerException;
import smx.tracker.TrackerInterface;
import smx.tracker.event.BkndMeasureDataEvent;
import smx.tracker.event.BkndMeasureDataListener;
import smx.tracker.event.EventListenerList;
import smx.tracker.event.FactoryBkndMeasureDataEvent;
import smx.tracker.event.FactoryBkndMeasureDataListener;
import smx.tracker.event.MeasureDataEvent;
import smx.tracker.event.MeasureDataListener;
import smx.utility.ThreadComm;

class MeasureThread
implements Runnable {
    public static final int GENERAL_MEASUREMENT = 0;
    public static final int POINT_MEASUREMENT = 1;
    private ThreadComm data;
    private Thread thread;
    private boolean shutdown = false;
    private TrackerInterface trackerIntf = null;
    private int numRecords;
    private int waitingRecords;
    private ArrayList tempHold;
    private boolean isBknd;
    private boolean isFactoryBknd;
    private int measurementType;
    private EventListenerList dataListenerList;
    private boolean eventsFrozen = false;
    private int[] threadExitLock = new int[1];
    private ThreadComm startStop = new ThreadComm();
    private final int TEMP_HOLD_SIZE = 50;
    private int[] threadSuspendLock = new int[1];
    private boolean stopMeasure = false;

    MeasureThread(TrackerInterface trackerInterface, boolean bl, boolean bl2, EventListenerList eventListenerList) {
        this.data = new ThreadComm(50);
        this.trackerIntf = trackerInterface;
        this.isBknd = bl;
        this.isFactoryBknd = bl2;
        this.waitingRecords = 0;
        this.dataListenerList = eventListenerList;
        this.tempHold = new ArrayList(50);
        this.threadExitLock[0] = 0;
        this.thread = new Thread((Runnable)this, "Measure Thread");
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public synchronized void freezeEvents() {
        this.eventsFrozen = true;
    }

    public synchronized void unfreezeEvents() {
        this.eventsFrozen = false;
        this.notify();
    }

    public synchronized void updateListeners(EventListenerList eventListenerList) {
        this.dataListenerList = eventListenerList;
    }

    private synchronized void fireMeasureData(int n) {
        if (this.eventsFrozen) {
            do {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (this.eventsFrozen);
        }
        MeasureDataEvent measureDataEvent = new MeasureDataEvent(this, n);
        Object[] objectArray = this.dataListenerList.getListenerList();
        int n2 = objectArray.length;
        for (int i = 0; i < n2; i += 2) {
            if (objectArray[i] != MeasureDataListener.class) continue;
            ((MeasureDataListener)objectArray[i + 1]).dataAvailable(measureDataEvent);
        }
    }

    private synchronized void fireBkndMeasureData(int n) {
        if (this.eventsFrozen) {
            do {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (this.eventsFrozen);
        }
        BkndMeasureDataEvent bkndMeasureDataEvent = new BkndMeasureDataEvent(this, n);
        Object[] objectArray = this.dataListenerList.getListenerList();
        int n2 = objectArray.length;
        for (int i = 0; i < n2; i += 2) {
            if (objectArray[i] != BkndMeasureDataListener.class) continue;
            ((BkndMeasureDataListener)objectArray[i + 1]).dataAvailable(bkndMeasureDataEvent);
        }
    }

    private synchronized void fireFactoryBkndMeasureData(int n) {
        if (this.eventsFrozen) {
            do {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (this.eventsFrozen);
        }
        FactoryBkndMeasureDataEvent factoryBkndMeasureDataEvent = new FactoryBkndMeasureDataEvent(this, n);
        Object[] objectArray = this.dataListenerList.getListenerList();
        int n2 = objectArray.length;
        for (int i = 0; i < n2; i += 2) {
            if (objectArray[i] != FactoryBkndMeasureDataListener.class) continue;
            ((FactoryBkndMeasureDataListener)objectArray[i + 1]).dataAvailable(factoryBkndMeasureDataEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        Object[] objectArray = null;
        try {
            while (!this.shutdown) {
                if (this.stopMeasure) {
                    this.suspendMeasurements();
                }
                this.startStop.browse();
                if (this.numRecords < 0) continue;
                try {
                    if (1 == this.measurementType) {
                        MeasurePointData[] measurePointDataArray = this.isBknd ? (this.isFactoryBknd ? this.trackerIntf.readFactoryBkndMeasurePointData(this.numRecords) : this.trackerIntf.readBkndMeasurePointData(this.numRecords)) : this.trackerIntf.readMeasurePointData(this.numRecords);
                        objectArray = measurePointDataArray;
                    } else {
                        MeasureData[] measureDataArray = this.isBknd ? (this.isFactoryBknd ? this.trackerIntf.readFactoryBkndMeasureData(this.numRecords) : this.trackerIntf.readBkndMeasureData(this.numRecords)) : this.trackerIntf.readMeasureData(this.numRecords);
                        objectArray = measureDataArray;
                    }
                }
                catch (TrackerException trackerException) {
                    continue;
                }
                this.data.send(objectArray);
                MeasureThread measureThread = this;
                synchronized (measureThread) {
                    this.waitingRecords += this.numRecords;
                }
                try {
                    if (this.isBknd) {
                        if (this.isFactoryBknd) {
                            this.fireFactoryBkndMeasureData(this.numRecords);
                            continue;
                        }
                        this.fireBkndMeasureData(this.numRecords);
                        continue;
                    }
                    this.fireMeasureData(this.numRecords);
                }
                catch (Exception exception) {
                    PrintException.print(exception);
                }
            }
            return;
        }
        catch (Exception exception) {
            PrintException.print(exception);
            return;
        }
        finally {
            this.releaseAllLocks();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseAllLocks() {
        int[] nArray = this.threadSuspendLock;
        synchronized (this.threadSuspendLock) {
            this.threadSuspendLock[0] = 1;
            this.threadSuspendLock.notify();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            nArray = this.threadExitLock;
            synchronized (this.threadExitLock) {
                this.threadExitLock[0] = 1;
                this.threadExitLock.notifyAll();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }
    }

    public boolean isBusy() {
        return this.startStop.isFull();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearOldData() {
        this.data.flush();
        this.tempHold.clear();
        MeasureThread measureThread = this;
        synchronized (measureThread) {
            this.waitingRecords = 0;
        }
    }

    public void startMeasurements(Object[] objectArray) {
        this.measurementType = (Integer)objectArray[0];
        this.numRecords = (Integer)objectArray[1];
        try {
            this.startStop.send(objectArray);
        }
        catch (IOException iOException) {
            PrintException.print(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopMeasurements() {
        this.stopMeasure = true;
        if (this.data.isFull()) {
            try {
                this.localReadData(1);
            }
            catch (IOException iOException) {
                System.err.println("Data exception while Command thread tried to remove data to free the Measure Thread");
            }
        }
        int[] nArray = this.threadSuspendLock;
        synchronized (this.threadSuspendLock) {
            try {
                if (this.threadSuspendLock[0] == 0) {
                    this.threadSuspendLock.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.threadSuspendLock[0] = 0;
            // ** MonitorExit[var1_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void suspendMeasurements() {
        try {
            this.startStop.receive();
        }
        catch (IOException iOException) {
            PrintException.print(iOException);
        }
        this.clearOldData();
        this.stopMeasure = false;
        int[] nArray = this.threadSuspendLock;
        synchronized (this.threadSuspendLock) {
            this.threadSuspendLock[0] = 1;
            this.threadSuspendLock.notify();
            // ** MonitorExit[var1_2] (shouldn't be in output)
            return;
        }
    }

    public int type() {
        return this.measurementType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] localReadData(int n) throws IOException {
        int n2;
        int n3 = 0;
        Object[] objectArray = null;
        Object[] objectArray2 = null;
        if (n <= 0) {
            return null;
        }
        n3 = Math.min(this.tempHold.size(), n);
        if (n3 > 0) {
            objectArray2 = 1 == this.measurementType ? new MeasurePointData[n] : new MeasureData[n];
            for (n2 = 0; n2 < n3; ++n2) {
            }
            objectArray2[n2] = this.tempHold.remove(0);
        }
        while (n3 < n) {
            objectArray = this.data.receive();
            int n4 = objectArray.length;
            if (n4 == n && 0 == n3) {
                objectArray2 = objectArray;
                break;
            }
            if (null == objectArray2) {
                objectArray2 = 1 == this.measurementType ? new MeasurePointData[n] : new MeasureData[n];
            }
            for (n2 = 0; n2 < n4; ++n2) {
                if (n3 < n) {
                    objectArray2[n3] = objectArray[n2];
                    ++n3;
                    continue;
                }
                this.tempHold.add(objectArray[n2]);
            }
        }
        MeasureThread measureThread = this;
        synchronized (measureThread) {
            this.waitingRecords -= n;
        }
        return objectArray2;
    }

    public MeasureData[] readData(int n) throws IOException {
        return (MeasureData[])this.localReadData(n);
    }

    public MeasurePointData[] readPointData(int n) throws IOException {
        return (MeasurePointData[])this.localReadData(n);
    }

    public void shutdown() {
        this.shutdown = true;
        Object[] objectArray = new Object[]{new Integer(-5), new Integer(-10)};
        try {
            this.startStop.send(objectArray);
        }
        catch (IOException iOException) {
            PrintException.print(iOException);
        }
        this.waitTillShutDown();
        this.startStop.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitTillShutDown() {
        int[] nArray = this.threadExitLock;
        synchronized (this.threadExitLock) {
            try {
                if (this.threadExitLock[0] == 0) {
                    this.threadExitLock.wait(10000L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return;
        }
    }

    public int recordsAvailable() {
        return this.waitingRecords;
    }
}

