/*
 * Decompiled with CFR 0.152.
 */
package smx.tracker.AppsKeystoneSim.SimulatorAPI;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import smx.tracker.AppsKeystoneSim.SimulatorAPI.Constants;
import smx.tracker.AppsKeystoneSim.SimulatorAPI.Nest;
import smx.tracker.AppsKeystoneSim.SimulatorAPI.SimuData;
import smx.tracker.AppsKeystoneSim.SimulatorAPI.Trackers;

public class TrackerDialog
extends JDialog
implements ActionListener {
    private LinkedList trackerList;
    private LinkedList nestList;
    private Trackers tracker;
    private double[] position;
    private double[] rotation;
    private JTextField nameIn;
    private JTextField IPaddressIn;
    private JTextField[] posIn;
    private JTextField[] rotIn;
    private JButton ok;
    private JButton cancel;
    private boolean okClick;
    private int flag;
    private int index;
    private int coordinate;
    private SimuData simuData;

    public TrackerDialog(JFrame jFrame, LinkedList linkedList, LinkedList linkedList2, int n, String string, int n2, int n3, SimuData simuData) {
        super(jFrame, string, true);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        this.setLocation(dimension.width / 2, dimension.height / 2);
        this.setSize(300, 220);
        this.setResizable(false);
        this.posIn = new JTextField[3];
        this.rotIn = new JTextField[3];
        this.trackerList = new LinkedList();
        Trackers trackers = new Trackers();
        Trackers trackers2 = new Trackers();
        for (int i = 0; i < linkedList.size(); ++i) {
            trackers = (Trackers)linkedList.get(i);
            trackers2 = (Trackers)trackers.clone();
            this.trackerList.add(i, trackers2);
        }
        this.nestList = new LinkedList();
        Nest nest = new Nest();
        Nest nest2 = new Nest();
        for (int i = 0; i < linkedList2.size(); ++i) {
            nest = (Nest)linkedList2.get(i);
            nest2 = (Nest)nest.clone();
            this.nestList.add(i, nest2);
        }
        this.flag = n2;
        this.index = n;
        this.coordinate = n3;
        this.okClick = false;
        this.simuData = simuData;
        if (this.flag == 0) {
            this.tracker = new Trackers();
            this.tracker.setIPAddress("128.128.128.100");
        } else {
            Trackers trackers3 = (Trackers)this.trackerList.get(this.index);
            this.tracker = (Trackers)trackers3.clone();
        }
        this.position = this.tracker.getPosition();
        this.rotation = this.tracker.getRotation();
        this.buildTrackerDialog();
    }

    public boolean isOKClicked() {
        return this.okClick;
    }

    public LinkedList showDialog() {
        this.show();
        return this.trackerList;
    }

    public LinkedList getNestList() {
        return this.nestList;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.ok) {
            Object object;
            int n;
            double[] dArray = new double[3];
            double[] dArray2 = new double[3];
            if (this.flag == 0) {
                if (this.nameIn.getText().equals("")) {
                    JOptionPane.showConfirmDialog(this, "Please provide a tracker name.", "Error", 2, 2);
                    return;
                }
                for (n = 0; n < this.trackerList.size(); ++n) {
                    Trackers trackers = (Trackers)this.trackerList.get(n);
                    if (!this.nameIn.getText().equals(trackers.getName())) continue;
                    JOptionPane.showConfirmDialog(this, "This tracker name already exist, please enter another name", "Error", 2, 0);
                    return;
                }
            }
            if (this.flag == 0 || this.flag == 3) {
                int n2;
                if (this.IPaddressIn.getText().equals("")) {
                    JOptionPane.showConfirmDialog(this, "Please provide an IP address", "Error", 2, 2);
                    return;
                }
                StringTokenizer stringTokenizer = new StringTokenizer(this.IPaddressIn.getText(), ".");
                if (stringTokenizer.countTokens() != 4) {
                    JOptionPane.showConfirmDialog(this, "This is an invalid IP address, please enter a valid IP address", "Error", 2, 0);
                    return;
                }
                for (n2 = 0; n2 < 4; ++n2) {
                    object = stringTokenizer.nextToken();
                    if (Integer.parseInt(((String)object).trim()) <= 255 && Integer.parseInt(((String)object).trim()) >= 0) continue;
                    JOptionPane.showConfirmDialog(this, "This is an invalid IP address, please enter a valid IP address", "Error", 2, 0);
                    return;
                }
                for (n2 = 0; n2 < this.trackerList.size(); ++n2) {
                    object = (Trackers)this.trackerList.get(n2);
                    if (!this.IPaddressIn.getText().equals(((Trackers)object).getIPAddress())) continue;
                    JOptionPane.showConfirmDialog(this, "This IP address already exist, please enter another IP address", "Error", 2, 0);
                    return;
                }
            }
            for (n = 0; n < 3; ++n) {
                if (this.posIn[n].getText().equals("") || this.rotIn[n].getText().equals("")) {
                    JOptionPane.showConfirmDialog(this, "Please provide tracker's complete position", "Error", 2, 0);
                    return;
                }
                dArray[n] = new Double(this.posIn[n].getText().trim());
                dArray2[n] = new Double(this.rotIn[n].getText().trim());
                if (this.flag != 2) continue;
                int n3 = n;
                dArray[n3] = dArray[n3] + this.position[n];
                int n4 = n;
                dArray2[n4] = dArray2[n4] + this.rotation[n];
            }
            if (this.flag != 3) {
                for (n = 0; n < this.trackerList.size(); ++n) {
                    Trackers trackers;
                    if (this.flag != 0) {
                        if (n == this.index) continue;
                        trackers = (Trackers)this.trackerList.get(n);
                    } else {
                        trackers = (Trackers)this.trackerList.get(n);
                    }
                    object = trackers.getPosition();
                    if (!(Math.sqrt(Math.pow(dArray[0] - object[0], 2.0) + Math.pow(dArray[1] - object[1], 2.0) + Math.pow(dArray[2] - object[2], 2.0)) <= 1.0)) continue;
                    JOptionPane.showConfirmDialog(this, "This tracker is too close to another tracker, please enter another position.", "Error", 2, 0);
                    return;
                }
                for (n = 0; n < this.nestList.size(); ++n) {
                    Nest nest = (Nest)this.nestList.get(n);
                    object = nest.getPosition();
                    Object object2 = new double[3];
                    object2 = this.coordinate == 1 ? this.simuData.sphere_to_cart((double)object[0], (double)object[1], (double)object[2]) : (Object)object;
                    if (!(Math.sqrt(Math.pow(dArray[0] - object2[0], 2.0) + Math.pow(dArray[1] - object2[1], 2.0) + Math.pow(dArray[2] - object2[2], 2.0)) <= 0.1)) continue;
                    JOptionPane.showConfirmDialog(this, "This tracker is too close to a nest, please enter another position.", "Error", 2, 0);
                    return;
                }
            }
            switch (this.flag) {
                case 0: {
                    this.tracker.setName(this.nameIn.getText());
                    this.tracker.setIPAddress(this.IPaddressIn.getText());
                    this.tracker.setAbsPosition(dArray, dArray2);
                    this.trackerList.add(this.tracker);
                    Nest nest = new Nest();
                    nest.setNestName("TMR_" + this.tracker.getName());
                    double[] dArray3 = Constants.TMR_LOCATION;
                    dArray3 = this.simuData.coordTransfer(dArray3, dArray, dArray2);
                    if (this.coordinate == 0) {
                        dArray3 = this.simuData.sphere_to_cart(dArray3[0], dArray3[1], dArray3[2]);
                    }
                    nest.setAbsPosition(dArray3);
                    this.nestList.addLast(nest);
                    break;
                }
                case 1: 
                case 2: {
                    this.tracker.setAbsPosition(dArray, dArray2);
                    this.trackerList.set(this.index, this.tracker);
                    break;
                }
                case 3: {
                    this.tracker.setIPAddress(this.IPaddressIn.getText());
                    this.trackerList.set(this.index, this.tracker);
                }
            }
            this.okClick = true;
        }
        this.dispose();
    }

    private void buildTrackerDialog() {
        int n;
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.right = 35;
        JLabel jLabel = new JLabel("Name");
        JLabel jLabel2 = new JLabel("IP Address");
        JLabel jLabel3 = new JLabel(this.tracker.getName());
        JLabel jLabel4 = new JLabel(this.tracker.getIPAddress());
        this.add(jLabel, gridBagConstraints, jPanel, 0, 0, 1, 1);
        this.add(jLabel2, gridBagConstraints, jPanel, 0, 1, 1, 1);
        switch (this.flag) {
            case 0: {
                this.nameIn = new JTextField(this.tracker.getName(), 10);
                this.IPaddressIn = new JTextField(this.tracker.getIPAddress(), 10);
                this.add(this.nameIn, gridBagConstraints, jPanel, 1, 0, 1, 1);
                this.add(this.IPaddressIn, gridBagConstraints, jPanel, 1, 1, 1, 1);
                break;
            }
            case 1: 
            case 2: {
                this.add(jLabel3, gridBagConstraints, jPanel, 1, 0, 1, 1);
                this.add(jLabel4, gridBagConstraints, jPanel, 1, 1, 1, 1);
                break;
            }
            case 3: {
                this.IPaddressIn = new JTextField(this.tracker.getIPAddress(), 10);
                this.add(jLabel3, gridBagConstraints, jPanel, 1, 0, 1, 1);
                this.add(this.IPaddressIn, gridBagConstraints, jPanel, 1, 1, 1, 1);
            }
        }
        gridBagConstraints.insets.left = 15;
        gridBagConstraints.insets.right = 5;
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets.top = 2;
        gridBagConstraints2.insets.bottom = 2;
        gridBagConstraints2.insets.left = 2;
        gridBagConstraints2.insets.right = 2;
        Border border = BorderFactory.createEtchedBorder();
        TitledBorder titledBorder = BorderFactory.createTitledBorder(border, "World Location");
        jPanel2.setBorder(titledBorder);
        JLabel jLabel5 = new JLabel("X");
        JLabel jLabel6 = new JLabel("Y");
        JLabel jLabel7 = new JLabel("Z");
        this.add(jLabel5, gridBagConstraints2, jPanel2, 0, 0, 1, 1);
        this.add(jLabel6, gridBagConstraints2, jPanel2, 0, 1, 1, 1);
        this.add(jLabel7, gridBagConstraints2, jPanel2, 0, 2, 1, 1);
        for (int i = 0; i < 3; ++i) {
            this.posIn[i] = this.flag == 2 ? new JTextField("0.0", 8) : new JTextField(new Double(this.position[i]).toString(), 8);
            this.add(this.posIn[i], gridBagConstraints2, jPanel2, 1, i, 1, 1);
        }
        this.add(jPanel2, gridBagConstraints2, jPanel, 0, 3, 1, 4);
        gridBagConstraints.insets.left = 15;
        gridBagConstraints.insets.right = 5;
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.insets.top = 2;
        gridBagConstraints3.insets.bottom = 2;
        gridBagConstraints3.insets.left = 2;
        gridBagConstraints3.insets.right = 2;
        TitledBorder titledBorder2 = BorderFactory.createTitledBorder(border, "Rotation");
        jPanel3.setBorder(titledBorder2);
        Box box = Box.createVerticalBox();
        JLabel jLabel8 = new JLabel("RX");
        JLabel jLabel9 = new JLabel("RY");
        JLabel jLabel10 = new JLabel("RZ");
        this.add(jLabel8, gridBagConstraints3, jPanel3, 0, 0, 1, 1);
        this.add(jLabel9, gridBagConstraints3, jPanel3, 0, 1, 1, 1);
        this.add(jLabel10, gridBagConstraints3, jPanel3, 0, 2, 1, 1);
        for (n = 0; n < 3; ++n) {
            this.rotIn[n] = this.flag == 2 ? new JTextField("0.0", 8) : new JTextField(new Double(this.rotation[n]).toString(), 8);
            this.add(this.rotIn[n], gridBagConstraints3, jPanel3, 1, n, 1, 1);
        }
        this.add(jPanel3, gridBagConstraints, jPanel, 1, 3, 1, 4);
        if (this.flag == 3) {
            for (n = 0; n < 3; ++n) {
                this.posIn[n].setEditable(false);
                this.rotIn[n].setEditable(false);
            }
        }
        gridBagConstraints.insets.top = 10;
        this.ok = new JButton("OK");
        this.cancel = new JButton("Cancel");
        this.ok.addActionListener(this);
        this.cancel.addActionListener(this);
        this.add(this.ok, gridBagConstraints, jPanel, 0, 8, 1, 1);
        this.add(this.cancel, gridBagConstraints, jPanel, 1, 8, 1, 1);
        this.getContentPane().add(jPanel);
    }

    public void add(Component component, GridBagConstraints gridBagConstraints, JPanel jPanel, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        jPanel.add(component, gridBagConstraints);
    }
}

