/*
 * Decompiled with CFR 0.152.
 */
package smx.tracker.AppsKeystoneSim.SimulatorAPI;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import smx.tracker.AppsKeystoneSim.SimulatorAPI.Noise;

public class GeneralDialog
extends JDialog
implements ActionListener {
    private Noise noise;
    private JButton ok;
    private JButton cancel;
    private JTextField angField;
    private JTextField radField;
    private JTextField traField;
    private JTextField temField;
    private boolean okClick;

    public GeneralDialog(JFrame jFrame, String string, Noise noise) {
        super(jFrame, string, true);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        this.setSize(350, 240);
        Dimension dimension = toolkit.getScreenSize();
        this.setLocation(dimension.width / 2, dimension.height / 2);
        this.setResizable(false);
        this.noise = (Noise)noise.clone();
        this.okClick = false;
        this.buildGDInterface();
    }

    public Noise showDialog() {
        this.show();
        return this.noise;
    }

    public boolean isOKClicked() {
        return this.okClick;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.ok) {
            if (this.angField.getText().equals("") || this.radField.getText().equals("") || this.traField.getText().equals("") || this.temField.getText().equals("")) {
                JOptionPane.showConfirmDialog(this, "Please provide complete set of noises", "Error", 2, 0);
                return;
            }
            double[] dArray = new double[]{new Double(this.angField.getText().trim()), new Double(this.radField.getText().trim()), new Double(this.traField.getText().trim()), new Double(this.temField.getText().trim())};
            this.noise.setNoise(dArray);
            this.okClick = true;
        }
        this.dispose();
    }

    private void buildGDInterface() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = new JLabel("Max. Angular Noise");
        JLabel jLabel2 = new JLabel("Max. Radial Noise");
        JLabel jLabel3 = new JLabel("Max. Transverse Noise");
        JLabel jLabel4 = new JLabel("Max. Temperature Noise");
        this.angField = new JTextField(new Double(this.noise.getNoise()[0]).toString(), 10);
        this.radField = new JTextField(new Double(this.noise.getNoise()[1]).toString(), 10);
        this.traField = new JTextField(new Double(this.noise.getNoise()[2]).toString(), 10);
        this.temField = new JTextField(new Double(this.noise.getNoise()[3]).toString(), 10);
        this.ok = new JButton("OK");
        this.cancel = new JButton("Cancel");
        this.ok.addActionListener(this);
        this.cancel.addActionListener(this);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.insets.top = 15;
        gridBagConstraints.insets.left = 20;
        gridBagConstraints.insets.right = 10;
        this.add(jLabel, gridBagConstraints, jPanel, 0, 0, 2, 1);
        this.add(jLabel2, gridBagConstraints, jPanel, 0, 1, 2, 1);
        this.add(jLabel3, gridBagConstraints, jPanel, 0, 2, 2, 1);
        this.add(jLabel4, gridBagConstraints, jPanel, 0, 3, 2, 1);
        this.add(this.angField, gridBagConstraints, jPanel, 2, 0, 1, 1);
        this.add(this.radField, gridBagConstraints, jPanel, 2, 1, 1, 1);
        this.add(this.traField, gridBagConstraints, jPanel, 2, 2, 1, 1);
        this.add(this.temField, gridBagConstraints, jPanel, 2, 3, 1, 1);
        gridBagConstraints.insets.left = 42;
        gridBagConstraints.insets.right = 42;
        gridBagConstraints.insets.bottom = 8;
        this.add(this.ok, gridBagConstraints, jPanel, 1, 4, 1, 1);
        this.add(this.cancel, gridBagConstraints, jPanel, 2, 4, 1, 1);
        this.getContentPane().add(jPanel);
    }

    private void add(Component component, GridBagConstraints gridBagConstraints, JPanel jPanel, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        jPanel.add(component, gridBagConstraints);
    }
}

