/*
 * Decompiled with CFR 0.152.
 */
package smx.utility;

import java.text.DecimalFormat;

public class UnitsConversion {
    private String name;
    private double scale;
    private double prescaleOffset;
    private double postscaleOffset;
    private int numDisplayDecimalPlaces;
    private DecimalFormat displayFormat;

    public UnitsConversion(String string, double d, double d2, double d3, int n) throws IllegalArgumentException {
        if (0 == string.length() || d <= 0.0 || n <= 0) {
            throw new IllegalArgumentException();
        }
        this.name = string;
        this.scale = d;
        this.prescaleOffset = d2;
        this.postscaleOffset = d3;
        this.numDisplayDecimalPlaces = n;
        this.displayFormat = new DecimalFormat();
        this.displayFormat.setMinimumFractionDigits(n);
        this.displayFormat.setMaximumFractionDigits(n);
        this.displayFormat.setGroupingSize(0);
    }

    public double convertTo(double d) {
        return (d + this.prescaleOffset) * this.scale + this.postscaleOffset;
    }

    public String convertToDisplayStr(double d) {
        double d2 = this.convertTo(d);
        return this.displayFormat.format(d2);
    }

    public double convertFrom(double d) {
        return (d - this.postscaleOffset) / this.scale - this.prescaleOffset;
    }

    public int displayDecimalPlaces() {
        return this.numDisplayDecimalPlaces;
    }

    public double displayPrescaleOffset() {
        return this.prescaleOffset;
    }

    public double displayPostscaleOffset() {
        return this.postscaleOffset;
    }

    public double displayScale() {
        return this.scale;
    }

    public String displayName() {
        return this.name;
    }

    public static int calculateDecimalPlaces(double d, int n, double d2) {
        double d3 = d2 / d;
        int n2 = n - (int)Math.round(Math.log(d3) / Math.log(10.0));
        return Math.max(1, n2);
    }
}

