/*
 * Decompiled with CFR 0.152.
 */
package smx.utility;

import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;

public class ThreadComm {
    private ArrayList buffer;
    private int size;

    public ThreadComm(int n) {
        this.buffer = new ArrayList(n);
        this.size = n;
    }

    public ThreadComm() {
        this(1);
    }

    private synchronized void send(Object[] objectArray, boolean bl, int n) throws IOException {
        while (null != this.buffer && this.buffer.size() == this.size) {
            try {
                long l = System.currentTimeMillis();
                if (bl) {
                    this.wait(n);
                    if ((n -= (int)(System.currentTimeMillis() - l)) > 0) continue;
                    break;
                }
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                throw new InterruptedIOException();
            }
        }
        if (null == this.buffer) {
            throw new EOFException();
        }
        if (bl && this.size == this.buffer.size()) {
            throw new IOException("send timed out");
        }
        this.buffer.add(objectArray);
        this.notifyAll();
    }

    public void send(Object[] objectArray, int n) throws IOException {
        this.send(objectArray, true, n);
    }

    public void send(Object[] objectArray) throws IOException {
        this.send(objectArray, false, 0);
    }

    private synchronized Object[] receive(boolean bl, int n, boolean bl2) throws IOException {
        while (null != this.buffer && 0 == this.buffer.size()) {
            try {
                long l = System.currentTimeMillis();
                if (bl) {
                    this.wait(n);
                    if ((n -= (int)(System.currentTimeMillis() - l)) > 0) continue;
                    break;
                }
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                throw new InterruptedIOException();
            }
        }
        if (null == this.buffer) {
            throw new EOFException();
        }
        if (bl && 0 == this.buffer.size()) {
            throw new IOException("receive timed out");
        }
        Object[] objectArray = bl2 ? (Object[])this.buffer.remove(0) : (Object[])this.buffer.get(0);
        this.notifyAll();
        return objectArray;
    }

    public Object[] receive(int n) throws IOException {
        return this.receive(true, n, true);
    }

    public Object[] receive() throws IOException {
        return this.receive(false, 0, true);
    }

    public Object[] browse() throws IOException {
        return this.receive(false, 0, false);
    }

    public synchronized void flush() {
        if (null != this.buffer) {
            this.buffer.clear();
        }
    }

    public synchronized boolean isFull() {
        return this.buffer.size() == this.size;
    }

    public synchronized boolean isEmpty() {
        return this.buffer.size() == 0;
    }

    public synchronized void close() {
        if (null != this.buffer) {
            this.buffer = null;
            this.notifyAll();
        }
    }
}

