/*
 * Decompiled with CFR 0.152.
 */
package smx.utility;

import java.io.DataOutput;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class LittleEndianOutputStream
extends FilterOutputStream
implements DataOutput {
    public LittleEndianOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    @Override
    public void writeShort(int n) throws IOException {
        OutputStream outputStream = this.out;
        int n2 = n & 0xFF;
        int n3 = (n & 0xFF00) >> 8;
        outputStream.write(n2);
        outputStream.write(n3);
    }

    @Override
    public void writeInt(int n) throws IOException {
        OutputStream outputStream = this.out;
        int n2 = n & 0xFF;
        int n3 = (n & 0xFF00) >> 8;
        int n4 = (n & 0xFF0000) >> 16;
        int n5 = (n & 0xFF000000) >> 24;
        outputStream.write(n2);
        outputStream.write(n3);
        outputStream.write(n4);
        outputStream.write(n5);
    }

    @Override
    public void writeLong(long l) throws IOException {
        OutputStream outputStream = this.out;
        int n = (int)l & 0xFF;
        int n2 = (int)(l >> 8) & 0xFF;
        int n3 = (int)(l >> 16) & 0xFF;
        int n4 = (int)(l >> 24) & 0xFF;
        int n5 = (int)(l >> 32) & 0xFF;
        int n6 = (int)(l >> 40) & 0xFF;
        int n7 = (int)(l >> 48) & 0xFF;
        int n8 = (int)(l >> 56) & 0xFF;
        outputStream.write(n);
        outputStream.write(n2);
        outputStream.write(n3);
        outputStream.write(n4);
        outputStream.write(n5);
        outputStream.write(n6);
        outputStream.write(n7);
        outputStream.write(n8);
    }

    @Override
    public void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    @Override
    public void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    @Override
    public void writeByte(int n) throws IOException {
        OutputStream outputStream = this.out;
        outputStream.write((byte)n);
    }

    @Override
    public void writeChar(int n) throws IOException {
        this.writeShort(n);
    }

    @Override
    public void writeUTF(String string) throws IOException {
    }

    @Override
    public void writeChars(String string) throws IOException {
    }

    @Override
    public void writeBytes(String string) throws IOException {
    }

    @Override
    public void writeBoolean(boolean bl) throws IOException {
        this.writeByte(bl ? 1 : 0);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        OutputStream outputStream = this.out;
        this.out.write(byArray, n, n2);
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        OutputStream outputStream = this.out;
        this.out.write(byArray);
    }

    @Override
    public void write(int n) throws IOException {
        this.writeByte(n);
    }
}

