/*
 * Decompiled with CFR 0.152.
 */
package smx.tracker.apps4xxx.utility;

import java.io.IOException;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TooManyListenersException;
import javax.swing.JFrame;
import smx.tracker.AbortedException;
import smx.tracker.AverageFilter;
import smx.tracker.ContinueTrigger;
import smx.tracker.DataTag;
import smx.tracker.DistanceMode;
import smx.tracker.Filter;
import smx.tracker.InterfaceBusyException;
import smx.tracker.MeasureCfg;
import smx.tracker.MeasureData;
import smx.tracker.MeasurePointData;
import smx.tracker.MirrorTargetType;
import smx.tracker.NullContinueTrigger;
import smx.tracker.NullFilter;
import smx.tracker.NullStartTrigger;
import smx.tracker.StartTrigger;
import smx.tracker.TargetType;
import smx.tracker.Tracker;
import smx.tracker.TrackerException;
import smx.tracker.apps4xxx.utility.ThreadListener;
import smx.tracker.apps4xxx.utility.TrackerAppException;
import smx.tracker.apps4xxx.utility.tools.debug.P;
import smx.tracker.event.BusyEvent;
import smx.tracker.event.BusyListener;
import smx.utility.ThreadComm;

public abstract class TrackerAppCommandThread {
    private ResourceBundle res = ResourceBundle.getBundle("smx.tracker.apps4xxx.utility.TrackerAppRes", Locale.getDefault());
    protected final int DEFAULT_SAMPLE_RATE = 2000;
    public static final int STOP_APP = -9;
    protected static final int NULL_COMMAND = 0;
    protected Tracker trk = null;
    protected ThreadComm command = new ThreadComm();
    protected ThreadComm response = new ThreadComm();
    protected boolean shutdown = false;
    protected ThreadListener listener = null;
    protected boolean hasExclusiveAccess = false;
    protected boolean bvalidInitialPt;
    protected double[] currentPosition = null;
    protected boolean abortCurrentCheckFlag = false;
    protected Object[] responseData;
    protected int commandCode = 0;
    protected boolean oldBlockSetting;
    protected DataTag[] stateTag;
    protected DataTag[] stateDataTags;
    protected boolean appIsSelfClosing;
    protected Thread thread;
    private Boolean currentTrackingState;
    private TargetType currentTargetType;
    private DistanceMode currentDistMode = null;
    private JFrame frame;
    private ThreadListener exitListener = null;
    private boolean displayAreUSureDialog = false;
    private ThreadListener shutterListener = null;
    private Object[] stateDataToBeRestored = null;
    private BusyListener busyListener;
    private String appName;

    public TrackerAppCommandThread(String string, Tracker tracker, ThreadListener threadListener, BusyListener busyListener, ThreadListener threadListener2, JFrame jFrame) {
        this.appName = string;
        this.trk = tracker;
        this.listener = threadListener;
        this.busyListener = busyListener;
        this.exitListener = threadListener2;
        this.frame = jFrame;
        this.trk.addBusyListener((BusyListener)new TrackerApp4xxxBusyListener());
    }

    public void sendCommand(Object[] objectArray) {
        try {
            this.response.flush();
            this.command.send(objectArray);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Object[] receiveResponse() {
        try {
            Object[] objectArray = this.response.receive();
            return objectArray;
        }
        catch (IOException iOException) {
            Object[] objectArray = null;
            return objectArray;
        }
    }

    public Object[] peekResponse() {
        try {
            Object[] objectArray = this.response.browse();
            return objectArray;
        }
        catch (IOException iOException) {
            Object[] objectArray = null;
            return objectArray;
        }
    }

    protected Object[] getStateInfo(DataTag[] dataTagArray) {
        Object[] objectArray;
        try {
            objectArray = this.trk.readOneTimeData(dataTagArray);
        }
        catch (TrackerException trackerException) {
            System.out.println("Exception in readonetimeData");
            objectArray = new Object[]{trackerException};
            trackerException.printStackTrace();
        }
        return objectArray;
    }

    protected void setExclusiveAccess() throws TrackerException {
        int n;
        if (this.hasExclusiveAccess) {
            return;
        }
        for (n = 0; n < 10; ++n) {
            try {
                this.trk.setExclusiveAccess();
                break;
            }
            catch (InterfaceBusyException interfaceBusyException) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        if (10 == n) {
            this.trk.setExclusiveAccess();
        }
        this.hasExclusiveAccess = true;
    }

    protected void clearExclusiveAccess() throws TrackerException {
        this.trk.clearExclusiveAccess();
        this.hasExclusiveAccess = false;
    }

    protected void handleException(Exception exception) {
        try {
            throw exception;
        }
        catch (TrackerAppException trackerAppException) {
            System.out.println("Got a Tracker App exception.");
            this.responseData[0] = trackerAppException;
        }
        catch (AbortedException abortedException) {
            this.responseData[0] = null;
            this.responseData[1] = null;
            this.responseData[2] = null;
            P.rintln("Command thread is quitting due to App closing in the middle of a test");
            try {
                this.shutDownThread();
            }
            catch (TrackerException trackerException) {
                this.responseData[0] = trackerException;
            }
        }
        catch (TrackerException trackerException) {
            this.responseData[0] = trackerException;
            System.out.println("Exception while executing the tracker command");
            trackerException.printStackTrace();
        }
        catch (IOException iOException) {
            this.responseData[0] = iOException;
            P.rintln("Got an IOException!");
            if (this.abortCurrentCheckFlag) {
                this.responseData[0] = null;
                this.responseData[1] = null;
                this.responseData[2] = null;
                P.rintln("The IOException occured becoz TrackerApp4xxx is aborted");
                try {
                    this.shutDownThread();
                }
                catch (TrackerException trackerException) {
                    this.responseData[0] = trackerException;
                }
            } else {
                iOException.printStackTrace();
            }
        }
        catch (Exception exception2) {
            exception2.printStackTrace();
            P.rintln("Got the base class Exception exception !@#$%^");
        }
    }

    protected void sendResponseToApp() {
        if (this.commandCode != -9) {
            try {
                this.checkAndAbort();
            }
            catch (AbortedException abortedException) {
                this.responseData[0] = null;
                this.responseData[1] = null;
                this.responseData[2] = null;
                P.rintln("Command thread is quitting due to TrackerApp closing at the end of a test");
                try {
                    this.shutDownThread();
                }
                catch (TrackerException trackerException) {
                    this.responseData[0] = trackerException;
                }
            }
        } else if (!this.shutdown) {
            try {
                this.shutDownThread();
            }
            catch (TrackerException trackerException) {
                // empty catch block
            }
        }
        if (!this.shutdown) {
            this.responseData[1] = this.getStateInfo(this.stateTag);
        }
        try {
            this.response.send(this.responseData);
            if (this.listener != null && !this.shutdown) {
                this.listener.commandComplete();
            }
        }
        catch (IOException iOException) {
            System.out.println("Got an exception while trying to fill response queue");
        }
    }

    private void doThreadCleanup() {
        try {
            this.command.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.exitListener != null) {
            this.exitListener.commandComplete();
        }
        P.rintln("Tracker App Command thread is SHUT DOWN !@#$");
    }

    public void addThreadListener(ThreadListener threadListener) throws TooManyListenersException {
        if (this.listener != null) {
            throw new TooManyListenersException();
        }
        this.listener = threadListener;
    }

    public void removeThreadListener(ThreadListener threadListener) {
        if (threadListener == this.listener) {
            this.listener = null;
        }
    }

    protected void stopAppActivities() throws TrackerException {
    }

    protected double[] getOneMeasurement(int n) throws TrackerException {
        double[] dArray = new double[4];
        this.trk.startMeasurePoint(new MeasureCfg(n, (Filter)new AverageFilter(), (StartTrigger)new NullStartTrigger(), (ContinueTrigger)new NullContinueTrigger()));
        MeasurePointData[] measurePointDataArray = this.trk.readMeasurePointData(1);
        this.trk.stopMeasurePoint();
        if (measurePointDataArray[0].status() != 0) {
            throw new TrackerAppException(this.res.getString("Measured_data_invalid"));
        }
        dArray[0] = measurePointDataArray[0].distance();
        dArray[1] = measurePointDataArray[0].azimuth();
        dArray[2] = measurePointDataArray[0].zenith();
        dArray[3] = measurePointDataArray[0].time();
        return dArray;
    }

    protected double[] getOneFactoryBkndMeasurement(int n) throws TrackerException {
        double[] dArray = new double[4];
        this.trk.setFactoryBkndMeasureBlocking(true);
        this.trk.startFactoryBkndMeasurePoint(new MeasureCfg(n, (Filter)new AverageFilter(), (StartTrigger)new NullStartTrigger(), (ContinueTrigger)new NullContinueTrigger()));
        MeasurePointData[] measurePointDataArray = this.trk.readFactoryBkndMeasurePointData(1);
        this.trk.stopFactoryBkndMeasurePoint();
        if (measurePointDataArray[0].status() != 0) {
            throw new TrackerAppException(this.res.getString("Measured_data_invalid"));
        }
        dArray[0] = measurePointDataArray[0].distance();
        dArray[1] = measurePointDataArray[0].azimuth();
        dArray[2] = measurePointDataArray[0].zenith();
        dArray[3] = measurePointDataArray[0].time();
        return dArray;
    }

    protected Object[] measureOneTimeFactoryBkndData(DataTag[] dataTagArray, int n) throws TrackerException {
        MeasureData measureData;
        boolean bl = this.trk.getFactoryBkndMeasureBlocking();
        this.trk.setFactoryBkndMeasureBlocking(true);
        this.trk.startFactoryBkndMeasure(new MeasureCfg(n, (Filter)new NullFilter(), (StartTrigger)new NullStartTrigger(), (ContinueTrigger)new NullContinueTrigger()), dataTagArray);
        MeasureData[] measureDataArray = this.trk.readFactoryBkndMeasureData(1);
        this.trk.stopFactoryBkndMeasure();
        this.trk.setFactoryBkndMeasureBlocking(bl);
        MeasureData measureData2 = measureData = measureDataArray != null ? measureDataArray[0] : null;
        if (measureData == null) {
            throw new TrackerAppException(this.res.getString("Measured_data_invalid"));
        }
        Object[] objectArray = measureData.getData();
        return objectArray;
    }

    Object[] measureOneTimeData(DataTag[] dataTagArray, int n) throws TrackerException {
        MeasureData measureData;
        this.trk.startMeasure(new MeasureCfg(n, (Filter)new NullFilter(), (StartTrigger)new NullStartTrigger(), (ContinueTrigger)new NullContinueTrigger()), dataTagArray);
        MeasureData[] measureDataArray = this.trk.readMeasureData(1);
        this.trk.stopMeasure();
        MeasureData measureData2 = measureData = measureDataArray != null ? measureDataArray[0] : null;
        if (measureData == null) {
            throw new TrackerAppException(this.res.getString("Measured_data_invalid"));
        }
        Object[] objectArray = measureData.getData();
        return objectArray;
    }

    protected Object[] readOneTimeData(DataTag[] dataTagArray) throws TrackerException {
        return this.trk.readOneTimeData(dataTagArray);
    }

    protected void writeOneTimeData(DataTag[] dataTagArray, Object[] objectArray) throws TrackerException {
        this.trk.writeOneTimeData(dataTagArray, objectArray);
    }

    protected final void aimToBackMirror() throws TrackerException {
        Object var1_1 = null;
        TargetType targetType = null;
        targetType = this.trk.targetType();
        this.trk.changeTargetType((TargetType)new MirrorTargetType());
        this.currentTargetType = targetType;
        this.trk.command("moveto zero", 10000);
        this.trk.search(0.02);
    }

    protected final void restoreTargetType() throws TrackerException {
        if (this.currentTargetType != null) {
            this.trk.changeTargetType(this.currentTargetType);
            this.currentTargetType = null;
        }
    }

    protected void getCurrentPosition() throws TrackerException {
        this.bvalidInitialPt = true;
        try {
            this.currentPosition = this.getOneMeasurement(2000);
        }
        catch (TrackerAppException trackerAppException) {
            this.bvalidInitialPt = false;
        }
    }

    protected void restoreOriginalPosition() throws TrackerException {
        if (this.bvalidInitialPt) {
            this.trk.move(this.currentPosition[1], this.currentPosition[2], this.currentPosition[0], false);
        }
    }

    void abortCurrentCheck(boolean bl) {
        this.appIsSelfClosing = bl;
        this.abortCurrentCheckFlag = true;
        this.command.close();
        this.displayAreUSureDialog = bl;
        this.trk.abort();
    }

    protected final void checkAndAbort() throws AbortedException {
        if (this.abortCurrentCheckFlag) {
            P.rintln("Throwing the aborted exception!");
            throw new AbortedException();
        }
    }

    protected final void listenForBusyEvents() {
        if (this.busyListener != null) {
            this.trk.addBusyListener(this.busyListener);
        }
    }

    protected final void ignoreBusyEvents() {
        if (this.busyListener != null) {
            this.trk.removeBusyListener(this.busyListener);
        }
    }

    protected final void storeCurrentTrackerState() throws TrackerException {
        this.currentDistMode = this.trk.distanceMeasureMode();
        P.rintln("Current distance mode stored");
        this.currentTrackingState = new Boolean(this.trk.trackingOn());
        this.currentTargetType = this.trk.targetType();
        if (this.stateDataTags != null) {
            this.stateDataToBeRestored = this.trk.readOneTimeData(this.stateDataTags);
            P.rintln("Noted the initial tracker state");
        }
    }

    private final void restoreOldTrackerStateAndLeaveExclusiveAccess() throws TrackerException {
        this.restoreOldTrackerState();
        this.clearExclusiveAccess();
        P.rintln("Released ExclusiveAccess.");
    }

    protected final void restoreOldTrackerState() {
        try {
            if (this.currentDistMode != null) {
                this.trk.changeDistanceMeasureMode(this.currentDistMode);
                P.rintln("Distance mode reset");
            }
            if (this.currentTrackingState != null) {
                this.trk.changeTrackingState(this.currentTrackingState.booleanValue());
            }
            P.rintln("Tracking state reset");
            if (this.currentTargetType != null) {
                this.trk.changeTargetType(this.currentTargetType);
            }
            P.rintln("Target type reset");
            if (this.stateDataTags != null && this.stateDataToBeRestored != null) {
                this.trk.writeOneTimeData(this.stateDataTags, this.stateDataToBeRestored);
            }
            P.rintln("Tracker state restored.");
        }
        catch (TrackerException trackerException) {
            trackerException.printStackTrace();
        }
    }

    private void shutDownThread() throws TrackerException {
        if (this.shutdown) {
            return;
        }
        try {
            this.shutdown = true;
            this.restoreOldTrackerStateAndLeaveExclusiveAccess();
            if (this.displayAreUSureDialog || this.abortCurrentCheckFlag) {
                this.abortCurrentCheckFlag = false;
                this.displayAreUSureDialog = false;
            }
            this.stopAppActivities();
            if (this.appIsSelfClosing) {
                this.trk.stopApplication(this.appName);
            }
            this.trk.setBlocking(this.oldBlockSetting);
            Object var2_1 = null;
            this.doThreadCleanup();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.doThreadCleanup();
            throw throwable;
        }
    }

    protected final JFrame frame() {
        return this.frame;
    }

    static {
        STOP_APP = -9;
        NULL_COMMAND = 0;
    }

    class TrackerApp4xxxBusyListener
    implements BusyListener {
        TrackerApp4xxxBusyListener() {
        }

        public void stateChanged(BusyEvent busyEvent) {
            if (!busyEvent.getCommandState()) {
                P.rintln("Well the tracker finally is NOT BUSY");
                TrackerAppCommandThread.this.trk.removeBusyListener((BusyListener)this);
                TrackerAppCommandThread.this.thread.start();
            }
        }
    }
}

