/*
 * Decompiled with CFR 0.152.
 */
package smx.tracker.apps4xxx.utility;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.image.ImageProducer;
import java.io.IOException;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TooManyListenersException;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import smx.tracker.Tracker;
import smx.tracker.TrackerApp;
import smx.tracker.TrackerException;
import smx.tracker.apps4xxx.PleaseWait;
import smx.tracker.apps4xxx.utility.ThreadListener;
import smx.tracker.apps4xxx.utility.TrackerAppCommandThread;
import smx.tracker.apps4xxx.utility.TrackerExceptionString;
import smx.tracker.apps4xxx.utility.tools.Assert;
import smx.tracker.apps4xxx.utility.tools.P;
import smx.tracker.event.BusyEvent;
import smx.tracker.event.BusyListener;
import smx.tracker.event.ConnectEvent;
import smx.tracker.event.ConnectListener;
import smx.utility.ThreadComm;
import smx.utility.UnitsConversion;

public abstract class TrackerApp4xxx
extends TrackerApp {
    protected TrackerAppBusyListener trackerAppBusyListener = new TrackerAppBusyListener(false);
    private ConnectListener connectListener = new ConnectListener(){

        public void connectionChanged(ConnectEvent connectEvent) {
            TrackerApp4xxx.this.onConnectionChanged(connectEvent);
        }
    };
    protected CommandThreadExitListener commandThreadExitListener = new CommandThreadExitListener();
    public static final int LINEAR_UNIT = 1;
    public static final int ANGULAR_UNIT = 2;
    public static final int TEMPERATURE_UNIT = 3;
    public static final int PRESSURE_UNIT = 4;
    protected TrackerAppCommandThread commandThread = null;
    protected JFrame frame;
    protected int currentCmdId = -1;
    public UnitsConversion localLinearUnits;
    public UnitsConversion localAngularUnits;
    public UnitsConversion localTemperatureUnits;
    public UnitsConversion localPressureUnits;
    boolean appCommandInProgress = false;
    private ResourceBundle res = ResourceBundle.getBundle("smx.tracker.apps4xxx.utility.TrackerAppRes", Locale.getDefault());
    protected ThreadCreationComplete threadCreationComplete = new ThreadCreationComplete();
    protected DecimalFormat posForm = new DecimalFormat();
    private boolean busy = false;
    private PleaseWait pleaseWaitDialog = null;
    private ThreadCmdFinish threadFinish = new ThreadCmdFinish();
    private String outputFileName;
    private boolean appIsStable = false;
    private boolean appCloseButtonClicked = false;
    private ThreadComm commandThreadExitResponse = new ThreadComm();
    private ThreadComm trackerAppExitResponse = new ThreadComm();
    private boolean showErrorDialog = true;
    private Component rootComponent;
    static Class class$smx$tracker$TrackerException;

    public abstract void launchApp();

    public abstract void setBusyStateToApp(boolean var1);

    public abstract void setBusy(boolean var1);

    public TrackerApp4xxx(String string, Tracker tracker, JFrame jFrame) {
        super(string, tracker, jFrame);
        this.localLinearUnits = this.lengthUnits;
        this.localAngularUnits = this.angularUnits;
        this.localTemperatureUnits = this.temperatureUnits;
        this.localPressureUnits = this.pressureUnits;
        this.posForm.setMinimumFractionDigits(1);
        this.posForm.setMaximumFractionDigits(1);
        this.posForm.setGroupingSize(0);
        this.frame = jFrame;
        try {
            this.trackerAppInit();
            this.frame.setCursor(Cursor.getPredefinedCursor(3));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private synchronized void signalAppStable() {
        if (!this.appIsStable) {
            this.appIsStable = true;
            ((Object)((Object)this)).notifyAll();
        }
    }

    public synchronized void waitUntilStable() {
        try {
            while (!this.appIsStable) {
                ((Object)((Object)this)).wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected final void showFatalErrorAndCloseApp(String string) {
        JOptionPane.showMessageDialog(this.frame, String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append("\n").append(this.res.getString("Closing_the_app")))), this.res.getString("Failed_to_run_app"), 0);
        this.onClose(new ActionEvent(new Object(), 1001, ""));
    }

    public void onClose(ActionEvent actionEvent) {
        if (this.commandThread == null) {
            P.rintln("\n\nCOMMAND THREAD IS --------------  N U L L ------------");
            P.rintln("\n\n");
            return;
        }
        if (actionEvent != null) {
            this.appCloseButtonClicked = true;
            P.rintln("Close button hit");
        }
        if (!this.isOKToCloseApp()) {
            P.rintln("Sending abort message to tracker app command thread");
            if (this.appCloseButtonClicked && JOptionPane.showConfirmDialog(this.frame, this.res.getString("Abort_App"), this.res.getString("Are_u_sure"), 0) == 0 || !this.appCloseButtonClicked) {
                this.commandThread.abortCurrentCheck(this.appCloseButtonClicked);
                this.waitForHealthChecksThreadToExit();
            } else if (actionEvent != null) {
                this.appCloseButtonClicked = false;
                P.rintln("Undid the Close button hit");
            }
        } else {
            this.closeTrackerApp();
        }
    }

    private void trackerAppInit() throws TrackerException {
        try {
            if (this.trk != null) {
                this.trk.addConnectListener(this.connectListener);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void onConnectionChanged(ConnectEvent connectEvent) {
    }

    private void onThreadCmdComplete(Object[] objectArray) {
        boolean bl = false;
        try {
            try {
                this.restoreTheCursor();
                this.disposePleaseWaitDialog();
                if (this.showErrorDialog && objectArray[0] != null && (class$smx$tracker$TrackerException == null ? (class$smx$tracker$TrackerException = TrackerApp4xxx.class$("smx.tracker.TrackerException")) : class$smx$tracker$TrackerException).isInstance(objectArray[0])) {
                    TrackerExceptionString.displayErrorToUser((Component)((Object)this), (TrackerException)((Object)objectArray[0]), null, null);
                }
                Object[] objectArray2 = (Object[])objectArray[1];
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Object var6_5 = null;
                this.busy = false;
                this.setBusy(false);
            }
            Object var6_4 = null;
            this.busy = false;
            this.setBusy(false);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.busy = false;
            this.setBusy(false);
            throw throwable;
        }
    }

    public void stop() {
        if (!this.appCloseButtonClicked) {
            this.onClose(null);
        }
        this.pleaseWaitDialog = null;
        this.threadCreationComplete = null;
        this.threadFinish = null;
        this.commandThread = null;
        this.trk.removeConnectListener(this.connectListener);
        P.rintln("\t\tCalling stop");
        super.stop();
        this.restoreTheCursor();
    }

    public void startPleaseWaitDialog(String string, int n) {
        if (string.equals("")) {
            return;
        }
        this.pleaseWaitDialog = new PleaseWait((Frame)this.frame, string, this.trk, true);
    }

    public void disposePleaseWaitDialog() {
        if (this.pleaseWaitDialog != null) {
            this.pleaseWaitDialog.dispose();
            this.pleaseWaitDialog = null;
        }
    }

    public void setCommandInProgress(boolean bl) {
        this.appCommandInProgress = bl;
    }

    public boolean doThreadTransaction(Object[] objectArray, String string, ThreadListener threadListener, boolean bl, int n) {
        if (this.currentCmdId == -9 || this.commandThread == null) {
            return false;
        }
        this.threadFinish.setThreadListener(threadListener);
        try {
            this.commandThread.addThreadListener(this.threadFinish);
        }
        catch (TooManyListenersException tooManyListenersException) {
            tooManyListenersException.printStackTrace();
            Assert.isTrue(false, "TooManyListeners exception fired in doThreadTransaction");
            boolean bl2 = false;
            return bl2;
        }
        this.commandThread.ignoreBusyEvents();
        this.trackerAppBusyListener.clearBusyEventList();
        this.currentCmdId = (Integer)objectArray[0];
        this.busy = true;
        this.setBusy(true);
        this.startPleaseWaitDialog(string, n);
        this.commandThread.sendCommand(objectArray);
        this.setTheWaitCursor();
        if (bl) {
            this.commandThread.peekResponse();
        }
        return true;
    }

    public boolean doThreadTransaction(Object[] objectArray, String string, ThreadListener threadListener) {
        return this.doThreadTransaction(objectArray, string, threadListener, false, 1000);
    }

    public boolean doThreadTransaction(Object[] objectArray, String string, ThreadListener threadListener, boolean bl) {
        return this.doThreadTransaction(objectArray, string, threadListener, bl, 1000);
    }

    void closeTrackerApp() {
        if (this.appCloseButtonClicked) {
            P.rintln("closeTrackerApp called properly");
        } else {
            P.rintln("closeTrackerApp called improperly");
        }
        Object[] objectArray = new Object[2];
        objectArray[0] = new Integer(-9);
        objectArray[1] = new Boolean(this.appCloseButtonClicked);
        this.doThreadTransaction(objectArray, "", null);
        this.waitForHealthChecksThreadToExit();
    }

    public Image loadImage(String string, String string2) {
        try {
            URL uRL = ((Object)((Object)this)).getClass().getResource(String.valueOf(String.valueOf(string2)).concat(String.valueOf(String.valueOf(string))));
            Image image = ((Component)((Object)this)).createImage((ImageProducer)uRL.getContent());
            return image;
        }
        catch (Exception exception) {
            Image image = null;
            return image;
        }
    }

    private void waitForHealthChecksThreadToExit() {
        try {
            P.rintln("Thread to be waiting for thread to exit is : ".concat(String.valueOf(String.valueOf(Thread.currentThread().getName()))));
            this.trackerAppExitResponse.receive();
            P.rintln("Thread released from waiting is : ".concat(String.valueOf(String.valueOf(Thread.currentThread().getName()))));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public String getStatusString(int n) {
        if ((n & 2) != 0) {
            return this.res.getString("Error");
        }
        if ((n & 4) != 0) {
            return this.res.getString("Invalid");
        }
        if ((n & 8) != 0) {
            return this.res.getString("Manual");
        }
        if ((n & 0x20) != 0) {
            return this.res.getString("Default");
        }
        if (n == 0) {
            return this.res.getString("Valid");
        }
        return this.res.getString("Unknown");
    }

    protected Component getAppRootComponent() {
        return null;
    }

    private void setTheWaitCursor() {
        if (this.rootComponent != null) {
            this.rootComponent.setCursor(Cursor.getPredefinedCursor(3));
        }
    }

    private void restoreTheCursor() {
        if (this.rootComponent != null) {
            this.rootComponent.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    protected boolean isOKToCloseApp() {
        return !this.busy;
    }

    void wakeUpThreadWaitingForExitResponse() {
        try {
            this.trackerAppExitResponse.send(new Object[]{new Integer(1)});
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public boolean isBusy() {
        return this.busy;
    }

    protected final void enableErrorDialogDisplay(boolean bl) {
        this.showErrorDialog = bl;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        LINEAR_UNIT = 1;
        ANGULAR_UNIT = 2;
        TEMPERATURE_UNIT = 3;
        PRESSURE_UNIT = 4;
    }

    private class CommandThreadExitListener
    implements ThreadListener {
        private CommandThreadExitListener() {
        }

        public void commandComplete() {
            TrackerApp4xxx.this.wakeUpThreadWaitingForExitResponse();
        }
    }

    private class ThreadCreationComplete
    implements ThreadListener,
    Runnable {
        private ThreadCreationComplete() {
        }

        public void commandComplete() {
            TrackerApp4xxx.this.commandThread.removeThreadListener(this);
            TrackerApp4xxx.this.signalAppStable();
            P.rintln("App is signaled to be stable");
            SwingUtilities.invokeLater(this);
        }

        public void run() {
            TrackerApp4xxx.this.frame.setCursor(Cursor.getPredefinedCursor(0));
            TrackerApp4xxx.this.rootComponent = TrackerApp4xxx.this.getAppRootComponent();
            TrackerApp4xxx.this.launchApp();
        }
    }

    private class ThreadCmdFinish
    implements ThreadListener,
    Runnable {
        private ThreadListener listener;
        private boolean cmdInProgress = false;
        private ArrayList responseData = new ArrayList();

        private ThreadCmdFinish() {
        }

        public void commandComplete() {
            Object[] objectArray = TrackerApp4xxx.this.commandThread.peekResponse();
            this.responseData.add(objectArray);
            if (this.listener != null) {
                this.listener.commandComplete();
            }
            TrackerApp4xxx.this.commandThread.removeThreadListener(this);
            TrackerApp4xxx.this.commandThread.listenForBusyEvents();
            ThreadCmdFinish threadCmdFinish = this;
            synchronized (threadCmdFinish) {
                Assert.isTrue(this.cmdInProgress, "cmdComplete is called without a prior call to doThreadTransac");
                if (this.cmdInProgress) {
                    this.cmdInProgress = false;
                    this.listener = null;
                    this.notifyAll();
                }
            }
            SwingUtilities.invokeLater(this);
        }

        public void run() {
            if (this.responseData.isEmpty()) {
                return;
            }
            TrackerApp4xxx.this.onThreadCmdComplete((Object[])this.responseData.remove(0));
        }

        public void setThreadListener(ThreadListener threadListener) {
            ThreadCmdFinish threadCmdFinish = this;
            synchronized (threadCmdFinish) {
                while (this.cmdInProgress) {
                    P.rintln(String.valueOf(String.valueOf(Thread.currentThread().getName())).concat(" : is submitting a command too soon!@#"));
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                this.cmdInProgress = true;
                this.listener = threadListener;
            }
        }

        public void addResponseData(Object[] objectArray) {
            this.responseData.add(objectArray);
        }
    }

    protected class TrackerAppBusyListener
    implements BusyListener,
    Runnable {
        private ArrayList eventList = new ArrayList();
        private boolean bkndTrigger = true;
        private boolean measureTrigger = true;

        public TrackerAppBusyListener(boolean bl) {
            this.bkndTrigger = bl;
        }

        public TrackerAppBusyListener() {
            this(true);
        }

        public void stateChanged(BusyEvent busyEvent) {
            if (TrackerApp4xxx.this.busy) {
                P.rintln("\t\nIgnoring the busy listener event since app is busy\n\n");
                return;
            }
            this.eventList.add(busyEvent);
            SwingUtilities.invokeLater(this);
        }

        public synchronized void clearBusyEventList() {
            this.eventList.clear();
        }

        public synchronized void run() {
            BusyEvent busyEvent = (BusyEvent)this.eventList.remove(0);
            if (busyEvent == null) {
                return;
            }
            boolean bl = busyEvent.getBkndMeasureState();
            boolean bl2 = busyEvent.getCommandState();
            boolean bl3 = busyEvent.getMeasureState();
            boolean bl4 = bl2;
            if (this.bkndTrigger) {
                boolean bl5 = bl4 = bl4 || bl;
            }
            if (this.measureTrigger) {
                bl4 = bl4 || bl3;
            }
            TrackerApp4xxx.this.setBusyStateToApp(bl4);
        }
    }
}

