/*
 * Decompiled with CFR 0.152.
 */
package smx.tracker.apps4xxx.utility;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.util.StringTokenizer;
import javax.swing.JList;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import smx.tracker.apps4xxx.utility.IconTabData;

public class IconTabListCellRenderer
extends JTextArea
implements ListCellRenderer {
    protected static Border m_noFocusBorder;
    protected Insets m_insets = new Insets(0, 0, 0, 0);
    protected int m_defaultTab = 65;
    protected int[] m_tabs = null;

    public IconTabListCellRenderer() {
        m_noFocusBorder = new EmptyBorder(1, 1, 1, 1);
        this.setOpaque(false);
        this.setBorder(m_noFocusBorder);
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        Object object2;
        if (n == 0) {
            this.setBackground(jList.getBackground());
            this.setForeground(Color.red);
            object2 = jList.getFont();
            Font font = ((Font)object2).deriveFont(1);
            this.setFont(font);
            this.setBorder(m_noFocusBorder);
        } else {
            this.setBackground(jList.getBackground());
            this.setForeground(jList.getForeground());
            this.setFont(jList.getFont());
            this.setBorder(bl2 ? UIManager.getBorder("List.focusCellHighlightBorder") : m_noFocusBorder);
        }
        if (object instanceof IconTabData) {
            object2 = (IconTabData)object;
            this.setText(((IconTabData)object2).toString());
        }
        return this;
    }

    protected String getUntabbedText(FontMetrics fontMetrics, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
        String string2 = new String();
        int n = fontMetrics.stringWidth(" ");
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            string2 = string2.concat(string3);
            n2 += fontMetrics.stringWidth(string3);
            int n3 = 0;
            while (n2 >= this.getTab(n3)) {
                ++n3;
            }
            n2 = this.getTab(n3);
            if (!stringTokenizer.hasMoreTokens()) break;
            string2 = this.concatString(string2, " ", (n2 - fontMetrics.stringWidth(string2)) / n);
        }
        return string2;
    }

    public void setDefaultTab(int n) {
        this.m_defaultTab = n;
    }

    public int getDefaultTab() {
        return this.m_defaultTab;
    }

    public void setTabs(int[] nArray) {
        this.m_tabs = nArray;
    }

    public int[] getTabs() {
        return this.m_tabs;
    }

    public int getTab(int n) {
        if (this.m_tabs == null) {
            return this.m_defaultTab * n;
        }
        int n2 = this.m_tabs.length;
        if (n >= 0 && n < n2) {
            return this.m_tabs[n];
        }
        return this.m_tabs[n2 - 1] + this.m_defaultTab * (n - n2 + 1);
    }

    String concatString(String string, String string2, int n) {
        for (int i = 0; i < n; ++i) {
            string = string.concat(string2);
        }
        return string;
    }
}

