/*
 * Decompiled with CFR 0.152.
 */
package smx.tracker.apps4xxx.trackerpad;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import smx.tracker.AirExtTemp;
import smx.tracker.AlarmType;
import smx.tracker.DeviationAlarm;
import smx.tracker.ExtTempType;
import smx.tracker.HighAlarm;
import smx.tracker.LowAlarm;
import smx.tracker.MaterialExtTemp;
import smx.tracker.NullAlarm;
import smx.tracker.NullExtTemp;
import smx.tracker.apps4xxx.trackerpad.TrackerPad;

public class TempCfg
extends JDialog {
    Object[] workingData;
    JPanel panel1 = new JPanel();
    JPanel hardwarePanel = new JPanel();
    JScrollPane jScrollPane1 = new JScrollPane();
    GridLayout gridLayout3 = new GridLayout();
    Border border1;
    TitledBorder titledBorder1;
    Border border2;
    TitledBorder titledBorder2;
    Border border3;
    TitledBorder titledBorder3;
    Border border4;
    TitledBorder titledBorder4;
    JPanel sensorPanel = new JPanel();
    Border border5;
    TitledBorder titledBorder5;
    JPanel buttonPanel = new JPanel();
    JButton okButton = new JButton();
    JButton cancelButton = new JButton();
    GridLayout gridLayout2 = new GridLayout();
    JPanel alarmPanel = new JPanel();
    Border border6;
    TitledBorder titledBorder6;
    JLabel jLabel1 = new JLabel();
    JTextField deviationText = new JTextField();
    JTextField setPointText = new JTextField();
    JLabel jLabel2 = new JLabel();
    JPanel jPanel8 = new JPanel();
    JRadioButton alarmLow = new JRadioButton();
    JRadioButton alarmHigh = new JRadioButton();
    JRadioButton alarmDeviation = new JRadioButton();
    JRadioButton alarmDisable = new JRadioButton();
    GridLayout gridLayout4 = new GridLayout();
    FlowLayout flowLayout3 = new FlowLayout();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JRadioButton noAlarmSelected = new JRadioButton();
    ButtonGroup alarmButtonGroup = new ButtonGroup();
    ButtonGroup sensorButtonGroup = new ButtonGroup();
    JList tempInputList = new JList();
    JRadioButton sensorNoneRadio = new JRadioButton();
    JRadioButton sensorAirRadio = new JRadioButton();
    JRadioButton sensorMaterialRadio = new JRadioButton();
    JRadioButton noSensorSelected = new JRadioButton();

    public TempCfg(Frame frame, String string, boolean bl, Object[] objectArray) {
        super(frame, string, bl);
        TrackerPad.formatter.applyPattern(TrackerPad.res.getString("Input_X_Template"));
        Object[] objectArray2 = new Object[1];
        String[] stringArray = new String[8];
        for (int i = 0; i < 8; ++i) {
            objectArray2[0] = new Integer(i + 1);
            stringArray[i] = new String(TrackerPad.formatter.format(objectArray2));
        }
        try {
            this.jbInit();
            this.pack();
            this.setLocationRelativeTo(frame);
            this.workingData = objectArray;
            this.tempInputList.setListData(stringArray);
            this.tempInputList.updateUI();
            this.tempInputList.setSelectedIndex(0);
            this.tempInputList.ensureIndexIsVisible(0);
            ((Component)this).setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.border1 = BorderFactory.createEtchedBorder(Color.white, new Color(134, 134, 134));
        this.border2 = BorderFactory.createEmptyBorder();
        this.border3 = BorderFactory.createLineBorder(SystemColor.controlText, 1);
        this.border4 = BorderFactory.createEtchedBorder(Color.white, new Color(134, 134, 134));
        this.border5 = BorderFactory.createEtchedBorder(Color.white, new Color(134, 134, 134));
        this.border6 = BorderFactory.createEtchedBorder(Color.white, new Color(134, 134, 134));
        this.titledBorder1 = new TitledBorder(this.border1, TrackerPad.res.getString("Temperature_Input"));
        this.titledBorder2 = new TitledBorder(this.border2, TrackerPad.res.getString("Usage"));
        this.titledBorder3 = new TitledBorder(this.border3, TrackerPad.res.getString("Usage"));
        this.titledBorder4 = new TitledBorder(this.border4, TrackerPad.res.getString("Air_Config"));
        this.titledBorder5 = new TitledBorder(this.border5, TrackerPad.res.getString("Sensor_Config"));
        this.titledBorder6 = new TitledBorder(this.border6, TrackerPad.res.getString("Alarm_Config"));
        this.okButton.setText(TrackerPad.res.getString("OK"));
        this.cancelButton.setText(TrackerPad.res.getString("Cancel"));
        this.jLabel1.setText(TrackerPad.res.getString("Set_Point"));
        this.deviationText.setText(TrackerPad.form.format(5.0));
        this.setPointText.setText(TrackerPad.form.format(20.0));
        this.jLabel2.setText(TrackerPad.res.getString("Deviation"));
        this.alarmLow.setText(TrackerPad.res.getString("Low"));
        this.alarmHigh.setText(TrackerPad.res.getString("High"));
        this.alarmDeviation.setText(TrackerPad.res.getString("Deviation"));
        this.alarmDisable.setText(TrackerPad.res.getString("Disable"));
        this.noAlarmSelected.setText(TrackerPad.res.getString("No_Selection"));
        this.noSensorSelected.setText(TrackerPad.res.getString("No_Selection"));
        this.sensorNoneRadio.setText(TrackerPad.res.getString("None"));
        this.sensorAirRadio.setText(TrackerPad.res.getString("Air"));
        this.sensorMaterialRadio.setText(TrackerPad.res.getString("Material"));
        this.panel1.setLayout(this.gridBagLayout1);
        this.jScrollPane1.setBorder(this.titledBorder1);
        this.hardwarePanel.setLayout(this.gridLayout3);
        this.gridLayout3.setColumns(2);
        this.sensorPanel.setBorder(this.titledBorder5);
        this.sensorPanel.setLayout(this.gridLayout2);
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TempCfg.this.okButton_actionPerformed(actionEvent);
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TempCfg.this.cancelButton_actionPerformed(actionEvent);
            }
        });
        this.gridLayout2.setColumns(1);
        this.gridLayout2.setRows(3);
        this.alarmPanel.setBorder(this.titledBorder6);
        this.alarmPanel.setLayout(this.flowLayout3);
        this.deviationText.setEnabled(false);
        this.deviationText.setMinimumSize(new Dimension(21, 21));
        this.deviationText.setPreferredSize(new Dimension(21, 21));
        this.setPointText.setEnabled(false);
        this.setPointText.setMinimumSize(new Dimension(28, 21));
        this.setPointText.setPreferredSize(new Dimension(28, 21));
        this.alarmLow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TempCfg.this.alarmLow_actionPerformed(actionEvent);
            }
        });
        this.alarmHigh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TempCfg.this.alarmHigh_actionPerformed(actionEvent);
            }
        });
        this.alarmDeviation.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TempCfg.this.alarmDeviation_actionPerformed(actionEvent);
            }
        });
        this.alarmDisable.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TempCfg.this.alarmDisable_actionPerformed(actionEvent);
            }
        });
        this.jPanel8.setLayout(this.gridLayout4);
        this.gridLayout4.setColumns(1);
        this.gridLayout4.setRows(4);
        this.flowLayout3.setAlignment(0);
        this.noAlarmSelected.setEnabled(false);
        this.noAlarmSelected.setVisible(false);
        this.noSensorSelected.setEnabled(false);
        this.noSensorSelected.setVisible(false);
        this.sensorNoneRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TempCfg.this.sensorNoneRadio_actionPerformed(actionEvent);
            }
        });
        this.sensorAirRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TempCfg.this.sensorAirRadio_actionPerformed(actionEvent);
            }
        });
        this.sensorMaterialRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TempCfg.this.sensorMaterialRadio_actionPerformed(actionEvent);
            }
        });
        this.getContentPane().add(this.panel1);
        this.panel1.add((Component)this.hardwarePanel, new GridBagConstraints(0, 0, 1, 14, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.hardwarePanel.add((Component)this.jScrollPane1, null);
        this.jScrollPane1.getViewport().add((Component)this.tempInputList, null);
        this.panel1.add((Component)this.sensorPanel, new GridBagConstraints(1, 0, 3, 3, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.sensorPanel.add((Component)this.sensorNoneRadio, null);
        this.sensorPanel.add((Component)this.sensorAirRadio, null);
        this.sensorPanel.add((Component)this.sensorMaterialRadio, null);
        this.panel1.add((Component)this.alarmPanel, new GridBagConstraints(1, 7, 3, 5, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.alarmPanel.add((Component)this.jPanel8, null);
        this.jPanel8.add((Component)this.alarmDisable, null);
        this.jPanel8.add((Component)this.alarmDeviation, null);
        this.jPanel8.add((Component)this.alarmHigh, null);
        this.jPanel8.add((Component)this.alarmLow, null);
        this.alarmPanel.add((Component)this.jLabel1, null);
        this.alarmPanel.add((Component)this.setPointText, null);
        this.alarmPanel.add((Component)this.jLabel2, null);
        this.alarmPanel.add((Component)this.deviationText, null);
        this.panel1.add((Component)this.buttonPanel, new GridBagConstraints(1, 12, 3, 2, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.buttonPanel.add((Component)this.okButton, null);
        this.buttonPanel.add((Component)this.cancelButton, null);
        this.tempInputList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                TempCfg.this.tempInputList_valueChanged(listSelectionEvent);
            }
        });
        this.alarmButtonGroup.add(this.alarmDisable);
        this.alarmButtonGroup.add(this.alarmDeviation);
        this.alarmButtonGroup.add(this.alarmHigh);
        this.alarmButtonGroup.add(this.alarmLow);
        this.alarmButtonGroup.add(this.noAlarmSelected);
        this.sensorButtonGroup.add(this.sensorNoneRadio);
        this.sensorButtonGroup.add(this.sensorAirRadio);
        this.sensorButtonGroup.add(this.sensorMaterialRadio);
        this.sensorButtonGroup.add(this.noSensorSelected);
    }

    private void enableAlarmEntryFromButtons() {
        this.deviationText.setEnabled(this.alarmDeviation.isSelected());
        this.setPointText.setEnabled(!this.noAlarmSelected.isSelected() && !this.alarmDisable.isSelected());
    }

    private void updateSensorDisplay(int[] nArray) {
        int[] nArray2 = new int[]{0, 0, 0};
        boolean bl = false;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i] * 2;
            ExtTempType extTempType = (ExtTempType)this.workingData[n2];
            if (extTempType instanceof NullExtTemp) {
                nArray2[0] = nArray2[0] + 1;
            }
            if (extTempType instanceof AirExtTemp) {
                nArray2[1] = nArray2[1] + 1;
            }
            if (!(extTempType instanceof MaterialExtTemp)) continue;
            nArray2[2] = nArray2[2] + 1;
        }
        if (n == nArray2[0]) {
            this.sensorNoneRadio.setSelected(true);
            bl = true;
        }
        if (n == nArray2[1]) {
            this.sensorAirRadio.setSelected(true);
            bl = true;
        }
        if (n == nArray2[2]) {
            this.sensorMaterialRadio.setSelected(true);
            bl = true;
        }
        if (!bl) {
            this.noSensorSelected.setSelected(true);
        }
        this.enableAlarmEntryFromButtons();
    }

    private void updateAlarmDisplay(int[] nArray) {
        int[] nArray2 = new int[]{0, 0, 0, 0};
        boolean bl = false;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i] * 2 + 1;
            AlarmType alarmType = (AlarmType)this.workingData[n2];
            if (alarmType instanceof DeviationAlarm) {
                nArray2[1] = nArray2[1] + 1;
                continue;
            }
            if (alarmType instanceof HighAlarm) {
                nArray2[2] = nArray2[2] + 1;
                continue;
            }
            if (alarmType instanceof LowAlarm) {
                nArray2[3] = nArray2[3] + 1;
                continue;
            }
            if (!(alarmType instanceof NullAlarm)) continue;
            nArray2[0] = nArray2[0] + 1;
        }
        if (n == nArray2[0]) {
            this.alarmDisable.setSelected(true);
            bl = true;
        }
        if (n == nArray2[1]) {
            this.alarmDeviation.setSelected(true);
            bl = true;
        }
        if (n == nArray2[2]) {
            this.alarmHigh.setSelected(true);
            bl = true;
        }
        if (n == nArray2[3]) {
            this.alarmLow.setSelected(true);
            bl = true;
        }
        if (!bl) {
            this.noAlarmSelected.setSelected(true);
        }
        this.enableAlarmEntryFromButtons();
    }

    private void updateDisplay() {
        int[] nArray = this.tempInputList.getSelectedIndices();
        int n = nArray.length;
        if (n > 0) {
            this.sensorNoneRadio.setEnabled(true);
            this.sensorAirRadio.setEnabled(true);
            this.sensorMaterialRadio.setEnabled(true);
            this.alarmDisable.setEnabled(true);
            this.alarmDeviation.setEnabled(true);
            this.alarmHigh.setEnabled(true);
            this.alarmLow.setEnabled(true);
            this.setPointText.setEnabled(true);
            this.deviationText.setEnabled(true);
            this.updateAlarmDisplay(nArray);
            this.updateSensorDisplay(nArray);
        } else {
            this.sensorNoneRadio.setEnabled(false);
            this.sensorAirRadio.setEnabled(false);
            this.sensorMaterialRadio.setEnabled(false);
            this.alarmDisable.setEnabled(false);
            this.alarmDeviation.setEnabled(false);
            this.alarmHigh.setEnabled(false);
            this.alarmLow.setEnabled(false);
            this.setPointText.setEnabled(false);
            this.deviationText.setEnabled(false);
        }
    }

    private void tempInputList_valueChanged(ListSelectionEvent listSelectionEvent) {
        this.updateDisplay();
    }

    private void updateData() {
        int[] nArray = this.tempInputList.getSelectedIndices();
        int n = nArray.length;
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                double d;
                Object object;
                int n2 = nArray[i] * 2;
                int n3 = n2 + 1;
                if (!this.noSensorSelected.isSelected()) {
                    Object object2 = this.sensorAirRadio.isSelected() ? new AirExtTemp() : (this.sensorMaterialRadio.isSelected() ? new MaterialExtTemp() : new NullExtTemp());
                    this.workingData[n2] = object2;
                }
                if (this.noAlarmSelected.isSelected()) continue;
                if (this.alarmDisable.isSelected()) {
                    this.workingData[n3] = new NullAlarm();
                }
                if (this.alarmDeviation.isSelected()) {
                    object = new String[2];
                    d = 0.0;
                    double d2 = 0.0;
                    object[0] = this.setPointText.getText().trim();
                    object[1] = this.deviationText.getText().trim();
                    try {
                        d = TrackerPad.form.parse(object[0]).doubleValue();
                        d2 = TrackerPad.form.parse(object[1]).doubleValue();
                    }
                    catch (ParseException parseException) {
                        JOptionPane.showMessageDialog(this, TrackerPad.res.getString("Enter_Number"), TrackerPad.res.getString("Error"), 0);
                        return;
                    }
                    this.workingData[n3] = new DeviationAlarm(d, d2);
                }
                if (this.alarmHigh.isSelected()) {
                    object = "";
                    d = 0.0;
                    object = this.setPointText.getText().trim();
                    try {
                        d = TrackerPad.form.parse((String)object).doubleValue();
                    }
                    catch (ParseException parseException) {
                        JOptionPane.showMessageDialog(this, TrackerPad.res.getString("Enter_Number"), TrackerPad.res.getString("Error"), 0);
                        return;
                    }
                    this.workingData[n3] = new HighAlarm(d);
                }
                if (!this.alarmLow.isSelected()) continue;
                object = "";
                d = 0.0;
                object = this.setPointText.getText().trim();
                try {
                    d = TrackerPad.form.parse((String)object).doubleValue();
                }
                catch (ParseException parseException) {
                    JOptionPane.showMessageDialog(this, TrackerPad.res.getString("Enter_Number"), TrackerPad.res.getString("Error"), 0);
                    return;
                }
                this.workingData[n3] = new LowAlarm(d);
            }
        }
    }

    void alarmDisable_actionPerformed(ActionEvent actionEvent) {
        this.updateData();
        this.enableAlarmEntryFromButtons();
    }

    void alarmDeviation_actionPerformed(ActionEvent actionEvent) {
        this.updateData();
        this.enableAlarmEntryFromButtons();
    }

    void alarmHigh_actionPerformed(ActionEvent actionEvent) {
        this.updateData();
        this.enableAlarmEntryFromButtons();
    }

    void alarmLow_actionPerformed(ActionEvent actionEvent) {
        this.updateData();
        this.enableAlarmEntryFromButtons();
    }

    void sensorNoneRadio_actionPerformed(ActionEvent actionEvent) {
        this.updateData();
    }

    void sensorAirRadio_actionPerformed(ActionEvent actionEvent) {
        this.updateData();
    }

    void sensorMaterialRadio_actionPerformed(ActionEvent actionEvent) {
        this.updateData();
    }

    void cancelButton_actionPerformed(ActionEvent actionEvent) {
        this.workingData = null;
        this.dispose();
    }

    void okButton_actionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }

    public Object[] getData() {
        return this.workingData;
    }
}

