/*
 * Decompiled with CFR 0.152.
 */
package smx.tracker.apps4xxx.trackerpad;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.ParseException;
import java.util.TooManyListenersException;
import javax.swing.DefaultFocusManager;
import javax.swing.FocusManager;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import smx.tracker.TrackerException;
import smx.tracker.apps4xxx.trackerpad.TrackerPad;
import smx.tracker.apps4xxx.trackerpad.TrackerPadThread;
import smx.tracker.apps4xxx.utility.GlassComponent;
import smx.tracker.apps4xxx.utility.ThreadListener;
import smx.tracker.apps4xxx.utility.TrackerExceptionString;
import smx.utility.UnitsConversion;

public class SetDistance
extends JDialog {
    private TrackerPadThread padThread = null;
    private Object[] distance = null;
    private UnitsConversion lengthUnits = null;
    private setDistCmdComplete setDistListener = new setDistCmdComplete();
    private boolean okClicked = false;
    private String oldDistance = "";
    JPanel panel1 = new JPanel();
    JLabel jLabel1 = new JLabel();
    JTextField distReading = new JTextField();
    JLabel unit = new JLabel();
    JButton applyButton = new JButton();
    JButton cancelButton = new JButton();
    JButton OKButton = new JButton();
    JPanel jPanel1 = new JPanel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    GridBagLayout gridBagLayout2 = new GridBagLayout();

    private void restoreCursor() {
        GlassComponent.setWaitState(false, this);
    }

    public SetDistance(Frame frame, String string, TrackerPadThread trackerPadThread, Object[] objectArray, UnitsConversion unitsConversion, boolean bl) {
        super(frame, string, bl);
        this.padThread = trackerPadThread;
        this.distance = objectArray;
        this.lengthUnits = unitsConversion;
        this.setGlassPane(new GlassComponent());
        try {
            this.jbInit();
            this.pack();
            this.setLocationRelativeTo(frame);
            ((Component)this).setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public SetDistance() {
        this(null, "", null, null, null, false);
    }

    void jbInit() throws Exception {
        this.panel1.setLayout(this.gridBagLayout2);
        this.jLabel1.setText(TrackerPad.res.getString("Enter_Distance"));
        this.unit.setText(TrackerPad.res.getString("Meters"));
        this.OKButton.setText(TrackerPad.res.getString("OK"));
        this.cancelButton.setText(TrackerPad.res.getString("Cancel"));
        this.applyButton.setText(TrackerPad.res.getString("Apply"));
        FocusManager.setCurrentManager(new MyFocusManager(this));
        double d = (Double)this.distance[0] / (double)1000000;
        this.oldDistance = this.lengthUnits.convertToDisplayStr(d);
        this.distReading.setMaximumSize(new Dimension(4, 21));
        this.distReading.setText(this.oldDistance);
        this.distReading.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 9) {
                    SetDistance.this.distReading.requestFocus();
                    SetDistance.this.distReading.selectAll();
                } else if (Character.isDigit(keyEvent.getKeyChar())) {
                    SetDistance.this.applyButton.setEnabled(true);
                }
            }
        });
        this.unit.setMaximumSize(new Dimension(4, 21));
        this.unit.setMinimumSize(new Dimension(4, 21));
        this.unit.setPreferredSize(new Dimension(4, 21));
        this.unit.setText(this.lengthUnits.displayName());
        this.applyButton.setEnabled(false);
        this.applyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SetDistance.this.applyButton_actionPerformed(actionEvent);
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SetDistance.this.cancelButton_actionPerformed(actionEvent);
            }
        });
        this.panel1.setMinimumSize(new Dimension(328, 180));
        this.panel1.setPreferredSize(new Dimension(328, 180));
        this.OKButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SetDistance.this.OKButton_actionPerformed(actionEvent);
            }
        });
        this.jPanel1.setLayout(this.gridBagLayout1);
        this.getContentPane().add(this.panel1);
        this.panel1.add((Component)this.jLabel1, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(29, 24, 0, 54), 29, 5));
        this.panel1.add((Component)this.distReading, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(17, 84, 0, 0), 83, 0));
        this.panel1.add((Component)this.unit, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(17, 8, 0, 80), 71, 0));
        this.panel1.add((Component)this.jPanel1, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 10, 1, new Insets(27, 24, 28, 19), 0, 0));
        this.jPanel1.add((Component)this.applyButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 15, 7, 0), 16, 0));
        this.jPanel1.add((Component)this.OKButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 7, 7, 0), 28, 0));
        this.jPanel1.add((Component)this.cancelButton, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 7, 7, 25), 6, 0));
    }

    void applyButton_actionPerformed(ActionEvent actionEvent) {
        this.okClicked = false;
        this.saveDistance();
    }

    void cancelButton_actionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }

    void OKButton_actionPerformed(ActionEvent actionEvent) {
        this.okClicked = true;
        this.saveDistance();
    }

    private void saveDistance() {
        String string = this.distReading.getText().trim();
        Object[] objectArray = new Object[3];
        Double d = null;
        if (this.oldDistance.equals(string)) {
            if (this.okClicked) {
                this.dispose();
            }
            return;
        }
        try {
            char[] cArray = string.toCharArray();
            for (int i = 0; i < cArray.length; ++i) {
                if (!Character.isLetter(cArray[i])) continue;
                throw new ParseException("", i);
            }
            d = new Double(TrackerPad.form.parse(string).doubleValue());
        }
        catch (ParseException parseException) {
            JOptionPane.showMessageDialog(this, TrackerPad.res.getString("Enter_Number"), TrackerPad.res.getString("Error"), 0);
            return;
        }
        objectArray[0] = new Integer(27);
        objectArray[1] = new Integer(0);
        objectArray[2] = new Double(this.lengthUnits.convertFrom(d.doubleValue()));
        try {
            this.padThread.addThreadListener(this.setDistListener);
        }
        catch (TooManyListenersException tooManyListenersException) {
            JOptionPane.showMessageDialog(this, TrackerPad.res.getString("Too_Many_Listener"), TrackerPad.res.getString("Internal_Error"), 0);
            return;
        }
        GlassComponent.setWaitState(true, this);
        this.padThread.sendCommand(objectArray);
    }

    private class setDistCmdComplete
    implements ThreadListener,
    Runnable {
        private setDistCmdComplete() {
        }

        public void commandComplete() {
            SetDistance.this.padThread.removeThreadListener(this);
            SwingUtilities.invokeLater(this);
        }

        public void run() {
            Object[] objectArray = SetDistance.this.padThread.receiveResponse();
            if (objectArray[0] != null) {
                TrackerExceptionString.displayErrorToUser(null, (TrackerException)((Object)objectArray[0]), TrackerPad.res.getString("Error"), "");
            }
            if (SetDistance.this.okClicked) {
                SetDistance.this.dispose();
            }
            SetDistance.this.restoreCursor();
        }
    }

    private class MyFocusManager
    extends DefaultFocusManager {
        private MyFocusManager(SetDistance setDistance) {
        }

        public void processKeyEvent(Component component, KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 9) {
                return;
            }
            super.processKeyEvent(component, keyEvent);
        }
    }
}

