/*
 * Decompiled with CFR 0.152.
 */
package smx.tracker.apps4xxx.startupchecks;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TooManyListenersException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import smx.tracker.MeasureData;
import smx.tracker.Tracker;
import smx.tracker.TrackerApp;
import smx.tracker.TrackerException;
import smx.tracker.apps4xxx.startupchecks.StartupChecksFailure;
import smx.tracker.apps4xxx.startupchecks.StartupChecksThread;
import smx.tracker.apps4xxx.utility.ThreadListener;
import smx.tracker.apps4xxx.utility.TrackerExceptionString;
import smx.tracker.event.FactoryBkndMeasureDataEvent;
import smx.tracker.event.FactoryBkndMeasureDataListener;

public class StartupChecks
extends TrackerApp {
    private Icon badImage = null;
    private Icon goodImage = null;
    private Icon brightImage = null;
    private Icon darkImage = null;
    private Timer timer = null;
    private BkndMeasureData bkndListener = new BkndMeasureData();
    private MeasureData[] dataReceived = null;
    private ThreadCmdComplete threadComplete = new ThreadCmdComplete();
    private InitializeComplete initializeComplete = new InitializeComplete();
    private laserStatusComplete laserComplete = new laserStatusComplete();
    private shutterStatusComplete openShutterComplete = new shutterStatusComplete();
    private ShutDownCmdComplete shutDownComplete = new ShutDownCmdComplete();
    private darkLevelComplete PSDComplete = new darkLevelComplete();
    private StartupChecksThread checksThread = null;
    private PrepareComplete prepareComplete = new PrepareComplete();
    private StopBkndCmdComplete stopBkndListener = new StopBkndCmdComplete();
    private JLabel[] labels = new JLabel[4];
    private boolean blinking = true;
    private boolean appIsStable = false;
    private boolean exit = false;
    private boolean ignore = false;
    private boolean firstStartup = true;
    private boolean laserInProgress = false;
    private boolean motorInProgress = false;
    private boolean shutterInProgress = false;
    private boolean checkFailed = false;
    private boolean quitClicked = false;
    private boolean PSDChecked = false;
    private boolean startCounting = false;
    private long laserStatus = 0L;
    private long motorStatus = 0L;
    private long shutterStatus = 0L;
    private long beginTime = 0L;
    private int azEncoderStatus = 0;
    private int zeEncoderStatus = 0;
    private int laserError = 0;
    private int motorError = 0;
    private Object[] bkndStartFailed = new Object[1];
    private Object[] waitForShutDown = new Object[1];
    private Object[] waitForStopBknd = new Object[1];
    public static final ResourceBundle res = ResourceBundle.getBundle("smx.tracker.apps4xxx.startupchecks.StartupChecksBundle", Locale.getDefault());
    private static final int BLINKING_RATE = 100;
    private static final int OFF = 0;
    private static final int FAILURE = 1;
    private static final int INITIALIZE = 2;
    JPanel panel1 = new JPanel();
    JPanel jPanel2 = new JPanel();
    JPanel jPanel3 = new JPanel();
    JButton OK = new JButton();
    JButton cancel = new JButton();
    JLabel InterferometerIcon = new JLabel();
    JLabel InterferometerLabel = new JLabel();
    JLabel MotorIcon = new JLabel();
    JLabel MotorLabel = new JLabel();
    JTextField detailMessage = new JTextField();
    JPanel jPanel4 = new JPanel();
    JLabel ShutterLabel = new JLabel();
    JLabel ShutterIcon = new JLabel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    GridBagLayout gridBagLayout3 = new GridBagLayout();
    JLabel PSDLabel = new JLabel();
    JLabel PSDIcon = new JLabel();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    GridBagLayout gridBagLayout4 = new GridBagLayout();
    GridBagLayout gridBagLayout5 = new GridBagLayout();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateDisplay(MeasureData[] measureDataArray) {
        block63: {
            block62: {
                block64: {
                    this.laserStatus = (Long)measureDataArray[0].getDataElement(0);
                    this.motorStatus = (Long)measureDataArray[0].getDataElement(1);
                    this.shutterStatus = (Long)measureDataArray[0].getDataElement(2);
                    this.azEncoderStatus = (Integer)measureDataArray[0].getDataElement(3);
                    this.zeEncoderStatus = (Integer)measureDataArray[0].getDataElement(4);
                    if (!this.laserInProgress) {
                        this.laserInProgress = true;
                        if (this.laserStatus == (long)0 || this.laserStatus == (long)3) {
                            this.startCounting = false;
                            if (this.laserStatus == (long)0) {
                                this.laserError = 0;
                            } else if (this.laserStatus == (long)3) {
                                this.laserError = 1;
                            }
                            JLabel[] jLabelArray = this.labels;
                            synchronized (jLabelArray) {
                                if (this.labels[0] == null) {
                                    this.labels[0] = this.InterferometerIcon;
                                }
                            }
                            if (!this.motorInProgress && !this.shutterInProgress) {
                                this.showLaserError(res.getString("Turn_Laser_On_Failure"));
                                return;
                            }
                        } else if (this.laserStatus == (long)2) {
                            this.startCounting = false;
                            JLabel[] jLabelArray = this.labels;
                            synchronized (jLabelArray) {
                                if (this.labels[0] != null) {
                                    this.labels[0].setIcon(this.goodImage);
                                    this.labels[0] = null;
                                }
                            }
                            if (this.labels[1] == null && this.labels[2] == null && this.labels[3] == null) {
                                this.cleanUpBeforeExit();
                                return;
                            }
                        } else if (this.laserStatus == (long)1) {
                            if (this.labels[0] == null) {
                                this.labels[0] = this.InterferometerIcon;
                            }
                            if (!this.startCounting) {
                                this.startCounting = true;
                                this.beginTime = System.currentTimeMillis();
                            } else {
                                long l = System.currentTimeMillis();
                                if (l - this.beginTime > (long)1800000) {
                                    this.laserError = 1;
                                    if (!this.motorInProgress && !this.shutterInProgress) {
                                        this.showLaserError(res.getString("Laser_Unable_Lock"));
                                        return;
                                    }
                                }
                            }
                        }
                        this.laserInProgress = false;
                    }
                    if (!this.shutterInProgress) {
                        JLabel[] jLabelArray;
                        this.shutterInProgress = true;
                        if (this.shutterStatus == (long)0) {
                            jLabelArray = this.labels;
                            synchronized (jLabelArray) {
                                if (this.labels[2] == null) {
                                    this.labels[2] = this.ShutterIcon;
                                }
                            }
                            if (!this.laserInProgress && !this.motorInProgress) {
                                this.showShutterError(res.getString("Turn_Shutter_On_Failure"));
                                return;
                            }
                        } else {
                            jLabelArray = this.labels;
                            synchronized (jLabelArray) {
                                if (this.labels[2] != null) {
                                    this.labels[2].setIcon(this.goodImage);
                                    this.labels[2] = null;
                                }
                            }
                            if (this.labels[0] == null && this.labels[1] == null && this.labels[3] == null) {
                                this.cleanUpBeforeExit();
                                return;
                            }
                        }
                        this.shutterInProgress = false;
                    }
                    if (this.motorInProgress) break block63;
                    this.motorInProgress = true;
                    if (this.motorStatus != (long)0 && this.motorStatus != (long)2) break block64;
                    if (this.motorStatus == (long)0) {
                        this.motorError = 0;
                    }
                    if (this.motorStatus == (long)2) {
                        this.motorError = 2;
                    }
                    JLabel[] jLabelArray = this.labels;
                    synchronized (jLabelArray) {
                        if (this.labels[1] == null && !this.ignore) {
                            this.labels[1] = this.MotorIcon;
                        }
                    }
                    if (this.laserInProgress || this.shutterInProgress || this.ignore) break block62;
                    if (this.motorError == 0) {
                        this.showMotorError(res.getString("Turn_Motor_On_Failure"));
                        return;
                    }
                    if (this.motorError == 2) {
                        if (!this.firstStartup) {
                            this.showMotorError(res.getString("Turn_Motor_On_Failure"));
                            return;
                        }
                        if (this.laserStatus == (long)2) {
                            this.firstStartup = false;
                            if (this.azEncoderStatus != 0 || this.zeEncoderStatus != 0 || this.motorStatus == (long)2) {
                                JOptionPane.showMessageDialog((Component)((Object)this), res.getString("Away_From_Tracker_Reminder"), res.getString("Reminder"), 0);
                                this.initialize();
                                return;
                            }
                            break block62;
                        } else {
                            this.motorInProgress = false;
                        }
                    }
                    break block62;
                }
                if (this.motorStatus == (long)1) {
                    JLabel[] jLabelArray = this.labels;
                    synchronized (jLabelArray) {
                        if (this.labels[1] != null) {
                            this.labels[1].setIcon(this.goodImage);
                            this.labels[1] = null;
                        }
                    }
                    if (!this.PSDChecked) {
                        if (this.laserStatus == (long)2) {
                            this.runDarkLevel();
                            return;
                        }
                    } else {
                        JLabel[] jLabelArray2 = this.labels;
                        synchronized (jLabelArray2) {
                            if (this.labels[3] != null) {
                                this.labels[3].setIcon(this.goodImage);
                                this.labels[3] = null;
                            }
                        }
                    }
                    if (this.labels[0] == null && this.labels[2] == null && this.labels[3] == null) {
                        this.cleanUpBeforeExit();
                    }
                }
            }
            this.motorInProgress = false;
        }
    }

    public StartupChecks(String string, Tracker tracker, JFrame jFrame) {
        super(string, tracker, jFrame);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        ((Component)((Object)this)).setLocation(dimension.width / 6, dimension.height / 8);
        this.bkndStartFailed[0] = new Boolean(true);
        this.waitForShutDown[0] = new Boolean(true);
        this.waitForStopBknd[0] = new Boolean(true);
        try {
            this.jbInit();
            this.checksThread = new StartupChecksThread(this.trk, this.threadComplete);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.timer = new Timer(100, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (StartupChecks.this.quitClicked) {
                    StartupChecks.this.exitApplication();
                } else {
                    StartupChecks.this.onTimer();
                }
            }
        });
        this.timer.start();
    }

    public StartupChecks() {
        this("", null, null);
    }

    private void startFailed() {
        this.detailMessage.setText(res.getString("Start_Checks_Failure"));
        Object[] objectArray = this.bkndStartFailed;
        synchronized (objectArray) {
            this.bkndStartFailed[0] = new Boolean(false);
            this.bkndStartFailed.notifyAll();
        }
        JLabel[] jLabelArray = this.labels;
        synchronized (jLabelArray) {
            for (int i = 0; i < this.labels.length; ++i) {
                if (this.labels[i] == null) continue;
                this.labels[i].setIcon(this.badImage);
                this.labels[i] = null;
            }
        }
        JOptionPane.showMessageDialog(this.frame, res.getString("Start_Checks_Failure"), res.getString("Error"), 0);
    }

    void jbInit() throws Exception {
        this.panel1.setLayout(this.gridBagLayout4);
        this.jPanel3.setLayout(this.gridBagLayout3);
        this.OK.setMaximumSize(new Dimension(73, 27));
        this.OK.setMinimumSize(new Dimension(73, 27));
        this.OK.setPreferredSize(new Dimension(73, 27));
        this.OK.setText(res.getString("OK"));
        this.OK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StartupChecks.this.OK_actionPerformed(actionEvent);
            }
        });
        this.OK.setEnabled(false);
        this.cancel.setText(res.getString("Cancel"));
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StartupChecks.this.cancel_actionPerformed(actionEvent);
            }
        });
        ((Container)((Object)this)).setLayout(this.gridBagLayout5);
        this.jPanel2.setLayout(this.gridBagLayout2);
        this.InterferometerLabel.setText(res.getString("Interferometer_Stable"));
        this.MotorLabel.setText(res.getString("Motors_On"));
        this.goodImage = new ImageIcon(this.loadImage("go.gif"));
        this.badImage = new ImageIcon(this.loadImage("nogo.gif"));
        this.brightImage = new ImageIcon(this.loadImage("blink1.gif"));
        this.darkImage = new ImageIcon(this.loadImage("blink2.gif"));
        this.InterferometerIcon.setText(" ");
        this.MotorIcon.setText(" ");
        this.ShutterIcon.setText(" ");
        this.PSDIcon.setText(" ");
        this.InterferometerIcon.setIcon(this.darkImage);
        this.MotorIcon.setIcon(this.darkImage);
        this.ShutterIcon.setIcon(this.darkImage);
        this.PSDIcon.setIcon(this.darkImage);
        this.labels[0] = this.InterferometerIcon;
        this.labels[1] = this.MotorIcon;
        this.labels[2] = this.ShutterIcon;
        this.labels[3] = this.PSDIcon;
        this.jPanel4.setLayout(this.gridBagLayout1);
        this.detailMessage.setBackground(Color.lightGray);
        this.detailMessage.setEnabled(false);
        this.detailMessage.setFont(new Font("SansSerif", 0, 22));
        this.detailMessage.setDisabledTextColor(Color.black);
        this.detailMessage.setEditable(false);
        this.detailMessage.setText(res.getString("Starting"));
        this.detailMessage.setHorizontalAlignment(0);
        ((JComponent)((Object)this)).setMinimumSize(new Dimension(400, 250));
        ((JComponent)((Object)this)).setPreferredSize(new Dimension(400, 280));
        this.panel1.setMinimumSize(new Dimension(400, 250));
        this.panel1.setPreferredSize(new Dimension(400, 280));
        this.ShutterLabel.setText(res.getString("Shutter_Open"));
        this.PSDLabel.setText(res.getString("PSD"));
        ((Container)((Object)this)).add(this.panel1, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 0, 2), 0, 0));
        this.panel1.add((Component)this.jPanel4, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 1, 0, 1), 9, 10));
        this.jPanel4.add((Component)this.detailMessage, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(20, 40, 6, 40), 108, 36));
        this.panel1.add((Component)this.jPanel3, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 1, 3, 1), -2, 3));
        this.jPanel3.add((Component)this.cancel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(12, 71, 18, 89), 0, 0));
        this.jPanel3.add((Component)this.OK, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(12, 89, 18, 0), 0, 0));
        this.panel1.add((Component)this.jPanel2, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 14, 0, 1), 35, 4));
        this.jPanel2.add((Component)this.ShutterIcon, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 2, 2, 0), 0, 0));
        this.jPanel2.add((Component)this.InterferometerIcon, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.MotorLabel, new GridBagConstraints(3, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 0, 0, 1), 62, 22));
        this.jPanel2.add((Component)this.InterferometerLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 0, 0, 0), 66, 22));
        this.jPanel2.add((Component)this.ShutterLabel, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 3, 0), 141, 22));
        this.jPanel2.add((Component)this.PSDLabel, new GridBagConstraints(3, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 3, 1), 91, 22));
        this.jPanel2.add((Component)this.PSDIcon, new GridBagConstraints(2, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
        this.jPanel2.add((Component)this.MotorIcon, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 0, 0, 0), 0, 0));
    }

    void cancel_actionPerformed(ActionEvent actionEvent) {
        this.exitApplication();
    }

    void OK_actionPerformed(ActionEvent actionEvent) {
        this.exitApplication();
    }

    private void exitApplication() {
        this.exit = true;
        try {
            this.trk.stopApplication("StartupChecks");
        }
        catch (TrackerException trackerException) {
            // empty catch block
        }
    }

    private Image loadImage(String string) {
        string = "/smx/tracker/apps4xxx/utility/images/".concat(String.valueOf(String.valueOf(string)));
        Image image = Toolkit.getDefaultToolkit().getImage(((Object)((Object)this)).getClass().getResource(string));
        MediaTracker mediaTracker = new MediaTracker((Component)((Object)this));
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        if (image == null) {
            return null;
        }
        return image;
    }

    public void stop() {
        this.exit = true;
        this.timer.stop();
        this.timer = null;
        Object[] objectArray = this.bkndStartFailed;
        synchronized (objectArray) {
            if (((Boolean)this.bkndStartFailed[0]).booleanValue()) {
                try {
                    this.bkndStartFailed.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.checksThread.abortCmdInProgress();
        this.stopBkndMeasure();
        Object[] objectArray2 = this.waitForStopBknd;
        synchronized (objectArray2) {
            if (((Boolean)this.waitForStopBknd[0]).booleanValue()) {
                try {
                    this.waitForStopBknd.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.shutDownThread();
        Object[] objectArray3 = this.waitForShutDown;
        synchronized (objectArray3) {
            if (((Boolean)this.waitForShutDown[0]).booleanValue()) {
                try {
                    this.waitForShutDown.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.checksThread = null;
        super.stop();
    }

    private void onTimer() {
        if (this.blinking) {
            JLabel[] jLabelArray = this.labels;
            synchronized (jLabelArray) {
                for (int i = 0; i < this.labels.length; ++i) {
                    if (this.labels[i] == null) continue;
                    this.labels[i].setIcon(this.brightImage);
                }
            }
            this.blinking = false;
        } else {
            JLabel[] jLabelArray = this.labels;
            synchronized (jLabelArray) {
                for (int i = 0; i < this.labels.length; ++i) {
                    if (this.labels[i] == null) continue;
                    this.labels[i].setIcon(this.darkImage);
                }
            }
            this.blinking = true;
        }
    }

    private synchronized void signalAppStable() {
        if (!this.appIsStable) {
            this.appIsStable = true;
            ((Object)((Object)this)).notifyAll();
        }
    }

    public synchronized void waitUntilStable() {
        try {
            while (!this.appIsStable) {
                ((Object)((Object)this)).wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void prepareForBknd() {
        if (this.checksThread == null) {
            return;
        }
        try {
            this.checksThread.addThreadListener(this.prepareComplete);
        }
        catch (TooManyListenersException tooManyListenersException) {
            JOptionPane.showMessageDialog(null, res.getString("Too_Many_Listeners"), res.getString("Internal_Error"), 0);
            return;
        }
        Object[] objectArray = new Object[]{new Integer(5), this.bkndListener};
        this.checksThread.sendCommand(objectArray);
    }

    private void stopBkndMeasure() {
        if (this.checksThread == null) {
            return;
        }
        try {
            this.checksThread.addThreadListener(this.stopBkndListener);
        }
        catch (TooManyListenersException tooManyListenersException) {
            JOptionPane.showMessageDialog(null, res.getString("Too_Many_Listeners"), res.getString("Internal_Error"), 0);
            return;
        }
        Object[] objectArray = new Object[]{new Integer(1), this.bkndListener};
        this.checksThread.sendCommand(objectArray);
    }

    private void motorOn() {
        if (this.checksThread == null) {
            return;
        }
        Object[] objectArray = new Object[]{new Integer(2)};
        this.checksThread.sendCommand(objectArray);
        Object[] objectArray2 = this.checksThread.receiveResponse();
        if (objectArray2[0] != null && !this.exit) {
            this.showMotorError(res.getString("Turn_Motor_On_Failure"));
        } else {
            this.motorInProgress = false;
        }
    }

    private void sendHome() {
        if (this.checksThread == null) {
            return;
        }
        Object[] objectArray = new Object[]{new Integer(6)};
        this.checksThread.sendCommand(objectArray);
        Object[] objectArray2 = this.checksThread.receiveResponse();
        if (objectArray2[0] != null) {
            TrackerExceptionString.displayErrorToUser(this.frame, (TrackerException)((Object)objectArray2[0]), res.getString("Error"), "");
        }
    }

    private void cleanUpBeforeExit() {
        this.exit = true;
        if (this.checkFailed) {
            this.detailMessage.setBackground(Color.red);
            this.detailMessage.setText(res.getString("Startup_Check_Failed"));
        } else {
            this.detailMessage.setBackground(Color.green);
            this.detailMessage.setText(res.getString("Startup_Complete"));
            this.sendHome();
        }
        this.OK.setEnabled(true);
        this.cancel.setEnabled(false);
    }

    private void changeLaserState(boolean bl) {
        if (this.checksThread == null) {
            return;
        }
        try {
            this.checksThread.addThreadListener(this.laserComplete);
        }
        catch (TooManyListenersException tooManyListenersException) {
            JOptionPane.showMessageDialog(null, res.getString("Too_Many_Listeners"), res.getString("Internal_Error"), 0);
            return;
        }
        Object[] objectArray = new Object[]{new Integer(3), new Boolean(bl)};
        this.checksThread.sendCommand(objectArray);
    }

    private void shutDownThread() {
        if (this.checksThread == null) {
            return;
        }
        try {
            this.checksThread.addThreadListener(this.shutDownComplete);
        }
        catch (TooManyListenersException tooManyListenersException) {
            JOptionPane.showMessageDialog(null, res.getString("Too_Many_Listeners"), res.getString("Internal_Error"), 0);
            return;
        }
        Object[] objectArray = new Object[]{new Integer(7), this.bkndListener};
        this.checksThread.sendCommand(objectArray);
    }

    private void initialize() {
        if (this.checksThread == null) {
            return;
        }
        try {
            this.checksThread.addThreadListener(this.initializeComplete);
        }
        catch (TooManyListenersException tooManyListenersException) {
            JOptionPane.showMessageDialog(null, res.getString("Too_Many_Listeners"), res.getString("Internal_Error"), 0);
            return;
        }
        Object[] objectArray = new Object[]{new Integer(4)};
        this.checksThread.sendCommand(objectArray);
    }

    private void openShutter() {
        if (this.checksThread == null) {
            return;
        }
        try {
            this.checksThread.addThreadListener(this.openShutterComplete);
        }
        catch (TooManyListenersException tooManyListenersException) {
            JOptionPane.showMessageDialog(null, res.getString("Too_Many_Listeners"), res.getString("Internal_Error"), 0);
            return;
        }
        Object[] objectArray = new Object[]{new Integer(8)};
        this.checksThread.sendCommand(objectArray);
    }

    private void showLaserError(String string) {
        StartupChecksFailure startupChecksFailure = new StartupChecksFailure((Frame)this.frame, string, true, true);
        if (startupChecksFailure.keyClicked() == 0) {
            if (this.laserError == 0) {
                this.changeLaserState(false);
            } else if (this.laserError == 1) {
                this.changeLaserState(true);
            }
        } else if (startupChecksFailure.keyClicked() == 1) {
            this.quitClicked = true;
        }
    }

    private void showShutterError(String string) {
        StartupChecksFailure startupChecksFailure = new StartupChecksFailure((Frame)this.frame, string, true, true);
        if (startupChecksFailure.keyClicked() == 0) {
            this.openShutter();
        } else if (startupChecksFailure.keyClicked() == 1) {
            this.quitClicked = true;
        }
    }

    private void showMotorError(String string) {
        StartupChecksFailure startupChecksFailure = new StartupChecksFailure((Frame)this.frame, string, false, true);
        if (startupChecksFailure.keyClicked() == 0) {
            if (this.motorError == 0) {
                this.motorOn();
            } else if (this.motorError == 2) {
                if (this.laserStatus == (long)2) {
                    if (this.azEncoderStatus != 0 || this.zeEncoderStatus != 0 || this.motorStatus == (long)2) {
                        JOptionPane.showMessageDialog((Component)((Object)this), res.getString("Away_From_Tracker_Reminder"), res.getString("Reminder"), 0);
                        this.initialize();
                    }
                } else {
                    this.motorInProgress = false;
                }
            }
        } else if (startupChecksFailure.keyClicked() == 1) {
            this.quitClicked = true;
        } else if (startupChecksFailure.keyClicked() == 2) {
            this.ignore = true;
            this.checkFailed = true;
            this.PSDChecked = true;
            this.motorInProgress = false;
            JLabel[] jLabelArray = this.labels;
            synchronized (jLabelArray) {
                if (this.labels[1] != null) {
                    this.labels[1].setIcon(this.badImage);
                    this.labels[1] = null;
                }
                if (this.labels[3] != null) {
                    this.labels[3].setIcon(this.badImage);
                    this.labels[3] = null;
                }
            }
        }
    }

    private MeasureData[] getAvailableData(FactoryBkndMeasureDataEvent factoryBkndMeasureDataEvent) throws TrackerException {
        return this.trk.readFactoryBkndMeasureData(factoryBkndMeasureDataEvent.getNumMeasurements());
    }

    private void runDarkLevel() {
        if (this.checksThread == null) {
            return;
        }
        try {
            this.checksThread.addThreadListener(this.PSDComplete);
        }
        catch (TooManyListenersException tooManyListenersException) {
            JOptionPane.showMessageDialog(null, res.getString("Too_Many_Listeners"), res.getString("Internal_Error"), 0);
            return;
        }
        Object[] objectArray = new Object[]{new Integer(9)};
        this.checksThread.sendCommand(objectArray);
    }

    static {
        BLINKING_RATE = 100;
        OFF = 0;
        FAILURE = 1;
        INITIALIZE = 2;
    }

    private class BkndMeasureData
    implements FactoryBkndMeasureDataListener,
    Runnable {
        MeasureData[] data = null;

        private BkndMeasureData() {
        }

        public void dataAvailable(FactoryBkndMeasureDataEvent factoryBkndMeasureDataEvent) {
            MeasureData[] measureDataArray = null;
            try {
                if (!StartupChecks.this.exit) {
                    measureDataArray = StartupChecks.this.getAvailableData(factoryBkndMeasureDataEvent);
                }
                if (this.data == null && measureDataArray != null) {
                    this.data = measureDataArray;
                    SwingUtilities.invokeLater(this);
                }
            }
            catch (TrackerException trackerException) {
                JOptionPane.showMessageDialog(StartupChecks.this.frame, res.getString("Data_Reading_Error"), res.getString("Error"), 0);
            }
        }

        public void run() {
            try {
                StartupChecks.this.updateDisplay(this.data);
                Object var2_1 = null;
                this.data = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.data = null;
                throw throwable;
            }
        }
    }

    private class shutterStatusComplete
    implements ThreadListener {
        private shutterStatusComplete() {
        }

        public void commandComplete() {
            if (StartupChecks.this.checksThread != null) {
                StartupChecks.this.checksThread.removeThreadListener(this);
                Object[] objectArray = StartupChecks.this.checksThread.receiveResponse();
                if (objectArray[0] != null && !StartupChecks.this.exit) {
                    StartupChecks.this.showShutterError(res.getString("Turn_Shutter_On_Failure"));
                } else {
                    StartupChecks.this.shutterInProgress = false;
                }
            }
        }
    }

    private class laserStatusComplete
    implements ThreadListener {
        private laserStatusComplete() {
        }

        public void commandComplete() {
            if (StartupChecks.this.checksThread != null) {
                StartupChecks.this.checksThread.removeThreadListener(this);
                Object[] objectArray = StartupChecks.this.checksThread.receiveResponse();
                if (objectArray[0] != null && !StartupChecks.this.exit) {
                    StartupChecks.this.showLaserError(res.getString("Turn_Laser_On_Failure"));
                } else {
                    StartupChecks.this.startCounting = false;
                    StartupChecks.this.laserInProgress = false;
                }
            }
        }
    }

    private class darkLevelComplete
    implements ThreadListener {
        private darkLevelComplete() {
        }

        public void commandComplete() {
            if (StartupChecks.this.checksThread != null) {
                StartupChecks.this.checksThread.removeThreadListener(this);
                Object[] objectArray = StartupChecks.this.checksThread.receiveResponse();
                if (objectArray[0] == null) {
                    StartupChecks.this.PSDChecked = true;
                }
                StartupChecks.this.motorInProgress = false;
            }
        }
    }

    private class InitializeComplete
    implements ThreadListener {
        private InitializeComplete() {
        }

        public void commandComplete() {
            if (StartupChecks.this.checksThread != null) {
                StartupChecks.this.checksThread.removeThreadListener(this);
                Object[] objectArray = StartupChecks.this.checksThread.receiveResponse();
                if (objectArray[0] != null && !StartupChecks.this.exit) {
                    StartupChecks.this.showMotorError(res.getString("Turn_Motor_On_Failure"));
                } else {
                    StartupChecks.this.motorInProgress = false;
                    StartupChecks.this.PSDChecked = true;
                }
            }
        }
    }

    private class PrepareComplete
    implements ThreadListener {
        private PrepareComplete() {
        }

        public void commandComplete() {
            if (StartupChecks.this.checksThread != null) {
                StartupChecks.this.checksThread.removeThreadListener(this);
                Object[] objectArray = StartupChecks.this.checksThread.receiveResponse();
                if (objectArray[0] != null) {
                    StartupChecks.this.startFailed();
                    return;
                }
                Object[] objectArray2 = StartupChecks.this.bkndStartFailed;
                synchronized (objectArray2) {
                    ((StartupChecks)StartupChecks.this).bkndStartFailed[0] = new Boolean(false);
                    StartupChecks.this.bkndStartFailed.notifyAll();
                }
            }
        }
    }

    private class ThreadCmdComplete
    implements ThreadListener {
        private ThreadCmdComplete() {
        }

        public void commandComplete() {
            if (StartupChecks.this.checksThread != null) {
                StartupChecks.this.checksThread.removeThreadListener(this);
                Object[] objectArray = StartupChecks.this.checksThread.receiveResponse();
                if (objectArray[0] != null) {
                    StartupChecks.this.startFailed();
                    return;
                }
                StartupChecks.this.prepareForBknd();
                StartupChecks.this.signalAppStable();
            }
        }
    }

    private class StopBkndCmdComplete
    implements ThreadListener {
        private StopBkndCmdComplete() {
        }

        public void commandComplete() {
            if (StartupChecks.this.checksThread != null) {
                StartupChecks.this.checksThread.removeThreadListener(this);
                Object[] objectArray = StartupChecks.this.checksThread.receiveResponse();
                if (objectArray[0] != null) {
                    JOptionPane.showMessageDialog(null, res.getString("Stop_Checks_Failure"), res.getString("Error"), 0);
                }
                Object[] objectArray2 = StartupChecks.this.waitForStopBknd;
                synchronized (objectArray2) {
                    ((StartupChecks)StartupChecks.this).waitForStopBknd[0] = new Boolean(false);
                    StartupChecks.this.waitForStopBknd.notifyAll();
                }
            }
        }
    }

    private class ShutDownCmdComplete
    implements ThreadListener {
        private ShutDownCmdComplete() {
        }

        public void commandComplete() {
            Object[] objectArray = StartupChecks.this.waitForShutDown;
            synchronized (objectArray) {
                ((StartupChecks)StartupChecks.this).waitForShutDown[0] = new Boolean(false);
                StartupChecks.this.waitForShutDown.notifyAll();
            }
        }
    }
}

