/*
 * Decompiled with CFR 0.152.
 */
package smx.tracker.apps4xxx.operationalchecks;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import smx.tracker.MeasureData;
import smx.tracker.Tracker;
import smx.tracker.TrackerException;
import smx.tracker.apps4xxx.operationalchecks.OpChecksADMPane;
import smx.tracker.apps4xxx.operationalchecks.OpChecksBacksightsPane;
import smx.tracker.apps4xxx.operationalchecks.OpChecksPanel;
import smx.tracker.apps4xxx.operationalchecks.OpChecksRepeatabilityPane;
import smx.tracker.apps4xxx.operationalchecks.OpChecksSMRPane;
import smx.tracker.apps4xxx.operationalchecks.OpChecksThread;
import smx.tracker.apps4xxx.utility.ClosureMath;
import smx.tracker.apps4xxx.utility.TrackerApp4xxx;
import smx.tracker.apps4xxx.utility.TrackerExceptionString;
import smx.tracker.apps4xxx.utility.tools.P;
import smx.tracker.apps4xxx.utility.tools.XTool;
import smx.tracker.event.FactoryBkndMeasureDataEvent;
import smx.tracker.event.FactoryBkndMeasureDataListener;

public class OperationalChecks
extends TrackerApp4xxx
implements Serializable {
    String packagePath = new String("/smx/tracker/apps4xxx/operationalchecks/");
    JPanel panel1 = new JPanel();
    public static final ResourceBundle res = ResourceBundle.getBundle("smx.tracker.apps4xxx.operationalchecks.OpChecksRes", Locale.getDefault());
    OpChecksPanel jRepeatabilityPanel;
    OpChecksPanel jBacksightsPane;
    OpChecksPanel jADMPane;
    OpChecksPanel jSMRPane;
    OpChecksPanel[] panelGroup;
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    int oldTabIndex = 0;
    boolean bTestInProgress = false;
    FactoryBkndMeasureDataImplementer factoryBkndDataListener = new FactoryBkndMeasureDataImplementer();
    private JTabbedPane opChecksTabPane;
    private final int MAX_PANES = 4;
    boolean admCapable;
    boolean admEnabled;
    long targetType;
    long sightMode;
    ClosureMath closureMath;
    double azimuthAngle;
    double zenithAngle;
    double radialDistance;
    double radialDistanceUnCorrected;
    double averageSMRIntensity;
    double temperature;
    double pressure;
    double humidity;
    int temperatureStatus;
    int pressureStatus;
    int humidityStatus;
    double baselineIntensity;
    boolean baselineIntensitySet;
    double measurementTime;
    int overallStatus;
    int distanceStatus;
    public static OperationalChecks parentApp;
    public static OpChecksThread parentAppCommandThread;
    public static JFrame parentAppFrame;
    private boolean trackingOn = true;
    private boolean motorsOn = false;
    private boolean motorsFailed = true;
    private boolean quickBackSights = false;
    private Component component1;
    private Component component2;
    private JButton ctrlClose = new JButton();
    private boolean factoryBkndMeasurementInProgress;
    private ArrayList bkndDataList = new ArrayList(1000);

    private void initialiseGUI() {
        try {
            this.opChecksTabPane = new JTabbedPane();
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public OperationalChecks(String string, Tracker tracker, JFrame jFrame) {
        super(string, tracker, jFrame);
        parentAppFrame = jFrame;
        parentApp = this;
        this.commandThread = new OpChecksThread(this.trk, this.threadCreationComplete, this.trackerAppBusyListener, this.commandThreadExitListener, jFrame);
        parentAppCommandThread = (OpChecksThread)this.commandThread;
        this.jRepeatabilityPanel = new OpChecksRepeatabilityPane(res.getString("Repeatability"));
        this.jBacksightsPane = new OpChecksBacksightsPane(res.getString("Backsights"));
        this.jADMPane = new OpChecksADMPane("ADM");
        this.initialiseGUI();
        this.processParam(string);
    }

    protected Component getAppRootComponent() {
        Component component = null;
        for (int i = 0; component == null && i < 50; ++i) {
            component = SwingUtilities.getRoot(this.opChecksTabPane);
            XTool.putToSleep(Thread.currentThread(), 100);
        }
        return component;
    }

    public Tracker getInterface() {
        return this.trk;
    }

    private void jbInit() throws Exception {
        this.component1 = Box.createHorizontalStrut(8);
        this.component2 = Box.createHorizontalStrut(8);
        this.ctrlClose.setMaximumSize(new Dimension(35, 25));
        this.ctrlClose.setMinimumSize(new Dimension(35, 25));
        this.ctrlClose.setPreferredSize(new Dimension(35, 25));
        this.ctrlClose.setMargin(new Insets(2, 2, 2, 2));
        this.ctrlClose.setToolTipText(res.getString("Close_app"));
        this.ctrlClose.setMnemonic('C');
        this.ctrlClose.setText(res.getString("Close"));
        this.ctrlClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OperationalChecks.this.onClose(actionEvent);
            }
        });
        this.opChecksTabPane.setEnabled(false);
        ((Container)((Object)this)).setLayout(this.gridBagLayout1);
        this.opChecksTabPane.setDoubleBuffered(true);
        ((JComponent)((Object)this)).setMaximumSize(new Dimension(5000, 4000));
        ((JComponent)((Object)this)).setMinimumSize(new Dimension(550, 450));
        ((JComponent)((Object)this)).setPreferredSize(new Dimension(550, 450));
        ((Container)((Object)this)).add(this.opChecksTabPane, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.8, 10, 1, new Insets(8, 8, 2, 8), 0, 0));
        ((Container)((Object)this)).add(this.component1, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 0, 0));
        ((Container)((Object)this)).add(this.ctrlClose, new GridBagConstraints(1, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(1, 1, 1, 1), 0, 0));
        ((Container)((Object)this)).add(this.component2, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 0, 0));
    }

    MeasureData extractFactoryBkndDataFromTracker(int n) {
        MeasureData[] measureDataArray = null;
        try {
            measureDataArray = this.trk.readFactoryBkndMeasureData(n);
        }
        catch (TrackerException trackerException) {
            trackerException.printStackTrace();
            MeasureData measureData = null;
            return measureData;
        }
        if (measureDataArray == null) {
            return null;
        }
        return measureDataArray[0];
    }

    void startFactoryBkndMeasurementForTargetPos() {
        if (this.factoryBkndMeasurementInProgress) {
            return;
        }
        Object[] objectArray = new Object[]{new Integer(7), this.factoryBkndDataListener};
        this.doThreadTransaction(objectArray, "", null);
        this.factoryBkndMeasurementInProgress = true;
        P.rintln("\tStarting factory bknd measurements");
    }

    void stopFactoryBkndMeasurementForTargetPos() {
        if (!this.factoryBkndMeasurementInProgress) {
            return;
        }
        Object[] objectArray = new Object[]{new Integer(8)};
        this.doThreadTransaction(objectArray, "", null);
        this.factoryBkndMeasurementInProgress = false;
        P.rintln("\tStopping factory bknd measurements");
    }

    private void updateTargetPosition(MeasureData measureData, JPanel jPanel) {
        int n = 0;
        Object[] objectArray = null;
        try {
            objectArray = measureData.getData();
            this.measurementTime = measureData.time();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        int n2 = -1;
        int n3 = -1;
        this.azimuthAngle = Math.IEEEremainder((Double)objectArray[n++], 1296000.0);
        this.azimuthAngle = Math.toRadians(this.azimuthAngle / 3600.0);
        n2 = (Integer)objectArray[n++];
        this.zenithAngle = Math.IEEEremainder((Double)objectArray[n++], 1296000.0);
        this.zenithAngle = Math.toRadians(this.zenithAngle / 3600.0);
        n3 = (Integer)objectArray[n++];
        this.radialDistance = (Double)objectArray[n++] / (double)1000000;
        this.distanceStatus = (Integer)objectArray[n++];
        this.radialDistanceUnCorrected = (Double)objectArray[n++] / (double)1000000;
        int n4 = n2 | n3 | this.distanceStatus;
        this.overallStatus = (n4 & 2) != 0 ? 2 : ((n4 & 4) != 0 ? 1 : 0);
        this.targetType = (Long)objectArray[n++];
        this.sightMode = (Long)objectArray[n++];
        double d = (Double)objectArray[n++];
        double d2 = (Double)objectArray[n++];
        double d3 = (Double)objectArray[n++];
        double d4 = (Double)objectArray[n++];
        double d5 = d + d2 + d3 + d4;
        if (this.baselineIntensitySet) {
            this.averageSMRIntensity = (d5 /= 0.85) / this.baselineIntensity * 100.0;
            if (this.averageSMRIntensity >= 100.0) {
                this.averageSMRIntensity = 100.0;
            }
        } else {
            this.averageSMRIntensity = d5 / (double)2;
        }
        this.temperatureStatus = (Integer)objectArray[n++];
        this.temperature = (Double)objectArray[n++];
        this.pressureStatus = (Integer)objectArray[n++];
        this.pressure = (Double)objectArray[n++];
        this.humidityStatus = (Integer)objectArray[n++];
        this.humidity = (Double)objectArray[n++] * (double)100;
        this.panelGroup[this.opChecksTabPane.getSelectedIndex()].displayTargetPosition();
    }

    void setSpecialAttribToActivePane(int n) {
        this.opChecksTabPane.setForegroundAt(n, Color.black);
        this.opChecksTabPane.setForegroundAt(this.oldTabIndex, Color.white);
        this.opChecksTabPane.setIconAt(this.oldTabIndex, null);
        this.oldTabIndex = n;
    }

    void ok_actionPerformed(ActionEvent actionEvent) {
    }

    void cancel_actionPerformed(ActionEvent actionEvent) {
    }

    public void launchApp() {
        if (this.commandThread == null) {
            return;
        }
        Object[] objectArray = this.commandThread.receiveResponse();
        if (objectArray[0] != null && objectArray[0] instanceof TrackerException) {
            this.showFatalErrorAndCloseApp(TrackerExceptionString.getError((TrackerException)((Object)objectArray[0])));
            return;
        }
        Object[] objectArray2 = (Object[])objectArray[2];
        boolean bl = (Boolean)objectArray2[0];
        this.admCapable = (Boolean)objectArray2[1];
        this.admEnabled = (Boolean)objectArray2[2];
        this.baselineIntensity = (Double)objectArray2[3];
        this.baselineIntensitySet = (Boolean)objectArray2[4];
        this.closureMath = (ClosureMath)objectArray2[5];
        this.jSMRPane = new OpChecksSMRPane(res.getString("General_page"));
        ((OpChecksSMRPane)this.jSMRPane).setupOneTimeExternalTemperatureSensorData((Object[])objectArray2[6]);
        if (bl) {
            this.showFatalErrorAndCloseApp(res.getString("Factory_bknd_meaurements_in_progress"));
            return;
        }
        if (this.admCapable) {
            this.panelGroup = new OpChecksPanel[4];
            System.out.println("This is an ADM tracker");
        } else {
            this.panelGroup = new OpChecksPanel[3];
            System.out.println("This is a non-ADM tracker");
        }
        this.opChecksTabPane.removeAll();
        int n = 0;
        this.panelGroup[n++] = this.jSMRPane;
        this.panelGroup[n++] = this.jRepeatabilityPanel;
        this.panelGroup[n++] = this.jBacksightsPane;
        if (this.admCapable) {
            this.panelGroup[n++] = this.jADMPane;
        }
        for (int i = 0; i < this.panelGroup.length; ++i) {
            this.opChecksTabPane.add((Component)this.panelGroup[i], this.panelGroup[i].getTitle());
        }
        if (this.quickBackSights) {
            this.opChecksTabPane.setSelectedIndex(2);
        }
        this.startFactoryBkndMeasurementForTargetPos();
    }

    public void setBusy(boolean bl) {
        this.opChecksTabPane.setEnabled(!bl);
    }

    void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    public String toString() {
        return "Operational Checks";
    }

    private void processParam(String string) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "-", true);
            while (true) {
                String string2;
                if (!(string2 = stringTokenizer.nextToken()).equals("-")) {
                    continue;
                }
                while ((string2 = stringTokenizer.nextToken()).equals("-")) {
                }
                string2 = string2.trim();
                switch (string2.charAt(0)) {
                    case 'b': {
                        break;
                    }
                    case 'a': {
                        String string3 = string2.substring(1).trim();
                        if (!string3.equalsIgnoreCase("qbc")) break;
                        this.quickBackSights = true;
                    }
                }
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            return;
        }
    }

    public void setBusyStateToApp(boolean bl) {
        if (this.isBusy()) {
            P.rintln(String.valueOf(String.valueOf(new StringBuffer("\n\tIGNORING setBusyStateToApp() call with flag = ").append(bl).append("\n"))));
            return;
        }
        P.rintln(String.valueOf(String.valueOf(new StringBuffer("\n\tsetBusyStateToApp() called with flag = ").append(bl).append("\n"))));
        this.opChecksTabPane.setEnabled(!bl);
        this.panelGroup[this.opChecksTabPane.getSelectedIndex()].enableAllControls(!bl);
        this.ctrlClose.setEnabled(!bl);
    }

    private class FactoryBkndMeasureDataImplementer
    implements FactoryBkndMeasureDataListener,
    Runnable {
        private FactoryBkndMeasureDataImplementer() {
        }

        public void dataAvailable(FactoryBkndMeasureDataEvent factoryBkndMeasureDataEvent) {
            MeasureData measureData = OperationalChecks.this.extractFactoryBkndDataFromTracker(factoryBkndMeasureDataEvent.getNumMeasurements());
            if (measureData == null) {
                return;
            }
            OperationalChecks.this.bkndDataList.add(measureData);
            SwingUtilities.invokeLater(this);
        }

        public void run() {
            if (OperationalChecks.this.bkndDataList.isEmpty()) {
                return;
            }
            OperationalChecks.this.updateTargetPosition((MeasureData)OperationalChecks.this.bkndDataList.remove(0), OperationalChecks.this.panelGroup[OperationalChecks.this.opChecksTabPane.getSelectedIndex()]);
            OperationalChecks.this.bkndDataList.clear();
        }
    }
}

