/*
 * Decompiled with CFR 0.152.
 */
package smx.tracker.apps4xxx.operationalchecks;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import smx.tracker.apps4xxx.operationalchecks.OpChecksTableColumnData;
import smx.tracker.apps4xxx.operationalchecks.OpChecksTableDisplay;
import smx.tracker.apps4xxx.operationalchecks.OpChecksThread;
import smx.tracker.apps4xxx.operationalchecks.OperationalChecks;
import smx.tracker.apps4xxx.utility.ThreadListener;
import smx.tracker.apps4xxx.utility.tools.P;
import smx.tracker.apps4xxx.utility.tools.XTime;
import smx.tracker.apps4xxx.utility.tools.XTool;

public abstract class OpChecksPanel
extends JPanel {
    ResourceBundle res = OperationalChecks.res;
    final OpChecksTableColumnData referencePositionColumn = new OpChecksTableColumnData(this.res.getString("Reference_position"), 175, 2);
    final OpChecksTableColumnData dXColumn = new OpChecksTableColumnData(this.res.getString("dX"), 75, 4);
    final OpChecksTableColumnData dYColumn = new OpChecksTableColumnData(this.res.getString("dY"), 75, 4);
    final OpChecksTableColumnData dZColumn = new OpChecksTableColumnData(this.res.getString("dZ"), 75, 4);
    final OpChecksTableColumnData dRColumn = new OpChecksTableColumnData(this.res.getString("dR"), 75, 4);
    final OpChecksTableColumnData dTColumn = new OpChecksTableColumnData(this.res.getString("dT"), 75, 4);
    final OpChecksTableColumnData dPColumn = new OpChecksTableColumnData(this.res.getString("dP"), 75, 4);
    final OpChecksTableColumnData dateColumn = new OpChecksTableColumnData(this.res.getString("Date"), 75, 4);
    final OpChecksTableColumnData timeColumn = new OpChecksTableColumnData(this.res.getString("Time"), 75, 4);
    AncestorListenerImplementer ancestorListenerImplementer = new AncestorListenerImplementer();
    protected int intervalRate = 250;
    private String panelTitle;
    protected DecimalFormat displayFormat;
    String dataTokenizer = ";";
    ArrayList pointList = new ArrayList(100);
    int currentPtId = 1;
    String[][] strArrayPointData;
    OpChecksTableDisplay resultsPanel;
    protected OpChecksThread opChecksThread;
    protected OperationalChecks parentTabPane;
    private String resultsFileName;
    private String resultsOutputDir = ".";
    protected JButton ctrlClear = new JButton();
    protected JButton ctrlSave = new JButton();
    protected JButton ctrlSaveAs = new JButton();
    protected JButton ctrlHome = new JButton();
    protected Dimension oldDimension = new Dimension(0, 0);
    protected boolean fontCalculatedOnce = false;
    private HomeCmdListener homeCmdListener = new HomeCmdListener();
    protected static boolean beamBroken = false;
    private boolean homeCmdInProgress = false;
    protected final int MAX_UNIT_NAME_LENGTH = 4;
    protected boolean appendData = true;
    private boolean beamBrokeErrorDisplayedOnce;

    abstract void displayTargetPosition();

    protected abstract void enableAllControls(boolean var1);

    protected OpChecksPanel(String string) {
        this.panelTitle = string;
        this.displayFormat = new DecimalFormat();
        this.displayFormat.setMinimumFractionDigits(6);
        this.displayFormat.setMaximumFractionDigits(9);
        this.displayFormat.setGroupingSize(0);
        this.addAncestorListener(this.ancestorListenerImplementer);
    }

    void setTitle(String string) {
        this.panelTitle = string;
    }

    String getTitle() {
        return this.panelTitle;
    }

    protected void handleBeamBreak() {
        if (this.homeCmdInProgress) {
            P.rintln("Ignoring the beam break msg");
            return;
        }
        beamBroken = true;
        this.parentTabPane.stopFactoryBkndMeasurementForTargetPos();
        if (!this.beamBrokeErrorDisplayedOnce) {
            this.beamBrokeErrorDisplayedOnce = true;
            XTool.displayErrorToUser(this, "OperationalChecks", this.res.getString("Beam_broke_err_before_test_started"));
        }
        this.enableAllControls(false);
        this.ctrlHome.setEnabled(true);
    }

    String[][] constructStringArrayFromObjectArray(Object[] objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer((String)objectArray[0], this.dataTokenizer);
        int n = stringTokenizer.countTokens();
        String[][] stringArray = new String[objectArray.length][n];
        for (int i = 0; i < objectArray.length; ++i) {
            stringTokenizer = new StringTokenizer((String)objectArray[i], this.dataTokenizer);
            for (int j = 0; j < n; ++j) {
                stringArray[i][j] = stringTokenizer.nextToken();
            }
        }
        return stringArray;
    }

    void updatePointDataInTable() {
        this.strArrayPointData = this.constructStringArrayFromObjectArray(this.pointList.toArray());
        this.resultsPanel.updateTable(this.strArrayPointData);
    }

    void updateResults(String string) {
        this.pointList.add(string);
        this.updatePointDataInTable();
        ++this.currentPtId;
    }

    void clearResults() {
        this.pointList.clear();
        this.updatePointDataInTable();
        this.currentPtId = 0;
        this.ctrlClear.setEnabled(false);
        this.ctrlSave.setEnabled(false);
        this.ctrlSaveAs.setEnabled(false);
    }

    protected String getDataToBeSaved() {
        String string = this.resultsFileName.endsWith(this.res.getString("_csv")) ? this.resultsPanel.getTableData(",") : this.resultsPanel.getTableData();
        return string;
    }

    protected void onSave(ActionEvent actionEvent) {
        if (this.resultsFileName == null) {
            this.onSaveAs(actionEvent);
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(10000);
        stringBuffer.append(this.res.getString("Opchecks_performed"));
        stringBuffer.append(" ").append(XTime.getTime()).append(" ( ");
        stringBuffer.append(XTime.getDate()).append(" ) ");
        stringBuffer.append(XTool.lineSeparator());
        stringBuffer.append(this.getDataToBeSaved());
        XTool.saveResults(OperationalChecks.parentAppFrame, String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.resultsOutputDir))).append(File.separator).append(this.resultsFileName))), stringBuffer.toString(), this.appendData, this.res.getString("File_open_error"), this.res.getString("File_open_error_msg"));
    }

    protected String getFileFilters() {
        String string = null;
        if (this.resultsFileName != null && this.resultsFileName.endsWith(this.res.getString("_csv"))) {
            this.res.getString("Text_files");
            string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(",".concat(String.valueOf(String.valueOf(this.res.getString("_txt")))))));
            string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(";".concat(String.valueOf(String.valueOf(this.res.getString("CSV_files")))))));
            string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(",".concat(String.valueOf(String.valueOf(this.res.getString("_csv")))))));
        } else {
            string = this.res.getString("CSV_files");
            string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(",".concat(String.valueOf(String.valueOf(this.res.getString("_csv")))))));
            string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(";".concat(String.valueOf(String.valueOf(this.res.getString("Text_files")))))));
            string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(",".concat(String.valueOf(String.valueOf(this.res.getString("_txt")))))));
        }
        return string;
    }

    protected void onSaveAs(ActionEvent actionEvent) {
        String[] stringArray = XTool.openFileSaveAsChooser(OperationalChecks.parentAppFrame, this.res.getString("Save_As"), this.res.getString("Append_to_file"), this.appendData, this.resultsFileName, this.resultsOutputDir, this.getFileFilters(), this.res.getString("Invalid_file_error"), this.res.getString("Invalid_file_error_msg"));
        if (stringArray != null) {
            this.appendData = XTool.isDataAppended();
            if (stringArray[0] != null) {
                this.resultsOutputDir = stringArray[0];
            }
            if (stringArray[1] != null) {
                this.resultsFileName = stringArray[1];
                this.onSave(null);
            }
        }
    }

    void onHome(ActionEvent actionEvent) {
        this.parentTabPane.stopFactoryBkndMeasurementForTargetPos();
        Object[] objectArray = new Object[]{new Integer(1)};
        this.homeCmdInProgress = true;
        this.parentTabPane.doThreadTransaction(objectArray, "", this.homeCmdListener, true);
        this.homeCmdInProgress = false;
        Object[] objectArray2 = null;
        if (this.opChecksThread != null) {
            objectArray2 = this.opChecksThread.peekResponse();
        }
        if (objectArray2 != null && objectArray2[0] == null) {
            this.beamBrokeErrorDisplayedOnce = false;
            beamBroken = false;
            this.enableAllControls(true);
            this.parentTabPane.startFactoryBkndMeasurementForTargetPos();
        }
    }

    protected void onFocusGained() {
        if (this.oldDimension.getHeight() != 0.0 && this.oldDimension.getWidth() != 0.0) {
            this.oldDimension.setSize(50000, 50000);
            this.fontCalculatedOnce = false;
        }
        if (beamBroken) {
            this.parentTabPane.startFactoryBkndMeasurementForTargetPos();
        } else {
            this.enableAllControls(true);
        }
    }

    protected void onFocusLost() {
        this.beamBrokeErrorDisplayedOnce = false;
    }

    protected void initialize() {
        this.ctrlClear.setText(this.res.getString("Clear"));
        this.ctrlClear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OpChecksPanel.this.clearResults();
            }
        });
        this.ctrlSave.setText(this.res.getString("Save"));
        this.ctrlSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OpChecksPanel.this.onSave(actionEvent);
            }
        });
        this.ctrlSaveAs.setText(this.res.getString("Save_As"));
        this.ctrlSaveAs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OpChecksPanel.this.onSaveAs(actionEvent);
            }
        });
        this.ctrlClear.setEnabled(false);
        this.ctrlClear.setMnemonic('L');
        this.ctrlSave.setEnabled(false);
        this.ctrlSave.setMnemonic('S');
        this.ctrlSaveAs.setEnabled(false);
        this.ctrlSaveAs.setMnemonic('A');
    }

    private class AncestorListenerImplementer
    implements AncestorListener {
        private AncestorListenerImplementer() {
        }

        public void ancestorAdded(AncestorEvent ancestorEvent) {
            OpChecksPanel.this.onFocusGained();
        }

        public void ancestorRemoved(AncestorEvent ancestorEvent) {
            OpChecksPanel.this.onFocusLost();
        }

        public void ancestorMoved(AncestorEvent ancestorEvent) {
        }
    }

    private class HomeCmdListener
    implements ThreadListener {
        private HomeCmdListener() {
        }

        public void commandComplete() {
            if (OpChecksPanel.this.oldDimension.getHeight() != 0.0 && OpChecksPanel.this.oldDimension.getWidth() != 0.0) {
                OpChecksPanel.this.oldDimension.setSize(50000, 50000);
                OpChecksPanel.this.fontCalculatedOnce = false;
            }
        }
    }
}

