/*
 * Decompiled with CFR 0.152.
 */
package smx.tracker.apps4xxx.operationalchecks;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import smx.tracker.apps4xxx.operationalchecks.OpChecksPanel;
import smx.tracker.apps4xxx.operationalchecks.OpChecksTableColumnData;
import smx.tracker.apps4xxx.operationalchecks.OpChecksTableDisplay;
import smx.tracker.apps4xxx.operationalchecks.OperationalChecks;
import smx.tracker.apps4xxx.utility.ThreadListener;
import smx.tracker.apps4xxx.utility.XMath;
import smx.tracker.apps4xxx.utility.tools.XTime;
import smx.tracker.apps4xxx.utility.tools.XTool;

public class OpChecksBacksightsPane
extends OpChecksPanel {
    public final OpChecksTableColumnData[] columns;
    String resultHeading;
    double[] initialSightSpherData;
    double[] backSightSpherData;
    private DecimalFormat posForm;
    private DecimalFormat resultsFormat;
    StartStopTestCompleteListener startStopTestListener;
    GridLayout gridLayout2;
    JPanel jPanel1;
    JPanel jPanel2;
    Border border1;
    TitledBorder titledBorder2;
    Border border2;
    Border border3;
    GridLayout gridLayout1;
    JPanel jPanel3;
    JPanel jPanel4;
    GridBagLayout gridBagLayout1;
    GridBagLayout gridBagLayout2;
    JTextField ctrlAz;
    JTextField ctrlZe;
    JLabel jLabel1;
    JLabel jLabel2;
    JLabel jLabel3;
    JLabel jLabel4;
    JLabel jLabel1Units;
    JLabel jLabel2Units;
    JLabel jLabel3Units;
    JLabel jLabel4Units;
    JTextField ctrlInter;
    JTextField ctrlTotal;
    GridBagLayout gridBagLayout3;
    Border border4;
    TitledBorder titledBorder1;
    Border border5;
    JPanel jPanel6;
    GridLayout gridLayout3;
    JButton ctrlStartStop;
    private boolean btestInProgress;

    public OpChecksBacksightsPane(String string) {
        super(string);
        this.columns = new OpChecksTableColumnData[]{this.referencePositionColumn, this.dateColumn, this.timeColumn, new OpChecksTableColumnData(this.res.getString("3D"), 75, 4)};
        this.initialSightSpherData = new double[3];
        this.backSightSpherData = new double[3];
        this.gridLayout2 = new GridLayout();
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.gridLayout1 = new GridLayout();
        this.jPanel3 = new JPanel();
        this.jPanel4 = new JPanel();
        this.gridBagLayout1 = new GridBagLayout();
        this.gridBagLayout2 = new GridBagLayout();
        this.ctrlAz = new JTextField();
        this.ctrlZe = new JTextField();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel1Units = new JLabel();
        this.jLabel2Units = new JLabel();
        this.jLabel3Units = new JLabel();
        this.jLabel4Units = new JLabel();
        this.ctrlInter = new JTextField();
        this.ctrlTotal = new JTextField();
        this.gridBagLayout3 = new GridBagLayout();
        this.jPanel6 = new JPanel();
        this.gridLayout3 = new GridLayout();
        this.ctrlStartStop = new JButton();
        this.btestInProgress = false;
        this.parentTabPane = OperationalChecks.parentApp;
        this.opChecksThread = OperationalChecks.parentAppCommandThread;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        super.initialize();
        this.resultsPanel = new OpChecksTableDisplay(null, this.columns, null);
        this.border3 = BorderFactory.createCompoundBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(134, 134, 134)), this.res.getString("Position_Monitor")), BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.border1 = BorderFactory.createLineBorder(Color.white, 1);
        this.titledBorder2 = new TitledBorder(this.border1, this.res.getString("Tests_Detailed"));
        this.border2 = BorderFactory.createCompoundBorder(this.titledBorder2, BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.border4 = new EtchedBorder(0, Color.white, new Color(134, 134, 134));
        this.titledBorder1 = new TitledBorder(this.border4, this.res.getString("Tests"));
        this.border5 = BorderFactory.createCompoundBorder(this.titledBorder1, BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.setLayout(this.gridLayout2);
        this.jPanel1.setLayout(this.gridLayout1);
        this.jPanel1.setBorder(this.border3);
        this.jPanel1.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.jPanel1.setMinimumSize(new Dimension(200, 125));
        this.jPanel1.setPreferredSize(new Dimension(50, 50));
        this.jPanel2.setBorder(this.border2);
        this.jPanel2.setMinimumSize(new Dimension(200, 125));
        this.jPanel2.setPreferredSize(new Dimension(50, 50));
        this.jPanel2.setLayout(this.gridBagLayout3);
        this.gridLayout1.setColumns(2);
        this.gridLayout1.setHgap(25);
        this.jPanel3.setLayout(this.gridBagLayout1);
        this.jPanel4.setLayout(this.gridBagLayout2);
        this.ctrlAz.setBackground(Color.black);
        this.ctrlAz.setFont(new Font("SansSerif", 1, 30));
        this.ctrlAz.setForeground(Color.white);
        this.ctrlAz.setEditable(false);
        this.ctrlAz.setHorizontalAlignment(4);
        this.ctrlZe.setBackground(Color.black);
        this.ctrlZe.setFont(new Font("SansSerif", 1, 30));
        this.ctrlZe.setForeground(Color.white);
        this.ctrlZe.setEditable(false);
        this.ctrlZe.setHorizontalAlignment(4);
        this.jLabel1.setFont(new Font("Dialog", 1, 25));
        this.jLabel1.setText(this.res.getString("Az"));
        this.jLabel2.setText(this.res.getString("Ze"));
        this.jLabel3.setText(this.res.getString("Ra"));
        this.jLabel4.setText(this.res.getString("3D"));
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(this.parentTabPane.localAngularUnits.displayName());
        StringBuffer stringBuffer2 = new StringBuffer(100);
        stringBuffer2.append(this.parentTabPane.localLinearUnits.displayName());
        StringBuffer stringBuffer3 = new StringBuffer(100);
        if (stringBuffer.length() > 4) {
            stringBuffer3.append("(").append(stringBuffer.substring(0, 4)).append(")");
        } else {
            stringBuffer3.append("(").append(stringBuffer).append(")");
        }
        StringBuffer stringBuffer4 = new StringBuffer(100);
        if (stringBuffer2.length() > 4) {
            stringBuffer4.append("(").append(stringBuffer2.substring(0, 4)).append(")");
        } else {
            stringBuffer4.append("(").append(stringBuffer2).append(")");
        }
        this.jLabel1Units.setHorizontalTextPosition(0);
        this.jLabel1Units.setVerticalTextPosition(1);
        this.jLabel2Units.setHorizontalTextPosition(0);
        this.jLabel2Units.setVerticalTextPosition(1);
        this.jLabel3Units.setHorizontalTextPosition(0);
        this.jLabel3Units.setVerticalTextPosition(1);
        this.jLabel4Units.setHorizontalTextPosition(0);
        this.jLabel4Units.setVerticalTextPosition(1);
        this.jLabel1Units.setText(stringBuffer3.toString());
        this.jLabel2Units.setText(stringBuffer3.toString());
        this.jLabel3Units.setText(stringBuffer4.toString());
        this.jLabel4Units.setText(stringBuffer4.toString());
        this.jLabel2.setFont(new Font("Dialog", 1, 25));
        this.jLabel3.setFont(new Font("SansSerif", 1, 25));
        this.ctrlInter.setBackground(Color.black);
        this.ctrlInter.setFont(new Font("SansSerif", 1, 30));
        this.ctrlInter.setForeground(Color.white);
        this.ctrlInter.setEditable(false);
        this.ctrlInter.setHorizontalAlignment(4);
        this.jLabel4.setFont(new Font("SansSerif", 1, 25));
        this.ctrlTotal.setBackground(Color.black);
        this.ctrlTotal.setFont(new Font("SansSerif", 1, 30));
        this.ctrlTotal.setForeground(Color.white);
        this.ctrlTotal.setEditable(false);
        this.ctrlTotal.setHorizontalAlignment(4);
        this.setMaximumSize(new Dimension(5000, 4000));
        this.setMinimumSize(new Dimension(550, 425));
        this.setPreferredSize(new Dimension(550, 425));
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                OpChecksBacksightsPane.this.onComponentResized(componentEvent);
            }
        });
        this.jPanel6.setLayout(this.gridLayout3);
        this.gridLayout3.setColumns(1);
        this.gridLayout3.setRows(5);
        this.gridLayout3.setVgap(1);
        this.ctrlStartStop.setMnemonic('T');
        this.ctrlStartStop.setText(this.res.getString("Start_Test"));
        this.ctrlStartStop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OpChecksBacksightsPane.this.ctrlStartStop_actionPerformed(actionEvent);
            }
        });
        this.ctrlHome.setMnemonic('H');
        this.ctrlHome.setText(this.res.getString("Home"));
        this.ctrlHome.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OpChecksBacksightsPane.this.onHome(actionEvent);
            }
        });
        this.gridLayout2.setRows(2);
        this.add((Component)this.jPanel1, null);
        this.jPanel1.add((Component)this.jPanel3, null);
        this.jPanel3.add((Component)this.ctrlAz, new GridBagConstraints(1, 0, 1, 2, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 15, 15));
        this.jPanel3.add((Component)this.ctrlZe, new GridBagConstraints(1, 2, 1, 2, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 15, 15));
        this.jPanel3.add((Component)this.jLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 3), 5, 5));
        this.jPanel3.add((Component)this.jLabel1Units, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 2, 2, 3), 0, 0));
        this.jPanel3.add((Component)this.jLabel2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 3), 5, 5));
        this.jPanel3.add((Component)this.jLabel2Units, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 2, 2, 3), 0, 0));
        this.jPanel1.add((Component)this.jPanel4, null);
        this.jPanel4.add((Component)this.ctrlInter, new GridBagConstraints(1, 0, 1, 2, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 15, 15));
        this.jPanel4.add((Component)this.ctrlTotal, new GridBagConstraints(1, 2, 1, 2, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 15, 15));
        this.jPanel4.add((Component)this.jLabel3, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 3), 5, 5));
        this.jPanel4.add((Component)this.jLabel3Units, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 2, 2, 3), 0, 0));
        this.jPanel4.add((Component)this.jLabel4, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 3), 5, 5));
        this.jPanel4.add((Component)this.jLabel4Units, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 2, 2, 3), 0, 0));
        this.add((Component)this.jPanel2, null);
        this.jPanel2.add((Component)this.resultsPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 200, 100));
        this.jPanel2.add((Component)this.jPanel6, new GridBagConstraints(2, 0, 1, 1, 0.0, 1.0, 10, 3, new Insets(2, 5, 2, 2), 0, 25));
        this.jPanel6.add((Component)this.ctrlStartStop, null);
        this.jPanel6.add((Component)this.ctrlHome, null);
        this.jPanel6.add((Component)this.ctrlClear, null);
        this.jPanel6.add((Component)this.ctrlSave, null);
        this.jPanel6.add((Component)this.ctrlSaveAs, null);
    }

    private void onComponentResized(ComponentEvent componentEvent) {
        String string = this.ctrlAz.getText();
        String string2 = this.ctrlZe.getText();
        String string3 = this.ctrlInter.getText();
        Font font = this.ctrlInter.getFont();
        FontMetrics fontMetrics = ((Component)this.ctrlInter).getFontMetrics(font);
        int n = fontMetrics.stringWidth(string);
        int n2 = fontMetrics.stringWidth(string2);
        int n3 = fontMetrics.stringWidth(string3);
        int n4 = Math.max(n, n2);
        if ((n4 = Math.max(n4, n3)) == 0) {
            return;
        }
        Font font2 = null;
        font2 = n4 == n ? XTool.calculateMaxFontThatFits(this.ctrlAz, this.oldDimension) : (n4 == n2 ? XTool.calculateMaxFontThatFits(this.ctrlZe, this.oldDimension) : XTool.calculateMaxFontThatFits(this.ctrlInter, this.oldDimension));
        if (font2 == null) {
            return;
        }
        this.ctrlAz.setFont(font2);
        this.ctrlZe.setFont(font2);
        this.ctrlInter.setFont(font2);
        this.ctrlTotal.setFont(font2);
    }

    public void displayTargetPosition() {
        double[] dArray = new double[]{this.parentTabPane.radialDistance, this.parentTabPane.azimuthAngle, this.parentTabPane.zenithAngle};
        this.ctrlInter.setText(this.parentTabPane.localLinearUnits.convertToDisplayStr(dArray[0]));
        this.ctrlAz.setText(this.parentTabPane.localAngularUnits.convertToDisplayStr(dArray[1]));
        this.ctrlZe.setText(this.parentTabPane.localAngularUnits.convertToDisplayStr(dArray[2]));
        if (!this.fontCalculatedOnce) {
            this.onComponentResized(null);
            this.fontCalculatedOnce = true;
        }
        if (this.parentTabPane.overallStatus == 0) {
            this.ctrlAz.setForeground(Color.white);
            this.ctrlZe.setForeground(Color.white);
            this.ctrlInter.setForeground(Color.white);
        } else {
            this.ctrlAz.setForeground(Color.red);
            this.ctrlZe.setForeground(Color.red);
            this.ctrlInter.setForeground(Color.red);
            if (!this.btestInProgress) {
                super.handleBeamBreak();
            }
        }
    }

    void SetDeviationResults(double[] dArray) {
        dArray[4] = dArray[4] >= 0.0 ? dArray[4] - Math.PI : dArray[4] + Math.PI;
        dArray[5] = dArray[5] * (double)-1;
        double d = dArray[1] - dArray[4];
        double d2 = dArray[2] - dArray[5];
        double d3 = dArray[0] * Math.sqrt(d * d + d2 * d2 * Math.sin(dArray[2]) * Math.sin(dArray[2]));
        String string = this.parentTabPane.localLinearUnits.convertToDisplayStr(d3);
        this.ctrlTotal.setText(string);
        double[] dArray2 = new double[]{dArray[0], dArray[1], dArray[2]};
        XMath.pointSphereToCart(dArray2);
        String string2 = this.parentTabPane.localLinearUnits.convertToDisplayStr(dArray2[0]);
        String string3 = this.parentTabPane.localLinearUnits.convertToDisplayStr(dArray2[1]);
        String string4 = this.parentTabPane.localLinearUnits.convertToDisplayStr(dArray2[2]);
        StringBuffer stringBuffer = new StringBuffer(512);
        stringBuffer.append(string2).append("  ").append(string3).append("  ").append(string4).append(this.dataTokenizer);
        stringBuffer.append(XTime.getDate(dArray[6])).append(this.dataTokenizer);
        stringBuffer.append(XTime.getTime(dArray[6])).append(this.dataTokenizer);
        stringBuffer.append(string).append(this.dataTokenizer);
        this.updateResults(stringBuffer.toString());
    }

    void ctrlStartStop_actionPerformed(ActionEvent actionEvent) {
        this.btestInProgress = true;
        this.ctrlStartStop.setEnabled(false);
        this.ctrlHome.setEnabled(false);
        Object[] objectArray = new Object[]{new Integer(12)};
        if (this.startStopTestListener == null) {
            this.startStopTestListener = new StartStopTestCompleteListener();
        }
        this.parentTabPane.doThreadTransaction(objectArray, "", this.startStopTestListener);
    }

    protected void enableAllControls(boolean bl) {
        this.ctrlStartStop.setEnabled(bl);
        this.ctrlHome.setEnabled(bl);
    }

    private class StartStopTestCompleteListener
    implements ThreadListener,
    Runnable {
        private Object[] data;

        private StartStopTestCompleteListener() {
        }

        public void commandComplete() {
            this.data = OpChecksBacksightsPane.this.opChecksThread.peekResponse();
            SwingUtilities.invokeLater(this);
        }

        public void run() {
            if (this.data[0] == null && this.data[2] != null) {
                OpChecksBacksightsPane.this.SetDeviationResults((double[])this.data[2]);
            }
            OpChecksBacksightsPane.this.btestInProgress = false;
            OpChecksBacksightsPane.this.ctrlStartStop.setEnabled(true);
            OpChecksBacksightsPane.this.ctrlHome.setEnabled(true);
            if (OpChecksBacksightsPane.this.resultsPanel.isDataAvailable()) {
                OpChecksBacksightsPane.this.ctrlClear.setEnabled(true);
                OpChecksBacksightsPane.this.ctrlSave.setEnabled(true);
                OpChecksBacksightsPane.this.ctrlSaveAs.setEnabled(true);
            }
        }
    }
}

